"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMock = void 0;

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var createSetupContractMock = function createSetupContractMock() {
  var setupContract = {
    getAll: jest.fn(),
    get: jest.fn(),
    get$: jest.fn(),
    set: jest.fn(),
    remove: jest.fn(),
    isDeclared: jest.fn(),
    isDefault: jest.fn(),
    isCustom: jest.fn(),
    isOverridden: jest.fn(),
    overrideLocalDefault: jest.fn(),
    getUpdate$: jest.fn(),
    getSaved$: jest.fn(),
    getUpdateErrors$: jest.fn(),
    stop: jest.fn()
  };
  return setupContract;
};

var createMock = function createMock() {
  var uiSettings = createSetupContractMock();
  var core = {
    uiSettings: uiSettings
  };
  return core;
};

exports.createMock = createMock;