import { applyFirst } from './Apply';
import { unsafeMonoidArray } from './Monoid';
import { none, some } from './Option';
import { max, min } from './Ord';
// tslint:disable-next-line: deprecation
export function getFoldableComposition(F, G) {
    return {
        reduce: (fga, b, f) => F.reduce(fga, b, (b, ga) => G.reduce(ga, b, f))
    };
}
// tslint:disable-next-line: deprecation
export function foldMap(F, M) {
    return (fa, f) => F.reduce(fa, M.empty, (acc, x) => M.concat(acc, f(x)));
}
// tslint:disable-next-line: deprecation
export function foldr(F) {
    const toArrayF = toArray(F);
    return (fa, b, f) => toArrayF(fa).reduceRight((acc, a) => f(a, acc), b);
}
// tslint:disable-next-line: deprecation
export function fold(F, M) {
    return fa => F.reduce(fa, M.empty, M.concat);
}
export function foldM(
// tslint:disable-next-line: deprecation
F, M) {
    return (f, b, fa) => F.reduce(fa, M.of(b), (mb, a) => M.chain(mb, b => f(b, a)));
}
export function traverse_(M, 
// tslint:disable-next-line: deprecation
F) {
    const toArrayF = toArray(F);
    const applyFirstM = applyFirst(M);
    const initialValue = M.of(undefined);
    return (f, fa) => toArrayF(fa).reduce((mu, a) => applyFirstM(mu, f(a)), initialValue);
}
// tslint:disable-next-line: deprecation
export function sequence_(M, F) {
    const traverse_MF = traverse_(M, F);
    return fa => traverse_MF(ma => ma, fa);
}
// tslint:disable-next-line: deprecation
export function oneOf(F, P) {
    return fga => F.reduce(fga, P.zero(), (acc, a) => P.alt(acc, a));
}
// tslint:disable-next-line: deprecation
export function intercalate(F, M) {
    return sep => {
        function go({ init, acc }, x) {
            return init ? { init: false, acc: x } : { init: false, acc: M.concat(M.concat(acc, sep), x) };
        }
        return fm => F.reduce(fm, { init: true, acc: M.empty }, go).acc;
    };
}
// tslint:disable-next-line: deprecation
export function sum(F, S) {
    return fa => F.reduce(fa, S.zero, (b, a) => S.add(b, a));
}
// tslint:disable-next-line: deprecation
export function product(F, S) {
    return fa => F.reduce(fa, S.one, (b, a) => S.mul(b, a));
}
// tslint:disable-next-line: deprecation
export function elem(F, S) {
    return (a, fa) => F.reduce(fa, false, (b, x) => b || S.equals(x, a));
}
// tslint:disable-next-line: deprecation
export function find(F) {
    return (fa, p) => F.reduce(fa, none, (b, a) => {
        if (b.isNone() && p(a)) {
            return some(a);
        }
        else {
            return b;
        }
    });
}
// tslint:disable-next-line: deprecation
export function minimum(F, O) {
    const minO = min(O);
    return fa => F.reduce(fa, none, (b, a) => (b.isNone() ? some(a) : some(minO(b.value, a))));
}
// tslint:disable-next-line: deprecation
export function maximum(F, O) {
    const maxO = max(O);
    return fa => F.reduce(fa, none, (b, a) => (b.isNone() ? some(a) : some(maxO(b.value, a))));
}
// tslint:disable-next-line: deprecation
export function toArray(F) {
    const foldMapF = foldMap(F, unsafeMonoidArray);
    return fa => foldMapF(fa, a => [a]);
}
export function traverse(M, 
// tslint:disable-next-line: deprecation
F) {
    const traverseMF = traverse_(M, F);
    return (fa, f) => traverseMF(f, fa);
}
