"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var renderprops_konva_cjs_1 = require("react-spring/renderprops-konva.cjs");
var rendering_1 = require("../../lib/series/rendering");
var rendering_props_utils_1 = require("./utils/rendering_props_utils");
var AreaGeometries = /** @class */ (function (_super) {
    __extends(AreaGeometries, _super);
    function AreaGeometries(props) {
        var _this = _super.call(this, props) || this;
        _this.barSeriesRef = react_1.default.createRef();
        _this.renderAreaPoints = function (themeIsVisible) {
            var areas = _this.props.areas;
            return areas.reduce(function (acc, glyph, i) {
                var points = glyph.points, seriesPointStyle = glyph.seriesPointStyle;
                var isVisible = seriesPointStyle ? seriesPointStyle.visible : themeIsVisible;
                if (!isVisible) {
                    return acc;
                }
                var _a = _this.props.style.point, radius = _a.radius, strokeWidth = _a.strokeWidth, opacity = _a.opacity;
                var pointStyleProps = rendering_props_utils_1.buildPointStyleProps({
                    radius: radius,
                    strokeWidth: strokeWidth,
                    opacity: opacity,
                    seriesPointStyle: seriesPointStyle,
                });
                return __spread(acc, _this.renderPoints(points, i, pointStyleProps));
            }, []);
        };
        _this.renderPoints = function (areaPoints, areaIndex, pointStyleProps) {
            var areaPointElements = [];
            areaPoints.forEach(function (areaPoint, pointIndex) {
                var x = areaPoint.x, y = areaPoint.y, color = areaPoint.color, transform = areaPoint.transform;
                if (_this.props.animated) {
                    areaPointElements.push(react_1.default.createElement(react_konva_1.Group, { key: "area-point-group-" + areaIndex + "-" + pointIndex, x: transform.x },
                        react_1.default.createElement(renderprops_konva_cjs_1.Spring, { native: true, from: { y: y }, to: { y: y } }, function () {
                            var pointProps = rendering_props_utils_1.buildAreaPointProps({
                                areaIndex: areaIndex,
                                pointIndex: pointIndex,
                                x: x,
                                y: y,
                                color: color,
                                pointStyleProps: pointStyleProps,
                            });
                            return react_1.default.createElement(renderprops_konva_cjs_1.animated.Circle, __assign({}, pointProps));
                        })));
                }
                else {
                    var pointProps = rendering_props_utils_1.buildAreaPointProps({
                        areaIndex: areaIndex,
                        pointIndex: pointIndex,
                        x: transform.x + x,
                        y: y,
                        color: color,
                        pointStyleProps: pointStyleProps,
                    });
                    areaPointElements.push(react_1.default.createElement(react_konva_1.Circle, __assign({}, pointProps)));
                }
            });
            return areaPointElements;
        };
        _this.renderAreaGeoms = function (themeIsVisible) {
            var areas = _this.props.areas;
            var opacity = _this.props.style.area.opacity;
            var areasToRender = [];
            areas.forEach(function (glyph, i) {
                var area = glyph.area, color = glyph.color, transform = glyph.transform, seriesAreaStyle = glyph.seriesAreaStyle;
                var isVisible = seriesAreaStyle ? seriesAreaStyle.visible : themeIsVisible;
                if (!isVisible) {
                    return;
                }
                if (_this.props.animated) {
                    areasToRender.push(react_1.default.createElement(react_konva_1.Group, { key: "area-group-" + i, x: transform.x },
                        react_1.default.createElement(renderprops_konva_cjs_1.Spring, { native: true, from: { area: area }, to: { area: area } }, function (props) {
                            var areaProps = rendering_props_utils_1.buildAreaProps({
                                index: i,
                                areaPath: props.area,
                                xTransform: 0,
                                color: color,
                                opacity: opacity,
                                seriesAreaStyle: seriesAreaStyle,
                            });
                            return react_1.default.createElement(renderprops_konva_cjs_1.animated.Path, __assign({}, areaProps));
                        })));
                }
                else {
                    var areaProps = rendering_props_utils_1.buildAreaProps({
                        index: i,
                        areaPath: area,
                        xTransform: transform.x,
                        color: color,
                        opacity: opacity,
                        seriesAreaStyle: seriesAreaStyle,
                    });
                    areasToRender.push(react_1.default.createElement(react_konva_1.Path, __assign({}, areaProps)));
                }
            });
            return areasToRender;
        };
        _this.renderAreaLines = function (themeIsVisible) {
            var _a = _this.props, areas = _a.areas, sharedStyle = _a.sharedStyle;
            var strokeWidth = _this.props.style.line.strokeWidth;
            var linesToRender = [];
            areas.forEach(function (glyph, areaIndex) {
                var lines = glyph.lines, color = glyph.color, geometryId = glyph.geometryId, transform = glyph.transform, seriesAreaLineStyle = glyph.seriesAreaLineStyle;
                var isVisible = seriesAreaLineStyle ? seriesAreaLineStyle.visible : themeIsVisible;
                if (!isVisible) {
                    return;
                }
                var customOpacity = seriesAreaLineStyle ? seriesAreaLineStyle.opacity : undefined;
                var geometryStyle = rendering_1.getGeometryStyle(geometryId, _this.props.highlightedLegendItem, sharedStyle, customOpacity);
                lines.forEach(function (linePath, lineIndex) {
                    var lineProps = rendering_props_utils_1.buildAreaLineProps({
                        areaIndex: areaIndex,
                        lineIndex: lineIndex,
                        xTransform: transform.x,
                        linePath: linePath,
                        color: color,
                        strokeWidth: strokeWidth,
                        geometryStyle: geometryStyle,
                        seriesAreaLineStyle: seriesAreaLineStyle,
                    });
                    linesToRender.push(react_1.default.createElement(react_konva_1.Path, __assign({}, lineProps)));
                });
            });
            return linesToRender;
            // if (this.props.animated) {
            //   return (
            //     <Group key={`area-line-group-${i}`} x={transform.x}>
            //       <Spring native from={{ line }} to={{ line }}>
            //         {(props: { line: string }) => {
            //           const lineProps = buildAreaLineProps({
            //             index: i,
            //             linePath: props.line,
            //             color,
            //             strokeWidth,
            //             geometryStyle,
            //           });
            //           return <animated.Path {...lineProps} />;
            //         }}
            //       </Spring>
            //     </Group>
            //   );
            // } else {
            // }
        };
        _this.barSeriesRef = react_1.default.createRef();
        _this.state = {
            overPoint: undefined,
        };
        return _this;
    }
    AreaGeometries.prototype.render = function () {
        var _a = this.props.style, point = _a.point, area = _a.area, line = _a.line;
        return (react_1.default.createElement(react_konva_1.Group, { ref: this.barSeriesRef, key: 'bar_series' },
            this.renderAreaGeoms(area.visible),
            this.renderAreaLines(line.visible),
            this.renderAreaPoints(point.visible)));
    };
    AreaGeometries.defaultProps = {
        animated: false,
    };
    return AreaGeometries;
}(react_1.default.PureComponent));
exports.AreaGeometries = AreaGeometries;
//# sourceMappingURL=area_geometries.js.map