"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
var interactions_1 = require("../lib/utils/interactions");
var utils_1 = require("../state/utils");
function canRenderBand(type, visible) {
    return visible && (type === interactions_1.TooltipType.Crosshairs || type === interactions_1.TooltipType.VerticalCursor);
}
function canRenderHelpLine(type, visible) {
    return visible && type === interactions_1.TooltipType.Crosshairs;
}
var CrosshairComponent = /** @class */ (function (_super) {
    __extends(CrosshairComponent, _super);
    function CrosshairComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CrosshairComponent.prototype.render = function () {
        var isCrosshairVisible = this.props.chartStore.isCrosshairVisible;
        if (!isCrosshairVisible.get()) {
            return react_1.default.createElement("div", { className: "echCrosshair" });
        }
        return (react_1.default.createElement("div", { className: "echCrosshair" },
            this.renderBand(),
            this.renderLine()));
    };
    CrosshairComponent.prototype.renderBand = function () {
        var _a = this.props.chartStore, band = _a.chartTheme.crosshair.band, cursorBandPosition = _a.cursorBandPosition, tooltipType = _a.tooltipType;
        if (!canRenderBand(tooltipType.get(), band.visible)) {
            return null;
        }
        var style = __assign({}, cursorBandPosition, { background: band.fill });
        return react_1.default.createElement("div", { className: "echCrosshair__band", style: style });
    };
    CrosshairComponent.prototype.renderLine = function () {
        var _a = this.props.chartStore, line = _a.chartTheme.crosshair.line, cursorLinePosition = _a.cursorLinePosition, tooltipType = _a.tooltipType, chartRotation = _a.chartRotation;
        if (!canRenderHelpLine(tooltipType.get(), line.visible)) {
            return null;
        }
        var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
        var style;
        if (isHorizontalRotated) {
            style = __assign({}, cursorLinePosition, { borderTopWidth: line.strokeWidth, borderTopColor: line.stroke, borderTopStyle: line.dash ? 'dashed' : 'solid' });
        }
        else {
            style = __assign({}, cursorLinePosition, { borderLeftWidth: line.strokeWidth, borderLeftColor: line.stroke, borderLeftStyle: line.dash ? 'dashed' : 'solid' });
        }
        return react_1.default.createElement("div", { className: "echCrosshair__line", style: style });
    };
    CrosshairComponent.displayName = 'Crosshair';
    return CrosshairComponent;
}(react_1.default.Component));
exports.Crosshair = mobx_react_1.inject('chartStore')(mobx_react_1.observer(CrosshairComponent));
//# sourceMappingURL=crosshair.js.map