/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.sf.juife.OkCancelDialog;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.view.std.StdI18n;

public class JSPianoRollPrefsDlg
extends OkCancelDialog {
    private final MainPane mainPane = new MainPane();

    public JSPianoRollPrefsDlg() {
        super((Frame)CC.getMainFrame(), StdI18n.i18n.getLabel("JSPianoRollPrefsDlg.title"));
        this.btnOk.setText(StdI18n.i18n.getButtonLabel("apply"));
        this.setMainPane(this.mainPane);
        this.btnOk.requestFocus();
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        try {
            this.mainPane.apply();
        }
        catch (Exception exception) {
            HF.showErrorMessage(exception);
            return;
        }
        this.setVisible(false);
        this.setCancelled(false);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    public static class MainPane
    extends JPanel {
        private final JLabel lFromKey = new JLabel(StdI18n.i18n.getLabel("JSPianoRollPrefsDlg.lFromKey"));
        private final JLabel lToKey = new JLabel(StdI18n.i18n.getLabel("JSPianoRollPrefsDlg.lToKey"));
        private final JLabel lHeight = new JLabel(StdI18n.i18n.getLabel("JSPianoRollPrefsDlg.lHeight"));
        private final JSpinner spinnerFirstKey = new JSpinner(new SpinnerNumberModel(0, 0, 127, 1));
        private final JSpinner spinnerLastKey = new JSpinner(new SpinnerNumberModel(0, 0, 127, 1));
        private final JSpinner spinnerHeight = new JSpinner(new SpinnerNumberModel(80, 80, 300, 1));

        public MainPane() {
            int n = CC.preferences().getIntProperty("midiKeyboard.firstKey");
            this.spinnerFirstKey.setValue(n);
            n = CC.preferences().getIntProperty("midiKeyboard.lastKey");
            this.spinnerLastKey.setValue(n);
            n = CC.preferences().getIntProperty("midiKeyboard.height");
            this.spinnerHeight.setValue(n);
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.lFromKey);
            jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
            jPanel.add(this.spinnerFirstKey);
            jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
            jPanel.add(this.lToKey);
            jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
            jPanel.add(this.spinnerLastKey);
            jPanel.setAlignmentX(0.0f);
            this.add(jPanel);
            String string = StdI18n.i18n.getLabel("JSPianoRollPrefsDlg.keyRange");
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
            jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, jPanel.getPreferredSize().height));
            this.add(Box.createRigidArea(new Dimension(0, 6)));
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.lHeight);
            jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
            jPanel.add(this.spinnerHeight);
            jPanel.setAlignmentX(0.0f);
            this.add(jPanel);
        }

        public void apply() throws Exception {
            int n = Integer.parseInt(this.spinnerFirstKey.getValue().toString());
            int n2 = Integer.parseInt(this.spinnerLastKey.getValue().toString());
            if (n < 0 || n > 127 || n2 < 0 || n2 > 127 || n >= n2) {
                String string = StdI18n.i18n.getError("JSPianoRollPrefsDlg.invalidKeyRange!");
                throw new Exception(string);
            }
            if (n2 - n < 31) {
                int n3 = n2 - n + 1;
                String string = StdI18n.i18n.getError("JSPianoRollPrefsDlg.tooSmallKeyRange!", n3);
                throw new Exception(string);
            }
            CC.preferences().setIntProperty("midiKeyboard.firstKey", n);
            CC.preferences().setIntProperty("midiKeyboard.lastKey", n2);
            n = Integer.parseInt(this.spinnerHeight.getValue().toString());
            CC.preferences().setIntProperty("midiKeyboard.height", n);
        }
    }
}

