/*
 * Decompiled with CFR 0.152.
 */
package grails.rest.render.atom;

import grails.converters.XML;
import grails.rest.Link;
import grails.rest.render.RenderContext;
import grails.rest.render.hal.HalXmlRenderer;
import grails.rest.render.util.AbstractLinkingRenderer;
import grails.web.mime.MimeType;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.web.xml.PrettyPrintXMLStreamWriter;
import org.grails.web.xml.StreamingMarkupWriter;
import org.grails.web.xml.XMLStreamWriter;
import org.springframework.http.HttpMethod;

public class AtomRenderer<T>
extends HalXmlRenderer<T> {
    public static final MimeType MIME_TYPE;
    public static final SimpleDateFormat ATOM_DATE_FORMAT;
    public static final String FEED_TAG = "feed";
    public static final String ENTRY_TAG = "entry";
    public static final String XMLNS_ATTRIBUTE = "xmlns";
    public static final String PUBLISHED_TAG = "published";
    public static final String UPDATED_TAG = "updated";
    public static final String ID_TAG = "id";
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    public static final SimpleDateFormat ID_DATE_FORMAT;
    public static final String RELATIONSHIP_ALTERNATE = "alternate";
    public static final MimeType[] DEFAULT_ATOM_MIME_TYPES;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public AtomRenderer(Class<T> targetType) {
        super(targetType, DEFAULT_ATOM_MIME_TYPES);
    }

    @Override
    public void renderInternal(T object, RenderContext context) {
        StreamingMarkupWriter streamingWriter = new StreamingMarkupWriter(context.getWriter(), this.getEncoding());
        PrettyPrintXMLStreamWriter w = this.getPrettyPrint() ? new PrettyPrintXMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)streamingWriter) : new XMLStreamWriter((groovy.xml.streamingmarkupsupport.StreamingMarkupWriter)streamingWriter);
        XML xml = new XML((XMLStreamWriter)w);
        PersistentEntity entity = this.getMappingContext().getPersistentEntity(object.getClass().getName());
        boolean isDomain = entity != null;
        Set writtenObjects = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        w.startDocument(this.getEncoding(), "1.0");
        if (isDomain) {
            this.writeDomainWithEmbeddedAndLinks(entity, object, context, xml, writtenObjects);
        } else if (object instanceof Collection) {
            Locale locale = context.getLocale();
            String resourceHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"uri", context.getResourcePath(), "method", HttpMethod.GET, "absolute", true}));
            String title = this.getResourceTitle(context.getResourcePath(), locale);
            XMLStreamWriter writer = xml.getWriter();
            writer.startNode(FEED_TAG).attribute(XMLNS_ATTRIBUTE, ATOM_NAMESPACE).startNode(AbstractLinkingRenderer.TITLE_ATTRIBUTE).characters(title).end().startNode(ID_TAG).characters(this.generateIdForURI(resourceHref)).end();
            Link linkSelf = new Link(AbstractLinkingRenderer.RELATIONSHIP_SELF, resourceHref);
            String string = title;
            linkSelf.setTitle(string);
            String string2 = ((MimeType)BytecodeInterface8.objectArrayGet((Object[])this.getMimeTypes(), (int)0)).getName();
            linkSelf.setContentType(string2);
            Locale locale2 = locale;
            linkSelf.setHreflang(locale2);
            this.writeLink(linkSelf, locale, xml);
            Link linkAlt = new Link(RELATIONSHIP_ALTERNATE, resourceHref);
            String string3 = title;
            linkAlt.setTitle(string3);
            Locale locale3 = locale;
            linkAlt.setHreflang(locale3);
            this.writeLink(linkAlt, locale, xml);
            Object o2 = null;
            for (Object o2 : (Collection)ScriptBytecodeAdapter.castToType(object, Collection.class)) {
                PersistentEntity currentEntity = this.getMappingContext().getPersistentEntity(o2.getClass().getName());
                if (DefaultTypeTransformation.booleanUnbox((Object)currentEntity)) {
                    this.writeDomainWithEmbeddedAndLinks(currentEntity, o2, context, xml, writtenObjects, false);
                    continue;
                }
                throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{o2}, new String[]{"Cannot render object [", "] using Atom. The AtomRenderer can only be used with domain classes that specify 'dateCreated' and 'lastUpdated' properties"})));
            }
            writer.end();
            context.getWriter().flush();
        } else {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{object}, new String[]{"Cannot render object [", "] using Atom. The AtomRenderer can only be used with domain classes that specify 'dateCreated' and 'lastUpdated' properties"})));
        }
    }

    public String generateIdForURI(String url, Date dateCreated, Object id) {
        String string;
        if (url.startsWith("http")) {
            String string2;
            url = string2 = url.substring(url.indexOf("//") + 2, url.length());
        }
        url = string = url.replace("#", "/");
        int i = url.indexOf("/");
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)i, (Object)-1)) {
            Object object;
            String dateCreatedId = "";
            if (DefaultTypeTransformation.booleanUnbox((Object)dateCreated)) {
                GStringImpl gStringImpl = new GStringImpl(new Object[]{ID_DATE_FORMAT.format(dateCreated)}, new String[]{",", ""});
                dateCreatedId = ShortTypeHandling.castToString((Object)gStringImpl);
            }
            GStringImpl gStringImpl = new GStringImpl(new Object[]{url.substring(0, i), dateCreatedId, DefaultTypeTransformation.booleanUnbox((Object)(object = id)) ? object : url.substring(i, url.length())}, new String[]{"", "", ":", ""});
            url = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{url}, new String[]{"tag:", ""}));
    }

    protected void writeDomainWithEmbeddedAndLinks(PersistentEntity entity, Object object, RenderContext context, XML xml, Set writtenObjects, boolean isFirst) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)entity.getPropertyByName("lastUpdated"))) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{object}, new String[]{"Cannot render object [", "] using Atom. The AtomRenderer can only be used with domain classes that specify 'dateCreated' and 'lastUpdated' properties"})));
        }
        Locale locale = context.getLocale();
        String resourceHref = this.getLinkGenerator().link(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"resource", object, "method", HttpMethod.GET, "absolute", true}));
        String title = this.getLinkTitle(entity, locale);
        XMLStreamWriter writer = xml.getWriter();
        writer.startNode(isFirst ? FEED_TAG : ENTRY_TAG);
        if (isFirst) {
            writer.attribute(XMLNS_ATTRIBUTE, ATOM_NAMESPACE);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)entity.getPropertyByName(AbstractLinkingRenderer.TITLE_ATTRIBUTE))) {
            writer.startNode(AbstractLinkingRenderer.TITLE_ATTRIBUTE).characters(DefaultGroovyMethods.toString((Object)object)).end();
        }
        String dateCreated = this.formatDateCreated(object);
        if (DefaultTypeTransformation.booleanUnbox((Object)dateCreated)) {
            writer.startNode(PUBLISHED_TAG).characters(dateCreated).end();
        }
        String lastUpdated = this.formatLastUpdated(object);
        if (DefaultTypeTransformation.booleanUnbox((Object)lastUpdated)) {
            writer.startNode(UPDATED_TAG).characters(lastUpdated).end();
        }
        writer.startNode(ID_TAG).characters(this.getObjectId(entity, object)).end();
        Link linkSelf = new Link(AbstractLinkingRenderer.RELATIONSHIP_SELF, resourceHref);
        String string = title;
        linkSelf.setTitle(string);
        String string2 = ((MimeType)BytecodeInterface8.objectArrayGet((Object[])this.getMimeTypes(), (int)0)).getName();
        linkSelf.setContentType(string2);
        Locale locale2 = locale;
        linkSelf.setHreflang(locale2);
        this.writeLink(linkSelf, locale, xml);
        Link linkAlt = new Link(RELATIONSHIP_ALTERNATE, resourceHref);
        String string3 = title;
        linkAlt.setTitle(string3);
        Locale locale3 = locale;
        linkAlt.setHreflang(locale3);
        this.writeLink(linkAlt, locale, xml);
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(entity.getJavaClass());
        Map<Association, Object> associationMap = this.writeAssociationLinks(context, object, locale, xml, entity, metaClass);
        this.writeDomain(context, metaClass, entity, object, xml);
        if (DefaultTypeTransformation.booleanUnbox(associationMap)) {
            Map.Entry entry = null;
            Iterator<Map.Entry<Association, Object>> iterator = associationMap.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                Association property = (Association)ScriptBytecodeAdapter.castToType(entry.getKey(), Association.class);
                boolean isSingleEnded = property instanceof ToOne;
                if (isSingleEnded) {
                    Object value = entry.getValue();
                    if (writtenObjects.contains(value) || !(value != null)) continue;
                    PersistentEntity associatedEntity = property.getAssociatedEntity();
                    if (!DefaultTypeTransformation.booleanUnbox((Object)associatedEntity)) continue;
                    DefaultGroovyMethods.leftShift((Set)writtenObjects, value);
                    this.writeDomainWithEmbeddedAndLinks(associatedEntity, value, context, xml, writtenObjects, false);
                    continue;
                }
                PersistentEntity associatedEntity = property.getAssociatedEntity();
                if (!DefaultTypeTransformation.booleanUnbox((Object)associatedEntity)) continue;
                writer.startNode(property.getName());
                Object obj = null;
                Iterator iterator2 = DefaultGroovyMethods.iterator(entry.getValue());
                while (iterator2.hasNext()) {
                    obj = iterator2.next();
                    DefaultGroovyMethods.leftShift((Set)writtenObjects, obj);
                    this.writeDomainWithEmbeddedAndLinks(associatedEntity, obj, context, xml, writtenObjects, false);
                }
                writer.end();
            }
        }
        writer.end();
    }

    public String getObjectId(PersistentEntity entity, Object object) {
        CallSite[] callSiteArray = AtomRenderer.$getCallSiteArray();
        Object name = callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty((Object)entity));
        Object objectId = callSiteArray[2].call(object, name);
        Object dateCreated = callSiteArray[3].callGetProperty(object);
        Object url = callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"resource", object, "method", callSiteArray[6].callGetProperty(HttpMethod.class), "absolute", true}));
        return ShortTypeHandling.castToString((Object)callSiteArray[7].callCurrent((GroovyObject)this, url, dateCreated, objectId));
    }

    protected String formatDateCreated(Object object) {
        CallSite[] callSiteArray = AtomRenderer.$getCallSiteArray();
        Object dateCreated = callSiteArray[8].callGetProperty(object);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)dateCreated, null)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[9].callCurrent((GroovyObject)this, dateCreated));
        }
        return ShortTypeHandling.castToString(null);
    }

    protected String formatLastUpdated(Object object) {
        CallSite[] callSiteArray = AtomRenderer.$getCallSiteArray();
        Object lastUpdated = callSiteArray[10].callGetProperty(object);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)lastUpdated, null)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[11].callCurrent((GroovyObject)this, lastUpdated));
        }
        return ShortTypeHandling.castToString(null);
    }

    protected String formatAtomDate(Date dateCreated) {
        String dateFormat = ATOM_DATE_FORMAT.format(dateCreated);
        return StringGroovyMethods.plus((String)dateFormat.substring(0, 19), (CharSequence)dateFormat.substring(22, dateFormat.length()));
    }

    @Generated
    public String generateIdForURI(String url, Date dateCreated) {
        return this.generateIdForURI(url, dateCreated, null);
    }

    @Generated
    public String generateIdForURI(String url) {
        return this.generateIdForURI(url, null, null);
    }

    @Override
    @Generated
    protected void writeDomainWithEmbeddedAndLinks(PersistentEntity entity, Object object, RenderContext context, XML xml, Set writtenObjects) {
        this.writeDomainWithEmbeddedAndLinks(entity, object, context, xml, writtenObjects, true);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AtomRenderer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2;
        MimeType mimeType;
        MIME_TYPE = mimeType = MimeType.ATOM_XML;
        ATOM_DATE_FORMAT = simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        ID_DATE_FORMAT = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        MimeType[] mimeTypeArray = new MimeType[]{MIME_TYPE};
        DEFAULT_ATOM_MIME_TYPES = mimeTypeArray;
    }

    public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$5$renderInternal(Object object, RenderContext renderContext) {
        super.renderInternal(object, renderContext);
    }

    public /* synthetic */ void super$5$writeDomainWithEmbeddedAndLinks(PersistentEntity persistentEntity, Object object, RenderContext renderContext, XML xML, Set set) {
        super.writeDomainWithEmbeddedAndLinks(persistentEntity, object, renderContext, xML, set);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "name";
        stringArray[1] = "identity";
        stringArray[2] = "getAt";
        stringArray[3] = "dateCreated";
        stringArray[4] = "link";
        stringArray[5] = "linkGenerator";
        stringArray[6] = "GET";
        stringArray[7] = "generateIdForURI";
        stringArray[8] = "dateCreated";
        stringArray[9] = "formatAtomDate";
        stringArray[10] = "lastUpdated";
        stringArray[11] = "formatAtomDate";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[12];
        AtomRenderer.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AtomRenderer.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AtomRenderer.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

