/*
 * Decompiled with CFR 0.152.
 */
package plugins.collaboration.socket;

import freemind.controller.actions.generated.instance.CollaborationActionBase;
import freemind.controller.actions.generated.instance.CollaborationGoodbye;
import freemind.controller.actions.generated.instance.CollaborationHello;
import freemind.controller.actions.generated.instance.CollaborationReceiveLock;
import freemind.controller.actions.generated.instance.CollaborationRequireLock;
import freemind.controller.actions.generated.instance.CollaborationTransaction;
import freemind.controller.actions.generated.instance.CollaborationUnableToLock;
import freemind.controller.actions.generated.instance.CollaborationUserInformation;
import freemind.controller.actions.generated.instance.CollaborationWelcome;
import freemind.controller.actions.generated.instance.CollaborationWhoAreYou;
import freemind.controller.actions.generated.instance.CollaborationWrongCredentials;
import freemind.extensions.PermanentNodeHook;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import plugins.collaboration.socket.CommunicationBase;
import plugins.collaboration.socket.SocketBasics;
import plugins.collaboration.socket.SocketConnectionHook;

public class ClientCommunication
extends CommunicationBase {
    private static final int MAX_LOCK_RETRIES = 5;
    private static final long LOCK_RETRY_SLEEP_TIME = 1000L;
    private String mLockId;
    private HashSet mLockIds = new HashSet();
    private String mPassword;
    private SocketConnectionHook mSocketConnectionHook = null;
    private boolean mReceivedGoodbye = false;
    private CollaborationUserInformation mUserInfo;

    public ClientCommunication(String pName, Socket pClient, MindMapController pController, String pPassword) throws IOException {
        super(pName, pClient, pController, new DataOutputStream(pClient.getOutputStream()), new DataInputStream(pClient.getInputStream()));
        this.mPassword = pPassword;
        this.setCurrentState(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processCommand(CollaborationActionBase pCommand) throws IOException {
        if (pCommand instanceof CollaborationGoodbye) {
            CollaborationGoodbye goodbye = (CollaborationGoodbye)pCommand;
            logger.info("Goodbye received from " + goodbye.getUserId());
            this.terminateSocket();
            return;
        }
        boolean commandHandled = false;
        if (pCommand instanceof CollaborationUserInformation) {
            CollaborationUserInformation userInfo;
            this.mUserInfo = userInfo = (CollaborationUserInformation)pCommand;
            commandHandled = true;
        }
        if (pCommand instanceof CollaborationWhoAreYou) {
            if (this.getCurrentState() != 3) {
                this.printWrongState(pCommand);
            }
            CollaborationHello helloCommand = new CollaborationHello();
            helloCommand.setUserId(Tools.getUserName());
            helloCommand.setPassword(this.mPassword);
            this.send((CollaborationActionBase)helloCommand);
            this.setCurrentState(4);
            commandHandled = true;
        }
        if (pCommand instanceof CollaborationWelcome) {
            if (this.getCurrentState() != 4) {
                this.printWrongState(pCommand);
            }
            CollaborationWelcome collWelcome = (CollaborationWelcome)pCommand;
            this.createNewMap(collWelcome.getMap());
            this.setCurrentState(0);
            commandHandled = true;
        }
        if (pCommand instanceof CollaborationWrongCredentials) {
            if (this.getCurrentState() != 4) {
                this.printWrongState(pCommand);
            }
            this.terminateSocket();
            this.getMindMapController().getController().errorMessage((Object)this.getMindMapController().getText("socket_wrong_password"));
            commandHandled = true;
        }
        if (pCommand instanceof CollaborationTransaction) {
            boolean removeResult;
            CollaborationTransaction trans = (CollaborationTransaction)pCommand;
            HashSet hashSet = this.mLockIds;
            synchronized (hashSet) {
                removeResult = this.mLockIds.remove(trans.getId());
            }
            if (!removeResult) {
                if (this.getCurrentState() != 0) {
                    this.printWrongState(pCommand);
                }
                if (this.mSocketConnectionHook != null) {
                    this.mSocketConnectionHook.executeTransaction(this.getActionPair(trans));
                }
            }
            commandHandled = true;
        }
        if (pCommand instanceof CollaborationReceiveLock) {
            if (this.getCurrentState() != 5) {
                this.printWrongState(pCommand);
            }
            CollaborationReceiveLock lockReceived = (CollaborationReceiveLock)pCommand;
            this.mLockId = lockReceived.getId();
            HashSet hashSet = this.mLockIds;
            synchronized (hashSet) {
                this.mLockIds.add(this.mLockId);
            }
            this.setCurrentState(6);
            commandHandled = true;
        }
        if (pCommand instanceof CollaborationUnableToLock) {
            this.setCurrentState(0);
            commandHandled = true;
        }
        if (!commandHandled) {
            logger.warning("Received unknown message of type " + pCommand.getClass());
        }
    }

    public void terminateSocket() {
        this.mReceivedGoodbye = true;
        if (this.mSocketConnectionHook != null) {
            this.mSocketConnectionHook.deregisterFilter();
            this.toggleHook();
        } else {
            this.shutdown();
        }
    }

    public void toggleHook() {
        SocketBasics.togglePermanentHook(this.getMindMapController(), "plugins/collaboration/socket/socket_slave_plugin");
    }

    public synchronized String sendLockRequest() throws InterruptedException, SocketBasics.UnableToGetLockException {
        this.mLockId = null;
        int lockTries = 0;
        int timeout = 0;
        while (lockTries < 5) {
            CollaborationRequireLock lockRequest = new CollaborationRequireLock();
            this.setCurrentState(5);
            if (!this.send((CollaborationActionBase)lockRequest)) {
                this.setCurrentState(0);
                throw new SocketBasics.UnableToGetLockException();
            }
            int sleepTime = 100;
            for (timeout = 200; this.getCurrentState() == 5 && timeout >= 0; --timeout) {
                ClientCommunication.sleep(100L);
            }
            if (this.getCurrentState() == 6) break;
            logger.info("Didn't receive a lock, current try: " + ++lockTries);
            ClientCommunication.sleep(1000L);
        }
        this.setCurrentState(0);
        if (lockTries == 5 || timeout < 0) {
            throw new SocketBasics.UnableToGetLockException();
        }
        return this.mLockId;
    }

    void createNewMap(String map) throws IOException {
        logger.info("Restoring the map...");
        MindMapController newModeController = (MindMapController)this.getMindMapController().getMode().createModeController();
        MindMapMapModel newModel = new MindMapMapModel(this.getMindMapController().getFrame(), (ModeController)newModeController);
        HashMap IDToTarget = new HashMap();
        StringReader reader = new StringReader(map);
        MindMapNodeModel rootNode = (MindMapNodeModel)newModeController.createNodeTreeFromXml((Reader)reader, IDToTarget);
        reader.close();
        newModel.setRoot((MindMapNode)rootNode);
        rootNode.setMap((MindMap)newModel);
        this.getMindMapController().newMap((MindMap)newModel);
        newModeController.invokeHooksRecursively((NodeAdapter)rootNode, (MindMap)newModel);
        this.setController(newModeController);
        this.toggleHook();
        Collection activatedHooks = this.getMindMapController().getRootNode().getActivatedHooks();
        for (PermanentNodeHook hook : activatedHooks) {
            if (!(hook instanceof SocketConnectionHook)) continue;
            SocketConnectionHook connHook = null;
            connHook = (SocketConnectionHook)hook;
            connHook.setClientCommunication(this);
            connHook.registerFilter();
            this.mSocketConnectionHook = connHook;
            break;
        }
    }

    private void setController(MindMapController pNewModeController) {
        this.mController = pNewModeController;
    }

    private MindMapController getMindMapController() {
        return this.mController;
    }

    public void shutdown() {
        this.commitSuicide();
        try {
            if (!this.mReceivedGoodbye) {
                CollaborationGoodbye goodbye = new CollaborationGoodbye();
                goodbye.setUserId(Tools.getUserName());
                this.send((CollaborationActionBase)goodbye);
            }
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
        }
        try {
            this.close();
        }
        catch (IOException e) {
            Resources.getInstance().logException((Throwable)e);
        }
    }

    public int getPort() {
        return this.mSocket.getLocalPort();
    }

    public CollaborationUserInformation getUserInfo() {
        return this.mUserInfo;
    }
}

