/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.overridemethods;

import java.util.List;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.Messages;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.OverrideOptions;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.VirtualMethodContainer;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.VirtualMethodPrintData;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.VirtualMethodsASTVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class OverrideMethodsRefactoring
extends CRefactoring {
    private VirtualMethodsASTVisitor fVirtualMethodVisitor;
    private OverrideOptions fOptions;
    private VirtualMethodContainer fMethodContainer;
    private VirtualMethodPrintData fPrintData = new VirtualMethodPrintData();
    private ImplementMethodRefactoring fImplementMethodRefactoring;

    public VirtualMethodPrintData getPrintData() {
        return this.fPrintData;
    }

    public VirtualMethodContainer getMethodContainer() {
        return this.fMethodContainer;
    }

    public OverrideMethodsRefactoring(ICElement element, ISelection selection, ICProject project) {
        super(element, selection, project);
        this.fOptions = new OverrideOptions(project);
        this.fMethodContainer = new VirtualMethodContainer(this.fOptions);
        this.fVirtualMethodVisitor = new VirtualMethodsASTVisitor((ITextSelection)selection, this.tu.getFile().getName(), this.fMethodContainer, TypeUtil.getFullyQualifiedName((ICElement)element).getFullyQualifiedName());
        this.fImplementMethodRefactoring = new ImplementMethodRefactoring(element, selection, project);
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        return null;
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        List<IASTSimpleDeclaration> methods = this.fPrintData.rewriteAST(this.refactoringContext, collector, this.fVirtualMethodVisitor);
        this.fImplementMethodRefactoring.setContext(this.refactoringContext);
        this.fImplementMethodRefactoring.collectModifications(pm, collector, methods, this.fPrintData.getParentOffset());
    }

    private void removeOverridenMethods() {
        ICPPClassType classType = this.fVirtualMethodVisitor.getClassBinding();
        ICPPMethod[] iCPPMethodArray = classType.getDeclaredMethods();
        int n = iCPPMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            this.fMethodContainer.remove(method);
            ++n2;
        }
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)5);
        RefactoringStatus status = super.checkInitialConditions(pm);
        IASTTranslationUnit ast = this.getAST(this.tu, (IProgressMonitor)subMonitor.split(1));
        this.fVirtualMethodVisitor.visitAst(ast);
        subMonitor.worked(3);
        if (this.fVirtualMethodVisitor.getClassNode() == null) {
            status.addFatalError(Messages.OverrideMethodsRefactoring_SelNotInClass);
            return status;
        }
        this.removeOverridenMethods();
        if (this.fMethodContainer.isEmpty()) {
            status.addFatalError(Messages.OverrideMethodsRefactoring_NoMethods);
            return status;
        }
        return status;
    }

    @Override
    protected RefactoringStatus checkFinalConditions(IProgressMonitor subProgressMonitor, CheckConditionsContext checkContext) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        this.fImplementMethodRefactoring.finalConditions(checkContext);
        return result;
    }

    public OverrideOptions getOptions() {
        return this.fOptions;
    }
}

