/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntModelProblem;
import org.eclipse.jface.resource.ImageDescriptor;

public class AntTaskNode
extends AntElementNode {
    private Task fTask = null;
    protected String fBaseLabel = null;
    protected String fLabel;
    private String fId = null;
    protected boolean fConfigured = false;

    public AntTaskNode(Task task) {
        super(task.getTaskName());
        this.fTask = task;
    }

    public AntTaskNode(Task task, String label) {
        super(task.getTaskName());
        this.fTask = task;
        this.fBaseLabel = label;
    }

    @Override
    public String getLabel() {
        if (this.fLabel == null) {
            StringBuffer label = new StringBuffer();
            if (this.fBaseLabel != null) {
                label.append(this.fBaseLabel);
            } else if (this.fId != null) {
                label.append(this.fId);
            } else {
                label.append(this.fTask.getTaskName());
            }
            if (this.isExternal()) {
                this.appendEntityName(label);
            }
            this.fLabel = label.toString();
        }
        return this.fLabel;
    }

    public void setBaseLabel(String label) {
        this.fBaseLabel = label;
    }

    public Task getTask() {
        return this.fTask;
    }

    public void setTask(Task task) {
        this.fTask = task;
    }

    @Override
    protected ImageDescriptor getBaseImageDescriptor() {
        if (this.fId != null) {
            return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.type");
        }
        return super.getBaseImageDescriptor();
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public boolean configure(boolean validateFully) {
        if (this.getId() != null) {
            try {
                this.getProjectNode().getProject().getReference(this.getId());
            }
            catch (BuildException e) {
                this.handleBuildException(e, "problem_tasks");
            }
        }
        if (!validateFully || this.getParentNode() instanceof AntTaskNode) {
            return false;
        }
        if (this.fConfigured) {
            return false;
        }
        int severity = AntModelProblem.getSeverity("problem_tasks");
        if (severity != -1) {
            try {
                this.getTask().maybeConfigure();
                this.fConfigured = true;
                return true;
            }
            catch (BuildException be) {
                this.handleBuildException(be, "problem_tasks");
            }
            catch (AntSecurityException antSecurityException) {
                this.handleBuildException(new BuildException(AntModelMessages.AntTaskNode_0), "problem_security");
            }
        }
        return false;
    }

    protected void handleBuildException(BuildException be, String preferenceKey) {
        int severity = AntModelProblem.getSeverity(preferenceKey);
        if (severity != -1) {
            this.getAntModel().handleBuildException(be, this, severity);
        }
    }

    @Override
    public boolean containsOccurrence(String identifier) {
        RuntimeConfigurable wrapper = this.getTask().getRuntimeConfigurableWrapper();
        Hashtable attributeMap = wrapper.getAttributeMap();
        Set keys = attributeMap.keySet();
        boolean lookingForProperty = identifier.startsWith("${") && identifier.endsWith("}");
        for (String key : keys) {
            String value = (String)attributeMap.get(key);
            if (!(lookingForProperty && (key.equals("if") || key.equals("unless")) ? value.indexOf(identifier.substring(2, identifier.length() - 1)) != -1 : value.indexOf(identifier) != -1)) continue;
            return true;
        }
        StringBuffer text = wrapper.getText();
        return text.length() > 0 && lookingForProperty && text.indexOf(identifier) != -1;
    }

    @Override
    public List<Integer> computeIdentifierOffsets(String identifier) {
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null || textToSearch.length() == 0 || identifier.length() == 0) {
            return null;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        RuntimeConfigurable wrapper = this.getTask().getRuntimeConfigurableWrapper();
        Hashtable attributeMap = wrapper.getAttributeMap();
        Set keys = attributeMap.keySet();
        String lineSep = System.getProperty("line.separator");
        for (String key : keys) {
            String value = (String)attributeMap.get(key);
            int identifierCorrection = 1;
            if (value.indexOf(identifier) == -1) continue;
            int keyOffset = textToSearch.indexOf(key);
            while (keyOffset > 0 && !Character.isWhitespace(textToSearch.charAt(keyOffset - 1))) {
                keyOffset = textToSearch.indexOf(key, keyOffset + 1);
            }
            int valueOffset = textToSearch.indexOf(34, keyOffset);
            int valueLine = ((AntModel)this.getAntModel()).getLine(this.getOffset() + valueOffset);
            int withinValueOffset = value.indexOf(identifier);
            while (withinValueOffset != -1) {
                int resultLine = ((AntModel)this.getAntModel()).getLine(this.getOffset() + valueOffset + withinValueOffset);
                int resultOffset = this.getOffset() + valueOffset + withinValueOffset + identifierCorrection + (resultLine - valueLine) * (lineSep.length() - 1);
                results.add(resultOffset);
                withinValueOffset = value.indexOf(identifier, withinValueOffset + 1);
            }
        }
        String text = wrapper.getText().toString().trim();
        if (text.length() > 0) {
            int offset = textToSearch.indexOf(text.toString());
            offset = textToSearch.indexOf(identifier, offset);
            results.add(offset + this.getOffset());
        }
        return results;
    }
}

