/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.WindowsRegistry;

class WinRegistry8
extends WindowsRegistry {
    private static final Log log = Log.getLog(WinRegistry8.class);
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteKey = null;
    private static Method regDeleteValue = null;

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Integer.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Integer.TYPE, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Integer.TYPE, byte[].class);
            regDeleteValue.setAccessible(true);
            regDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Integer.TYPE, byte[].class);
            regDeleteKey.setAccessible(true);
        }
        catch (Exception e) {
            log.error("Error initializing Windows registry", e);
        }
    }

    WinRegistry8() {
    }

    @Override
    public String readString(long hkey, String key, String valueName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            return this.readString(systemRoot, (int)hkey, key, valueName);
        }
        if (hkey == (long)HKEY_CURRENT_USER) {
            return this.readString(userRoot, (int)hkey, key, valueName);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    @Override
    public Map<String, String> readStringValues(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            return this.readStringValues(systemRoot, (int)hkey, key);
        }
        if (hkey == (long)HKEY_CURRENT_USER) {
            return this.readStringValues(userRoot, (int)hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    @Override
    public List<String> readStringSubKeys(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            return this.readStringSubKeys(systemRoot, (int)hkey, key);
        }
        if (hkey == (long)HKEY_CURRENT_USER) {
            return this.readStringSubKeys(userRoot, (int)hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    @Override
    public void createKey(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] ret;
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            ret = this.createKey(systemRoot, (int)hkey, key);
            regCloseKey.invoke((Object)systemRoot, ret[0]);
        } else if (hkey == (long)HKEY_CURRENT_USER) {
            ret = this.createKey(userRoot, (int)hkey, key);
            regCloseKey.invoke((Object)userRoot, ret[0]);
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
        if (ret[1] != REG_SUCCESS) {
            throw new IllegalArgumentException("rc=" + ret[1] + "  key=" + key);
        }
    }

    @Override
    public void writeStringValue(long hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            this.writeStringValue(systemRoot, (int)hkey, key, valueName, value);
        } else if (hkey == (long)HKEY_CURRENT_USER) {
            this.writeStringValue(userRoot, (int)hkey, key, valueName, value);
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
    }

    @Override
    public void deleteKey(long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = -1;
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            rc = this.deleteKey(systemRoot, (int)hkey, key);
        } else if (hkey == (long)HKEY_CURRENT_USER) {
            rc = this.deleteKey(userRoot, (int)hkey, key);
        }
        if (rc != REG_SUCCESS) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key);
        }
    }

    @Override
    public void deleteValue(long hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = -1;
        if (hkey == (long)HKEY_LOCAL_MACHINE) {
            rc = this.deleteValue(systemRoot, (int)hkey, key, value);
        } else if (hkey == (long)HKEY_CURRENT_USER) {
            rc = this.deleteValue(userRoot, (int)hkey, key, value);
        }
        if (rc != REG_SUCCESS) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key + "  value=" + value);
        }
    }

    private int deleteValue(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regOpenKey.invoke((Object)root, hkey, this.toCstr(key), 983103);
        if (handles[1] != REG_SUCCESS) {
            return handles[1];
        }
        int rc = (Integer)regDeleteValue.invoke((Object)root, handles[0], this.toCstr(value));
        regCloseKey.invoke((Object)root, handles[0]);
        return rc;
    }

    private int deleteKey(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Integer)regDeleteKey.invoke((Object)root, hkey, this.toCstr(key));
    }

    private String readString(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regOpenKey.invoke((Object)root, hkey, this.toCstr(key), 131097);
        if (handles[1] != REG_SUCCESS) {
            return null;
        }
        byte[] valb = (byte[])regQueryValueEx.invoke((Object)root, handles[0], this.toCstr(value));
        regCloseKey.invoke((Object)root, handles[0]);
        return valb != null ? new String(valb).trim() : null;
    }

    private Map<String, String> readStringValues(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> results = new HashMap<String, String>();
        int[] handles = (int[])regOpenKey.invoke((Object)root, hkey, this.toCstr(key), 131097);
        if (handles[1] != REG_SUCCESS) {
            return null;
        }
        int[] info = (int[])regQueryInfoKey.invoke((Object)root, handles[0]);
        int count = info[2];
        int maxlen = 256;
        int index = 0;
        while (index < count) {
            byte[] name = (byte[])regEnumValue.invoke((Object)root, handles[0], index, maxlen + 1);
            if (name != null) {
                String value = this.readString(hkey, key, new String(name));
                results.put(new String(name).trim(), value);
            }
            ++index;
        }
        regCloseKey.invoke((Object)root, handles[0]);
        return results;
    }

    private List<String> readStringSubKeys(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        int[] handles = (int[])regOpenKey.invoke((Object)root, hkey, this.toCstr(key), 131097);
        if (handles[1] != REG_SUCCESS) {
            return null;
        }
        int[] info = (int[])regQueryInfoKey.invoke((Object)root, handles[0]);
        int cfr_ignored_0 = info[2];
        int maxlen = info[3];
        int index = 0;
        while (index < Integer.MAX_VALUE) {
            byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, handles[0], index, maxlen + 1);
            if (name == null) break;
            results.add(new String(name).trim());
            ++index;
        }
        regCloseKey.invoke((Object)root, handles[0]);
        return results;
    }

    private int[] createKey(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (int[])regCreateKeyEx.invoke((Object)root, hkey, this.toCstr(key));
    }

    private void writeStringValue(Preferences root, int hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regOpenKey.invoke((Object)root, hkey, this.toCstr(key), 983103);
        regSetValueEx.invoke((Object)root, handles[0], this.toCstr(valueName), this.toCstr(value));
        regCloseKey.invoke((Object)root, handles[0]);
    }
}

