/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.preferences;

import java.io.IOException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jkiss.dbeaver.model.impl.preferences.AbstractPreferenceStore;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class BundlePreferenceStore
extends AbstractPreferenceStore {
    private final IEclipsePreferences defaultProps;
    private final IEclipsePreferences props;
    private boolean dirty = false;

    public BundlePreferenceStore(Bundle bundle) {
        this.defaultProps = DefaultScope.INSTANCE.getNode(bundle.getSymbolicName());
        this.props = InstanceScope.INSTANCE.getNode(bundle.getSymbolicName());
    }

    @Override
    public boolean contains(String name) {
        return this.props.get(name, null) != null || this.defaultProps.get(name, null) != null;
    }

    @Override
    public boolean getBoolean(String name) {
        return this.props.get(name, null) != null ? this.props.getBoolean(name, false) : (this.defaultProps.get(name, null) != null ? this.defaultProps.getBoolean(name, false) : false);
    }

    @Override
    public double getDouble(String name) {
        return this.props.get(name, null) != null ? this.props.getDouble(name, 0.0) : (this.defaultProps.get(name, null) != null ? this.defaultProps.getDouble(name, 0.0) : 0.0);
    }

    @Override
    public float getFloat(String name) {
        return this.props.get(name, null) != null ? this.props.getFloat(name, 0.0f) : (this.defaultProps.get(name, null) != null ? this.defaultProps.getFloat(name, 0.0f) : 0.0f);
    }

    @Override
    public int getInt(String name) {
        return this.props.get(name, null) != null ? this.props.getInt(name, 0) : (this.defaultProps.get(name, null) != null ? this.defaultProps.getInt(name, 0) : 0);
    }

    @Override
    public long getLong(String name) {
        return this.props.get(name, null) != null ? this.props.getLong(name, 0L) : (this.defaultProps.get(name, null) != null ? this.defaultProps.getLong(name, 0L) : 0L);
    }

    @Override
    public String getString(String name) {
        return this.props.get(name, null) != null ? this.props.get(name, "") : (this.defaultProps.get(name, null) != null ? this.defaultProps.get(name, "") : "");
    }

    @Override
    public boolean getDefaultBoolean(String name) {
        return this.defaultProps.getBoolean(name, false);
    }

    @Override
    public double getDefaultDouble(String name) {
        return this.defaultProps.getDouble(name, 0.0);
    }

    @Override
    public float getDefaultFloat(String name) {
        return this.defaultProps.getFloat(name, 0.0f);
    }

    @Override
    public int getDefaultInt(String name) {
        return this.defaultProps.getInt(name, 0);
    }

    @Override
    public long getDefaultLong(String name) {
        return this.defaultProps.getLong(name, 0L);
    }

    @Override
    public String getDefaultString(String name) {
        return this.defaultProps.get(name, "");
    }

    @Override
    public boolean isDefault(String name) {
        return this.props.get(name, null) == null && this.defaultProps.get(name, null) != null;
    }

    @Override
    public boolean needsSaving() {
        return this.dirty;
    }

    @Override
    public void setDefault(String name, double value) {
        this.defaultProps.putDouble(name, value);
    }

    @Override
    public void setDefault(String name, float value) {
        this.defaultProps.putFloat(name, value);
    }

    @Override
    public void setDefault(String name, int value) {
        this.defaultProps.putInt(name, value);
    }

    @Override
    public void setDefault(String name, long value) {
        this.defaultProps.putLong(name, value);
    }

    @Override
    public void setDefault(String name, String defaultObject) {
        this.defaultProps.put(name, defaultObject);
    }

    @Override
    public void setDefault(String name, boolean value) {
        this.defaultProps.putBoolean(name, value);
    }

    @Override
    public void setToDefault(String name) {
        String oldValue = this.getString(name);
        String defaultValue = this.getDefaultString(name);
        this.props.remove(name);
        if (!CommonUtils.equalObjects((Object)oldValue, (Object)defaultValue)) {
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, defaultValue);
        }
    }

    @Override
    public void setValue(String name, double value) {
        double oldValue = this.getDouble(name);
        if (oldValue == value) {
            return;
        }
        if (this.getDefaultDouble(name) == value) {
            this.props.remove(name);
        } else {
            this.props.putDouble(name, value);
        }
        this.dirty = true;
        this.firePropertyChangeEvent(name, new Double(oldValue), new Double(value));
    }

    @Override
    public void setValue(String name, float value) {
        float oldValue = this.getFloat(name);
        if (oldValue == value) {
            return;
        }
        if (this.getDefaultFloat(name) == value) {
            this.props.remove(name);
        } else {
            this.props.putFloat(name, value);
        }
        this.dirty = true;
        this.firePropertyChangeEvent(name, new Float(oldValue), new Float(value));
    }

    @Override
    public void setValue(String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue == value) {
            return;
        }
        if (this.getDefaultInt(name) == value) {
            this.props.remove(name);
        } else {
            this.props.putInt(name, value);
        }
        this.dirty = true;
        this.firePropertyChangeEvent(name, new Integer(oldValue), new Integer(value));
    }

    @Override
    public void setValue(String name, long value) {
        long oldValue = this.getLong(name);
        if (oldValue == value) {
            return;
        }
        if (this.getDefaultLong(name) == value) {
            this.props.remove(name);
        } else {
            this.props.putLong(name, value);
        }
        this.dirty = true;
        this.firePropertyChangeEvent(name, new Long(oldValue), new Long(value));
    }

    @Override
    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        if (CommonUtils.equalObjects((Object)oldValue, (Object)value)) {
            return;
        }
        if (this.getDefaultString(name).equals(value)) {
            this.props.remove(name);
        } else {
            this.props.put(name, value);
        }
        this.dirty = true;
        this.firePropertyChangeEvent(name, oldValue, value);
    }

    @Override
    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue == value) {
            return;
        }
        if (this.getDefaultBoolean(name) == value) {
            this.props.remove(name);
        } else {
            this.props.putBoolean(name, value);
        }
        this.dirty = true;
        this.firePropertyChangeEvent(name, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void save() throws IOException {
        try {
            this.props.flush();
            this.defaultProps.flush();
        }
        catch (BackingStoreException e) {
            throw new IOException(e);
        }
    }
}

