/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.List;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;

public class AdvertiseRefsHookChain
implements AdvertiseRefsHook {
    private final AdvertiseRefsHook[] hooks;
    private final int count;

    public static AdvertiseRefsHook newChain(List<? extends AdvertiseRefsHook> hooks) {
        AdvertiseRefsHook[] newHooks = new AdvertiseRefsHook[hooks.size()];
        int i = 0;
        for (AdvertiseRefsHook advertiseRefsHook : hooks) {
            if (advertiseRefsHook == AdvertiseRefsHook.DEFAULT) continue;
            newHooks[i++] = advertiseRefsHook;
        }
        if (i == 0) {
            return AdvertiseRefsHook.DEFAULT;
        }
        if (i == 1) {
            return newHooks[0];
        }
        return new AdvertiseRefsHookChain(newHooks, i);
    }

    @Override
    public void advertiseRefs(BaseReceivePack rp) throws ServiceMayNotContinueException {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].advertiseRefs(rp);
        }
    }

    @Override
    public void advertiseRefs(UploadPack rp) throws ServiceMayNotContinueException {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].advertiseRefs(rp);
        }
    }

    private AdvertiseRefsHookChain(AdvertiseRefsHook[] hooks, int count2) {
        this.hooks = hooks;
        this.count = count2;
    }
}

