/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Optional;
import javax.lang.model.element.Modifier;

@BugPattern(name="AutoValueFinalMethods", summary="Make toString(), hashCode() and equals() final in AutoValue classes, so it is clear to readers that AutoValue is not overriding them", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class AutoValueFinalMethods
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String MEMOIZED = "com.google.auto.value.extension.memoized.Memoized";
    private static final Matcher<MethodTree> METHOD_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.PUBLIC), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.ABSTRACT)), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.FINAL)), Matchers.not((Matcher)Matchers.hasAnnotation((String)"com.google.auto.value.extension.memoized.Memoized")), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.equalsMethodDeclaration(), Matchers.toStringMethodDeclaration(), Matchers.hashCodeMethodDeclaration()})});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!ASTHelpers.hasAnnotation((Tree)tree, (String)"com.google.auto.value.AutoValue", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (Tree tree2 : tree.getMembers()) {
            Optional optionalSuggestedFix;
            if (!(tree2 instanceof MethodTree) || !METHOD_MATCHER.matches((Tree)((MethodTree)tree2), state) || !(optionalSuggestedFix = SuggestedFixes.addModifiers((Tree)tree2, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL})).isPresent()) continue;
            fix.merge((SuggestedFix)optionalSuggestedFix.get());
        }
        if (!fix.isEmpty()) {
            return this.describeMatch(tree, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }
}

