(function() {
  var Grim, copyPathToClipboard, ipcRenderer, showCursorScope, showSyntaxTree, stopEventPropagation, stopEventPropagationAndGroupUndo;

  ipcRenderer = require('electron').ipcRenderer;

  Grim = require('grim');

  module.exports = function(arg) {
    var clipboard, commandInstaller, commandRegistry, config, notificationManager, project;
    commandRegistry = arg.commandRegistry, commandInstaller = arg.commandInstaller, config = arg.config, notificationManager = arg.notificationManager, project = arg.project, clipboard = arg.clipboard;
    commandRegistry.add('atom-workspace', {
      'pane:show-next-recently-used-item': function() {
        return this.getModel().getActivePane().activateNextRecentlyUsedItem();
      },
      'pane:show-previous-recently-used-item': function() {
        return this.getModel().getActivePane().activatePreviousRecentlyUsedItem();
      },
      'pane:move-active-item-to-top-of-stack': function() {
        return this.getModel().getActivePane().moveActiveItemToTopOfStack();
      },
      'pane:show-next-item': function() {
        return this.getModel().getActivePane().activateNextItem();
      },
      'pane:show-previous-item': function() {
        return this.getModel().getActivePane().activatePreviousItem();
      },
      'pane:show-item-1': function() {
        return this.getModel().getActivePane().activateItemAtIndex(0);
      },
      'pane:show-item-2': function() {
        return this.getModel().getActivePane().activateItemAtIndex(1);
      },
      'pane:show-item-3': function() {
        return this.getModel().getActivePane().activateItemAtIndex(2);
      },
      'pane:show-item-4': function() {
        return this.getModel().getActivePane().activateItemAtIndex(3);
      },
      'pane:show-item-5': function() {
        return this.getModel().getActivePane().activateItemAtIndex(4);
      },
      'pane:show-item-6': function() {
        return this.getModel().getActivePane().activateItemAtIndex(5);
      },
      'pane:show-item-7': function() {
        return this.getModel().getActivePane().activateItemAtIndex(6);
      },
      'pane:show-item-8': function() {
        return this.getModel().getActivePane().activateItemAtIndex(7);
      },
      'pane:show-item-9': function() {
        return this.getModel().getActivePane().activateLastItem();
      },
      'pane:move-item-right': function() {
        return this.getModel().getActivePane().moveItemRight();
      },
      'pane:move-item-left': function() {
        return this.getModel().getActivePane().moveItemLeft();
      },
      'window:increase-font-size': function() {
        return this.getModel().increaseFontSize();
      },
      'window:decrease-font-size': function() {
        return this.getModel().decreaseFontSize();
      },
      'window:reset-font-size': function() {
        return this.getModel().resetFontSize();
      },
      'application:about': function() {
        return ipcRenderer.send('command', 'application:about');
      },
      'application:show-preferences': function() {
        return ipcRenderer.send('command', 'application:show-settings');
      },
      'application:show-settings': function() {
        return ipcRenderer.send('command', 'application:show-settings');
      },
      'application:quit': function() {
        return ipcRenderer.send('command', 'application:quit');
      },
      'application:hide': function() {
        return ipcRenderer.send('command', 'application:hide');
      },
      'application:hide-other-applications': function() {
        return ipcRenderer.send('command', 'application:hide-other-applications');
      },
      'application:install-update': function() {
        return ipcRenderer.send('command', 'application:install-update');
      },
      'application:unhide-all-applications': function() {
        return ipcRenderer.send('command', 'application:unhide-all-applications');
      },
      'application:new-window': function() {
        return ipcRenderer.send('command', 'application:new-window');
      },
      'application:new-file': function() {
        return ipcRenderer.send('command', 'application:new-file');
      },
      'application:open': function() {
        var defaultPath, ref, ref1, ref2;
        defaultPath = (ref = (ref1 = atom.workspace.getActiveTextEditor()) != null ? ref1.getPath() : void 0) != null ? ref : (ref2 = atom.project.getPaths()) != null ? ref2[0] : void 0;
        return ipcRenderer.send('open-chosen-any', defaultPath);
      },
      'application:open-file': function() {
        var defaultPath, ref, ref1, ref2;
        defaultPath = (ref = (ref1 = atom.workspace.getActiveTextEditor()) != null ? ref1.getPath() : void 0) != null ? ref : (ref2 = atom.project.getPaths()) != null ? ref2[0] : void 0;
        return ipcRenderer.send('open-chosen-file', defaultPath);
      },
      'application:open-folder': function() {
        var defaultPath, ref, ref1, ref2;
        defaultPath = (ref = (ref1 = atom.workspace.getActiveTextEditor()) != null ? ref1.getPath() : void 0) != null ? ref : (ref2 = atom.project.getPaths()) != null ? ref2[0] : void 0;
        return ipcRenderer.send('open-chosen-folder', defaultPath);
      },
      'application:open-dev': function() {
        return ipcRenderer.send('command', 'application:open-dev');
      },
      'application:open-safe': function() {
        return ipcRenderer.send('command', 'application:open-safe');
      },
      'application:add-project-folder': function() {
        return atom.addProjectFolder();
      },
      'application:minimize': function() {
        return ipcRenderer.send('command', 'application:minimize');
      },
      'application:zoom': function() {
        return ipcRenderer.send('command', 'application:zoom');
      },
      'application:bring-all-windows-to-front': function() {
        return ipcRenderer.send('command', 'application:bring-all-windows-to-front');
      },
      'application:open-your-config': function() {
        return ipcRenderer.send('command', 'application:open-your-config');
      },
      'application:open-your-init-script': function() {
        return ipcRenderer.send('command', 'application:open-your-init-script');
      },
      'application:open-your-keymap': function() {
        return ipcRenderer.send('command', 'application:open-your-keymap');
      },
      'application:open-your-snippets': function() {
        return ipcRenderer.send('command', 'application:open-your-snippets');
      },
      'application:open-your-stylesheet': function() {
        return ipcRenderer.send('command', 'application:open-your-stylesheet');
      },
      'application:open-license': function() {
        return this.getModel().openLicense();
      },
      'window:run-package-specs': function() {
        return this.runPackageSpecs();
      },
      'window:run-benchmarks': function() {
        return this.runBenchmarks();
      },
      'window:toggle-left-dock': function() {
        return this.getModel().getLeftDock().toggle();
      },
      'window:toggle-right-dock': function() {
        return this.getModel().getRightDock().toggle();
      },
      'window:toggle-bottom-dock': function() {
        return this.getModel().getBottomDock().toggle();
      },
      'window:focus-next-pane': function() {
        return this.getModel().activateNextPane();
      },
      'window:focus-previous-pane': function() {
        return this.getModel().activatePreviousPane();
      },
      'window:focus-pane-above': function() {
        return this.focusPaneViewAbove();
      },
      'window:focus-pane-below': function() {
        return this.focusPaneViewBelow();
      },
      'window:focus-pane-on-left': function() {
        return this.focusPaneViewOnLeft();
      },
      'window:focus-pane-on-right': function() {
        return this.focusPaneViewOnRight();
      },
      'window:move-active-item-to-pane-above': function() {
        return this.moveActiveItemToPaneAbove();
      },
      'window:move-active-item-to-pane-below': function() {
        return this.moveActiveItemToPaneBelow();
      },
      'window:move-active-item-to-pane-on-left': function() {
        return this.moveActiveItemToPaneOnLeft();
      },
      'window:move-active-item-to-pane-on-right': function() {
        return this.moveActiveItemToPaneOnRight();
      },
      'window:copy-active-item-to-pane-above': function() {
        return this.moveActiveItemToPaneAbove({
          keepOriginal: true
        });
      },
      'window:copy-active-item-to-pane-below': function() {
        return this.moveActiveItemToPaneBelow({
          keepOriginal: true
        });
      },
      'window:copy-active-item-to-pane-on-left': function() {
        return this.moveActiveItemToPaneOnLeft({
          keepOriginal: true
        });
      },
      'window:copy-active-item-to-pane-on-right': function() {
        return this.moveActiveItemToPaneOnRight({
          keepOriginal: true
        });
      },
      'window:save-all': function() {
        return this.getModel().saveAll();
      },
      'window:toggle-invisibles': function() {
        return config.set("editor.showInvisibles", !config.get("editor.showInvisibles"));
      },
      'window:log-deprecation-warnings': function() {
        return Grim.logDeprecations();
      },
      'window:toggle-auto-indent': function() {
        return config.set("editor.autoIndent", !config.get("editor.autoIndent"));
      },
      'pane:reopen-closed-item': function() {
        return this.getModel().reopenItem();
      },
      'core:close': function() {
        return this.getModel().closeActivePaneItemOrEmptyPaneOrWindow();
      },
      'core:save': function() {
        return this.getModel().saveActivePaneItem();
      },
      'core:save-as': function() {
        return this.getModel().saveActivePaneItemAs();
      }
    }, false);
    if (process.platform === 'darwin') {
      commandRegistry.add('atom-workspace', 'window:install-shell-commands', (function() {
        return commandInstaller.installShellCommandsInteractively();
      }), false);
    }
    commandRegistry.add('atom-pane', {
      'pane:save-items': function() {
        return this.getModel().saveItems();
      },
      'pane:split-left': function() {
        return this.getModel().splitLeft();
      },
      'pane:split-right': function() {
        return this.getModel().splitRight();
      },
      'pane:split-up': function() {
        return this.getModel().splitUp();
      },
      'pane:split-down': function() {
        return this.getModel().splitDown();
      },
      'pane:split-left-and-copy-active-item': function() {
        return this.getModel().splitLeft({
          copyActiveItem: true
        });
      },
      'pane:split-right-and-copy-active-item': function() {
        return this.getModel().splitRight({
          copyActiveItem: true
        });
      },
      'pane:split-up-and-copy-active-item': function() {
        return this.getModel().splitUp({
          copyActiveItem: true
        });
      },
      'pane:split-down-and-copy-active-item': function() {
        return this.getModel().splitDown({
          copyActiveItem: true
        });
      },
      'pane:split-left-and-move-active-item': function() {
        return this.getModel().splitLeft({
          moveActiveItem: true
        });
      },
      'pane:split-right-and-move-active-item': function() {
        return this.getModel().splitRight({
          moveActiveItem: true
        });
      },
      'pane:split-up-and-move-active-item': function() {
        return this.getModel().splitUp({
          moveActiveItem: true
        });
      },
      'pane:split-down-and-move-active-item': function() {
        return this.getModel().splitDown({
          moveActiveItem: true
        });
      },
      'pane:close': function() {
        return this.getModel().close();
      },
      'pane:close-other-items': function() {
        return this.getModel().destroyInactiveItems();
      },
      'pane:increase-size': function() {
        return this.getModel().increaseSize();
      },
      'pane:decrease-size': function() {
        return this.getModel().decreaseSize();
      }
    }, false);
    commandRegistry.add('atom-text-editor', stopEventPropagation({
      'core:move-left': function() {
        return this.moveLeft();
      },
      'core:move-right': function() {
        return this.moveRight();
      },
      'core:select-left': function() {
        return this.selectLeft();
      },
      'core:select-right': function() {
        return this.selectRight();
      },
      'core:select-up': function() {
        return this.selectUp();
      },
      'core:select-down': function() {
        return this.selectDown();
      },
      'core:select-all': function() {
        return this.selectAll();
      },
      'editor:select-word': function() {
        return this.selectWordsContainingCursors();
      },
      'editor:consolidate-selections': function(event) {
        if (!this.consolidateSelections()) {
          return event.abortKeyBinding();
        }
      },
      'editor:move-to-beginning-of-next-paragraph': function() {
        return this.moveToBeginningOfNextParagraph();
      },
      'editor:move-to-beginning-of-previous-paragraph': function() {
        return this.moveToBeginningOfPreviousParagraph();
      },
      'editor:move-to-beginning-of-screen-line': function() {
        return this.moveToBeginningOfScreenLine();
      },
      'editor:move-to-beginning-of-line': function() {
        return this.moveToBeginningOfLine();
      },
      'editor:move-to-end-of-screen-line': function() {
        return this.moveToEndOfScreenLine();
      },
      'editor:move-to-end-of-line': function() {
        return this.moveToEndOfLine();
      },
      'editor:move-to-first-character-of-line': function() {
        return this.moveToFirstCharacterOfLine();
      },
      'editor:move-to-beginning-of-word': function() {
        return this.moveToBeginningOfWord();
      },
      'editor:move-to-end-of-word': function() {
        return this.moveToEndOfWord();
      },
      'editor:move-to-beginning-of-next-word': function() {
        return this.moveToBeginningOfNextWord();
      },
      'editor:move-to-previous-word-boundary': function() {
        return this.moveToPreviousWordBoundary();
      },
      'editor:move-to-next-word-boundary': function() {
        return this.moveToNextWordBoundary();
      },
      'editor:move-to-previous-subword-boundary': function() {
        return this.moveToPreviousSubwordBoundary();
      },
      'editor:move-to-next-subword-boundary': function() {
        return this.moveToNextSubwordBoundary();
      },
      'editor:select-to-beginning-of-next-paragraph': function() {
        return this.selectToBeginningOfNextParagraph();
      },
      'editor:select-to-beginning-of-previous-paragraph': function() {
        return this.selectToBeginningOfPreviousParagraph();
      },
      'editor:select-to-end-of-line': function() {
        return this.selectToEndOfLine();
      },
      'editor:select-to-beginning-of-line': function() {
        return this.selectToBeginningOfLine();
      },
      'editor:select-to-end-of-word': function() {
        return this.selectToEndOfWord();
      },
      'editor:select-to-beginning-of-word': function() {
        return this.selectToBeginningOfWord();
      },
      'editor:select-to-beginning-of-next-word': function() {
        return this.selectToBeginningOfNextWord();
      },
      'editor:select-to-next-word-boundary': function() {
        return this.selectToNextWordBoundary();
      },
      'editor:select-to-previous-word-boundary': function() {
        return this.selectToPreviousWordBoundary();
      },
      'editor:select-to-next-subword-boundary': function() {
        return this.selectToNextSubwordBoundary();
      },
      'editor:select-to-previous-subword-boundary': function() {
        return this.selectToPreviousSubwordBoundary();
      },
      'editor:select-to-first-character-of-line': function() {
        return this.selectToFirstCharacterOfLine();
      },
      'editor:select-line': function() {
        return this.selectLinesContainingCursors();
      },
      'editor:select-larger-syntax-node': function() {
        return this.selectLargerSyntaxNode();
      },
      'editor:select-smaller-syntax-node': function() {
        return this.selectSmallerSyntaxNode();
      }
    }), false);
    commandRegistry.add('atom-text-editor:not([readonly])', stopEventPropagation({
      'core:undo': function() {
        return this.undo();
      },
      'core:redo': function() {
        return this.redo();
      }
    }), false);
    commandRegistry.add('atom-text-editor', stopEventPropagationAndGroupUndo(config, {
      'core:copy': function() {
        return this.copySelectedText();
      },
      'editor:copy-selection': function() {
        return this.copyOnlySelectedText();
      }
    }), false);
    commandRegistry.add('atom-text-editor:not([readonly])', stopEventPropagationAndGroupUndo(config, {
      'core:backspace': function() {
        return this.backspace();
      },
      'core:delete': function() {
        return this["delete"]();
      },
      'core:cut': function() {
        return this.cutSelectedText();
      },
      'core:paste': function() {
        return this.pasteText();
      },
      'editor:paste-without-reformatting': function() {
        return this.pasteText({
          normalizeLineEndings: false,
          autoIndent: false,
          preserveTrailingLineIndentation: true
        });
      },
      'editor:delete-to-previous-word-boundary': function() {
        return this.deleteToPreviousWordBoundary();
      },
      'editor:delete-to-next-word-boundary': function() {
        return this.deleteToNextWordBoundary();
      },
      'editor:delete-to-beginning-of-word': function() {
        return this.deleteToBeginningOfWord();
      },
      'editor:delete-to-beginning-of-line': function() {
        return this.deleteToBeginningOfLine();
      },
      'editor:delete-to-end-of-line': function() {
        return this.deleteToEndOfLine();
      },
      'editor:delete-to-end-of-word': function() {
        return this.deleteToEndOfWord();
      },
      'editor:delete-to-beginning-of-subword': function() {
        return this.deleteToBeginningOfSubword();
      },
      'editor:delete-to-end-of-subword': function() {
        return this.deleteToEndOfSubword();
      },
      'editor:delete-line': function() {
        return this.deleteLine();
      },
      'editor:cut-to-end-of-line': function() {
        return this.cutToEndOfLine();
      },
      'editor:cut-to-end-of-buffer-line': function() {
        return this.cutToEndOfBufferLine();
      },
      'editor:transpose': function() {
        return this.transpose();
      },
      'editor:upper-case': function() {
        return this.upperCase();
      },
      'editor:lower-case': function() {
        return this.lowerCase();
      }
    }), false);
    commandRegistry.add('atom-text-editor:not([mini])', stopEventPropagation({
      'core:move-up': function() {
        return this.moveUp();
      },
      'core:move-down': function() {
        return this.moveDown();
      },
      'core:move-to-top': function() {
        return this.moveToTop();
      },
      'core:move-to-bottom': function() {
        return this.moveToBottom();
      },
      'core:page-up': function() {
        return this.pageUp();
      },
      'core:page-down': function() {
        return this.pageDown();
      },
      'core:select-to-top': function() {
        return this.selectToTop();
      },
      'core:select-to-bottom': function() {
        return this.selectToBottom();
      },
      'core:select-page-up': function() {
        return this.selectPageUp();
      },
      'core:select-page-down': function() {
        return this.selectPageDown();
      },
      'editor:add-selection-below': function() {
        return this.addSelectionBelow();
      },
      'editor:add-selection-above': function() {
        return this.addSelectionAbove();
      },
      'editor:split-selections-into-lines': function() {
        return this.splitSelectionsIntoLines();
      },
      'editor:toggle-soft-tabs': function() {
        return this.toggleSoftTabs();
      },
      'editor:toggle-soft-wrap': function() {
        return this.toggleSoftWrapped();
      },
      'editor:fold-all': function() {
        return this.foldAll();
      },
      'editor:unfold-all': function() {
        return this.unfoldAll();
      },
      'editor:fold-current-row': function() {
        this.foldCurrentRow();
        return this.scrollToCursorPosition();
      },
      'editor:unfold-current-row': function() {
        this.unfoldCurrentRow();
        return this.scrollToCursorPosition();
      },
      'editor:fold-selection': function() {
        return this.foldSelectedLines();
      },
      'editor:fold-at-indent-level-1': function() {
        this.foldAllAtIndentLevel(0);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-2': function() {
        this.foldAllAtIndentLevel(1);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-3': function() {
        this.foldAllAtIndentLevel(2);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-4': function() {
        this.foldAllAtIndentLevel(3);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-5': function() {
        this.foldAllAtIndentLevel(4);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-6': function() {
        this.foldAllAtIndentLevel(5);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-7': function() {
        this.foldAllAtIndentLevel(6);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-8': function() {
        this.foldAllAtIndentLevel(7);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-9': function() {
        this.foldAllAtIndentLevel(8);
        return this.scrollToCursorPosition();
      },
      'editor:log-cursor-scope': function() {
        return showCursorScope(this.getCursorScope(), notificationManager);
      },
      'editor:log-cursor-syntax-tree-scope': function() {
        return showSyntaxTree(this.getCursorSyntaxTreeScope(), notificationManager);
      },
      'editor:copy-path': function() {
        return copyPathToClipboard(this, project, clipboard, false);
      },
      'editor:copy-project-path': function() {
        return copyPathToClipboard(this, project, clipboard, true);
      },
      'editor:toggle-indent-guide': function() {
        return config.set('editor.showIndentGuide', !config.get('editor.showIndentGuide'));
      },
      'editor:toggle-line-numbers': function() {
        return config.set('editor.showLineNumbers', !config.get('editor.showLineNumbers'));
      },
      'editor:scroll-to-cursor': function() {
        return this.scrollToCursorPosition();
      }
    }), false);
    return commandRegistry.add('atom-text-editor:not([mini]):not([readonly])', stopEventPropagationAndGroupUndo(config, {
      'editor:indent': function() {
        return this.indent();
      },
      'editor:auto-indent': function() {
        return this.autoIndentSelectedRows();
      },
      'editor:indent-selected-rows': function() {
        return this.indentSelectedRows();
      },
      'editor:outdent-selected-rows': function() {
        return this.outdentSelectedRows();
      },
      'editor:newline': function() {
        return this.insertNewline();
      },
      'editor:newline-below': function() {
        return this.insertNewlineBelow();
      },
      'editor:newline-above': function() {
        return this.insertNewlineAbove();
      },
      'editor:toggle-line-comments': function() {
        return this.toggleLineCommentsInSelection();
      },
      'editor:checkout-head-revision': function() {
        return atom.workspace.checkoutHeadRevision(this);
      },
      'editor:move-line-up': function() {
        return this.moveLineUp();
      },
      'editor:move-line-down': function() {
        return this.moveLineDown();
      },
      'editor:move-selection-left': function() {
        return this.moveSelectionLeft();
      },
      'editor:move-selection-right': function() {
        return this.moveSelectionRight();
      },
      'editor:duplicate-lines': function() {
        return this.duplicateLines();
      },
      'editor:join-lines': function() {
        return this.joinLines();
      }
    }), false);
  };

  stopEventPropagation = function(commandListeners) {
    var commandListener, commandName, fn, newCommandListeners;
    newCommandListeners = {};
    fn = function(commandListener) {
      return newCommandListeners[commandName] = function(event) {
        event.stopPropagation();
        return commandListener.call(this.getModel(), event);
      };
    };
    for (commandName in commandListeners) {
      commandListener = commandListeners[commandName];
      fn(commandListener);
    }
    return newCommandListeners;
  };

  stopEventPropagationAndGroupUndo = function(config, commandListeners) {
    var commandListener, commandName, fn, newCommandListeners;
    newCommandListeners = {};
    fn = function(commandListener) {
      return newCommandListeners[commandName] = function(event) {
        var model;
        event.stopPropagation();
        model = this.getModel();
        return model.transact(model.getUndoGroupingInterval(), function() {
          return commandListener.call(model, event);
        });
      };
    };
    for (commandName in commandListeners) {
      commandListener = commandListeners[commandName];
      fn(commandListener);
    }
    return newCommandListeners;
  };

  showCursorScope = function(descriptor, notificationManager) {
    var content, list;
    list = descriptor.scopes.toString().split(',');
    list = list.map(function(item) {
      return "* " + item;
    });
    content = "Scopes at Cursor\n" + (list.join('\n'));
    return notificationManager.addInfo(content, {
      dismissable: true
    });
  };

  showSyntaxTree = function(descriptor, notificationManager) {
    var content, list;
    list = descriptor.scopes.toString().split(',');
    list = list.map(function(item) {
      return "* " + item;
    });
    content = "Syntax tree at Cursor\n" + (list.join('\n'));
    return notificationManager.addInfo(content, {
      dismissable: true
    });
  };

  copyPathToClipboard = function(editor, project, clipboard, relative) {
    var filePath;
    if (filePath = editor.getPath()) {
      if (relative) {
        filePath = project.relativize(filePath);
      }
      return clipboard.write(filePath);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
