Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _keybindingsPanel = require('./keybindings-panel');

var _keybindingsPanel2 = _interopRequireDefault(_keybindingsPanel);

// Displays the keybindings for a package namespace

var PackageKeymapView = (function () {
  function PackageKeymapView(pack) {
    var _this = this;

    _classCallCheck(this, PackageKeymapView);

    this.pack = pack;
    this.otherPlatformPattern = new RegExp('\\.platform-(?!' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b)');
    this.namespace = this.pack.name;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);

    var packagesWithKeymapsDisabled = atom.config.get('core.packagesWithKeymapsDisabled') || [];
    this.refs.keybindingToggle.checked = !packagesWithKeymapsDisabled.includes(this.namespace);

    var changeHandler = function changeHandler(event) {
      event.stopPropagation();
      var value = _this.refs.keybindingToggle.checked;
      if (value) {
        atom.config.removeAtKeyPath('core.packagesWithKeymapsDisabled', _this.namespace);
      } else {
        atom.config.pushAtKeyPath('core.packagesWithKeymapsDisabled', _this.namespace);
      }

      _this.updateKeyBindingView();
    };
    this.refs.keybindingToggle.addEventListener('change', changeHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.keybindingToggle.removeEventListener('change', changeHandler);
    }));

    var copyIconClickHandler = function copyIconClickHandler(event) {
      var target = event.target.closest('.copy-icon');
      if (target) {
        event.preventDefault();
        event.stopPropagation();
        _this.writeKeyBindingToClipboard(target.closest('tr').dataset);
      }
    };
    this.element.addEventListener('click', copyIconClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('click', copyIconClickHandler);
    }));

    this.updateKeyBindingView();

    var hasKeymaps = false;
    // eslint-disable-next-line no-unused-vars
    for (var _ref3 of atom.packages.getLoadedPackage(this.namespace).keymaps) {
      var _ref2 = _slicedToArray(_ref3, 2);

      var packageKeymapsPath = _ref2[0];
      var keymap = _ref2[1];

      if (keymap.length > 0) {
        hasKeymaps = true;
        break;
      }
    }

    if (this.refs.keybindingItems.children.length === 0 && !hasKeymaps) {
      this.element.style.display = 'none';
    }
  }

  _createClass(PackageKeymapView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'section',
        { className: 'section' },
        _etch2['default'].dom(
          'div',
          { className: 'section-heading icon icon-keyboard' },
          'Keybindings'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'checkbox' },
          _etch2['default'].dom(
            'label',
            { 'for': 'toggleKeybindings' },
            _etch2['default'].dom('input', { id: 'toggleKeybindings', className: 'input-checkbox', type: 'checkbox', ref: 'keybindingToggle' }),
            _etch2['default'].dom(
              'div',
              { className: 'setting-title' },
              'Enable'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'setting-description' },
            "Disable this if you want to bind your own keystrokes for this package's commands in your keymap."
          )
        ),
        _etch2['default'].dom(
          'table',
          { className: 'package-keymap-table table native-key-bindings text', tabIndex: '-1' },
          _etch2['default'].dom(
            'thead',
            null,
            _etch2['default'].dom(
              'tr',
              null,
              _etch2['default'].dom(
                'th',
                null,
                'Keystroke'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Command'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Selector'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Source'
              )
            )
          ),
          _etch2['default'].dom('tbody', { ref: 'keybindingItems' })
        )
      );
    }
  }, {
    key: 'updateKeyBindingView',
    value: function updateKeyBindingView() {
      this.refs.keybindingItems.innerHTML = '';

      var packagesWithKeymapsDisabled = atom.config.get('core.packagesWithKeymapsDisabled') || [];
      var keybindingsDisabled = packagesWithKeymapsDisabled.includes(this.namespace);
      if (keybindingsDisabled) {
        this.refs.keybindingItems.classList.add('text-subtle');
      } else {
        this.refs.keybindingItems.classList.remove('text-subtle');
      }

      var keyBindings = [];
      if (atom.keymaps.build) {
        // eslint-disable-next-line no-unused-vars
        for (var _ref43 of atom.packages.getLoadedPackage(this.namespace).keymaps) {
          var _ref42 = _slicedToArray(_ref43, 2);

          var keymapPath = _ref42[0];
          var keymap = _ref42[1];

          keyBindings.push.apply(keyBindings, _toConsumableArray(atom.keymaps.build(this.namespace, keymap, 0, false)));
        }
      } else {
        // Backwards compatibility for Atom <= 1.19
        for (var keyBinding of atom.keymaps.getKeyBindings()) {
          var command = keyBinding.command;

          if (command && command.indexOf && command.indexOf(this.namespace + ':') === 0) {
            keyBindings.push(keyBinding);
          }
        }
      }

      for (var keyBinding of keyBindings) {
        var command = keyBinding.command;
        var keystrokes = keyBinding.keystrokes;
        var selector = keyBinding.selector;
        var source = keyBinding.source;

        if (!command) {
          continue;
        }

        if (this.otherPlatformPattern.test(selector)) {
          continue;
        }

        var keyBindingRow = document.createElement('tr');
        keyBindingRow.dataset.selector = selector;
        keyBindingRow.dataset.keystrokes = keystrokes;
        keyBindingRow.dataset.command = command;

        var keystrokesTd = document.createElement('td');

        var copyIconSpan = document.createElement('span');
        copyIconSpan.classList.add('icon', 'icon-clippy', 'copy-icon');
        keystrokesTd.appendChild(copyIconSpan);

        var keystrokesSpan = document.createElement('span');
        keystrokesSpan.textContent = keystrokes;
        keystrokesTd.appendChild(keystrokesSpan);

        keyBindingRow.appendChild(keystrokesTd);

        var commandTd = document.createElement('td');
        commandTd.textContent = command;
        keyBindingRow.appendChild(commandTd);

        var selectorTd = document.createElement('td');
        selectorTd.textContent = selector;
        keyBindingRow.appendChild(selectorTd);

        var sourceTd = document.createElement('td');
        sourceTd.textContent = _keybindingsPanel2['default'].determineSource(source);
        keyBindingRow.appendChild(sourceTd);

        this.refs.keybindingItems.appendChild(keyBindingRow);
      }
    }
  }, {
    key: 'writeKeyBindingToClipboard',
    value: function writeKeyBindingToClipboard(_ref5) {
      var selector = _ref5.selector;
      var keystrokes = _ref5.keystrokes;
      var command = _ref5.command;

      var content = undefined;
      var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
      if (keymapExtension === '.cson') {
        content = '\'' + selector + '\':\n  \'' + keystrokes + '\': \'' + command + '\'';
      } else {
        content = '"' + selector + '": {\n  "' + keystrokes + '": "' + command + '"\n}';
      }

      atom.clipboard.write(content);
    }
  }]);

  return PackageKeymapView;
})();

exports['default'] = PackageKeymapView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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