(function() {
  var CompositeDisposable, Disposable, Emitter, NotificationsLogItem, moment, ref;

  ref = require('atom'), Emitter = ref.Emitter, CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable;

  moment = require('moment');

  module.exports = NotificationsLogItem = (function() {
    NotificationsLogItem.prototype.subscriptions = null;

    NotificationsLogItem.prototype.timestampInterval = null;

    function NotificationsLogItem(notification) {
      this.notification = notification;
      this.emitter = new Emitter;
      this.subscriptions = new CompositeDisposable;
      this.render();
    }

    NotificationsLogItem.prototype.render = function() {
      var notificationElement, notificationView;
      notificationView = atom.views.getView(this.notification);
      notificationElement = this.renderNotification(notificationView);
      this.timestamp = document.createElement('div');
      this.timestamp.classList.add('timestamp');
      this.notification.moment = moment(this.notification.getTimestamp());
      this.subscriptions.add(atom.tooltips.add(this.timestamp, {
        title: this.notification.moment.format("ll LTS")
      }));
      this.updateTimestamp();
      this.timestampInterval = setInterval(this.updateTimestamp.bind(this), 60 * 1000);
      this.subscriptions.add(new Disposable((function(_this) {
        return function() {
          return clearInterval(_this.timestampInterval);
        };
      })(this)));
      this.element = document.createElement('li');
      this.element.classList.add('notifications-log-item', this.notification.getType());
      this.element.appendChild(notificationElement);
      this.element.appendChild(this.timestamp);
      this.element.addEventListener('click', (function(_this) {
        return function(e) {
          if (e.target.closest('.btn-toolbar a, .btn-toolbar button') == null) {
            return _this.emitter.emit('click');
          }
        };
      })(this));
      this.element.getRenderPromise = function() {
        return notificationView.getRenderPromise();
      };
      if (this.notification.getType() === 'fatal') {
        notificationView.getRenderPromise().then((function(_this) {
          return function() {
            return _this.element.replaceChild(_this.renderNotification(notificationView), notificationElement);
          };
        })(this));
      }
      return this.subscriptions.add(new Disposable((function(_this) {
        return function() {
          return _this.element.remove();
        };
      })(this)));
    };

    NotificationsLogItem.prototype.renderNotification = function(view) {
      var button, buttons, i, j, len, len1, logButton, message, nButtons, nElement, ref1, ref2, tooltip;
      message = document.createElement('div');
      message.classList.add('message');
      message.innerHTML = view.element.querySelector(".content > .message").innerHTML;
      buttons = document.createElement('div');
      buttons.classList.add('btn-toolbar');
      nButtons = view.element.querySelector(".content > .meta > .btn-toolbar");
      if (nButtons != null) {
        ref1 = nButtons.children;
        for (i = 0, len = ref1.length; i < len; i++) {
          button = ref1[i];
          logButton = button.cloneNode(true);
          logButton.originalButton = button;
          logButton.addEventListener('click', function(e) {
            var newEvent;
            newEvent = new MouseEvent('click', e);
            return e.target.originalButton.dispatchEvent(newEvent);
          });
          ref2 = atom.tooltips.findTooltips(button);
          for (j = 0, len1 = ref2.length; j < len1; j++) {
            tooltip = ref2[j];
            this.subscriptions.add(atom.tooltips.add(logButton, tooltip.options));
          }
          buttons.appendChild(logButton);
        }
      }
      nElement = document.createElement('div');
      nElement.classList.add('notifications-log-notification', 'icon', "icon-" + (this.notification.getIcon()), this.notification.getType());
      nElement.appendChild(message);
      nElement.appendChild(buttons);
      return nElement;
    };

    NotificationsLogItem.prototype.getElement = function() {
      return this.element;
    };

    NotificationsLogItem.prototype.destroy = function() {
      this.subscriptions.dispose();
      return this.emitter.emit('did-destroy');
    };

    NotificationsLogItem.prototype.onClick = function(callback) {
      return this.emitter.on('click', callback);
    };

    NotificationsLogItem.prototype.onDidDestroy = function(callback) {
      return this.emitter.on('did-destroy', callback);
    };

    NotificationsLogItem.prototype.updateTimestamp = function() {
      return this.timestamp.textContent = this.notification.moment.fromNow();
    };

    return NotificationsLogItem;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
