"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BarePullRequestDetailView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _reactTabs = require("react-tabs");

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

var _periodicRefresher = _interopRequireDefault(require("../periodic-refresher"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _prChangedFilesContainer = _interopRequireDefault(require("../containers/pr-changed-files-container"));

var _prCheckoutController = require("../controllers/pr-checkout-controller");

var _prTimelineController = _interopRequireDefault(require("../controllers/pr-timeline-controller"));

var _emojiReactionsController = _interopRequireDefault(require("../controllers/emoji-reactions-controller"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../views/github-dotcom-markdown"));

var _issueishBadge = _interopRequireDefault(require("../views/issueish-badge"));

var _checkoutButton = _interopRequireDefault(require("./checkout-button"));

var _prCommitsView = _interopRequireDefault(require("../views/pr-commits-view"));

var _prStatusesView = _interopRequireDefault(require("../views/pr-statuses-view"));

var _reviewsFooterView = _interopRequireDefault(require("../views/reviews-footer-view"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BarePullRequestDetailView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      refreshing: false
    });

    _defineProperty(this, "handleRefreshClick", e => {
      e.preventDefault();
      this.refresher.refreshNow(true);
    });

    _defineProperty(this, "recordOpenInBrowserEvent", () => {
      (0, _reporterProxy.addEvent)('open-pull-request-in-browser', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "onTabSelected", index => {
      this.props.onTabSelected(index);
      const eventName = ['open-pr-tab-overview', 'open-pr-tab-build-status', 'open-pr-tab-commits', 'open-pr-tab-files-changed'][index];
      (0, _reporterProxy.addEvent)(eventName, {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "refresh", () => {
      if (this.state.refreshing) {
        return;
      }

      this.setState({
        refreshing: true
      });
      this.props.relay.refetch({
        repoId: this.props.repository.id,
        issueishId: this.props.pullRequest.id,
        timelineCount: _helpers.PAGE_SIZE,
        timelineCursor: null,
        commitCount: _helpers.PAGE_SIZE,
        commitCursor: null
      }, null, () => {
        this.setState({
          refreshing: false
        });
      }, {
        force: true
      });
    });
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher["default"](BarePullRequestDetailView, {
      interval: () => 5 * 60 * 1000,
      getCurrentId: () => this.props.pullRequest.id,
      refresh: this.refresh,
      minimumIntervalPerId: 2 * 60 * 1000
    }); // auto-refresh disabled for now until pagination is handled
    // this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  renderPrMetadata(pullRequest, repo) {
    const author = this.getAuthor(pullRequest);
    return _react["default"].createElement("span", {
      className: "github-IssueishDetailView-meta"
    }, _react["default"].createElement("code", {
      className: "github-IssueishDetailView-baseRefName"
    }, pullRequest.isCrossRepository ? `${repo.owner.login}/${pullRequest.baseRefName}` : pullRequest.baseRefName), ' ‹ ', _react["default"].createElement("code", {
      className: "github-IssueishDetailView-headRefName"
    }, pullRequest.isCrossRepository ? `${author.login}/${pullRequest.headRefName}` : pullRequest.headRefName));
  }

  renderPullRequestBody(pullRequest) {
    const onBranch = this.props.checkoutOp.why() === _prCheckoutController.checkoutStates.CURRENT;

    return _react["default"].createElement(_reactTabs.Tabs, {
      selectedIndex: this.props.selectedTab,
      onSelect: this.onTabSelected
    }, _react["default"].createElement(_reactTabs.TabList, {
      className: "github-IssueishDetailView-tablist"
    }, _react["default"].createElement(_reactTabs.Tab, {
      className: "github-IssueishDetailView-tab"
    }, _react["default"].createElement(_octicon["default"], {
      icon: "info",
      className: "github-IssueishDetailView-tab-icon"
    }), "Overview"), _react["default"].createElement(_reactTabs.Tab, {
      className: "github-IssueishDetailView-tab"
    }, _react["default"].createElement(_octicon["default"], {
      icon: "checklist",
      className: "github-IssueishDetailView-tab-icon"
    }), "Build Status"), _react["default"].createElement(_reactTabs.Tab, {
      className: "github-IssueishDetailView-tab"
    }, _react["default"].createElement(_octicon["default"], {
      icon: "git-commit",
      className: "github-IssueishDetailView-tab-icon"
    }), "Commits", _react["default"].createElement("span", {
      className: "github-IssueishDetailView-tab-count"
    }, pullRequest.countedCommits.totalCount)), _react["default"].createElement(_reactTabs.Tab, {
      className: "github-IssueishDetailView-tab"
    }, _react["default"].createElement(_octicon["default"], {
      icon: "diff",
      className: "github-IssueishDetailView-tab-icon"
    }), "Files", _react["default"].createElement("span", {
      className: "github-IssueishDetailView-tab-count"
    }, pullRequest.changedFiles))), _react["default"].createElement(_reactTabs.TabPanel, null, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-overview"
    }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
      html: pullRequest.bodyHTML || '<em>No description provided.</em>',
      switchToIssueish: this.props.switchToIssueish
    }), _react["default"].createElement(_emojiReactionsController["default"], {
      reactable: pullRequest,
      tooltips: this.props.tooltips,
      reportMutationErrors: this.props.reportMutationErrors
    }), _react["default"].createElement(_prTimelineController["default"], {
      onBranch: onBranch,
      openCommit: this.props.openCommit,
      pullRequest: pullRequest,
      switchToIssueish: this.props.switchToIssueish
    }))), _react["default"].createElement(_reactTabs.TabPanel, null, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-buildStatus"
    }, _react["default"].createElement(_prStatusesView["default"], {
      pullRequest: pullRequest,
      displayType: "full"
    }))), _react["default"].createElement(_reactTabs.TabPanel, null, _react["default"].createElement(_prCommitsView["default"], {
      pullRequest: pullRequest,
      onBranch: onBranch,
      openCommit: this.props.openCommit
    })), _react["default"].createElement(_reactTabs.TabPanel, {
      className: "github-IssueishDetailView-filesChanged"
    }, _react["default"].createElement(_prChangedFilesContainer["default"], {
      localRepository: this.props.localRepository,
      owner: this.props.repository.owner.login,
      repo: this.props.repository.name,
      number: pullRequest.number,
      endpoint: this.props.endpoint,
      token: this.props.token,
      reviewCommentsLoading: this.props.reviewCommentsLoading,
      reviewCommentThreads: this.props.reviewCommentThreads,
      workspace: this.props.workspace,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,
      workdirPath: this.props.workdirPath,
      itemType: this.props.itemType,
      refEditor: this.props.refEditor,
      destroy: this.props.destroy,
      shouldRefetch: this.state.refreshing,
      switchToIssueish: this.props.switchToIssueish,
      pullRequest: this.props.pullRequest,
      initChangedFilePath: this.props.initChangedFilePath,
      initChangedFilePosition: this.props.initChangedFilePosition,
      onOpenFilesTab: this.props.onOpenFilesTab
    })));
  }

  render() {
    const repo = this.props.repository;
    const pullRequest = this.props.pullRequest;
    const author = this.getAuthor(pullRequest);
    return _react["default"].createElement("div", {
      className: "github-IssueishDetailView native-key-bindings"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-container"
    }, _react["default"].createElement("header", {
      className: "github-IssueishDetailView-header"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-avatar",
      href: author.url
    }, _react["default"].createElement("img", {
      className: "github-IssueishDetailView-avatarImage",
      src: author.avatarUrl,
      title: author.login,
      alt: author.login
    }))), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn is-flexible"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow is-fullwidth"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-title",
      href: pullRequest.url
    }, pullRequest.title)), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow"
    }, _react["default"].createElement(_issueishBadge["default"], {
      className: "github-IssueishDetailView-headerBadge",
      type: pullRequest.__typename,
      state: pullRequest.state
    }), _react["default"].createElement(_octicon["default"], {
      icon: "repo-sync",
      className: (0, _classnames["default"])('github-IssueishDetailView-headerRefreshButton', {
        refreshing: this.state.refreshing
      }),
      onClick: this.handleRefreshClick
    }), _react["default"].createElement("a", {
      className: "github-IssueishDetailView-headerLink",
      title: "open on GitHub.com",
      href: pullRequest.url,
      onClick: this.recordOpenInBrowserEvent
    }, repo.owner.login, "/", repo.name, "#", pullRequest.number), _react["default"].createElement("span", {
      className: "github-IssueishDetailView-headerStatus"
    }, _react["default"].createElement(_prStatusesView["default"], {
      pullRequest: pullRequest,
      displayType: "check"
    }))), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow"
    }, this.renderPrMetadata(pullRequest, repo))), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn"
    }, _react["default"].createElement(_checkoutButton["default"], {
      checkoutOp: this.props.checkoutOp,
      classNamePrefix: "github-IssueishDetailView-checkoutButton--",
      classNames: ['github-IssueishDetailView-checkoutButton']
    }))), this.renderPullRequestBody(pullRequest), _react["default"].createElement(_reviewsFooterView["default"], {
      commentsResolved: this.props.reviewCommentsResolvedCount,
      totalComments: this.props.reviewCommentsTotalCount,
      openReviews: this.props.openReviews,
      pullRequestURL: `${this.props.pullRequest.url}/files`
    })));
  }

  getAuthor(pullRequest) {
    return pullRequest.author || _helpers.GHOST_USER;
  }

}

exports.BarePullRequestDetailView = BarePullRequestDetailView;

_defineProperty(BarePullRequestDetailView, "propTypes", {
  // Relay response
  relay: _propTypes["default"].shape({
    refetch: _propTypes["default"].func.isRequired
  }),
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    name: _propTypes["default"].string.isRequired,
    owner: _propTypes["default"].shape({
      login: _propTypes["default"].string
    })
  }),
  pullRequest: _propTypes["default"].shape({
    __typename: _propTypes["default"].string.isRequired,
    id: _propTypes["default"].string.isRequired,
    title: _propTypes["default"].string,
    countedCommits: _propTypes["default"].shape({
      totalCount: _propTypes["default"].number.isRequired
    }).isRequired,
    isCrossRepository: _propTypes["default"].bool,
    changedFiles: _propTypes["default"].number.isRequired,
    url: _propTypes["default"].string.isRequired,
    bodyHTML: _propTypes["default"].string,
    number: _propTypes["default"].number,
    state: _propTypes["default"].oneOf(['OPEN', 'CLOSED', 'MERGED']).isRequired,
    author: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired,
      avatarUrl: _propTypes["default"].string.isRequired,
      url: _propTypes["default"].string.isRequired
    })
  }).isRequired,
  // Local model objects
  localRepository: _propTypes["default"].object.isRequired,
  checkoutOp: _propTypes2.EnableableOperationPropType.isRequired,
  workdirPath: _propTypes["default"].string,
  // Review comment threads
  reviewCommentsLoading: _propTypes["default"].bool.isRequired,
  reviewCommentsTotalCount: _propTypes["default"].number.isRequired,
  reviewCommentsResolvedCount: _propTypes["default"].number.isRequired,
  reviewCommentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })).isRequired,
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action functions
  openCommit: _propTypes["default"].func.isRequired,
  openReviews: _propTypes["default"].func.isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired,
  destroy: _propTypes["default"].func.isRequired,
  reportMutationErrors: _propTypes["default"].func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired,
  // Tab management
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  selectedTab: _propTypes["default"].number.isRequired,
  onTabSelected: _propTypes["default"].func.isRequired,
  onOpenFilesTab: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createRefetchContainer)(BarePullRequestDetailView, {
  repository: function () {
    const node = require("./__generated__/prDetailView_repository.graphql");

    if (node.hash && node.hash !== "3f3d61ddd6afa1c9e0811c3b5be51bb0") {
      console.error("The definition of 'prDetailView_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prDetailView_repository.graphql");
  },
  pullRequest: function () {
    const node = require("./__generated__/prDetailView_pullRequest.graphql");

    if (node.hash && node.hash !== "3fc00d1cf0c2c3906259c3dbd88952e6") {
      console.error("The definition of 'prDetailView_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prDetailView_pullRequest.graphql");
  }
}, function () {
  const node = require("./__generated__/prDetailViewRefetchQuery.graphql");

  if (node.hash && node.hash !== "04dad90234c09010553beb02cf90cbb1") {
    console.error("The definition of 'prDetailViewRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/prDetailViewRefetchQuery.graphql");
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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