"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class DonutChart extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderArc');
  }

  render() {
    const _this$props = this.props,
          {
      slices,
      baseOffset
    } = _this$props,
          others = _objectWithoutProperties(_this$props, ["slices", "baseOffset"]); // eslint-disable-line no-unused-vars


    const arcs = this.calculateArcs(slices);
    return _react["default"].createElement("svg", others, arcs.map(this.renderArc));
  }

  calculateArcs(slices) {
    const total = slices.reduce((acc, item) => acc + item.count, 0);
    let lengthSoFar = 0;
    return slices.map((_ref) => {
      let {
        count
      } = _ref,
          others = _objectWithoutProperties(_ref, ["count"]);

      const piece = _objectSpread({
        length: count / total * 100,
        position: lengthSoFar
      }, others);

      lengthSoFar += piece.length;
      return piece;
    });
  }

  renderArc({
    length,
    position,
    type,
    className
  }) {
    return _react["default"].createElement("circle", {
      key: type,
      cx: "21",
      cy: "21",
      r: "15.91549430918954",
      fill: "transparent",
      className: `donut-ring-${type}`,
      pathLength: "100",
      strokeWidth: "3",
      strokeDasharray: `${length} ${100 - length}`,
      strokeDashoffset: `${100 - position + this.props.baseOffset}`
    });
  }

}

exports["default"] = DonutChart;

_defineProperty(DonutChart, "propTypes", {
  baseOffset: _propTypes["default"].number,
  slices: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    type: _propTypes["default"].string,
    className: _propTypes["default"].string,
    count: _propTypes["default"].number
  }))
});

_defineProperty(DonutChart, "defaultProps", {
  baseOffset: 25
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImRvbnV0LWNoYXJ0LmpzIl0sIm5hbWVzIjpbIkRvbnV0Q2hhcnQiLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJyZW5kZXIiLCJzbGljZXMiLCJiYXNlT2Zmc2V0Iiwib3RoZXJzIiwiYXJjcyIsImNhbGN1bGF0ZUFyY3MiLCJtYXAiLCJyZW5kZXJBcmMiLCJ0b3RhbCIsInJlZHVjZSIsImFjYyIsIml0ZW0iLCJjb3VudCIsImxlbmd0aFNvRmFyIiwicGllY2UiLCJsZW5ndGgiLCJwb3NpdGlvbiIsInR5cGUiLCJjbGFzc05hbWUiLCJQcm9wVHlwZXMiLCJudW1iZXIiLCJhcnJheU9mIiwic2hhcGUiLCJzdHJpbmciXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFFQTs7Ozs7Ozs7Ozs7O0FBRWUsTUFBTUEsVUFBTixTQUF5QkMsa0JBQU1DLFNBQS9CLENBQXlDO0FBZ0J0REMsRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVE7QUFDakIsVUFBTUEsS0FBTjtBQUNBLDJCQUFTLElBQVQsRUFBZSxXQUFmO0FBQ0Q7O0FBRURDLEVBQUFBLE1BQU0sR0FBRztBQUNQLHdCQUF3QyxLQUFLRCxLQUE3QztBQUFBLFVBQU07QUFBQ0UsTUFBQUEsTUFBRDtBQUFTQyxNQUFBQTtBQUFULEtBQU47QUFBQSxVQUE4QkMsTUFBOUIsbUVBRE8sQ0FDNkM7OztBQUNwRCxVQUFNQyxJQUFJLEdBQUcsS0FBS0MsYUFBTCxDQUFtQkosTUFBbkIsQ0FBYjtBQUVBLFdBQ0UsdUNBQVNFLE1BQVQsRUFDR0MsSUFBSSxDQUFDRSxHQUFMLENBQVMsS0FBS0MsU0FBZCxDQURILENBREY7QUFLRDs7QUFFREYsRUFBQUEsYUFBYSxDQUFDSixNQUFELEVBQVM7QUFDcEIsVUFBTU8sS0FBSyxHQUFHUCxNQUFNLENBQUNRLE1BQVAsQ0FBYyxDQUFDQyxHQUFELEVBQU1DLElBQU4sS0FBZUQsR0FBRyxHQUFHQyxJQUFJLENBQUNDLEtBQXhDLEVBQStDLENBQS9DLENBQWQ7QUFDQSxRQUFJQyxXQUFXLEdBQUcsQ0FBbEI7QUFFQSxXQUFPWixNQUFNLENBQUNLLEdBQVAsQ0FBVyxVQUF3QjtBQUFBLFVBQXZCO0FBQUNNLFFBQUFBO0FBQUQsT0FBdUI7QUFBQSxVQUFaVCxNQUFZOztBQUN4QyxZQUFNVyxLQUFLO0FBQ1RDLFFBQUFBLE1BQU0sRUFBRUgsS0FBSyxHQUFHSixLQUFSLEdBQWdCLEdBRGY7QUFFVFEsUUFBQUEsUUFBUSxFQUFFSDtBQUZELFNBR05WLE1BSE0sQ0FBWDs7QUFLQVUsTUFBQUEsV0FBVyxJQUFJQyxLQUFLLENBQUNDLE1BQXJCO0FBQ0EsYUFBT0QsS0FBUDtBQUNELEtBUk0sQ0FBUDtBQVNEOztBQUVEUCxFQUFBQSxTQUFTLENBQUM7QUFBQ1EsSUFBQUEsTUFBRDtBQUFTQyxJQUFBQSxRQUFUO0FBQW1CQyxJQUFBQSxJQUFuQjtBQUF5QkMsSUFBQUE7QUFBekIsR0FBRCxFQUFzQztBQUM3QyxXQUNFO0FBQ0UsTUFBQSxHQUFHLEVBQUVELElBRFA7QUFFRSxNQUFBLEVBQUUsRUFBQyxJQUZMO0FBR0UsTUFBQSxFQUFFLEVBQUMsSUFITDtBQUlFLE1BQUEsQ0FBQyxFQUFDLG1CQUpKO0FBS0UsTUFBQSxJQUFJLEVBQUMsYUFMUDtBQU1FLE1BQUEsU0FBUyxFQUFHLGNBQWFBLElBQUssRUFOaEM7QUFPRSxNQUFBLFVBQVUsRUFBQyxLQVBiO0FBUUUsTUFBQSxXQUFXLEVBQUMsR0FSZDtBQVNFLE1BQUEsZUFBZSxFQUFHLEdBQUVGLE1BQU8sSUFBRyxNQUFNQSxNQUFPLEVBVDdDO0FBVUUsTUFBQSxnQkFBZ0IsRUFBRyxHQUFFLE1BQU1DLFFBQU4sR0FBaUIsS0FBS2pCLEtBQUwsQ0FBV0csVUFBVztBQVY5RCxNQURGO0FBY0Q7O0FBOURxRDs7OztnQkFBbkNQLFUsZUFDQTtBQUNqQk8sRUFBQUEsVUFBVSxFQUFFaUIsc0JBQVVDLE1BREw7QUFFakJuQixFQUFBQSxNQUFNLEVBQUVrQixzQkFBVUUsT0FBVixDQUNORixzQkFBVUcsS0FBVixDQUFnQjtBQUNkTCxJQUFBQSxJQUFJLEVBQUVFLHNCQUFVSSxNQURGO0FBRWRMLElBQUFBLFNBQVMsRUFBRUMsc0JBQVVJLE1BRlA7QUFHZFgsSUFBQUEsS0FBSyxFQUFFTyxzQkFBVUM7QUFISCxHQUFoQixDQURNO0FBRlMsQzs7Z0JBREF6QixVLGtCQVlHO0FBQ3BCTyxFQUFBQSxVQUFVLEVBQUU7QUFEUSxDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzkuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcblxuaW1wb3J0IHthdXRvYmluZH0gZnJvbSAnLi4vaGVscGVycyc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIERvbnV0Q2hhcnQgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIGJhc2VPZmZzZXQ6IFByb3BUeXBlcy5udW1iZXIsXG4gICAgc2xpY2VzOiBQcm9wVHlwZXMuYXJyYXlPZihcbiAgICAgIFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICAgIHR5cGU6IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIGNsYXNzTmFtZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgICAgY291bnQ6IFByb3BUeXBlcy5udW1iZXIsXG4gICAgICB9KSxcbiAgICApLFxuICB9XG5cbiAgc3RhdGljIGRlZmF1bHRQcm9wcyA9IHtcbiAgICBiYXNlT2Zmc2V0OiAyNSxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICAgIGF1dG9iaW5kKHRoaXMsICdyZW5kZXJBcmMnKTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBjb25zdCB7c2xpY2VzLCBiYXNlT2Zmc2V0LCAuLi5vdGhlcnN9ID0gdGhpcy5wcm9wczsgLy8gZXNsaW50LWRpc2FibGUtbGluZSBuby11bnVzZWQtdmFyc1xuICAgIGNvbnN0IGFyY3MgPSB0aGlzLmNhbGN1bGF0ZUFyY3Moc2xpY2VzKTtcblxuICAgIHJldHVybiAoXG4gICAgICA8c3ZnIHsuLi5vdGhlcnN9PlxuICAgICAgICB7YXJjcy5tYXAodGhpcy5yZW5kZXJBcmMpfVxuICAgICAgPC9zdmc+XG4gICAgKTtcbiAgfVxuXG4gIGNhbGN1bGF0ZUFyY3Moc2xpY2VzKSB7XG4gICAgY29uc3QgdG90YWwgPSBzbGljZXMucmVkdWNlKChhY2MsIGl0ZW0pID0+IGFjYyArIGl0ZW0uY291bnQsIDApO1xuICAgIGxldCBsZW5ndGhTb0ZhciA9IDA7XG5cbiAgICByZXR1cm4gc2xpY2VzLm1hcCgoe2NvdW50LCAuLi5vdGhlcnN9KSA9PiB7XG4gICAgICBjb25zdCBwaWVjZSA9IHtcbiAgICAgICAgbGVuZ3RoOiBjb3VudCAvIHRvdGFsICogMTAwLFxuICAgICAgICBwb3NpdGlvbjogbGVuZ3RoU29GYXIsXG4gICAgICAgIC4uLm90aGVycyxcbiAgICAgIH07XG4gICAgICBsZW5ndGhTb0ZhciArPSBwaWVjZS5sZW5ndGg7XG4gICAgICByZXR1cm4gcGllY2U7XG4gICAgfSk7XG4gIH1cblxuICByZW5kZXJBcmMoe2xlbmd0aCwgcG9zaXRpb24sIHR5cGUsIGNsYXNzTmFtZX0pIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGNpcmNsZVxuICAgICAgICBrZXk9e3R5cGV9XG4gICAgICAgIGN4PVwiMjFcIlxuICAgICAgICBjeT1cIjIxXCJcbiAgICAgICAgcj1cIjE1LjkxNTQ5NDMwOTE4OTU0XCJcbiAgICAgICAgZmlsbD1cInRyYW5zcGFyZW50XCJcbiAgICAgICAgY2xhc3NOYW1lPXtgZG9udXQtcmluZy0ke3R5cGV9YH1cbiAgICAgICAgcGF0aExlbmd0aD1cIjEwMFwiXG4gICAgICAgIHN0cm9rZVdpZHRoPVwiM1wiXG4gICAgICAgIHN0cm9rZURhc2hhcnJheT17YCR7bGVuZ3RofSAkezEwMCAtIGxlbmd0aH1gfVxuICAgICAgICBzdHJva2VEYXNob2Zmc2V0PXtgJHsxMDAgLSBwb3NpdGlvbiArIHRoaXMucHJvcHMuYmFzZU9mZnNldH1gfVxuICAgICAgLz5cbiAgICApO1xuICB9XG59XG4iXX0=