"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactionPickerView = _interopRequireDefault(require("../views/reaction-picker-view"));

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReactionPickerController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "addReactionAndClose", async content => {
      await this.props.addReaction(content);
      (0, _reporterProxy.addEvent)('add-emoji-reaction', {
        "package": 'github'
      });
      this.props.tooltipHolder.map(tooltip => tooltip.dispose());
    });

    _defineProperty(this, "removeReactionAndClose", async content => {
      await this.props.removeReaction(content);
      (0, _reporterProxy.addEvent)('remove-emoji-reaction', {
        "package": 'github'
      });
      this.props.tooltipHolder.map(tooltip => tooltip.dispose());
    });
  }

  render() {
    return _react["default"].createElement(_reactionPickerView["default"], _extends({
      addReactionAndClose: this.addReactionAndClose,
      removeReactionAndClose: this.removeReactionAndClose
    }, this.props));
  }

}

exports["default"] = ReactionPickerController;

_defineProperty(ReactionPickerController, "propTypes", {
  addReaction: _propTypes["default"].func.isRequired,
  removeReaction: _propTypes["default"].func.isRequired,
  tooltipHolder: _propTypes2.RefHolderPropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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