"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _reactRelay = require("react-relay");

var _helpers = require("../helpers");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _propTypes2 = require("../prop-types");

var _keytarStrategy = require("../shared/keytar-strategy");

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _errorView = _interopRequireDefault(require("../views/error-view"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _relayEnvironment = _interopRequireDefault(require("../views/relay-environment"));

var _aggregatedReviewsContainer = _interopRequireDefault(require("./aggregated-reviews-container"));

var _issueishDetailController = _interopRequireDefault(require("../controllers/issueish-detail-controller"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishDetailContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderWithToken", tokenData => {
      const token = tokenData && tokenData.token;

      if (token === _keytarStrategy.UNAUTHENTICATED) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        });
      }

      if (token === _keytarStrategy.INSUFFICIENT) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        }, _react["default"].createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
      }

      return _react["default"].createElement(_observeModel["default"], {
        model: this.props.repository,
        fetchData: this.fetchRepositoryData
      }, repoData => this.renderWithRepositoryData(token, repoData));
    });

    _defineProperty(this, "fetchToken", loginModel => {
      return (0, _yubikiri["default"])({
        token: loginModel.getToken(this.props.endpoint.getLoginAccount())
      });
    });

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri["default"])({
        branches: repository.getBranches(),
        remotes: repository.getRemotes(),
        isMerging: repository.isMerging(),
        isRebasing: repository.isRebasing(),
        isAbsent: repository.isAbsent(),
        isLoading: repository.isLoading(),
        isPresent: repository.isPresent()
      });
    });

    _defineProperty(this, "handleLogin", token => this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token));

    _defineProperty(this, "handleLogout", () => this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount()));
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderWithRepositoryData(token, repoData) {
    if (!token) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/issueishDetailContainerQuery.graphql");

      if (node.hash && node.hash !== "f0f0b983d5648d6435cb0a818dcdf081") {
        console.error("The definition of 'issueishDetailContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/issueishDetailContainerQuery.graphql");
    });

    const variables = {
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      issueishNumber: this.props.issueishNumber,
      timelineCount: _helpers.PAGE_SIZE,
      timelineCursor: null,
      commitCount: _helpers.PAGE_SIZE,
      commitCursor: null,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    };
    return _react["default"].createElement(_relayEnvironment["default"].Provider, {
      value: environment
    }, _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      query: query,
      variables: variables,
      render: queryResult => this.renderWithQueryResult(token, repoData, queryResult)
    }));
  }

  renderWithQueryResult(token, repoData, {
    error,
    props,
    retry
  }) {
    if (error) {
      return _react["default"].createElement(_queryErrorView["default"], {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (!props || !repoData) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    if (props.repository.issueish.__typename === 'PullRequest') {
      return _react["default"].createElement(_aggregatedReviewsContainer["default"], {
        pullRequest: props.repository.issueish
      }, aggregatedReviews => this.renderWithCommentResult(token, repoData, {
        props,
        retry
      }, aggregatedReviews));
    } else {
      return this.renderWithCommentResult(token, repoData, {
        props,
        retry
      }, {
        errors: [],
        commentThreads: [],
        loading: false
      });
    }
  }

  renderWithCommentResult(token, repoData, {
    props,
    retry
  }, {
    errors,
    commentThreads,
    loading
  }) {
    const nonEmptyThreads = commentThreads.filter(each => each.comments && each.comments.length > 0);
    const totalCount = nonEmptyThreads.length;
    const resolvedCount = nonEmptyThreads.filter(each => each.thread.isResolved).length;

    if (errors && errors.length > 0) {
      const descriptions = errors.map(error => error.toString());
      return _react["default"].createElement(_errorView["default"], {
        title: "Unable to fetch review comments",
        descriptions: descriptions,
        retry: retry,
        logout: this.handleLogout
      });
    }

    return _react["default"].createElement(_issueishDetailController["default"], _extends({}, props, repoData, {
      reviewCommentsLoading: loading,
      reviewCommentsTotalCount: totalCount,
      reviewCommentsResolvedCount: resolvedCount,
      reviewCommentThreads: nonEmptyThreads,
      token: token,
      localRepository: this.props.repository,
      workdirPath: this.props.repository.getWorkingDirectoryPath(),
      issueishNumber: this.props.issueishNumber,
      onTitleChange: this.props.onTitleChange,
      switchToIssueish: this.props.switchToIssueish,
      initChangedFilePath: this.props.initChangedFilePath,
      initChangedFilePosition: this.props.initChangedFilePosition,
      selectedTab: this.props.selectedTab,
      onTabSelected: this.props.onTabSelected,
      onOpenFilesTab: this.props.onOpenFilesTab,
      endpoint: this.props.endpoint,
      reportMutationErrors: this.props.reportMutationErrors,
      workspace: this.props.workspace,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,
      itemType: this.props.itemType,
      destroy: this.props.destroy,
      refEditor: this.props.refEditor
    }));
  }

}

exports["default"] = IssueishDetailContainer;

_defineProperty(IssueishDetailContainer, "propTypes", {
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Issueish selection criteria
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  issueishNumber: _propTypes["default"].number.isRequired,
  // For opening files changed tab
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  selectedTab: _propTypes["default"].number.isRequired,
  onTabSelected: _propTypes["default"].func.isRequired,
  onOpenFilesTab: _propTypes["default"].func.isRequired,
  // Package models
  repository: _propTypes["default"].object.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action methods
  switchToIssueish: _propTypes["default"].func.isRequired,
  onTitleChange: _propTypes["default"].func.isRequired,
  destroy: _propTypes["default"].func.isRequired,
  reportMutationErrors: _propTypes["default"].func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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