"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _issueishListController = _interopRequireWildcard(require("../controllers/issueish-list-controller"));

var _createPullRequestTile = _interopRequireDefault(require("../views/create-pull-request-tile"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CurrentPullRequestContainer extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult', 'renderEmptyTile');
    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, this.props.token);

    const head = this.props.branches.getHeadBranch();

    if (!head.isPresent()) {
      return this.renderEmptyResult();
    }

    const push = head.getPush();

    if (!push.isPresent() || !push.isRemoteTracking()) {
      return this.renderEmptyResult();
    }

    const pushRemote = this.props.remotes.withName(push.getRemoteName());

    if (!pushRemote.isPresent() || !pushRemote.isGithubRepo()) {
      return this.renderEmptyResult();
    }

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/currentPullRequestContainerQuery.graphql");

      if (node.hash && node.hash !== "ade50c0777277f2032b27dfced670a2d") {
        console.error("The definition of 'currentPullRequestContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/currentPullRequestContainerQuery.graphql");
    });

    const variables = {
      headOwner: pushRemote.getOwner(),
      headName: pushRemote.getRepo(),
      headRef: push.getRemoteRef(),
      first: this.props.limit
    };
    return _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderEmptyResult() {
    this.sub.dispose();
    this.sub = this.props.remoteOperationObserver.onDidComplete(() => this.forceUpdate());
    return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
      isLoading: false
    }, this.controllerProps()));
  }

  renderQueryResult({
    error,
    props,
    retry
  }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    if (!props.repository || !props.repository.ref) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const associatedPullRequests = props.repository.ref.associatedPullRequests;
    return _react["default"].createElement(_issueishListController["default"], _extends({
      total: associatedPullRequests.totalCount,
      results: associatedPullRequests.nodes,
      isLoading: false,
      workspace: this.props.workspace,
      endpoint: this.props.endpoint,
      resultFilter: issueish => issueish.getHeadRepositoryID() === this.props.repository.id
    }, this.controllerProps()));
  }

  renderEmptyTile() {
    return _react["default"].createElement(_createPullRequestTile["default"], {
      repository: this.props.repository,
      remote: this.props.remote,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.props.onCreatePr
    });
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: 'Checked out pull request',
      onOpenIssueish: this.props.onOpenIssueish,
      onOpenReviews: this.props.onOpenReviews,
      emptyComponent: this.renderEmptyTile,
      needReviewsButton: true
    };
  }

}

exports["default"] = CurrentPullRequestContainer;

_defineProperty(CurrentPullRequestContainer, "propTypes", {
  // Relay payload
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }).isRequired,
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Search constraints
  limit: _propTypes["default"].number,
  // Repository model attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  // Actions
  onOpenIssueish: _propTypes["default"].func.isRequired,
  onOpenReviews: _propTypes["default"].func.isRequired,
  onCreatePr: _propTypes["default"].func.isRequired
});

_defineProperty(CurrentPullRequestContainer, "defaultProps", {
  limit: 5
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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