**Please be sure to read the [contributor's guide to the GitHub package](https://github.com/atom/github/blob/master/CONTRIBUTING.md) before submitting any pull requests.**

### Requirements

* Filling out the template is required. Any pull request that does not include enough information to be reviewed in a timely manner may be closed at the maintainers' discretion.
* Suggestion: You can use checklists to keep track of progress for the sections on metrics, tests, documentation, and user research.

### Description of the Change

<!--

We must be able to understand the design of your change from this description. If we can't get a good idea of what the code will be doing from the description here, the pull request may be closed at the maintainers' discretion. Keep in mind that the maintainer reviewing this PR may not be familiar with or have worked with the code here recently, so please walk us through the concepts.

-->

### Screenshot/Gif

<!-- If the changes are visual, add a screenshot or record a Gif. This doesn't have to be updated during implementation, but after a PR is merged, a final screenshot/gif should be added. It might get used for blog posts, documentation etc. Write "N/A" if not applicable. -->

### Alternate Designs

<!-- Explain what other alternates were considered and why the proposed version was selected -->

### Benefits

<!-- What benefits will be realized by the code change? -->

### Possible Drawbacks

<!-- What are the possible side-effects or negative impacts of the code change? -->

### Applicable Issues

<!-- Enter any applicable Issues here -->

### Metrics

<!-- What metrics are associated with this code change and what questions can they help us answer? Write "N/A" if not applicable. -->

### Tests

<!-- 

How did you verify that your change has the desired effects?
- How did you verify that all new functionality works as expected?
- How did you verify that all changed functionality works as expected?
- How did you verify that the change has not introduced any regressions?

What unit or integration tests were (or will be) added to help protect against future regressions? 
For manual testing, be sure to describe in detail the actions you performed (including buttons you clicked, text you typed, commands you ran, etc.), and the results you observed.
If you chose not to include a specific test, please explain why. 

Write "N/A" if not applicable. 

-->

### Documentation

<!-- Describe the documentation added or improved. Write "N/A" if not applicable. -->

### Release Notes

<!--

Please describe the changes in a single line that explains this improvement in
terms that a user can understand.  This text will be used in Atom's release notes.

If this change is not user-facing or notable enough to be included in release notes
you may use the strings "Not applicable" or "N/A" here.

Examples:

- The GitHub package now allows you to add co-authors to commits.
- Fixed an issue where the merge message did not show up in the commit message box.
- Increased the performance of rendering diffs.

-->

### User Experience Research (Optional)

<!-- If this change would benefit from UXR, please state assumptions or hypotheses and specify if they are to be validated before or after releasing. Examples include investigating discoverability, verifying performance improvements, tracking metrics, etc. -->

