Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _grim = require('grim');

var _grim2 = _interopRequireDefault(_grim);

var _marked = require('marked');

var _marked2 = _interopRequireDefault(_marked);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _shell = require('shell');

var _shell2 = _interopRequireDefault(_shell);

var DeprecationCopView = (function () {
  function DeprecationCopView(_ref) {
    var _this = this;

    var uri = _ref.uri;

    _classCallCheck(this, DeprecationCopView);

    this.uri = uri;
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(_grim2['default'].on('updated', function () {
      _etch2['default'].update(_this);
    }));
    // TODO: Remove conditional when the new StyleManager deprecation APIs reach stable.
    if (atom.styles.onDidUpdateDeprecations) {
      this.subscriptions.add(atom.styles.onDidUpdateDeprecations(function () {
        _etch2['default'].update(_this);
      }));
    }
    _etch2['default'].initialize(this);
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
  }

  _createClass(DeprecationCopView, [{
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: this.constructor.name,
        uri: this.getURI(),
        version: 1
      };
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {
      return _etch2['default'].update(this);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        {
          className: 'deprecation-cop pane-item native-key-bindings',
          tabIndex: '-1'
        },
        _etch2['default'].dom(
          'div',
          { className: 'panel' },
          _etch2['default'].dom(
            'div',
            { className: 'padded deprecation-overview' },
            _etch2['default'].dom(
              'div',
              { className: 'pull-right btn-group' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn btn-primary check-for-update',
                  onclick: function (event) {
                    event.preventDefault();
                    _this2.checkForUpdates();
                  }
                },
                'Check for Updates'
              )
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            _etch2['default'].dom(
              'span',
              null,
              'Deprecated calls'
            )
          ),
          _etch2['default'].dom(
            'ul',
            { className: 'list-tree has-collapsable-children' },
            this.renderDeprecatedCalls()
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            _etch2['default'].dom(
              'span',
              null,
              'Deprecated selectors'
            )
          ),
          _etch2['default'].dom(
            'ul',
            { className: 'selectors list-tree has-collapsable-children' },
            this.renderDeprecatedSelectors()
          )
        )
      );
    }
  }, {
    key: 'renderDeprecatedCalls',
    value: function renderDeprecatedCalls() {
      var _this3 = this;

      var deprecationsByPackageName = this.getDeprecatedCallsByPackageName();
      var packageNames = Object.keys(deprecationsByPackageName);
      if (packageNames.length === 0) {
        return _etch2['default'].dom(
          'li',
          { className: 'list-item' },
          'No deprecated calls'
        );
      } else {
        return packageNames.sort().map(function (packageName) {
          return _etch2['default'].dom(
            'li',
            { className: 'deprecation list-nested-item collapsed' },
            _etch2['default'].dom(
              'div',
              {
                className: 'deprecation-info list-item',
                onclick: function (event) {
                  return event.target.parentElement.classList.toggle('collapsed');
                }
              },
              _etch2['default'].dom(
                'span',
                { className: 'text-highlight' },
                packageName || 'atom core'
              ),
              _etch2['default'].dom(
                'span',
                null,
                ' (' + _underscorePlus2['default'].pluralize(deprecationsByPackageName[packageName].length, 'deprecation') + ')'
              )
            ),
            _etch2['default'].dom(
              'ul',
              { className: 'list' },
              _this3.renderPackageActionsIfNeeded(packageName),
              deprecationsByPackageName[packageName].map(function (_ref2) {
                var deprecation = _ref2.deprecation;
                var stack = _ref2.stack;
                return _etch2['default'].dom(
                  'li',
                  { className: 'list-item deprecation-detail' },
                  _etch2['default'].dom('span', { className: 'text-warning icon icon-alert' }),
                  _etch2['default'].dom('div', {
                    className: 'list-item deprecation-message',
                    innerHTML: (0, _marked2['default'])(deprecation.getMessage())
                  }),
                  _this3.renderIssueURLIfNeeded(packageName, deprecation, _this3.buildIssueURL(packageName, deprecation, stack)),
                  _etch2['default'].dom(
                    'div',
                    { className: 'stack-trace' },
                    stack.map(function (_ref3) {
                      var functionName = _ref3.functionName;
                      var location = _ref3.location;
                      return _etch2['default'].dom(
                        'div',
                        { className: 'stack-line' },
                        _etch2['default'].dom(
                          'span',
                          null,
                          functionName
                        ),
                        _etch2['default'].dom(
                          'span',
                          null,
                          ' - '
                        ),
                        _etch2['default'].dom(
                          'a',
                          {
                            className: 'stack-line-location',
                            href: location,
                            onclick: function (event) {
                              event.preventDefault();
                              _this3.openLocation(location);
                            }
                          },
                          location
                        )
                      );
                    })
                  )
                );
              })
            )
          );
        });
      }
    }
  }, {
    key: 'renderDeprecatedSelectors',
    value: function renderDeprecatedSelectors() {
      var _this4 = this;

      var deprecationsByPackageName = this.getDeprecatedSelectorsByPackageName();
      var packageNames = Object.keys(deprecationsByPackageName);
      if (packageNames.length === 0) {
        return _etch2['default'].dom(
          'li',
          { className: 'list-item' },
          'No deprecated selectors'
        );
      } else {
        return packageNames.map(function (packageName) {
          return _etch2['default'].dom(
            'li',
            { className: 'deprecation list-nested-item collapsed' },
            _etch2['default'].dom(
              'div',
              {
                className: 'deprecation-info list-item',
                onclick: function (event) {
                  return event.target.parentElement.classList.toggle('collapsed');
                }
              },
              _etch2['default'].dom(
                'span',
                { className: 'text-highlight' },
                packageName
              )
            ),
            _etch2['default'].dom(
              'ul',
              { className: 'list' },
              _this4.renderPackageActionsIfNeeded(packageName),
              deprecationsByPackageName[packageName].map(function (_ref4) {
                var packagePath = _ref4.packagePath;
                var sourcePath = _ref4.sourcePath;
                var deprecation = _ref4.deprecation;

                var relativeSourcePath = _path2['default'].relative(packagePath, sourcePath);
                var issueTitle = 'Deprecated selector in `' + relativeSourcePath + '`';
                var issueBody = 'In `' + relativeSourcePath + '`: \n\n' + deprecation.message;
                return _etch2['default'].dom(
                  'li',
                  { className: 'list-item source-file' },
                  _etch2['default'].dom(
                    'a',
                    {
                      className: 'source-url',
                      href: sourcePath,
                      onclick: function (event) {
                        event.preventDefault();
                        _this4.openLocation(sourcePath);
                      }
                    },
                    relativeSourcePath
                  ),
                  _etch2['default'].dom(
                    'ul',
                    { className: 'list' },
                    _etch2['default'].dom(
                      'li',
                      { className: 'list-item deprecation-detail' },
                      _etch2['default'].dom('span', { className: 'text-warning icon icon-alert' }),
                      _etch2['default'].dom('div', {
                        className: 'list-item deprecation-message',
                        innerHTML: (0, _marked2['default'])(deprecation.message)
                      }),
                      _this4.renderSelectorIssueURLIfNeeded(packageName, issueTitle, issueBody)
                    )
                  )
                );
              })
            )
          );
        });
      }
    }
  }, {
    key: 'renderPackageActionsIfNeeded',
    value: function renderPackageActionsIfNeeded(packageName) {
      var _this5 = this;

      if (packageName && atom.packages.getLoadedPackage(packageName)) {
        return _etch2['default'].dom(
          'div',
          { className: 'padded' },
          _etch2['default'].dom(
            'div',
            { className: 'btn-group' },
            _etch2['default'].dom(
              'button',
              {
                className: 'btn check-for-update',
                onclick: function (event) {
                  event.preventDefault();
                  _this5.checkForUpdates();
                }
              },
              'Check for Update'
            ),
            _etch2['default'].dom(
              'button',
              {
                className: 'btn disable-package',
                'data-package-name': packageName,
                onclick: function (event) {
                  event.preventDefault();
                  _this5.disablePackage(packageName);
                }
              },
              'Disable Package'
            )
          )
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'encodeURI',
    value: (function (_encodeURI) {
      function encodeURI(_x) {
        return _encodeURI.apply(this, arguments);
      }

      encodeURI.toString = function () {
        return _encodeURI.toString();
      };

      return encodeURI;
    })(function (str) {
      return encodeURI(str).replace(/#/g, '%23').replace(/;/g, '%3B').replace(/%20/g, '+');
    })
  }, {
    key: 'renderSelectorIssueURLIfNeeded',
    value: function renderSelectorIssueURLIfNeeded(packageName, issueTitle, issueBody) {
      var _this6 = this;

      var repoURL = this.getRepoURL(packageName);
      if (repoURL) {
        var _ret = (function () {
          var issueURL = repoURL + '/issues/new?title=' + _this6.encodeURI(issueTitle) + '&body=' + _this6.encodeURI(issueBody);
          return {
            v: _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn issue-url',
                  'data-issue-title': issueTitle,
                  'data-repo-url': repoURL,
                  'data-issue-url': issueURL,
                  onclick: function (event) {
                    event.preventDefault();
                    _this6.openIssueURL(repoURL, issueURL, issueTitle);
                  }
                },
                'Report Issue'
              )
            )
          };
        })();

        if (typeof _ret === 'object') return _ret.v;
      } else {
        return '';
      }
    }
  }, {
    key: 'renderIssueURLIfNeeded',
    value: function renderIssueURLIfNeeded(packageName, deprecation, issueURL) {
      var _this7 = this;

      if (packageName && issueURL) {
        var _ret2 = (function () {
          var repoURL = _this7.getRepoURL(packageName);
          var issueTitle = deprecation.getOriginName() + ' is deprecated.';
          return {
            v: _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn issue-url',
                  'data-issue-title': issueTitle,
                  'data-repo-url': repoURL,
                  'data-issue-url': issueURL,
                  onclick: function (event) {
                    event.preventDefault();
                    _this7.openIssueURL(repoURL, issueURL, issueTitle);
                  }
                },
                'Report Issue'
              )
            )
          };
        })();

        if (typeof _ret2 === 'object') return _ret2.v;
      } else {
        return '';
      }
    }
  }, {
    key: 'buildIssueURL',
    value: function buildIssueURL(packageName, deprecation, stack) {
      var repoURL = this.getRepoURL(packageName);
      if (repoURL) {
        var title = deprecation.getOriginName() + ' is deprecated.';
        var stacktrace = stack.map(function (_ref5) {
          var functionName = _ref5.functionName;
          var location = _ref5.location;
          return functionName + ' (' + location + ')';
        }).join('\n');
        var body = deprecation.getMessage() + '\n```\n' + stacktrace + '\n```';
        return repoURL + '/issues/new?title=' + encodeURI(title) + '&body=' + encodeURI(body);
      } else {
        return null;
      }
    }
  }, {
    key: 'openIssueURL',
    value: _asyncToGenerator(function* (repoURL, issueURL, issueTitle) {
      var issue = yield this.findSimilarIssue(repoURL, issueTitle);
      if (issue) {
        _shell2['default'].openExternal(issue.html_url);
      } else if (process.platform === 'win32') {
        // Windows will not launch URLs greater than ~2000 bytes so we need to shrink it
        _shell2['default'].openExternal((yield this.shortenURL(issueURL)) || issueURL);
      } else {
        _shell2['default'].openExternal(issueURL);
      }
    })
  }, {
    key: 'findSimilarIssue',
    value: _asyncToGenerator(function* (repoURL, issueTitle) {
      var url = 'https://api.github.com/search/issues';
      var repo = repoURL.replace(/http(s)?:\/\/(\d+\.)?github.com\//gi, '');
      var query = issueTitle + ' repo:' + repo;
      var response = yield window.fetch(url + '?q=' + encodeURI(query) + '&sort=created', {
        method: 'GET',
        headers: {
          Accept: 'application/vnd.github.v3+json',
          'Content-Type': 'application/json'
        }
      });

      if (response.ok) {
        var data = yield response.json();
        if (data.items) {
          var issues = {};
          for (var issue of data.items) {
            if (issue.title.includes(issueTitle) && !issues[issue.state]) {
              issues[issue.state] = issue;
            }
          }

          return issues.open || issues.closed;
        }
      }
    })
  }, {
    key: 'shortenURL',
    value: _asyncToGenerator(function* (url) {
      var encodedUrl = encodeURIComponent(url).substr(0, 5000); // is.gd has 5000 char limit
      var incompletePercentEncoding = encodedUrl.indexOf('%', encodedUrl.length - 2);
      if (incompletePercentEncoding >= 0) {
        // Handle an incomplete % encoding cut-off
        encodedUrl = encodedUrl.substr(0, incompletePercentEncoding);
      }

      var result = yield fetch('https://is.gd/create.php?format=simple', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'url=' + encodedUrl
      });

      return result.text();
    })
  }, {
    key: 'getRepoURL',
    value: function getRepoURL(packageName) {
      var loadedPackage = atom.packages.getLoadedPackage(packageName);
      if (loadedPackage && loadedPackage.metadata && loadedPackage.metadata.repository) {
        var url = loadedPackage.metadata.repository.url || loadedPackage.metadata.repository;
        return url.replace(/\.git$/, '');
      } else {
        return null;
      }
    }
  }, {
    key: 'getDeprecatedCallsByPackageName',
    value: function getDeprecatedCallsByPackageName() {
      var deprecatedCalls = _grim2['default'].getDeprecations();
      deprecatedCalls.sort(function (a, b) {
        return b.getCallCount() - a.getCallCount();
      });
      var deprecatedCallsByPackageName = {};
      for (var deprecation of deprecatedCalls) {
        var stacks = deprecation.getStacks();
        stacks.sort(function (a, b) {
          return b.callCount - a.callCount;
        });
        for (var stack of stacks) {
          var packageName = null;
          if (stack.metadata && stack.metadata.packageName) {
            packageName = stack.metadata.packageName;
          } else {
            packageName = (this.getPackageName(stack) || '').toLowerCase();
          }

          deprecatedCallsByPackageName[packageName] = deprecatedCallsByPackageName[packageName] || [];
          deprecatedCallsByPackageName[packageName].push({ deprecation: deprecation, stack: stack });
        }
      }
      return deprecatedCallsByPackageName;
    }
  }, {
    key: 'getDeprecatedSelectorsByPackageName',
    value: function getDeprecatedSelectorsByPackageName() {
      var deprecatedSelectorsByPackageName = {};
      if (atom.styles.getDeprecations) {
        var deprecatedSelectorsBySourcePath = atom.styles.getDeprecations();
        for (var sourcePath of Object.keys(deprecatedSelectorsBySourcePath)) {
          var deprecation = deprecatedSelectorsBySourcePath[sourcePath];
          var components = sourcePath.split(_path2['default'].sep);
          var packagesComponentIndex = components.indexOf('packages');
          var packageName = null;
          var packagePath = null;
          if (packagesComponentIndex === -1) {
            packageName = 'Other'; // could be Atom Core or the personal style sheet
            packagePath = '';
          } else {
            packageName = components[packagesComponentIndex + 1];
            packagePath = components.slice(0, packagesComponentIndex + 1).join(_path2['default'].sep);
          }

          deprecatedSelectorsByPackageName[packageName] = deprecatedSelectorsByPackageName[packageName] || [];
          deprecatedSelectorsByPackageName[packageName].push({
            packagePath: packagePath,
            sourcePath: sourcePath,
            deprecation: deprecation
          });
        }
      }

      return deprecatedSelectorsByPackageName;
    }
  }, {
    key: 'getPackageName',
    value: function getPackageName(stack) {
      var packagePaths = this.getPackagePathsByPackageName();
      for (var _ref63 of packagePaths) {
        var _ref62 = _slicedToArray(_ref63, 2);

        var packageName = _ref62[0];
        var packagePath = _ref62[1];

        if (packagePath.includes('.atom/dev/packages') || packagePath.includes('.atom/packages')) {
          packagePaths.set(packageName, _fsPlus2['default'].absolute(packagePath));
        }
      }

      for (var i = 1; i < stack.length; i++) {
        var fileName = stack[i].fileName;

        // Empty when it was run from the dev console
        if (!fileName) {
          return null;
        }

        // Continue to next stack entry if call is in node_modules
        if (fileName.includes(_path2['default'].sep + 'node_modules' + _path2['default'].sep)) {
          continue;
        }

        for (var _ref73 of packagePaths) {
          var _ref72 = _slicedToArray(_ref73, 2);

          var packageName = _ref72[0];
          var packagePath = _ref72[1];

          var relativePath = _path2['default'].relative(packagePath, fileName);
          if (!/^\.\./.test(relativePath)) {
            return packageName;
          }
        }

        if (atom.getUserInitScriptPath() === fileName) {
          return 'Your local ' + _path2['default'].basename(fileName) + ' file';
        }
      }

      return null;
    }
  }, {
    key: 'getPackagePathsByPackageName',
    value: function getPackagePathsByPackageName() {
      if (this.packagePathsByPackageName) {
        return this.packagePathsByPackageName;
      } else {
        this.packagePathsByPackageName = new Map();
        for (var pack of atom.packages.getLoadedPackages()) {
          this.packagePathsByPackageName.set(pack.name, pack.path);
        }
        return this.packagePathsByPackageName;
      }
    }
  }, {
    key: 'checkForUpdates',
    value: function checkForUpdates() {
      atom.workspace.open('atom://config/updates');
    }
  }, {
    key: 'disablePackage',
    value: function disablePackage(packageName) {
      if (packageName) {
        atom.packages.disablePackage(packageName);
      }
    }
  }, {
    key: 'openLocation',
    value: function openLocation(location) {
      var pathToOpen = location.replace('file://', '');
      if (process.platform === 'win32') {
        pathToOpen = pathToOpen.replace(/^\//, '');
      }
      atom.open({ pathsToOpen: [pathToOpen] });
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.uri;
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Deprecation Cop';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'alert';
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return DeprecationCopView;
})();

exports['default'] = DeprecationCopView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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