# This file was generated automatically by the Snowball to Python compiler
# http://snowballstem.org/

from .basestemmer import BaseStemmer
from .among import Among


class TurkishStemmer(BaseStemmer):
    '''
    This class was automatically generated by a Snowball to Python compiler
    It implements the stemming algorithm defined by a snowball script.
    '''

    a_0 = [
        Among(u"m", -1, -1),
        Among(u"n", -1, -1),
        Among(u"miz", -1, -1),
        Among(u"niz", -1, -1),
        Among(u"muz", -1, -1),
        Among(u"nuz", -1, -1),
        Among(u"m\u00FCz", -1, -1),
        Among(u"n\u00FCz", -1, -1),
        Among(u"m\u0131z", -1, -1),
        Among(u"n\u0131z", -1, -1)
    ]

    a_1 = [
        Among(u"leri", -1, -1),
        Among(u"lar\u0131", -1, -1)
    ]

    a_2 = [
        Among(u"ni", -1, -1),
        Among(u"nu", -1, -1),
        Among(u"n\u00FC", -1, -1),
        Among(u"n\u0131", -1, -1)
    ]

    a_3 = [
        Among(u"in", -1, -1),
        Among(u"un", -1, -1),
        Among(u"\u00FCn", -1, -1),
        Among(u"\u0131n", -1, -1)
    ]

    a_4 = [
        Among(u"a", -1, -1),
        Among(u"e", -1, -1)
    ]

    a_5 = [
        Among(u"na", -1, -1),
        Among(u"ne", -1, -1)
    ]

    a_6 = [
        Among(u"da", -1, -1),
        Among(u"ta", -1, -1),
        Among(u"de", -1, -1),
        Among(u"te", -1, -1)
    ]

    a_7 = [
        Among(u"nda", -1, -1),
        Among(u"nde", -1, -1)
    ]

    a_8 = [
        Among(u"dan", -1, -1),
        Among(u"tan", -1, -1),
        Among(u"den", -1, -1),
        Among(u"ten", -1, -1)
    ]

    a_9 = [
        Among(u"ndan", -1, -1),
        Among(u"nden", -1, -1)
    ]

    a_10 = [
        Among(u"la", -1, -1),
        Among(u"le", -1, -1)
    ]

    a_11 = [
        Among(u"ca", -1, -1),
        Among(u"ce", -1, -1)
    ]

    a_12 = [
        Among(u"im", -1, -1),
        Among(u"um", -1, -1),
        Among(u"\u00FCm", -1, -1),
        Among(u"\u0131m", -1, -1)
    ]

    a_13 = [
        Among(u"sin", -1, -1),
        Among(u"sun", -1, -1),
        Among(u"s\u00FCn", -1, -1),
        Among(u"s\u0131n", -1, -1)
    ]

    a_14 = [
        Among(u"iz", -1, -1),
        Among(u"uz", -1, -1),
        Among(u"\u00FCz", -1, -1),
        Among(u"\u0131z", -1, -1)
    ]

    a_15 = [
        Among(u"siniz", -1, -1),
        Among(u"sunuz", -1, -1),
        Among(u"s\u00FCn\u00FCz", -1, -1),
        Among(u"s\u0131n\u0131z", -1, -1)
    ]

    a_16 = [
        Among(u"lar", -1, -1),
        Among(u"ler", -1, -1)
    ]

    a_17 = [
        Among(u"niz", -1, -1),
        Among(u"nuz", -1, -1),
        Among(u"n\u00FCz", -1, -1),
        Among(u"n\u0131z", -1, -1)
    ]

    a_18 = [
        Among(u"dir", -1, -1),
        Among(u"tir", -1, -1),
        Among(u"dur", -1, -1),
        Among(u"tur", -1, -1),
        Among(u"d\u00FCr", -1, -1),
        Among(u"t\u00FCr", -1, -1),
        Among(u"d\u0131r", -1, -1),
        Among(u"t\u0131r", -1, -1)
    ]

    a_19 = [
        Among(u"cas\u0131na", -1, -1),
        Among(u"cesine", -1, -1)
    ]

    a_20 = [
        Among(u"di", -1, -1),
        Among(u"ti", -1, -1),
        Among(u"dik", -1, -1),
        Among(u"tik", -1, -1),
        Among(u"duk", -1, -1),
        Among(u"tuk", -1, -1),
        Among(u"d\u00FCk", -1, -1),
        Among(u"t\u00FCk", -1, -1),
        Among(u"d\u0131k", -1, -1),
        Among(u"t\u0131k", -1, -1),
        Among(u"dim", -1, -1),
        Among(u"tim", -1, -1),
        Among(u"dum", -1, -1),
        Among(u"tum", -1, -1),
        Among(u"d\u00FCm", -1, -1),
        Among(u"t\u00FCm", -1, -1),
        Among(u"d\u0131m", -1, -1),
        Among(u"t\u0131m", -1, -1),
        Among(u"din", -1, -1),
        Among(u"tin", -1, -1),
        Among(u"dun", -1, -1),
        Among(u"tun", -1, -1),
        Among(u"d\u00FCn", -1, -1),
        Among(u"t\u00FCn", -1, -1),
        Among(u"d\u0131n", -1, -1),
        Among(u"t\u0131n", -1, -1),
        Among(u"du", -1, -1),
        Among(u"tu", -1, -1),
        Among(u"d\u00FC", -1, -1),
        Among(u"t\u00FC", -1, -1),
        Among(u"d\u0131", -1, -1),
        Among(u"t\u0131", -1, -1)
    ]

    a_21 = [
        Among(u"sa", -1, -1),
        Among(u"se", -1, -1),
        Among(u"sak", -1, -1),
        Among(u"sek", -1, -1),
        Among(u"sam", -1, -1),
        Among(u"sem", -1, -1),
        Among(u"san", -1, -1),
        Among(u"sen", -1, -1)
    ]

    a_22 = [
        Among(u"mi\u015F", -1, -1),
        Among(u"mu\u015F", -1, -1),
        Among(u"m\u00FC\u015F", -1, -1),
        Among(u"m\u0131\u015F", -1, -1)
    ]

    a_23 = [
        Among(u"b", -1, 1),
        Among(u"c", -1, 2),
        Among(u"d", -1, 3),
        Among(u"\u011F", -1, 4)
    ]

    g_vowel = [17, 65, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 8, 0, 0, 0, 0, 0, 0, 1]

    g_U = [1, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 1]

    g_vowel1 = [1, 64, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1]

    g_vowel2 = [17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130]

    g_vowel3 = [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1]

    g_vowel4 = [17]

    g_vowel5 = [65]

    g_vowel6 = [65]

    B_continue_stemming_noun_suffixes = False


    def __r_check_vowel_harmony(self):
        # (, line 109
        # test, line 110
        v_1 = self.limit - self.cursor
        # (, line 111
        # (, line 112
        # goto, line 112
        try:
            while True:
                v_2 = self.limit - self.cursor
                try:
                    if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                        raise lab1()
                    self.cursor = self.limit - v_2
                    raise lab0()
                except lab1: pass
                self.cursor = self.limit - v_2
                if self.cursor <= self.limit_backward:
                    return False
                self.cursor -= 1
        except lab0: pass
        # (, line 113
        # or, line 114
        try:
            v_3 = self.limit - self.cursor
            try:
                # (, line 114
                # literal, line 114
                if not self.eq_s_b(u"a"):
                    raise lab3()
                # goto, line 114
                try:
                    while True:
                        v_4 = self.limit - self.cursor
                        try:
                            if not self.in_grouping_b(TurkishStemmer.g_vowel1, 97, 305):
                                raise lab5()
                            self.cursor = self.limit - v_4
                            raise lab4()
                        except lab5: pass
                        self.cursor = self.limit - v_4
                        if self.cursor <= self.limit_backward:
                            raise lab3()
                        self.cursor -= 1
                except lab4: pass
                raise lab2()
            except lab3: pass
            self.cursor = self.limit - v_3
            try:
                # (, line 115
                # literal, line 115
                if not self.eq_s_b(u"e"):
                    raise lab6()
                # goto, line 115
                try:
                    while True:
                        v_5 = self.limit - self.cursor
                        try:
                            if not self.in_grouping_b(TurkishStemmer.g_vowel2, 101, 252):
                                raise lab8()
                            self.cursor = self.limit - v_5
                            raise lab7()
                        except lab8: pass
                        self.cursor = self.limit - v_5
                        if self.cursor <= self.limit_backward:
                            raise lab6()
                        self.cursor -= 1
                except lab7: pass
                raise lab2()
            except lab6: pass
            self.cursor = self.limit - v_3
            try:
                # (, line 116
                # literal, line 116
                if not self.eq_s_b(u"\u0131"):
                    raise lab9()
                # goto, line 116
                try:
                    while True:
                        v_6 = self.limit - self.cursor
                        try:
                            if not self.in_grouping_b(TurkishStemmer.g_vowel3, 97, 305):
                                raise lab11()
                            self.cursor = self.limit - v_6
                            raise lab10()
                        except lab11: pass
                        self.cursor = self.limit - v_6
                        if self.cursor <= self.limit_backward:
                            raise lab9()
                        self.cursor -= 1
                except lab10: pass
                raise lab2()
            except lab9: pass
            self.cursor = self.limit - v_3
            try:
                # (, line 117
                # literal, line 117
                if not self.eq_s_b(u"i"):
                    raise lab12()
                # goto, line 117
                try:
                    while True:
                        v_7 = self.limit - self.cursor
                        try:
                            if not self.in_grouping_b(TurkishStemmer.g_vowel4, 101, 105):
                                raise lab14()
                            self.cursor = self.limit - v_7
                            raise lab13()
                        except lab14: pass
                        self.cursor = self.limit - v_7
                        if self.cursor <= self.limit_backward:
                            raise lab12()
                        self.cursor -= 1
                except lab13: pass
                raise lab2()
            except lab12: pass
            self.cursor = self.limit - v_3
            try:
                # (, line 118
                # literal, line 118
                if not self.eq_s_b(u"o"):
                    raise lab15()
                # goto, line 118
                try:
                    while True:
                        v_8 = self.limit - self.cursor
                        try:
                            if not self.in_grouping_b(TurkishStemmer.g_vowel5, 111, 117):
                                raise lab17()
                            self.cursor = self.limit - v_8
                            raise lab16()
                        except lab17: pass
                        self.cursor = self.limit - v_8
                        if self.cursor <= self.limit_backward:
                            raise lab15()
                        self.cursor -= 1
                except lab16: pass
                raise lab2()
            except lab15: pass
            self.cursor = self.limit - v_3
            try:
                # (, line 119
                # literal, line 119
                if not self.eq_s_b(u"\u00F6"):
                    raise lab18()
                # goto, line 119
                try:
                    while True:
                        v_9 = self.limit - self.cursor
                        try:
                            if not self.in_grouping_b(TurkishStemmer.g_vowel6, 246, 252):
                                raise lab20()
                            self.cursor = self.limit - v_9
                            raise lab19()
                        except lab20: pass
                        self.cursor = self.limit - v_9
                        if self.cursor <= self.limit_backward:
                            raise lab18()
                        self.cursor -= 1
                except lab19: pass
                raise lab2()
            except lab18: pass
            self.cursor = self.limit - v_3
            try:
                # (, line 120
                # literal, line 120
                if not self.eq_s_b(u"u"):
                    raise lab21()
                # goto, line 120
                try:
                    while True:
                        v_10 = self.limit - self.cursor
                        try:
                            if not self.in_grouping_b(TurkishStemmer.g_vowel5, 111, 117):
                                raise lab23()
                            self.cursor = self.limit - v_10
                            raise lab22()
                        except lab23: pass
                        self.cursor = self.limit - v_10
                        if self.cursor <= self.limit_backward:
                            raise lab21()
                        self.cursor -= 1
                except lab22: pass
                raise lab2()
            except lab21: pass
            self.cursor = self.limit - v_3
            # (, line 121
            # literal, line 121
            if not self.eq_s_b(u"\u00FC"):
                return False
            # goto, line 121
            try:
                while True:
                    v_11 = self.limit - self.cursor
                    try:
                        if not self.in_grouping_b(TurkishStemmer.g_vowel6, 246, 252):
                            raise lab25()
                        self.cursor = self.limit - v_11
                        raise lab24()
                    except lab25: pass
                    self.cursor = self.limit - v_11
                    if self.cursor <= self.limit_backward:
                        return False
                    self.cursor -= 1
            except lab24: pass
        except lab2: pass
        self.cursor = self.limit - v_1
        return True

    def __r_mark_suffix_with_optional_n_consonant(self):
        # (, line 130
        # or, line 132
        try:
            v_1 = self.limit - self.cursor
            try:
                # (, line 131
                # literal, line 131
                if not self.eq_s_b(u"n"):
                    raise lab1()
                # (, line 131
                # test, line 131
                v_2 = self.limit - self.cursor
                if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab1()
                self.cursor = self.limit - v_2
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            # (, line 133
            # (, line 133
            # not, line 133
            v_3 = self.limit - self.cursor
            try:
                # (, line 133
                # test, line 133
                v_4 = self.limit - self.cursor
                # literal, line 133
                if not self.eq_s_b(u"n"):
                    raise lab2()
                self.cursor = self.limit - v_4
                return False
            except lab2: pass
            self.cursor = self.limit - v_3
            # test, line 133
            v_5 = self.limit - self.cursor
            # (, line 133
            # next, line 133
            if self.cursor <= self.limit_backward:
                return False
            self.cursor -= 1
            if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                return False
            self.cursor = self.limit - v_5
        except lab0: pass
        return True

    def __r_mark_suffix_with_optional_s_consonant(self):
        # (, line 141
        # or, line 143
        try:
            v_1 = self.limit - self.cursor
            try:
                # (, line 142
                # literal, line 142
                if not self.eq_s_b(u"s"):
                    raise lab1()
                # (, line 142
                # test, line 142
                v_2 = self.limit - self.cursor
                if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab1()
                self.cursor = self.limit - v_2
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            # (, line 144
            # (, line 144
            # not, line 144
            v_3 = self.limit - self.cursor
            try:
                # (, line 144
                # test, line 144
                v_4 = self.limit - self.cursor
                # literal, line 144
                if not self.eq_s_b(u"s"):
                    raise lab2()
                self.cursor = self.limit - v_4
                return False
            except lab2: pass
            self.cursor = self.limit - v_3
            # test, line 144
            v_5 = self.limit - self.cursor
            # (, line 144
            # next, line 144
            if self.cursor <= self.limit_backward:
                return False
            self.cursor -= 1
            if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                return False
            self.cursor = self.limit - v_5
        except lab0: pass
        return True

    def __r_mark_suffix_with_optional_y_consonant(self):
        # (, line 151
        # or, line 153
        try:
            v_1 = self.limit - self.cursor
            try:
                # (, line 152
                # literal, line 152
                if not self.eq_s_b(u"y"):
                    raise lab1()
                # (, line 152
                # test, line 152
                v_2 = self.limit - self.cursor
                if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab1()
                self.cursor = self.limit - v_2
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            # (, line 154
            # (, line 154
            # not, line 154
            v_3 = self.limit - self.cursor
            try:
                # (, line 154
                # test, line 154
                v_4 = self.limit - self.cursor
                # literal, line 154
                if not self.eq_s_b(u"y"):
                    raise lab2()
                self.cursor = self.limit - v_4
                return False
            except lab2: pass
            self.cursor = self.limit - v_3
            # test, line 154
            v_5 = self.limit - self.cursor
            # (, line 154
            # next, line 154
            if self.cursor <= self.limit_backward:
                return False
            self.cursor -= 1
            if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                return False
            self.cursor = self.limit - v_5
        except lab0: pass
        return True

    def __r_mark_suffix_with_optional_U_vowel(self):
        # (, line 157
        # or, line 159
        try:
            v_1 = self.limit - self.cursor
            try:
                # (, line 158
                if not self.in_grouping_b(TurkishStemmer.g_U, 105, 305):
                    raise lab1()
                # (, line 158
                # test, line 158
                v_2 = self.limit - self.cursor
                if not self.out_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                    raise lab1()
                self.cursor = self.limit - v_2
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            # (, line 160
            # (, line 160
            # not, line 160
            v_3 = self.limit - self.cursor
            try:
                # (, line 160
                # test, line 160
                v_4 = self.limit - self.cursor
                if not self.in_grouping_b(TurkishStemmer.g_U, 105, 305):
                    raise lab2()
                self.cursor = self.limit - v_4
                return False
            except lab2: pass
            self.cursor = self.limit - v_3
            # test, line 160
            v_5 = self.limit - self.cursor
            # (, line 160
            # next, line 160
            if self.cursor <= self.limit_backward:
                return False
            self.cursor -= 1
            if not self.out_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                return False
            self.cursor = self.limit - v_5
        except lab0: pass
        return True

    def __r_mark_possessives(self):
        # (, line 164
        # among, line 165
        if self.find_among_b(TurkishStemmer.a_0) == 0:
            return False
        # (, line 167
        # call mark_suffix_with_optional_U_vowel, line 167
        if not self.__r_mark_suffix_with_optional_U_vowel():
            return False
        return True

    def __r_mark_sU(self):
        # (, line 170
        # call check_vowel_harmony, line 171
        if not self.__r_check_vowel_harmony():
            return False
        if not self.in_grouping_b(TurkishStemmer.g_U, 105, 305):
            return False
        # (, line 173
        # call mark_suffix_with_optional_s_consonant, line 173
        if not self.__r_mark_suffix_with_optional_s_consonant():
            return False
        return True

    def __r_mark_lArI(self):
        # (, line 176
        # among, line 177
        if self.find_among_b(TurkishStemmer.a_1) == 0:
            return False
        return True

    def __r_mark_yU(self):
        # (, line 180
        # call check_vowel_harmony, line 181
        if not self.__r_check_vowel_harmony():
            return False
        if not self.in_grouping_b(TurkishStemmer.g_U, 105, 305):
            return False
        # (, line 183
        # call mark_suffix_with_optional_y_consonant, line 183
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_nU(self):
        # (, line 186
        # call check_vowel_harmony, line 187
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 188
        if self.find_among_b(TurkishStemmer.a_2) == 0:
            return False
        return True

    def __r_mark_nUn(self):
        # (, line 191
        # call check_vowel_harmony, line 192
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 193
        if self.find_among_b(TurkishStemmer.a_3) == 0:
            return False
        # (, line 194
        # call mark_suffix_with_optional_n_consonant, line 194
        if not self.__r_mark_suffix_with_optional_n_consonant():
            return False
        return True

    def __r_mark_yA(self):
        # (, line 197
        # call check_vowel_harmony, line 198
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 199
        if self.find_among_b(TurkishStemmer.a_4) == 0:
            return False
        # (, line 200
        # call mark_suffix_with_optional_y_consonant, line 200
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_nA(self):
        # (, line 203
        # call check_vowel_harmony, line 204
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 205
        if self.find_among_b(TurkishStemmer.a_5) == 0:
            return False
        return True

    def __r_mark_DA(self):
        # (, line 208
        # call check_vowel_harmony, line 209
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 210
        if self.find_among_b(TurkishStemmer.a_6) == 0:
            return False
        return True

    def __r_mark_ndA(self):
        # (, line 213
        # call check_vowel_harmony, line 214
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 215
        if self.find_among_b(TurkishStemmer.a_7) == 0:
            return False
        return True

    def __r_mark_DAn(self):
        # (, line 218
        # call check_vowel_harmony, line 219
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 220
        if self.find_among_b(TurkishStemmer.a_8) == 0:
            return False
        return True

    def __r_mark_ndAn(self):
        # (, line 223
        # call check_vowel_harmony, line 224
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 225
        if self.find_among_b(TurkishStemmer.a_9) == 0:
            return False
        return True

    def __r_mark_ylA(self):
        # (, line 228
        # call check_vowel_harmony, line 229
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 230
        if self.find_among_b(TurkishStemmer.a_10) == 0:
            return False
        # (, line 231
        # call mark_suffix_with_optional_y_consonant, line 231
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_ki(self):
        # (, line 234
        # literal, line 235
        if not self.eq_s_b(u"ki"):
            return False
        return True

    def __r_mark_ncA(self):
        # (, line 238
        # call check_vowel_harmony, line 239
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 240
        if self.find_among_b(TurkishStemmer.a_11) == 0:
            return False
        # (, line 241
        # call mark_suffix_with_optional_n_consonant, line 241
        if not self.__r_mark_suffix_with_optional_n_consonant():
            return False
        return True

    def __r_mark_yUm(self):
        # (, line 244
        # call check_vowel_harmony, line 245
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 246
        if self.find_among_b(TurkishStemmer.a_12) == 0:
            return False
        # (, line 247
        # call mark_suffix_with_optional_y_consonant, line 247
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_sUn(self):
        # (, line 250
        # call check_vowel_harmony, line 251
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 252
        if self.find_among_b(TurkishStemmer.a_13) == 0:
            return False
        return True

    def __r_mark_yUz(self):
        # (, line 255
        # call check_vowel_harmony, line 256
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 257
        if self.find_among_b(TurkishStemmer.a_14) == 0:
            return False
        # (, line 258
        # call mark_suffix_with_optional_y_consonant, line 258
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_sUnUz(self):
        # (, line 261
        # among, line 262
        if self.find_among_b(TurkishStemmer.a_15) == 0:
            return False
        return True

    def __r_mark_lAr(self):
        # (, line 265
        # call check_vowel_harmony, line 266
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 267
        if self.find_among_b(TurkishStemmer.a_16) == 0:
            return False
        return True

    def __r_mark_nUz(self):
        # (, line 270
        # call check_vowel_harmony, line 271
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 272
        if self.find_among_b(TurkishStemmer.a_17) == 0:
            return False
        return True

    def __r_mark_DUr(self):
        # (, line 275
        # call check_vowel_harmony, line 276
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 277
        if self.find_among_b(TurkishStemmer.a_18) == 0:
            return False
        return True

    def __r_mark_cAsInA(self):
        # (, line 280
        # among, line 281
        if self.find_among_b(TurkishStemmer.a_19) == 0:
            return False
        return True

    def __r_mark_yDU(self):
        # (, line 284
        # call check_vowel_harmony, line 285
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 286
        if self.find_among_b(TurkishStemmer.a_20) == 0:
            return False
        # (, line 290
        # call mark_suffix_with_optional_y_consonant, line 290
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_ysA(self):
        # (, line 294
        # among, line 295
        if self.find_among_b(TurkishStemmer.a_21) == 0:
            return False
        # (, line 296
        # call mark_suffix_with_optional_y_consonant, line 296
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_ymUs_(self):
        # (, line 299
        # call check_vowel_harmony, line 300
        if not self.__r_check_vowel_harmony():
            return False
        # among, line 301
        if self.find_among_b(TurkishStemmer.a_22) == 0:
            return False
        # (, line 302
        # call mark_suffix_with_optional_y_consonant, line 302
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_mark_yken(self):
        # (, line 305
        # literal, line 306
        if not self.eq_s_b(u"ken"):
            return False
        # (, line 306
        # call mark_suffix_with_optional_y_consonant, line 306
        if not self.__r_mark_suffix_with_optional_y_consonant():
            return False
        return True

    def __r_stem_nominal_verb_suffixes(self):
        # (, line 309
        # [, line 310
        self.ket = self.cursor
        # set continue_stemming_noun_suffixes, line 311
        self.B_continue_stemming_noun_suffixes = True
        # or, line 313
        try:
            v_1 = self.limit - self.cursor
            try:
                # (, line 312
                # or, line 312
                try:
                    v_2 = self.limit - self.cursor
                    try:
                        # call mark_ymUs_, line 312
                        if not self.__r_mark_ymUs_():
                            raise lab3()
                        raise lab2()
                    except lab3: pass
                    self.cursor = self.limit - v_2
                    try:
                        # call mark_yDU, line 312
                        if not self.__r_mark_yDU():
                            raise lab4()
                        raise lab2()
                    except lab4: pass
                    self.cursor = self.limit - v_2
                    try:
                        # call mark_ysA, line 312
                        if not self.__r_mark_ysA():
                            raise lab5()
                        raise lab2()
                    except lab5: pass
                    self.cursor = self.limit - v_2
                    # call mark_yken, line 312
                    if not self.__r_mark_yken():
                        raise lab1()
                except lab2: pass
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 314
                # call mark_cAsInA, line 314
                if not self.__r_mark_cAsInA():
                    raise lab6()
                # (, line 314
                # or, line 314
                try:
                    v_3 = self.limit - self.cursor
                    try:
                        # call mark_sUnUz, line 314
                        if not self.__r_mark_sUnUz():
                            raise lab8()
                        raise lab7()
                    except lab8: pass
                    self.cursor = self.limit - v_3
                    try:
                        # call mark_lAr, line 314
                        if not self.__r_mark_lAr():
                            raise lab9()
                        raise lab7()
                    except lab9: pass
                    self.cursor = self.limit - v_3
                    try:
                        # call mark_yUm, line 314
                        if not self.__r_mark_yUm():
                            raise lab10()
                        raise lab7()
                    except lab10: pass
                    self.cursor = self.limit - v_3
                    try:
                        # call mark_sUn, line 314
                        if not self.__r_mark_sUn():
                            raise lab11()
                        raise lab7()
                    except lab11: pass
                    self.cursor = self.limit - v_3
                    try:
                        # call mark_yUz, line 314
                        if not self.__r_mark_yUz():
                            raise lab12()
                        raise lab7()
                    except lab12: pass
                    self.cursor = self.limit - v_3
                except lab7: pass
                # call mark_ymUs_, line 314
                if not self.__r_mark_ymUs_():
                    raise lab6()
                raise lab0()
            except lab6: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 316
                # call mark_lAr, line 317
                if not self.__r_mark_lAr():
                    raise lab13()
                # ], line 317
                self.bra = self.cursor
                # delete, line 317
                if not self.slice_del():
                    return False

                # try, line 317
                v_4 = self.limit - self.cursor
                try:
                    # (, line 317
                    # [, line 317
                    self.ket = self.cursor
                    # (, line 317
                    # or, line 317
                    try:
                        v_5 = self.limit - self.cursor
                        try:
                            # call mark_DUr, line 317
                            if not self.__r_mark_DUr():
                                raise lab16()
                            raise lab15()
                        except lab16: pass
                        self.cursor = self.limit - v_5
                        try:
                            # call mark_yDU, line 317
                            if not self.__r_mark_yDU():
                                raise lab17()
                            raise lab15()
                        except lab17: pass
                        self.cursor = self.limit - v_5
                        try:
                            # call mark_ysA, line 317
                            if not self.__r_mark_ysA():
                                raise lab18()
                            raise lab15()
                        except lab18: pass
                        self.cursor = self.limit - v_5
                        # call mark_ymUs_, line 317
                        if not self.__r_mark_ymUs_():
                            self.cursor = self.limit - v_4
                            raise lab14()
                    except lab15: pass
                except lab14: pass
                # unset continue_stemming_noun_suffixes, line 318
                self.B_continue_stemming_noun_suffixes = False
                raise lab0()
            except lab13: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 321
                # call mark_nUz, line 321
                if not self.__r_mark_nUz():
                    raise lab19()
                # (, line 321
                # or, line 321
                try:
                    v_6 = self.limit - self.cursor
                    try:
                        # call mark_yDU, line 321
                        if not self.__r_mark_yDU():
                            raise lab21()
                        raise lab20()
                    except lab21: pass
                    self.cursor = self.limit - v_6
                    # call mark_ysA, line 321
                    if not self.__r_mark_ysA():
                        raise lab19()
                except lab20: pass
                raise lab0()
            except lab19: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 323
                # (, line 323
                # or, line 323
                try:
                    v_7 = self.limit - self.cursor
                    try:
                        # call mark_sUnUz, line 323
                        if not self.__r_mark_sUnUz():
                            raise lab24()
                        raise lab23()
                    except lab24: pass
                    self.cursor = self.limit - v_7
                    try:
                        # call mark_yUz, line 323
                        if not self.__r_mark_yUz():
                            raise lab25()
                        raise lab23()
                    except lab25: pass
                    self.cursor = self.limit - v_7
                    try:
                        # call mark_sUn, line 323
                        if not self.__r_mark_sUn():
                            raise lab26()
                        raise lab23()
                    except lab26: pass
                    self.cursor = self.limit - v_7
                    # call mark_yUm, line 323
                    if not self.__r_mark_yUm():
                        raise lab22()
                except lab23: pass
                # ], line 323
                self.bra = self.cursor
                # delete, line 323
                if not self.slice_del():
                    return False

                # try, line 323
                v_8 = self.limit - self.cursor
                try:
                    # (, line 323
                    # [, line 323
                    self.ket = self.cursor
                    # call mark_ymUs_, line 323
                    if not self.__r_mark_ymUs_():
                        self.cursor = self.limit - v_8
                        raise lab27()
                except lab27: pass
                raise lab0()
            except lab22: pass
            self.cursor = self.limit - v_1
            # (, line 325
            # call mark_DUr, line 325
            if not self.__r_mark_DUr():
                return False
            # ], line 325
            self.bra = self.cursor
            # delete, line 325
            if not self.slice_del():
                return False

            # try, line 325
            v_9 = self.limit - self.cursor
            try:
                # (, line 325
                # [, line 325
                self.ket = self.cursor
                # (, line 325
                # or, line 325
                try:
                    v_10 = self.limit - self.cursor
                    try:
                        # call mark_sUnUz, line 325
                        if not self.__r_mark_sUnUz():
                            raise lab30()
                        raise lab29()
                    except lab30: pass
                    self.cursor = self.limit - v_10
                    try:
                        # call mark_lAr, line 325
                        if not self.__r_mark_lAr():
                            raise lab31()
                        raise lab29()
                    except lab31: pass
                    self.cursor = self.limit - v_10
                    try:
                        # call mark_yUm, line 325
                        if not self.__r_mark_yUm():
                            raise lab32()
                        raise lab29()
                    except lab32: pass
                    self.cursor = self.limit - v_10
                    try:
                        # call mark_sUn, line 325
                        if not self.__r_mark_sUn():
                            raise lab33()
                        raise lab29()
                    except lab33: pass
                    self.cursor = self.limit - v_10
                    try:
                        # call mark_yUz, line 325
                        if not self.__r_mark_yUz():
                            raise lab34()
                        raise lab29()
                    except lab34: pass
                    self.cursor = self.limit - v_10
                except lab29: pass
                # call mark_ymUs_, line 325
                if not self.__r_mark_ymUs_():
                    self.cursor = self.limit - v_9
                    raise lab28()
            except lab28: pass
        except lab0: pass
        # ], line 326
        self.bra = self.cursor
        # delete, line 326
        if not self.slice_del():
            return False

        return True

    def __r_stem_suffix_chain_before_ki(self):
        # (, line 330
        # [, line 331
        self.ket = self.cursor
        # call mark_ki, line 332
        if not self.__r_mark_ki():
            return False
        # (, line 333
        # or, line 340
        try:
            v_1 = self.limit - self.cursor
            try:
                # (, line 334
                # call mark_DA, line 334
                if not self.__r_mark_DA():
                    raise lab1()
                # ], line 334
                self.bra = self.cursor
                # delete, line 334
                if not self.slice_del():
                    return False

                # try, line 334
                v_2 = self.limit - self.cursor
                try:
                    # (, line 334
                    # [, line 334
                    self.ket = self.cursor
                    # or, line 336
                    try:
                        v_3 = self.limit - self.cursor
                        try:
                            # (, line 335
                            # call mark_lAr, line 335
                            if not self.__r_mark_lAr():
                                raise lab4()
                            # ], line 335
                            self.bra = self.cursor
                            # delete, line 335
                            if not self.slice_del():
                                return False

                            # try, line 335
                            v_4 = self.limit - self.cursor
                            try:
                                # (, line 335
                                # call stem_suffix_chain_before_ki, line 335
                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_4
                                    raise lab5()
                            except lab5: pass
                            raise lab3()
                        except lab4: pass
                        self.cursor = self.limit - v_3
                        # (, line 337
                        # call mark_possessives, line 337
                        if not self.__r_mark_possessives():
                            self.cursor = self.limit - v_2
                            raise lab2()
                        # ], line 337
                        self.bra = self.cursor
                        # delete, line 337
                        if not self.slice_del():
                            return False

                        # try, line 337
                        v_5 = self.limit - self.cursor
                        try:
                            # (, line 337
                            # [, line 337
                            self.ket = self.cursor
                            # call mark_lAr, line 337
                            if not self.__r_mark_lAr():
                                self.cursor = self.limit - v_5
                                raise lab6()
                            # ], line 337
                            self.bra = self.cursor
                            # delete, line 337
                            if not self.slice_del():
                                return False

                            # call stem_suffix_chain_before_ki, line 337
                            if not self.__r_stem_suffix_chain_before_ki():
                                self.cursor = self.limit - v_5
                                raise lab6()
                        except lab6: pass
                    except lab3: pass
                except lab2: pass
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 341
                # call mark_nUn, line 341
                if not self.__r_mark_nUn():
                    raise lab7()
                # ], line 341
                self.bra = self.cursor
                # delete, line 341
                if not self.slice_del():
                    return False

                # try, line 341
                v_6 = self.limit - self.cursor
                try:
                    # (, line 341
                    # [, line 341
                    self.ket = self.cursor
                    # or, line 343
                    try:
                        v_7 = self.limit - self.cursor
                        try:
                            # (, line 342
                            # call mark_lArI, line 342
                            if not self.__r_mark_lArI():
                                raise lab10()
                            # ], line 342
                            self.bra = self.cursor
                            # delete, line 342
                            if not self.slice_del():
                                return False

                            raise lab9()
                        except lab10: pass
                        self.cursor = self.limit - v_7
                        try:
                            # (, line 344
                            # [, line 344
                            self.ket = self.cursor
                            # or, line 344
                            try:
                                v_8 = self.limit - self.cursor
                                try:
                                    # call mark_possessives, line 344
                                    if not self.__r_mark_possessives():
                                        raise lab13()
                                    raise lab12()
                                except lab13: pass
                                self.cursor = self.limit - v_8
                                # call mark_sU, line 344
                                if not self.__r_mark_sU():
                                    raise lab11()
                            except lab12: pass
                            # ], line 344
                            self.bra = self.cursor
                            # delete, line 344
                            if not self.slice_del():
                                return False

                            # try, line 344
                            v_9 = self.limit - self.cursor
                            try:
                                # (, line 344
                                # [, line 344
                                self.ket = self.cursor
                                # call mark_lAr, line 344
                                if not self.__r_mark_lAr():
                                    self.cursor = self.limit - v_9
                                    raise lab14()
                                # ], line 344
                                self.bra = self.cursor
                                # delete, line 344
                                if not self.slice_del():
                                    return False

                                # call stem_suffix_chain_before_ki, line 344
                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_9
                                    raise lab14()
                            except lab14: pass
                            raise lab9()
                        except lab11: pass
                        self.cursor = self.limit - v_7
                        # (, line 346
                        # call stem_suffix_chain_before_ki, line 346
                        if not self.__r_stem_suffix_chain_before_ki():
                            self.cursor = self.limit - v_6
                            raise lab8()
                    except lab9: pass
                except lab8: pass
                raise lab0()
            except lab7: pass
            self.cursor = self.limit - v_1
            # (, line 349
            # call mark_ndA, line 349
            if not self.__r_mark_ndA():
                return False
            # (, line 349
            # or, line 351
            try:
                v_10 = self.limit - self.cursor
                try:
                    # (, line 350
                    # call mark_lArI, line 350
                    if not self.__r_mark_lArI():
                        raise lab16()
                    # ], line 350
                    self.bra = self.cursor
                    # delete, line 350
                    if not self.slice_del():
                        return False

                    raise lab15()
                except lab16: pass
                self.cursor = self.limit - v_10
                try:
                    # (, line 352
                    # (, line 352
                    # call mark_sU, line 352
                    if not self.__r_mark_sU():
                        raise lab17()
                    # ], line 352
                    self.bra = self.cursor
                    # delete, line 352
                    if not self.slice_del():
                        return False

                    # try, line 352
                    v_11 = self.limit - self.cursor
                    try:
                        # (, line 352
                        # [, line 352
                        self.ket = self.cursor
                        # call mark_lAr, line 352
                        if not self.__r_mark_lAr():
                            self.cursor = self.limit - v_11
                            raise lab18()
                        # ], line 352
                        self.bra = self.cursor
                        # delete, line 352
                        if not self.slice_del():
                            return False

                        # call stem_suffix_chain_before_ki, line 352
                        if not self.__r_stem_suffix_chain_before_ki():
                            self.cursor = self.limit - v_11
                            raise lab18()
                    except lab18: pass
                    raise lab15()
                except lab17: pass
                self.cursor = self.limit - v_10
                # (, line 354
                # call stem_suffix_chain_before_ki, line 354
                if not self.__r_stem_suffix_chain_before_ki():
                    return False
            except lab15: pass
        except lab0: pass
        return True

    def __r_stem_noun_suffixes(self):
        # (, line 359
        # or, line 361
        try:
            v_1 = self.limit - self.cursor
            try:
                # (, line 360
                # [, line 360
                self.ket = self.cursor
                # call mark_lAr, line 360
                if not self.__r_mark_lAr():
                    raise lab1()
                # ], line 360
                self.bra = self.cursor
                # delete, line 360
                if not self.slice_del():
                    return False

                # try, line 360
                v_2 = self.limit - self.cursor
                try:
                    # (, line 360
                    # call stem_suffix_chain_before_ki, line 360
                    if not self.__r_stem_suffix_chain_before_ki():
                        self.cursor = self.limit - v_2
                        raise lab2()
                except lab2: pass
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 362
                # [, line 362
                self.ket = self.cursor
                # call mark_ncA, line 362
                if not self.__r_mark_ncA():
                    raise lab3()
                # ], line 362
                self.bra = self.cursor
                # delete, line 362
                if not self.slice_del():
                    return False

                # try, line 363
                v_3 = self.limit - self.cursor
                try:
                    # (, line 363
                    # or, line 365
                    try:
                        v_4 = self.limit - self.cursor
                        try:
                            # (, line 364
                            # [, line 364
                            self.ket = self.cursor
                            # call mark_lArI, line 364
                            if not self.__r_mark_lArI():
                                raise lab6()
                            # ], line 364
                            self.bra = self.cursor
                            # delete, line 364
                            if not self.slice_del():
                                return False

                            raise lab5()
                        except lab6: pass
                        self.cursor = self.limit - v_4
                        try:
                            # (, line 366
                            # [, line 366
                            self.ket = self.cursor
                            # or, line 366
                            try:
                                v_5 = self.limit - self.cursor
                                try:
                                    # call mark_possessives, line 366
                                    if not self.__r_mark_possessives():
                                        raise lab9()
                                    raise lab8()
                                except lab9: pass
                                self.cursor = self.limit - v_5
                                # call mark_sU, line 366
                                if not self.__r_mark_sU():
                                    raise lab7()
                            except lab8: pass
                            # ], line 366
                            self.bra = self.cursor
                            # delete, line 366
                            if not self.slice_del():
                                return False

                            # try, line 366
                            v_6 = self.limit - self.cursor
                            try:
                                # (, line 366
                                # [, line 366
                                self.ket = self.cursor
                                # call mark_lAr, line 366
                                if not self.__r_mark_lAr():
                                    self.cursor = self.limit - v_6
                                    raise lab10()
                                # ], line 366
                                self.bra = self.cursor
                                # delete, line 366
                                if not self.slice_del():
                                    return False

                                # call stem_suffix_chain_before_ki, line 366
                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_6
                                    raise lab10()
                            except lab10: pass
                            raise lab5()
                        except lab7: pass
                        self.cursor = self.limit - v_4
                        # (, line 368
                        # [, line 368
                        self.ket = self.cursor
                        # call mark_lAr, line 368
                        if not self.__r_mark_lAr():
                            self.cursor = self.limit - v_3
                            raise lab4()
                        # ], line 368
                        self.bra = self.cursor
                        # delete, line 368
                        if not self.slice_del():
                            return False

                        # call stem_suffix_chain_before_ki, line 368
                        if not self.__r_stem_suffix_chain_before_ki():
                            self.cursor = self.limit - v_3
                            raise lab4()
                    except lab5: pass
                except lab4: pass
                raise lab0()
            except lab3: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 372
                # [, line 372
                self.ket = self.cursor
                # (, line 372
                # or, line 372
                try:
                    v_7 = self.limit - self.cursor
                    try:
                        # call mark_ndA, line 372
                        if not self.__r_mark_ndA():
                            raise lab13()
                        raise lab12()
                    except lab13: pass
                    self.cursor = self.limit - v_7
                    # call mark_nA, line 372
                    if not self.__r_mark_nA():
                        raise lab11()
                except lab12: pass
                # (, line 373
                # or, line 375
                try:
                    v_8 = self.limit - self.cursor
                    try:
                        # (, line 374
                        # call mark_lArI, line 374
                        if not self.__r_mark_lArI():
                            raise lab15()
                        # ], line 374
                        self.bra = self.cursor
                        # delete, line 374
                        if not self.slice_del():
                            return False

                        raise lab14()
                    except lab15: pass
                    self.cursor = self.limit - v_8
                    try:
                        # (, line 376
                        # call mark_sU, line 376
                        if not self.__r_mark_sU():
                            raise lab16()
                        # ], line 376
                        self.bra = self.cursor
                        # delete, line 376
                        if not self.slice_del():
                            return False

                        # try, line 376
                        v_9 = self.limit - self.cursor
                        try:
                            # (, line 376
                            # [, line 376
                            self.ket = self.cursor
                            # call mark_lAr, line 376
                            if not self.__r_mark_lAr():
                                self.cursor = self.limit - v_9
                                raise lab17()
                            # ], line 376
                            self.bra = self.cursor
                            # delete, line 376
                            if not self.slice_del():
                                return False

                            # call stem_suffix_chain_before_ki, line 376
                            if not self.__r_stem_suffix_chain_before_ki():
                                self.cursor = self.limit - v_9
                                raise lab17()
                        except lab17: pass
                        raise lab14()
                    except lab16: pass
                    self.cursor = self.limit - v_8
                    # (, line 378
                    # call stem_suffix_chain_before_ki, line 378
                    if not self.__r_stem_suffix_chain_before_ki():
                        raise lab11()
                except lab14: pass
                raise lab0()
            except lab11: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 382
                # [, line 382
                self.ket = self.cursor
                # (, line 382
                # or, line 382
                try:
                    v_10 = self.limit - self.cursor
                    try:
                        # call mark_ndAn, line 382
                        if not self.__r_mark_ndAn():
                            raise lab20()
                        raise lab19()
                    except lab20: pass
                    self.cursor = self.limit - v_10
                    # call mark_nU, line 382
                    if not self.__r_mark_nU():
                        raise lab18()
                except lab19: pass
                # (, line 382
                # or, line 382
                try:
                    v_11 = self.limit - self.cursor
                    try:
                        # (, line 382
                        # call mark_sU, line 382
                        if not self.__r_mark_sU():
                            raise lab22()
                        # ], line 382
                        self.bra = self.cursor
                        # delete, line 382
                        if not self.slice_del():
                            return False

                        # try, line 382
                        v_12 = self.limit - self.cursor
                        try:
                            # (, line 382
                            # [, line 382
                            self.ket = self.cursor
                            # call mark_lAr, line 382
                            if not self.__r_mark_lAr():
                                self.cursor = self.limit - v_12
                                raise lab23()
                            # ], line 382
                            self.bra = self.cursor
                            # delete, line 382
                            if not self.slice_del():
                                return False

                            # call stem_suffix_chain_before_ki, line 382
                            if not self.__r_stem_suffix_chain_before_ki():
                                self.cursor = self.limit - v_12
                                raise lab23()
                        except lab23: pass
                        raise lab21()
                    except lab22: pass
                    self.cursor = self.limit - v_11
                    # (, line 382
                    # call mark_lArI, line 382
                    if not self.__r_mark_lArI():
                        raise lab18()
                except lab21: pass
                raise lab0()
            except lab18: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 384
                # [, line 384
                self.ket = self.cursor
                # call mark_DAn, line 384
                if not self.__r_mark_DAn():
                    raise lab24()
                # ], line 384
                self.bra = self.cursor
                # delete, line 384
                if not self.slice_del():
                    return False

                # try, line 384
                v_13 = self.limit - self.cursor
                try:
                    # (, line 384
                    # [, line 384
                    self.ket = self.cursor
                    # (, line 385
                    # or, line 387
                    try:
                        v_14 = self.limit - self.cursor
                        try:
                            # (, line 386
                            # call mark_possessives, line 386
                            if not self.__r_mark_possessives():
                                raise lab27()
                            # ], line 386
                            self.bra = self.cursor
                            # delete, line 386
                            if not self.slice_del():
                                return False

                            # try, line 386
                            v_15 = self.limit - self.cursor
                            try:
                                # (, line 386
                                # [, line 386
                                self.ket = self.cursor
                                # call mark_lAr, line 386
                                if not self.__r_mark_lAr():
                                    self.cursor = self.limit - v_15
                                    raise lab28()
                                # ], line 386
                                self.bra = self.cursor
                                # delete, line 386
                                if not self.slice_del():
                                    return False

                                # call stem_suffix_chain_before_ki, line 386
                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_15
                                    raise lab28()
                            except lab28: pass
                            raise lab26()
                        except lab27: pass
                        self.cursor = self.limit - v_14
                        try:
                            # (, line 388
                            # call mark_lAr, line 388
                            if not self.__r_mark_lAr():
                                raise lab29()
                            # ], line 388
                            self.bra = self.cursor
                            # delete, line 388
                            if not self.slice_del():
                                return False

                            # try, line 388
                            v_16 = self.limit - self.cursor
                            try:
                                # (, line 388
                                # call stem_suffix_chain_before_ki, line 388
                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_16
                                    raise lab30()
                            except lab30: pass
                            raise lab26()
                        except lab29: pass
                        self.cursor = self.limit - v_14
                        # (, line 390
                        # call stem_suffix_chain_before_ki, line 390
                        if not self.__r_stem_suffix_chain_before_ki():
                            self.cursor = self.limit - v_13
                            raise lab25()
                    except lab26: pass
                except lab25: pass
                raise lab0()
            except lab24: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 394
                # [, line 394
                self.ket = self.cursor
                # or, line 394
                try:
                    v_17 = self.limit - self.cursor
                    try:
                        # call mark_nUn, line 394
                        if not self.__r_mark_nUn():
                            raise lab33()
                        raise lab32()
                    except lab33: pass
                    self.cursor = self.limit - v_17
                    # call mark_ylA, line 394
                    if not self.__r_mark_ylA():
                        raise lab31()
                except lab32: pass
                # ], line 394
                self.bra = self.cursor
                # delete, line 394
                if not self.slice_del():
                    return False

                # try, line 395
                v_18 = self.limit - self.cursor
                try:
                    # (, line 395
                    # or, line 397
                    try:
                        v_19 = self.limit - self.cursor
                        try:
                            # (, line 396
                            # [, line 396
                            self.ket = self.cursor
                            # call mark_lAr, line 396
                            if not self.__r_mark_lAr():
                                raise lab36()
                            # ], line 396
                            self.bra = self.cursor
                            # delete, line 396
                            if not self.slice_del():
                                return False

                            # call stem_suffix_chain_before_ki, line 396
                            if not self.__r_stem_suffix_chain_before_ki():
                                raise lab36()
                            raise lab35()
                        except lab36: pass
                        self.cursor = self.limit - v_19
                        try:
                            # (, line 398
                            # [, line 398
                            self.ket = self.cursor
                            # or, line 398
                            try:
                                v_20 = self.limit - self.cursor
                                try:
                                    # call mark_possessives, line 398
                                    if not self.__r_mark_possessives():
                                        raise lab39()
                                    raise lab38()
                                except lab39: pass
                                self.cursor = self.limit - v_20
                                # call mark_sU, line 398
                                if not self.__r_mark_sU():
                                    raise lab37()
                            except lab38: pass
                            # ], line 398
                            self.bra = self.cursor
                            # delete, line 398
                            if not self.slice_del():
                                return False

                            # try, line 398
                            v_21 = self.limit - self.cursor
                            try:
                                # (, line 398
                                # [, line 398
                                self.ket = self.cursor
                                # call mark_lAr, line 398
                                if not self.__r_mark_lAr():
                                    self.cursor = self.limit - v_21
                                    raise lab40()
                                # ], line 398
                                self.bra = self.cursor
                                # delete, line 398
                                if not self.slice_del():
                                    return False

                                # call stem_suffix_chain_before_ki, line 398
                                if not self.__r_stem_suffix_chain_before_ki():
                                    self.cursor = self.limit - v_21
                                    raise lab40()
                            except lab40: pass
                            raise lab35()
                        except lab37: pass
                        self.cursor = self.limit - v_19
                        # call stem_suffix_chain_before_ki, line 400
                        if not self.__r_stem_suffix_chain_before_ki():
                            self.cursor = self.limit - v_18
                            raise lab34()
                    except lab35: pass
                except lab34: pass
                raise lab0()
            except lab31: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 404
                # [, line 404
                self.ket = self.cursor
                # call mark_lArI, line 404
                if not self.__r_mark_lArI():
                    raise lab41()
                # ], line 404
                self.bra = self.cursor
                # delete, line 404
                if not self.slice_del():
                    return False

                raise lab0()
            except lab41: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 406
                # call stem_suffix_chain_before_ki, line 406
                if not self.__r_stem_suffix_chain_before_ki():
                    raise lab42()
                raise lab0()
            except lab42: pass
            self.cursor = self.limit - v_1
            try:
                # (, line 408
                # [, line 408
                self.ket = self.cursor
                # or, line 408
                try:
                    v_22 = self.limit - self.cursor
                    try:
                        # call mark_DA, line 408
                        if not self.__r_mark_DA():
                            raise lab45()
                        raise lab44()
                    except lab45: pass
                    self.cursor = self.limit - v_22
                    try:
                        # call mark_yU, line 408
                        if not self.__r_mark_yU():
                            raise lab46()
                        raise lab44()
                    except lab46: pass
                    self.cursor = self.limit - v_22
                    # call mark_yA, line 408
                    if not self.__r_mark_yA():
                        raise lab43()
                except lab44: pass
                # ], line 408
                self.bra = self.cursor
                # delete, line 408
                if not self.slice_del():
                    return False

                # try, line 408
                v_23 = self.limit - self.cursor
                try:
                    # (, line 408
                    # [, line 408
                    self.ket = self.cursor
                    # (, line 408
                    # or, line 408
                    try:
                        v_24 = self.limit - self.cursor
                        try:
                            # (, line 408
                            # call mark_possessives, line 408
                            if not self.__r_mark_possessives():
                                raise lab49()
                            # ], line 408
                            self.bra = self.cursor
                            # delete, line 408
                            if not self.slice_del():
                                return False

                            # try, line 408
                            v_25 = self.limit - self.cursor
                            try:
                                # (, line 408
                                # [, line 408
                                self.ket = self.cursor
                                # call mark_lAr, line 408
                                if not self.__r_mark_lAr():
                                    self.cursor = self.limit - v_25
                                    raise lab50()
                            except lab50: pass
                            raise lab48()
                        except lab49: pass
                        self.cursor = self.limit - v_24
                        # call mark_lAr, line 408
                        if not self.__r_mark_lAr():
                            self.cursor = self.limit - v_23
                            raise lab47()
                    except lab48: pass
                    # ], line 408
                    self.bra = self.cursor
                    # delete, line 408
                    if not self.slice_del():
                        return False

                    # [, line 408
                    self.ket = self.cursor
                    # call stem_suffix_chain_before_ki, line 408
                    if not self.__r_stem_suffix_chain_before_ki():
                        self.cursor = self.limit - v_23
                        raise lab47()
                except lab47: pass
                raise lab0()
            except lab43: pass
            self.cursor = self.limit - v_1
            # (, line 410
            # [, line 410
            self.ket = self.cursor
            # or, line 410
            try:
                v_26 = self.limit - self.cursor
                try:
                    # call mark_possessives, line 410
                    if not self.__r_mark_possessives():
                        raise lab52()
                    raise lab51()
                except lab52: pass
                self.cursor = self.limit - v_26
                # call mark_sU, line 410
                if not self.__r_mark_sU():
                    return False
            except lab51: pass
            # ], line 410
            self.bra = self.cursor
            # delete, line 410
            if not self.slice_del():
                return False

            # try, line 410
            v_27 = self.limit - self.cursor
            try:
                # (, line 410
                # [, line 410
                self.ket = self.cursor
                # call mark_lAr, line 410
                if not self.__r_mark_lAr():
                    self.cursor = self.limit - v_27
                    raise lab53()
                # ], line 410
                self.bra = self.cursor
                # delete, line 410
                if not self.slice_del():
                    return False

                # call stem_suffix_chain_before_ki, line 410
                if not self.__r_stem_suffix_chain_before_ki():
                    self.cursor = self.limit - v_27
                    raise lab53()
            except lab53: pass
        except lab0: pass
        return True

    def __r_post_process_last_consonants(self):
        # (, line 413
        # [, line 414
        self.ket = self.cursor
        # substring, line 414
        among_var = self.find_among_b(TurkishStemmer.a_23)
        if among_var == 0:
            return False
        # ], line 414
        self.bra = self.cursor
        if among_var == 1:
            # (, line 415
            # <-, line 415
            if not self.slice_from(u"p"):
                return False
        elif among_var == 2:
            # (, line 416
            # <-, line 416
            if not self.slice_from(u"\u00E7"):
                return False
        elif among_var == 3:
            # (, line 417
            # <-, line 417
            if not self.slice_from(u"t"):
                return False
        elif among_var == 4:
            # (, line 418
            # <-, line 418
            if not self.slice_from(u"k"):
                return False
        return True

    def __r_append_U_to_stems_ending_with_d_or_g(self):
        # (, line 428
        # test, line 429
        v_1 = self.limit - self.cursor
        # (, line 429
        # or, line 429
        try:
            v_2 = self.limit - self.cursor
            try:
                # literal, line 429
                if not self.eq_s_b(u"d"):
                    raise lab1()
                raise lab0()
            except lab1: pass
            self.cursor = self.limit - v_2
            # literal, line 429
            if not self.eq_s_b(u"g"):
                return False
        except lab0: pass
        self.cursor = self.limit - v_1
        # or, line 431
        try:
            v_3 = self.limit - self.cursor
            try:
                # (, line 430
                # test, line 430
                v_4 = self.limit - self.cursor
                # (, line 430
                # (, line 430
                # goto, line 430
                try:
                    while True:
                        v_5 = self.limit - self.cursor
                        try:
                            if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                                raise lab5()
                            self.cursor = self.limit - v_5
                            raise lab4()
                        except lab5: pass
                        self.cursor = self.limit - v_5
                        if self.cursor <= self.limit_backward:
                            raise lab3()
                        self.cursor -= 1
                except lab4: pass
                # or, line 430
                try:
                    v_6 = self.limit - self.cursor
                    try:
                        # literal, line 430
                        if not self.eq_s_b(u"a"):
                            raise lab7()
                        raise lab6()
                    except lab7: pass
                    self.cursor = self.limit - v_6
                    # literal, line 430
                    if not self.eq_s_b(u"\u0131"):
                        raise lab3()
                except lab6: pass
                self.cursor = self.limit - v_4
                # <+, line 430
                c = self.cursor
                self.insert(self.cursor, self.cursor, u"\u0131")
                self.cursor = c
                raise lab2()
            except lab3: pass
            self.cursor = self.limit - v_3
            try:
                # (, line 432
                # test, line 432
                v_7 = self.limit - self.cursor
                # (, line 432
                # (, line 432
                # goto, line 432
                try:
                    while True:
                        v_8 = self.limit - self.cursor
                        try:
                            if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                                raise lab10()
                            self.cursor = self.limit - v_8
                            raise lab9()
                        except lab10: pass
                        self.cursor = self.limit - v_8
                        if self.cursor <= self.limit_backward:
                            raise lab8()
                        self.cursor -= 1
                except lab9: pass
                # or, line 432
                try:
                    v_9 = self.limit - self.cursor
                    try:
                        # literal, line 432
                        if not self.eq_s_b(u"e"):
                            raise lab12()
                        raise lab11()
                    except lab12: pass
                    self.cursor = self.limit - v_9
                    # literal, line 432
                    if not self.eq_s_b(u"i"):
                        raise lab8()
                except lab11: pass
                self.cursor = self.limit - v_7
                # <+, line 432
                c = self.cursor
                self.insert(self.cursor, self.cursor, u"i")
                self.cursor = c
                raise lab2()
            except lab8: pass
            self.cursor = self.limit - v_3
            try:
                # (, line 434
                # test, line 434
                v_10 = self.limit - self.cursor
                # (, line 434
                # (, line 434
                # goto, line 434
                try:
                    while True:
                        v_11 = self.limit - self.cursor
                        try:
                            if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                                raise lab15()
                            self.cursor = self.limit - v_11
                            raise lab14()
                        except lab15: pass
                        self.cursor = self.limit - v_11
                        if self.cursor <= self.limit_backward:
                            raise lab13()
                        self.cursor -= 1
                except lab14: pass
                # or, line 434
                try:
                    v_12 = self.limit - self.cursor
                    try:
                        # literal, line 434
                        if not self.eq_s_b(u"o"):
                            raise lab17()
                        raise lab16()
                    except lab17: pass
                    self.cursor = self.limit - v_12
                    # literal, line 434
                    if not self.eq_s_b(u"u"):
                        raise lab13()
                except lab16: pass
                self.cursor = self.limit - v_10
                # <+, line 434
                c = self.cursor
                self.insert(self.cursor, self.cursor, u"u")
                self.cursor = c
                raise lab2()
            except lab13: pass
            self.cursor = self.limit - v_3
            # (, line 436
            # test, line 436
            v_13 = self.limit - self.cursor
            # (, line 436
            # (, line 436
            # goto, line 436
            try:
                while True:
                    v_14 = self.limit - self.cursor
                    try:
                        if not self.in_grouping_b(TurkishStemmer.g_vowel, 97, 305):
                            raise lab19()
                        self.cursor = self.limit - v_14
                        raise lab18()
                    except lab19: pass
                    self.cursor = self.limit - v_14
                    if self.cursor <= self.limit_backward:
                        return False
                    self.cursor -= 1
            except lab18: pass
            # or, line 436
            try:
                v_15 = self.limit - self.cursor
                try:
                    # literal, line 436
                    if not self.eq_s_b(u"\u00F6"):
                        raise lab21()
                    raise lab20()
                except lab21: pass
                self.cursor = self.limit - v_15
                # literal, line 436
                if not self.eq_s_b(u"\u00FC"):
                    return False
            except lab20: pass
            self.cursor = self.limit - v_13
            # <+, line 436
            c = self.cursor
            self.insert(self.cursor, self.cursor, u"\u00FC")
            self.cursor = c
        except lab2: pass
        return True

    def __r_is_reserved_word(self):
        # (, line 439
        # literal, line 440
        if not self.eq_s_b(u"ad"):
            return False
        # try, line 440
        v_1 = self.limit - self.cursor
        try:
            # literal, line 440
            if not self.eq_s_b(u"soy"):
                self.cursor = self.limit - v_1
                raise lab0()
        except lab0: pass
        # atlimit, line 440
        if self.cursor > self.limit_backward:
            return False
        return True

    def __r_more_than_one_syllable_word(self):
        # (, line 446
        # test, line 447
        v_1 = self.cursor
        # (, line 447
        # atleast, line 447
        v_2 = 2
        # atleast, line 447
        try:
            while True:
                try:
                    v_3 = self.cursor
                    try:
                        # (, line 447
                        # gopast, line 447
                        try:
                            while True:
                                try:
                                    if not self.in_grouping(TurkishStemmer.g_vowel, 97, 305):
                                        raise lab4()
                                    raise lab3()
                                except lab4: pass
                                if self.cursor >= self.limit:
                                    raise lab2()
                                self.cursor += 1
                        except lab3: pass
                        v_2 -= 1
                        raise lab1()
                    except lab2: pass
                    self.cursor = v_3
                    raise lab0()
                except lab1: pass
        except lab0: pass
        if v_2 > 0:
            return False
        self.cursor = v_1
        return True

    def __r_postlude(self):
        # (, line 450
        # backwards, line 451
        self.limit_backward = self.cursor
        self.cursor = self.limit
        # (, line 451
        # not, line 452
        v_1 = self.limit - self.cursor
        try:
            # (, line 452
            # call is_reserved_word, line 452
            if not self.__r_is_reserved_word():
                raise lab0()
            return False
        except lab0: pass
        self.cursor = self.limit - v_1
        # do, line 453
        v_2 = self.limit - self.cursor
        # call append_U_to_stems_ending_with_d_or_g, line 453
        self.__r_append_U_to_stems_ending_with_d_or_g()
        self.cursor = self.limit - v_2
        # do, line 454
        v_3 = self.limit - self.cursor
        # call post_process_last_consonants, line 454
        self.__r_post_process_last_consonants()
        self.cursor = self.limit - v_3
        self.cursor = self.limit_backward
        return True

    def _stem(self):
        # (, line 459
        # (, line 460
        # call more_than_one_syllable_word, line 460
        if not self.__r_more_than_one_syllable_word():
            return False
        # (, line 461
        # backwards, line 462
        self.limit_backward = self.cursor
        self.cursor = self.limit
        # (, line 462
        # do, line 463
        v_1 = self.limit - self.cursor
        # call stem_nominal_verb_suffixes, line 463
        self.__r_stem_nominal_verb_suffixes()
        self.cursor = self.limit - v_1
        # Boolean test continue_stemming_noun_suffixes, line 464
        if not self.B_continue_stemming_noun_suffixes:
            return False
        # do, line 465
        v_2 = self.limit - self.cursor
        # call stem_noun_suffixes, line 465
        self.__r_stem_noun_suffixes()
        self.cursor = self.limit - v_2
        self.cursor = self.limit_backward
        # call postlude, line 468
        if not self.__r_postlude():
            return False
        return True


class lab0(BaseException): pass


class lab1(BaseException): pass


class lab2(BaseException): pass


class lab3(BaseException): pass


class lab4(BaseException): pass


class lab5(BaseException): pass


class lab6(BaseException): pass


class lab7(BaseException): pass


class lab8(BaseException): pass


class lab9(BaseException): pass


class lab10(BaseException): pass


class lab11(BaseException): pass


class lab12(BaseException): pass


class lab13(BaseException): pass


class lab14(BaseException): pass


class lab15(BaseException): pass


class lab16(BaseException): pass


class lab17(BaseException): pass


class lab18(BaseException): pass


class lab19(BaseException): pass


class lab20(BaseException): pass


class lab21(BaseException): pass


class lab22(BaseException): pass


class lab23(BaseException): pass


class lab24(BaseException): pass


class lab25(BaseException): pass


class lab26(BaseException): pass


class lab27(BaseException): pass


class lab28(BaseException): pass


class lab29(BaseException): pass


class lab30(BaseException): pass


class lab31(BaseException): pass


class lab32(BaseException): pass


class lab33(BaseException): pass


class lab34(BaseException): pass


class lab35(BaseException): pass


class lab36(BaseException): pass


class lab37(BaseException): pass


class lab38(BaseException): pass


class lab39(BaseException): pass


class lab40(BaseException): pass


class lab41(BaseException): pass


class lab42(BaseException): pass


class lab43(BaseException): pass


class lab44(BaseException): pass


class lab45(BaseException): pass


class lab46(BaseException): pass


class lab47(BaseException): pass


class lab48(BaseException): pass


class lab49(BaseException): pass


class lab50(BaseException): pass


class lab51(BaseException): pass


class lab52(BaseException): pass


class lab53(BaseException): pass
