/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.Timer;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;

public class ProfilerXYTooltipOverlay
extends ChartOverlay
implements ActionListener {
    private static final int TOOLTIP_OFFSET = 15;
    private static final int TOOLTIP_MARGIN = 10;
    private static final int TOOLTIP_RESPONSE = 50;
    private static final int ANIMATION_STEPS = 5;
    private ProfilerXYTooltipPainter tooltipPainter;
    private Timer timer;
    private int currentStep;
    private Point mousePosition;
    private Point targetPosition;

    public ProfilerXYTooltipOverlay(final ChartComponent chartComponent, ProfilerXYTooltipPainter profilerXYTooltipPainter) {
        if (chartComponent.getSelectionModel() == null) {
            throw new NullPointerException("No ChartSelectionModel set for " + chartComponent);
        }
        if (!Utils.forceSpeed()) {
            this.timer = new Timer(10, this);
            this.timer.setInitialDelay(0);
        }
        this.setLayout(null);
        this.tooltipPainter = profilerXYTooltipPainter;
        this.add(profilerXYTooltipPainter);
        profilerXYTooltipPainter.setVisible(false);
        chartComponent.getSelectionModel().addSelectionListener(new ChartSelectionListener(){

            public void selectionModeChanged(int n, int n2) {
            }

            public void selectionBoundsChanged(Rectangle rectangle, Rectangle rectangle2) {
            }

            public void highlightedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
                ProfilerXYTooltipOverlay.this.updateTooltip(chartComponent);
            }

            public void selectedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
            }
        });
        chartComponent.addConfigurationListener((ChartConfigurationListener)new ChartConfigurationListener.Adapter(){

            public void contentsUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4, int n, int n2) {
                ProfilerXYTooltipOverlay.this.updateTooltip(chartComponent);
            }
        });
        chartComponent.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ProfilerXYTooltipOverlay.this.mousePosition = mouseEvent.getPoint();
                ProfilerXYTooltipOverlay.this.updateTooltip(chartComponent);
            }
        });
    }

    public final void setPosition(Point point) {
        if (this.tooltipPainter != null) {
            if (point == null) {
                if (this.tooltipPainter.isVisible()) {
                    this.tooltipPainter.setVisible(false);
                }
                if (this.timer != null) {
                    this.timer.stop();
                }
            } else if (!this.tooltipPainter.isVisible() || this.timer == null) {
                this.tooltipPainter.setVisible(true);
                this.tooltipPainter.setLocation(point);
            } else {
                this.currentStep = 0;
                this.targetPosition = point;
                this.timer.restart();
            }
        }
    }

    public final Point getPosition() {
        if (this.tooltipPainter == null) {
            return null;
        }
        return this.tooltipPainter.getLocation();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Point point = this.tooltipPainter.getLocation();
        point.x += (this.targetPosition.x - point.x) / (5 - this.currentStep);
        point.y += (this.targetPosition.y - point.y) / (5 - this.currentStep);
        this.tooltipPainter.setLocation(point);
        if (++this.currentStep == 5) {
            this.timer.stop();
        }
    }

    private void updateTooltip(ChartComponent chartComponent) {
        XYItemSelection xYItemSelection;
        if (this.mousePosition == null) {
            return;
        }
        List list = chartComponent.getSelectionModel().getHighlightedItems();
        XYItemSelection xYItemSelection2 = xYItemSelection = list.isEmpty() ? null : (XYItemSelection)list.get(0);
        if (xYItemSelection == null || xYItemSelection.getItem().getValuesCount() <= xYItemSelection.getValueIndex()) {
            this.setPosition(null);
        } else {
            this.tooltipPainter.update(list);
            this.tooltipPainter.setSize(this.tooltipPainter.getPreferredSize());
            this.setPosition(list, chartComponent.getPaintersModel(), chartComponent.getChartContext());
        }
    }

    private void setPosition(List<ItemSelection> list, PaintersModel paintersModel, ChartContext chartContext) {
        int n = -1;
        int n2 = this.mousePosition.y;
        for (ItemSelection itemSelection : list) {
            ChartItem chartItem = itemSelection.getItem();
            ItemPainter itemPainter = paintersModel.getPainter(chartItem);
            Rectangle rectangle = Utils.checkedRectangle((LongRect)itemPainter.getSelectionBounds(itemSelection, chartContext));
            if (n != -1) continue;
            n += rectangle.x + rectangle.width / 2;
        }
        this.setPosition(this.normalizePosition(new Point(n, n2)));
    }

    private Point normalizePosition(Point point) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.tooltipPainter.getWidth();
        int n4 = this.tooltipPainter.getHeight();
        point.x += 15;
        if (point.x + n3 + 10 > n) {
            point.x -= 15 + n3 + 10;
        }
        if (point.x < 15) {
            point.x = 15;
        }
        point.y -= n4 + 10;
        if (point.y + n4 + 10 > n2) {
            point.y = n2 - n4 - 10;
        }
        if (point.y < 10) {
            point.y = 10;
        }
        return point;
    }

    public void paint(Graphics graphics) {
        if (this.tooltipPainter == null) {
            return;
        }
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 == null) {
            graphics.setClip(rectangle);
        } else {
            graphics.setClip(rectangle2.intersection(rectangle));
        }
        super.paint(graphics);
    }
}

