/*
 * Decompiled with CFR 0.152.
 */
package com.springrts.ai.oo.clb;

import com.springrts.ai.AICallback;
import com.springrts.ai.oo.AIFloat3;
import com.springrts.ai.oo.CallbackAIException;
import com.springrts.ai.oo.clb.AbstractUnit;
import com.springrts.ai.oo.clb.Command;
import com.springrts.ai.oo.clb.CommandDescription;
import com.springrts.ai.oo.clb.Feature;
import com.springrts.ai.oo.clb.Group;
import com.springrts.ai.oo.clb.Resource;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import com.springrts.ai.oo.clb.Weapon;
import com.springrts.ai.oo.clb.WeaponMount;
import com.springrts.ai.oo.clb.WrappCurrentCommand;
import com.springrts.ai.oo.clb.WrappUnitDef;
import com.springrts.ai.oo.clb.WrappUnitSupportedCommand;
import com.springrts.ai.oo.clb.WrappWeapon;
import java.util.ArrayList;
import java.util.List;

public class WrappUnit
extends AbstractUnit
implements Unit {
    private AICallback innerCallback = null;
    private int unitId = -1;

    public WrappUnit(AICallback aICallback, int n) {
        this.innerCallback = aICallback;
        this.unitId = n;
    }

    @Override
    public int getUnitId() {
        return this.unitId;
    }

    public static Unit getInstance(AICallback aICallback, int n) {
        if (n < 0) {
            return null;
        }
        WrappUnit wrappUnit = null;
        wrappUnit = new WrappUnit(aICallback, n);
        return wrappUnit;
    }

    @Override
    public int getLimit() {
        int n = this.innerCallback.Unit_getLimit();
        return n;
    }

    @Override
    public int getMax() {
        int n = this.innerCallback.Unit_getMax();
        return n;
    }

    @Override
    public UnitDef getDef() {
        int n = this.innerCallback.Unit_getDef(this.getUnitId());
        UnitDef unitDef = WrappUnitDef.getInstance(this.innerCallback, n);
        return unitDef;
    }

    @Override
    public float getRulesParamFloat(String string, float f) {
        float f2 = this.innerCallback.Unit_getRulesParamFloat(this.getUnitId(), string, f);
        return f2;
    }

    @Override
    public String getRulesParamString(String string, String string2) {
        String string3 = this.innerCallback.Unit_getRulesParamString(this.getUnitId(), string, string2);
        return string3;
    }

    @Override
    public int getTeam() {
        int n = this.innerCallback.Unit_getTeam(this.getUnitId());
        return n;
    }

    @Override
    public int getAllyTeam() {
        int n = this.innerCallback.Unit_getAllyTeam(this.getUnitId());
        return n;
    }

    @Override
    public int getAiHint() {
        int n = this.innerCallback.Unit_getAiHint(this.getUnitId());
        return n;
    }

    @Override
    public int getStockpile() {
        int n = this.innerCallback.Unit_getStockpile(this.getUnitId());
        return n;
    }

    @Override
    public int getStockpileQueued() {
        int n = this.innerCallback.Unit_getStockpileQueued(this.getUnitId());
        return n;
    }

    @Override
    public float getMaxSpeed() {
        float f = this.innerCallback.Unit_getMaxSpeed(this.getUnitId());
        return f;
    }

    @Override
    public float getMaxRange() {
        float f = this.innerCallback.Unit_getMaxRange(this.getUnitId());
        return f;
    }

    @Override
    public float getMaxHealth() {
        float f = this.innerCallback.Unit_getMaxHealth(this.getUnitId());
        return f;
    }

    @Override
    public float getExperience() {
        float f = this.innerCallback.Unit_getExperience(this.getUnitId());
        return f;
    }

    @Override
    public int getGroup() {
        int n = this.innerCallback.Unit_getGroup(this.getUnitId());
        return n;
    }

    @Override
    public List<Command> getCurrentCommands() {
        int n;
        int n2 = n = this.innerCallback.Unit_getCurrentCommands(this.getUnitId());
        ArrayList<Command> arrayList = new ArrayList<Command>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(WrappCurrentCommand.getInstance(this.innerCallback, this.unitId, i));
        }
        return arrayList;
    }

    @Override
    public List<CommandDescription> getSupportedCommands() {
        int n;
        int n2 = n = this.innerCallback.Unit_getSupportedCommands(this.getUnitId());
        ArrayList<CommandDescription> arrayList = new ArrayList<CommandDescription>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(WrappUnitSupportedCommand.getInstance(this.innerCallback, this.unitId, i));
        }
        return arrayList;
    }

    @Override
    public float getHealth() {
        float f = this.innerCallback.Unit_getHealth(this.getUnitId());
        return f;
    }

    @Override
    public float getSpeed() {
        float f = this.innerCallback.Unit_getSpeed(this.getUnitId());
        return f;
    }

    @Override
    public float getPower() {
        float f = this.innerCallback.Unit_getPower(this.getUnitId());
        return f;
    }

    @Override
    public float getResourceUse(Resource resource) {
        int n = resource.getResourceId();
        float f = this.innerCallback.Unit_getResourceUse(this.getUnitId(), n);
        return f;
    }

    @Override
    public float getResourceMake(Resource resource) {
        int n = resource.getResourceId();
        float f = this.innerCallback.Unit_getResourceMake(this.getUnitId(), n);
        return f;
    }

    @Override
    public AIFloat3 getPos() {
        float[] fArray = new float[3];
        this.innerCallback.Unit_getPos(this.getUnitId(), fArray);
        AIFloat3 aIFloat3 = new AIFloat3(fArray[0], fArray[1], fArray[2]);
        return aIFloat3;
    }

    @Override
    public AIFloat3 getVel() {
        float[] fArray = new float[3];
        this.innerCallback.Unit_getVel(this.getUnitId(), fArray);
        AIFloat3 aIFloat3 = new AIFloat3(fArray[0], fArray[1], fArray[2]);
        return aIFloat3;
    }

    @Override
    public boolean isActivated() {
        boolean bl = this.innerCallback.Unit_isActivated(this.getUnitId());
        return bl;
    }

    @Override
    public boolean isBeingBuilt() {
        boolean bl = this.innerCallback.Unit_isBeingBuilt(this.getUnitId());
        return bl;
    }

    @Override
    public boolean isCloaked() {
        boolean bl = this.innerCallback.Unit_isCloaked(this.getUnitId());
        return bl;
    }

    @Override
    public boolean isParalyzed() {
        boolean bl = this.innerCallback.Unit_isParalyzed(this.getUnitId());
        return bl;
    }

    @Override
    public boolean isNeutral() {
        boolean bl = this.innerCallback.Unit_isNeutral(this.getUnitId());
        return bl;
    }

    @Override
    public int getBuildingFacing() {
        int n = this.innerCallback.Unit_getBuildingFacing(this.getUnitId());
        return n;
    }

    @Override
    public int getLastUserOrderFrame() {
        int n = this.innerCallback.Unit_getLastUserOrderFrame(this.getUnitId());
        return n;
    }

    @Override
    public List<Weapon> getWeapons() {
        int n;
        int n2 = n = this.innerCallback.Unit_getWeapons(this.getUnitId());
        ArrayList<Weapon> arrayList = new ArrayList<Weapon>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(WrappWeapon.getInstance(this.innerCallback, this.unitId, i));
        }
        return arrayList;
    }

    @Override
    public Weapon getWeapon(WeaponMount weaponMount) {
        int n = weaponMount.getWeaponMountId();
        int n2 = this.innerCallback.Unit_getWeapon(this.getUnitId(), n);
        Weapon weapon = WrappWeapon.getInstance(this.innerCallback, this.unitId, n2);
        return weapon;
    }

    @Override
    public void build(UnitDef unitDef, AIFloat3 aIFloat3, int n, short s, int n2) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n3 = unitDef.getUnitDefId();
        int n4 = this.innerCallback.Unit_build(this.getUnitId(), n3, fArray, n, s, n2);
        if (n4 != 0) {
            throw new CallbackAIException("build", n4);
        }
    }

    @Override
    public void stop(short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_stop(this.getUnitId(), s, n);
        if (n2 != 0) {
            throw new CallbackAIException("stop", n2);
        }
    }

    @Override
    public void wait(short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_wait(this.getUnitId(), s, n);
        if (n2 != 0) {
            throw new CallbackAIException("wait", n2);
        }
    }

    @Override
    public void waitFor(int n, short s, int n2) throws CallbackAIException {
        int n3 = this.innerCallback.Unit_waitFor(this.getUnitId(), n, s, n2);
        if (n3 != 0) {
            throw new CallbackAIException("waitFor", n3);
        }
    }

    @Override
    public void waitForDeathOf(Unit unit, short s, int n) throws CallbackAIException {
        int n2 = unit.getUnitId();
        int n3 = this.innerCallback.Unit_waitForDeathOf(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("waitForDeathOf", n3);
        }
    }

    @Override
    public void waitForSquadSize(int n, short s, int n2) throws CallbackAIException {
        int n3 = this.innerCallback.Unit_waitForSquadSize(this.getUnitId(), n, s, n2);
        if (n3 != 0) {
            throw new CallbackAIException("waitForSquadSize", n3);
        }
    }

    @Override
    public void waitForAll(short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_waitForAll(this.getUnitId(), s, n);
        if (n2 != 0) {
            throw new CallbackAIException("waitForAll", n2);
        }
    }

    @Override
    public void moveTo(AIFloat3 aIFloat3, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_moveTo(this.getUnitId(), fArray, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("moveTo", n2);
        }
    }

    @Override
    public void patrolTo(AIFloat3 aIFloat3, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_patrolTo(this.getUnitId(), fArray, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("patrolTo", n2);
        }
    }

    @Override
    public void fight(AIFloat3 aIFloat3, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_fight(this.getUnitId(), fArray, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("fight", n2);
        }
    }

    @Override
    public void attack(Unit unit, short s, int n) throws CallbackAIException {
        int n2 = unit.getUnitId();
        int n3 = this.innerCallback.Unit_attack(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("attack", n3);
        }
    }

    @Override
    public void attackArea(AIFloat3 aIFloat3, float f, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_attackArea(this.getUnitId(), fArray, f, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("attackArea", n2);
        }
    }

    @Override
    public void guard(Unit unit, short s, int n) throws CallbackAIException {
        int n2 = unit.getUnitId();
        int n3 = this.innerCallback.Unit_guard(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("guard", n3);
        }
    }

    @Override
    public void aiSelect(short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_aiSelect(this.getUnitId(), s, n);
        if (n2 != 0) {
            throw new CallbackAIException("aiSelect", n2);
        }
    }

    @Override
    public void addToGroup(Group group, short s, int n) throws CallbackAIException {
        int n2 = group.getGroupId();
        int n3 = this.innerCallback.Unit_addToGroup(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("addToGroup", n3);
        }
    }

    @Override
    public void removeFromGroup(short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_removeFromGroup(this.getUnitId(), s, n);
        if (n2 != 0) {
            throw new CallbackAIException("removeFromGroup", n2);
        }
    }

    @Override
    public void repair(Unit unit, short s, int n) throws CallbackAIException {
        int n2 = unit.getUnitId();
        int n3 = this.innerCallback.Unit_repair(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("repair", n3);
        }
    }

    @Override
    public void setFireState(int n, short s, int n2) throws CallbackAIException {
        int n3 = this.innerCallback.Unit_setFireState(this.getUnitId(), n, s, n2);
        if (n3 != 0) {
            throw new CallbackAIException("setFireState", n3);
        }
    }

    @Override
    public void setMoveState(int n, short s, int n2) throws CallbackAIException {
        int n3 = this.innerCallback.Unit_setMoveState(this.getUnitId(), n, s, n2);
        if (n3 != 0) {
            throw new CallbackAIException("setMoveState", n3);
        }
    }

    @Override
    public void setBase(AIFloat3 aIFloat3, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_setBase(this.getUnitId(), fArray, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("setBase", n2);
        }
    }

    @Override
    public void selfDestruct(short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_selfDestruct(this.getUnitId(), s, n);
        if (n2 != 0) {
            throw new CallbackAIException("selfDestruct", n2);
        }
    }

    @Override
    public void setWantedMaxSpeed(float f, short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_setWantedMaxSpeed(this.getUnitId(), f, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("setWantedMaxSpeed", n2);
        }
    }

    @Override
    public void loadUnits(List<Unit> list, short s, int n) throws CallbackAIException {
        int n2;
        int n3 = n2 = list.size();
        int n4 = n2;
        int[] nArray = new int[n4];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = list.get(i).getUnitId();
        }
        int n5 = this.innerCallback.Unit_loadUnits(this.getUnitId(), nArray, n2, s, n);
        if (n5 != 0) {
            throw new CallbackAIException("loadUnits", n5);
        }
    }

    @Override
    public void loadUnitsInArea(AIFloat3 aIFloat3, float f, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_loadUnitsInArea(this.getUnitId(), fArray, f, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("loadUnitsInArea", n2);
        }
    }

    @Override
    public void loadOnto(Unit unit, short s, int n) throws CallbackAIException {
        int n2 = unit.getUnitId();
        int n3 = this.innerCallback.Unit_loadOnto(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("loadOnto", n3);
        }
    }

    @Override
    public void unload(AIFloat3 aIFloat3, Unit unit, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = unit.getUnitId();
        int n3 = this.innerCallback.Unit_unload(this.getUnitId(), fArray, n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("unload", n3);
        }
    }

    @Override
    public void unloadUnitsInArea(AIFloat3 aIFloat3, float f, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_unloadUnitsInArea(this.getUnitId(), fArray, f, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("unloadUnitsInArea", n2);
        }
    }

    @Override
    public void setOn(boolean bl, short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_setOn(this.getUnitId(), bl, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("setOn", n2);
        }
    }

    @Override
    public void reclaimUnit(Unit unit, short s, int n) throws CallbackAIException {
        int n2 = unit.getUnitId();
        int n3 = this.innerCallback.Unit_reclaimUnit(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("reclaimUnit", n3);
        }
    }

    @Override
    public void reclaimFeature(Feature feature, short s, int n) throws CallbackAIException {
        int n2 = feature.getFeatureId();
        int n3 = this.innerCallback.Unit_reclaimFeature(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("reclaimFeature", n3);
        }
    }

    @Override
    public void reclaimInArea(AIFloat3 aIFloat3, float f, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_reclaimInArea(this.getUnitId(), fArray, f, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("reclaimInArea", n2);
        }
    }

    @Override
    public void cloak(boolean bl, short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_cloak(this.getUnitId(), bl, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("cloak", n2);
        }
    }

    @Override
    public void stockpile(short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_stockpile(this.getUnitId(), s, n);
        if (n2 != 0) {
            throw new CallbackAIException("stockpile", n2);
        }
    }

    @Override
    public void dGun(Unit unit, short s, int n) throws CallbackAIException {
        int n2 = unit.getUnitId();
        int n3 = this.innerCallback.Unit_dGun(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("dGun", n3);
        }
    }

    @Override
    public void dGunPosition(AIFloat3 aIFloat3, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_dGunPosition(this.getUnitId(), fArray, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("dGunPosition", n2);
        }
    }

    @Override
    public void restoreArea(AIFloat3 aIFloat3, float f, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_restoreArea(this.getUnitId(), fArray, f, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("restoreArea", n2);
        }
    }

    @Override
    public void setRepeat(boolean bl, short s, int n) throws CallbackAIException {
        int n2 = this.innerCallback.Unit_setRepeat(this.getUnitId(), bl, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("setRepeat", n2);
        }
    }

    @Override
    public void setTrajectory(int n, short s, int n2) throws CallbackAIException {
        int n3 = this.innerCallback.Unit_setTrajectory(this.getUnitId(), n, s, n2);
        if (n3 != 0) {
            throw new CallbackAIException("setTrajectory", n3);
        }
    }

    @Override
    public void resurrect(Feature feature, short s, int n) throws CallbackAIException {
        int n2 = feature.getFeatureId();
        int n3 = this.innerCallback.Unit_resurrect(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("resurrect", n3);
        }
    }

    @Override
    public void resurrectInArea(AIFloat3 aIFloat3, float f, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_resurrectInArea(this.getUnitId(), fArray, f, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("resurrectInArea", n2);
        }
    }

    @Override
    public void capture(Unit unit, short s, int n) throws CallbackAIException {
        int n2 = unit.getUnitId();
        int n3 = this.innerCallback.Unit_capture(this.getUnitId(), n2, s, n);
        if (n3 != 0) {
            throw new CallbackAIException("capture", n3);
        }
    }

    @Override
    public void captureInArea(AIFloat3 aIFloat3, float f, short s, int n) throws CallbackAIException {
        float[] fArray = aIFloat3.toFloatArray();
        int n2 = this.innerCallback.Unit_captureInArea(this.getUnitId(), fArray, f, s, n);
        if (n2 != 0) {
            throw new CallbackAIException("captureInArea", n2);
        }
    }

    @Override
    public void setAutoRepairLevel(int n, short s, int n2) throws CallbackAIException {
        int n3 = this.innerCallback.Unit_setAutoRepairLevel(this.getUnitId(), n, s, n2);
        if (n3 != 0) {
            throw new CallbackAIException("setAutoRepairLevel", n3);
        }
    }

    @Override
    public void setIdleMode(int n, short s, int n2) throws CallbackAIException {
        int n3 = this.innerCallback.Unit_setIdleMode(this.getUnitId(), n, s, n2);
        if (n3 != 0) {
            throw new CallbackAIException("setIdleMode", n3);
        }
    }

    @Override
    public void executeCustomCommand(int n, List<Float> list, short s, int n2) throws CallbackAIException {
        int n3;
        int n4 = n3 = list.size();
        int n5 = n3;
        float[] fArray = new float[n5];
        for (int i = 0; i < n4; ++i) {
            fArray[i] = list.get(i).floatValue();
        }
        int n6 = this.innerCallback.Unit_executeCustomCommand(this.getUnitId(), n, fArray, n3, s, n2);
        if (n6 != 0) {
            throw new CallbackAIException("executeCustomCommand", n6);
        }
    }
}

