/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.cache.shaded.org.jline.terminal.impl;

import java.io.IOError;
import java.io.IOException;
import java.util.function.IntConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lmcoursier.internal.shaded.coursier.cache.shaded.org.jline.terminal.Cursor;
import lmcoursier.internal.shaded.coursier.cache.shaded.org.jline.terminal.Terminal;
import lmcoursier.internal.shaded.coursier.cache.shaded.org.jline.utils.Curses;
import lmcoursier.internal.shaded.coursier.cache.shaded.org.jline.utils.InfoCmp;

public class CursorSupport {
    public static Cursor getCursorPosition(Terminal terminal, IntConsumer discarded) {
        try {
            String u6 = terminal.getStringCapability(InfoCmp.Capability.user6);
            String u7 = terminal.getStringCapability(InfoCmp.Capability.user7);
            if (u6 == null || u7 == null) {
                return null;
            }
            boolean inc1 = false;
            StringBuilder patb = new StringBuilder();
            int index = 0;
            block17: while (index < u6.length()) {
                char ch = u6.charAt(index++);
                switch (ch) {
                    case '\\': {
                        switch (u6.charAt(index++)) {
                            case 'E': 
                            case 'e': {
                                patb.append("\\x1b");
                                continue block17;
                            }
                        }
                        throw new IllegalArgumentException();
                    }
                    case '%': {
                        ch = u6.charAt(index++);
                        switch (ch) {
                            case '%': {
                                patb.append('%');
                                continue block17;
                            }
                            case 'i': {
                                inc1 = true;
                                continue block17;
                            }
                            case 'd': {
                                patb.append("([0-9]+)");
                                continue block17;
                            }
                        }
                        throw new IllegalArgumentException();
                    }
                }
                switch (ch) {
                    case '[': {
                        patb.append('\\');
                    }
                }
                patb.append(ch);
            }
            Pattern pattern = Pattern.compile(patb.toString());
            Curses.tputs(terminal.writer(), u7, new Object[0]);
            terminal.flush();
            StringBuilder sb = new StringBuilder();
            int start = 0;
            while (true) {
                int c;
                if ((c = terminal.reader().read()) < 0) {
                    return null;
                }
                sb.append((char)c);
                Matcher matcher = pattern.matcher(sb.substring(start));
                if (matcher.matches()) {
                    int y = Integer.parseInt(matcher.group(1));
                    int x = Integer.parseInt(matcher.group(2));
                    if (inc1) {
                        --x;
                        --y;
                    }
                    if (discarded != null) {
                        for (int i = 0; i < start; ++i) {
                            discarded.accept(sb.charAt(i));
                        }
                    }
                    return new Cursor(x, y);
                }
                if (matcher.hitEnd()) continue;
                ++start;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

