/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.cache;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import lmcoursier.internal.shaded.coursier.cache.CachePolicy;
import lmcoursier.internal.shaded.coursier.cache.CachePolicy$LocalOnly$;
import lmcoursier.internal.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import lmcoursier.internal.shaded.coursier.cache.CachePolicy$Update$;
import lmcoursier.internal.shaded.coursier.credentials.Credentials;
import lmcoursier.internal.shaded.coursier.credentials.FileCredentials;
import lmcoursier.internal.shaded.coursier.credentials.FileCredentials$;
import lmcoursier.internal.shaded.coursier.parse.CachePolicyParser$;
import lmcoursier.internal.shaded.coursier.parse.CredentialsParser$;
import lmcoursier.internal.shaded.coursier.paths.CachePath;
import lmcoursier.internal.shaded.coursier.paths.CoursierPaths;
import lmcoursier.internal.shaded.coursier.util.Sync$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CacheDefaults$ {
    public static CacheDefaults$ MODULE$;
    private File location;
    private int concurrentDownloadCount;
    private ExecutorService pool;
    private Option<Duration> ttl;
    private int sslRetryCount;
    private Option<Object> maxRedirections;
    private final Seq<Option<String>> checksums;
    private final int bufferSize;
    private final Seq<CachePolicy> noEnvCachePolicies;
    private volatile byte bitmap$0;

    static {
        new CacheDefaults$();
    }

    private File location$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.location = CachePath.defaultCacheDirectory();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.location;
    }

    public File location() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.location$lzycompute() : this.location;
    }

    private int defaultConcurrentDownloadCount() {
        return 6;
    }

    private int concurrentDownloadCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.concurrentDownloadCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.parallel-download-count").flatMap((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toInt()).toOption()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.defaultConcurrentDownloadCount()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.concurrentDownloadCount;
    }

    public int concurrentDownloadCount() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.concurrentDownloadCount$lzycompute() : this.concurrentDownloadCount;
    }

    private ExecutorService pool$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.pool = Sync$.MODULE$.fixedThreadPool(this.concurrentDownloadCount());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.pool;
    }

    public ExecutorService pool() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.pool$lzycompute() : this.pool;
    }

    public Either<Throwable, Duration> parseDuration(String s) {
        Right right;
        if (new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(s)).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CacheDefaults$.$anonfun$parseDuration$1(BoxesRunTime.unboxToChar((Object)x$1))))) {
            right = package$.MODULE$.Right().apply((Object)Duration$.MODULE$.Zero());
        } else {
            Right right2;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Duration$.MODULE$.apply(s));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Duration s2 = (Duration)success.value();
                right2 = package$.MODULE$.Right().apply((Object)s2);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                right2 = package$.MODULE$.Left().apply((Object)t);
            } else {
                throw new MatchError((Object)try_);
            }
            right = right2;
        }
        return right;
    }

    private Option<Duration> ttl$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Option fromEnv = scala.sys.package$.MODULE$.env().get((Object)"COURSIER_TTL").flatMap((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.parseDuration((String)x$2).right().toOption());
                this.ttl = fromEnv.orElse((Function0 & Serializable & scala.Serializable)() -> CacheDefaults$.fromProps$1()).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)CacheDefaults$.default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.ttl;
    }

    public Option<Duration> ttl() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.ttl$lzycompute() : this.ttl;
    }

    public Seq<Option<String>> checksums() {
        return this.checksums;
    }

    private int defaultSslRetryCount() {
        return 3;
    }

    private int sslRetryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.sslRetryCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.sslexception-retry").flatMap((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toInt()).toOption()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.defaultSslRetryCount()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.sslRetryCount;
    }

    public int sslRetryCount() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.sslRetryCount$lzycompute() : this.sslRetryCount;
    }

    private Option<Object> defaultMaxRedirections() {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20));
    }

    private Option<Object> maxRedirections$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.maxRedirections = CacheDefaults$.prop$1("lmcoursier.internal.shaded.coursier.http.maxRedirects").orElse((Function0 & Serializable & scala.Serializable)() -> CacheDefaults$.prop$1("http.maxRedirects")).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultMaxRedirections());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.maxRedirections;
    }

    public Option<Object> maxRedirections() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.maxRedirections$lzycompute() : this.maxRedirections;
    }

    public int defaultRetryCount() {
        return 1;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    private Option<String> credentialPropOpt() {
        return scala.sys.package$.MODULE$.env().get((Object)"COURSIER_CREDENTIALS").orElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.credentials")).map((Function1 & Serializable & scala.Serializable)s -> (String)new StringOps(Predef$.MODULE$.augmentString(s)).dropWhile((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isSpaceChar$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$6))))));
    }

    private boolean isPropFile(String s) {
        return s.startsWith("/") || s.startsWith("file:");
    }

    public Seq<Credentials> credentials() {
        Seq seq;
        if (this.credentialPropOpt().isEmpty()) {
            File configDir = CoursierPaths.configDirectory();
            File mainCredentialsFile = new File(configDir, "credentials.properties");
            File dir = new File(configDir, "credentials");
            File[] files = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return !name.startsWith(".") && name.endsWith(".properties");
                }
            });
            Seq otherFiles = (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)files)).toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).map((Function1 & Serializable & scala.Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true), Seq$.MODULE$.canBuildFrom());
            FileCredentials fileCredentials = FileCredentials$.MODULE$.apply(mainCredentialsFile.getAbsolutePath(), true);
            seq = (Seq)otherFiles.$plus$colon((Object)fileCredentials, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Option$.MODULE$.option2Iterable(this.credentialPropOpt().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)CacheDefaults$.MODULE$.isPropFile(s)))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Seq seq;
                String string = x0$1;
                if (MODULE$.isPropFile(string)) {
                    String path0 = string.startsWith("file:") ? new File(new URI(string)).getAbsolutePath() : string;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileCredentials[]{FileCredentials$.MODULE$.apply(path0, true)}));
                } else {
                    seq = (Seq)CredentialsParser$.MODULE$.parseSeq(string).either().right().toSeq().flatten((Function1)Predef$.MODULE$.$conforms());
                }
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public Seq<CachePolicy> noEnvCachePolicies() {
        return this.noEnvCachePolicies;
    }

    public Seq<CachePolicy> cachePolicies() {
        Option fromEnv = CacheDefaults$.fromOption$1(scala.sys.package$.MODULE$.env().get((Object)"COURSIER_MODE"), "COURSIER_MODE environment variable");
        return (Seq)fromEnv.orElse((Function0 & Serializable & scala.Serializable)() -> CacheDefaults$.fromProps$2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.noEnvCachePolicies());
    }

    public static final /* synthetic */ boolean $anonfun$parseDuration$1(char x$1) {
        return x$1 == '0';
    }

    private static final Option fromProps$1() {
        return scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.ttl").flatMap((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.parseDuration((String)x$3).right().toOption());
    }

    private static final FiniteDuration default$1() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(24)).hours();
    }

    private static final Option prop$1(String name) {
        return scala.sys.package$.MODULE$.props().get(name).flatMap((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toInt()).toOption()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 >= 0);
    }

    public static final /* synthetic */ boolean $anonfun$cachePolicies$1(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    private static final Option fromOption$1(Option value, String description) {
        return value.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CacheDefaults$.$anonfun$cachePolicies$1(x$8))).flatMap((Function1 & Serializable & scala.Serializable)str -> {
            boolean bl = false;
            Right right = null;
            Either<.colon.colon<String>, Seq<CachePolicy>> either2 = CachePolicyParser$.MODULE$.cachePolicies((String)str, MODULE$.noEnvCachePolicies()).either();
            if (either2 instanceof Right) {
                bl = true;
                right = (Right)either2;
                Seq seq = (Seq)right.value();
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                    Console$.MODULE$.err().println(new StringBuilder(40).append("Warning: no mode found in ").append(description).append(", ignoring it.").toString());
                    return None$.MODULE$;
                }
            }
            if (bl) {
                Seq policies = (Seq)right.value();
                return new Some((Object)policies);
            }
            if (!(either2 instanceof Left)) throw new MatchError(either2);
            Console$.MODULE$.err().println(new StringBuilder(44).append("Warning: unrecognized mode in ").append(description).append(", ignoring it.").toString());
            return None$.MODULE$;
        });
    }

    private static final Option fromProps$2() {
        return CacheDefaults$.fromOption$1(scala.sys.package$.MODULE$.props().get("lmcoursier.internal.shaded.coursier.mode"), "Java property coursier.mode");
    }

    private CacheDefaults$() {
        MODULE$ = this;
        this.checksums = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)"SHA-1"), None$.MODULE$}));
        this.bufferSize = 0x100000;
        this.noEnvCachePolicies = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CachePolicy[]{CachePolicy$LocalUpdateChanging$.MODULE$, CachePolicy$LocalOnly$.MODULE$, CachePolicy$Update$.MODULE$}));
    }
}

