/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.namespace;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.namespace.MRIDRule;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.util.Message;

public class MRIDTransformationRule
implements NamespaceTransformer {
    private List src = new ArrayList();
    private MRIDRule dest;

    public void addSrc(MRIDRule mRIDRule) {
        this.src.add(mRIDRule);
    }

    public void addDest(MRIDRule mRIDRule) {
        if (this.dest != null) {
            throw new IllegalArgumentException("only one dest is allowed per mapping");
        }
        this.dest = mRIDRule;
    }

    @Override
    public ModuleRevisionId transform(ModuleRevisionId moduleRevisionId) {
        MridRuleMatcher mridRuleMatcher = new MridRuleMatcher();
        for (MRIDRule mRIDRule : this.src) {
            if (!mridRuleMatcher.match(mRIDRule, moduleRevisionId)) continue;
            ModuleRevisionId moduleRevisionId2 = mridRuleMatcher.apply(this.dest, moduleRevisionId);
            Message.debug("found matching namespace rule: " + mRIDRule + ". Applied " + this.dest + " on " + moduleRevisionId + ". Transformed to " + moduleRevisionId2);
            return moduleRevisionId2;
        }
        return moduleRevisionId;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    private static class MridRuleMatcher {
        private static final String[] TYPES = new String[]{"o", "m", "b", "r"};
        private Matcher[] matchers = new Matcher[TYPES.length];

        private MridRuleMatcher() {
        }

        public boolean match(MRIDRule mRIDRule, ModuleRevisionId moduleRevisionId) {
            this.matchers[0] = Pattern.compile(this.getPattern(mRIDRule.getOrg())).matcher(moduleRevisionId.getOrganisation());
            if (!this.matchers[0].matches()) {
                return false;
            }
            this.matchers[1] = Pattern.compile(this.getPattern(mRIDRule.getModule())).matcher(moduleRevisionId.getName());
            if (!this.matchers[1].matches()) {
                return false;
            }
            if (moduleRevisionId.getBranch() == null) {
                this.matchers[2] = null;
            } else {
                this.matchers[2] = Pattern.compile(this.getPattern(mRIDRule.getBranch())).matcher(moduleRevisionId.getBranch());
                if (!this.matchers[2].matches()) {
                    return false;
                }
            }
            this.matchers[3] = Pattern.compile(this.getPattern(mRIDRule.getRev())).matcher(moduleRevisionId.getRevision());
            return this.matchers[3].matches();
        }

        public ModuleRevisionId apply(MRIDRule mRIDRule, ModuleRevisionId moduleRevisionId) {
            String string = this.applyRules(mRIDRule.getOrg(), "o");
            String string2 = this.applyRules(mRIDRule.getModule(), "m");
            String string3 = this.applyRules(mRIDRule.getBranch(), "b");
            String string4 = this.applyRules(mRIDRule.getRev(), "r");
            return ModuleRevisionId.newInstance(string, string2, string3, string4, moduleRevisionId.getQualifiedExtraAttributes());
        }

        private String applyRules(String string, String string2) {
            for (int i = 0; i < TYPES.length; ++i) {
                string = this.applyTypeRule(string, TYPES[i], string2, this.matchers[i]);
            }
            return string;
        }

        private String applyTypeRule(String string, String string2, String string3, Matcher matcher) {
            if (matcher == null) {
                return string;
            }
            String string4 = string == null ? "$" + string3 + "0" : string;
            for (int i = 0; i < TYPES.length; ++i) {
                if (TYPES[i].equals(string2)) {
                    string4 = string4.replaceAll("([^\\\\])\\$" + string2, "$1\\$");
                    string4 = string4.replaceAll("^\\$" + string2, "\\$");
                    continue;
                }
                string4 = string4.replaceAll("([^\\\\])\\$" + TYPES[i], "$1\\\\\\$" + TYPES[i]);
                string4 = string4.replaceAll("^\\$" + TYPES[i], "\\\\\\$" + TYPES[i]);
            }
            StringBuffer stringBuffer = new StringBuffer();
            matcher.reset();
            matcher.find();
            matcher.appendReplacement(stringBuffer, string4);
            String string5 = stringBuffer.toString();
            if (string == null && ("$" + string3 + "0").equals(string5)) {
                return null;
            }
            return string5;
        }

        private String getPattern(String string) {
            return string == null ? ".*" : string;
        }
    }
}

