/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DialogAwareDataContext;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionHandlerBean;
import com.intellij.openapi.editor.actionSystem.LatencyAwareEditorAction;
import com.intellij.openapi.editor.actionSystem.LatencyRecorder;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(EditorAction.class);
    private EditorActionHandler myHandler;
    private boolean myHandlersLoaded;

    public final EditorActionHandler getHandler() {
        this.ensureHandlersLoaded();
        return this.myHandler;
    }

    protected EditorAction(EditorActionHandler defaultHandler) {
        this.myHandler = defaultHandler;
        this.setEnabledInModalContext(true);
    }

    public final EditorActionHandler setupHandler(@NotNull EditorActionHandler newHandler) {
        if (newHandler == null) {
            EditorAction.$$$reportNull$$$0(0);
        }
        this.ensureHandlersLoaded();
        EditorActionHandler tmp = this.myHandler;
        this.myHandler = newHandler;
        this.myHandler.setWorksInInjected(this.isInInjectedContext());
        return tmp;
    }

    private void ensureHandlersLoaded() {
        if (!this.myHandlersLoaded) {
            this.myHandlersLoaded = true;
            String id = ActionManager.getInstance().getId(this);
            List extensions = EditorActionHandlerBean.EP_NAME.getExtensionList();
            for (int i = extensions.size() - 1; i >= 0; --i) {
                EditorActionHandlerBean handlerBean = (EditorActionHandlerBean)((Object)extensions.get(i));
                if (!handlerBean.action.equals(id)) continue;
                this.myHandler = handlerBean.getHandler(this.myHandler);
                this.myHandler.setWorksInInjected(this.isInInjectedContext());
            }
        }
    }

    @Override
    public void setInjectedContext(boolean worksInInjected) {
        super.setInjectedContext(worksInInjected);
        this.myHandler.setWorksInInjected(this.isInInjectedContext());
    }

    @Override
    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditorAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext);
        if (this instanceof LatencyAwareEditorAction && editor != null) {
            String actionId = ActionManager.getInstance().getId(this);
            InputEvent inputEvent = e.getInputEvent();
            if (actionId != null && inputEvent != null) {
                LatencyRecorder.getInstance().recordLatencyAwareAction(editor, actionId, inputEvent.getWhen());
            }
        }
        this.actionPerformed(editor, dataContext);
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            EditorAction.$$$reportNull$$$0(2);
        }
        return CommonDataKeys.EDITOR.getData(dataContext);
    }

    public final void actionPerformed(Editor editor, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            EditorAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            return;
        }
        if (editor.isDisposed()) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
            LOG.error("Action " + this + " invoked on a disposed editor" + (file == null ? "" : " for file " + file));
            return;
        }
        EditorActionHandler handler = this.getHandler();
        Runnable command = () -> handler.execute(editor, null, EditorAction.getProjectAwareDataContext(editor, dataContext));
        if (!handler.executeInCommand(editor, dataContext)) {
            command.run();
            return;
        }
        String commandName = this.getTemplatePresentation().getText();
        if (commandName == null) {
            commandName = "";
        }
        CommandProcessor.getInstance().executeCommand(editor.getProject(), command, commandName, (Object)handler.getCommandGroupId(editor), UndoConfirmationPolicy.DEFAULT, editor.getDocument());
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        presentation.setEnabled(this.getHandler().isEnabled(editor, null, dataContext));
    }

    public void updateForKeyboardAccess(Editor editor, Presentation presentation, DataContext dataContext) {
        this.update(editor, presentation, dataContext);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            EditorAction.$$$reportNull$$$0(4);
        }
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext);
        if (editor == null) {
            presentation.setEnabled(false);
        } else if (editor.isDisposed()) {
            LOG.error("Disposed editor in " + dataContext + " for " + this);
            presentation.setEnabled(false);
        } else if (e.getInputEvent() instanceof KeyEvent) {
            this.updateForKeyboardAccess(editor, presentation, dataContext);
        } else {
            this.update(editor, presentation, dataContext);
        }
    }

    private static DataContext getProjectAwareDataContext(Editor editor, @NotNull DataContext original) {
        if (original == null) {
            EditorAction.$$$reportNull$$$0(5);
        }
        if (CommonDataKeys.PROJECT.getData(original) == editor.getProject()) {
            return new DialogAwareDataContext(original);
        }
        return dataId -> {
            Project project;
            if (CommonDataKeys.PROJECT.is(dataId) && (project = editor.getProject()) != null) {
                return project;
            }
            return original.getData(dataId);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHandler";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actionSystem/EditorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectAwareDataContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

