/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.splitbysize;

import java.util.Map;
import java.util.Optional;
import javafx.scene.control.RadioButton;
import org.pdfsam.splitbysize.SizeUnit;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.workspace.RestorableView;

class SizeUnitRadio
extends RadioButton
implements RestorableView {
    private SizeUnit unit;

    public SizeUnitRadio(SizeUnit unit) {
        RequireUtils.requireNotNull((Object)((Object)unit), (String)"Unit cannot be null");
        this.unit = unit;
        this.setText(unit.friendlyName());
        this.setId("unit" + unit.symbol());
    }

    public void saveStateTo(Map<String, String> data) {
        if (this.isSelected()) {
            data.put(this.unit.toString(), Boolean.TRUE.toString());
        }
    }

    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get(this.unit.toString())).map(Boolean::valueOf).ifPresent(arg_0 -> ((SizeUnitRadio)this).setSelected(arg_0));
    }

    public SizeUnit unit() {
        return this.unit;
    }
}

