/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.cos.DirectCOSObject;
import org.sejda.sambox.cos.IndirectCOSObjectIdentifier;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.input.COSParser;
import org.sejda.sambox.output.IncrementablePDDocumentWriter;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.util.SpecVersionUtils;
import org.sejda.sambox.xref.FileTrailer;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementablePDDocument
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementablePDDocument.class);
    private Map<IndirectCOSObjectIdentifier, COSBase> replacements = new HashMap<IndirectCOSObjectIdentifier, COSBase>();
    private Set<COSBase> newIndirects = new HashSet<COSBase>();
    private PDDocument incremented;
    public final COSParser parser;

    IncrementablePDDocument(PDDocument incremented, COSParser parser) {
        RequireUtils.requireNotNullArg((Object)incremented, (String)"Incremented document cannot be null");
        RequireUtils.requireNotNullArg((Object)parser, (String)"COSParser cannot be null");
        this.incremented = incremented;
        this.parser = parser;
    }

    public PDDocument incremented() {
        return this.incremented;
    }

    public FileTrailer trailer() {
        return this.incremented.getDocument().getTrailer();
    }

    public InputStream incrementedAsStream() throws IOException {
        this.parser.source().position(0L);
        return this.parser.source().asInputStream();
    }

    public COSObjectKey highestExistingReference() {
        return this.parser.provider().highestKey();
    }

    public void replace(IndirectCOSObjectIdentifier toReplace, COSObjectable replacement) {
        RequireUtils.requireNotNullArg((Object)toReplace, (String)"Missing id of the object to be replaced");
        this.replacements.put(toReplace, Optional.ofNullable(replacement).map(COSObjectable::getCOSObject).orElse(COSNull.NULL));
    }

    public boolean modified(COSObjectable modified) {
        RequireUtils.requireNotNullArg((Object)modified, (String)"Missing modified object");
        if (modified.getCOSObject().hasId()) {
            this.replacements.put(modified.getCOSObject().id(), modified.getCOSObject());
            return true;
        }
        return false;
    }

    public void newIndirect(COSObjectable newObject) {
        RequireUtils.requireNotNullArg((Object)newObject, (String)"Missing new object object");
        this.newIndirects.add(newObject.getCOSObject());
    }

    public List<IndirectCOSObjectReference> replacements() {
        return this.replacements.entrySet().stream().map(e -> new IndirectCOSObjectReference(((IndirectCOSObjectIdentifier)e.getKey()).objectIdentifier.objectNumber(), ((IndirectCOSObjectIdentifier)e.getKey()).objectIdentifier.generation(), ((COSBase)e.getValue()).getCOSObject())).collect(Collectors.toList());
    }

    public Set<COSBase> newIndirects() {
        return Collections.unmodifiableSet(this.newIndirects);
    }

    public COSDictionary encryptionDictionary() {
        return this.incremented.getDocument().getEncryptionDictionary();
    }

    public byte[] encryptionKey() {
        return Optional.ofNullable(this.incremented.getSecurityHandler()).map(s -> s.getEncryptionKey()).orElse(null);
    }

    @Override
    public void close() throws IOException {
        this.incremented.close();
        IOUtils.close((Closeable)this.parser.provider());
        IOUtils.close((Closeable)this.parser);
    }

    public void writeTo(File file, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((File)file), options);
    }

    public void writeTo(String filename, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((String)filename), options);
    }

    public void writeTo(WritableByteChannel channel, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((WritableByteChannel)channel), options);
    }

    public void writeTo(OutputStream out, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((OutputStream)out), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTo(CountingWritableByteChannel output, WriteOption ... options) throws IOException {
        RequireUtils.requireState((boolean)this.incremented.isOpen(), (String)"The document is closed");
        RequireUtils.requireState((!this.replacements.isEmpty() ? 1 : 0) != 0, (String)"No update to be incrementally written");
        this.updateId(output.toString().getBytes(StandardCharsets.ISO_8859_1));
        try (IncrementablePDDocumentWriter writer = new IncrementablePDDocumentWriter(output, options);){
            writer.write(this);
        }
        finally {
            IOUtils.close((Closeable)this);
        }
    }

    private void updateId(byte[] bytes) {
        DirectCOSObject id = DirectCOSObject.asDirectObject(this.incremented.generateFileIdentifier(bytes));
        COSArray existingId = this.incremented.getDocument().getTrailer().getCOSObject().getDictionaryObject(COSName.ID, COSArray.class);
        if (Objects.nonNull(existingId) && existingId.size() == 2) {
            ((COSString)existingId.get(0).getCOSObject()).encryptable(false);
            existingId.set(1, id);
        } else {
            this.incremented.getDocument().getTrailer().getCOSObject().setItem(COSName.ID, (COSBase)DirectCOSObject.asDirectObject(new COSArray(id, id)));
        }
    }

    public void requireMinVersion(String version) {
        if (!SpecVersionUtils.isAtLeast(this.incremented.getVersion(), version)) {
            LOG.debug("Minimum spec version required is {}", (Object)version);
            this.setVersion(version);
        }
    }

    public void setVersion(String newVersion) {
        RequireUtils.requireState((boolean)this.incremented.isOpen(), (String)"The document is closed");
        RequireUtils.requireNotBlank((String)newVersion, (String)"Spec version cannot be blank");
        int compare = this.incremented.getVersion().compareTo(newVersion);
        if (compare > 0) {
            LOG.info("Spec version downgrade not allowed");
        } else if (compare < 0) {
            if (SpecVersionUtils.isAtLeast(newVersion, "1.4")) {
                COSDictionary catalog = this.incremented.getDocument().getCatalog();
                catalog.setName(COSName.VERSION, newVersion);
                this.modified(catalog);
            } else {
                LOG.warn("Sepc version must be at least 1.4 to be set as catalog entry in an incremental update");
            }
        }
    }
}

