/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.language.Demo;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.WordRepeatRule;

public class WordRepeatRuleTest {
    private final Demo demoLanguage = new Demo();
    private final JLanguageTool lt = new JLanguageTool((Language)this.demoLanguage);
    private final WordRepeatRule rule = new WordRepeatRule(TestTools.getEnglishMessages(), (Language)this.demoLanguage);

    @Test
    public void test() throws IOException {
        this.assertGood("A test");
        this.assertGood("A test.");
        this.assertGood("A test...");
        this.assertGood("1 000 000 years");
        this.assertGood("010 020 030");
        this.assertBad("A A test");
        this.assertBad("A a test");
        this.assertBad("This is is a test");
    }

    private void assertGood(String s) throws IOException {
        RuleMatch[] matches = this.rule.match(this.lt.getAnalyzedSentence(s));
        Assert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)0));
    }

    private void assertBad(String s) throws IOException {
        RuleMatch[] matches = this.rule.match(this.lt.getAnalyzedSentence(s));
        Assert.assertThat((Object)matches.length, (Matcher)CoreMatchers.is((Object)1));
    }
}

