/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.MenuItemSelectedListener;
import freemind.controller.actions.generated.instance.BoldNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class BoldAction
extends NodeGeneralAction
implements NodeActorXml,
MenuItemSelectedListener {
    public BoldAction(MindMapController modeController) {
        super(modeController, "bold", "images/Bold16.gif");
        this.addActor(this);
    }

    @Override
    public void act(XmlAction action) {
        BoldNodeAction boldact;
        NodeAdapter node;
        if (action instanceof BoldNodeAction && (node = this.getNodeFromID((boldact = (BoldNodeAction)action).getNode())).isBold() != boldact.getBold()) {
            node.setBold(boldact.getBold());
            this.modeController.nodeChanged(node);
        }
    }

    @Override
    public Class getDoActionClass() {
        return BoldNodeAction.class;
    }

    @Override
    public ActionPair apply(MindMap model, MindMapNode selected) {
        boolean bold = this.modeController.getSelected().isBold();
        return this.getActionPair(selected, !bold);
    }

    private ActionPair getActionPair(MindMapNode selected, boolean bold) {
        BoldNodeAction boldAction = this.toggleBold(selected, bold);
        BoldNodeAction undoBoldAction = this.toggleBold(selected, selected.isBold());
        return new ActionPair((XmlAction)boldAction, (XmlAction)undoBoldAction);
    }

    private BoldNodeAction toggleBold(MindMapNode selected, boolean bold) {
        BoldNodeAction boldAction = new BoldNodeAction();
        boldAction.setNode(this.getNodeID(selected));
        boldAction.setBold(bold);
        return boldAction;
    }

    public void setBold(MindMapNode node, boolean bold) {
        this.execute(this.getActionPair(node, bold));
    }

    @Override
    public boolean isSelected(JMenuItem item, Action action) {
        return this.modeController.getSelected().isBold();
    }
}

