/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import org.eclipse.dltk.internal.ui.editor.OccurrencesFinder;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ScriptEditorMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ToggleMarkOccurrencesAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public ToggleMarkOccurrencesAction() {
        super(ScriptEditorMessages.getBundleForConstructedKeys(), "ToggleMarkOccurrencesAction.", null, 2);
        DLTKPluginImages.setToolImageDescriptors((IAction)this, "mark_occurrences.png");
        this.update();
    }

    public void run() {
        if (this.fStore != null) {
            this.fStore.setValue("markOccurrences", this.isChecked());
        }
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        OccurrencesFinder occurrencesFinder = editor != null ? (OccurrencesFinder)editor.getAdapter(OccurrencesFinder.class) : null;
        this.setEnabled(occurrencesFinder != null);
        this.setChecked(occurrencesFinder != null && occurrencesFinder.isMarkingOccurrences());
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        if (editor != null) {
            IDLTKUILanguageToolkit toolkit;
            this.disconnectPreferenceStore();
            if (editor instanceof ScriptEditor && (toolkit = DLTKUILanguageManager.getLanguageToolkit(((ScriptEditor)editor).getLanguageToolkit())) != null) {
                this.fStore = toolkit.getPreferenceStore();
                if (this.fStore != null) {
                    this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
                }
            }
        } else {
            this.disconnectPreferenceStore();
        }
        this.update();
    }

    private void disconnectPreferenceStore() {
        if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("markOccurrences")) {
            this.setChecked(Boolean.valueOf(event.getNewValue().toString()));
        }
    }
}

