/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.types.TypeInfoCache;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.symbol.IBeanMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.SymbolPackage;
import org.eclipse.jst.jsf.context.symbol.internal.impl.ITypeDescriptorImpl;

public class IJavaTypeDescriptor2Impl
extends ITypeDescriptorImpl
implements IJavaTypeDescriptor2 {
    public static final String copyright = "Copyright 2006 Oracle";
    protected static final IType TYPE_EDEFAULT = null;
    protected IType type = TYPE_EDEFAULT;
    protected static final int ARRAY_COUNT_EDEFAULT = 0;
    protected int arrayCount = 0;
    protected static final IJavaElement JDT_CONTEXT_EDEFAULT = null;
    protected IJavaElement jdtContext = JDT_CONTEXT_EDEFAULT;

    protected IJavaTypeDescriptor2Impl() {
    }

    protected EClass eStaticClass() {
        return SymbolPackage.Literals.IJAVA_TYPE_DESCRIPTOR2;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType newType) {
        IType oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldType, (Object)this.type));
        }
    }

    public EList getInterfaceTypeSignatures() {
        BasicEList interfaces = new BasicEList();
        IType type_ = this.getType();
        if (type_ != null) {
            TypeInfoCache typeInfoCache = TypeInfoCache.getInstance();
            IType[] interfaceTypes = typeInfoCache.getCachedInterfaceTypes(type_);
            if (interfaceTypes == null) {
                interfaceTypes = typeInfoCache.cacheInterfaceTypesFor(type_);
            }
            this.copySignatures((List)interfaces, interfaceTypes);
        }
        return interfaces;
    }

    public EList getSuperTypeSignatures() {
        BasicEList interfaces = new BasicEList();
        IType type_ = this.getType();
        if (type_ != null) {
            TypeInfoCache typeInfoCache = TypeInfoCache.getInstance();
            IType[] interfaceTypes = typeInfoCache.getCachedSupertypes(type_);
            if (interfaceTypes == null) {
                interfaceTypes = typeInfoCache.cacheSupertypesFor(type_);
            }
            this.copySignatures((List)interfaces, interfaceTypes);
        }
        return interfaces;
    }

    private void copySignatures(List list, IType[] types) {
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                IType type_ = types[i];
                String signature = TypeUtil.getSignature(type_);
                if (signature != null) {
                    list.add(signature);
                }
                ++i;
            }
        }
    }

    public EList getProperties() {
        return this.getBeanProperties();
    }

    public EList getMethods() {
        return this.getBeanMethods();
    }

    public EList getBeanProperties() {
        ArrayList propertyColl;
        TypeInfoCache typeInfoCache = TypeInfoCache.getInstance();
        IBeanPropertySymbol[] properties = typeInfoCache.getCachedPropertySymbols(this.type);
        if (properties == null) {
            propertyColl = this.getPropertiesInternal();
            properties = propertyColl.toArray(new IBeanPropertySymbol[propertyColl.size()]);
            typeInfoCache.cachePropertySymbols(this.type, properties);
        } else {
            propertyColl = new ArrayList(properties.length);
            Collections.addAll(propertyColl, properties);
        }
        BasicEList list = new BasicEList(propertyColl);
        return list;
    }

    public EList getBeanMethods() {
        ArrayList methodColl;
        TypeInfoCache typeInfoCache = TypeInfoCache.getInstance();
        IBeanMethodSymbol[] methods = typeInfoCache.getCachedMethodSymbols(this.type);
        if (methods == null) {
            methodColl = this.getMethodsInternal();
            methods = methodColl.toArray(new IBeanMethodSymbol[methodColl.size()]);
            typeInfoCache.cacheMethodSymbols(this.type, methods);
        } else {
            methodColl = new ArrayList(methods.length);
            Collections.addAll(methodColl, methods);
        }
        BasicEList list = new BasicEList(methodColl);
        return list;
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public void setArrayCount(int newArrayCount) {
        int oldArrayCount = this.arrayCount;
        this.arrayCount = newArrayCount;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldArrayCount, this.arrayCount));
        }
    }

    public IJavaElement getJdtContext() {
        return this.jdtContext;
    }

    public void setJdtContext(IJavaElement newJdtContext) {
        IJavaElement oldJdtContext = this.jdtContext;
        this.jdtContext = newJdtContext;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldJdtContext, (Object)this.jdtContext));
        }
    }

    public IType resolveType(String resolvedTypeSignature) {
        IType resolvedType = null;
        IJavaProject project = null;
        if (this.getType() != null) {
            if (resolvedTypeSignature.equals(this.getTypeSignature())) {
                resolvedType = this.getType();
            } else {
                project = this.getType().getJavaProject();
                if (project != null) {
                    resolvedType = TypeUtil.resolveType(project, resolvedTypeSignature);
                }
            }
        }
        if (resolvedType == null && this.getJdtContext() != null) {
            resolvedType = super.resolveType(resolvedTypeSignature);
        }
        return resolvedType;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getType();
            }
            case 10: {
                return this.getBeanProperties();
            }
            case 11: {
                return this.getBeanMethods();
            }
            case 12: {
                return this.getArrayCount();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setType((IType)newValue);
                return;
            }
            case 10: {
                this.getBeanProperties().clear();
                this.getBeanProperties().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getBeanMethods().clear();
                this.getBeanMethods().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setArrayCount((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 10: {
                this.getBeanProperties().clear();
                return;
            }
            case 11: {
                this.getBeanMethods().clear();
                return;
            }
            case 12: {
                this.setArrayCount(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
            case 10: {
                return !this.getBeanProperties().isEmpty();
            }
            case 11: {
                return !this.getBeanMethods().isEmpty();
            }
            case 12: {
                return this.arrayCount != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public boolean isArray() {
        return this.getArrayCount() > 0;
    }

    public IObjectSymbol getArrayElement() {
        if (this.isArray()) {
            String typeSignature = this.getTypeSignature();
            int arrayCount_ = Signature.getArrayCount((String)typeSignature);
            String baseType = Signature.getElementType((String)typeSignature);
            String elementTypeSignature = Signature.createArraySignature((String)baseType, (int)(arrayCount_ - 1));
            IJavaTypeDescriptor2 elementTypeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
            String fullyQualifiedElementType = TypeUtil.getFullyQualifiedName(baseType);
            IType elementType = null;
            try {
                IType myType = this.getType();
                if (myType != null) {
                    elementType = this.getType().getJavaProject().findType(fullyQualifiedElementType);
                }
            }
            catch (JavaModelException javaModelException) {}
            if (elementType != null) {
                elementTypeDesc.setType(elementType);
            } else {
                elementTypeDesc.setTypeSignatureDelegate(elementTypeSignature);
            }
            elementTypeDesc.setArrayCount(Signature.getArrayCount((String)elementTypeSignature));
            IPropertySymbol newPropertySymbol = SymbolFactory.eINSTANCE.createIPropertySymbol();
            newPropertySymbol.setTypeDescriptor(elementTypeDesc);
            newPropertySymbol.setWritable(true);
            newPropertySymbol.setReadable(true);
            newPropertySymbol.setName(fullyQualifiedElementType);
            return newPropertySymbol;
        }
        return null;
    }

    public String getTypeSignature() {
        if (this.getType() == null) {
            if (this.eIsSet(4)) {
                return this.getTypeSignatureDelegate();
            }
            return null;
        }
        return Signature.createArraySignature((String)TypeUtil.getSignature(this.getType()), (int)this.getArrayCount());
    }

    private Collection getPropertiesInternal() {
        if (this.isArray()) {
            return Collections.EMPTY_LIST;
        }
        JDTBeanIntrospector introspector = new JDTBeanIntrospector(this.getType());
        Map<String, JDTBeanProperty> properties = introspector.getProperties();
        ArrayList<IBeanPropertySymbol> calculatedProps = new ArrayList<IBeanPropertySymbol>(properties.size());
        for (Map.Entry<String, JDTBeanProperty> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            JDTBeanProperty property = entry.getValue();
            IBeanPropertySymbol workingCopy = SymbolFactory.eINSTANCE.createIBeanPropertySymbol();
            workingCopy.setName(propertyName);
            workingCopy.setOwner(this);
            IJavaTypeDescriptor2 workingCopyDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
            workingCopy.setTypeDescriptor(workingCopyDesc);
            workingCopy.setReadable(property.isReadable());
            workingCopy.setWritable(property.isWritable());
            workingCopyDesc.setArrayCount(property.getArrayCount());
            workingCopyDesc.getTypeParameterSignatures().addAll(property.getTypeParameterSignatures());
            workingCopyDesc.setEnumType(property.isEnumType());
            IType newType = property.getType();
            String signature = property.getTypeSignature();
            if (newType != null) {
                workingCopyDesc.setType(newType);
            } else {
                workingCopyDesc.setTypeSignatureDelegate(signature);
            }
            calculatedProps.add(workingCopy);
        }
        return calculatedProps;
    }

    private Collection getMethodsInternal() {
        JDTBeanIntrospector introspector = new JDTBeanIntrospector(this.getType());
        IMethod[] methods = introspector.getAllMethods();
        ArrayList<IBeanMethodSymbol> methodSymbols = new ArrayList<IBeanMethodSymbol>();
        int i = 0;
        while (i < methods.length) {
            IMethod method = methods[i];
            try {
                if (!method.isConstructor() && Flags.isPublic((int)method.getFlags()) && !Flags.isStatic((int)method.getFlags())) {
                    String methodName = method.getElementName();
                    IBeanMethodSymbol workingCopy = SymbolFactory.eINSTANCE.createIBeanMethodSymbol();
                    workingCopy.setName(methodName);
                    workingCopy.setOwner(this);
                    workingCopy.setSignature(TypeUtil.resolveMethodSignature(this.getType(), method.getSignature()));
                    methodSymbols.add(workingCopy);
                }
            }
            catch (JavaModelException jme) {
                JSFCommonPlugin.log(jme);
            }
            ++i;
        }
        return methodSymbols;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (type: ");
        result.append(this.type);
        result.append(", arrayCount: ");
        result.append(this.arrayCount);
        result.append(')');
        return result.toString();
    }
}

