/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.tmf.core.model.timegraph.IElementResolver;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;

public class ResourcesEntryModel
extends TimeGraphEntryModel
implements IElementResolver {
    private final int fResourceId;
    private final Type fType;
    private final @NonNull Multimap<@NonNull String, @NonNull Object> fAspects;

    public ResourcesEntryModel(long id, long parentId, @NonNull List<@NonNull String> labels, long startTime, long endTime, int resourceId, Type type) {
        super(id, parentId, labels, startTime, endTime, type != Type.GROUP);
        this.fResourceId = resourceId;
        this.fType = type;
        switch (type) {
            case CPU: 
            case CURRENT_THREAD: 
            case FREQUENCY: {
                this.fAspects = ImmutableMultimap.of((Object)OsStrings.cpu(), (Object)resourceId);
                break;
            }
            default: {
                this.fAspects = ImmutableMultimap.of();
            }
        }
    }

    public int getResourceId() {
        return this.fResourceId;
    }

    public Type getType() {
        return this.fType;
    }

    public @NonNull Multimap<@NonNull String, @NonNull Object> getMetadata() {
        return this.fAspects;
    }

    public static enum Type {
        GROUP,
        CPU,
        CURRENT_THREAD,
        FREQUENCY,
        IRQ,
        SOFT_IRQ;

    }
}

