/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.DiskWriteModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.InputOutputStateProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Request;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class BlockRqComplete
extends KernelEventHandler {
    private final InputOutputStateProvider fStateProvider;

    public BlockRqComplete(IKernelAnalysisEventLayout layout, InputOutputStateProvider sp) {
        super(layout);
        this.fStateProvider = sp;
    }

    @Override
    public void handleEvent(@NonNull ITmfStateSystemBuilder ss, @NonNull ITmfEvent event) throws AttributeNotFoundException {
        ITmfEventField content = event.getContent();
        long ts = event.getTimestamp().getValue();
        Long sector = (Long)NonNullUtils.checkNotNull((Object)((Long)content.getField(new String[]{this.getLayout().fieldBlockSector()}).getValue()));
        int nrSector = ((Long)content.getField(new String[]{this.getLayout().fieldBlockNrSector()}).getValue()).intValue();
        int phydisk = ((Long)content.getField(new String[]{this.getLayout().fieldBlockDeviceId()}).getValue()).intValue();
        int rwbs = ((Long)content.getField(new String[]{this.getLayout().fieldBlockRwbs()}).getValue()).intValue();
        DiskWriteModel disk = this.fStateProvider.getDisk(phydisk);
        Request request = disk.getDriverRequest(sector);
        if (request == null) {
            request = new Request(disk, sector, rwbs);
        }
        request.setNrSector(nrSector);
        request.setType(rwbs);
        disk.completeRequest(ts, request);
    }
}

