/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.util.Throttler;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.IProgressUpdateCollector;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.util.PrefUtil;

class ProgressViewUpdater
implements IJobProgressManagerListener {
    private static ProgressViewUpdater singleton;
    private Set<IProgressUpdateCollector> collectors;
    UpdatesInfo currentInfo = new UpdatesInfo();
    boolean debug;
    Throttler throttledUpdate = new Throttler(PlatformUI.getWorkbench().getDisplay(), Duration.ofMillis(100L), this::update);

    static ProgressViewUpdater getSingleton() {
        if (singleton == null) {
            singleton = new ProgressViewUpdater();
        }
        return singleton;
    }

    static boolean hasSingleton() {
        return singleton != null;
    }

    static void clearSingleton() {
        if (singleton != null) {
            ProgressManager.getInstance().removeListener(singleton);
        }
        singleton = null;
    }

    private ProgressViewUpdater() {
        this.collectors = new LinkedHashSet<IProgressUpdateCollector>();
        ProgressManager.getInstance().addListener(this);
        this.debug = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_SYSTEM_JOBS");
    }

    void addCollector(IProgressUpdateCollector newCollector) {
        this.collectors.add(newCollector);
    }

    void removeCollector(IProgressUpdateCollector provider) {
        this.collectors.remove(provider);
        if (this.collectors.isEmpty()) {
            ProgressViewUpdater.clearSingleton();
        }
    }

    private void update() {
        if (this.collectors.isEmpty()) {
            return;
        }
        if (this.currentInfo.updateAll) {
            this.currentInfo.reset();
            for (IProgressUpdateCollector collector : this.collectors) {
                collector.refresh();
            }
        } else {
            JobTreeElement[][] elements = this.currentInfo.processForUpdate();
            JobTreeElement[] updateItems = elements[0];
            JobTreeElement[] additionItems = elements[1];
            JobTreeElement[] deletionItems = elements[2];
            this.currentInfo.reset();
            for (IProgressUpdateCollector collector : this.collectors) {
                if (updateItems.length > 0) {
                    collector.refresh(updateItems);
                }
                if (additionItems.length > 0) {
                    collector.add(additionItems);
                }
                if (deletionItems.length <= 0) continue;
                collector.remove(deletionItems);
            }
        }
    }

    @Override
    public void refreshJobInfo(JobInfo info) {
        this.currentInfo.refresh(info);
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void refreshGroup(GroupInfo info) {
        this.currentInfo.refresh(info);
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void addGroup(GroupInfo info) {
        this.currentInfo.add(info);
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void refreshAll() {
        this.currentInfo.updateAll = true;
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void addJob(JobInfo info) {
        GroupInfo group = info.getGroupInfo();
        if (group == null) {
            this.currentInfo.add(info);
        } else {
            this.currentInfo.refresh(group);
        }
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void removeJob(JobInfo info) {
        GroupInfo group = info.getGroupInfo();
        if (group == null) {
            this.currentInfo.remove(info);
        } else {
            this.currentInfo.refresh(group);
        }
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void removeGroup(GroupInfo group) {
        this.currentInfo.remove(group);
        this.throttledUpdate.throttledExec();
    }

    @Override
    public boolean showsDebug() {
        return this.debug;
    }

    static class UpdatesInfo {
        Collection<JobTreeElement> additions = new LinkedHashSet<JobTreeElement>();
        Collection<JobTreeElement> deletions = new LinkedHashSet<JobTreeElement>();
        Collection<JobTreeElement> refreshes = new LinkedHashSet<JobTreeElement>();
        volatile boolean updateAll;

        private UpdatesInfo() {
        }

        synchronized void add(JobTreeElement addition) {
            this.additions.add(addition);
        }

        synchronized void remove(JobTreeElement removal) {
            this.deletions.add(removal);
        }

        synchronized void refresh(JobTreeElement refresh) {
            this.refreshes.add(refresh);
        }

        synchronized void reset() {
            this.additions.clear();
            this.deletions.clear();
            this.refreshes.clear();
            this.updateAll = false;
        }

        synchronized JobTreeElement[][] processForUpdate() {
            HashSet<JobTreeElement> staleAdditions = new HashSet<JobTreeElement>();
            for (JobTreeElement treeElement : this.additions) {
                if (treeElement.isActive() || !this.deletions.contains(treeElement)) continue;
                staleAdditions.add(treeElement);
            }
            this.additions.removeAll(staleAdditions);
            HashSet<JobTreeElement> obsoleteRefresh = new HashSet<JobTreeElement>();
            for (JobTreeElement treeElement : this.refreshes) {
                JobTreeElement parent;
                if (this.deletions.contains(treeElement) || this.additions.contains(treeElement)) {
                    obsoleteRefresh.add(treeElement);
                }
                if ((parent = treeElement.getParent()) != null && (this.deletions.contains(parent) || this.additions.contains(parent))) {
                    obsoleteRefresh.add(treeElement);
                }
                if (treeElement.isActive()) continue;
                obsoleteRefresh.add(treeElement);
                this.deletions.add(treeElement);
            }
            this.refreshes.removeAll(obsoleteRefresh);
            JobTreeElement[] updateItems = this.refreshes.toArray(new JobTreeElement[0]);
            JobTreeElement[] additionItems = this.additions.toArray(new JobTreeElement[0]);
            JobTreeElement[] deletionItems = this.deletions.toArray(new JobTreeElement[0]);
            return new JobTreeElement[][]{updateItems, additionItems, deletionItems};
        }
    }
}

