/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Modifier;

@BugPattern(name="CollectorShouldNotUseState", summary="Collector.of() should not use state", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class CollectorShouldNotUseState
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public static final Matcher<ExpressionTree> COLLECTOR_OF_CALL = Matchers.staticMethod().onClass("java.util.stream.Collector").named("of");
    public final Matcher<Tree> containsAnonymousClassUsingState = Matchers.contains((Matcher)new AnonymousClassUsingStateMatcher());

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState visitorState) {
        if (COLLECTOR_OF_CALL.matches((Tree)methodInvocationTree, visitorState) && this.containsAnonymousClassUsingState.matches((Tree)methodInvocationTree, visitorState)) {
            return this.describeMatch(methodInvocationTree);
        }
        return Description.NO_MATCH;
    }

    private class AnonymousClassUsingStateMatcher
    implements Matcher<Tree> {
        private AnonymousClassUsingStateMatcher() {
        }

        public boolean matches(Tree tree, VisitorState visitorState) {
            if (!(tree instanceof NewClassTree)) {
                return false;
            }
            NewClassTree newClassTree = (NewClassTree)tree;
            if (newClassTree.getClassBody() == null) {
                return false;
            }
            return newClassTree.getClassBody().getMembers().stream().filter(mem -> mem instanceof VariableTree).anyMatch(mem -> !this.isFinal((Tree)mem));
        }

        private boolean isFinal(Tree tree) {
            return ASTHelpers.getSymbol((VariableTree)((VariableTree)tree)).getModifiers().contains((Object)Modifier.FINAL);
        }
    }
}

