#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 10
#define STATE_COUNT 2631
#define SYMBOL_COUNT 158
#define ALIAS_COUNT 1
#define TOKEN_COUNT 98
#define EXTERNAL_TOKEN_COUNT 15
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 10

enum {
  sym_word = 1,
  anon_sym_LF = 2,
  anon_sym_for = 3,
  anon_sym_in = 4,
  anon_sym_LPAREN_LPAREN = 5,
  anon_sym_RPAREN_RPAREN = 6,
  anon_sym_SEMI = 7,
  anon_sym_while = 8,
  anon_sym_do = 9,
  anon_sym_done = 10,
  anon_sym_if = 11,
  anon_sym_then = 12,
  anon_sym_fi = 13,
  anon_sym_elif = 14,
  anon_sym_else = 15,
  anon_sym_case = 16,
  anon_sym_esac = 17,
  anon_sym_PIPE = 18,
  anon_sym_RPAREN = 19,
  anon_sym_SEMI_SEMI = 20,
  anon_sym_function = 21,
  anon_sym_LPAREN = 22,
  anon_sym_LBRACE = 23,
  anon_sym_RBRACE = 24,
  anon_sym_PIPE_AMP = 25,
  anon_sym_AMP_AMP = 26,
  anon_sym_PIPE_PIPE = 27,
  anon_sym_BANG = 28,
  anon_sym_LBRACK = 29,
  anon_sym_RBRACK = 30,
  anon_sym_LBRACK_LBRACK = 31,
  anon_sym_RBRACK_RBRACK = 32,
  anon_sym_declare = 33,
  anon_sym_typeset = 34,
  anon_sym_export = 35,
  anon_sym_readonly = 36,
  anon_sym_local = 37,
  anon_sym_unset = 38,
  anon_sym_unsetenv = 39,
  anon_sym_EQ_TILDE = 40,
  anon_sym_EQ_EQ = 41,
  anon_sym_EQ = 42,
  anon_sym_PLUS_EQ = 43,
  anon_sym_LT = 44,
  anon_sym_GT = 45,
  anon_sym_GT_GT = 46,
  anon_sym_AMP_GT = 47,
  anon_sym_AMP_GT_GT = 48,
  anon_sym_LT_AMP = 49,
  anon_sym_GT_AMP = 50,
  anon_sym_LT_LT = 51,
  anon_sym_LT_LT_DASH = 52,
  anon_sym_LT_LT_LT = 53,
  anon_sym_BANG_EQ = 54,
  anon_sym_PLUS = 55,
  anon_sym_DASH = 56,
  anon_sym_DASH_EQ = 57,
  anon_sym_LT_EQ = 58,
  anon_sym_GT_EQ = 59,
  anon_sym_PLUS_PLUS = 60,
  anon_sym_DASH_DASH = 61,
  anon_sym_DOLLAR = 62,
  sym__special_character = 63,
  anon_sym_DQUOTE = 64,
  sym__string_content = 65,
  sym_raw_string = 66,
  sym_ansii_c_string = 67,
  anon_sym_POUND = 68,
  anon_sym_DOLLAR_LBRACE = 69,
  anon_sym_SLASH = 70,
  anon_sym_COLON = 71,
  anon_sym_COLON_QMARK = 72,
  anon_sym_COLON_DASH = 73,
  anon_sym_PERCENT = 74,
  anon_sym_DOLLAR_LPAREN = 75,
  anon_sym_BQUOTE = 76,
  anon_sym_LT_LPAREN = 77,
  anon_sym_GT_LPAREN = 78,
  sym_comment = 79,
  aux_sym__simple_variable_name_token1 = 80,
  anon_sym_STAR = 81,
  anon_sym_AT = 82,
  anon_sym_QMARK = 83,
  anon_sym_0 = 84,
  anon_sym__ = 85,
  sym_test_operator = 86,
  anon_sym_AMP = 87,
  sym_heredoc_start = 88,
  sym__simple_heredoc_body = 89,
  sym__heredoc_body_beginning = 90,
  sym__heredoc_body_middle = 91,
  sym__heredoc_body_end = 92,
  sym_file_descriptor = 93,
  sym__empty_value = 94,
  sym__concat = 95,
  sym_variable_name = 96,
  sym_regex = 97,
  sym_program = 98,
  sym__statements = 99,
  aux_sym__statements2 = 100,
  sym__terminated_statement = 101,
  sym_redirected_statement = 102,
  sym_for_statement = 103,
  sym_c_style_for_statement = 104,
  sym_while_statement = 105,
  sym_do_group = 106,
  sym_if_statement = 107,
  sym_elif_clause = 108,
  sym_else_clause = 109,
  sym_case_statement = 110,
  sym_case_item = 111,
  sym_last_case_item = 112,
  sym_function_definition = 113,
  sym_compound_statement = 114,
  sym_subshell = 115,
  sym_pipeline = 116,
  sym_list = 117,
  sym_negated_command = 118,
  sym_test_command = 119,
  sym_declaration_command = 120,
  sym_unset_command = 121,
  sym_command = 122,
  sym_command_name = 123,
  sym_variable_assignment = 124,
  sym_subscript = 125,
  sym_file_redirect = 126,
  sym_heredoc_redirect = 127,
  sym_heredoc_body = 128,
  sym_herestring_redirect = 129,
  sym__expression = 130,
  sym_binary_expression = 131,
  sym_unary_expression = 132,
  sym_postfix_expression = 133,
  sym_parenthesized_expression = 134,
  sym_concatenation = 135,
  sym_string = 136,
  sym_array = 137,
  sym_simple_expansion = 138,
  sym_string_expansion = 139,
  sym_expansion = 140,
  sym_command_substitution = 141,
  sym_process_substitution = 142,
  aux_sym__statements_repeat1 = 143,
  aux_sym_redirected_statement_repeat1 = 144,
  aux_sym_for_statement_repeat1 = 145,
  aux_sym_if_statement_repeat1 = 146,
  aux_sym_case_statement_repeat1 = 147,
  aux_sym_case_item_repeat1 = 148,
  aux_sym_declaration_command_repeat1 = 149,
  aux_sym_unset_command_repeat1 = 150,
  aux_sym_command_repeat1 = 151,
  aux_sym_command_repeat2 = 152,
  aux_sym_heredoc_body_repeat1 = 153,
  aux_sym__literal_repeat1 = 154,
  aux_sym_concatenation_repeat1 = 155,
  aux_sym_string_repeat1 = 156,
  aux_sym_expansion_repeat1 = 157,
  alias_sym_special_variable_name = 158,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_word] = "word",
  [anon_sym_LF] = "\n",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_LPAREN_LPAREN] = "((",
  [anon_sym_RPAREN_RPAREN] = "))",
  [anon_sym_SEMI] = ";",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_done] = "done",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_fi] = "fi",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_case] = "case",
  [anon_sym_esac] = "esac",
  [anon_sym_PIPE] = "|",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI_SEMI] = ";;",
  [anon_sym_function] = "function",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PIPE_AMP] = "|&",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG] = "!",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_declare] = "declare",
  [anon_sym_typeset] = "typeset",
  [anon_sym_export] = "export",
  [anon_sym_readonly] = "readonly",
  [anon_sym_local] = "local",
  [anon_sym_unset] = "unset",
  [anon_sym_unsetenv] = "unsetenv",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_GT] = "&>",
  [anon_sym_AMP_GT_GT] = "&>>",
  [anon_sym_LT_AMP] = "<&",
  [anon_sym_GT_AMP] = ">&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_LT_LT_LT] = "<<<",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DOLLAR] = "$",
  [sym__special_character] = "_special_character",
  [anon_sym_DQUOTE] = "\"",
  [sym__string_content] = "_string_content",
  [sym_raw_string] = "raw_string",
  [sym_ansii_c_string] = "ansii_c_string",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_COLON_QMARK] = ":?",
  [anon_sym_COLON_DASH] = ":-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LT_LPAREN] = "<(",
  [anon_sym_GT_LPAREN] = ">(",
  [sym_comment] = "comment",
  [aux_sym__simple_variable_name_token1] = "variable_name",
  [anon_sym_STAR] = "special_variable_name",
  [anon_sym_AT] = "special_variable_name",
  [anon_sym_QMARK] = "special_variable_name",
  [anon_sym_0] = "special_variable_name",
  [anon_sym__] = "special_variable_name",
  [sym_test_operator] = "test_operator",
  [anon_sym_AMP] = "&",
  [sym_heredoc_start] = "heredoc_start",
  [sym__simple_heredoc_body] = "_simple_heredoc_body",
  [sym__heredoc_body_beginning] = "_heredoc_body_beginning",
  [sym__heredoc_body_middle] = "_heredoc_body_middle",
  [sym__heredoc_body_end] = "_heredoc_body_end",
  [sym_file_descriptor] = "file_descriptor",
  [sym__empty_value] = "_empty_value",
  [sym__concat] = "_concat",
  [sym_variable_name] = "variable_name",
  [sym_regex] = "regex",
  [sym_program] = "program",
  [sym__statements] = "_statements",
  [aux_sym__statements2] = "_statements2",
  [sym__terminated_statement] = "_terminated_statement",
  [sym_redirected_statement] = "redirected_statement",
  [sym_for_statement] = "for_statement",
  [sym_c_style_for_statement] = "c_style_for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_group] = "do_group",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_case_statement] = "case_statement",
  [sym_case_item] = "case_item",
  [sym_last_case_item] = "case_item",
  [sym_function_definition] = "function_definition",
  [sym_compound_statement] = "compound_statement",
  [sym_subshell] = "subshell",
  [sym_pipeline] = "pipeline",
  [sym_list] = "list",
  [sym_negated_command] = "negated_command",
  [sym_test_command] = "test_command",
  [sym_declaration_command] = "declaration_command",
  [sym_unset_command] = "unset_command",
  [sym_command] = "command",
  [sym_command_name] = "command_name",
  [sym_variable_assignment] = "variable_assignment",
  [sym_subscript] = "subscript",
  [sym_file_redirect] = "file_redirect",
  [sym_heredoc_redirect] = "heredoc_redirect",
  [sym_heredoc_body] = "heredoc_body",
  [sym_herestring_redirect] = "herestring_redirect",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_concatenation] = "concatenation",
  [sym_string] = "string",
  [sym_array] = "array",
  [sym_simple_expansion] = "simple_expansion",
  [sym_string_expansion] = "string_expansion",
  [sym_expansion] = "expansion",
  [sym_command_substitution] = "command_substitution",
  [sym_process_substitution] = "process_substitution",
  [aux_sym__statements_repeat1] = "_statements_repeat1",
  [aux_sym_redirected_statement_repeat1] = "redirected_statement_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_case_item_repeat1] = "case_item_repeat1",
  [aux_sym_declaration_command_repeat1] = "declaration_command_repeat1",
  [aux_sym_unset_command_repeat1] = "unset_command_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_command_repeat2] = "command_repeat2",
  [aux_sym_heredoc_body_repeat1] = "heredoc_body_repeat1",
  [aux_sym__literal_repeat1] = "_literal_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_expansion_repeat1] = "expansion_repeat1",
  [alias_sym_special_variable_name] = "special_variable_name",
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_done] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_esac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsetenv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__special_character] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [sym_ansii_c_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__simple_variable_name_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = true,
  },
  [sym_test_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_heredoc_start] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_heredoc_body] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_beginning] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_middle] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_end] = {
    .visible = false,
    .named = true,
  },
  [sym_file_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_value] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__statements] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__statements2] = {
    .visible = false,
    .named = false,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_redirected_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_c_style_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_group] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_last_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_subshell] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_command] = {
    .visible = true,
    .named = true,
  },
  [sym_test_command] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_command] = {
    .visible = true,
    .named = true,
  },
  [sym_unset_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_body] = {
    .visible = true,
    .named = true,
  },
  [sym_herestring_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_process_substitution] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_redirected_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unset_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_heredoc_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_special_variable_name] = {
    .visible = true,
    .named = true,
  },
};

static TSSymbol ts_alias_sequences[8][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [1] = {
    [0] = sym_word,
  },
  [2] = {
    [1] = sym_word,
  },
  [3] = {
    [1] = alias_sym_special_variable_name,
  },
  [4] = {
    [2] = sym_word,
  },
  [5] = {
    [2] = alias_sym_special_variable_name,
  },
  [6] = {
    [3] = sym_word,
  },
  [7] = {
    [4] = sym_word,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '!') ADVANCE(156);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '%') ADVANCE(228);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(149);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(195);
      if (lookahead == '-') ADVANCE(198);
      if (lookahead == '/') ADVANCE(224);
      if (lookahead == '0') ADVANCE(251);
      if (lookahead == ':') ADVANCE(225);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(178);
      if (lookahead == '=') ADVANCE(170);
      if (lookahead == '>') ADVANCE(181);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == ']') ADVANCE(162);
      if (lookahead == '_') ADVANCE(254);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(260);
      if (lookahead == 'i') ADVANCE(259);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 1:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\n') ADVANCE(116);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '=') ADVANCE(256);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(74);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 2:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\n') ADVANCE(117);
      if (lookahead == '!') ADVANCE(155);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(209);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '-') ADVANCE(197);
      if (lookahead == '0') ADVANCE(252);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(179);
      if (lookahead == '>') ADVANCE(183);
      if (lookahead == '?') ADVANCE(248);
      if (lookahead == '@') ADVANCE(246);
      if (lookahead == '\\') SKIP(12)
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 3:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\n') ADVANCE(117);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(179);
      if (lookahead == '>') ADVANCE(183);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(70);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      END_STATE();
    case 4:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\n') ADVANCE(117);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '&') ADVANCE(264);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') SKIP(11)
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(70);
      if (lookahead == 'i') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      END_STATE();
    case 5:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\n') ADVANCE(120);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(76);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(262);
      END_STATE();
    case 6:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\n') ADVANCE(121);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(83);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(262);
      END_STATE();
    case 7:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '0') ADVANCE(250);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '=') ADVANCE(256);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(94);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(262);
      END_STATE();
    case 8:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\n') ADVANCE(127);
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '0') ADVANCE(250);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(104);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(262);
      END_STATE();
    case 9:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(149);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(176);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(73);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 10:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      END_STATE();
    case 11:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      END_STATE();
    case 12:
      if (lookahead == 0) ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      END_STATE();
    case 13:
      if (lookahead == '\n') ADVANCE(116);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '=') ADVANCE(256);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(74);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 14:
      if (lookahead == '\n') ADVANCE(117);
      if (lookahead == '!') ADVANCE(155);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(209);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '-') ADVANCE(197);
      if (lookahead == '0') ADVANCE(252);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(179);
      if (lookahead == '>') ADVANCE(183);
      if (lookahead == '?') ADVANCE(248);
      if (lookahead == '@') ADVANCE(246);
      if (lookahead == '\\') SKIP(112)
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == 'e') ADVANCE(242);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 15:
      if (lookahead == '\n') ADVANCE(117);
      if (lookahead == '!') ADVANCE(155);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(209);
      if (lookahead == '&') ADVANCE(264);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '-') ADVANCE(197);
      if (lookahead == '0') ADVANCE(252);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '?') ADVANCE(248);
      if (lookahead == '@') ADVANCE(246);
      if (lookahead == '\\') SKIP(105)
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == 'i') ADVANCE(241);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 16:
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(264);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == '-') ADVANCE(261);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(59);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(89);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 17:
      if (lookahead == '\n') ADVANCE(119);
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(209);
      if (lookahead == '&') ADVANCE(265);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(196);
      if (lookahead == '-') ADVANCE(199);
      if (lookahead == '0') ADVANCE(252);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(180);
      if (lookahead == '=') ADVANCE(171);
      if (lookahead == '>') ADVANCE(184);
      if (lookahead == '?') ADVANCE(248);
      if (lookahead == '@') ADVANCE(246);
      if (lookahead == '\\') SKIP(108)
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 18:
      if (lookahead == '\n') ADVANCE(119);
      if (lookahead == '!') ADVANCE(63);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '&') ADVANCE(265);
      if (lookahead == '+') ADVANCE(196);
      if (lookahead == '-') ADVANCE(199);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(180);
      if (lookahead == '=') ADVANCE(171);
      if (lookahead == '>') ADVANCE(184);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') SKIP(93)
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      END_STATE();
    case 19:
      if (lookahead == '\n') ADVANCE(120);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(76);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(262);
      END_STATE();
    case 20:
      if (lookahead == '\n') ADVANCE(121);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(83);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(262);
      END_STATE();
    case 21:
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '0') ADVANCE(250);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '=') ADVANCE(256);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(94);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(262);
      END_STATE();
    case 22:
      if (lookahead == '\n') ADVANCE(123);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(264);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(59);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(97);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 23:
      if (lookahead == '\n') ADVANCE(124);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '=') ADVANCE(256);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(260);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(262);
      END_STATE();
    case 24:
      if (lookahead == '\n') ADVANCE(125);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(237);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(262);
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(126);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(103);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(260);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(262);
      END_STATE();
    case 26:
      if (lookahead == '\n') ADVANCE(127);
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '0') ADVANCE(250);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(104);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(262);
      END_STATE();
    case 27:
      if (lookahead == '\n') ADVANCE(128);
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(264);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '0') ADVANCE(250);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(59);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(109);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 28:
      if (lookahead == '\n') ADVANCE(129);
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '0') ADVANCE(250);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '=') ADVANCE(256);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(110);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(237);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(262);
      END_STATE();
    case 29:
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '0') ADVANCE(250);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(111);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(237);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(262);
      END_STATE();
    case 30:
      if (lookahead == '!') ADVANCE(156);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '%') ADVANCE(228);
      if (lookahead == '&') ADVANCE(266);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(149);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '+') ADVANCE(195);
      if (lookahead == '-') ADVANCE(198);
      if (lookahead == '/') ADVANCE(224);
      if (lookahead == '0') ADVANCE(251);
      if (lookahead == ':') ADVANCE(225);
      if (lookahead == ';') ADVANCE(137);
      if (lookahead == '<') ADVANCE(178);
      if (lookahead == '=') ADVANCE(170);
      if (lookahead == '>') ADVANCE(181);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == ']') ADVANCE(162);
      if (lookahead == '_') ADVANCE(254);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(260);
      if (lookahead == 'i') ADVANCE(259);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 31:
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '%') ADVANCE(228);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '0') ADVANCE(250);
      if (lookahead == ':') ADVANCE(225);
      if (lookahead == '<') ADVANCE(59);
      if (lookahead == '=') ADVANCE(172);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(107);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 32:
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == '*') ADVANCE(245);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '0') ADVANCE(250);
      if (lookahead == '<') ADVANCE(176);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '?') ADVANCE(249);
      if (lookahead == '@') ADVANCE(247);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead == '_') ADVANCE(253);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 33:
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(149);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(176);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(73);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 34:
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(149);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(176);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(99);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(260);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 35:
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(149);
      if (lookahead == '<') ADVANCE(176);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(78);
      if (lookahead == ']') ADVANCE(212);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 36:
      if (lookahead == '!') ADVANCE(158);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '-') ADVANCE(261);
      if (lookahead == '<') ADVANCE(59);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(79);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 37:
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(209);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(196);
      if (lookahead == '-') ADVANCE(199);
      if (lookahead == '0') ADVANCE(252);
      if (lookahead == '<') ADVANCE(180);
      if (lookahead == '=') ADVANCE(171);
      if (lookahead == '>') ADVANCE(184);
      if (lookahead == '?') ADVANCE(248);
      if (lookahead == '@') ADVANCE(246);
      if (lookahead == '\\') SKIP(77)
      if (lookahead == ']') ADVANCE(66);
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '|') ADVANCE(144);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 38:
      if (lookahead == '!') ADVANCE(157);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(209);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(196);
      if (lookahead == '-') ADVANCE(199);
      if (lookahead == '0') ADVANCE(252);
      if (lookahead == '<') ADVANCE(180);
      if (lookahead == '=') ADVANCE(171);
      if (lookahead == '>') ADVANCE(184);
      if (lookahead == '?') ADVANCE(248);
      if (lookahead == '@') ADVANCE(246);
      if (lookahead == '\\') SKIP(106)
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(38)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 39:
      if (lookahead == '!') ADVANCE(155);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(209);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '-') ADVANCE(197);
      if (lookahead == '0') ADVANCE(252);
      if (lookahead == '?') ADVANCE(248);
      if (lookahead == '@') ADVANCE(246);
      if (lookahead == '\\') ADVANCE(88);
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(216);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(218);
      END_STATE();
    case 40:
      if (lookahead == '!') ADVANCE(63);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(209);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(196);
      if (lookahead == '-') ADVANCE(199);
      if (lookahead == '0') ADVANCE(252);
      if (lookahead == '<') ADVANCE(180);
      if (lookahead == '=') ADVANCE(171);
      if (lookahead == '>') ADVANCE(184);
      if (lookahead == '?') ADVANCE(248);
      if (lookahead == '@') ADVANCE(246);
      if (lookahead == '\\') SKIP(84)
      if (lookahead == ']') ADVANCE(66);
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '|') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 41:
      if (lookahead == '!') ADVANCE(63);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '+') ADVANCE(196);
      if (lookahead == '-') ADVANCE(199);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(180);
      if (lookahead == '=') ADVANCE(171);
      if (lookahead == '>') ADVANCE(184);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') SKIP(85)
      if (lookahead == ']') ADVANCE(213);
      if (lookahead == 'e') ADVANCE(70);
      if (lookahead == 'i') ADVANCE(69);
      if (lookahead == '|') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(41)
      END_STATE();
    case 42:
      if (lookahead == '!') ADVANCE(63);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == '+') ADVANCE(196);
      if (lookahead == '-') ADVANCE(199);
      if (lookahead == '<') ADVANCE(180);
      if (lookahead == '=') ADVANCE(171);
      if (lookahead == '>') ADVANCE(184);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(212);
      if (lookahead == '\\') SKIP(90)
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(42)
      END_STATE();
    case 43:
      if (lookahead == '!') ADVANCE(63);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '+') ADVANCE(196);
      if (lookahead == '-') ADVANCE(199);
      if (lookahead == '<') ADVANCE(180);
      if (lookahead == '=') ADVANCE(171);
      if (lookahead == '>') ADVANCE(184);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') SKIP(86)
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      END_STATE();
    case 44:
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '%') ADVANCE(228);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == '/') ADVANCE(224);
      if (lookahead == ':') ADVANCE(225);
      if (lookahead == '<') ADVANCE(59);
      if (lookahead == '=') ADVANCE(172);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(87);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 45:
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '%') ADVANCE(228);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '-') ADVANCE(200);
      if (lookahead == ':') ADVANCE(225);
      if (lookahead == '<') ADVANCE(59);
      if (lookahead == '=') ADVANCE(172);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(91);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(45)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 46:
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(149);
      if (lookahead == '<') ADVANCE(176);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(80);
      if (lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(46)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 47:
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '(') ADVANCE(148);
      if (lookahead == ')') ADVANCE(145);
      if (lookahead == '<') ADVANCE(176);
      if (lookahead == '>') ADVANCE(182);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '|') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      if (lookahead != 0 &&
          lookahead != ';') ADVANCE(262);
      END_STATE();
    case 48:
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '<') ADVANCE(59);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(92);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '}') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 49:
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '<') ADVANCE(59);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(96);
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 50:
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '$') ADVANCE(210);
      if (lookahead == '\'') ADVANCE(55);
      if (lookahead == '<') ADVANCE(59);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(95);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == 'e') ADVANCE(260);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(262);
      END_STATE();
    case 51:
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(215);
      if (lookahead == '$') ADVANCE(211);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(217);
      if (lookahead != 0) ADVANCE(218);
      END_STATE();
    case 52:
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == '&') ADVANCE(65);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '+') ADVANCE(64);
      if (lookahead == '<') ADVANCE(175);
      if (lookahead == '=') ADVANCE(169);
      if (lookahead == '>') ADVANCE(183);
      if (lookahead == '[') ADVANCE(159);
      if (lookahead == '\\') SKIP(81)
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 53:
      if (lookahead == '#') ADVANCE(234);
      if (lookahead == ';') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(98);
      if (lookahead == '{') ADVANCE(150);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(262);
      END_STATE();
    case 54:
      if (lookahead == '&') ADVANCE(153);
      END_STATE();
    case 55:
      if (lookahead == '\'') ADVANCE(219);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 56:
      if (lookahead == '\'') ADVANCE(220);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0) ADVANCE(56);
      END_STATE();
    case 57:
      if (lookahead == '\'') ADVANCE(221);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0) ADVANCE(56);
      END_STATE();
    case 58:
      if (lookahead == '(') ADVANCE(134);
      END_STATE();
    case 59:
      if (lookahead == '(') ADVANCE(231);
      END_STATE();
    case 60:
      if (lookahead == '(') ADVANCE(232);
      END_STATE();
    case 61:
      if (lookahead == ')') ADVANCE(135);
      END_STATE();
    case 62:
      if (lookahead == ';') ADVANCE(147);
      END_STATE();
    case 63:
      if (lookahead == '=') ADVANCE(193);
      END_STATE();
    case 64:
      if (lookahead == '=') ADVANCE(173);
      END_STATE();
    case 65:
      if (lookahead == '>') ADVANCE(186);
      END_STATE();
    case 66:
      if (lookahead == ']') ADVANCE(164);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(68);
      END_STATE();
    case 68:
      if (lookahead == 'c') ADVANCE(138);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(131);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 71:
      if (lookahead == '|') ADVANCE(154);
      END_STATE();
    case 72:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 73:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 74:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 75:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 76:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 77:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      END_STATE();
    case 78:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 79:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 80:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(46)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 81:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      END_STATE();
    case 82:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(217);
      if (lookahead != 0) ADVANCE(218);
      END_STATE();
    case 83:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 84:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      END_STATE();
    case 85:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(41)
      END_STATE();
    case 86:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      END_STATE();
    case 87:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 88:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(216);
      if (lookahead != 0) ADVANCE(218);
      END_STATE();
    case 89:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 90:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(42)
      END_STATE();
    case 91:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(45)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 92:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 93:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      END_STATE();
    case 94:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 95:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 96:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 97:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 98:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 99:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 100:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 101:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 102:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 103:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 104:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 105:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      END_STATE();
    case 106:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(38)
      END_STATE();
    case 107:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 108:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      END_STATE();
    case 109:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 110:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 111:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 112:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      END_STATE();
    case 113:
      if (lookahead != 0) ADVANCE(218);
      END_STATE();
    case 114:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(262);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(116);
      if (lookahead == '\\') ADVANCE(74);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(117);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(118);
      if (lookahead == '-') ADVANCE(261);
      if (lookahead == '\\') ADVANCE(89);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(119);
      if (lookahead == '-') ADVANCE(199);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(120);
      if (lookahead == '\\') ADVANCE(76);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(83);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '\\') ADVANCE(94);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(123);
      if (lookahead == '\\') ADVANCE(97);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(100);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(125);
      if (lookahead == '\\') ADVANCE(101);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(126);
      if (lookahead == '\\') ADVANCE(103);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(104);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(128);
      if (lookahead == '\\') ADVANCE(109);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(129);
      if (lookahead == '\\') ADVANCE(110);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(111);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_in);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LPAREN_LPAREN);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_RPAREN_RPAREN);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == ';') ADVANCE(147);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_esac);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_esac);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '&') ADVANCE(152);
      if (lookahead == '|') ADVANCE(154);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(154);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      if (lookahead == ')') ADVANCE(135);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '(') ADVANCE(134);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_PIPE_AMP);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(194);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || '>' < lookahead) &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(193);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(163);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      if (lookahead == ']') ADVANCE(164);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(168);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || '>' < lookahead) &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(167);
      if (lookahead == '~') ADVANCE(165);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(188);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(188);
      if (lookahead == '(') ADVANCE(231);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(188);
      if (lookahead == '(') ADVANCE(231);
      if (lookahead == '<') ADVANCE(190);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(188);
      if (lookahead == '(') ADVANCE(231);
      if (lookahead == '<') ADVANCE(190);
      if (lookahead == '=') ADVANCE(203);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(188);
      if (lookahead == '<') ADVANCE(190);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(203);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(189);
      if (lookahead == '(') ADVANCE(232);
      if (lookahead == '=') ADVANCE(204);
      if (lookahead == '>') ADVANCE(185);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(189);
      if (lookahead == '(') ADVANCE(232);
      if (lookahead == '>') ADVANCE(185);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(189);
      if (lookahead == '>') ADVANCE(185);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(204);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_AMP_GT);
      if (lookahead == '>') ADVANCE(187);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_AMP_GT_GT);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_LT_AMP);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_GT_AMP);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '-') ADVANCE(191);
      if (lookahead == '<') ADVANCE(192);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_LT_LT_LT);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(206);
      if (lookahead == '=') ADVANCE(174);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || '>' < lookahead) &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(205);
      if (lookahead == '=') ADVANCE(173);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(208);
      if (lookahead == '=') ADVANCE(202);
      if (lookahead == '\\') ADVANCE(114);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(263);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || '>' < lookahead) &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(207);
      if (lookahead == '=') ADVANCE(201);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(263);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '\'') ADVANCE(56);
      if (lookahead == '(') ADVANCE(229);
      if (lookahead == '{') ADVANCE(223);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(') ADVANCE(229);
      if (lookahead == '{') ADVANCE(223);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym__special_character);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym__special_character);
      if (lookahead == ']') ADVANCE(164);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '\\') ADVANCE(233);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(215);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '!') ADVANCE(155);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(222);
      if (lookahead == '$') ADVANCE(209);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '-') ADVANCE(197);
      if (lookahead == '0') ADVANCE(252);
      if (lookahead == '?') ADVANCE(248);
      if (lookahead == '@') ADVANCE(246);
      if (lookahead == '\\') ADVANCE(88);
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(216);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(218);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '"') ADVANCE(214);
      if (lookahead == '#') ADVANCE(215);
      if (lookahead == '$') ADVANCE(211);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == '`') ADVANCE(230);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(217);
      if (lookahead != 0) ADVANCE(218);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\\') ADVANCE(113);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(218);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_raw_string);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_ansii_c_string);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_ansii_c_string);
      if (lookahead == '\'') ADVANCE(220);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0) ADVANCE(56);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-') ADVANCE(227);
      if (lookahead == '?') ADVANCE(226);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_COLON_QMARK);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_COLON_DASH);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_LT_LPAREN);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_GT_LPAREN);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead != 0) ADVANCE(215);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(234);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == 'a') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == 'c') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == 's') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'a') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'c') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'n') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 's') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=') ADVANCE(168);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || '>' < lookahead) &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == 'a') ADVANCE(258);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == 'c') ADVANCE(140);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == 'n') ADVANCE(132);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == 's') ADVANCE(257);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(114);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(263);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(262);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(263);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(153);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(153);
      if (lookahead == '>') ADVANCE(186);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'c') ADVANCE(2);
      if (lookahead == 'd') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'i') ADVANCE(6);
      if (lookahead == 'l') ADVANCE(7);
      if (lookahead == 'r') ADVANCE(8);
      if (lookahead == 't') ADVANCE(9);
      if (lookahead == 'u') ADVANCE(10);
      if (lookahead == 'w') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(12);
      END_STATE();
    case 3:
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(14);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(15);
      if (lookahead == 'x') ADVANCE(16);
      END_STATE();
    case 5:
      if (lookahead == 'i') ADVANCE(17);
      if (lookahead == 'o') ADVANCE(18);
      if (lookahead == 'u') ADVANCE(19);
      END_STATE();
    case 6:
      if (lookahead == 'f') ADVANCE(20);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == 'h') ADVANCE(23);
      if (lookahead == 'y') ADVANCE(24);
      END_STATE();
    case 10:
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(26);
      END_STATE();
    case 12:
      if (lookahead == 's') ADVANCE(27);
      END_STATE();
    case 13:
      if (lookahead == 'c') ADVANCE(28);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 15:
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 's') ADVANCE(31);
      END_STATE();
    case 16:
      if (lookahead == 'p') ADVANCE(32);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_fi);
      END_STATE();
    case 18:
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 21:
      if (lookahead == 'c') ADVANCE(35);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(36);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 24:
      if (lookahead == 'p') ADVANCE(38);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(39);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(40);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 30:
      if (lookahead == 'f') ADVANCE(44);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(46);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(47);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(48);
      END_STATE();
    case 36:
      if (lookahead == 'd') ADVANCE(49);
      END_STATE();
    case 37:
      if (lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(53);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(54);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_done);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 46:
      if (lookahead == 'r') ADVANCE(55);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(57);
      END_STATE();
    case 49:
      if (lookahead == 'o') ADVANCE(58);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 51:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(60);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(64);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 58:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_unset);
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 64:
      if (lookahead == 'o') ADVANCE(69);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 66:
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 67:
      if (lookahead == 'n') ADVANCE(72);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 70:
      if (lookahead == 'y') ADVANCE(74);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_typeset);
      END_STATE();
    case 72:
      if (lookahead == 'v') ADVANCE(75);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_unsetenv);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 9, .external_lex_state = 2},
  [2] = {.lex_state = 1, .external_lex_state = 3},
  [3] = {.lex_state = 9, .external_lex_state = 2},
  [4] = {.lex_state = 47},
  [5] = {.lex_state = 5, .external_lex_state = 4},
  [6] = {.lex_state = 5, .external_lex_state = 5},
  [7] = {.lex_state = 37},
  [8] = {.lex_state = 9, .external_lex_state = 2},
  [9] = {.lex_state = 47},
  [10] = {.lex_state = 35, .external_lex_state = 6},
  [11] = {.lex_state = 1, .external_lex_state = 3},
  [12] = {.lex_state = 9, .external_lex_state = 2},
  [13] = {.lex_state = 47},
  [14] = {.lex_state = 36},
  [15] = {.lex_state = 1, .external_lex_state = 3},
  [16] = {.lex_state = 37, .external_lex_state = 7},
  [17] = {.lex_state = 46, .external_lex_state = 2},
  [18] = {.lex_state = 52},
  [19] = {.lex_state = 52},
  [20] = {.lex_state = 9, .external_lex_state = 2},
  [21] = {.lex_state = 51},
  [22] = {.lex_state = 9, .external_lex_state = 2},
  [23] = {.lex_state = 52},
  [24] = {.lex_state = 9, .external_lex_state = 2},
  [25] = {.lex_state = 36},
  [26] = {.lex_state = 36},
  [27] = {.lex_state = 1, .external_lex_state = 5},
  [28] = {.lex_state = 3, .external_lex_state = 5},
  [29] = {.lex_state = 6, .external_lex_state = 4},
  [30] = {.lex_state = 52},
  [31] = {.lex_state = 1, .external_lex_state = 5},
  [32] = {.lex_state = 9, .external_lex_state = 2},
  [33] = {.lex_state = 9},
  [34] = {.lex_state = 47, .external_lex_state = 2},
  [35] = {.lex_state = 9},
  [36] = {.lex_state = 1, .external_lex_state = 5},
  [37] = {.lex_state = 9},
  [38] = {.lex_state = 47},
  [39] = {.lex_state = 1, .external_lex_state = 3},
  [40] = {.lex_state = 9},
  [41] = {.lex_state = 47, .external_lex_state = 8},
  [42] = {.lex_state = 47, .external_lex_state = 2},
  [43] = {.lex_state = 47, .external_lex_state = 2},
  [44] = {.lex_state = 5, .external_lex_state = 9},
  [45] = {.lex_state = 5, .external_lex_state = 4},
  [46] = {.lex_state = 5, .external_lex_state = 4},
  [47] = {.lex_state = 5, .external_lex_state = 3},
  [48] = {.lex_state = 5, .external_lex_state = 5},
  [49] = {.lex_state = 5, .external_lex_state = 5},
  [50] = {.lex_state = 1, .external_lex_state = 3},
  [51] = {.lex_state = 1, .external_lex_state = 3},
  [52] = {.lex_state = 1, .external_lex_state = 3},
  [53] = {.lex_state = 9},
  [54] = {.lex_state = 40},
  [55] = {.lex_state = 3, .external_lex_state = 5},
  [56] = {.lex_state = 3, .external_lex_state = 5},
  [57] = {.lex_state = 6, .external_lex_state = 4},
  [58] = {.lex_state = 35, .external_lex_state = 6},
  [59] = {.lex_state = 47},
  [60] = {.lex_state = 3, .external_lex_state = 5},
  [61] = {.lex_state = 6, .external_lex_state = 4},
  [62] = {.lex_state = 4, .external_lex_state = 10},
  [63] = {.lex_state = 4, .external_lex_state = 11},
  [64] = {.lex_state = 4, .external_lex_state = 11},
  [65] = {.lex_state = 40, .external_lex_state = 12},
  [66] = {.lex_state = 36},
  [67] = {.lex_state = 36},
  [68] = {.lex_state = 41},
  [69] = {.lex_state = 43},
  [70] = {.lex_state = 44, .external_lex_state = 13},
  [71] = {.lex_state = 40, .external_lex_state = 7},
  [72] = {.lex_state = 52},
  [73] = {.lex_state = 44, .external_lex_state = 13},
  [74] = {.lex_state = 3, .external_lex_state = 5},
  [75] = {.lex_state = 47, .external_lex_state = 14},
  [76] = {.lex_state = 47},
  [77] = {.lex_state = 47},
  [78] = {.lex_state = 47, .external_lex_state = 2},
  [79] = {.lex_state = 9},
  [80] = {.lex_state = 39},
  [81] = {.lex_state = 1, .external_lex_state = 3},
  [82] = {.lex_state = 51, .external_lex_state = 12},
  [83] = {.lex_state = 51},
  [84] = {.lex_state = 9},
  [85] = {.lex_state = 4, .external_lex_state = 11},
  [86] = {.lex_state = 16, .external_lex_state = 11},
  [87] = {.lex_state = 47},
  [88] = {.lex_state = 43, .external_lex_state = 15},
  [89] = {.lex_state = 40},
  [90] = {.lex_state = 1, .external_lex_state = 5},
  [91] = {.lex_state = 1, .external_lex_state = 5},
  [92] = {.lex_state = 9, .external_lex_state = 2},
  [93] = {.lex_state = 9, .external_lex_state = 16},
  [94] = {.lex_state = 9, .external_lex_state = 2},
  [95] = {.lex_state = 9, .external_lex_state = 17},
  [96] = {.lex_state = 9, .external_lex_state = 2},
  [97] = {.lex_state = 47},
  [98] = {.lex_state = 3, .external_lex_state = 5},
  [99] = {.lex_state = 3, .external_lex_state = 5},
  [100] = {.lex_state = 6, .external_lex_state = 4},
  [101] = {.lex_state = 9, .external_lex_state = 2},
  [102] = {.lex_state = 1, .external_lex_state = 5},
  [103] = {.lex_state = 47, .external_lex_state = 2},
  [104] = {.lex_state = 1, .external_lex_state = 3},
  [105] = {.lex_state = 47, .external_lex_state = 18},
  [106] = {.lex_state = 1, .external_lex_state = 5},
  [107] = {.lex_state = 1, .external_lex_state = 5},
  [108] = {.lex_state = 9},
  [109] = {.lex_state = 1, .external_lex_state = 3},
  [110] = {.lex_state = 47},
  [111] = {.lex_state = 1, .external_lex_state = 3},
  [112] = {.lex_state = 3, .external_lex_state = 5},
  [113] = {.lex_state = 5, .external_lex_state = 4},
  [114] = {.lex_state = 5, .external_lex_state = 5},
  [115] = {.lex_state = 1, .external_lex_state = 3},
  [116] = {.lex_state = 9},
  [117] = {.lex_state = 3, .external_lex_state = 5},
  [118] = {.lex_state = 35, .external_lex_state = 6},
  [119] = {.lex_state = 35, .external_lex_state = 19},
  [120] = {.lex_state = 3, .external_lex_state = 5},
  [121] = {.lex_state = 9, .external_lex_state = 2},
  [122] = {.lex_state = 47},
  [123] = {.lex_state = 41},
  [124] = {.lex_state = 4, .external_lex_state = 11},
  [125] = {.lex_state = 41},
  [126] = {.lex_state = 4, .external_lex_state = 11},
  [127] = {.lex_state = 42},
  [128] = {.lex_state = 40},
  [129] = {.lex_state = 36},
  [130] = {.lex_state = 40},
  [131] = {.lex_state = 36, .external_lex_state = 18},
  [132] = {.lex_state = 3, .external_lex_state = 5},
  [133] = {.lex_state = 45, .external_lex_state = 20},
  [134] = {.lex_state = 1, .external_lex_state = 3},
  [135] = {.lex_state = 45, .external_lex_state = 21},
  [136] = {.lex_state = 45, .external_lex_state = 13},
  [137] = {.lex_state = 45, .external_lex_state = 13},
  [138] = {.lex_state = 44, .external_lex_state = 13},
  [139] = {.lex_state = 52},
  [140] = {.lex_state = 44, .external_lex_state = 13},
  [141] = {.lex_state = 48, .external_lex_state = 13},
  [142] = {.lex_state = 1, .external_lex_state = 3},
  [143] = {.lex_state = 45, .external_lex_state = 21},
  [144] = {.lex_state = 45, .external_lex_state = 13},
  [145] = {.lex_state = 6, .external_lex_state = 9},
  [146] = {.lex_state = 47},
  [147] = {.lex_state = 6, .external_lex_state = 4},
  [148] = {.lex_state = 6, .external_lex_state = 4},
  [149] = {.lex_state = 52, .external_lex_state = 22},
  [150] = {.lex_state = 43, .external_lex_state = 22},
  [151] = {.lex_state = 52, .external_lex_state = 22},
  [152] = {.lex_state = 47, .external_lex_state = 8},
  [153] = {.lex_state = 47, .external_lex_state = 2},
  [154] = {.lex_state = 47, .external_lex_state = 2},
  [155] = {.lex_state = 1, .external_lex_state = 3},
  [156] = {.lex_state = 1, .external_lex_state = 3},
  [157] = {.lex_state = 51, .external_lex_state = 12},
  [158] = {.lex_state = 51},
  [159] = {.lex_state = 39},
  [160] = {.lex_state = 51},
  [161] = {.lex_state = 1, .external_lex_state = 3},
  [162] = {.lex_state = 47},
  [163] = {.lex_state = 47},
  [164] = {.lex_state = 16, .external_lex_state = 11},
  [165] = {.lex_state = 18, .external_lex_state = 11},
  [166] = {.lex_state = 9, .external_lex_state = 2},
  [167] = {.lex_state = 3, .external_lex_state = 5},
  [168] = {.lex_state = 3, .external_lex_state = 5},
  [169] = {.lex_state = 6, .external_lex_state = 4},
  [170] = {.lex_state = 4, .external_lex_state = 11},
  [171] = {.lex_state = 9, .external_lex_state = 23},
  [172] = {.lex_state = 4, .external_lex_state = 11},
  [173] = {.lex_state = 3, .external_lex_state = 5},
  [174] = {.lex_state = 3, .external_lex_state = 5},
  [175] = {.lex_state = 6, .external_lex_state = 4},
  [176] = {.lex_state = 3, .external_lex_state = 3},
  [177] = {.lex_state = 3, .external_lex_state = 5},
  [178] = {.lex_state = 3, .external_lex_state = 5},
  [179] = {.lex_state = 3, .external_lex_state = 5},
  [180] = {.lex_state = 9, .external_lex_state = 2},
  [181] = {.lex_state = 9, .external_lex_state = 16},
  [182] = {.lex_state = 1, .external_lex_state = 5},
  [183] = {.lex_state = 1, .external_lex_state = 3},
  [184] = {.lex_state = 1, .external_lex_state = 5},
  [185] = {.lex_state = 1, .external_lex_state = 5},
  [186] = {.lex_state = 1, .external_lex_state = 5},
  [187] = {.lex_state = 3, .external_lex_state = 5},
  [188] = {.lex_state = 7, .external_lex_state = 5},
  [189] = {.lex_state = 9},
  [190] = {.lex_state = 4, .external_lex_state = 11},
  [191] = {.lex_state = 3, .external_lex_state = 5},
  [192] = {.lex_state = 9, .external_lex_state = 2},
  [193] = {.lex_state = 9, .external_lex_state = 2},
  [194] = {.lex_state = 3, .external_lex_state = 5},
  [195] = {.lex_state = 6, .external_lex_state = 4},
  [196] = {.lex_state = 47},
  [197] = {.lex_state = 47},
  [198] = {.lex_state = 9, .external_lex_state = 2},
  [199] = {.lex_state = 4, .external_lex_state = 11},
  [200] = {.lex_state = 50},
  [201] = {.lex_state = 4, .external_lex_state = 11},
  [202] = {.lex_state = 50},
  [203] = {.lex_state = 40},
  [204] = {.lex_state = 40},
  [205] = {.lex_state = 40},
  [206] = {.lex_state = 1, .external_lex_state = 3},
  [207] = {.lex_state = 45, .external_lex_state = 13},
  [208] = {.lex_state = 45, .external_lex_state = 13},
  [209] = {.lex_state = 45, .external_lex_state = 13},
  [210] = {.lex_state = 45, .external_lex_state = 21},
  [211] = {.lex_state = 48, .external_lex_state = 13},
  [212] = {.lex_state = 1, .external_lex_state = 3},
  [213] = {.lex_state = 45, .external_lex_state = 21},
  [214] = {.lex_state = 45, .external_lex_state = 13},
  [215] = {.lex_state = 35, .external_lex_state = 20},
  [216] = {.lex_state = 42, .external_lex_state = 13},
  [217] = {.lex_state = 35, .external_lex_state = 13},
  [218] = {.lex_state = 1, .external_lex_state = 3},
  [219] = {.lex_state = 45, .external_lex_state = 13},
  [220] = {.lex_state = 45, .external_lex_state = 13},
  [221] = {.lex_state = 47, .external_lex_state = 12},
  [222] = {.lex_state = 6, .external_lex_state = 4},
  [223] = {.lex_state = 47},
  [224] = {.lex_state = 47},
  [225] = {.lex_state = 52, .external_lex_state = 12},
  [226] = {.lex_state = 49, .external_lex_state = 15},
  [227] = {.lex_state = 52, .external_lex_state = 12},
  [228] = {.lex_state = 52, .external_lex_state = 15},
  [229] = {.lex_state = 52, .external_lex_state = 15},
  [230] = {.lex_state = 51},
  [231] = {.lex_state = 1, .external_lex_state = 3},
  [232] = {.lex_state = 39},
  [233] = {.lex_state = 3, .external_lex_state = 5},
  [234] = {.lex_state = 22, .external_lex_state = 11},
  [235] = {.lex_state = 36},
  [236] = {.lex_state = 18, .external_lex_state = 11},
  [237] = {.lex_state = 16, .external_lex_state = 11},
  [238] = {.lex_state = 3, .external_lex_state = 5},
  [239] = {.lex_state = 9, .external_lex_state = 2},
  [240] = {.lex_state = 37},
  [241] = {.lex_state = 4, .external_lex_state = 11},
  [242] = {.lex_state = 9, .external_lex_state = 23},
  [243] = {.lex_state = 9, .external_lex_state = 2},
  [244] = {.lex_state = 4, .external_lex_state = 11},
  [245] = {.lex_state = 3, .external_lex_state = 5},
  [246] = {.lex_state = 35, .external_lex_state = 6},
  [247] = {.lex_state = 9, .external_lex_state = 2},
  [248] = {.lex_state = 47},
  [249] = {.lex_state = 9, .external_lex_state = 16},
  [250] = {.lex_state = 9, .external_lex_state = 2},
  [251] = {.lex_state = 3, .external_lex_state = 5},
  [252] = {.lex_state = 47},
  [253] = {.lex_state = 47},
  [254] = {.lex_state = 47},
  [255] = {.lex_state = 9, .external_lex_state = 2},
  [256] = {.lex_state = 50},
  [257] = {.lex_state = 9, .external_lex_state = 12},
  [258] = {.lex_state = 3, .external_lex_state = 5},
  [259] = {.lex_state = 47},
  [260] = {.lex_state = 41},
  [261] = {.lex_state = 47},
  [262] = {.lex_state = 9},
  [263] = {.lex_state = 50},
  [264] = {.lex_state = 3, .external_lex_state = 5},
  [265] = {.lex_state = 41},
  [266] = {.lex_state = 47},
  [267] = {.lex_state = 1, .external_lex_state = 3},
  [268] = {.lex_state = 45, .external_lex_state = 13},
  [269] = {.lex_state = 45, .external_lex_state = 13},
  [270] = {.lex_state = 35, .external_lex_state = 20},
  [271] = {.lex_state = 42, .external_lex_state = 13},
  [272] = {.lex_state = 35, .external_lex_state = 13},
  [273] = {.lex_state = 1, .external_lex_state = 3},
  [274] = {.lex_state = 45, .external_lex_state = 13},
  [275] = {.lex_state = 45, .external_lex_state = 13},
  [276] = {.lex_state = 1, .external_lex_state = 3},
  [277] = {.lex_state = 1, .external_lex_state = 3},
  [278] = {.lex_state = 45, .external_lex_state = 13},
  [279] = {.lex_state = 6, .external_lex_state = 4},
  [280] = {.lex_state = 47},
  [281] = {.lex_state = 52},
  [282] = {.lex_state = 52, .external_lex_state = 12},
  [283] = {.lex_state = 52},
  [284] = {.lex_state = 52, .external_lex_state = 12},
  [285] = {.lex_state = 47},
  [286] = {.lex_state = 53},
  [287] = {.lex_state = 43},
  [288] = {.lex_state = 36},
  [289] = {.lex_state = 18, .external_lex_state = 11},
  [290] = {.lex_state = 3, .external_lex_state = 5},
  [291] = {.lex_state = 4, .external_lex_state = 11},
  [292] = {.lex_state = 9, .external_lex_state = 23},
  [293] = {.lex_state = 9, .external_lex_state = 2},
  [294] = {.lex_state = 9, .external_lex_state = 2},
  [295] = {.lex_state = 4, .external_lex_state = 11},
  [296] = {.lex_state = 3, .external_lex_state = 5},
  [297] = {.lex_state = 47},
  [298] = {.lex_state = 3, .external_lex_state = 5},
  [299] = {.lex_state = 41},
  [300] = {.lex_state = 47},
  [301] = {.lex_state = 47},
  [302] = {.lex_state = 34, .external_lex_state = 2},
  [303] = {.lex_state = 9},
  [304] = {.lex_state = 34, .external_lex_state = 2},
  [305] = {.lex_state = 9},
  [306] = {.lex_state = 47},
  [307] = {.lex_state = 3, .external_lex_state = 5},
  [308] = {.lex_state = 41},
  [309] = {.lex_state = 47},
  [310] = {.lex_state = 1, .external_lex_state = 3},
  [311] = {.lex_state = 45, .external_lex_state = 13},
  [312] = {.lex_state = 1, .external_lex_state = 3},
  [313] = {.lex_state = 1, .external_lex_state = 3},
  [314] = {.lex_state = 45, .external_lex_state = 13},
  [315] = {.lex_state = 1, .external_lex_state = 3},
  [316] = {.lex_state = 52},
  [317] = {.lex_state = 52},
  [318] = {.lex_state = 3, .external_lex_state = 5},
  [319] = {.lex_state = 53},
  [320] = {.lex_state = 3, .external_lex_state = 5},
  [321] = {.lex_state = 53},
  [322] = {.lex_state = 43},
  [323] = {.lex_state = 36},
  [324] = {.lex_state = 9, .external_lex_state = 2},
  [325] = {.lex_state = 9, .external_lex_state = 2},
  [326] = {.lex_state = 3, .external_lex_state = 5},
  [327] = {.lex_state = 3, .external_lex_state = 5},
  [328] = {.lex_state = 41},
  [329] = {.lex_state = 9, .external_lex_state = 12},
  [330] = {.lex_state = 47},
  [331] = {.lex_state = 9},
  [332] = {.lex_state = 50},
  [333] = {.lex_state = 41},
  [334] = {.lex_state = 34, .external_lex_state = 2},
  [335] = {.lex_state = 9},
  [336] = {.lex_state = 50},
  [337] = {.lex_state = 41},
  [338] = {.lex_state = 34, .external_lex_state = 2},
  [339] = {.lex_state = 9, .external_lex_state = 12},
  [340] = {.lex_state = 47},
  [341] = {.lex_state = 9},
  [342] = {.lex_state = 3, .external_lex_state = 5},
  [343] = {.lex_state = 41},
  [344] = {.lex_state = 1, .external_lex_state = 3},
  [345] = {.lex_state = 1, .external_lex_state = 3},
  [346] = {.lex_state = 3, .external_lex_state = 5},
  [347] = {.lex_state = 53},
  [348] = {.lex_state = 53},
  [349] = {.lex_state = 43},
  [350] = {.lex_state = 3, .external_lex_state = 5},
  [351] = {.lex_state = 50},
  [352] = {.lex_state = 41},
  [353] = {.lex_state = 50},
  [354] = {.lex_state = 41},
  [355] = {.lex_state = 9, .external_lex_state = 2},
  [356] = {.lex_state = 9},
  [357] = {.lex_state = 9, .external_lex_state = 2},
  [358] = {.lex_state = 9},
  [359] = {.lex_state = 3, .external_lex_state = 5},
  [360] = {.lex_state = 3, .external_lex_state = 5},
  [361] = {.lex_state = 53},
  [362] = {.lex_state = 53},
  [363] = {.lex_state = 50},
  [364] = {.lex_state = 50},
  [365] = {.lex_state = 47},
  [366] = {.lex_state = 9},
  [367] = {.lex_state = 9, .external_lex_state = 2},
  [368] = {.lex_state = 47},
  [369] = {.lex_state = 9},
  [370] = {.lex_state = 9, .external_lex_state = 2},
  [371] = {.lex_state = 3, .external_lex_state = 5},
  [372] = {.lex_state = 53},
  [373] = {.lex_state = 47},
  [374] = {.lex_state = 9},
  [375] = {.lex_state = 47},
  [376] = {.lex_state = 9},
  [377] = {.lex_state = 3, .external_lex_state = 5},
  [378] = {.lex_state = 47},
  [379] = {.lex_state = 47},
  [380] = {.lex_state = 1, .external_lex_state = 3},
  [381] = {.lex_state = 5, .external_lex_state = 4},
  [382] = {.lex_state = 5, .external_lex_state = 5},
  [383] = {.lex_state = 1, .external_lex_state = 3},
  [384] = {.lex_state = 1, .external_lex_state = 3},
  [385] = {.lex_state = 46, .external_lex_state = 2},
  [386] = {.lex_state = 1, .external_lex_state = 5},
  [387] = {.lex_state = 3, .external_lex_state = 5},
  [388] = {.lex_state = 6, .external_lex_state = 4},
  [389] = {.lex_state = 1, .external_lex_state = 5},
  [390] = {.lex_state = 9, .external_lex_state = 2},
  [391] = {.lex_state = 47, .external_lex_state = 2},
  [392] = {.lex_state = 1, .external_lex_state = 5},
  [393] = {.lex_state = 1, .external_lex_state = 3},
  [394] = {.lex_state = 3, .external_lex_state = 3},
  [395] = {.lex_state = 3, .external_lex_state = 5},
  [396] = {.lex_state = 3, .external_lex_state = 5},
  [397] = {.lex_state = 5, .external_lex_state = 9},
  [398] = {.lex_state = 5, .external_lex_state = 4},
  [399] = {.lex_state = 5, .external_lex_state = 4},
  [400] = {.lex_state = 5, .external_lex_state = 3},
  [401] = {.lex_state = 5, .external_lex_state = 5},
  [402] = {.lex_state = 5, .external_lex_state = 5},
  [403] = {.lex_state = 1, .external_lex_state = 3},
  [404] = {.lex_state = 1, .external_lex_state = 3},
  [405] = {.lex_state = 1, .external_lex_state = 3},
  [406] = {.lex_state = 3, .external_lex_state = 5},
  [407] = {.lex_state = 43, .external_lex_state = 22},
  [408] = {.lex_state = 36},
  [409] = {.lex_state = 43, .external_lex_state = 15},
  [410] = {.lex_state = 3, .external_lex_state = 5},
  [411] = {.lex_state = 1, .external_lex_state = 3},
  [412] = {.lex_state = 1, .external_lex_state = 5},
  [413] = {.lex_state = 1, .external_lex_state = 5},
  [414] = {.lex_state = 9, .external_lex_state = 2},
  [415] = {.lex_state = 9, .external_lex_state = 16},
  [416] = {.lex_state = 9, .external_lex_state = 2},
  [417] = {.lex_state = 9, .external_lex_state = 2},
  [418] = {.lex_state = 3, .external_lex_state = 5},
  [419] = {.lex_state = 3, .external_lex_state = 5},
  [420] = {.lex_state = 6, .external_lex_state = 4},
  [421] = {.lex_state = 35, .external_lex_state = 6},
  [422] = {.lex_state = 1, .external_lex_state = 5},
  [423] = {.lex_state = 1, .external_lex_state = 3},
  [424] = {.lex_state = 47, .external_lex_state = 18},
  [425] = {.lex_state = 1, .external_lex_state = 5},
  [426] = {.lex_state = 1, .external_lex_state = 5},
  [427] = {.lex_state = 1, .external_lex_state = 3},
  [428] = {.lex_state = 47},
  [429] = {.lex_state = 1, .external_lex_state = 3},
  [430] = {.lex_state = 3, .external_lex_state = 5},
  [431] = {.lex_state = 5, .external_lex_state = 4},
  [432] = {.lex_state = 5, .external_lex_state = 5},
  [433] = {.lex_state = 1, .external_lex_state = 3},
  [434] = {.lex_state = 3, .external_lex_state = 5},
  [435] = {.lex_state = 9, .external_lex_state = 2},
  [436] = {.lex_state = 9, .external_lex_state = 16},
  [437] = {.lex_state = 3, .external_lex_state = 5},
  [438] = {.lex_state = 43, .external_lex_state = 15},
  [439] = {.lex_state = 36},
  [440] = {.lex_state = 43, .external_lex_state = 15},
  [441] = {.lex_state = 36, .external_lex_state = 18},
  [442] = {.lex_state = 3, .external_lex_state = 5},
  [443] = {.lex_state = 1, .external_lex_state = 3},
  [444] = {.lex_state = 1, .external_lex_state = 3},
  [445] = {.lex_state = 6, .external_lex_state = 9},
  [446] = {.lex_state = 6, .external_lex_state = 4},
  [447] = {.lex_state = 6, .external_lex_state = 4},
  [448] = {.lex_state = 3, .external_lex_state = 3},
  [449] = {.lex_state = 3, .external_lex_state = 5},
  [450] = {.lex_state = 3, .external_lex_state = 5},
  [451] = {.lex_state = 1, .external_lex_state = 3},
  [452] = {.lex_state = 1, .external_lex_state = 3},
  [453] = {.lex_state = 1, .external_lex_state = 3},
  [454] = {.lex_state = 3, .external_lex_state = 5},
  [455] = {.lex_state = 3, .external_lex_state = 5},
  [456] = {.lex_state = 6, .external_lex_state = 4},
  [457] = {.lex_state = 4, .external_lex_state = 11},
  [458] = {.lex_state = 4, .external_lex_state = 11},
  [459] = {.lex_state = 3, .external_lex_state = 5},
  [460] = {.lex_state = 3, .external_lex_state = 5},
  [461] = {.lex_state = 6, .external_lex_state = 4},
  [462] = {.lex_state = 3, .external_lex_state = 3},
  [463] = {.lex_state = 3, .external_lex_state = 5},
  [464] = {.lex_state = 3, .external_lex_state = 5},
  [465] = {.lex_state = 3, .external_lex_state = 5},
  [466] = {.lex_state = 9, .external_lex_state = 2},
  [467] = {.lex_state = 9, .external_lex_state = 16},
  [468] = {.lex_state = 1, .external_lex_state = 5},
  [469] = {.lex_state = 1, .external_lex_state = 3},
  [470] = {.lex_state = 1, .external_lex_state = 5},
  [471] = {.lex_state = 1, .external_lex_state = 5},
  [472] = {.lex_state = 1, .external_lex_state = 5},
  [473] = {.lex_state = 3, .external_lex_state = 5},
  [474] = {.lex_state = 7, .external_lex_state = 5},
  [475] = {.lex_state = 3, .external_lex_state = 5},
  [476] = {.lex_state = 43, .external_lex_state = 15},
  [477] = {.lex_state = 43, .external_lex_state = 15},
  [478] = {.lex_state = 43, .external_lex_state = 15},
  [479] = {.lex_state = 1, .external_lex_state = 3},
  [480] = {.lex_state = 1, .external_lex_state = 3},
  [481] = {.lex_state = 1, .external_lex_state = 3},
  [482] = {.lex_state = 22, .external_lex_state = 10},
  [483] = {.lex_state = 6, .external_lex_state = 4},
  [484] = {.lex_state = 22, .external_lex_state = 11},
  [485] = {.lex_state = 44, .external_lex_state = 20},
  [486] = {.lex_state = 44, .external_lex_state = 20},
  [487] = {.lex_state = 1, .external_lex_state = 3},
  [488] = {.lex_state = 3, .external_lex_state = 5},
  [489] = {.lex_state = 3, .external_lex_state = 5},
  [490] = {.lex_state = 4, .external_lex_state = 11},
  [491] = {.lex_state = 9, .external_lex_state = 2},
  [492] = {.lex_state = 4, .external_lex_state = 11},
  [493] = {.lex_state = 3, .external_lex_state = 5},
  [494] = {.lex_state = 9, .external_lex_state = 2},
  [495] = {.lex_state = 3, .external_lex_state = 5},
  [496] = {.lex_state = 3, .external_lex_state = 5},
  [497] = {.lex_state = 3, .external_lex_state = 5},
  [498] = {.lex_state = 1, .external_lex_state = 3},
  [499] = {.lex_state = 1, .external_lex_state = 3},
  [500] = {.lex_state = 1, .external_lex_state = 3},
  [501] = {.lex_state = 1, .external_lex_state = 3},
  [502] = {.lex_state = 6, .external_lex_state = 4},
  [503] = {.lex_state = 22, .external_lex_state = 11},
  [504] = {.lex_state = 44, .external_lex_state = 13},
  [505] = {.lex_state = 44, .external_lex_state = 20},
  [506] = {.lex_state = 44, .external_lex_state = 13},
  [507] = {.lex_state = 44, .external_lex_state = 20},
  [508] = {.lex_state = 3, .external_lex_state = 5},
  [509] = {.lex_state = 4, .external_lex_state = 11},
  [510] = {.lex_state = 9, .external_lex_state = 2},
  [511] = {.lex_state = 3, .external_lex_state = 5},
  [512] = {.lex_state = 3, .external_lex_state = 5},
  [513] = {.lex_state = 3, .external_lex_state = 5},
  [514] = {.lex_state = 1, .external_lex_state = 3},
  [515] = {.lex_state = 1, .external_lex_state = 3},
  [516] = {.lex_state = 1, .external_lex_state = 3},
  [517] = {.lex_state = 1, .external_lex_state = 3},
  [518] = {.lex_state = 44, .external_lex_state = 13},
  [519] = {.lex_state = 44, .external_lex_state = 13},
  [520] = {.lex_state = 3, .external_lex_state = 5},
  [521] = {.lex_state = 3, .external_lex_state = 5},
  [522] = {.lex_state = 3, .external_lex_state = 5},
  [523] = {.lex_state = 3, .external_lex_state = 5},
  [524] = {.lex_state = 3, .external_lex_state = 5},
  [525] = {.lex_state = 1, .external_lex_state = 3},
  [526] = {.lex_state = 1, .external_lex_state = 3},
  [527] = {.lex_state = 3, .external_lex_state = 5},
  [528] = {.lex_state = 3, .external_lex_state = 5},
  [529] = {.lex_state = 3, .external_lex_state = 5},
  [530] = {.lex_state = 3, .external_lex_state = 5},
  [531] = {.lex_state = 3, .external_lex_state = 5},
  [532] = {.lex_state = 3, .external_lex_state = 5},
  [533] = {.lex_state = 23, .external_lex_state = 3},
  [534] = {.lex_state = 5, .external_lex_state = 4},
  [535] = {.lex_state = 5, .external_lex_state = 5},
  [536] = {.lex_state = 47, .external_lex_state = 8},
  [537] = {.lex_state = 23, .external_lex_state = 3},
  [538] = {.lex_state = 46, .external_lex_state = 2},
  [539] = {.lex_state = 23, .external_lex_state = 5},
  [540] = {.lex_state = 3, .external_lex_state = 5},
  [541] = {.lex_state = 6, .external_lex_state = 4},
  [542] = {.lex_state = 23, .external_lex_state = 5},
  [543] = {.lex_state = 9, .external_lex_state = 2},
  [544] = {.lex_state = 47, .external_lex_state = 2},
  [545] = {.lex_state = 1, .external_lex_state = 5},
  [546] = {.lex_state = 47, .external_lex_state = 8},
  [547] = {.lex_state = 3, .external_lex_state = 3},
  [548] = {.lex_state = 3, .external_lex_state = 5},
  [549] = {.lex_state = 3, .external_lex_state = 5},
  [550] = {.lex_state = 24, .external_lex_state = 9},
  [551] = {.lex_state = 24, .external_lex_state = 4},
  [552] = {.lex_state = 5, .external_lex_state = 4},
  [553] = {.lex_state = 24, .external_lex_state = 3},
  [554] = {.lex_state = 24, .external_lex_state = 5},
  [555] = {.lex_state = 5, .external_lex_state = 5},
  [556] = {.lex_state = 47, .external_lex_state = 8},
  [557] = {.lex_state = 47, .external_lex_state = 8},
  [558] = {.lex_state = 47, .external_lex_state = 8},
  [559] = {.lex_state = 18, .external_lex_state = 10},
  [560] = {.lex_state = 36},
  [561] = {.lex_state = 18, .external_lex_state = 11},
  [562] = {.lex_state = 47, .external_lex_state = 8},
  [563] = {.lex_state = 47, .external_lex_state = 2},
  [564] = {.lex_state = 47, .external_lex_state = 2},
  [565] = {.lex_state = 9, .external_lex_state = 2},
  [566] = {.lex_state = 9, .external_lex_state = 16},
  [567] = {.lex_state = 9, .external_lex_state = 2},
  [568] = {.lex_state = 9, .external_lex_state = 2},
  [569] = {.lex_state = 3, .external_lex_state = 5},
  [570] = {.lex_state = 6, .external_lex_state = 4},
  [571] = {.lex_state = 1, .external_lex_state = 5},
  [572] = {.lex_state = 23, .external_lex_state = 3},
  [573] = {.lex_state = 47, .external_lex_state = 18},
  [574] = {.lex_state = 23, .external_lex_state = 5},
  [575] = {.lex_state = 1, .external_lex_state = 5},
  [576] = {.lex_state = 47, .external_lex_state = 8},
  [577] = {.lex_state = 47},
  [578] = {.lex_state = 47, .external_lex_state = 8},
  [579] = {.lex_state = 24, .external_lex_state = 4},
  [580] = {.lex_state = 24, .external_lex_state = 5},
  [581] = {.lex_state = 47, .external_lex_state = 8},
  [582] = {.lex_state = 18, .external_lex_state = 11},
  [583] = {.lex_state = 36},
  [584] = {.lex_state = 18, .external_lex_state = 11},
  [585] = {.lex_state = 36, .external_lex_state = 18},
  [586] = {.lex_state = 47, .external_lex_state = 8},
  [587] = {.lex_state = 47, .external_lex_state = 8},
  [588] = {.lex_state = 5, .external_lex_state = 9},
  [589] = {.lex_state = 5, .external_lex_state = 4},
  [590] = {.lex_state = 5, .external_lex_state = 4},
  [591] = {.lex_state = 3, .external_lex_state = 3},
  [592] = {.lex_state = 3, .external_lex_state = 5},
  [593] = {.lex_state = 3, .external_lex_state = 5},
  [594] = {.lex_state = 47, .external_lex_state = 8},
  [595] = {.lex_state = 47, .external_lex_state = 8},
  [596] = {.lex_state = 47, .external_lex_state = 8},
  [597] = {.lex_state = 6, .external_lex_state = 4},
  [598] = {.lex_state = 4, .external_lex_state = 11},
  [599] = {.lex_state = 3, .external_lex_state = 5},
  [600] = {.lex_state = 6, .external_lex_state = 4},
  [601] = {.lex_state = 9, .external_lex_state = 2},
  [602] = {.lex_state = 9, .external_lex_state = 16},
  [603] = {.lex_state = 1, .external_lex_state = 5},
  [604] = {.lex_state = 23, .external_lex_state = 3},
  [605] = {.lex_state = 23, .external_lex_state = 5},
  [606] = {.lex_state = 23, .external_lex_state = 5},
  [607] = {.lex_state = 23, .external_lex_state = 5},
  [608] = {.lex_state = 32, .external_lex_state = 2},
  [609] = {.lex_state = 18, .external_lex_state = 11},
  [610] = {.lex_state = 18, .external_lex_state = 11},
  [611] = {.lex_state = 18, .external_lex_state = 11},
  [612] = {.lex_state = 47, .external_lex_state = 8},
  [613] = {.lex_state = 47, .external_lex_state = 8},
  [614] = {.lex_state = 47, .external_lex_state = 8},
  [615] = {.lex_state = 5, .external_lex_state = 4},
  [616] = {.lex_state = 47, .external_lex_state = 8},
  [617] = {.lex_state = 9, .external_lex_state = 2},
  [618] = {.lex_state = 4, .external_lex_state = 11},
  [619] = {.lex_state = 47, .external_lex_state = 8},
  [620] = {.lex_state = 47, .external_lex_state = 8},
  [621] = {.lex_state = 47, .external_lex_state = 8},
  [622] = {.lex_state = 47, .external_lex_state = 8},
  [623] = {.lex_state = 5, .external_lex_state = 4},
  [624] = {.lex_state = 9, .external_lex_state = 2},
  [625] = {.lex_state = 47, .external_lex_state = 8},
  [626] = {.lex_state = 47, .external_lex_state = 8},
  [627] = {.lex_state = 47, .external_lex_state = 8},
  [628] = {.lex_state = 47, .external_lex_state = 8},
  [629] = {.lex_state = 47, .external_lex_state = 8},
  [630] = {.lex_state = 47, .external_lex_state = 8},
  [631] = {.lex_state = 24, .external_lex_state = 4},
  [632] = {.lex_state = 24, .external_lex_state = 5},
  [633] = {.lex_state = 5, .external_lex_state = 9},
  [634] = {.lex_state = 3, .external_lex_state = 5},
  [635] = {.lex_state = 25, .external_lex_state = 4},
  [636] = {.lex_state = 9, .external_lex_state = 2},
  [637] = {.lex_state = 23, .external_lex_state = 5},
  [638] = {.lex_state = 5, .external_lex_state = 9},
  [639] = {.lex_state = 24, .external_lex_state = 4},
  [640] = {.lex_state = 24, .external_lex_state = 5},
  [641] = {.lex_state = 5, .external_lex_state = 9},
  [642] = {.lex_state = 5, .external_lex_state = 9},
  [643] = {.lex_state = 5, .external_lex_state = 9},
  [644] = {.lex_state = 5, .external_lex_state = 9},
  [645] = {.lex_state = 5, .external_lex_state = 4},
  [646] = {.lex_state = 5, .external_lex_state = 4},
  [647] = {.lex_state = 9, .external_lex_state = 2},
  [648] = {.lex_state = 34, .external_lex_state = 16},
  [649] = {.lex_state = 34, .external_lex_state = 2},
  [650] = {.lex_state = 9, .external_lex_state = 2},
  [651] = {.lex_state = 3, .external_lex_state = 5},
  [652] = {.lex_state = 25, .external_lex_state = 4},
  [653] = {.lex_state = 23, .external_lex_state = 5},
  [654] = {.lex_state = 23, .external_lex_state = 5},
  [655] = {.lex_state = 5, .external_lex_state = 9},
  [656] = {.lex_state = 47},
  [657] = {.lex_state = 5, .external_lex_state = 9},
  [658] = {.lex_state = 5, .external_lex_state = 9},
  [659] = {.lex_state = 5, .external_lex_state = 9},
  [660] = {.lex_state = 5, .external_lex_state = 9},
  [661] = {.lex_state = 47, .external_lex_state = 8},
  [662] = {.lex_state = 47, .external_lex_state = 2},
  [663] = {.lex_state = 47, .external_lex_state = 2},
  [664] = {.lex_state = 5, .external_lex_state = 9},
  [665] = {.lex_state = 5, .external_lex_state = 9},
  [666] = {.lex_state = 5, .external_lex_state = 9},
  [667] = {.lex_state = 25, .external_lex_state = 4},
  [668] = {.lex_state = 4, .external_lex_state = 11},
  [669] = {.lex_state = 3, .external_lex_state = 5},
  [670] = {.lex_state = 25, .external_lex_state = 4},
  [671] = {.lex_state = 34, .external_lex_state = 2},
  [672] = {.lex_state = 34, .external_lex_state = 16},
  [673] = {.lex_state = 23, .external_lex_state = 5},
  [674] = {.lex_state = 8, .external_lex_state = 4},
  [675] = {.lex_state = 5, .external_lex_state = 9},
  [676] = {.lex_state = 5, .external_lex_state = 9},
  [677] = {.lex_state = 5, .external_lex_state = 9},
  [678] = {.lex_state = 47, .external_lex_state = 2},
  [679] = {.lex_state = 5, .external_lex_state = 9},
  [680] = {.lex_state = 34, .external_lex_state = 2},
  [681] = {.lex_state = 4, .external_lex_state = 11},
  [682] = {.lex_state = 5, .external_lex_state = 9},
  [683] = {.lex_state = 5, .external_lex_state = 9},
  [684] = {.lex_state = 5, .external_lex_state = 9},
  [685] = {.lex_state = 5, .external_lex_state = 9},
  [686] = {.lex_state = 47, .external_lex_state = 2},
  [687] = {.lex_state = 34, .external_lex_state = 2},
  [688] = {.lex_state = 5, .external_lex_state = 9},
  [689] = {.lex_state = 5, .external_lex_state = 9},
  [690] = {.lex_state = 5, .external_lex_state = 9},
  [691] = {.lex_state = 5, .external_lex_state = 9},
  [692] = {.lex_state = 5, .external_lex_state = 9},
  [693] = {.lex_state = 5, .external_lex_state = 9},
  [694] = {.lex_state = 5, .external_lex_state = 3},
  [695] = {.lex_state = 6, .external_lex_state = 4},
  [696] = {.lex_state = 5, .external_lex_state = 3},
  [697] = {.lex_state = 5, .external_lex_state = 3},
  [698] = {.lex_state = 5, .external_lex_state = 3},
  [699] = {.lex_state = 5, .external_lex_state = 3},
  [700] = {.lex_state = 5, .external_lex_state = 3},
  [701] = {.lex_state = 5, .external_lex_state = 5},
  [702] = {.lex_state = 5, .external_lex_state = 5},
  [703] = {.lex_state = 3, .external_lex_state = 5},
  [704] = {.lex_state = 6, .external_lex_state = 4},
  [705] = {.lex_state = 5, .external_lex_state = 3},
  [706] = {.lex_state = 47},
  [707] = {.lex_state = 5, .external_lex_state = 3},
  [708] = {.lex_state = 5, .external_lex_state = 3},
  [709] = {.lex_state = 5, .external_lex_state = 3},
  [710] = {.lex_state = 5, .external_lex_state = 3},
  [711] = {.lex_state = 5, .external_lex_state = 9},
  [712] = {.lex_state = 5, .external_lex_state = 4},
  [713] = {.lex_state = 5, .external_lex_state = 4},
  [714] = {.lex_state = 5, .external_lex_state = 3},
  [715] = {.lex_state = 5, .external_lex_state = 3},
  [716] = {.lex_state = 5, .external_lex_state = 3},
  [717] = {.lex_state = 8, .external_lex_state = 5},
  [718] = {.lex_state = 5, .external_lex_state = 3},
  [719] = {.lex_state = 5, .external_lex_state = 3},
  [720] = {.lex_state = 5, .external_lex_state = 3},
  [721] = {.lex_state = 5, .external_lex_state = 4},
  [722] = {.lex_state = 5, .external_lex_state = 3},
  [723] = {.lex_state = 5, .external_lex_state = 3},
  [724] = {.lex_state = 5, .external_lex_state = 3},
  [725] = {.lex_state = 5, .external_lex_state = 3},
  [726] = {.lex_state = 5, .external_lex_state = 3},
  [727] = {.lex_state = 5, .external_lex_state = 4},
  [728] = {.lex_state = 5, .external_lex_state = 3},
  [729] = {.lex_state = 5, .external_lex_state = 3},
  [730] = {.lex_state = 5, .external_lex_state = 3},
  [731] = {.lex_state = 5, .external_lex_state = 3},
  [732] = {.lex_state = 5, .external_lex_state = 3},
  [733] = {.lex_state = 5, .external_lex_state = 3},
  [734] = {.lex_state = 4, .external_lex_state = 10},
  [735] = {.lex_state = 4, .external_lex_state = 10},
  [736] = {.lex_state = 4, .external_lex_state = 10},
  [737] = {.lex_state = 4, .external_lex_state = 10},
  [738] = {.lex_state = 4, .external_lex_state = 10},
  [739] = {.lex_state = 4, .external_lex_state = 10},
  [740] = {.lex_state = 4, .external_lex_state = 11},
  [741] = {.lex_state = 4, .external_lex_state = 11},
  [742] = {.lex_state = 4, .external_lex_state = 10},
  [743] = {.lex_state = 47},
  [744] = {.lex_state = 4, .external_lex_state = 10},
  [745] = {.lex_state = 4, .external_lex_state = 10},
  [746] = {.lex_state = 4, .external_lex_state = 10},
  [747] = {.lex_state = 4, .external_lex_state = 10},
  [748] = {.lex_state = 25, .external_lex_state = 9},
  [749] = {.lex_state = 25, .external_lex_state = 4},
  [750] = {.lex_state = 25, .external_lex_state = 4},
  [751] = {.lex_state = 4, .external_lex_state = 10},
  [752] = {.lex_state = 4, .external_lex_state = 10},
  [753] = {.lex_state = 4, .external_lex_state = 10},
  [754] = {.lex_state = 15, .external_lex_state = 11},
  [755] = {.lex_state = 4, .external_lex_state = 10},
  [756] = {.lex_state = 4, .external_lex_state = 10},
  [757] = {.lex_state = 4, .external_lex_state = 10},
  [758] = {.lex_state = 25, .external_lex_state = 4},
  [759] = {.lex_state = 4, .external_lex_state = 10},
  [760] = {.lex_state = 4, .external_lex_state = 10},
  [761] = {.lex_state = 4, .external_lex_state = 10},
  [762] = {.lex_state = 4, .external_lex_state = 10},
  [763] = {.lex_state = 4, .external_lex_state = 10},
  [764] = {.lex_state = 25, .external_lex_state = 4},
  [765] = {.lex_state = 4, .external_lex_state = 10},
  [766] = {.lex_state = 4, .external_lex_state = 10},
  [767] = {.lex_state = 4, .external_lex_state = 10},
  [768] = {.lex_state = 4, .external_lex_state = 10},
  [769] = {.lex_state = 4, .external_lex_state = 10},
  [770] = {.lex_state = 4, .external_lex_state = 10},
  [771] = {.lex_state = 41, .external_lex_state = 12},
  [772] = {.lex_state = 40, .external_lex_state = 12},
  [773] = {.lex_state = 40, .external_lex_state = 12},
  [774] = {.lex_state = 40, .external_lex_state = 12},
  [775] = {.lex_state = 40, .external_lex_state = 12},
  [776] = {.lex_state = 40, .external_lex_state = 12},
  [777] = {.lex_state = 41},
  [778] = {.lex_state = 41},
  [779] = {.lex_state = 40, .external_lex_state = 12},
  [780] = {.lex_state = 47},
  [781] = {.lex_state = 40, .external_lex_state = 12},
  [782] = {.lex_state = 40, .external_lex_state = 12},
  [783] = {.lex_state = 40, .external_lex_state = 12},
  [784] = {.lex_state = 40, .external_lex_state = 12},
  [785] = {.lex_state = 24, .external_lex_state = 9},
  [786] = {.lex_state = 24, .external_lex_state = 4},
  [787] = {.lex_state = 24, .external_lex_state = 4},
  [788] = {.lex_state = 40, .external_lex_state = 12},
  [789] = {.lex_state = 40, .external_lex_state = 12},
  [790] = {.lex_state = 40, .external_lex_state = 12},
  [791] = {.lex_state = 37},
  [792] = {.lex_state = 40, .external_lex_state = 12},
  [793] = {.lex_state = 40, .external_lex_state = 12},
  [794] = {.lex_state = 40, .external_lex_state = 12},
  [795] = {.lex_state = 24, .external_lex_state = 4},
  [796] = {.lex_state = 40, .external_lex_state = 12},
  [797] = {.lex_state = 40, .external_lex_state = 12},
  [798] = {.lex_state = 40, .external_lex_state = 12},
  [799] = {.lex_state = 40, .external_lex_state = 12},
  [800] = {.lex_state = 40, .external_lex_state = 12},
  [801] = {.lex_state = 24, .external_lex_state = 4},
  [802] = {.lex_state = 40, .external_lex_state = 12},
  [803] = {.lex_state = 40, .external_lex_state = 12},
  [804] = {.lex_state = 40, .external_lex_state = 12},
  [805] = {.lex_state = 40, .external_lex_state = 12},
  [806] = {.lex_state = 40, .external_lex_state = 12},
  [807] = {.lex_state = 40, .external_lex_state = 12},
  [808] = {.lex_state = 43, .external_lex_state = 22},
  [809] = {.lex_state = 43, .external_lex_state = 22},
  [810] = {.lex_state = 51, .external_lex_state = 12},
  [811] = {.lex_state = 51, .external_lex_state = 12},
  [812] = {.lex_state = 43, .external_lex_state = 22},
  [813] = {.lex_state = 43, .external_lex_state = 22},
  [814] = {.lex_state = 43, .external_lex_state = 15},
  [815] = {.lex_state = 43, .external_lex_state = 15},
  [816] = {.lex_state = 43, .external_lex_state = 22},
  [817] = {.lex_state = 47},
  [818] = {.lex_state = 43, .external_lex_state = 22},
  [819] = {.lex_state = 43, .external_lex_state = 22},
  [820] = {.lex_state = 51, .external_lex_state = 12},
  [821] = {.lex_state = 51, .external_lex_state = 12},
  [822] = {.lex_state = 51, .external_lex_state = 12},
  [823] = {.lex_state = 43, .external_lex_state = 22},
  [824] = {.lex_state = 51, .external_lex_state = 12},
  [825] = {.lex_state = 38, .external_lex_state = 15},
  [826] = {.lex_state = 51, .external_lex_state = 12},
  [827] = {.lex_state = 51, .external_lex_state = 12},
  [828] = {.lex_state = 51, .external_lex_state = 12},
  [829] = {.lex_state = 43, .external_lex_state = 22},
  [830] = {.lex_state = 51, .external_lex_state = 12},
  [831] = {.lex_state = 51, .external_lex_state = 12},
  [832] = {.lex_state = 51, .external_lex_state = 12},
  [833] = {.lex_state = 51, .external_lex_state = 12},
  [834] = {.lex_state = 51, .external_lex_state = 12},
  [835] = {.lex_state = 51, .external_lex_state = 12},
  [836] = {.lex_state = 51, .external_lex_state = 12},
  [837] = {.lex_state = 51, .external_lex_state = 12},
  [838] = {.lex_state = 51, .external_lex_state = 12},
  [839] = {.lex_state = 51, .external_lex_state = 12},
  [840] = {.lex_state = 5, .external_lex_state = 9},
  [841] = {.lex_state = 5, .external_lex_state = 9},
  [842] = {.lex_state = 43, .external_lex_state = 22},
  [843] = {.lex_state = 43, .external_lex_state = 22},
  [844] = {.lex_state = 5, .external_lex_state = 9},
  [845] = {.lex_state = 5, .external_lex_state = 9},
  [846] = {.lex_state = 5, .external_lex_state = 4},
  [847] = {.lex_state = 5, .external_lex_state = 4},
  [848] = {.lex_state = 5, .external_lex_state = 9},
  [849] = {.lex_state = 47},
  [850] = {.lex_state = 5, .external_lex_state = 9},
  [851] = {.lex_state = 5, .external_lex_state = 9},
  [852] = {.lex_state = 43, .external_lex_state = 22},
  [853] = {.lex_state = 43, .external_lex_state = 22},
  [854] = {.lex_state = 43, .external_lex_state = 22},
  [855] = {.lex_state = 5, .external_lex_state = 9},
  [856] = {.lex_state = 43, .external_lex_state = 22},
  [857] = {.lex_state = 8, .external_lex_state = 4},
  [858] = {.lex_state = 43, .external_lex_state = 22},
  [859] = {.lex_state = 43, .external_lex_state = 22},
  [860] = {.lex_state = 43, .external_lex_state = 22},
  [861] = {.lex_state = 5, .external_lex_state = 9},
  [862] = {.lex_state = 43, .external_lex_state = 22},
  [863] = {.lex_state = 43, .external_lex_state = 22},
  [864] = {.lex_state = 43, .external_lex_state = 22},
  [865] = {.lex_state = 43, .external_lex_state = 22},
  [866] = {.lex_state = 43, .external_lex_state = 22},
  [867] = {.lex_state = 43, .external_lex_state = 22},
  [868] = {.lex_state = 43, .external_lex_state = 22},
  [869] = {.lex_state = 43, .external_lex_state = 22},
  [870] = {.lex_state = 43, .external_lex_state = 22},
  [871] = {.lex_state = 43, .external_lex_state = 22},
  [872] = {.lex_state = 5, .external_lex_state = 3},
  [873] = {.lex_state = 5, .external_lex_state = 3},
  [874] = {.lex_state = 5, .external_lex_state = 9},
  [875] = {.lex_state = 5, .external_lex_state = 9},
  [876] = {.lex_state = 5, .external_lex_state = 3},
  [877] = {.lex_state = 5, .external_lex_state = 3},
  [878] = {.lex_state = 5, .external_lex_state = 5},
  [879] = {.lex_state = 5, .external_lex_state = 5},
  [880] = {.lex_state = 5, .external_lex_state = 3},
  [881] = {.lex_state = 47},
  [882] = {.lex_state = 5, .external_lex_state = 3},
  [883] = {.lex_state = 5, .external_lex_state = 3},
  [884] = {.lex_state = 5, .external_lex_state = 9},
  [885] = {.lex_state = 5, .external_lex_state = 9},
  [886] = {.lex_state = 5, .external_lex_state = 9},
  [887] = {.lex_state = 5, .external_lex_state = 3},
  [888] = {.lex_state = 5, .external_lex_state = 9},
  [889] = {.lex_state = 8, .external_lex_state = 5},
  [890] = {.lex_state = 5, .external_lex_state = 9},
  [891] = {.lex_state = 5, .external_lex_state = 9},
  [892] = {.lex_state = 5, .external_lex_state = 9},
  [893] = {.lex_state = 5, .external_lex_state = 3},
  [894] = {.lex_state = 5, .external_lex_state = 9},
  [895] = {.lex_state = 5, .external_lex_state = 9},
  [896] = {.lex_state = 5, .external_lex_state = 9},
  [897] = {.lex_state = 5, .external_lex_state = 9},
  [898] = {.lex_state = 5, .external_lex_state = 9},
  [899] = {.lex_state = 5, .external_lex_state = 9},
  [900] = {.lex_state = 5, .external_lex_state = 9},
  [901] = {.lex_state = 5, .external_lex_state = 9},
  [902] = {.lex_state = 5, .external_lex_state = 9},
  [903] = {.lex_state = 5, .external_lex_state = 9},
  [904] = {.lex_state = 45, .external_lex_state = 20},
  [905] = {.lex_state = 45, .external_lex_state = 20},
  [906] = {.lex_state = 5, .external_lex_state = 3},
  [907] = {.lex_state = 5, .external_lex_state = 3},
  [908] = {.lex_state = 45, .external_lex_state = 20},
  [909] = {.lex_state = 45, .external_lex_state = 20},
  [910] = {.lex_state = 45, .external_lex_state = 13},
  [911] = {.lex_state = 45, .external_lex_state = 13},
  [912] = {.lex_state = 45, .external_lex_state = 20},
  [913] = {.lex_state = 47},
  [914] = {.lex_state = 45, .external_lex_state = 20},
  [915] = {.lex_state = 45, .external_lex_state = 20},
  [916] = {.lex_state = 5, .external_lex_state = 3},
  [917] = {.lex_state = 5, .external_lex_state = 3},
  [918] = {.lex_state = 5, .external_lex_state = 3},
  [919] = {.lex_state = 45, .external_lex_state = 20},
  [920] = {.lex_state = 5, .external_lex_state = 3},
  [921] = {.lex_state = 31, .external_lex_state = 13},
  [922] = {.lex_state = 5, .external_lex_state = 3},
  [923] = {.lex_state = 5, .external_lex_state = 3},
  [924] = {.lex_state = 5, .external_lex_state = 3},
  [925] = {.lex_state = 45, .external_lex_state = 20},
  [926] = {.lex_state = 5, .external_lex_state = 3},
  [927] = {.lex_state = 5, .external_lex_state = 3},
  [928] = {.lex_state = 5, .external_lex_state = 3},
  [929] = {.lex_state = 5, .external_lex_state = 3},
  [930] = {.lex_state = 5, .external_lex_state = 3},
  [931] = {.lex_state = 5, .external_lex_state = 3},
  [932] = {.lex_state = 5, .external_lex_state = 3},
  [933] = {.lex_state = 5, .external_lex_state = 3},
  [934] = {.lex_state = 5, .external_lex_state = 3},
  [935] = {.lex_state = 5, .external_lex_state = 3},
  [936] = {.lex_state = 6, .external_lex_state = 9},
  [937] = {.lex_state = 6, .external_lex_state = 9},
  [938] = {.lex_state = 45, .external_lex_state = 20},
  [939] = {.lex_state = 45, .external_lex_state = 20},
  [940] = {.lex_state = 6, .external_lex_state = 9},
  [941] = {.lex_state = 6, .external_lex_state = 9},
  [942] = {.lex_state = 6, .external_lex_state = 4},
  [943] = {.lex_state = 6, .external_lex_state = 4},
  [944] = {.lex_state = 6, .external_lex_state = 9},
  [945] = {.lex_state = 47},
  [946] = {.lex_state = 6, .external_lex_state = 9},
  [947] = {.lex_state = 6, .external_lex_state = 9},
  [948] = {.lex_state = 45, .external_lex_state = 20},
  [949] = {.lex_state = 45, .external_lex_state = 20},
  [950] = {.lex_state = 45, .external_lex_state = 20},
  [951] = {.lex_state = 6, .external_lex_state = 9},
  [952] = {.lex_state = 45, .external_lex_state = 20},
  [953] = {.lex_state = 8, .external_lex_state = 4},
  [954] = {.lex_state = 45, .external_lex_state = 20},
  [955] = {.lex_state = 45, .external_lex_state = 20},
  [956] = {.lex_state = 45, .external_lex_state = 20},
  [957] = {.lex_state = 6, .external_lex_state = 9},
  [958] = {.lex_state = 45, .external_lex_state = 20},
  [959] = {.lex_state = 45, .external_lex_state = 20},
  [960] = {.lex_state = 45, .external_lex_state = 20},
  [961] = {.lex_state = 45, .external_lex_state = 20},
  [962] = {.lex_state = 45, .external_lex_state = 20},
  [963] = {.lex_state = 45, .external_lex_state = 20},
  [964] = {.lex_state = 45, .external_lex_state = 20},
  [965] = {.lex_state = 45, .external_lex_state = 20},
  [966] = {.lex_state = 45, .external_lex_state = 20},
  [967] = {.lex_state = 45, .external_lex_state = 20},
  [968] = {.lex_state = 43, .external_lex_state = 22},
  [969] = {.lex_state = 18, .external_lex_state = 10},
  [970] = {.lex_state = 6, .external_lex_state = 9},
  [971] = {.lex_state = 6, .external_lex_state = 9},
  [972] = {.lex_state = 18, .external_lex_state = 10},
  [973] = {.lex_state = 18, .external_lex_state = 10},
  [974] = {.lex_state = 43, .external_lex_state = 22},
  [975] = {.lex_state = 43, .external_lex_state = 22},
  [976] = {.lex_state = 18, .external_lex_state = 10},
  [977] = {.lex_state = 47},
  [978] = {.lex_state = 18, .external_lex_state = 10},
  [979] = {.lex_state = 18, .external_lex_state = 10},
  [980] = {.lex_state = 6, .external_lex_state = 9},
  [981] = {.lex_state = 6, .external_lex_state = 9},
  [982] = {.lex_state = 6, .external_lex_state = 9},
  [983] = {.lex_state = 18, .external_lex_state = 10},
  [984] = {.lex_state = 6, .external_lex_state = 9},
  [985] = {.lex_state = 38, .external_lex_state = 22},
  [986] = {.lex_state = 6, .external_lex_state = 9},
  [987] = {.lex_state = 6, .external_lex_state = 9},
  [988] = {.lex_state = 6, .external_lex_state = 9},
  [989] = {.lex_state = 18, .external_lex_state = 10},
  [990] = {.lex_state = 6, .external_lex_state = 9},
  [991] = {.lex_state = 6, .external_lex_state = 9},
  [992] = {.lex_state = 6, .external_lex_state = 9},
  [993] = {.lex_state = 6, .external_lex_state = 9},
  [994] = {.lex_state = 6, .external_lex_state = 9},
  [995] = {.lex_state = 6, .external_lex_state = 9},
  [996] = {.lex_state = 6, .external_lex_state = 9},
  [997] = {.lex_state = 6, .external_lex_state = 9},
  [998] = {.lex_state = 6, .external_lex_state = 9},
  [999] = {.lex_state = 6, .external_lex_state = 9},
  [1000] = {.lex_state = 18, .external_lex_state = 10},
  [1001] = {.lex_state = 3, .external_lex_state = 3},
  [1002] = {.lex_state = 18, .external_lex_state = 10},
  [1003] = {.lex_state = 18, .external_lex_state = 10},
  [1004] = {.lex_state = 3, .external_lex_state = 3},
  [1005] = {.lex_state = 3, .external_lex_state = 3},
  [1006] = {.lex_state = 18, .external_lex_state = 11},
  [1007] = {.lex_state = 18, .external_lex_state = 11},
  [1008] = {.lex_state = 3, .external_lex_state = 3},
  [1009] = {.lex_state = 47},
  [1010] = {.lex_state = 3, .external_lex_state = 3},
  [1011] = {.lex_state = 3, .external_lex_state = 3},
  [1012] = {.lex_state = 18, .external_lex_state = 10},
  [1013] = {.lex_state = 18, .external_lex_state = 10},
  [1014] = {.lex_state = 18, .external_lex_state = 10},
  [1015] = {.lex_state = 3, .external_lex_state = 3},
  [1016] = {.lex_state = 18, .external_lex_state = 10},
  [1017] = {.lex_state = 17, .external_lex_state = 11},
  [1018] = {.lex_state = 18, .external_lex_state = 10},
  [1019] = {.lex_state = 18, .external_lex_state = 10},
  [1020] = {.lex_state = 18, .external_lex_state = 10},
  [1021] = {.lex_state = 3, .external_lex_state = 3},
  [1022] = {.lex_state = 18, .external_lex_state = 10},
  [1023] = {.lex_state = 18, .external_lex_state = 10},
  [1024] = {.lex_state = 18, .external_lex_state = 10},
  [1025] = {.lex_state = 18, .external_lex_state = 10},
  [1026] = {.lex_state = 18, .external_lex_state = 10},
  [1027] = {.lex_state = 18, .external_lex_state = 10},
  [1028] = {.lex_state = 18, .external_lex_state = 10},
  [1029] = {.lex_state = 18, .external_lex_state = 10},
  [1030] = {.lex_state = 18, .external_lex_state = 10},
  [1031] = {.lex_state = 18, .external_lex_state = 10},
  [1032] = {.lex_state = 3, .external_lex_state = 3},
  [1033] = {.lex_state = 6, .external_lex_state = 9},
  [1034] = {.lex_state = 3, .external_lex_state = 3},
  [1035] = {.lex_state = 3, .external_lex_state = 3},
  [1036] = {.lex_state = 6, .external_lex_state = 9},
  [1037] = {.lex_state = 6, .external_lex_state = 9},
  [1038] = {.lex_state = 3, .external_lex_state = 5},
  [1039] = {.lex_state = 3, .external_lex_state = 5},
  [1040] = {.lex_state = 6, .external_lex_state = 9},
  [1041] = {.lex_state = 47},
  [1042] = {.lex_state = 6, .external_lex_state = 9},
  [1043] = {.lex_state = 6, .external_lex_state = 9},
  [1044] = {.lex_state = 3, .external_lex_state = 3},
  [1045] = {.lex_state = 3, .external_lex_state = 3},
  [1046] = {.lex_state = 3, .external_lex_state = 3},
  [1047] = {.lex_state = 6, .external_lex_state = 9},
  [1048] = {.lex_state = 3, .external_lex_state = 3},
  [1049] = {.lex_state = 2, .external_lex_state = 5},
  [1050] = {.lex_state = 3, .external_lex_state = 3},
  [1051] = {.lex_state = 3, .external_lex_state = 3},
  [1052] = {.lex_state = 3, .external_lex_state = 3},
  [1053] = {.lex_state = 6, .external_lex_state = 9},
  [1054] = {.lex_state = 3, .external_lex_state = 3},
  [1055] = {.lex_state = 3, .external_lex_state = 3},
  [1056] = {.lex_state = 3, .external_lex_state = 3},
  [1057] = {.lex_state = 3, .external_lex_state = 3},
  [1058] = {.lex_state = 3, .external_lex_state = 3},
  [1059] = {.lex_state = 3, .external_lex_state = 3},
  [1060] = {.lex_state = 3, .external_lex_state = 3},
  [1061] = {.lex_state = 3, .external_lex_state = 3},
  [1062] = {.lex_state = 3, .external_lex_state = 3},
  [1063] = {.lex_state = 3, .external_lex_state = 3},
  [1064] = {.lex_state = 6, .external_lex_state = 9},
  [1065] = {.lex_state = 3, .external_lex_state = 3},
  [1066] = {.lex_state = 6, .external_lex_state = 9},
  [1067] = {.lex_state = 6, .external_lex_state = 9},
  [1068] = {.lex_state = 3, .external_lex_state = 3},
  [1069] = {.lex_state = 3, .external_lex_state = 3},
  [1070] = {.lex_state = 6, .external_lex_state = 4},
  [1071] = {.lex_state = 6, .external_lex_state = 4},
  [1072] = {.lex_state = 3, .external_lex_state = 3},
  [1073] = {.lex_state = 47},
  [1074] = {.lex_state = 3, .external_lex_state = 3},
  [1075] = {.lex_state = 3, .external_lex_state = 3},
  [1076] = {.lex_state = 6, .external_lex_state = 9},
  [1077] = {.lex_state = 6, .external_lex_state = 9},
  [1078] = {.lex_state = 6, .external_lex_state = 9},
  [1079] = {.lex_state = 3, .external_lex_state = 3},
  [1080] = {.lex_state = 6, .external_lex_state = 9},
  [1081] = {.lex_state = 8, .external_lex_state = 4},
  [1082] = {.lex_state = 6, .external_lex_state = 9},
  [1083] = {.lex_state = 6, .external_lex_state = 9},
  [1084] = {.lex_state = 6, .external_lex_state = 9},
  [1085] = {.lex_state = 3, .external_lex_state = 3},
  [1086] = {.lex_state = 6, .external_lex_state = 9},
  [1087] = {.lex_state = 6, .external_lex_state = 9},
  [1088] = {.lex_state = 6, .external_lex_state = 9},
  [1089] = {.lex_state = 6, .external_lex_state = 9},
  [1090] = {.lex_state = 6, .external_lex_state = 9},
  [1091] = {.lex_state = 6, .external_lex_state = 9},
  [1092] = {.lex_state = 6, .external_lex_state = 9},
  [1093] = {.lex_state = 6, .external_lex_state = 9},
  [1094] = {.lex_state = 6, .external_lex_state = 9},
  [1095] = {.lex_state = 6, .external_lex_state = 9},
  [1096] = {.lex_state = 3, .external_lex_state = 3},
  [1097] = {.lex_state = 35, .external_lex_state = 20},
  [1098] = {.lex_state = 3, .external_lex_state = 3},
  [1099] = {.lex_state = 3, .external_lex_state = 3},
  [1100] = {.lex_state = 35, .external_lex_state = 20},
  [1101] = {.lex_state = 35, .external_lex_state = 20},
  [1102] = {.lex_state = 3, .external_lex_state = 5},
  [1103] = {.lex_state = 3, .external_lex_state = 5},
  [1104] = {.lex_state = 35, .external_lex_state = 20},
  [1105] = {.lex_state = 47},
  [1106] = {.lex_state = 35, .external_lex_state = 20},
  [1107] = {.lex_state = 35, .external_lex_state = 20},
  [1108] = {.lex_state = 3, .external_lex_state = 3},
  [1109] = {.lex_state = 3, .external_lex_state = 3},
  [1110] = {.lex_state = 3, .external_lex_state = 3},
  [1111] = {.lex_state = 35, .external_lex_state = 20},
  [1112] = {.lex_state = 3, .external_lex_state = 3},
  [1113] = {.lex_state = 2, .external_lex_state = 5},
  [1114] = {.lex_state = 3, .external_lex_state = 3},
  [1115] = {.lex_state = 3, .external_lex_state = 3},
  [1116] = {.lex_state = 3, .external_lex_state = 3},
  [1117] = {.lex_state = 35, .external_lex_state = 20},
  [1118] = {.lex_state = 3, .external_lex_state = 3},
  [1119] = {.lex_state = 3, .external_lex_state = 3},
  [1120] = {.lex_state = 3, .external_lex_state = 3},
  [1121] = {.lex_state = 3, .external_lex_state = 3},
  [1122] = {.lex_state = 3, .external_lex_state = 3},
  [1123] = {.lex_state = 3, .external_lex_state = 3},
  [1124] = {.lex_state = 3, .external_lex_state = 3},
  [1125] = {.lex_state = 3, .external_lex_state = 3},
  [1126] = {.lex_state = 3, .external_lex_state = 3},
  [1127] = {.lex_state = 3, .external_lex_state = 3},
  [1128] = {.lex_state = 42, .external_lex_state = 20},
  [1129] = {.lex_state = 47, .external_lex_state = 12},
  [1130] = {.lex_state = 35, .external_lex_state = 20},
  [1131] = {.lex_state = 35, .external_lex_state = 20},
  [1132] = {.lex_state = 47, .external_lex_state = 12},
  [1133] = {.lex_state = 47, .external_lex_state = 12},
  [1134] = {.lex_state = 42, .external_lex_state = 13},
  [1135] = {.lex_state = 42, .external_lex_state = 13},
  [1136] = {.lex_state = 47, .external_lex_state = 12},
  [1137] = {.lex_state = 47},
  [1138] = {.lex_state = 47, .external_lex_state = 12},
  [1139] = {.lex_state = 47, .external_lex_state = 12},
  [1140] = {.lex_state = 35, .external_lex_state = 20},
  [1141] = {.lex_state = 35, .external_lex_state = 20},
  [1142] = {.lex_state = 35, .external_lex_state = 20},
  [1143] = {.lex_state = 47, .external_lex_state = 12},
  [1144] = {.lex_state = 35, .external_lex_state = 20},
  [1145] = {.lex_state = 37, .external_lex_state = 13},
  [1146] = {.lex_state = 35, .external_lex_state = 20},
  [1147] = {.lex_state = 35, .external_lex_state = 20},
  [1148] = {.lex_state = 35, .external_lex_state = 20},
  [1149] = {.lex_state = 47, .external_lex_state = 12},
  [1150] = {.lex_state = 35, .external_lex_state = 20},
  [1151] = {.lex_state = 35, .external_lex_state = 20},
  [1152] = {.lex_state = 35, .external_lex_state = 20},
  [1153] = {.lex_state = 35, .external_lex_state = 20},
  [1154] = {.lex_state = 35, .external_lex_state = 20},
  [1155] = {.lex_state = 35, .external_lex_state = 20},
  [1156] = {.lex_state = 35, .external_lex_state = 20},
  [1157] = {.lex_state = 35, .external_lex_state = 20},
  [1158] = {.lex_state = 35, .external_lex_state = 20},
  [1159] = {.lex_state = 35, .external_lex_state = 20},
  [1160] = {.lex_state = 47, .external_lex_state = 12},
  [1161] = {.lex_state = 22, .external_lex_state = 10},
  [1162] = {.lex_state = 47, .external_lex_state = 12},
  [1163] = {.lex_state = 47, .external_lex_state = 12},
  [1164] = {.lex_state = 22, .external_lex_state = 10},
  [1165] = {.lex_state = 22, .external_lex_state = 10},
  [1166] = {.lex_state = 47},
  [1167] = {.lex_state = 47},
  [1168] = {.lex_state = 22, .external_lex_state = 10},
  [1169] = {.lex_state = 47},
  [1170] = {.lex_state = 22, .external_lex_state = 10},
  [1171] = {.lex_state = 22, .external_lex_state = 10},
  [1172] = {.lex_state = 47, .external_lex_state = 12},
  [1173] = {.lex_state = 47, .external_lex_state = 12},
  [1174] = {.lex_state = 47, .external_lex_state = 12},
  [1175] = {.lex_state = 22, .external_lex_state = 10},
  [1176] = {.lex_state = 47, .external_lex_state = 12},
  [1177] = {.lex_state = 32},
  [1178] = {.lex_state = 47, .external_lex_state = 12},
  [1179] = {.lex_state = 47, .external_lex_state = 12},
  [1180] = {.lex_state = 47, .external_lex_state = 12},
  [1181] = {.lex_state = 22, .external_lex_state = 10},
  [1182] = {.lex_state = 47, .external_lex_state = 12},
  [1183] = {.lex_state = 47, .external_lex_state = 12},
  [1184] = {.lex_state = 47, .external_lex_state = 12},
  [1185] = {.lex_state = 47, .external_lex_state = 12},
  [1186] = {.lex_state = 47, .external_lex_state = 12},
  [1187] = {.lex_state = 47, .external_lex_state = 12},
  [1188] = {.lex_state = 47, .external_lex_state = 12},
  [1189] = {.lex_state = 47, .external_lex_state = 12},
  [1190] = {.lex_state = 47, .external_lex_state = 12},
  [1191] = {.lex_state = 47, .external_lex_state = 12},
  [1192] = {.lex_state = 22, .external_lex_state = 10},
  [1193] = {.lex_state = 23, .external_lex_state = 3},
  [1194] = {.lex_state = 22, .external_lex_state = 10},
  [1195] = {.lex_state = 22, .external_lex_state = 10},
  [1196] = {.lex_state = 23, .external_lex_state = 3},
  [1197] = {.lex_state = 23, .external_lex_state = 3},
  [1198] = {.lex_state = 22, .external_lex_state = 11},
  [1199] = {.lex_state = 22, .external_lex_state = 11},
  [1200] = {.lex_state = 23, .external_lex_state = 3},
  [1201] = {.lex_state = 47},
  [1202] = {.lex_state = 23, .external_lex_state = 3},
  [1203] = {.lex_state = 23, .external_lex_state = 3},
  [1204] = {.lex_state = 22, .external_lex_state = 10},
  [1205] = {.lex_state = 22, .external_lex_state = 10},
  [1206] = {.lex_state = 22, .external_lex_state = 10},
  [1207] = {.lex_state = 23, .external_lex_state = 3},
  [1208] = {.lex_state = 22, .external_lex_state = 10},
  [1209] = {.lex_state = 27, .external_lex_state = 11},
  [1210] = {.lex_state = 22, .external_lex_state = 10},
  [1211] = {.lex_state = 22, .external_lex_state = 10},
  [1212] = {.lex_state = 22, .external_lex_state = 10},
  [1213] = {.lex_state = 23, .external_lex_state = 3},
  [1214] = {.lex_state = 22, .external_lex_state = 10},
  [1215] = {.lex_state = 22, .external_lex_state = 10},
  [1216] = {.lex_state = 22, .external_lex_state = 10},
  [1217] = {.lex_state = 22, .external_lex_state = 10},
  [1218] = {.lex_state = 22, .external_lex_state = 10},
  [1219] = {.lex_state = 22, .external_lex_state = 10},
  [1220] = {.lex_state = 22, .external_lex_state = 10},
  [1221] = {.lex_state = 22, .external_lex_state = 10},
  [1222] = {.lex_state = 22, .external_lex_state = 10},
  [1223] = {.lex_state = 22, .external_lex_state = 10},
  [1224] = {.lex_state = 23, .external_lex_state = 3},
  [1225] = {.lex_state = 24, .external_lex_state = 9},
  [1226] = {.lex_state = 9, .external_lex_state = 23},
  [1227] = {.lex_state = 9, .external_lex_state = 23},
  [1228] = {.lex_state = 24, .external_lex_state = 9},
  [1229] = {.lex_state = 24, .external_lex_state = 9},
  [1230] = {.lex_state = 23, .external_lex_state = 5},
  [1231] = {.lex_state = 23, .external_lex_state = 5},
  [1232] = {.lex_state = 24, .external_lex_state = 9},
  [1233] = {.lex_state = 47},
  [1234] = {.lex_state = 24, .external_lex_state = 9},
  [1235] = {.lex_state = 24, .external_lex_state = 9},
  [1236] = {.lex_state = 9, .external_lex_state = 23},
  [1237] = {.lex_state = 9, .external_lex_state = 23},
  [1238] = {.lex_state = 9, .external_lex_state = 23},
  [1239] = {.lex_state = 24, .external_lex_state = 9},
  [1240] = {.lex_state = 9, .external_lex_state = 23},
  [1241] = {.lex_state = 28, .external_lex_state = 5},
  [1242] = {.lex_state = 9, .external_lex_state = 23},
  [1243] = {.lex_state = 9, .external_lex_state = 23},
  [1244] = {.lex_state = 9, .external_lex_state = 23},
  [1245] = {.lex_state = 24, .external_lex_state = 9},
  [1246] = {.lex_state = 9, .external_lex_state = 23},
  [1247] = {.lex_state = 9, .external_lex_state = 23},
  [1248] = {.lex_state = 9, .external_lex_state = 23},
  [1249] = {.lex_state = 9, .external_lex_state = 23},
  [1250] = {.lex_state = 9, .external_lex_state = 23},
  [1251] = {.lex_state = 9, .external_lex_state = 23},
  [1252] = {.lex_state = 9, .external_lex_state = 23},
  [1253] = {.lex_state = 9, .external_lex_state = 23},
  [1254] = {.lex_state = 9, .external_lex_state = 23},
  [1255] = {.lex_state = 9, .external_lex_state = 23},
  [1256] = {.lex_state = 24, .external_lex_state = 9},
  [1257] = {.lex_state = 24, .external_lex_state = 3},
  [1258] = {.lex_state = 23, .external_lex_state = 3},
  [1259] = {.lex_state = 23, .external_lex_state = 3},
  [1260] = {.lex_state = 24, .external_lex_state = 3},
  [1261] = {.lex_state = 24, .external_lex_state = 3},
  [1262] = {.lex_state = 24, .external_lex_state = 4},
  [1263] = {.lex_state = 24, .external_lex_state = 4},
  [1264] = {.lex_state = 24, .external_lex_state = 3},
  [1265] = {.lex_state = 47},
  [1266] = {.lex_state = 24, .external_lex_state = 3},
  [1267] = {.lex_state = 24, .external_lex_state = 3},
  [1268] = {.lex_state = 23, .external_lex_state = 3},
  [1269] = {.lex_state = 23, .external_lex_state = 3},
  [1270] = {.lex_state = 23, .external_lex_state = 3},
  [1271] = {.lex_state = 24, .external_lex_state = 3},
  [1272] = {.lex_state = 23, .external_lex_state = 3},
  [1273] = {.lex_state = 29, .external_lex_state = 4},
  [1274] = {.lex_state = 23, .external_lex_state = 3},
  [1275] = {.lex_state = 23, .external_lex_state = 3},
  [1276] = {.lex_state = 23, .external_lex_state = 3},
  [1277] = {.lex_state = 24, .external_lex_state = 3},
  [1278] = {.lex_state = 23, .external_lex_state = 3},
  [1279] = {.lex_state = 23, .external_lex_state = 3},
  [1280] = {.lex_state = 23, .external_lex_state = 3},
  [1281] = {.lex_state = 23, .external_lex_state = 3},
  [1282] = {.lex_state = 23, .external_lex_state = 3},
  [1283] = {.lex_state = 23, .external_lex_state = 3},
  [1284] = {.lex_state = 23, .external_lex_state = 3},
  [1285] = {.lex_state = 23, .external_lex_state = 3},
  [1286] = {.lex_state = 23, .external_lex_state = 3},
  [1287] = {.lex_state = 23, .external_lex_state = 3},
  [1288] = {.lex_state = 24, .external_lex_state = 3},
  [1289] = {.lex_state = 25, .external_lex_state = 9},
  [1290] = {.lex_state = 24, .external_lex_state = 9},
  [1291] = {.lex_state = 24, .external_lex_state = 9},
  [1292] = {.lex_state = 25, .external_lex_state = 9},
  [1293] = {.lex_state = 25, .external_lex_state = 9},
  [1294] = {.lex_state = 24, .external_lex_state = 5},
  [1295] = {.lex_state = 24, .external_lex_state = 5},
  [1296] = {.lex_state = 25, .external_lex_state = 9},
  [1297] = {.lex_state = 47},
  [1298] = {.lex_state = 25, .external_lex_state = 9},
  [1299] = {.lex_state = 25, .external_lex_state = 9},
  [1300] = {.lex_state = 24, .external_lex_state = 9},
  [1301] = {.lex_state = 24, .external_lex_state = 9},
  [1302] = {.lex_state = 24, .external_lex_state = 9},
  [1303] = {.lex_state = 25, .external_lex_state = 9},
  [1304] = {.lex_state = 24, .external_lex_state = 9},
  [1305] = {.lex_state = 29, .external_lex_state = 5},
  [1306] = {.lex_state = 24, .external_lex_state = 9},
  [1307] = {.lex_state = 24, .external_lex_state = 9},
  [1308] = {.lex_state = 24, .external_lex_state = 9},
  [1309] = {.lex_state = 25, .external_lex_state = 9},
  [1310] = {.lex_state = 24, .external_lex_state = 9},
  [1311] = {.lex_state = 24, .external_lex_state = 9},
  [1312] = {.lex_state = 24, .external_lex_state = 9},
  [1313] = {.lex_state = 24, .external_lex_state = 9},
  [1314] = {.lex_state = 24, .external_lex_state = 9},
  [1315] = {.lex_state = 24, .external_lex_state = 9},
  [1316] = {.lex_state = 24, .external_lex_state = 9},
  [1317] = {.lex_state = 24, .external_lex_state = 9},
  [1318] = {.lex_state = 24, .external_lex_state = 9},
  [1319] = {.lex_state = 24, .external_lex_state = 9},
  [1320] = {.lex_state = 25, .external_lex_state = 9},
  [1321] = {.lex_state = 24, .external_lex_state = 3},
  [1322] = {.lex_state = 24, .external_lex_state = 3},
  [1323] = {.lex_state = 25, .external_lex_state = 4},
  [1324] = {.lex_state = 25, .external_lex_state = 4},
  [1325] = {.lex_state = 24, .external_lex_state = 3},
  [1326] = {.lex_state = 24, .external_lex_state = 3},
  [1327] = {.lex_state = 24, .external_lex_state = 3},
  [1328] = {.lex_state = 24, .external_lex_state = 3},
  [1329] = {.lex_state = 29, .external_lex_state = 4},
  [1330] = {.lex_state = 24, .external_lex_state = 3},
  [1331] = {.lex_state = 24, .external_lex_state = 3},
  [1332] = {.lex_state = 24, .external_lex_state = 3},
  [1333] = {.lex_state = 24, .external_lex_state = 3},
  [1334] = {.lex_state = 24, .external_lex_state = 3},
  [1335] = {.lex_state = 24, .external_lex_state = 3},
  [1336] = {.lex_state = 24, .external_lex_state = 3},
  [1337] = {.lex_state = 24, .external_lex_state = 3},
  [1338] = {.lex_state = 24, .external_lex_state = 3},
  [1339] = {.lex_state = 24, .external_lex_state = 3},
  [1340] = {.lex_state = 24, .external_lex_state = 3},
  [1341] = {.lex_state = 24, .external_lex_state = 3},
  [1342] = {.lex_state = 24, .external_lex_state = 3},
  [1343] = {.lex_state = 25, .external_lex_state = 9},
  [1344] = {.lex_state = 25, .external_lex_state = 9},
  [1345] = {.lex_state = 25, .external_lex_state = 9},
  [1346] = {.lex_state = 25, .external_lex_state = 9},
  [1347] = {.lex_state = 25, .external_lex_state = 9},
  [1348] = {.lex_state = 25, .external_lex_state = 9},
  [1349] = {.lex_state = 14, .external_lex_state = 5},
  [1350] = {.lex_state = 25, .external_lex_state = 9},
  [1351] = {.lex_state = 25, .external_lex_state = 9},
  [1352] = {.lex_state = 25, .external_lex_state = 9},
  [1353] = {.lex_state = 25, .external_lex_state = 9},
  [1354] = {.lex_state = 25, .external_lex_state = 9},
  [1355] = {.lex_state = 25, .external_lex_state = 9},
  [1356] = {.lex_state = 25, .external_lex_state = 9},
  [1357] = {.lex_state = 25, .external_lex_state = 9},
  [1358] = {.lex_state = 25, .external_lex_state = 9},
  [1359] = {.lex_state = 25, .external_lex_state = 9},
  [1360] = {.lex_state = 25, .external_lex_state = 9},
  [1361] = {.lex_state = 25, .external_lex_state = 9},
  [1362] = {.lex_state = 25, .external_lex_state = 9},
  [1363] = {.lex_state = 47},
  [1364] = {.lex_state = 37},
  [1365] = {.lex_state = 35, .external_lex_state = 6},
  [1366] = {.lex_state = 51},
  [1367] = {.lex_state = 47},
  [1368] = {.lex_state = 9},
  [1369] = {.lex_state = 9},
  [1370] = {.lex_state = 40},
  [1371] = {.lex_state = 3, .external_lex_state = 5},
  [1372] = {.lex_state = 6, .external_lex_state = 4},
  [1373] = {.lex_state = 35, .external_lex_state = 6},
  [1374] = {.lex_state = 43},
  [1375] = {.lex_state = 44, .external_lex_state = 13},
  [1376] = {.lex_state = 44, .external_lex_state = 13},
  [1377] = {.lex_state = 47, .external_lex_state = 14},
  [1378] = {.lex_state = 47},
  [1379] = {.lex_state = 47, .external_lex_state = 2},
  [1380] = {.lex_state = 9},
  [1381] = {.lex_state = 39},
  [1382] = {.lex_state = 51},
  [1383] = {.lex_state = 9},
  [1384] = {.lex_state = 47},
  [1385] = {.lex_state = 43, .external_lex_state = 15},
  [1386] = {.lex_state = 40},
  [1387] = {.lex_state = 9, .external_lex_state = 17},
  [1388] = {.lex_state = 47},
  [1389] = {.lex_state = 9},
  [1390] = {.lex_state = 9, .external_lex_state = 2},
  [1391] = {.lex_state = 42},
  [1392] = {.lex_state = 45, .external_lex_state = 21},
  [1393] = {.lex_state = 45, .external_lex_state = 13},
  [1394] = {.lex_state = 44, .external_lex_state = 13},
  [1395] = {.lex_state = 44, .external_lex_state = 13},
  [1396] = {.lex_state = 48, .external_lex_state = 13},
  [1397] = {.lex_state = 45, .external_lex_state = 21},
  [1398] = {.lex_state = 45, .external_lex_state = 13},
  [1399] = {.lex_state = 47},
  [1400] = {.lex_state = 52, .external_lex_state = 22},
  [1401] = {.lex_state = 43, .external_lex_state = 22},
  [1402] = {.lex_state = 52, .external_lex_state = 22},
  [1403] = {.lex_state = 39},
  [1404] = {.lex_state = 47},
  [1405] = {.lex_state = 9, .external_lex_state = 2},
  [1406] = {.lex_state = 9, .external_lex_state = 23},
  [1407] = {.lex_state = 9},
  [1408] = {.lex_state = 4, .external_lex_state = 11},
  [1409] = {.lex_state = 47},
  [1410] = {.lex_state = 47},
  [1411] = {.lex_state = 9, .external_lex_state = 2},
  [1412] = {.lex_state = 50},
  [1413] = {.lex_state = 50},
  [1414] = {.lex_state = 45, .external_lex_state = 13},
  [1415] = {.lex_state = 45, .external_lex_state = 13},
  [1416] = {.lex_state = 45, .external_lex_state = 21},
  [1417] = {.lex_state = 48, .external_lex_state = 13},
  [1418] = {.lex_state = 45, .external_lex_state = 21},
  [1419] = {.lex_state = 45, .external_lex_state = 13},
  [1420] = {.lex_state = 35, .external_lex_state = 20},
  [1421] = {.lex_state = 42, .external_lex_state = 13},
  [1422] = {.lex_state = 35, .external_lex_state = 13},
  [1423] = {.lex_state = 45, .external_lex_state = 13},
  [1424] = {.lex_state = 45, .external_lex_state = 13},
  [1425] = {.lex_state = 47},
  [1426] = {.lex_state = 49, .external_lex_state = 15},
  [1427] = {.lex_state = 52, .external_lex_state = 15},
  [1428] = {.lex_state = 52, .external_lex_state = 15},
  [1429] = {.lex_state = 9, .external_lex_state = 2},
  [1430] = {.lex_state = 9, .external_lex_state = 23},
  [1431] = {.lex_state = 47},
  [1432] = {.lex_state = 47},
  [1433] = {.lex_state = 50},
  [1434] = {.lex_state = 41},
  [1435] = {.lex_state = 50},
  [1436] = {.lex_state = 41},
  [1437] = {.lex_state = 45, .external_lex_state = 13},
  [1438] = {.lex_state = 45, .external_lex_state = 13},
  [1439] = {.lex_state = 35, .external_lex_state = 20},
  [1440] = {.lex_state = 42, .external_lex_state = 13},
  [1441] = {.lex_state = 35, .external_lex_state = 13},
  [1442] = {.lex_state = 45, .external_lex_state = 13},
  [1443] = {.lex_state = 45, .external_lex_state = 13},
  [1444] = {.lex_state = 45, .external_lex_state = 13},
  [1445] = {.lex_state = 47},
  [1446] = {.lex_state = 53},
  [1447] = {.lex_state = 47},
  [1448] = {.lex_state = 41},
  [1449] = {.lex_state = 41},
  [1450] = {.lex_state = 45, .external_lex_state = 13},
  [1451] = {.lex_state = 45, .external_lex_state = 13},
  [1452] = {.lex_state = 53},
  [1453] = {.lex_state = 53},
  [1454] = {.lex_state = 41},
  [1455] = {.lex_state = 41},
  [1456] = {.lex_state = 53},
  [1457] = {.lex_state = 53},
  [1458] = {.lex_state = 53},
  [1459] = {.lex_state = 53},
  [1460] = {.lex_state = 53},
  [1461] = {.lex_state = 46, .external_lex_state = 2},
  [1462] = {.lex_state = 3, .external_lex_state = 5},
  [1463] = {.lex_state = 9, .external_lex_state = 2},
  [1464] = {.lex_state = 47, .external_lex_state = 2},
  [1465] = {.lex_state = 9, .external_lex_state = 16},
  [1466] = {.lex_state = 4, .external_lex_state = 11},
  [1467] = {.lex_state = 9, .external_lex_state = 16},
  [1468] = {.lex_state = 4, .external_lex_state = 11},
  [1469] = {.lex_state = 47},
  [1470] = {.lex_state = 47},
  [1471] = {.lex_state = 47},
  [1472] = {.lex_state = 37},
  [1473] = {.lex_state = 51},
  [1474] = {.lex_state = 47},
  [1475] = {.lex_state = 9},
  [1476] = {.lex_state = 44, .external_lex_state = 13},
  [1477] = {.lex_state = 44, .external_lex_state = 13},
  [1478] = {.lex_state = 47, .external_lex_state = 14},
  [1479] = {.lex_state = 47},
  [1480] = {.lex_state = 47, .external_lex_state = 2},
  [1481] = {.lex_state = 9},
  [1482] = {.lex_state = 39},
  [1483] = {.lex_state = 51},
  [1484] = {.lex_state = 9},
  [1485] = {.lex_state = 42},
  [1486] = {.lex_state = 45, .external_lex_state = 21},
  [1487] = {.lex_state = 45, .external_lex_state = 13},
  [1488] = {.lex_state = 44, .external_lex_state = 13},
  [1489] = {.lex_state = 44, .external_lex_state = 13},
  [1490] = {.lex_state = 48, .external_lex_state = 13},
  [1491] = {.lex_state = 45, .external_lex_state = 21},
  [1492] = {.lex_state = 45, .external_lex_state = 13},
  [1493] = {.lex_state = 47},
  [1494] = {.lex_state = 39},
  [1495] = {.lex_state = 45, .external_lex_state = 13},
  [1496] = {.lex_state = 45, .external_lex_state = 13},
  [1497] = {.lex_state = 45, .external_lex_state = 21},
  [1498] = {.lex_state = 48, .external_lex_state = 13},
  [1499] = {.lex_state = 45, .external_lex_state = 21},
  [1500] = {.lex_state = 45, .external_lex_state = 13},
  [1501] = {.lex_state = 35, .external_lex_state = 20},
  [1502] = {.lex_state = 42, .external_lex_state = 13},
  [1503] = {.lex_state = 35, .external_lex_state = 13},
  [1504] = {.lex_state = 45, .external_lex_state = 13},
  [1505] = {.lex_state = 45, .external_lex_state = 13},
  [1506] = {.lex_state = 47},
  [1507] = {.lex_state = 45, .external_lex_state = 13},
  [1508] = {.lex_state = 45, .external_lex_state = 13},
  [1509] = {.lex_state = 35, .external_lex_state = 20},
  [1510] = {.lex_state = 42, .external_lex_state = 13},
  [1511] = {.lex_state = 35, .external_lex_state = 13},
  [1512] = {.lex_state = 45, .external_lex_state = 13},
  [1513] = {.lex_state = 45, .external_lex_state = 13},
  [1514] = {.lex_state = 45, .external_lex_state = 13},
  [1515] = {.lex_state = 45, .external_lex_state = 13},
  [1516] = {.lex_state = 45, .external_lex_state = 13},
  [1517] = {.lex_state = 37},
  [1518] = {.lex_state = 51},
  [1519] = {.lex_state = 47},
  [1520] = {.lex_state = 9},
  [1521] = {.lex_state = 44, .external_lex_state = 13},
  [1522] = {.lex_state = 44, .external_lex_state = 13},
  [1523] = {.lex_state = 47, .external_lex_state = 14},
  [1524] = {.lex_state = 47, .external_lex_state = 2},
  [1525] = {.lex_state = 9},
  [1526] = {.lex_state = 39},
  [1527] = {.lex_state = 51},
  [1528] = {.lex_state = 9},
  [1529] = {.lex_state = 45, .external_lex_state = 21},
  [1530] = {.lex_state = 45, .external_lex_state = 13},
  [1531] = {.lex_state = 44, .external_lex_state = 13},
  [1532] = {.lex_state = 44, .external_lex_state = 13},
  [1533] = {.lex_state = 48, .external_lex_state = 13},
  [1534] = {.lex_state = 45, .external_lex_state = 21},
  [1535] = {.lex_state = 45, .external_lex_state = 13},
  [1536] = {.lex_state = 47},
  [1537] = {.lex_state = 39},
  [1538] = {.lex_state = 45, .external_lex_state = 13},
  [1539] = {.lex_state = 45, .external_lex_state = 13},
  [1540] = {.lex_state = 45, .external_lex_state = 21},
  [1541] = {.lex_state = 48, .external_lex_state = 13},
  [1542] = {.lex_state = 45, .external_lex_state = 21},
  [1543] = {.lex_state = 45, .external_lex_state = 13},
  [1544] = {.lex_state = 35, .external_lex_state = 20},
  [1545] = {.lex_state = 42, .external_lex_state = 13},
  [1546] = {.lex_state = 35, .external_lex_state = 13},
  [1547] = {.lex_state = 45, .external_lex_state = 13},
  [1548] = {.lex_state = 45, .external_lex_state = 13},
  [1549] = {.lex_state = 47},
  [1550] = {.lex_state = 45, .external_lex_state = 13},
  [1551] = {.lex_state = 45, .external_lex_state = 13},
  [1552] = {.lex_state = 35, .external_lex_state = 20},
  [1553] = {.lex_state = 42, .external_lex_state = 13},
  [1554] = {.lex_state = 35, .external_lex_state = 13},
  [1555] = {.lex_state = 45, .external_lex_state = 13},
  [1556] = {.lex_state = 45, .external_lex_state = 13},
  [1557] = {.lex_state = 45, .external_lex_state = 13},
  [1558] = {.lex_state = 45, .external_lex_state = 13},
  [1559] = {.lex_state = 45, .external_lex_state = 13},
  [1560] = {.lex_state = 37},
  [1561] = {.lex_state = 51},
  [1562] = {.lex_state = 47},
  [1563] = {.lex_state = 9},
  [1564] = {.lex_state = 44, .external_lex_state = 13},
  [1565] = {.lex_state = 44, .external_lex_state = 13},
  [1566] = {.lex_state = 47, .external_lex_state = 14},
  [1567] = {.lex_state = 47, .external_lex_state = 2},
  [1568] = {.lex_state = 9},
  [1569] = {.lex_state = 39},
  [1570] = {.lex_state = 51},
  [1571] = {.lex_state = 9},
  [1572] = {.lex_state = 45, .external_lex_state = 21},
  [1573] = {.lex_state = 45, .external_lex_state = 13},
  [1574] = {.lex_state = 44, .external_lex_state = 13},
  [1575] = {.lex_state = 44, .external_lex_state = 13},
  [1576] = {.lex_state = 48, .external_lex_state = 13},
  [1577] = {.lex_state = 45, .external_lex_state = 21},
  [1578] = {.lex_state = 45, .external_lex_state = 13},
  [1579] = {.lex_state = 47},
  [1580] = {.lex_state = 39},
  [1581] = {.lex_state = 45, .external_lex_state = 13},
  [1582] = {.lex_state = 45, .external_lex_state = 13},
  [1583] = {.lex_state = 45, .external_lex_state = 21},
  [1584] = {.lex_state = 48, .external_lex_state = 13},
  [1585] = {.lex_state = 45, .external_lex_state = 21},
  [1586] = {.lex_state = 45, .external_lex_state = 13},
  [1587] = {.lex_state = 35, .external_lex_state = 20},
  [1588] = {.lex_state = 42, .external_lex_state = 13},
  [1589] = {.lex_state = 35, .external_lex_state = 13},
  [1590] = {.lex_state = 45, .external_lex_state = 13},
  [1591] = {.lex_state = 45, .external_lex_state = 13},
  [1592] = {.lex_state = 47},
  [1593] = {.lex_state = 45, .external_lex_state = 13},
  [1594] = {.lex_state = 45, .external_lex_state = 13},
  [1595] = {.lex_state = 35, .external_lex_state = 20},
  [1596] = {.lex_state = 42, .external_lex_state = 13},
  [1597] = {.lex_state = 35, .external_lex_state = 13},
  [1598] = {.lex_state = 45, .external_lex_state = 13},
  [1599] = {.lex_state = 45, .external_lex_state = 13},
  [1600] = {.lex_state = 45, .external_lex_state = 13},
  [1601] = {.lex_state = 45, .external_lex_state = 13},
  [1602] = {.lex_state = 45, .external_lex_state = 13},
  [1603] = {.lex_state = 37},
  [1604] = {.lex_state = 51},
  [1605] = {.lex_state = 47},
  [1606] = {.lex_state = 9},
  [1607] = {.lex_state = 44, .external_lex_state = 13},
  [1608] = {.lex_state = 44, .external_lex_state = 13},
  [1609] = {.lex_state = 47, .external_lex_state = 14},
  [1610] = {.lex_state = 47, .external_lex_state = 2},
  [1611] = {.lex_state = 9},
  [1612] = {.lex_state = 39},
  [1613] = {.lex_state = 51},
  [1614] = {.lex_state = 9},
  [1615] = {.lex_state = 45, .external_lex_state = 21},
  [1616] = {.lex_state = 45, .external_lex_state = 13},
  [1617] = {.lex_state = 44, .external_lex_state = 13},
  [1618] = {.lex_state = 44, .external_lex_state = 13},
  [1619] = {.lex_state = 48, .external_lex_state = 13},
  [1620] = {.lex_state = 45, .external_lex_state = 21},
  [1621] = {.lex_state = 45, .external_lex_state = 13},
  [1622] = {.lex_state = 47},
  [1623] = {.lex_state = 39},
  [1624] = {.lex_state = 45, .external_lex_state = 13},
  [1625] = {.lex_state = 45, .external_lex_state = 13},
  [1626] = {.lex_state = 45, .external_lex_state = 21},
  [1627] = {.lex_state = 48, .external_lex_state = 13},
  [1628] = {.lex_state = 45, .external_lex_state = 21},
  [1629] = {.lex_state = 45, .external_lex_state = 13},
  [1630] = {.lex_state = 35, .external_lex_state = 20},
  [1631] = {.lex_state = 42, .external_lex_state = 13},
  [1632] = {.lex_state = 35, .external_lex_state = 13},
  [1633] = {.lex_state = 45, .external_lex_state = 13},
  [1634] = {.lex_state = 45, .external_lex_state = 13},
  [1635] = {.lex_state = 47},
  [1636] = {.lex_state = 45, .external_lex_state = 13},
  [1637] = {.lex_state = 45, .external_lex_state = 13},
  [1638] = {.lex_state = 35, .external_lex_state = 20},
  [1639] = {.lex_state = 42, .external_lex_state = 13},
  [1640] = {.lex_state = 35, .external_lex_state = 13},
  [1641] = {.lex_state = 45, .external_lex_state = 13},
  [1642] = {.lex_state = 45, .external_lex_state = 13},
  [1643] = {.lex_state = 45, .external_lex_state = 13},
  [1644] = {.lex_state = 45, .external_lex_state = 13},
  [1645] = {.lex_state = 45, .external_lex_state = 13},
  [1646] = {.lex_state = 37},
  [1647] = {.lex_state = 51},
  [1648] = {.lex_state = 47},
  [1649] = {.lex_state = 9},
  [1650] = {.lex_state = 44, .external_lex_state = 13},
  [1651] = {.lex_state = 44, .external_lex_state = 13},
  [1652] = {.lex_state = 47, .external_lex_state = 14},
  [1653] = {.lex_state = 47, .external_lex_state = 2},
  [1654] = {.lex_state = 9},
  [1655] = {.lex_state = 39},
  [1656] = {.lex_state = 51},
  [1657] = {.lex_state = 9},
  [1658] = {.lex_state = 45, .external_lex_state = 21},
  [1659] = {.lex_state = 45, .external_lex_state = 13},
  [1660] = {.lex_state = 44, .external_lex_state = 13},
  [1661] = {.lex_state = 44, .external_lex_state = 13},
  [1662] = {.lex_state = 48, .external_lex_state = 13},
  [1663] = {.lex_state = 45, .external_lex_state = 21},
  [1664] = {.lex_state = 45, .external_lex_state = 13},
  [1665] = {.lex_state = 47},
  [1666] = {.lex_state = 39},
  [1667] = {.lex_state = 45, .external_lex_state = 13},
  [1668] = {.lex_state = 45, .external_lex_state = 13},
  [1669] = {.lex_state = 45, .external_lex_state = 21},
  [1670] = {.lex_state = 48, .external_lex_state = 13},
  [1671] = {.lex_state = 45, .external_lex_state = 21},
  [1672] = {.lex_state = 45, .external_lex_state = 13},
  [1673] = {.lex_state = 35, .external_lex_state = 20},
  [1674] = {.lex_state = 42, .external_lex_state = 13},
  [1675] = {.lex_state = 35, .external_lex_state = 13},
  [1676] = {.lex_state = 45, .external_lex_state = 13},
  [1677] = {.lex_state = 45, .external_lex_state = 13},
  [1678] = {.lex_state = 47},
  [1679] = {.lex_state = 45, .external_lex_state = 13},
  [1680] = {.lex_state = 45, .external_lex_state = 13},
  [1681] = {.lex_state = 35, .external_lex_state = 20},
  [1682] = {.lex_state = 42, .external_lex_state = 13},
  [1683] = {.lex_state = 35, .external_lex_state = 13},
  [1684] = {.lex_state = 45, .external_lex_state = 13},
  [1685] = {.lex_state = 45, .external_lex_state = 13},
  [1686] = {.lex_state = 45, .external_lex_state = 13},
  [1687] = {.lex_state = 45, .external_lex_state = 13},
  [1688] = {.lex_state = 45, .external_lex_state = 13},
  [1689] = {.lex_state = 37},
  [1690] = {.lex_state = 51},
  [1691] = {.lex_state = 47},
  [1692] = {.lex_state = 9},
  [1693] = {.lex_state = 44, .external_lex_state = 13},
  [1694] = {.lex_state = 44, .external_lex_state = 13},
  [1695] = {.lex_state = 47, .external_lex_state = 2},
  [1696] = {.lex_state = 9},
  [1697] = {.lex_state = 39},
  [1698] = {.lex_state = 51},
  [1699] = {.lex_state = 9},
  [1700] = {.lex_state = 45, .external_lex_state = 21},
  [1701] = {.lex_state = 45, .external_lex_state = 13},
  [1702] = {.lex_state = 44, .external_lex_state = 13},
  [1703] = {.lex_state = 44, .external_lex_state = 13},
  [1704] = {.lex_state = 48, .external_lex_state = 13},
  [1705] = {.lex_state = 45, .external_lex_state = 21},
  [1706] = {.lex_state = 45, .external_lex_state = 13},
  [1707] = {.lex_state = 39},
  [1708] = {.lex_state = 45, .external_lex_state = 13},
  [1709] = {.lex_state = 45, .external_lex_state = 13},
  [1710] = {.lex_state = 45, .external_lex_state = 21},
  [1711] = {.lex_state = 48, .external_lex_state = 13},
  [1712] = {.lex_state = 45, .external_lex_state = 21},
  [1713] = {.lex_state = 45, .external_lex_state = 13},
  [1714] = {.lex_state = 35, .external_lex_state = 20},
  [1715] = {.lex_state = 42, .external_lex_state = 13},
  [1716] = {.lex_state = 35, .external_lex_state = 13},
  [1717] = {.lex_state = 45, .external_lex_state = 13},
  [1718] = {.lex_state = 45, .external_lex_state = 13},
  [1719] = {.lex_state = 45, .external_lex_state = 13},
  [1720] = {.lex_state = 45, .external_lex_state = 13},
  [1721] = {.lex_state = 35, .external_lex_state = 20},
  [1722] = {.lex_state = 42, .external_lex_state = 13},
  [1723] = {.lex_state = 35, .external_lex_state = 13},
  [1724] = {.lex_state = 45, .external_lex_state = 13},
  [1725] = {.lex_state = 45, .external_lex_state = 13},
  [1726] = {.lex_state = 45, .external_lex_state = 13},
  [1727] = {.lex_state = 45, .external_lex_state = 13},
  [1728] = {.lex_state = 45, .external_lex_state = 13},
  [1729] = {.lex_state = 37},
  [1730] = {.lex_state = 51},
  [1731] = {.lex_state = 47},
  [1732] = {.lex_state = 9},
  [1733] = {.lex_state = 44, .external_lex_state = 13},
  [1734] = {.lex_state = 44, .external_lex_state = 13},
  [1735] = {.lex_state = 47, .external_lex_state = 2},
  [1736] = {.lex_state = 9},
  [1737] = {.lex_state = 39},
  [1738] = {.lex_state = 51},
  [1739] = {.lex_state = 9},
  [1740] = {.lex_state = 45, .external_lex_state = 21},
  [1741] = {.lex_state = 45, .external_lex_state = 13},
  [1742] = {.lex_state = 44, .external_lex_state = 13},
  [1743] = {.lex_state = 44, .external_lex_state = 13},
  [1744] = {.lex_state = 48, .external_lex_state = 13},
  [1745] = {.lex_state = 45, .external_lex_state = 21},
  [1746] = {.lex_state = 45, .external_lex_state = 13},
  [1747] = {.lex_state = 39},
  [1748] = {.lex_state = 45, .external_lex_state = 13},
  [1749] = {.lex_state = 45, .external_lex_state = 13},
  [1750] = {.lex_state = 45, .external_lex_state = 21},
  [1751] = {.lex_state = 48, .external_lex_state = 13},
  [1752] = {.lex_state = 45, .external_lex_state = 21},
  [1753] = {.lex_state = 45, .external_lex_state = 13},
  [1754] = {.lex_state = 35, .external_lex_state = 20},
  [1755] = {.lex_state = 42, .external_lex_state = 13},
  [1756] = {.lex_state = 35, .external_lex_state = 13},
  [1757] = {.lex_state = 45, .external_lex_state = 13},
  [1758] = {.lex_state = 45, .external_lex_state = 13},
  [1759] = {.lex_state = 45, .external_lex_state = 13},
  [1760] = {.lex_state = 45, .external_lex_state = 13},
  [1761] = {.lex_state = 35, .external_lex_state = 20},
  [1762] = {.lex_state = 42, .external_lex_state = 13},
  [1763] = {.lex_state = 35, .external_lex_state = 13},
  [1764] = {.lex_state = 45, .external_lex_state = 13},
  [1765] = {.lex_state = 45, .external_lex_state = 13},
  [1766] = {.lex_state = 45, .external_lex_state = 13},
  [1767] = {.lex_state = 45, .external_lex_state = 13},
  [1768] = {.lex_state = 45, .external_lex_state = 13},
  [1769] = {.lex_state = 37},
  [1770] = {.lex_state = 51},
  [1771] = {.lex_state = 47},
  [1772] = {.lex_state = 9},
  [1773] = {.lex_state = 44, .external_lex_state = 13},
  [1774] = {.lex_state = 44, .external_lex_state = 13},
  [1775] = {.lex_state = 47, .external_lex_state = 2},
  [1776] = {.lex_state = 9},
  [1777] = {.lex_state = 39},
  [1778] = {.lex_state = 51},
  [1779] = {.lex_state = 9},
  [1780] = {.lex_state = 45, .external_lex_state = 21},
  [1781] = {.lex_state = 45, .external_lex_state = 13},
  [1782] = {.lex_state = 44, .external_lex_state = 13},
  [1783] = {.lex_state = 44, .external_lex_state = 13},
  [1784] = {.lex_state = 48, .external_lex_state = 13},
  [1785] = {.lex_state = 45, .external_lex_state = 21},
  [1786] = {.lex_state = 45, .external_lex_state = 13},
  [1787] = {.lex_state = 39},
  [1788] = {.lex_state = 45, .external_lex_state = 13},
  [1789] = {.lex_state = 45, .external_lex_state = 13},
  [1790] = {.lex_state = 45, .external_lex_state = 21},
  [1791] = {.lex_state = 48, .external_lex_state = 13},
  [1792] = {.lex_state = 45, .external_lex_state = 21},
  [1793] = {.lex_state = 45, .external_lex_state = 13},
  [1794] = {.lex_state = 35, .external_lex_state = 20},
  [1795] = {.lex_state = 42, .external_lex_state = 13},
  [1796] = {.lex_state = 35, .external_lex_state = 13},
  [1797] = {.lex_state = 45, .external_lex_state = 13},
  [1798] = {.lex_state = 45, .external_lex_state = 13},
  [1799] = {.lex_state = 45, .external_lex_state = 13},
  [1800] = {.lex_state = 45, .external_lex_state = 13},
  [1801] = {.lex_state = 35, .external_lex_state = 20},
  [1802] = {.lex_state = 42, .external_lex_state = 13},
  [1803] = {.lex_state = 35, .external_lex_state = 13},
  [1804] = {.lex_state = 45, .external_lex_state = 13},
  [1805] = {.lex_state = 45, .external_lex_state = 13},
  [1806] = {.lex_state = 45, .external_lex_state = 13},
  [1807] = {.lex_state = 45, .external_lex_state = 13},
  [1808] = {.lex_state = 45, .external_lex_state = 13},
  [1809] = {.lex_state = 37},
  [1810] = {.lex_state = 51},
  [1811] = {.lex_state = 47},
  [1812] = {.lex_state = 9},
  [1813] = {.lex_state = 44, .external_lex_state = 13},
  [1814] = {.lex_state = 44, .external_lex_state = 13},
  [1815] = {.lex_state = 47, .external_lex_state = 2},
  [1816] = {.lex_state = 9},
  [1817] = {.lex_state = 39},
  [1818] = {.lex_state = 51},
  [1819] = {.lex_state = 9},
  [1820] = {.lex_state = 45, .external_lex_state = 21},
  [1821] = {.lex_state = 45, .external_lex_state = 13},
  [1822] = {.lex_state = 44, .external_lex_state = 13},
  [1823] = {.lex_state = 44, .external_lex_state = 13},
  [1824] = {.lex_state = 48, .external_lex_state = 13},
  [1825] = {.lex_state = 45, .external_lex_state = 21},
  [1826] = {.lex_state = 45, .external_lex_state = 13},
  [1827] = {.lex_state = 39},
  [1828] = {.lex_state = 45, .external_lex_state = 13},
  [1829] = {.lex_state = 45, .external_lex_state = 13},
  [1830] = {.lex_state = 45, .external_lex_state = 21},
  [1831] = {.lex_state = 48, .external_lex_state = 13},
  [1832] = {.lex_state = 45, .external_lex_state = 21},
  [1833] = {.lex_state = 45, .external_lex_state = 13},
  [1834] = {.lex_state = 35, .external_lex_state = 20},
  [1835] = {.lex_state = 42, .external_lex_state = 13},
  [1836] = {.lex_state = 35, .external_lex_state = 13},
  [1837] = {.lex_state = 45, .external_lex_state = 13},
  [1838] = {.lex_state = 45, .external_lex_state = 13},
  [1839] = {.lex_state = 45, .external_lex_state = 13},
  [1840] = {.lex_state = 45, .external_lex_state = 13},
  [1841] = {.lex_state = 35, .external_lex_state = 20},
  [1842] = {.lex_state = 42, .external_lex_state = 13},
  [1843] = {.lex_state = 35, .external_lex_state = 13},
  [1844] = {.lex_state = 45, .external_lex_state = 13},
  [1845] = {.lex_state = 45, .external_lex_state = 13},
  [1846] = {.lex_state = 45, .external_lex_state = 13},
  [1847] = {.lex_state = 45, .external_lex_state = 13},
  [1848] = {.lex_state = 45, .external_lex_state = 13},
  [1849] = {.lex_state = 37},
  [1850] = {.lex_state = 51},
  [1851] = {.lex_state = 47},
  [1852] = {.lex_state = 9},
  [1853] = {.lex_state = 44, .external_lex_state = 13},
  [1854] = {.lex_state = 44, .external_lex_state = 13},
  [1855] = {.lex_state = 47, .external_lex_state = 2},
  [1856] = {.lex_state = 9},
  [1857] = {.lex_state = 39},
  [1858] = {.lex_state = 51},
  [1859] = {.lex_state = 9},
  [1860] = {.lex_state = 45, .external_lex_state = 21},
  [1861] = {.lex_state = 45, .external_lex_state = 13},
  [1862] = {.lex_state = 44, .external_lex_state = 13},
  [1863] = {.lex_state = 44, .external_lex_state = 13},
  [1864] = {.lex_state = 48, .external_lex_state = 13},
  [1865] = {.lex_state = 45, .external_lex_state = 21},
  [1866] = {.lex_state = 45, .external_lex_state = 13},
  [1867] = {.lex_state = 39},
  [1868] = {.lex_state = 45, .external_lex_state = 13},
  [1869] = {.lex_state = 45, .external_lex_state = 13},
  [1870] = {.lex_state = 45, .external_lex_state = 21},
  [1871] = {.lex_state = 48, .external_lex_state = 13},
  [1872] = {.lex_state = 45, .external_lex_state = 21},
  [1873] = {.lex_state = 45, .external_lex_state = 13},
  [1874] = {.lex_state = 35, .external_lex_state = 20},
  [1875] = {.lex_state = 42, .external_lex_state = 13},
  [1876] = {.lex_state = 35, .external_lex_state = 13},
  [1877] = {.lex_state = 45, .external_lex_state = 13},
  [1878] = {.lex_state = 45, .external_lex_state = 13},
  [1879] = {.lex_state = 45, .external_lex_state = 13},
  [1880] = {.lex_state = 45, .external_lex_state = 13},
  [1881] = {.lex_state = 35, .external_lex_state = 20},
  [1882] = {.lex_state = 42, .external_lex_state = 13},
  [1883] = {.lex_state = 35, .external_lex_state = 13},
  [1884] = {.lex_state = 45, .external_lex_state = 13},
  [1885] = {.lex_state = 45, .external_lex_state = 13},
  [1886] = {.lex_state = 45, .external_lex_state = 13},
  [1887] = {.lex_state = 45, .external_lex_state = 13},
  [1888] = {.lex_state = 45, .external_lex_state = 13},
  [1889] = {.lex_state = 37},
  [1890] = {.lex_state = 51},
  [1891] = {.lex_state = 47},
  [1892] = {.lex_state = 9},
  [1893] = {.lex_state = 44, .external_lex_state = 13},
  [1894] = {.lex_state = 44, .external_lex_state = 13},
  [1895] = {.lex_state = 47, .external_lex_state = 2},
  [1896] = {.lex_state = 9},
  [1897] = {.lex_state = 39},
  [1898] = {.lex_state = 51},
  [1899] = {.lex_state = 9},
  [1900] = {.lex_state = 45, .external_lex_state = 21},
  [1901] = {.lex_state = 45, .external_lex_state = 13},
  [1902] = {.lex_state = 44, .external_lex_state = 13},
  [1903] = {.lex_state = 44, .external_lex_state = 13},
  [1904] = {.lex_state = 48, .external_lex_state = 13},
  [1905] = {.lex_state = 45, .external_lex_state = 21},
  [1906] = {.lex_state = 45, .external_lex_state = 13},
  [1907] = {.lex_state = 39},
  [1908] = {.lex_state = 45, .external_lex_state = 13},
  [1909] = {.lex_state = 45, .external_lex_state = 13},
  [1910] = {.lex_state = 45, .external_lex_state = 21},
  [1911] = {.lex_state = 48, .external_lex_state = 13},
  [1912] = {.lex_state = 45, .external_lex_state = 21},
  [1913] = {.lex_state = 45, .external_lex_state = 13},
  [1914] = {.lex_state = 35, .external_lex_state = 20},
  [1915] = {.lex_state = 42, .external_lex_state = 13},
  [1916] = {.lex_state = 35, .external_lex_state = 13},
  [1917] = {.lex_state = 45, .external_lex_state = 13},
  [1918] = {.lex_state = 45, .external_lex_state = 13},
  [1919] = {.lex_state = 45, .external_lex_state = 13},
  [1920] = {.lex_state = 45, .external_lex_state = 13},
  [1921] = {.lex_state = 35, .external_lex_state = 20},
  [1922] = {.lex_state = 42, .external_lex_state = 13},
  [1923] = {.lex_state = 35, .external_lex_state = 13},
  [1924] = {.lex_state = 45, .external_lex_state = 13},
  [1925] = {.lex_state = 45, .external_lex_state = 13},
  [1926] = {.lex_state = 45, .external_lex_state = 13},
  [1927] = {.lex_state = 45, .external_lex_state = 13},
  [1928] = {.lex_state = 45, .external_lex_state = 13},
  [1929] = {.lex_state = 37},
  [1930] = {.lex_state = 51},
  [1931] = {.lex_state = 47},
  [1932] = {.lex_state = 9},
  [1933] = {.lex_state = 44, .external_lex_state = 13},
  [1934] = {.lex_state = 44, .external_lex_state = 13},
  [1935] = {.lex_state = 47, .external_lex_state = 2},
  [1936] = {.lex_state = 9},
  [1937] = {.lex_state = 39},
  [1938] = {.lex_state = 51},
  [1939] = {.lex_state = 9},
  [1940] = {.lex_state = 45, .external_lex_state = 21},
  [1941] = {.lex_state = 45, .external_lex_state = 13},
  [1942] = {.lex_state = 44, .external_lex_state = 13},
  [1943] = {.lex_state = 44, .external_lex_state = 13},
  [1944] = {.lex_state = 48, .external_lex_state = 13},
  [1945] = {.lex_state = 45, .external_lex_state = 21},
  [1946] = {.lex_state = 45, .external_lex_state = 13},
  [1947] = {.lex_state = 39},
  [1948] = {.lex_state = 45, .external_lex_state = 13},
  [1949] = {.lex_state = 45, .external_lex_state = 13},
  [1950] = {.lex_state = 45, .external_lex_state = 21},
  [1951] = {.lex_state = 48, .external_lex_state = 13},
  [1952] = {.lex_state = 45, .external_lex_state = 21},
  [1953] = {.lex_state = 45, .external_lex_state = 13},
  [1954] = {.lex_state = 35, .external_lex_state = 20},
  [1955] = {.lex_state = 42, .external_lex_state = 13},
  [1956] = {.lex_state = 35, .external_lex_state = 13},
  [1957] = {.lex_state = 45, .external_lex_state = 13},
  [1958] = {.lex_state = 45, .external_lex_state = 13},
  [1959] = {.lex_state = 45, .external_lex_state = 13},
  [1960] = {.lex_state = 45, .external_lex_state = 13},
  [1961] = {.lex_state = 35, .external_lex_state = 20},
  [1962] = {.lex_state = 42, .external_lex_state = 13},
  [1963] = {.lex_state = 35, .external_lex_state = 13},
  [1964] = {.lex_state = 45, .external_lex_state = 13},
  [1965] = {.lex_state = 45, .external_lex_state = 13},
  [1966] = {.lex_state = 45, .external_lex_state = 13},
  [1967] = {.lex_state = 45, .external_lex_state = 13},
  [1968] = {.lex_state = 45, .external_lex_state = 13},
  [1969] = {.lex_state = 37},
  [1970] = {.lex_state = 51},
  [1971] = {.lex_state = 47},
  [1972] = {.lex_state = 9},
  [1973] = {.lex_state = 44, .external_lex_state = 13},
  [1974] = {.lex_state = 44, .external_lex_state = 13},
  [1975] = {.lex_state = 47, .external_lex_state = 2},
  [1976] = {.lex_state = 9},
  [1977] = {.lex_state = 39},
  [1978] = {.lex_state = 51},
  [1979] = {.lex_state = 9},
  [1980] = {.lex_state = 45, .external_lex_state = 21},
  [1981] = {.lex_state = 45, .external_lex_state = 13},
  [1982] = {.lex_state = 44, .external_lex_state = 13},
  [1983] = {.lex_state = 44, .external_lex_state = 13},
  [1984] = {.lex_state = 48, .external_lex_state = 13},
  [1985] = {.lex_state = 45, .external_lex_state = 21},
  [1986] = {.lex_state = 45, .external_lex_state = 13},
  [1987] = {.lex_state = 39},
  [1988] = {.lex_state = 45, .external_lex_state = 13},
  [1989] = {.lex_state = 45, .external_lex_state = 13},
  [1990] = {.lex_state = 45, .external_lex_state = 21},
  [1991] = {.lex_state = 48, .external_lex_state = 13},
  [1992] = {.lex_state = 45, .external_lex_state = 21},
  [1993] = {.lex_state = 45, .external_lex_state = 13},
  [1994] = {.lex_state = 35, .external_lex_state = 20},
  [1995] = {.lex_state = 42, .external_lex_state = 13},
  [1996] = {.lex_state = 35, .external_lex_state = 13},
  [1997] = {.lex_state = 45, .external_lex_state = 13},
  [1998] = {.lex_state = 45, .external_lex_state = 13},
  [1999] = {.lex_state = 45, .external_lex_state = 13},
  [2000] = {.lex_state = 45, .external_lex_state = 13},
  [2001] = {.lex_state = 35, .external_lex_state = 20},
  [2002] = {.lex_state = 42, .external_lex_state = 13},
  [2003] = {.lex_state = 35, .external_lex_state = 13},
  [2004] = {.lex_state = 45, .external_lex_state = 13},
  [2005] = {.lex_state = 45, .external_lex_state = 13},
  [2006] = {.lex_state = 45, .external_lex_state = 13},
  [2007] = {.lex_state = 45, .external_lex_state = 13},
  [2008] = {.lex_state = 45, .external_lex_state = 13},
  [2009] = {.lex_state = 37},
  [2010] = {.lex_state = 51},
  [2011] = {.lex_state = 47},
  [2012] = {.lex_state = 9},
  [2013] = {.lex_state = 44, .external_lex_state = 13},
  [2014] = {.lex_state = 44, .external_lex_state = 13},
  [2015] = {.lex_state = 47, .external_lex_state = 2},
  [2016] = {.lex_state = 9},
  [2017] = {.lex_state = 39},
  [2018] = {.lex_state = 51},
  [2019] = {.lex_state = 9},
  [2020] = {.lex_state = 45, .external_lex_state = 21},
  [2021] = {.lex_state = 45, .external_lex_state = 13},
  [2022] = {.lex_state = 44, .external_lex_state = 13},
  [2023] = {.lex_state = 44, .external_lex_state = 13},
  [2024] = {.lex_state = 48, .external_lex_state = 13},
  [2025] = {.lex_state = 45, .external_lex_state = 21},
  [2026] = {.lex_state = 45, .external_lex_state = 13},
  [2027] = {.lex_state = 39},
  [2028] = {.lex_state = 45, .external_lex_state = 13},
  [2029] = {.lex_state = 45, .external_lex_state = 13},
  [2030] = {.lex_state = 45, .external_lex_state = 21},
  [2031] = {.lex_state = 48, .external_lex_state = 13},
  [2032] = {.lex_state = 45, .external_lex_state = 21},
  [2033] = {.lex_state = 45, .external_lex_state = 13},
  [2034] = {.lex_state = 35, .external_lex_state = 20},
  [2035] = {.lex_state = 42, .external_lex_state = 13},
  [2036] = {.lex_state = 35, .external_lex_state = 13},
  [2037] = {.lex_state = 45, .external_lex_state = 13},
  [2038] = {.lex_state = 45, .external_lex_state = 13},
  [2039] = {.lex_state = 45, .external_lex_state = 13},
  [2040] = {.lex_state = 45, .external_lex_state = 13},
  [2041] = {.lex_state = 35, .external_lex_state = 20},
  [2042] = {.lex_state = 42, .external_lex_state = 13},
  [2043] = {.lex_state = 35, .external_lex_state = 13},
  [2044] = {.lex_state = 45, .external_lex_state = 13},
  [2045] = {.lex_state = 45, .external_lex_state = 13},
  [2046] = {.lex_state = 45, .external_lex_state = 13},
  [2047] = {.lex_state = 45, .external_lex_state = 13},
  [2048] = {.lex_state = 45, .external_lex_state = 13},
  [2049] = {.lex_state = 37},
  [2050] = {.lex_state = 51},
  [2051] = {.lex_state = 47},
  [2052] = {.lex_state = 9},
  [2053] = {.lex_state = 44, .external_lex_state = 13},
  [2054] = {.lex_state = 44, .external_lex_state = 13},
  [2055] = {.lex_state = 47, .external_lex_state = 2},
  [2056] = {.lex_state = 9},
  [2057] = {.lex_state = 39},
  [2058] = {.lex_state = 51},
  [2059] = {.lex_state = 9},
  [2060] = {.lex_state = 45, .external_lex_state = 21},
  [2061] = {.lex_state = 45, .external_lex_state = 13},
  [2062] = {.lex_state = 44, .external_lex_state = 13},
  [2063] = {.lex_state = 44, .external_lex_state = 13},
  [2064] = {.lex_state = 48, .external_lex_state = 13},
  [2065] = {.lex_state = 45, .external_lex_state = 21},
  [2066] = {.lex_state = 45, .external_lex_state = 13},
  [2067] = {.lex_state = 39},
  [2068] = {.lex_state = 45, .external_lex_state = 13},
  [2069] = {.lex_state = 45, .external_lex_state = 13},
  [2070] = {.lex_state = 45, .external_lex_state = 21},
  [2071] = {.lex_state = 48, .external_lex_state = 13},
  [2072] = {.lex_state = 45, .external_lex_state = 21},
  [2073] = {.lex_state = 45, .external_lex_state = 13},
  [2074] = {.lex_state = 35, .external_lex_state = 20},
  [2075] = {.lex_state = 42, .external_lex_state = 13},
  [2076] = {.lex_state = 35, .external_lex_state = 13},
  [2077] = {.lex_state = 45, .external_lex_state = 13},
  [2078] = {.lex_state = 45, .external_lex_state = 13},
  [2079] = {.lex_state = 45, .external_lex_state = 13},
  [2080] = {.lex_state = 45, .external_lex_state = 13},
  [2081] = {.lex_state = 35, .external_lex_state = 20},
  [2082] = {.lex_state = 42, .external_lex_state = 13},
  [2083] = {.lex_state = 35, .external_lex_state = 13},
  [2084] = {.lex_state = 45, .external_lex_state = 13},
  [2085] = {.lex_state = 45, .external_lex_state = 13},
  [2086] = {.lex_state = 45, .external_lex_state = 13},
  [2087] = {.lex_state = 45, .external_lex_state = 13},
  [2088] = {.lex_state = 45, .external_lex_state = 13},
  [2089] = {.lex_state = 37},
  [2090] = {.lex_state = 51},
  [2091] = {.lex_state = 47},
  [2092] = {.lex_state = 9},
  [2093] = {.lex_state = 44, .external_lex_state = 13},
  [2094] = {.lex_state = 44, .external_lex_state = 13},
  [2095] = {.lex_state = 47, .external_lex_state = 2},
  [2096] = {.lex_state = 9},
  [2097] = {.lex_state = 39},
  [2098] = {.lex_state = 51},
  [2099] = {.lex_state = 9},
  [2100] = {.lex_state = 45, .external_lex_state = 21},
  [2101] = {.lex_state = 45, .external_lex_state = 13},
  [2102] = {.lex_state = 44, .external_lex_state = 13},
  [2103] = {.lex_state = 44, .external_lex_state = 13},
  [2104] = {.lex_state = 48, .external_lex_state = 13},
  [2105] = {.lex_state = 45, .external_lex_state = 21},
  [2106] = {.lex_state = 45, .external_lex_state = 13},
  [2107] = {.lex_state = 39},
  [2108] = {.lex_state = 45, .external_lex_state = 13},
  [2109] = {.lex_state = 45, .external_lex_state = 13},
  [2110] = {.lex_state = 45, .external_lex_state = 21},
  [2111] = {.lex_state = 48, .external_lex_state = 13},
  [2112] = {.lex_state = 45, .external_lex_state = 21},
  [2113] = {.lex_state = 45, .external_lex_state = 13},
  [2114] = {.lex_state = 35, .external_lex_state = 20},
  [2115] = {.lex_state = 42, .external_lex_state = 13},
  [2116] = {.lex_state = 35, .external_lex_state = 13},
  [2117] = {.lex_state = 45, .external_lex_state = 13},
  [2118] = {.lex_state = 45, .external_lex_state = 13},
  [2119] = {.lex_state = 45, .external_lex_state = 13},
  [2120] = {.lex_state = 45, .external_lex_state = 13},
  [2121] = {.lex_state = 35, .external_lex_state = 20},
  [2122] = {.lex_state = 42, .external_lex_state = 13},
  [2123] = {.lex_state = 35, .external_lex_state = 13},
  [2124] = {.lex_state = 45, .external_lex_state = 13},
  [2125] = {.lex_state = 45, .external_lex_state = 13},
  [2126] = {.lex_state = 45, .external_lex_state = 13},
  [2127] = {.lex_state = 45, .external_lex_state = 13},
  [2128] = {.lex_state = 45, .external_lex_state = 13},
  [2129] = {.lex_state = 37},
  [2130] = {.lex_state = 51},
  [2131] = {.lex_state = 47},
  [2132] = {.lex_state = 9},
  [2133] = {.lex_state = 44, .external_lex_state = 13},
  [2134] = {.lex_state = 44, .external_lex_state = 13},
  [2135] = {.lex_state = 47, .external_lex_state = 2},
  [2136] = {.lex_state = 9},
  [2137] = {.lex_state = 39},
  [2138] = {.lex_state = 51},
  [2139] = {.lex_state = 9},
  [2140] = {.lex_state = 45, .external_lex_state = 21},
  [2141] = {.lex_state = 45, .external_lex_state = 13},
  [2142] = {.lex_state = 44, .external_lex_state = 13},
  [2143] = {.lex_state = 44, .external_lex_state = 13},
  [2144] = {.lex_state = 48, .external_lex_state = 13},
  [2145] = {.lex_state = 45, .external_lex_state = 21},
  [2146] = {.lex_state = 45, .external_lex_state = 13},
  [2147] = {.lex_state = 39},
  [2148] = {.lex_state = 45, .external_lex_state = 13},
  [2149] = {.lex_state = 45, .external_lex_state = 13},
  [2150] = {.lex_state = 45, .external_lex_state = 21},
  [2151] = {.lex_state = 48, .external_lex_state = 13},
  [2152] = {.lex_state = 45, .external_lex_state = 21},
  [2153] = {.lex_state = 45, .external_lex_state = 13},
  [2154] = {.lex_state = 35, .external_lex_state = 20},
  [2155] = {.lex_state = 42, .external_lex_state = 13},
  [2156] = {.lex_state = 35, .external_lex_state = 13},
  [2157] = {.lex_state = 45, .external_lex_state = 13},
  [2158] = {.lex_state = 45, .external_lex_state = 13},
  [2159] = {.lex_state = 45, .external_lex_state = 13},
  [2160] = {.lex_state = 45, .external_lex_state = 13},
  [2161] = {.lex_state = 35, .external_lex_state = 20},
  [2162] = {.lex_state = 42, .external_lex_state = 13},
  [2163] = {.lex_state = 35, .external_lex_state = 13},
  [2164] = {.lex_state = 45, .external_lex_state = 13},
  [2165] = {.lex_state = 45, .external_lex_state = 13},
  [2166] = {.lex_state = 45, .external_lex_state = 13},
  [2167] = {.lex_state = 45, .external_lex_state = 13},
  [2168] = {.lex_state = 45, .external_lex_state = 13},
  [2169] = {.lex_state = 37},
  [2170] = {.lex_state = 51},
  [2171] = {.lex_state = 47},
  [2172] = {.lex_state = 9},
  [2173] = {.lex_state = 44, .external_lex_state = 13},
  [2174] = {.lex_state = 44, .external_lex_state = 13},
  [2175] = {.lex_state = 47, .external_lex_state = 2},
  [2176] = {.lex_state = 9},
  [2177] = {.lex_state = 39},
  [2178] = {.lex_state = 51},
  [2179] = {.lex_state = 9},
  [2180] = {.lex_state = 45, .external_lex_state = 21},
  [2181] = {.lex_state = 45, .external_lex_state = 13},
  [2182] = {.lex_state = 44, .external_lex_state = 13},
  [2183] = {.lex_state = 44, .external_lex_state = 13},
  [2184] = {.lex_state = 48, .external_lex_state = 13},
  [2185] = {.lex_state = 45, .external_lex_state = 21},
  [2186] = {.lex_state = 45, .external_lex_state = 13},
  [2187] = {.lex_state = 39},
  [2188] = {.lex_state = 45, .external_lex_state = 13},
  [2189] = {.lex_state = 45, .external_lex_state = 13},
  [2190] = {.lex_state = 45, .external_lex_state = 21},
  [2191] = {.lex_state = 48, .external_lex_state = 13},
  [2192] = {.lex_state = 45, .external_lex_state = 21},
  [2193] = {.lex_state = 45, .external_lex_state = 13},
  [2194] = {.lex_state = 35, .external_lex_state = 20},
  [2195] = {.lex_state = 42, .external_lex_state = 13},
  [2196] = {.lex_state = 35, .external_lex_state = 13},
  [2197] = {.lex_state = 45, .external_lex_state = 13},
  [2198] = {.lex_state = 45, .external_lex_state = 13},
  [2199] = {.lex_state = 45, .external_lex_state = 13},
  [2200] = {.lex_state = 45, .external_lex_state = 13},
  [2201] = {.lex_state = 35, .external_lex_state = 20},
  [2202] = {.lex_state = 42, .external_lex_state = 13},
  [2203] = {.lex_state = 35, .external_lex_state = 13},
  [2204] = {.lex_state = 45, .external_lex_state = 13},
  [2205] = {.lex_state = 45, .external_lex_state = 13},
  [2206] = {.lex_state = 45, .external_lex_state = 13},
  [2207] = {.lex_state = 45, .external_lex_state = 13},
  [2208] = {.lex_state = 45, .external_lex_state = 13},
  [2209] = {.lex_state = 37},
  [2210] = {.lex_state = 51},
  [2211] = {.lex_state = 47},
  [2212] = {.lex_state = 9},
  [2213] = {.lex_state = 44, .external_lex_state = 13},
  [2214] = {.lex_state = 44, .external_lex_state = 13},
  [2215] = {.lex_state = 47, .external_lex_state = 2},
  [2216] = {.lex_state = 9},
  [2217] = {.lex_state = 39},
  [2218] = {.lex_state = 51},
  [2219] = {.lex_state = 9},
  [2220] = {.lex_state = 45, .external_lex_state = 21},
  [2221] = {.lex_state = 45, .external_lex_state = 13},
  [2222] = {.lex_state = 44, .external_lex_state = 13},
  [2223] = {.lex_state = 44, .external_lex_state = 13},
  [2224] = {.lex_state = 48, .external_lex_state = 13},
  [2225] = {.lex_state = 45, .external_lex_state = 21},
  [2226] = {.lex_state = 45, .external_lex_state = 13},
  [2227] = {.lex_state = 39},
  [2228] = {.lex_state = 45, .external_lex_state = 13},
  [2229] = {.lex_state = 45, .external_lex_state = 13},
  [2230] = {.lex_state = 45, .external_lex_state = 21},
  [2231] = {.lex_state = 48, .external_lex_state = 13},
  [2232] = {.lex_state = 45, .external_lex_state = 21},
  [2233] = {.lex_state = 45, .external_lex_state = 13},
  [2234] = {.lex_state = 35, .external_lex_state = 20},
  [2235] = {.lex_state = 42, .external_lex_state = 13},
  [2236] = {.lex_state = 35, .external_lex_state = 13},
  [2237] = {.lex_state = 45, .external_lex_state = 13},
  [2238] = {.lex_state = 45, .external_lex_state = 13},
  [2239] = {.lex_state = 45, .external_lex_state = 13},
  [2240] = {.lex_state = 45, .external_lex_state = 13},
  [2241] = {.lex_state = 35, .external_lex_state = 20},
  [2242] = {.lex_state = 42, .external_lex_state = 13},
  [2243] = {.lex_state = 35, .external_lex_state = 13},
  [2244] = {.lex_state = 45, .external_lex_state = 13},
  [2245] = {.lex_state = 45, .external_lex_state = 13},
  [2246] = {.lex_state = 45, .external_lex_state = 13},
  [2247] = {.lex_state = 45, .external_lex_state = 13},
  [2248] = {.lex_state = 45, .external_lex_state = 13},
  [2249] = {.lex_state = 37},
  [2250] = {.lex_state = 51},
  [2251] = {.lex_state = 47},
  [2252] = {.lex_state = 9},
  [2253] = {.lex_state = 44, .external_lex_state = 13},
  [2254] = {.lex_state = 44, .external_lex_state = 13},
  [2255] = {.lex_state = 47, .external_lex_state = 2},
  [2256] = {.lex_state = 9},
  [2257] = {.lex_state = 39},
  [2258] = {.lex_state = 51},
  [2259] = {.lex_state = 9},
  [2260] = {.lex_state = 45, .external_lex_state = 21},
  [2261] = {.lex_state = 45, .external_lex_state = 13},
  [2262] = {.lex_state = 44, .external_lex_state = 13},
  [2263] = {.lex_state = 44, .external_lex_state = 13},
  [2264] = {.lex_state = 48, .external_lex_state = 13},
  [2265] = {.lex_state = 45, .external_lex_state = 21},
  [2266] = {.lex_state = 45, .external_lex_state = 13},
  [2267] = {.lex_state = 39},
  [2268] = {.lex_state = 45, .external_lex_state = 13},
  [2269] = {.lex_state = 45, .external_lex_state = 13},
  [2270] = {.lex_state = 45, .external_lex_state = 21},
  [2271] = {.lex_state = 48, .external_lex_state = 13},
  [2272] = {.lex_state = 45, .external_lex_state = 21},
  [2273] = {.lex_state = 45, .external_lex_state = 13},
  [2274] = {.lex_state = 35, .external_lex_state = 20},
  [2275] = {.lex_state = 42, .external_lex_state = 13},
  [2276] = {.lex_state = 35, .external_lex_state = 13},
  [2277] = {.lex_state = 45, .external_lex_state = 13},
  [2278] = {.lex_state = 45, .external_lex_state = 13},
  [2279] = {.lex_state = 45, .external_lex_state = 13},
  [2280] = {.lex_state = 45, .external_lex_state = 13},
  [2281] = {.lex_state = 35, .external_lex_state = 20},
  [2282] = {.lex_state = 42, .external_lex_state = 13},
  [2283] = {.lex_state = 35, .external_lex_state = 13},
  [2284] = {.lex_state = 45, .external_lex_state = 13},
  [2285] = {.lex_state = 45, .external_lex_state = 13},
  [2286] = {.lex_state = 45, .external_lex_state = 13},
  [2287] = {.lex_state = 45, .external_lex_state = 13},
  [2288] = {.lex_state = 45, .external_lex_state = 13},
  [2289] = {.lex_state = 37},
  [2290] = {.lex_state = 51},
  [2291] = {.lex_state = 47},
  [2292] = {.lex_state = 9},
  [2293] = {.lex_state = 44, .external_lex_state = 13},
  [2294] = {.lex_state = 44, .external_lex_state = 13},
  [2295] = {.lex_state = 47, .external_lex_state = 2},
  [2296] = {.lex_state = 9},
  [2297] = {.lex_state = 39},
  [2298] = {.lex_state = 51},
  [2299] = {.lex_state = 9},
  [2300] = {.lex_state = 45, .external_lex_state = 21},
  [2301] = {.lex_state = 45, .external_lex_state = 13},
  [2302] = {.lex_state = 44, .external_lex_state = 13},
  [2303] = {.lex_state = 44, .external_lex_state = 13},
  [2304] = {.lex_state = 48, .external_lex_state = 13},
  [2305] = {.lex_state = 45, .external_lex_state = 21},
  [2306] = {.lex_state = 45, .external_lex_state = 13},
  [2307] = {.lex_state = 39},
  [2308] = {.lex_state = 45, .external_lex_state = 13},
  [2309] = {.lex_state = 45, .external_lex_state = 13},
  [2310] = {.lex_state = 45, .external_lex_state = 21},
  [2311] = {.lex_state = 48, .external_lex_state = 13},
  [2312] = {.lex_state = 45, .external_lex_state = 21},
  [2313] = {.lex_state = 45, .external_lex_state = 13},
  [2314] = {.lex_state = 35, .external_lex_state = 20},
  [2315] = {.lex_state = 42, .external_lex_state = 13},
  [2316] = {.lex_state = 35, .external_lex_state = 13},
  [2317] = {.lex_state = 45, .external_lex_state = 13},
  [2318] = {.lex_state = 45, .external_lex_state = 13},
  [2319] = {.lex_state = 45, .external_lex_state = 13},
  [2320] = {.lex_state = 45, .external_lex_state = 13},
  [2321] = {.lex_state = 35, .external_lex_state = 20},
  [2322] = {.lex_state = 42, .external_lex_state = 13},
  [2323] = {.lex_state = 35, .external_lex_state = 13},
  [2324] = {.lex_state = 45, .external_lex_state = 13},
  [2325] = {.lex_state = 45, .external_lex_state = 13},
  [2326] = {.lex_state = 45, .external_lex_state = 13},
  [2327] = {.lex_state = 45, .external_lex_state = 13},
  [2328] = {.lex_state = 45, .external_lex_state = 13},
  [2329] = {.lex_state = 44, .external_lex_state = 13},
  [2330] = {.lex_state = 44, .external_lex_state = 13},
  [2331] = {.lex_state = 47, .external_lex_state = 2},
  [2332] = {.lex_state = 9},
  [2333] = {.lex_state = 9},
  [2334] = {.lex_state = 45, .external_lex_state = 21},
  [2335] = {.lex_state = 45, .external_lex_state = 13},
  [2336] = {.lex_state = 44, .external_lex_state = 13},
  [2337] = {.lex_state = 44, .external_lex_state = 13},
  [2338] = {.lex_state = 48, .external_lex_state = 13},
  [2339] = {.lex_state = 45, .external_lex_state = 21},
  [2340] = {.lex_state = 45, .external_lex_state = 13},
  [2341] = {.lex_state = 45, .external_lex_state = 13},
  [2342] = {.lex_state = 45, .external_lex_state = 13},
  [2343] = {.lex_state = 45, .external_lex_state = 21},
  [2344] = {.lex_state = 48, .external_lex_state = 13},
  [2345] = {.lex_state = 45, .external_lex_state = 21},
  [2346] = {.lex_state = 45, .external_lex_state = 13},
  [2347] = {.lex_state = 35, .external_lex_state = 20},
  [2348] = {.lex_state = 42, .external_lex_state = 13},
  [2349] = {.lex_state = 35, .external_lex_state = 13},
  [2350] = {.lex_state = 45, .external_lex_state = 13},
  [2351] = {.lex_state = 45, .external_lex_state = 13},
  [2352] = {.lex_state = 45, .external_lex_state = 13},
  [2353] = {.lex_state = 45, .external_lex_state = 13},
  [2354] = {.lex_state = 35, .external_lex_state = 20},
  [2355] = {.lex_state = 42, .external_lex_state = 13},
  [2356] = {.lex_state = 35, .external_lex_state = 13},
  [2357] = {.lex_state = 45, .external_lex_state = 13},
  [2358] = {.lex_state = 45, .external_lex_state = 13},
  [2359] = {.lex_state = 45, .external_lex_state = 13},
  [2360] = {.lex_state = 45, .external_lex_state = 13},
  [2361] = {.lex_state = 45, .external_lex_state = 13},
  [2362] = {.lex_state = 44, .external_lex_state = 13},
  [2363] = {.lex_state = 44, .external_lex_state = 13},
  [2364] = {.lex_state = 47, .external_lex_state = 2},
  [2365] = {.lex_state = 9},
  [2366] = {.lex_state = 9},
  [2367] = {.lex_state = 45, .external_lex_state = 21},
  [2368] = {.lex_state = 45, .external_lex_state = 13},
  [2369] = {.lex_state = 44, .external_lex_state = 13},
  [2370] = {.lex_state = 44, .external_lex_state = 13},
  [2371] = {.lex_state = 48, .external_lex_state = 13},
  [2372] = {.lex_state = 45, .external_lex_state = 21},
  [2373] = {.lex_state = 45, .external_lex_state = 13},
  [2374] = {.lex_state = 45, .external_lex_state = 13},
  [2375] = {.lex_state = 45, .external_lex_state = 13},
  [2376] = {.lex_state = 45, .external_lex_state = 21},
  [2377] = {.lex_state = 48, .external_lex_state = 13},
  [2378] = {.lex_state = 45, .external_lex_state = 21},
  [2379] = {.lex_state = 45, .external_lex_state = 13},
  [2380] = {.lex_state = 35, .external_lex_state = 20},
  [2381] = {.lex_state = 42, .external_lex_state = 13},
  [2382] = {.lex_state = 35, .external_lex_state = 13},
  [2383] = {.lex_state = 45, .external_lex_state = 13},
  [2384] = {.lex_state = 45, .external_lex_state = 13},
  [2385] = {.lex_state = 45, .external_lex_state = 13},
  [2386] = {.lex_state = 45, .external_lex_state = 13},
  [2387] = {.lex_state = 35, .external_lex_state = 20},
  [2388] = {.lex_state = 42, .external_lex_state = 13},
  [2389] = {.lex_state = 35, .external_lex_state = 13},
  [2390] = {.lex_state = 45, .external_lex_state = 13},
  [2391] = {.lex_state = 45, .external_lex_state = 13},
  [2392] = {.lex_state = 45, .external_lex_state = 13},
  [2393] = {.lex_state = 45, .external_lex_state = 13},
  [2394] = {.lex_state = 45, .external_lex_state = 13},
  [2395] = {.lex_state = 9, .external_lex_state = 2},
  [2396] = {.lex_state = 9, .external_lex_state = 2},
  [2397] = {.lex_state = 47},
  [2398] = {.lex_state = 36},
  [2399] = {.lex_state = 37, .external_lex_state = 7},
  [2400] = {.lex_state = 52},
  [2401] = {.lex_state = 52},
  [2402] = {.lex_state = 9, .external_lex_state = 2},
  [2403] = {.lex_state = 9, .external_lex_state = 2},
  [2404] = {.lex_state = 9, .external_lex_state = 2},
  [2405] = {.lex_state = 36},
  [2406] = {.lex_state = 36},
  [2407] = {.lex_state = 52},
  [2408] = {.lex_state = 9},
  [2409] = {.lex_state = 47},
  [2410] = {.lex_state = 36},
  [2411] = {.lex_state = 40, .external_lex_state = 7},
  [2412] = {.lex_state = 52},
  [2413] = {.lex_state = 47},
  [2414] = {.lex_state = 4, .external_lex_state = 11},
  [2415] = {.lex_state = 9},
  [2416] = {.lex_state = 4, .external_lex_state = 11},
  [2417] = {.lex_state = 4, .external_lex_state = 11},
  [2418] = {.lex_state = 52},
  [2419] = {.lex_state = 4, .external_lex_state = 11},
  [2420] = {.lex_state = 4, .external_lex_state = 11},
  [2421] = {.lex_state = 22, .external_lex_state = 11},
  [2422] = {.lex_state = 36},
  [2423] = {.lex_state = 47},
  [2424] = {.lex_state = 47},
  [2425] = {.lex_state = 43},
  [2426] = {.lex_state = 36},
  [2427] = {.lex_state = 47},
  [2428] = {.lex_state = 47},
  [2429] = {.lex_state = 43},
  [2430] = {.lex_state = 36},
  [2431] = {.lex_state = 43},
  [2432] = {.lex_state = 52, .external_lex_state = 22},
  [2433] = {.lex_state = 3, .external_lex_state = 3},
  [2434] = {.lex_state = 3, .external_lex_state = 3},
  [2435] = {.lex_state = 47},
  [2436] = {.lex_state = 47},
  [2437] = {.lex_state = 47},
  [2438] = {.lex_state = 9, .external_lex_state = 2},
  [2439] = {.lex_state = 37, .external_lex_state = 7},
  [2440] = {.lex_state = 52},
  [2441] = {.lex_state = 52},
  [2442] = {.lex_state = 9, .external_lex_state = 2},
  [2443] = {.lex_state = 9, .external_lex_state = 2},
  [2444] = {.lex_state = 52},
  [2445] = {.lex_state = 36},
  [2446] = {.lex_state = 40, .external_lex_state = 7},
  [2447] = {.lex_state = 52},
  [2448] = {.lex_state = 52},
  [2449] = {.lex_state = 9, .external_lex_state = 2},
  [2450] = {.lex_state = 37, .external_lex_state = 7},
  [2451] = {.lex_state = 52},
  [2452] = {.lex_state = 52},
  [2453] = {.lex_state = 9, .external_lex_state = 2},
  [2454] = {.lex_state = 9, .external_lex_state = 2},
  [2455] = {.lex_state = 52},
  [2456] = {.lex_state = 40, .external_lex_state = 7},
  [2457] = {.lex_state = 52},
  [2458] = {.lex_state = 52},
  [2459] = {.lex_state = 9, .external_lex_state = 2},
  [2460] = {.lex_state = 37, .external_lex_state = 7},
  [2461] = {.lex_state = 52},
  [2462] = {.lex_state = 9, .external_lex_state = 2},
  [2463] = {.lex_state = 9, .external_lex_state = 2},
  [2464] = {.lex_state = 52},
  [2465] = {.lex_state = 40, .external_lex_state = 7},
  [2466] = {.lex_state = 52},
  [2467] = {.lex_state = 52},
  [2468] = {.lex_state = 9, .external_lex_state = 2},
  [2469] = {.lex_state = 37, .external_lex_state = 7},
  [2470] = {.lex_state = 52},
  [2471] = {.lex_state = 9, .external_lex_state = 2},
  [2472] = {.lex_state = 9, .external_lex_state = 2},
  [2473] = {.lex_state = 52},
  [2474] = {.lex_state = 40, .external_lex_state = 7},
  [2475] = {.lex_state = 52},
  [2476] = {.lex_state = 52},
  [2477] = {.lex_state = 9, .external_lex_state = 2},
  [2478] = {.lex_state = 37, .external_lex_state = 7},
  [2479] = {.lex_state = 52},
  [2480] = {.lex_state = 9, .external_lex_state = 2},
  [2481] = {.lex_state = 9, .external_lex_state = 2},
  [2482] = {.lex_state = 52},
  [2483] = {.lex_state = 40, .external_lex_state = 7},
  [2484] = {.lex_state = 52},
  [2485] = {.lex_state = 52},
  [2486] = {.lex_state = 9, .external_lex_state = 2},
  [2487] = {.lex_state = 37, .external_lex_state = 7},
  [2488] = {.lex_state = 9, .external_lex_state = 2},
  [2489] = {.lex_state = 9, .external_lex_state = 2},
  [2490] = {.lex_state = 40, .external_lex_state = 7},
  [2491] = {.lex_state = 52},
  [2492] = {.lex_state = 52},
  [2493] = {.lex_state = 9, .external_lex_state = 2},
  [2494] = {.lex_state = 37, .external_lex_state = 7},
  [2495] = {.lex_state = 9, .external_lex_state = 2},
  [2496] = {.lex_state = 9, .external_lex_state = 2},
  [2497] = {.lex_state = 40, .external_lex_state = 7},
  [2498] = {.lex_state = 52},
  [2499] = {.lex_state = 52},
  [2500] = {.lex_state = 9, .external_lex_state = 2},
  [2501] = {.lex_state = 37, .external_lex_state = 7},
  [2502] = {.lex_state = 9, .external_lex_state = 2},
  [2503] = {.lex_state = 9, .external_lex_state = 2},
  [2504] = {.lex_state = 40, .external_lex_state = 7},
  [2505] = {.lex_state = 52},
  [2506] = {.lex_state = 52},
  [2507] = {.lex_state = 9, .external_lex_state = 2},
  [2508] = {.lex_state = 37, .external_lex_state = 7},
  [2509] = {.lex_state = 9, .external_lex_state = 2},
  [2510] = {.lex_state = 9, .external_lex_state = 2},
  [2511] = {.lex_state = 40, .external_lex_state = 7},
  [2512] = {.lex_state = 52},
  [2513] = {.lex_state = 52},
  [2514] = {.lex_state = 9, .external_lex_state = 2},
  [2515] = {.lex_state = 37, .external_lex_state = 7},
  [2516] = {.lex_state = 9, .external_lex_state = 2},
  [2517] = {.lex_state = 9, .external_lex_state = 2},
  [2518] = {.lex_state = 40, .external_lex_state = 7},
  [2519] = {.lex_state = 52},
  [2520] = {.lex_state = 52},
  [2521] = {.lex_state = 9, .external_lex_state = 2},
  [2522] = {.lex_state = 37, .external_lex_state = 7},
  [2523] = {.lex_state = 9, .external_lex_state = 2},
  [2524] = {.lex_state = 9, .external_lex_state = 2},
  [2525] = {.lex_state = 40, .external_lex_state = 7},
  [2526] = {.lex_state = 52},
  [2527] = {.lex_state = 52},
  [2528] = {.lex_state = 9, .external_lex_state = 2},
  [2529] = {.lex_state = 37, .external_lex_state = 7},
  [2530] = {.lex_state = 9, .external_lex_state = 2},
  [2531] = {.lex_state = 9, .external_lex_state = 2},
  [2532] = {.lex_state = 40, .external_lex_state = 7},
  [2533] = {.lex_state = 52},
  [2534] = {.lex_state = 52},
  [2535] = {.lex_state = 9, .external_lex_state = 2},
  [2536] = {.lex_state = 37, .external_lex_state = 7},
  [2537] = {.lex_state = 9, .external_lex_state = 2},
  [2538] = {.lex_state = 9, .external_lex_state = 2},
  [2539] = {.lex_state = 40, .external_lex_state = 7},
  [2540] = {.lex_state = 52},
  [2541] = {.lex_state = 52},
  [2542] = {.lex_state = 9, .external_lex_state = 2},
  [2543] = {.lex_state = 37, .external_lex_state = 7},
  [2544] = {.lex_state = 9, .external_lex_state = 2},
  [2545] = {.lex_state = 9, .external_lex_state = 2},
  [2546] = {.lex_state = 40, .external_lex_state = 7},
  [2547] = {.lex_state = 52},
  [2548] = {.lex_state = 52},
  [2549] = {.lex_state = 9, .external_lex_state = 2},
  [2550] = {.lex_state = 37, .external_lex_state = 7},
  [2551] = {.lex_state = 9, .external_lex_state = 2},
  [2552] = {.lex_state = 9, .external_lex_state = 2},
  [2553] = {.lex_state = 40, .external_lex_state = 7},
  [2554] = {.lex_state = 52},
  [2555] = {.lex_state = 52},
  [2556] = {.lex_state = 9, .external_lex_state = 2},
  [2557] = {.lex_state = 37, .external_lex_state = 7},
  [2558] = {.lex_state = 9, .external_lex_state = 2},
  [2559] = {.lex_state = 9, .external_lex_state = 2},
  [2560] = {.lex_state = 40, .external_lex_state = 7},
  [2561] = {.lex_state = 52},
  [2562] = {.lex_state = 52},
  [2563] = {.lex_state = 9, .external_lex_state = 2},
  [2564] = {.lex_state = 37, .external_lex_state = 7},
  [2565] = {.lex_state = 9, .external_lex_state = 2},
  [2566] = {.lex_state = 9, .external_lex_state = 2},
  [2567] = {.lex_state = 40, .external_lex_state = 7},
  [2568] = {.lex_state = 52},
  [2569] = {.lex_state = 52},
  [2570] = {.lex_state = 9, .external_lex_state = 2},
  [2571] = {.lex_state = 37, .external_lex_state = 7},
  [2572] = {.lex_state = 9, .external_lex_state = 2},
  [2573] = {.lex_state = 9, .external_lex_state = 2},
  [2574] = {.lex_state = 40, .external_lex_state = 7},
  [2575] = {.lex_state = 52},
  [2576] = {.lex_state = 52},
  [2577] = {.lex_state = 9, .external_lex_state = 2},
  [2578] = {.lex_state = 37, .external_lex_state = 7},
  [2579] = {.lex_state = 9, .external_lex_state = 2},
  [2580] = {.lex_state = 9, .external_lex_state = 2},
  [2581] = {.lex_state = 40, .external_lex_state = 7},
  [2582] = {.lex_state = 52},
  [2583] = {.lex_state = 52},
  [2584] = {.lex_state = 9, .external_lex_state = 2},
  [2585] = {.lex_state = 37, .external_lex_state = 7},
  [2586] = {.lex_state = 9, .external_lex_state = 2},
  [2587] = {.lex_state = 9, .external_lex_state = 2},
  [2588] = {.lex_state = 40, .external_lex_state = 7},
  [2589] = {.lex_state = 52},
  [2590] = {.lex_state = 52},
  [2591] = {.lex_state = 9, .external_lex_state = 2},
  [2592] = {.lex_state = 37, .external_lex_state = 7},
  [2593] = {.lex_state = 9, .external_lex_state = 2},
  [2594] = {.lex_state = 9, .external_lex_state = 2},
  [2595] = {.lex_state = 40, .external_lex_state = 7},
  [2596] = {.lex_state = 52},
  [2597] = {.lex_state = 52},
  [2598] = {.lex_state = 37, .external_lex_state = 7},
  [2599] = {.lex_state = 9, .external_lex_state = 2},
  [2600] = {.lex_state = 9, .external_lex_state = 2},
  [2601] = {.lex_state = 40, .external_lex_state = 7},
  [2602] = {.lex_state = 52},
  [2603] = {.lex_state = 52},
  [2604] = {.lex_state = 37, .external_lex_state = 7},
  [2605] = {.lex_state = 9, .external_lex_state = 2},
  [2606] = {.lex_state = 9, .external_lex_state = 2},
  [2607] = {.lex_state = 40, .external_lex_state = 7},
  [2608] = {.lex_state = 52},
  [2609] = {.lex_state = 52},
  [2610] = {.lex_state = 9, .external_lex_state = 2},
  [2611] = {.lex_state = 52},
  [2612] = {.lex_state = 4, .external_lex_state = 10},
  [2613] = {.lex_state = 4, .external_lex_state = 11},
  [2614] = {.lex_state = 4, .external_lex_state = 11},
  [2615] = {.lex_state = 41},
  [2616] = {.lex_state = 41},
  [2617] = {.lex_state = 47},
  [2618] = {.lex_state = 16, .external_lex_state = 11},
  [2619] = {.lex_state = 18, .external_lex_state = 11},
  [2620] = {.lex_state = 16, .external_lex_state = 11},
  [2621] = {.lex_state = 18, .external_lex_state = 11},
  [2622] = {.lex_state = 3, .external_lex_state = 5},
  [2623] = {.lex_state = 3, .external_lex_state = 5},
  [2624] = {.lex_state = 3, .external_lex_state = 3},
  [2625] = {.lex_state = 3, .external_lex_state = 5},
  [2626] = {.lex_state = 3, .external_lex_state = 3},
  [2627] = {.lex_state = 3, .external_lex_state = 3},
  [2628] = {.lex_state = 47},
  [2629] = {.lex_state = 16, .external_lex_state = 11},
  [2630] = {.lex_state = 18, .external_lex_state = 11},
};

enum {
  ts_external_token_heredoc_start = 0,
  ts_external_token__simple_heredoc_body = 1,
  ts_external_token__heredoc_body_beginning = 2,
  ts_external_token__heredoc_body_middle = 3,
  ts_external_token__heredoc_body_end = 4,
  ts_external_token_file_descriptor = 5,
  ts_external_token__empty_value = 6,
  ts_external_token__concat = 7,
  ts_external_token_variable_name = 8,
  ts_external_token_regex = 9,
  ts_external_token_RBRACE = 10,
  ts_external_token_RBRACK = 11,
  ts_external_token_LT_LT = 12,
  ts_external_token_LT_LT_DASH = 13,
  ts_external_token_LF = 14,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_heredoc_start] = sym_heredoc_start,
  [ts_external_token__simple_heredoc_body] = sym__simple_heredoc_body,
  [ts_external_token__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [ts_external_token__heredoc_body_middle] = sym__heredoc_body_middle,
  [ts_external_token__heredoc_body_end] = sym__heredoc_body_end,
  [ts_external_token_file_descriptor] = sym_file_descriptor,
  [ts_external_token__empty_value] = sym__empty_value,
  [ts_external_token__concat] = sym__concat,
  [ts_external_token_variable_name] = sym_variable_name,
  [ts_external_token_regex] = sym_regex,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_LT_LT] = anon_sym_LT_LT,
  [ts_external_token_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [ts_external_token_LF] = anon_sym_LF,
};

static bool ts_external_scanner_states[24][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_heredoc_start] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token__concat] = true,
    [ts_external_token__heredoc_body_end] = true,
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_regex] = true,
    [ts_external_token__empty_value] = true,
    [ts_external_token__heredoc_body_middle] = true,
  },
  [2] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_file_descriptor] = true,
  },
  [3] = {
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LF] = true,
  },
  [4] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LF] = true,
  },
  [5] = {
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LF] = true,
  },
  [6] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_RBRACE] = true,
  },
  [7] = {
    [ts_external_token_variable_name] = true,
  },
  [8] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
  },
  [9] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LF] = true,
  },
  [10] = {
    [ts_external_token_LF] = true,
    [ts_external_token__concat] = true,
  },
  [11] = {
    [ts_external_token_LF] = true,
  },
  [12] = {
    [ts_external_token__concat] = true,
  },
  [13] = {
    [ts_external_token_RBRACE] = true,
  },
  [14] = {
    [ts_external_token__empty_value] = true,
  },
  [15] = {
    [ts_external_token_RBRACK] = true,
  },
  [16] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token__simple_heredoc_body] = true,
  },
  [17] = {
    [ts_external_token_heredoc_start] = true,
  },
  [18] = {
    [ts_external_token_regex] = true,
  },
  [19] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token__simple_heredoc_body] = true,
  },
  [20] = {
    [ts_external_token_RBRACE] = true,
    [ts_external_token__concat] = true,
  },
  [21] = {
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
  },
  [22] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACK] = true,
  },
  [23] = {
    [ts_external_token__heredoc_body_end] = true,
    [ts_external_token__heredoc_body_middle] = true,
  },
};

static uint16_t ts_parse_table[STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_word] = ACTIONS(1),
    [sym_heredoc_start] = ACTIONS(1),
    [anon_sym_AMP_GT_GT] = ACTIONS(1),
    [sym__empty_value] = ACTIONS(1),
    [anon_sym_typeset] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LT_LPAREN] = ACTIONS(1),
    [anon_sym_done] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_COLON_DASH] = ACTIONS(1),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [sym_test_operator] = ACTIONS(1),
    [sym__simple_heredoc_body] = ACTIONS(1),
    [anon_sym_LT_AMP] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [sym__special_character] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1),
    [sym_raw_string] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [sym_variable_name] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [sym__heredoc_body_beginning] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_unset] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_GT_AMP] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [sym_ansii_c_string] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [sym_regex] = ACTIONS(1),
    [anon_sym_SEMI_SEMI] = ACTIONS(1),
    [sym__heredoc_body_middle] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_unsetenv] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_fi] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [sym__heredoc_body_end] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [sym_file_descriptor] = ACTIONS(1),
    [anon_sym_AMP_GT] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LT_LT_LT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_esac] = ACTIONS(1),
    [anon_sym_GT_LPAREN] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_COLON_QMARK] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [anon_sym_PIPE_AMP] = ACTIONS(1),
  },
  [1] = {
    [aux_sym__literal_repeat1] = STATE(27),
    [sym_if_statement] = STATE(28),
    [sym_function_definition] = STATE(28),
    [sym_negated_command] = STATE(28),
    [sym_test_command] = STATE(28),
    [sym_variable_assignment] = STATE(29),
    [sym_subscript] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_expansion] = STATE(15),
    [sym_command_substitution] = STATE(15),
    [aux_sym__statements_repeat1] = STATE(32),
    [sym_program] = STATE(33),
    [sym_redirected_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_compound_statement] = STATE(28),
    [sym_subshell] = STATE(28),
    [sym_declaration_command] = STATE(28),
    [sym_unset_command] = STATE(28),
    [sym_file_redirect] = STATE(34),
    [sym_string] = STATE(15),
    [sym_process_substitution] = STATE(15),
    [aux_sym_command_repeat1] = STATE(34),
    [sym__statements] = STATE(35),
    [sym_c_style_for_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_case_statement] = STATE(28),
    [sym_pipeline] = STATE(28),
    [sym_list] = STATE(28),
    [sym_command] = STATE(28),
    [sym_command_name] = STATE(36),
    [sym_simple_expansion] = STATE(15),
    [sym_string_expansion] = STATE(15),
    [sym_word] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(11),
    [anon_sym_typeset] = ACTIONS(11),
    [anon_sym_unsetenv] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LT_LPAREN] = ACTIONS(17),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [sym__special_character] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(33),
    [sym_raw_string] = ACTIONS(35),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_declare] = ACTIONS(11),
    [sym_variable_name] = ACTIONS(41),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(45),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(11),
    [anon_sym_unset] = ACTIONS(13),
    [ts_builtin_sym_end] = ACTIONS(47),
    [anon_sym_DQUOTE] = ACTIONS(49),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_ansii_c_string] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(59),
  },
  [2] = {
    [aux_sym_concatenation_repeat1] = STATE(39),
    [sym_word] = ACTIONS(61),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_AMP_GT_GT] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_LT_LT] = ACTIONS(61),
    [anon_sym_LT_LPAREN] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [sym__concat] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_LT_AMP] = ACTIONS(61),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_EQ_TILDE] = ACTIONS(61),
    [sym__special_character] = ACTIONS(61),
    [anon_sym_LT_LT_DASH] = ACTIONS(61),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(61),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(61),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(61),
    [sym_raw_string] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [anon_sym_AMP_GT] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_LT_LT_LT] = ACTIONS(61),
    [anon_sym_GT_AMP] = ACTIONS(61),
    [ts_builtin_sym_end] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(61),
    [anon_sym_GT_LPAREN] = ACTIONS(61),
    [sym_ansii_c_string] = ACTIONS(61),
    [anon_sym_AMP_AMP] = ACTIONS(61),
    [anon_sym_SEMI_SEMI] = ACTIONS(61),
    [anon_sym_PIPE_AMP] = ACTIONS(61),
  },
  [3] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(387),
    [sym_function_definition] = STATE(387),
    [sym_negated_command] = STATE(387),
    [sym_test_command] = STATE(387),
    [sym_variable_assignment] = STATE(388),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(390),
    [sym_redirected_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_compound_statement] = STATE(387),
    [sym_subshell] = STATE(387),
    [sym_declaration_command] = STATE(387),
    [sym_unset_command] = STATE(387),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym__statements] = STATE(40),
    [sym_c_style_for_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_case_statement] = STATE(387),
    [sym_pipeline] = STATE(387),
    [sym_list] = STATE(387),
    [sym_command] = STATE(387),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [4] = {
    [sym_command_substitution] = STATE(41),
    [aux_sym__literal_repeat1] = STATE(42),
    [sym_string] = STATE(41),
    [sym_process_substitution] = STATE(41),
    [sym_simple_expansion] = STATE(41),
    [sym_string_expansion] = STATE(41),
    [sym_concatenation] = STATE(43),
    [sym_expansion] = STATE(41),
    [sym_word] = ACTIONS(115),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(117),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(119),
    [sym_raw_string] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(121),
    [anon_sym_LT_LPAREN] = ACTIONS(123),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(123),
    [sym_ansii_c_string] = ACTIONS(115),
    [sym__special_character] = ACTIONS(129),
  },
  [5] = {
    [sym_command_substitution] = STATE(44),
    [aux_sym__literal_repeat1] = STATE(45),
    [sym_string] = STATE(44),
    [aux_sym_declaration_command_repeat1] = STATE(46),
    [sym_process_substitution] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_subscript] = STATE(2444),
    [sym_string_expansion] = STATE(44),
    [sym_variable_assignment] = STATE(46),
    [sym_concatenation] = STATE(46),
    [sym_expansion] = STATE(44),
    [sym_word] = ACTIONS(131),
    [anon_sym_AMP_GT_GT] = ACTIONS(133),
    [anon_sym_DOLLAR] = ACTIONS(135),
    [anon_sym_LT_LT] = ACTIONS(133),
    [anon_sym_LT_LPAREN] = ACTIONS(137),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(133),
    [anon_sym_PIPE] = ACTIONS(133),
    [anon_sym_LT] = ACTIONS(133),
    [anon_sym_LT_AMP] = ACTIONS(133),
    [anon_sym_GT_GT] = ACTIONS(133),
    [sym__special_character] = ACTIONS(139),
    [anon_sym_LT_LT_DASH] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(141),
    [aux_sym__simple_variable_name_token1] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(147),
    [anon_sym_SEMI] = ACTIONS(133),
    [sym_raw_string] = ACTIONS(131),
    [sym_variable_name] = ACTIONS(149),
    [sym_file_descriptor] = ACTIONS(147),
    [anon_sym_AMP] = ACTIONS(133),
    [anon_sym_GT] = ACTIONS(133),
    [anon_sym_AMP_GT] = ACTIONS(133),
    [ts_builtin_sym_end] = ACTIONS(147),
    [anon_sym_LT_LT_LT] = ACTIONS(133),
    [anon_sym_GT_AMP] = ACTIONS(133),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [anon_sym_BQUOTE] = ACTIONS(153),
    [anon_sym_GT_LPAREN] = ACTIONS(137),
    [sym_ansii_c_string] = ACTIONS(131),
    [anon_sym_AMP_AMP] = ACTIONS(133),
    [anon_sym_SEMI_SEMI] = ACTIONS(133),
    [anon_sym_PIPE_AMP] = ACTIONS(133),
  },
  [6] = {
    [sym_command_substitution] = STATE(47),
    [aux_sym__literal_repeat1] = STATE(48),
    [sym_string] = STATE(47),
    [aux_sym_unset_command_repeat1] = STATE(49),
    [sym_process_substitution] = STATE(47),
    [sym_simple_expansion] = STATE(47),
    [sym_string_expansion] = STATE(47),
    [sym_concatenation] = STATE(49),
    [sym_expansion] = STATE(47),
    [sym_word] = ACTIONS(155),
    [anon_sym_AMP_GT_GT] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [anon_sym_LT_LT] = ACTIONS(157),
    [anon_sym_LT_LPAREN] = ACTIONS(161),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(157),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_AMP] = ACTIONS(157),
    [anon_sym_GT_GT] = ACTIONS(157),
    [sym__special_character] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(157),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(165),
    [aux_sym__simple_variable_name_token1] = ACTIONS(167),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_LF] = ACTIONS(171),
    [anon_sym_SEMI] = ACTIONS(157),
    [sym_raw_string] = ACTIONS(155),
    [sym_file_descriptor] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_AMP_GT] = ACTIONS(157),
    [ts_builtin_sym_end] = ACTIONS(171),
    [anon_sym_LT_LT_LT] = ACTIONS(157),
    [anon_sym_GT_AMP] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(173),
    [anon_sym_BQUOTE] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(161),
    [sym_ansii_c_string] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(157),
    [anon_sym_SEMI_SEMI] = ACTIONS(157),
    [anon_sym_PIPE_AMP] = ACTIONS(157),
  },
  [7] = {
    [sym_string] = STATE(52),
    [anon_sym_DQUOTE] = ACTIONS(49),
    [aux_sym__simple_variable_name_token1] = ACTIONS(177),
    [anon_sym_AT] = ACTIONS(179),
    [anon_sym__] = ACTIONS(177),
    [anon_sym_BANG] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(179),
    [anon_sym_DOLLAR] = ACTIONS(181),
    [anon_sym_QMARK] = ACTIONS(179),
    [anon_sym_DASH] = ACTIONS(181),
    [sym_raw_string] = ACTIONS(183),
    [sym_comment] = ACTIONS(3),
    [anon_sym_POUND] = ACTIONS(181),
    [anon_sym_0] = ACTIONS(177),
  },
  [8] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(387),
    [sym_function_definition] = STATE(387),
    [sym_negated_command] = STATE(387),
    [sym_test_command] = STATE(387),
    [sym_variable_assignment] = STATE(388),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(390),
    [sym_redirected_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_compound_statement] = STATE(387),
    [sym_subshell] = STATE(387),
    [sym_declaration_command] = STATE(387),
    [sym_unset_command] = STATE(387),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym__statements] = STATE(53),
    [sym_c_style_for_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_case_statement] = STATE(387),
    [sym_pipeline] = STATE(387),
    [sym_list] = STATE(387),
    [sym_command] = STATE(387),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [9] = {
    [sym_word] = ACTIONS(185),
    [sym_comment] = ACTIONS(19),
  },
  [10] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(56),
    [sym_function_definition] = STATE(56),
    [sym_negated_command] = STATE(56),
    [sym_test_command] = STATE(56),
    [sym_variable_assignment] = STATE(57),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(58),
    [sym_redirected_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_compound_statement] = STATE(56),
    [sym_subshell] = STATE(56),
    [sym_declaration_command] = STATE(56),
    [sym_unset_command] = STATE(56),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_c_style_for_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_case_statement] = STATE(56),
    [sym_pipeline] = STATE(56),
    [sym_list] = STATE(56),
    [sym_command] = STATE(56),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_RBRACE] = ACTIONS(187),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [11] = {
    [aux_sym_concatenation_repeat1] = STATE(39),
    [sym_word] = ACTIONS(189),
    [anon_sym_AMP_GT_GT] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [anon_sym_LT_LT] = ACTIONS(189),
    [anon_sym_LT_LPAREN] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [sym__concat] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(189),
    [anon_sym_LT_AMP] = ACTIONS(189),
    [anon_sym_GT_GT] = ACTIONS(189),
    [anon_sym_EQ_TILDE] = ACTIONS(189),
    [sym__special_character] = ACTIONS(189),
    [anon_sym_LT_LT_DASH] = ACTIONS(189),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(189),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(189),
    [sym_file_descriptor] = ACTIONS(191),
    [anon_sym_AMP] = ACTIONS(189),
    [anon_sym_GT] = ACTIONS(189),
    [anon_sym_AMP_GT] = ACTIONS(189),
    [anon_sym_EQ_EQ] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_LT_LT_LT] = ACTIONS(189),
    [anon_sym_GT_AMP] = ACTIONS(189),
    [ts_builtin_sym_end] = ACTIONS(191),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [anon_sym_GT_LPAREN] = ACTIONS(189),
    [sym_ansii_c_string] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_SEMI_SEMI] = ACTIONS(189),
    [anon_sym_PIPE_AMP] = ACTIONS(189),
  },
  [12] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym__terminated_statement] = STATE(59),
    [sym_if_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_negated_command] = STATE(60),
    [sym_test_command] = STATE(60),
    [sym_variable_assignment] = STATE(61),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_compound_statement] = STATE(60),
    [sym_subshell] = STATE(60),
    [sym_declaration_command] = STATE(60),
    [sym_unset_command] = STATE(60),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_c_style_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_case_statement] = STATE(60),
    [sym_pipeline] = STATE(60),
    [sym_list] = STATE(60),
    [sym_command] = STATE(60),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [13] = {
    [sym_command_substitution] = STATE(62),
    [aux_sym__literal_repeat1] = STATE(63),
    [sym_string] = STATE(62),
    [sym_process_substitution] = STATE(62),
    [sym_simple_expansion] = STATE(62),
    [sym_string_expansion] = STATE(62),
    [sym_concatenation] = STATE(64),
    [sym_expansion] = STATE(62),
    [sym_word] = ACTIONS(193),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(195),
    [anon_sym_DQUOTE] = ACTIONS(197),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(199),
    [sym_raw_string] = ACTIONS(193),
    [anon_sym_BQUOTE] = ACTIONS(201),
    [anon_sym_DOLLAR] = ACTIONS(203),
    [sym_ansii_c_string] = ACTIONS(193),
    [anon_sym_GT_LPAREN] = ACTIONS(205),
    [anon_sym_LT_LPAREN] = ACTIONS(205),
    [sym__special_character] = ACTIONS(207),
    [sym_comment] = ACTIONS(19),
  },
  [14] = {
    [sym_command_substitution] = STATE(65),
    [sym_unary_expression] = STATE(69),
    [sym_postfix_expression] = STATE(69),
    [sym_string] = STATE(65),
    [aux_sym__literal_repeat1] = STATE(68),
    [sym_process_substitution] = STATE(65),
    [sym_parenthesized_expression] = STATE(69),
    [sym_simple_expansion] = STATE(65),
    [sym_string_expansion] = STATE(65),
    [sym__expression] = STATE(69),
    [sym_binary_expression] = STATE(69),
    [sym_concatenation] = STATE(69),
    [sym_expansion] = STATE(65),
    [sym_word] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_BANG] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [sym_test_operator] = ACTIONS(227),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [sym_ansii_c_string] = ACTIONS(217),
    [sym__special_character] = ACTIONS(231),
  },
  [15] = {
    [aux_sym_concatenation_repeat1] = STATE(39),
    [sym_word] = ACTIONS(61),
    [anon_sym_AMP_GT_GT] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_LT_LT] = ACTIONS(61),
    [anon_sym_LT_LPAREN] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [sym__concat] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_LT_AMP] = ACTIONS(61),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_EQ_TILDE] = ACTIONS(61),
    [sym__special_character] = ACTIONS(61),
    [anon_sym_LT_LT_DASH] = ACTIONS(61),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(61),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(61),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(61),
    [sym_raw_string] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [anon_sym_AMP_GT] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_LT_LT_LT] = ACTIONS(61),
    [anon_sym_GT_AMP] = ACTIONS(61),
    [ts_builtin_sym_end] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(61),
    [anon_sym_GT_LPAREN] = ACTIONS(61),
    [sym_ansii_c_string] = ACTIONS(61),
    [anon_sym_AMP_AMP] = ACTIONS(61),
    [anon_sym_SEMI_SEMI] = ACTIONS(61),
    [anon_sym_PIPE_AMP] = ACTIONS(61),
  },
  [16] = {
    [sym_subscript] = STATE(70),
    [aux_sym__simple_variable_name_token1] = ACTIONS(233),
    [anon_sym__] = ACTIONS(233),
    [anon_sym_AT] = ACTIONS(235),
    [anon_sym_BANG] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(235),
    [sym_variable_name] = ACTIONS(239),
    [anon_sym_DOLLAR] = ACTIONS(241),
    [anon_sym_DASH] = ACTIONS(241),
    [anon_sym_QMARK] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
    [anon_sym_0] = ACTIONS(233),
    [anon_sym_POUND] = ACTIONS(237),
  },
  [17] = {
    [aux_sym__literal_repeat1] = STATE(27),
    [sym_string] = STATE(15),
    [sym_process_substitution] = STATE(15),
    [sym_test_command] = STATE(74),
    [aux_sym_command_repeat1] = STATE(34),
    [sym_subscript] = STATE(2455),
    [sym_variable_assignment] = STATE(34),
    [sym_concatenation] = STATE(31),
    [sym_expansion] = STATE(15),
    [sym_command_substitution] = STATE(15),
    [sym_command] = STATE(74),
    [sym_command_name] = STATE(36),
    [sym_simple_expansion] = STATE(15),
    [sym_string_expansion] = STATE(15),
    [sym_subshell] = STATE(74),
    [sym_file_redirect] = STATE(34),
    [anon_sym_LPAREN] = ACTIONS(7),
    [sym_word] = ACTIONS(35),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(33),
    [sym_raw_string] = ACTIONS(35),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(37),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(45),
    [sym_variable_name] = ACTIONS(243),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_LT_LPAREN] = ACTIONS(17),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(49),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [sym_ansii_c_string] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_GT_LPAREN] = ACTIONS(17),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(59),
    [sym__special_character] = ACTIONS(27),
  },
  [18] = {
    [anon_sym_PLUS_EQ] = ACTIONS(245),
    [anon_sym_LBRACK] = ACTIONS(247),
    [anon_sym_EQ] = ACTIONS(245),
    [sym_comment] = ACTIONS(19),
  },
  [19] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(249),
    [anon_sym_GT_AMP] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(251),
    [anon_sym_LT_AMP] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(251),
    [anon_sym_AMP_GT] = ACTIONS(251),
    [sym_comment] = ACTIONS(19),
  },
  [20] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(387),
    [sym_function_definition] = STATE(387),
    [sym_negated_command] = STATE(387),
    [sym_test_command] = STATE(387),
    [sym_variable_assignment] = STATE(388),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(390),
    [sym_redirected_statement] = STATE(387),
    [sym_for_statement] = STATE(387),
    [sym_compound_statement] = STATE(387),
    [sym_subshell] = STATE(387),
    [sym_declaration_command] = STATE(387),
    [sym_unset_command] = STATE(387),
    [sym_file_redirect] = STATE(78),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym__statements] = STATE(79),
    [sym_c_style_for_statement] = STATE(387),
    [sym_while_statement] = STATE(387),
    [sym_case_statement] = STATE(387),
    [sym_pipeline] = STATE(387),
    [sym_list] = STATE(387),
    [sym_command] = STATE(387),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [21] = {
    [sym_command_substitution] = STATE(82),
    [sym_simple_expansion] = STATE(82),
    [aux_sym_string_repeat1] = STATE(83),
    [sym_expansion] = STATE(82),
    [anon_sym_DOLLAR] = ACTIONS(253),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(255),
    [anon_sym_DQUOTE] = ACTIONS(257),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(261),
    [sym__string_content] = ACTIONS(263),
  },
  [22] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(1462),
    [sym_function_definition] = STATE(1462),
    [sym_negated_command] = STATE(1462),
    [sym_test_command] = STATE(1462),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(543),
    [sym_redirected_statement] = STATE(1462),
    [sym_for_statement] = STATE(1462),
    [sym_compound_statement] = STATE(1462),
    [sym_subshell] = STATE(1462),
    [sym_declaration_command] = STATE(1462),
    [sym_unset_command] = STATE(1462),
    [sym_file_redirect] = STATE(1464),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(1464),
    [sym__statements] = STATE(84),
    [sym_c_style_for_statement] = STATE(1462),
    [sym_while_statement] = STATE(1462),
    [sym_case_statement] = STATE(1462),
    [sym_pipeline] = STATE(1462),
    [sym_list] = STATE(1462),
    [sym_command] = STATE(1462),
    [sym_command_name] = STATE(545),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(265),
    [anon_sym_typeset] = ACTIONS(265),
    [anon_sym_unsetenv] = ACTIONS(267),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(265),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(269),
    [anon_sym_declare] = ACTIONS(265),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(265),
    [anon_sym_unset] = ACTIONS(267),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [23] = {
    [sym_comment] = ACTIONS(19),
    [aux_sym__simple_variable_name_token1] = ACTIONS(271),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(273),
  },
  [24] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym__terminated_statement] = STATE(87),
    [sym_if_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_negated_command] = STATE(60),
    [sym_test_command] = STATE(60),
    [sym_variable_assignment] = STATE(61),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_compound_statement] = STATE(60),
    [sym_subshell] = STATE(60),
    [sym_declaration_command] = STATE(60),
    [sym_unset_command] = STATE(60),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_c_style_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_case_statement] = STATE(60),
    [sym_pipeline] = STATE(60),
    [sym_list] = STATE(60),
    [sym_command] = STATE(60),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [25] = {
    [sym_command_substitution] = STATE(407),
    [sym_unary_expression] = STATE(88),
    [sym_postfix_expression] = STATE(88),
    [sym_string] = STATE(407),
    [aux_sym__literal_repeat1] = STATE(409),
    [sym_process_substitution] = STATE(407),
    [sym_parenthesized_expression] = STATE(88),
    [sym_simple_expansion] = STATE(407),
    [sym_string_expansion] = STATE(407),
    [sym__expression] = STATE(88),
    [sym_binary_expression] = STATE(88),
    [sym_concatenation] = STATE(88),
    [sym_expansion] = STATE(407),
    [sym_word] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(277),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(279),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(281),
    [sym_raw_string] = ACTIONS(283),
    [anon_sym_BANG] = ACTIONS(285),
    [anon_sym_DOLLAR] = ACTIONS(287),
    [anon_sym_LT_LPAREN] = ACTIONS(289),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [sym_test_operator] = ACTIONS(293),
    [anon_sym_BQUOTE] = ACTIONS(295),
    [anon_sym_GT_LPAREN] = ACTIONS(289),
    [sym_ansii_c_string] = ACTIONS(283),
    [sym__special_character] = ACTIONS(297),
  },
  [26] = {
    [sym_command_substitution] = STATE(65),
    [sym_unary_expression] = STATE(89),
    [sym_postfix_expression] = STATE(89),
    [sym_string] = STATE(65),
    [aux_sym__literal_repeat1] = STATE(68),
    [sym_process_substitution] = STATE(65),
    [sym_parenthesized_expression] = STATE(89),
    [sym_simple_expansion] = STATE(65),
    [sym_string_expansion] = STATE(65),
    [sym__expression] = STATE(89),
    [sym_binary_expression] = STATE(89),
    [sym_concatenation] = STATE(89),
    [sym_expansion] = STATE(65),
    [sym_word] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_BANG] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [sym_test_operator] = ACTIONS(227),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [sym_ansii_c_string] = ACTIONS(217),
    [sym__special_character] = ACTIONS(231),
  },
  [27] = {
    [aux_sym__literal_repeat1] = STATE(91),
    [sym_word] = ACTIONS(299),
    [anon_sym_AMP_GT_GT] = ACTIONS(299),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_LT_LT] = ACTIONS(299),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(299),
    [anon_sym_PIPE] = ACTIONS(299),
    [anon_sym_LT] = ACTIONS(299),
    [anon_sym_LT_AMP] = ACTIONS(299),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_EQ_TILDE] = ACTIONS(299),
    [sym__special_character] = ACTIONS(301),
    [anon_sym_LT_LT_DASH] = ACTIONS(299),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(299),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(299),
    [anon_sym_LF] = ACTIONS(303),
    [anon_sym_SEMI] = ACTIONS(299),
    [sym_raw_string] = ACTIONS(299),
    [sym_file_descriptor] = ACTIONS(303),
    [anon_sym_AMP] = ACTIONS(299),
    [anon_sym_GT] = ACTIONS(299),
    [anon_sym_AMP_GT] = ACTIONS(299),
    [anon_sym_EQ_EQ] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [anon_sym_LT_LT_LT] = ACTIONS(299),
    [anon_sym_GT_AMP] = ACTIONS(299),
    [ts_builtin_sym_end] = ACTIONS(303),
    [anon_sym_BQUOTE] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_ansii_c_string] = ACTIONS(299),
    [anon_sym_AMP_AMP] = ACTIONS(299),
    [anon_sym_SEMI_SEMI] = ACTIONS(299),
    [anon_sym_PIPE_AMP] = ACTIONS(299),
  },
  [28] = {
    [sym_heredoc_redirect] = STATE(98),
    [aux_sym_redirected_statement_repeat1] = STATE(98),
    [sym_herestring_redirect] = STATE(98),
    [sym_file_redirect] = STATE(98),
    [anon_sym_SEMI_SEMI] = ACTIONS(305),
    [anon_sym_AMP_GT_GT] = ACTIONS(307),
    [anon_sym_LF] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(305),
    [sym_file_descriptor] = ACTIONS(311),
    [anon_sym_LT_LT] = ACTIONS(313),
    [anon_sym_GT] = ACTIONS(307),
    [anon_sym_AMP] = ACTIONS(305),
    [anon_sym_AMP_GT] = ACTIONS(307),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(315),
    [ts_builtin_sym_end] = ACTIONS(317),
    [anon_sym_LT_LT_LT] = ACTIONS(319),
    [anon_sym_GT_AMP] = ACTIONS(307),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_LT] = ACTIONS(307),
    [anon_sym_LT_AMP] = ACTIONS(307),
    [anon_sym_GT_GT] = ACTIONS(307),
    [anon_sym_AMP_AMP] = ACTIONS(315),
    [anon_sym_LT_LT_DASH] = ACTIONS(313),
    [anon_sym_PIPE_AMP] = ACTIONS(321),
  },
  [29] = {
    [sym_heredoc_redirect] = STATE(98),
    [aux_sym_redirected_statement_repeat1] = STATE(98),
    [sym_herestring_redirect] = STATE(98),
    [sym_file_redirect] = STATE(98),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(313),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(315),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(313),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(305),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(305),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [ts_builtin_sym_end] = ACTIONS(317),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(315),
    [anon_sym_SEMI_SEMI] = ACTIONS(305),
    [anon_sym_PIPE_AMP] = ACTIONS(321),
  },
  [30] = {
    [anon_sym_EQ] = ACTIONS(245),
    [anon_sym_PLUS_EQ] = ACTIONS(245),
    [sym_comment] = ACTIONS(19),
  },
  [31] = {
    [sym_word] = ACTIONS(61),
    [anon_sym_AMP_GT_GT] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_LT_LT] = ACTIONS(61),
    [anon_sym_LT_LPAREN] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_LT_AMP] = ACTIONS(61),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_EQ_TILDE] = ACTIONS(61),
    [sym__special_character] = ACTIONS(61),
    [anon_sym_LT_LT_DASH] = ACTIONS(61),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(61),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(61),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(61),
    [sym_raw_string] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [anon_sym_AMP_GT] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_LT_LT_LT] = ACTIONS(61),
    [anon_sym_GT_AMP] = ACTIONS(61),
    [ts_builtin_sym_end] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(61),
    [anon_sym_GT_LPAREN] = ACTIONS(61),
    [sym_ansii_c_string] = ACTIONS(61),
    [anon_sym_AMP_AMP] = ACTIONS(61),
    [anon_sym_SEMI_SEMI] = ACTIONS(61),
    [anon_sym_PIPE_AMP] = ACTIONS(61),
  },
  [32] = {
    [aux_sym__literal_repeat1] = STATE(27),
    [sym_if_statement] = STATE(99),
    [sym_function_definition] = STATE(99),
    [sym_negated_command] = STATE(99),
    [sym_test_command] = STATE(99),
    [sym_variable_assignment] = STATE(100),
    [sym_subscript] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_expansion] = STATE(15),
    [sym_command_substitution] = STATE(15),
    [aux_sym__statements_repeat1] = STATE(101),
    [sym_redirected_statement] = STATE(99),
    [sym_for_statement] = STATE(99),
    [sym_compound_statement] = STATE(99),
    [sym_subshell] = STATE(99),
    [sym_declaration_command] = STATE(99),
    [sym_unset_command] = STATE(99),
    [sym_file_redirect] = STATE(34),
    [sym_string] = STATE(15),
    [sym_process_substitution] = STATE(15),
    [aux_sym_command_repeat1] = STATE(34),
    [sym_c_style_for_statement] = STATE(99),
    [sym_while_statement] = STATE(99),
    [sym_case_statement] = STATE(99),
    [sym_pipeline] = STATE(99),
    [sym_list] = STATE(99),
    [sym_command] = STATE(99),
    [sym_command_name] = STATE(36),
    [sym_simple_expansion] = STATE(15),
    [sym_string_expansion] = STATE(15),
    [sym_word] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(11),
    [anon_sym_typeset] = ACTIONS(11),
    [anon_sym_unsetenv] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LT_LPAREN] = ACTIONS(17),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [sym__special_character] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(33),
    [sym_raw_string] = ACTIONS(35),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_declare] = ACTIONS(11),
    [sym_variable_name] = ACTIONS(41),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(45),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(11),
    [anon_sym_unset] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(49),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_ansii_c_string] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(59),
  },
  [33] = {
    [sym_comment] = ACTIONS(19),
    [ts_builtin_sym_end] = ACTIONS(327),
  },
  [34] = {
    [sym_command_substitution] = STATE(15),
    [aux_sym__literal_repeat1] = STATE(27),
    [sym_expansion] = STATE(15),
    [sym_string] = STATE(15),
    [sym_command_name] = STATE(102),
    [sym_process_substitution] = STATE(15),
    [sym_simple_expansion] = STATE(15),
    [sym_string_expansion] = STATE(15),
    [sym_subscript] = STATE(2455),
    [sym_variable_assignment] = STATE(103),
    [aux_sym_command_repeat1] = STATE(103),
    [sym_concatenation] = STATE(31),
    [sym_file_redirect] = STATE(103),
    [sym_word] = ACTIONS(35),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(45),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(37),
    [sym_raw_string] = ACTIONS(35),
    [sym_variable_name] = ACTIONS(243),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_LT_LPAREN] = ACTIONS(17),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(49),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [sym_ansii_c_string] = ACTIONS(35),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(17),
    [sym__special_character] = ACTIONS(329),
  },
  [35] = {
    [sym_comment] = ACTIONS(19),
    [ts_builtin_sym_end] = ACTIONS(331),
  },
  [36] = {
    [sym_command_substitution] = STATE(104),
    [aux_sym__literal_repeat1] = STATE(106),
    [sym_string] = STATE(104),
    [sym_process_substitution] = STATE(104),
    [sym_simple_expansion] = STATE(104),
    [sym_string_expansion] = STATE(104),
    [aux_sym_command_repeat2] = STATE(107),
    [sym_concatenation] = STATE(107),
    [sym_expansion] = STATE(104),
    [sym_word] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LT_LT] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(337),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [sym__special_character] = ACTIONS(27),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(341),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(343),
    [anon_sym_LF] = ACTIONS(345),
    [anon_sym_SEMI] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(333),
    [sym_file_descriptor] = ACTIONS(345),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [ts_builtin_sym_end] = ACTIONS(345),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(347),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(337),
    [sym_ansii_c_string] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
  },
  [37] = {
    [anon_sym_RPAREN] = ACTIONS(351),
    [sym_comment] = ACTIONS(19),
  },
  [38] = {
    [sym_command_substitution] = STATE(109),
    [sym_simple_expansion] = STATE(109),
    [sym_string_expansion] = STATE(109),
    [sym_string] = STATE(109),
    [sym_process_substitution] = STATE(109),
    [sym_expansion] = STATE(109),
    [sym_word] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(49),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(37),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_GT_LPAREN] = ACTIONS(17),
    [sym_ansii_c_string] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(17),
    [sym__special_character] = ACTIONS(353),
    [sym_comment] = ACTIONS(19),
  },
  [39] = {
    [aux_sym_concatenation_repeat1] = STATE(111),
    [sym_word] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LPAREN] = ACTIONS(355),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [sym__concat] = ACTIONS(357),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_LT_AMP] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(355),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [sym__special_character] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(355),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(355),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(355),
    [sym_raw_string] = ACTIONS(355),
    [sym_file_descriptor] = ACTIONS(359),
    [anon_sym_AMP] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_LT_LT_LT] = ACTIONS(355),
    [anon_sym_GT_AMP] = ACTIONS(355),
    [ts_builtin_sym_end] = ACTIONS(359),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_GT_LPAREN] = ACTIONS(355),
    [sym_ansii_c_string] = ACTIONS(355),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(355),
    [anon_sym_PIPE_AMP] = ACTIONS(355),
  },
  [40] = {
    [anon_sym_RPAREN] = ACTIONS(361),
    [sym_comment] = ACTIONS(19),
  },
  [41] = {
    [aux_sym_concatenation_repeat1] = STATE(546),
    [sym_word] = ACTIONS(363),
    [anon_sym_AMP_GT_GT] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_LT_LPAREN] = ACTIONS(363),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(365),
    [anon_sym_LT_AMP] = ACTIONS(363),
    [anon_sym_GT_GT] = ACTIONS(363),
    [sym__special_character] = ACTIONS(363),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(363),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(363),
    [sym_raw_string] = ACTIONS(363),
    [sym_variable_name] = ACTIONS(363),
    [sym_file_descriptor] = ACTIONS(363),
    [anon_sym_RPAREN] = ACTIONS(363),
    [anon_sym_GT] = ACTIONS(365),
    [anon_sym_AMP_GT] = ACTIONS(365),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_GT_AMP] = ACTIONS(363),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_GT_LPAREN] = ACTIONS(363),
    [sym_ansii_c_string] = ACTIONS(363),
  },
  [42] = {
    [aux_sym__literal_repeat1] = STATE(564),
    [sym_word] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(369),
    [sym__special_character] = ACTIONS(373),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [sym_raw_string] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [sym_file_descriptor] = ACTIONS(369),
    [anon_sym_RPAREN] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_ansii_c_string] = ACTIONS(369),
  },
  [43] = {
    [sym_word] = ACTIONS(363),
    [anon_sym_AMP_GT_GT] = ACTIONS(363),
    [anon_sym_DOLLAR] = ACTIONS(365),
    [anon_sym_LT_LPAREN] = ACTIONS(363),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(365),
    [anon_sym_LT_AMP] = ACTIONS(363),
    [anon_sym_GT_GT] = ACTIONS(363),
    [sym__special_character] = ACTIONS(363),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(363),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(363),
    [sym_raw_string] = ACTIONS(363),
    [sym_variable_name] = ACTIONS(363),
    [sym_file_descriptor] = ACTIONS(363),
    [anon_sym_RPAREN] = ACTIONS(363),
    [anon_sym_GT] = ACTIONS(365),
    [anon_sym_AMP_GT] = ACTIONS(365),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_GT_AMP] = ACTIONS(363),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_GT_LPAREN] = ACTIONS(363),
    [sym_ansii_c_string] = ACTIONS(363),
  },
  [44] = {
    [aux_sym_concatenation_repeat1] = STATE(638),
    [sym_word] = ACTIONS(375),
    [anon_sym_AMP_GT_GT] = ACTIONS(375),
    [anon_sym_DOLLAR] = ACTIONS(375),
    [anon_sym_LT_LT] = ACTIONS(375),
    [anon_sym_LT_LPAREN] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(375),
    [sym__concat] = ACTIONS(377),
    [anon_sym_PIPE] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(375),
    [anon_sym_LT_AMP] = ACTIONS(375),
    [anon_sym_GT_GT] = ACTIONS(375),
    [sym__special_character] = ACTIONS(375),
    [anon_sym_LT_LT_DASH] = ACTIONS(375),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(375),
    [aux_sym__simple_variable_name_token1] = ACTIONS(375),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(375),
    [anon_sym_LF] = ACTIONS(379),
    [anon_sym_SEMI] = ACTIONS(375),
    [sym_raw_string] = ACTIONS(375),
    [sym_variable_name] = ACTIONS(379),
    [sym_file_descriptor] = ACTIONS(379),
    [anon_sym_AMP] = ACTIONS(375),
    [anon_sym_GT] = ACTIONS(375),
    [anon_sym_AMP_GT] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [anon_sym_LT_LT_LT] = ACTIONS(375),
    [anon_sym_GT_AMP] = ACTIONS(375),
    [ts_builtin_sym_end] = ACTIONS(379),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [anon_sym_GT_LPAREN] = ACTIONS(375),
    [sym_ansii_c_string] = ACTIONS(375),
    [anon_sym_AMP_AMP] = ACTIONS(375),
    [anon_sym_SEMI_SEMI] = ACTIONS(375),
    [anon_sym_PIPE_AMP] = ACTIONS(375),
  },
  [45] = {
    [aux_sym__literal_repeat1] = STATE(646),
    [sym_word] = ACTIONS(381),
    [anon_sym_AMP_GT_GT] = ACTIONS(381),
    [anon_sym_DOLLAR] = ACTIONS(381),
    [anon_sym_LT_LT] = ACTIONS(381),
    [anon_sym_LT_LPAREN] = ACTIONS(381),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(381),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_LT_AMP] = ACTIONS(381),
    [anon_sym_GT_GT] = ACTIONS(381),
    [sym__special_character] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(381),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(381),
    [aux_sym__simple_variable_name_token1] = ACTIONS(381),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(381),
    [anon_sym_LF] = ACTIONS(385),
    [anon_sym_SEMI] = ACTIONS(381),
    [sym_raw_string] = ACTIONS(381),
    [sym_variable_name] = ACTIONS(385),
    [sym_file_descriptor] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_GT] = ACTIONS(381),
    [anon_sym_AMP_GT] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [anon_sym_LT_LT_LT] = ACTIONS(381),
    [anon_sym_GT_AMP] = ACTIONS(381),
    [ts_builtin_sym_end] = ACTIONS(385),
    [anon_sym_BQUOTE] = ACTIONS(381),
    [anon_sym_GT_LPAREN] = ACTIONS(381),
    [sym_ansii_c_string] = ACTIONS(381),
    [anon_sym_AMP_AMP] = ACTIONS(381),
    [anon_sym_SEMI_SEMI] = ACTIONS(381),
    [anon_sym_PIPE_AMP] = ACTIONS(381),
  },
  [46] = {
    [sym_command_substitution] = STATE(44),
    [aux_sym__literal_repeat1] = STATE(45),
    [sym_string] = STATE(44),
    [aux_sym_declaration_command_repeat1] = STATE(113),
    [sym_process_substitution] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_subscript] = STATE(2444),
    [sym_string_expansion] = STATE(44),
    [sym_variable_assignment] = STATE(113),
    [sym_concatenation] = STATE(113),
    [sym_expansion] = STATE(44),
    [sym_word] = ACTIONS(131),
    [anon_sym_AMP_GT_GT] = ACTIONS(387),
    [anon_sym_DOLLAR] = ACTIONS(135),
    [anon_sym_LT_LT] = ACTIONS(387),
    [anon_sym_LT_LPAREN] = ACTIONS(137),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_PIPE] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(387),
    [anon_sym_LT_AMP] = ACTIONS(387),
    [anon_sym_GT_GT] = ACTIONS(387),
    [sym__special_character] = ACTIONS(139),
    [anon_sym_LT_LT_DASH] = ACTIONS(387),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(141),
    [aux_sym__simple_variable_name_token1] = ACTIONS(389),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_LF] = ACTIONS(391),
    [anon_sym_SEMI] = ACTIONS(387),
    [sym_raw_string] = ACTIONS(131),
    [sym_variable_name] = ACTIONS(149),
    [sym_file_descriptor] = ACTIONS(391),
    [anon_sym_AMP] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(387),
    [anon_sym_AMP_GT] = ACTIONS(387),
    [ts_builtin_sym_end] = ACTIONS(391),
    [anon_sym_LT_LT_LT] = ACTIONS(387),
    [anon_sym_GT_AMP] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [anon_sym_BQUOTE] = ACTIONS(153),
    [anon_sym_GT_LPAREN] = ACTIONS(137),
    [sym_ansii_c_string] = ACTIONS(131),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_SEMI_SEMI] = ACTIONS(387),
    [anon_sym_PIPE_AMP] = ACTIONS(387),
  },
  [47] = {
    [aux_sym_concatenation_repeat1] = STATE(696),
    [sym_word] = ACTIONS(393),
    [anon_sym_AMP_GT_GT] = ACTIONS(393),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [anon_sym_LT_LT] = ACTIONS(393),
    [anon_sym_LT_LPAREN] = ACTIONS(393),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(393),
    [sym__concat] = ACTIONS(395),
    [anon_sym_PIPE] = ACTIONS(393),
    [anon_sym_LT] = ACTIONS(393),
    [anon_sym_LT_AMP] = ACTIONS(393),
    [anon_sym_GT_GT] = ACTIONS(393),
    [sym__special_character] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(393),
    [aux_sym__simple_variable_name_token1] = ACTIONS(393),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(393),
    [anon_sym_LF] = ACTIONS(397),
    [anon_sym_SEMI] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(393),
    [sym_file_descriptor] = ACTIONS(397),
    [anon_sym_AMP] = ACTIONS(393),
    [anon_sym_GT] = ACTIONS(393),
    [anon_sym_AMP_GT] = ACTIONS(393),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_LT_LT_LT] = ACTIONS(393),
    [anon_sym_GT_AMP] = ACTIONS(393),
    [ts_builtin_sym_end] = ACTIONS(397),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [anon_sym_GT_LPAREN] = ACTIONS(393),
    [sym_ansii_c_string] = ACTIONS(393),
    [anon_sym_AMP_AMP] = ACTIONS(393),
    [anon_sym_SEMI_SEMI] = ACTIONS(393),
    [anon_sym_PIPE_AMP] = ACTIONS(393),
  },
  [48] = {
    [aux_sym__literal_repeat1] = STATE(702),
    [sym_word] = ACTIONS(399),
    [anon_sym_AMP_GT_GT] = ACTIONS(399),
    [anon_sym_DOLLAR] = ACTIONS(399),
    [anon_sym_LT_LT] = ACTIONS(399),
    [anon_sym_LT_LPAREN] = ACTIONS(399),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_PIPE] = ACTIONS(399),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_LT_AMP] = ACTIONS(399),
    [anon_sym_GT_GT] = ACTIONS(399),
    [sym__special_character] = ACTIONS(401),
    [anon_sym_LT_LT_DASH] = ACTIONS(399),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [aux_sym__simple_variable_name_token1] = ACTIONS(399),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(399),
    [anon_sym_LF] = ACTIONS(403),
    [anon_sym_SEMI] = ACTIONS(399),
    [sym_raw_string] = ACTIONS(399),
    [sym_file_descriptor] = ACTIONS(403),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_GT] = ACTIONS(399),
    [anon_sym_AMP_GT] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_LT_LT_LT] = ACTIONS(399),
    [anon_sym_GT_AMP] = ACTIONS(399),
    [ts_builtin_sym_end] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(399),
    [anon_sym_GT_LPAREN] = ACTIONS(399),
    [sym_ansii_c_string] = ACTIONS(399),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_SEMI_SEMI] = ACTIONS(399),
    [anon_sym_PIPE_AMP] = ACTIONS(399),
  },
  [49] = {
    [sym_command_substitution] = STATE(47),
    [aux_sym__literal_repeat1] = STATE(48),
    [sym_string] = STATE(47),
    [aux_sym_unset_command_repeat1] = STATE(114),
    [sym_process_substitution] = STATE(47),
    [sym_simple_expansion] = STATE(47),
    [sym_string_expansion] = STATE(47),
    [sym_concatenation] = STATE(114),
    [sym_expansion] = STATE(47),
    [sym_word] = ACTIONS(155),
    [anon_sym_AMP_GT_GT] = ACTIONS(405),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [anon_sym_LT_LT] = ACTIONS(405),
    [anon_sym_LT_LPAREN] = ACTIONS(161),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(405),
    [anon_sym_PIPE] = ACTIONS(405),
    [anon_sym_LT] = ACTIONS(405),
    [anon_sym_LT_AMP] = ACTIONS(405),
    [anon_sym_GT_GT] = ACTIONS(405),
    [sym__special_character] = ACTIONS(163),
    [anon_sym_LT_LT_DASH] = ACTIONS(405),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(165),
    [aux_sym__simple_variable_name_token1] = ACTIONS(407),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_LF] = ACTIONS(409),
    [anon_sym_SEMI] = ACTIONS(405),
    [sym_raw_string] = ACTIONS(155),
    [sym_file_descriptor] = ACTIONS(409),
    [anon_sym_AMP] = ACTIONS(405),
    [anon_sym_GT] = ACTIONS(405),
    [anon_sym_AMP_GT] = ACTIONS(405),
    [ts_builtin_sym_end] = ACTIONS(409),
    [anon_sym_LT_LT_LT] = ACTIONS(405),
    [anon_sym_GT_AMP] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(173),
    [anon_sym_BQUOTE] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(161),
    [sym_ansii_c_string] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(405),
    [anon_sym_SEMI_SEMI] = ACTIONS(405),
    [anon_sym_PIPE_AMP] = ACTIONS(405),
  },
  [50] = {
    [sym_word] = ACTIONS(411),
    [anon_sym_AMP_GT_GT] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(411),
    [anon_sym_LT_LT] = ACTIONS(411),
    [anon_sym_LT_LPAREN] = ACTIONS(411),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(411),
    [sym__concat] = ACTIONS(413),
    [anon_sym_PIPE] = ACTIONS(411),
    [anon_sym_LT] = ACTIONS(411),
    [anon_sym_LT_AMP] = ACTIONS(411),
    [anon_sym_GT_GT] = ACTIONS(411),
    [anon_sym_EQ_TILDE] = ACTIONS(411),
    [sym__special_character] = ACTIONS(411),
    [anon_sym_LT_LT_DASH] = ACTIONS(411),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(411),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(411),
    [anon_sym_LF] = ACTIONS(413),
    [anon_sym_SEMI] = ACTIONS(411),
    [sym_raw_string] = ACTIONS(411),
    [sym_file_descriptor] = ACTIONS(413),
    [anon_sym_AMP] = ACTIONS(411),
    [anon_sym_GT] = ACTIONS(411),
    [anon_sym_AMP_GT] = ACTIONS(411),
    [anon_sym_EQ_EQ] = ACTIONS(411),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_LT_LT_LT] = ACTIONS(411),
    [anon_sym_GT_AMP] = ACTIONS(411),
    [ts_builtin_sym_end] = ACTIONS(413),
    [anon_sym_BQUOTE] = ACTIONS(411),
    [anon_sym_GT_LPAREN] = ACTIONS(411),
    [sym_ansii_c_string] = ACTIONS(411),
    [anon_sym_AMP_AMP] = ACTIONS(411),
    [anon_sym_SEMI_SEMI] = ACTIONS(411),
    [anon_sym_PIPE_AMP] = ACTIONS(411),
  },
  [51] = {
    [sym_word] = ACTIONS(415),
    [anon_sym_AMP_GT_GT] = ACTIONS(415),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LPAREN] = ACTIONS(415),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(415),
    [sym__concat] = ACTIONS(417),
    [anon_sym_PIPE] = ACTIONS(415),
    [anon_sym_LT] = ACTIONS(415),
    [anon_sym_LT_AMP] = ACTIONS(415),
    [anon_sym_GT_GT] = ACTIONS(415),
    [anon_sym_EQ_TILDE] = ACTIONS(415),
    [sym__special_character] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(415),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(415),
    [anon_sym_LF] = ACTIONS(417),
    [anon_sym_SEMI] = ACTIONS(415),
    [sym_raw_string] = ACTIONS(415),
    [sym_file_descriptor] = ACTIONS(417),
    [anon_sym_AMP] = ACTIONS(415),
    [anon_sym_GT] = ACTIONS(415),
    [anon_sym_AMP_GT] = ACTIONS(415),
    [anon_sym_EQ_EQ] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [anon_sym_LT_LT_LT] = ACTIONS(415),
    [anon_sym_GT_AMP] = ACTIONS(415),
    [ts_builtin_sym_end] = ACTIONS(417),
    [anon_sym_BQUOTE] = ACTIONS(415),
    [anon_sym_GT_LPAREN] = ACTIONS(415),
    [sym_ansii_c_string] = ACTIONS(415),
    [anon_sym_AMP_AMP] = ACTIONS(415),
    [anon_sym_SEMI_SEMI] = ACTIONS(415),
    [anon_sym_PIPE_AMP] = ACTIONS(415),
  },
  [52] = {
    [sym_word] = ACTIONS(419),
    [anon_sym_AMP_GT_GT] = ACTIONS(419),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_LT_LT] = ACTIONS(419),
    [anon_sym_LT_LPAREN] = ACTIONS(419),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(419),
    [sym__concat] = ACTIONS(421),
    [anon_sym_PIPE] = ACTIONS(419),
    [anon_sym_LT] = ACTIONS(419),
    [anon_sym_LT_AMP] = ACTIONS(419),
    [anon_sym_GT_GT] = ACTIONS(419),
    [anon_sym_EQ_TILDE] = ACTIONS(419),
    [sym__special_character] = ACTIONS(419),
    [anon_sym_LT_LT_DASH] = ACTIONS(419),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(419),
    [anon_sym_LF] = ACTIONS(421),
    [anon_sym_SEMI] = ACTIONS(419),
    [sym_raw_string] = ACTIONS(419),
    [sym_file_descriptor] = ACTIONS(421),
    [anon_sym_AMP] = ACTIONS(419),
    [anon_sym_GT] = ACTIONS(419),
    [anon_sym_AMP_GT] = ACTIONS(419),
    [anon_sym_EQ_EQ] = ACTIONS(419),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [anon_sym_LT_LT_LT] = ACTIONS(419),
    [anon_sym_GT_AMP] = ACTIONS(419),
    [ts_builtin_sym_end] = ACTIONS(421),
    [anon_sym_BQUOTE] = ACTIONS(419),
    [anon_sym_GT_LPAREN] = ACTIONS(419),
    [sym_ansii_c_string] = ACTIONS(419),
    [anon_sym_AMP_AMP] = ACTIONS(419),
    [anon_sym_SEMI_SEMI] = ACTIONS(419),
    [anon_sym_PIPE_AMP] = ACTIONS(419),
  },
  [53] = {
    [anon_sym_RPAREN] = ACTIONS(423),
    [sym_comment] = ACTIONS(19),
  },
  [54] = {
    [sym_compound_statement] = STATE(117),
    [anon_sym_LPAREN] = ACTIONS(425),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_comment] = ACTIONS(19),
  },
  [55] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(427),
    [anon_sym_AMP_GT_GT] = ACTIONS(427),
    [anon_sym_LF] = ACTIONS(429),
    [anon_sym_SEMI] = ACTIONS(427),
    [anon_sym_LT_LT] = ACTIONS(427),
    [anon_sym_AMP] = ACTIONS(427),
    [anon_sym_GT] = ACTIONS(427),
    [sym_file_descriptor] = ACTIONS(429),
    [anon_sym_AMP_GT] = ACTIONS(427),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [ts_builtin_sym_end] = ACTIONS(429),
    [anon_sym_LT_LT_LT] = ACTIONS(427),
    [anon_sym_PIPE] = ACTIONS(427),
    [anon_sym_GT_AMP] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(427),
    [anon_sym_LT_AMP] = ACTIONS(427),
    [anon_sym_GT_GT] = ACTIONS(427),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_SEMI_SEMI] = ACTIONS(427),
    [anon_sym_PIPE_AMP] = ACTIONS(427),
  },
  [56] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(437),
    [sym_file_descriptor] = ACTIONS(439),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_AMP] = ACTIONS(437),
    [anon_sym_AMP_GT] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_SEMI_SEMI] = ACTIONS(437),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
  },
  [57] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(437),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(437),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_SEMI_SEMI] = ACTIONS(437),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [58] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(56),
    [sym_function_definition] = STATE(56),
    [sym_negated_command] = STATE(56),
    [sym_test_command] = STATE(56),
    [sym_variable_assignment] = STATE(57),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(421),
    [sym_redirected_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_compound_statement] = STATE(56),
    [sym_subshell] = STATE(56),
    [sym_declaration_command] = STATE(56),
    [sym_unset_command] = STATE(56),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_c_style_for_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_case_statement] = STATE(56),
    [sym_pipeline] = STATE(56),
    [sym_list] = STATE(56),
    [sym_command] = STATE(56),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_RBRACE] = ACTIONS(447),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [59] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_then] = ACTIONS(449),
  },
  [60] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_LF] = ACTIONS(451),
    [anon_sym_SEMI] = ACTIONS(453),
    [sym_file_descriptor] = ACTIONS(439),
    [anon_sym_AMP] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(433),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_SEMI_SEMI] = ACTIONS(453),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [61] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(451),
    [anon_sym_SEMI] = ACTIONS(453),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_SEMI_SEMI] = ACTIONS(453),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [62] = {
    [aux_sym_concatenation_repeat1] = STATE(735),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(455),
    [sym__concat] = ACTIONS(457),
    [anon_sym_LF] = ACTIONS(459),
    [anon_sym_SEMI] = ACTIONS(455),
    [anon_sym_in] = ACTIONS(461),
    [anon_sym_SEMI_SEMI] = ACTIONS(455),
  },
  [63] = {
    [aux_sym__literal_repeat1] = STATE(741),
    [anon_sym_SEMI] = ACTIONS(463),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(463),
    [anon_sym_LF] = ACTIONS(465),
    [sym__special_character] = ACTIONS(467),
    [anon_sym_SEMI_SEMI] = ACTIONS(463),
    [anon_sym_in] = ACTIONS(469),
  },
  [64] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_LF] = ACTIONS(459),
    [anon_sym_SEMI] = ACTIONS(455),
    [anon_sym_in] = ACTIONS(461),
    [anon_sym_SEMI_SEMI] = ACTIONS(455),
  },
  [65] = {
    [aux_sym_concatenation_repeat1] = STATE(772),
    [anon_sym_PLUS_EQ] = ACTIONS(471),
    [anon_sym_PLUS_PLUS] = ACTIONS(471),
    [anon_sym_DASH] = ACTIONS(473),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(471),
    [anon_sym_PIPE_PIPE] = ACTIONS(471),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(471),
    [sym__concat] = ACTIONS(475),
    [sym_test_operator] = ACTIONS(471),
    [anon_sym_LT] = ACTIONS(473),
    [anon_sym_EQ_TILDE] = ACTIONS(471),
    [anon_sym_DASH_DASH] = ACTIONS(471),
    [anon_sym_LT_EQ] = ACTIONS(471),
    [anon_sym_DASH_EQ] = ACTIONS(471),
    [anon_sym_BANG_EQ] = ACTIONS(471),
    [anon_sym_RPAREN] = ACTIONS(473),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_EQ_EQ] = ACTIONS(471),
    [anon_sym_GT_EQ] = ACTIONS(471),
    [anon_sym_PLUS] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(471),
  },
  [66] = {
    [aux_sym__literal_repeat1] = STATE(68),
    [sym_unary_expression] = STATE(127),
    [sym_postfix_expression] = STATE(127),
    [sym_string] = STATE(65),
    [sym_process_substitution] = STATE(65),
    [sym__expression] = STATE(127),
    [sym_binary_expression] = STATE(127),
    [sym_concatenation] = STATE(127),
    [sym_expansion] = STATE(65),
    [sym_command_substitution] = STATE(65),
    [sym_parenthesized_expression] = STATE(127),
    [sym_simple_expansion] = STATE(65),
    [sym_string_expansion] = STATE(65),
    [sym_word] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_BANG] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [sym_test_operator] = ACTIONS(227),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [sym_ansii_c_string] = ACTIONS(217),
    [sym__special_character] = ACTIONS(231),
  },
  [67] = {
    [aux_sym__literal_repeat1] = STATE(68),
    [sym_unary_expression] = STATE(128),
    [sym_postfix_expression] = STATE(128),
    [sym_string] = STATE(65),
    [sym_process_substitution] = STATE(65),
    [sym__expression] = STATE(128),
    [sym_binary_expression] = STATE(128),
    [sym_concatenation] = STATE(128),
    [sym_expansion] = STATE(65),
    [sym_command_substitution] = STATE(65),
    [sym_parenthesized_expression] = STATE(128),
    [sym_simple_expansion] = STATE(65),
    [sym_string_expansion] = STATE(65),
    [sym_word] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_BANG] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [sym_test_operator] = ACTIONS(227),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [sym_ansii_c_string] = ACTIONS(217),
    [sym__special_character] = ACTIONS(231),
  },
  [68] = {
    [aux_sym__literal_repeat1] = STATE(778),
    [anon_sym_PLUS_EQ] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(477),
    [anon_sym_DASH] = ACTIONS(479),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(477),
    [sym_test_operator] = ACTIONS(477),
    [anon_sym_LT] = ACTIONS(479),
    [anon_sym_EQ_TILDE] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(477),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [sym__special_character] = ACTIONS(481),
    [anon_sym_DASH_EQ] = ACTIONS(477),
    [anon_sym_BANG_EQ] = ACTIONS(477),
    [anon_sym_RPAREN] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(479),
    [anon_sym_EQ_EQ] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_AMP_AMP] = ACTIONS(477),
  },
  [69] = {
    [anon_sym_BANG_EQ] = ACTIONS(483),
    [anon_sym_PLUS_EQ] = ACTIONS(483),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_EQ] = ACTIONS(487),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(491),
    [anon_sym_PIPE_PIPE] = ACTIONS(483),
    [anon_sym_GT_EQ] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_LT] = ACTIONS(487),
    [sym_test_operator] = ACTIONS(483),
    [anon_sym_EQ_TILDE] = ACTIONS(489),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(483),
    [anon_sym_AMP_AMP] = ACTIONS(483),
    [anon_sym_DASH_EQ] = ACTIONS(483),
  },
  [70] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(137),
    [sym_concatenation] = STATE(137),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(501),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(505),
    [anon_sym_DASH] = ACTIONS(501),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(501),
    [anon_sym_PERCENT] = ACTIONS(501),
    [anon_sym_POUND] = ACTIONS(509),
    [anon_sym_SLASH] = ACTIONS(511),
    [anon_sym_COLON_DASH] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(501),
    [sym__special_character] = ACTIONS(517),
  },
  [71] = {
    [sym_subscript] = STATE(138),
    [aux_sym__simple_variable_name_token1] = ACTIONS(519),
    [anon_sym__] = ACTIONS(519),
    [anon_sym_AT] = ACTIONS(521),
    [anon_sym_STAR] = ACTIONS(521),
    [sym_variable_name] = ACTIONS(523),
    [anon_sym_DOLLAR] = ACTIONS(525),
    [anon_sym_DASH] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(521),
    [sym_comment] = ACTIONS(19),
    [anon_sym_0] = ACTIONS(519),
  },
  [72] = {
    [anon_sym_EQ] = ACTIONS(527),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(529),
  },
  [73] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(144),
    [sym_concatenation] = STATE(144),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(531),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(533),
    [anon_sym_DASH] = ACTIONS(531),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(531),
    [anon_sym_PERCENT] = ACTIONS(531),
    [anon_sym_POUND] = ACTIONS(535),
    [anon_sym_SLASH] = ACTIONS(537),
    [anon_sym_COLON_DASH] = ACTIONS(531),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(531),
    [sym__special_character] = ACTIONS(517),
  },
  [74] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(539),
    [anon_sym_AMP_GT_GT] = ACTIONS(539),
    [anon_sym_LF] = ACTIONS(541),
    [anon_sym_SEMI] = ACTIONS(539),
    [anon_sym_LT_LT] = ACTIONS(539),
    [anon_sym_AMP] = ACTIONS(539),
    [anon_sym_GT] = ACTIONS(539),
    [sym_file_descriptor] = ACTIONS(541),
    [anon_sym_AMP_GT] = ACTIONS(539),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(539),
    [ts_builtin_sym_end] = ACTIONS(541),
    [anon_sym_LT_LT_LT] = ACTIONS(539),
    [anon_sym_PIPE] = ACTIONS(539),
    [anon_sym_GT_AMP] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(539),
    [anon_sym_LT_AMP] = ACTIONS(539),
    [anon_sym_GT_GT] = ACTIONS(539),
    [anon_sym_AMP_AMP] = ACTIONS(539),
    [anon_sym_SEMI_SEMI] = ACTIONS(539),
    [anon_sym_PIPE_AMP] = ACTIONS(539),
  },
  [75] = {
    [sym_command_substitution] = STATE(145),
    [aux_sym__literal_repeat1] = STATE(148),
    [sym_string] = STATE(145),
    [sym_array] = STATE(147),
    [sym_process_substitution] = STATE(145),
    [sym_simple_expansion] = STATE(145),
    [sym_string_expansion] = STATE(145),
    [sym_concatenation] = STATE(147),
    [sym_expansion] = STATE(145),
    [sym_word] = ACTIONS(543),
    [anon_sym_LPAREN] = ACTIONS(545),
    [anon_sym_DQUOTE] = ACTIONS(547),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(549),
    [sym_raw_string] = ACTIONS(543),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(551),
    [anon_sym_BQUOTE] = ACTIONS(553),
    [anon_sym_DOLLAR] = ACTIONS(555),
    [sym_ansii_c_string] = ACTIONS(543),
    [anon_sym_GT_LPAREN] = ACTIONS(557),
    [anon_sym_LT_LPAREN] = ACTIONS(557),
    [sym__special_character] = ACTIONS(559),
    [sym__empty_value] = ACTIONS(561),
    [sym_comment] = ACTIONS(19),
  },
  [76] = {
    [sym_command_substitution] = STATE(149),
    [aux_sym__literal_repeat1] = STATE(150),
    [sym_string] = STATE(149),
    [sym_process_substitution] = STATE(149),
    [sym_simple_expansion] = STATE(149),
    [sym_string_expansion] = STATE(149),
    [sym_concatenation] = STATE(151),
    [sym_expansion] = STATE(149),
    [sym_word] = ACTIONS(563),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(279),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(281),
    [sym_raw_string] = ACTIONS(563),
    [anon_sym_BQUOTE] = ACTIONS(295),
    [anon_sym_DOLLAR] = ACTIONS(287),
    [sym_ansii_c_string] = ACTIONS(563),
    [anon_sym_GT_LPAREN] = ACTIONS(289),
    [anon_sym_LT_LPAREN] = ACTIONS(289),
    [sym__special_character] = ACTIONS(565),
    [sym_comment] = ACTIONS(19),
  },
  [77] = {
    [sym_command_substitution] = STATE(152),
    [aux_sym__literal_repeat1] = STATE(153),
    [sym_string] = STATE(152),
    [sym_process_substitution] = STATE(152),
    [sym_simple_expansion] = STATE(152),
    [sym_string_expansion] = STATE(152),
    [sym_concatenation] = STATE(154),
    [sym_expansion] = STATE(152),
    [sym_word] = ACTIONS(567),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(117),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(119),
    [sym_raw_string] = ACTIONS(567),
    [anon_sym_DOLLAR] = ACTIONS(121),
    [anon_sym_LT_LPAREN] = ACTIONS(123),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(123),
    [sym_ansii_c_string] = ACTIONS(567),
    [sym__special_character] = ACTIONS(129),
  },
  [78] = {
    [sym_word] = ACTIONS(325),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(325),
    [anon_sym_AMP_GT_GT] = ACTIONS(325),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(325),
    [sym_raw_string] = ACTIONS(325),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [sym_file_descriptor] = ACTIONS(325),
    [sym_variable_name] = ACTIONS(325),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_LT_LPAREN] = ACTIONS(325),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_RPAREN] = ACTIONS(569),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_GT_AMP] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(325),
    [anon_sym_GT_GT] = ACTIONS(325),
    [sym_ansii_c_string] = ACTIONS(325),
    [anon_sym_BQUOTE] = ACTIONS(325),
    [anon_sym_GT_LPAREN] = ACTIONS(325),
    [sym__special_character] = ACTIONS(325),
  },
  [79] = {
    [anon_sym_RPAREN] = ACTIONS(569),
    [sym_comment] = ACTIONS(19),
  },
  [80] = {
    [aux_sym__simple_variable_name_token1] = ACTIONS(571),
    [anon_sym__] = ACTIONS(571),
    [anon_sym_AT] = ACTIONS(571),
    [anon_sym_DQUOTE] = ACTIONS(573),
    [anon_sym_BANG] = ACTIONS(575),
    [anon_sym_STAR] = ACTIONS(571),
    [anon_sym_DOLLAR] = ACTIONS(575),
    [anon_sym_QMARK] = ACTIONS(571),
    [anon_sym_DASH] = ACTIONS(575),
    [sym__string_content] = ACTIONS(577),
    [sym_comment] = ACTIONS(3),
    [anon_sym_POUND] = ACTIONS(575),
    [anon_sym_0] = ACTIONS(571),
  },
  [81] = {
    [sym_word] = ACTIONS(579),
    [anon_sym_AMP_GT_GT] = ACTIONS(579),
    [anon_sym_DOLLAR] = ACTIONS(579),
    [anon_sym_LT_LT] = ACTIONS(579),
    [anon_sym_LT_LPAREN] = ACTIONS(579),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(579),
    [sym__concat] = ACTIONS(581),
    [anon_sym_PIPE] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(579),
    [anon_sym_LT_AMP] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(579),
    [anon_sym_EQ_TILDE] = ACTIONS(579),
    [sym__special_character] = ACTIONS(579),
    [anon_sym_LT_LT_DASH] = ACTIONS(579),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(579),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(579),
    [anon_sym_LF] = ACTIONS(581),
    [anon_sym_SEMI] = ACTIONS(579),
    [sym_raw_string] = ACTIONS(579),
    [sym_file_descriptor] = ACTIONS(581),
    [anon_sym_AMP] = ACTIONS(579),
    [anon_sym_GT] = ACTIONS(579),
    [anon_sym_AMP_GT] = ACTIONS(579),
    [anon_sym_EQ_EQ] = ACTIONS(579),
    [anon_sym_DQUOTE] = ACTIONS(579),
    [anon_sym_LT_LT_LT] = ACTIONS(579),
    [anon_sym_GT_AMP] = ACTIONS(579),
    [ts_builtin_sym_end] = ACTIONS(581),
    [anon_sym_BQUOTE] = ACTIONS(579),
    [anon_sym_GT_LPAREN] = ACTIONS(579),
    [sym_ansii_c_string] = ACTIONS(579),
    [anon_sym_AMP_AMP] = ACTIONS(579),
    [anon_sym_SEMI_SEMI] = ACTIONS(579),
    [anon_sym_PIPE_AMP] = ACTIONS(579),
  },
  [82] = {
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(583),
    [sym__concat] = ACTIONS(585),
    [anon_sym_BQUOTE] = ACTIONS(583),
    [sym__string_content] = ACTIONS(583),
    [anon_sym_DOLLAR] = ACTIONS(583),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym_command_substitution] = STATE(82),
    [sym_simple_expansion] = STATE(82),
    [aux_sym_string_repeat1] = STATE(160),
    [sym_expansion] = STATE(82),
    [anon_sym_DOLLAR] = ACTIONS(587),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(255),
    [anon_sym_DQUOTE] = ACTIONS(573),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(259),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(261),
    [sym__string_content] = ACTIONS(263),
  },
  [84] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_BQUOTE] = ACTIONS(589),
  },
  [85] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(591),
    [anon_sym_LF] = ACTIONS(593),
    [anon_sym_SEMI] = ACTIONS(591),
    [anon_sym_SEMI_SEMI] = ACTIONS(591),
    [anon_sym_in] = ACTIONS(595),
  },
  [86] = {
    [sym_command_substitution] = STATE(559),
    [sym_unary_expression] = STATE(165),
    [sym_postfix_expression] = STATE(165),
    [sym_string] = STATE(559),
    [aux_sym__literal_repeat1] = STATE(561),
    [sym_process_substitution] = STATE(559),
    [sym_parenthesized_expression] = STATE(165),
    [sym_simple_expansion] = STATE(559),
    [sym_string_expansion] = STATE(559),
    [sym__expression] = STATE(165),
    [sym_binary_expression] = STATE(165),
    [sym_concatenation] = STATE(165),
    [sym_expansion] = STATE(559),
    [sym_word] = ACTIONS(597),
    [anon_sym_LPAREN] = ACTIONS(599),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(601),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(603),
    [sym_raw_string] = ACTIONS(597),
    [anon_sym_LF] = ACTIONS(605),
    [anon_sym_BANG] = ACTIONS(607),
    [anon_sym_SEMI] = ACTIONS(605),
    [anon_sym_DOLLAR] = ACTIONS(609),
    [anon_sym_AMP] = ACTIONS(605),
    [anon_sym_LT_LPAREN] = ACTIONS(611),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [sym_test_operator] = ACTIONS(607),
    [anon_sym_BQUOTE] = ACTIONS(615),
    [anon_sym_GT_LPAREN] = ACTIONS(611),
    [sym_ansii_c_string] = ACTIONS(597),
    [sym__special_character] = ACTIONS(617),
    [anon_sym_SEMI_SEMI] = ACTIONS(605),
  },
  [87] = {
    [sym_do_group] = STATE(167),
    [sym_comment] = ACTIONS(19),
    [anon_sym_do] = ACTIONS(619),
  },
  [88] = {
    [anon_sym_BANG_EQ] = ACTIONS(621),
    [anon_sym_PLUS_EQ] = ACTIONS(621),
    [anon_sym_PLUS_PLUS] = ACTIONS(623),
    [anon_sym_RBRACK] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(625),
    [anon_sym_GT] = ACTIONS(625),
    [anon_sym_EQ] = ACTIONS(625),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(627),
    [anon_sym_PIPE_PIPE] = ACTIONS(621),
    [anon_sym_GT_EQ] = ACTIONS(621),
    [anon_sym_PLUS] = ACTIONS(625),
    [anon_sym_LT] = ACTIONS(625),
    [sym_test_operator] = ACTIONS(621),
    [anon_sym_EQ_TILDE] = ACTIONS(627),
    [anon_sym_DASH_DASH] = ACTIONS(623),
    [anon_sym_LT_EQ] = ACTIONS(621),
    [anon_sym_AMP_AMP] = ACTIONS(621),
    [anon_sym_DASH_EQ] = ACTIONS(621),
  },
  [89] = {
    [anon_sym_BANG_EQ] = ACTIONS(483),
    [anon_sym_PLUS_EQ] = ACTIONS(483),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_EQ] = ACTIONS(487),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_PIPE_PIPE] = ACTIONS(483),
    [anon_sym_GT_EQ] = ACTIONS(483),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(491),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_LT] = ACTIONS(487),
    [sym_test_operator] = ACTIONS(483),
    [anon_sym_EQ_TILDE] = ACTIONS(489),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(483),
    [anon_sym_AMP_AMP] = ACTIONS(483),
    [anon_sym_DASH_EQ] = ACTIONS(483),
  },
  [90] = {
    [sym_word] = ACTIONS(189),
    [anon_sym_AMP_GT_GT] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [anon_sym_LT_LT] = ACTIONS(189),
    [anon_sym_LT_LPAREN] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_PIPE] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(189),
    [anon_sym_LT_AMP] = ACTIONS(189),
    [anon_sym_GT_GT] = ACTIONS(189),
    [anon_sym_EQ_TILDE] = ACTIONS(189),
    [sym__special_character] = ACTIONS(189),
    [anon_sym_LT_LT_DASH] = ACTIONS(189),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(189),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(189),
    [sym_file_descriptor] = ACTIONS(191),
    [anon_sym_AMP] = ACTIONS(189),
    [anon_sym_GT] = ACTIONS(189),
    [anon_sym_AMP_GT] = ACTIONS(189),
    [anon_sym_EQ_EQ] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_LT_LT_LT] = ACTIONS(189),
    [anon_sym_GT_AMP] = ACTIONS(189),
    [ts_builtin_sym_end] = ACTIONS(191),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [anon_sym_GT_LPAREN] = ACTIONS(189),
    [sym_ansii_c_string] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_SEMI_SEMI] = ACTIONS(189),
    [anon_sym_PIPE_AMP] = ACTIONS(189),
  },
  [91] = {
    [aux_sym__literal_repeat1] = STATE(91),
    [sym_word] = ACTIONS(629),
    [anon_sym_AMP_GT_GT] = ACTIONS(629),
    [anon_sym_DOLLAR] = ACTIONS(629),
    [anon_sym_LT_LT] = ACTIONS(629),
    [anon_sym_LT_LPAREN] = ACTIONS(629),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(629),
    [anon_sym_PIPE] = ACTIONS(629),
    [anon_sym_LT] = ACTIONS(629),
    [anon_sym_LT_AMP] = ACTIONS(629),
    [anon_sym_GT_GT] = ACTIONS(629),
    [anon_sym_EQ_TILDE] = ACTIONS(629),
    [sym__special_character] = ACTIONS(631),
    [anon_sym_LT_LT_DASH] = ACTIONS(629),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(629),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(629),
    [anon_sym_LF] = ACTIONS(634),
    [anon_sym_SEMI] = ACTIONS(629),
    [sym_raw_string] = ACTIONS(629),
    [sym_file_descriptor] = ACTIONS(634),
    [anon_sym_AMP] = ACTIONS(629),
    [anon_sym_GT] = ACTIONS(629),
    [anon_sym_AMP_GT] = ACTIONS(629),
    [anon_sym_EQ_EQ] = ACTIONS(629),
    [anon_sym_DQUOTE] = ACTIONS(629),
    [anon_sym_LT_LT_LT] = ACTIONS(629),
    [anon_sym_GT_AMP] = ACTIONS(629),
    [ts_builtin_sym_end] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(629),
    [anon_sym_GT_LPAREN] = ACTIONS(629),
    [sym_ansii_c_string] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(629),
    [anon_sym_SEMI_SEMI] = ACTIONS(629),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
  },
  [92] = {
    [aux_sym__literal_repeat1] = STATE(27),
    [sym_if_statement] = STATE(168),
    [sym_function_definition] = STATE(168),
    [sym_negated_command] = STATE(168),
    [sym_test_command] = STATE(168),
    [sym_variable_assignment] = STATE(169),
    [sym_subscript] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_expansion] = STATE(15),
    [sym_command_substitution] = STATE(15),
    [sym_redirected_statement] = STATE(168),
    [sym_for_statement] = STATE(168),
    [sym_compound_statement] = STATE(168),
    [sym_subshell] = STATE(168),
    [sym_declaration_command] = STATE(168),
    [sym_unset_command] = STATE(168),
    [sym_file_redirect] = STATE(34),
    [sym_string] = STATE(15),
    [sym_process_substitution] = STATE(15),
    [aux_sym_command_repeat1] = STATE(34),
    [sym_c_style_for_statement] = STATE(168),
    [sym_while_statement] = STATE(168),
    [sym_case_statement] = STATE(168),
    [sym_pipeline] = STATE(168),
    [sym_list] = STATE(168),
    [sym_command] = STATE(168),
    [sym_command_name] = STATE(36),
    [sym_simple_expansion] = STATE(15),
    [sym_string_expansion] = STATE(15),
    [sym_word] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(11),
    [anon_sym_typeset] = ACTIONS(11),
    [anon_sym_unsetenv] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LT_LPAREN] = ACTIONS(17),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [sym__special_character] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(33),
    [sym_raw_string] = ACTIONS(35),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_declare] = ACTIONS(11),
    [sym_variable_name] = ACTIONS(41),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(45),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(11),
    [anon_sym_unset] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(49),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_ansii_c_string] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(59),
  },
  [93] = {
    [sym_heredoc_body] = STATE(172),
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__simple_heredoc_body] = ACTIONS(640),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [sym__heredoc_body_beginning] = ACTIONS(642),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [ts_builtin_sym_end] = ACTIONS(644),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [94] = {
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [ts_builtin_sym_end] = ACTIONS(644),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [95] = {
    [sym_heredoc_start] = ACTIONS(646),
    [sym_comment] = ACTIONS(19),
  },
  [96] = {
    [aux_sym__literal_repeat1] = STATE(27),
    [sym_if_statement] = STATE(174),
    [sym_function_definition] = STATE(174),
    [sym_negated_command] = STATE(174),
    [sym_test_command] = STATE(174),
    [sym_variable_assignment] = STATE(175),
    [sym_subscript] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_expansion] = STATE(15),
    [sym_command_substitution] = STATE(15),
    [sym_redirected_statement] = STATE(174),
    [sym_for_statement] = STATE(174),
    [sym_compound_statement] = STATE(174),
    [sym_subshell] = STATE(174),
    [sym_declaration_command] = STATE(174),
    [sym_unset_command] = STATE(174),
    [sym_file_redirect] = STATE(34),
    [sym_string] = STATE(15),
    [sym_process_substitution] = STATE(15),
    [aux_sym_command_repeat1] = STATE(34),
    [sym_c_style_for_statement] = STATE(174),
    [sym_while_statement] = STATE(174),
    [sym_case_statement] = STATE(174),
    [sym_pipeline] = STATE(174),
    [sym_list] = STATE(174),
    [sym_command] = STATE(174),
    [sym_command_name] = STATE(36),
    [sym_simple_expansion] = STATE(15),
    [sym_string_expansion] = STATE(15),
    [sym_word] = ACTIONS(5),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(11),
    [anon_sym_typeset] = ACTIONS(11),
    [anon_sym_unsetenv] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LT_LPAREN] = ACTIONS(17),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [sym__special_character] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(33),
    [sym_raw_string] = ACTIONS(35),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_declare] = ACTIONS(11),
    [sym_variable_name] = ACTIONS(41),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(45),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(11),
    [anon_sym_unset] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(49),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(17),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_while] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_ansii_c_string] = ACTIONS(35),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(59),
  },
  [97] = {
    [sym_command_substitution] = STATE(176),
    [aux_sym__literal_repeat1] = STATE(177),
    [sym_string] = STATE(176),
    [sym_process_substitution] = STATE(176),
    [sym_simple_expansion] = STATE(176),
    [sym_string_expansion] = STATE(176),
    [sym_concatenation] = STATE(178),
    [sym_expansion] = STATE(176),
    [sym_word] = ACTIONS(648),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(650),
    [anon_sym_DQUOTE] = ACTIONS(652),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(654),
    [sym_raw_string] = ACTIONS(648),
    [anon_sym_BQUOTE] = ACTIONS(656),
    [anon_sym_DOLLAR] = ACTIONS(658),
    [sym_ansii_c_string] = ACTIONS(648),
    [anon_sym_GT_LPAREN] = ACTIONS(660),
    [anon_sym_LT_LPAREN] = ACTIONS(660),
    [sym__special_character] = ACTIONS(662),
    [sym_comment] = ACTIONS(19),
  },
  [98] = {
    [sym_heredoc_redirect] = STATE(179),
    [aux_sym_redirected_statement_repeat1] = STATE(179),
    [sym_herestring_redirect] = STATE(179),
    [sym_file_redirect] = STATE(179),
    [anon_sym_LT_LT_DASH] = ACTIONS(313),
    [anon_sym_AMP_GT_GT] = ACTIONS(307),
    [anon_sym_LF] = ACTIONS(664),
    [anon_sym_SEMI] = ACTIONS(666),
    [anon_sym_LT_LT] = ACTIONS(313),
    [anon_sym_AMP] = ACTIONS(666),
    [anon_sym_GT] = ACTIONS(307),
    [sym_file_descriptor] = ACTIONS(311),
    [anon_sym_AMP_GT] = ACTIONS(307),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(666),
    [ts_builtin_sym_end] = ACTIONS(664),
    [anon_sym_LT_LT_LT] = ACTIONS(319),
    [anon_sym_PIPE] = ACTIONS(666),
    [anon_sym_GT_AMP] = ACTIONS(307),
    [anon_sym_LT] = ACTIONS(307),
    [anon_sym_LT_AMP] = ACTIONS(307),
    [anon_sym_GT_GT] = ACTIONS(307),
    [anon_sym_AMP_AMP] = ACTIONS(666),
    [anon_sym_SEMI_SEMI] = ACTIONS(666),
    [anon_sym_PIPE_AMP] = ACTIONS(666),
  },
  [99] = {
    [sym_heredoc_redirect] = STATE(98),
    [aux_sym_redirected_statement_repeat1] = STATE(98),
    [sym_herestring_redirect] = STATE(98),
    [sym_file_redirect] = STATE(98),
    [anon_sym_PIPE_AMP] = ACTIONS(321),
    [anon_sym_AMP_GT_GT] = ACTIONS(307),
    [anon_sym_LF] = ACTIONS(668),
    [anon_sym_SEMI] = ACTIONS(670),
    [sym_file_descriptor] = ACTIONS(311),
    [anon_sym_LT_LT] = ACTIONS(313),
    [anon_sym_GT] = ACTIONS(307),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_AMP_GT] = ACTIONS(307),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(315),
    [ts_builtin_sym_end] = ACTIONS(644),
    [anon_sym_LT_LT_LT] = ACTIONS(319),
    [anon_sym_GT_AMP] = ACTIONS(307),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_LT] = ACTIONS(307),
    [anon_sym_LT_AMP] = ACTIONS(307),
    [anon_sym_GT_GT] = ACTIONS(307),
    [anon_sym_AMP_AMP] = ACTIONS(315),
    [anon_sym_SEMI_SEMI] = ACTIONS(670),
    [anon_sym_LT_LT_DASH] = ACTIONS(313),
  },
  [100] = {
    [sym_heredoc_redirect] = STATE(98),
    [aux_sym_redirected_statement_repeat1] = STATE(98),
    [sym_herestring_redirect] = STATE(98),
    [sym_file_redirect] = STATE(98),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(313),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(315),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(313),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(668),
    [anon_sym_SEMI] = ACTIONS(670),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(670),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [ts_builtin_sym_end] = ACTIONS(644),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(315),
    [anon_sym_SEMI_SEMI] = ACTIONS(670),
    [anon_sym_PIPE_AMP] = ACTIONS(321),
  },
  [101] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(1371),
    [sym_function_definition] = STATE(1371),
    [sym_negated_command] = STATE(1371),
    [sym_test_command] = STATE(1371),
    [sym_variable_assignment] = STATE(1372),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(101),
    [sym_redirected_statement] = STATE(1371),
    [sym_for_statement] = STATE(1371),
    [sym_compound_statement] = STATE(1371),
    [sym_subshell] = STATE(1371),
    [sym_declaration_command] = STATE(1371),
    [sym_unset_command] = STATE(1371),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_c_style_for_statement] = STATE(1371),
    [sym_while_statement] = STATE(1371),
    [sym_case_statement] = STATE(1371),
    [sym_pipeline] = STATE(1371),
    [sym_list] = STATE(1371),
    [sym_command] = STATE(1371),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [anon_sym_LPAREN] = ACTIONS(672),
    [sym_word] = ACTIONS(675),
    [anon_sym_AMP_GT_GT] = ACTIONS(678),
    [anon_sym_local] = ACTIONS(681),
    [anon_sym_typeset] = ACTIONS(681),
    [anon_sym_unsetenv] = ACTIONS(684),
    [anon_sym_DOLLAR] = ACTIONS(687),
    [anon_sym_LT_LPAREN] = ACTIONS(690),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(693),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_LT] = ACTIONS(699),
    [anon_sym_LT_AMP] = ACTIONS(678),
    [anon_sym_GT_GT] = ACTIONS(678),
    [anon_sym_export] = ACTIONS(681),
    [sym__special_character] = ACTIONS(702),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_case] = ACTIONS(708),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(711),
    [sym_raw_string] = ACTIONS(714),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_declare] = ACTIONS(681),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(723),
    [sym_file_descriptor] = ACTIONS(726),
    [sym_variable_name] = ACTIONS(729),
    [anon_sym_GT] = ACTIONS(699),
    [anon_sym_AMP_GT] = ACTIONS(699),
    [anon_sym_readonly] = ACTIONS(681),
    [anon_sym_unset] = ACTIONS(684),
    [anon_sym_DQUOTE] = ACTIONS(732),
    [anon_sym_GT_AMP] = ACTIONS(678),
    [anon_sym_BQUOTE] = ACTIONS(735),
    [anon_sym_GT_LPAREN] = ACTIONS(690),
    [anon_sym_for] = ACTIONS(738),
    [anon_sym_while] = ACTIONS(741),
    [anon_sym_LBRACK] = ACTIONS(744),
    [sym_ansii_c_string] = ACTIONS(714),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(747),
  },
  [102] = {
    [sym_command_substitution] = STATE(104),
    [aux_sym__literal_repeat1] = STATE(106),
    [sym_string] = STATE(104),
    [sym_process_substitution] = STATE(104),
    [sym_simple_expansion] = STATE(104),
    [sym_string_expansion] = STATE(104),
    [aux_sym_command_repeat2] = STATE(182),
    [sym_concatenation] = STATE(182),
    [sym_expansion] = STATE(104),
    [sym_word] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(750),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LT_LT] = ACTIONS(750),
    [anon_sym_LT_LPAREN] = ACTIONS(337),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(750),
    [anon_sym_PIPE] = ACTIONS(750),
    [anon_sym_LT] = ACTIONS(750),
    [anon_sym_LT_AMP] = ACTIONS(750),
    [anon_sym_GT_GT] = ACTIONS(750),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [sym__special_character] = ACTIONS(27),
    [anon_sym_LT_LT_DASH] = ACTIONS(750),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(341),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(343),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [sym_raw_string] = ACTIONS(333),
    [sym_file_descriptor] = ACTIONS(752),
    [anon_sym_AMP] = ACTIONS(750),
    [anon_sym_GT] = ACTIONS(750),
    [anon_sym_AMP_GT] = ACTIONS(750),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [ts_builtin_sym_end] = ACTIONS(752),
    [anon_sym_LT_LT_LT] = ACTIONS(750),
    [anon_sym_GT_AMP] = ACTIONS(750),
    [anon_sym_DQUOTE] = ACTIONS(347),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(337),
    [sym_ansii_c_string] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(750),
    [anon_sym_SEMI_SEMI] = ACTIONS(750),
    [anon_sym_PIPE_AMP] = ACTIONS(750),
  },
  [103] = {
    [sym_variable_assignment] = STATE(103),
    [sym_subscript] = STATE(2455),
    [aux_sym_command_repeat1] = STATE(103),
    [sym_file_redirect] = STATE(103),
    [sym_word] = ACTIONS(754),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(754),
    [anon_sym_AMP_GT_GT] = ACTIONS(756),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(754),
    [sym_raw_string] = ACTIONS(754),
    [anon_sym_DOLLAR] = ACTIONS(759),
    [sym_file_descriptor] = ACTIONS(761),
    [sym_variable_name] = ACTIONS(764),
    [anon_sym_GT] = ACTIONS(767),
    [anon_sym_LT_LPAREN] = ACTIONS(754),
    [anon_sym_AMP_GT] = ACTIONS(767),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(754),
    [anon_sym_GT_AMP] = ACTIONS(756),
    [anon_sym_LT] = ACTIONS(767),
    [anon_sym_LT_AMP] = ACTIONS(756),
    [anon_sym_GT_GT] = ACTIONS(756),
    [sym_ansii_c_string] = ACTIONS(754),
    [anon_sym_BQUOTE] = ACTIONS(754),
    [anon_sym_GT_LPAREN] = ACTIONS(754),
    [sym__special_character] = ACTIONS(754),
  },
  [104] = {
    [aux_sym_concatenation_repeat1] = STATE(39),
    [sym_word] = ACTIONS(770),
    [anon_sym_AMP_GT_GT] = ACTIONS(770),
    [anon_sym_DOLLAR] = ACTIONS(770),
    [anon_sym_LT_LT] = ACTIONS(770),
    [anon_sym_LT_LPAREN] = ACTIONS(770),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(770),
    [sym__concat] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(770),
    [anon_sym_LT] = ACTIONS(770),
    [anon_sym_LT_AMP] = ACTIONS(770),
    [anon_sym_GT_GT] = ACTIONS(770),
    [anon_sym_EQ_TILDE] = ACTIONS(770),
    [sym__special_character] = ACTIONS(770),
    [anon_sym_LT_LT_DASH] = ACTIONS(770),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(770),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(770),
    [anon_sym_LF] = ACTIONS(772),
    [anon_sym_SEMI] = ACTIONS(770),
    [sym_raw_string] = ACTIONS(770),
    [sym_file_descriptor] = ACTIONS(772),
    [anon_sym_AMP] = ACTIONS(770),
    [anon_sym_GT] = ACTIONS(770),
    [anon_sym_AMP_GT] = ACTIONS(770),
    [anon_sym_EQ_EQ] = ACTIONS(770),
    [anon_sym_DQUOTE] = ACTIONS(770),
    [anon_sym_LT_LT_LT] = ACTIONS(770),
    [anon_sym_GT_AMP] = ACTIONS(770),
    [ts_builtin_sym_end] = ACTIONS(772),
    [anon_sym_BQUOTE] = ACTIONS(770),
    [anon_sym_GT_LPAREN] = ACTIONS(770),
    [sym_ansii_c_string] = ACTIONS(770),
    [anon_sym_AMP_AMP] = ACTIONS(770),
    [anon_sym_SEMI_SEMI] = ACTIONS(770),
    [anon_sym_PIPE_AMP] = ACTIONS(770),
  },
  [105] = {
    [sym_command_substitution] = STATE(183),
    [aux_sym__literal_repeat1] = STATE(185),
    [sym_string] = STATE(183),
    [sym_process_substitution] = STATE(183),
    [sym_simple_expansion] = STATE(183),
    [sym_string_expansion] = STATE(183),
    [sym_concatenation] = STATE(184),
    [sym_expansion] = STATE(183),
    [sym_word] = ACTIONS(774),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(49),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(37),
    [sym_raw_string] = ACTIONS(774),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [sym_ansii_c_string] = ACTIONS(774),
    [anon_sym_GT_LPAREN] = ACTIONS(17),
    [anon_sym_LT_LPAREN] = ACTIONS(17),
    [sym__special_character] = ACTIONS(329),
    [sym_regex] = ACTIONS(776),
    [sym_comment] = ACTIONS(19),
  },
  [106] = {
    [aux_sym__literal_repeat1] = STATE(91),
    [sym_word] = ACTIONS(778),
    [anon_sym_AMP_GT_GT] = ACTIONS(778),
    [anon_sym_DOLLAR] = ACTIONS(778),
    [anon_sym_LT_LT] = ACTIONS(778),
    [anon_sym_LT_LPAREN] = ACTIONS(778),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_LT] = ACTIONS(778),
    [anon_sym_LT_AMP] = ACTIONS(778),
    [anon_sym_GT_GT] = ACTIONS(778),
    [anon_sym_EQ_TILDE] = ACTIONS(778),
    [sym__special_character] = ACTIONS(301),
    [anon_sym_LT_LT_DASH] = ACTIONS(778),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(778),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(778),
    [anon_sym_LF] = ACTIONS(780),
    [anon_sym_SEMI] = ACTIONS(778),
    [sym_raw_string] = ACTIONS(778),
    [sym_file_descriptor] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(778),
    [anon_sym_GT] = ACTIONS(778),
    [anon_sym_AMP_GT] = ACTIONS(778),
    [anon_sym_EQ_EQ] = ACTIONS(778),
    [anon_sym_DQUOTE] = ACTIONS(778),
    [anon_sym_LT_LT_LT] = ACTIONS(778),
    [anon_sym_GT_AMP] = ACTIONS(778),
    [ts_builtin_sym_end] = ACTIONS(780),
    [anon_sym_BQUOTE] = ACTIONS(778),
    [anon_sym_GT_LPAREN] = ACTIONS(778),
    [sym_ansii_c_string] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(778),
    [anon_sym_SEMI_SEMI] = ACTIONS(778),
    [anon_sym_PIPE_AMP] = ACTIONS(778),
  },
  [107] = {
    [sym_command_substitution] = STATE(104),
    [aux_sym__literal_repeat1] = STATE(106),
    [sym_string] = STATE(104),
    [sym_process_substitution] = STATE(104),
    [sym_simple_expansion] = STATE(104),
    [sym_string_expansion] = STATE(104),
    [aux_sym_command_repeat2] = STATE(186),
    [sym_concatenation] = STATE(186),
    [sym_expansion] = STATE(104),
    [sym_word] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(750),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LT_LT] = ACTIONS(750),
    [anon_sym_LT_LPAREN] = ACTIONS(337),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(750),
    [anon_sym_PIPE] = ACTIONS(750),
    [anon_sym_LT] = ACTIONS(750),
    [anon_sym_LT_AMP] = ACTIONS(750),
    [anon_sym_GT_GT] = ACTIONS(750),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [sym__special_character] = ACTIONS(27),
    [anon_sym_LT_LT_DASH] = ACTIONS(750),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(341),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(343),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [sym_raw_string] = ACTIONS(333),
    [sym_file_descriptor] = ACTIONS(752),
    [anon_sym_AMP] = ACTIONS(750),
    [anon_sym_GT] = ACTIONS(750),
    [anon_sym_AMP_GT] = ACTIONS(750),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [ts_builtin_sym_end] = ACTIONS(752),
    [anon_sym_LT_LT_LT] = ACTIONS(750),
    [anon_sym_GT_AMP] = ACTIONS(750),
    [anon_sym_DQUOTE] = ACTIONS(347),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(337),
    [sym_ansii_c_string] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(750),
    [anon_sym_SEMI_SEMI] = ACTIONS(750),
    [anon_sym_PIPE_AMP] = ACTIONS(750),
  },
  [108] = {
    [sym_compound_statement] = STATE(187),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_comment] = ACTIONS(19),
  },
  [109] = {
    [sym_word] = ACTIONS(782),
    [anon_sym_AMP_GT_GT] = ACTIONS(782),
    [anon_sym_DOLLAR] = ACTIONS(782),
    [anon_sym_LT_LT] = ACTIONS(782),
    [anon_sym_LT_LPAREN] = ACTIONS(782),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(782),
    [sym__concat] = ACTIONS(784),
    [anon_sym_PIPE] = ACTIONS(782),
    [anon_sym_LT] = ACTIONS(782),
    [anon_sym_LT_AMP] = ACTIONS(782),
    [anon_sym_GT_GT] = ACTIONS(782),
    [anon_sym_EQ_TILDE] = ACTIONS(782),
    [sym__special_character] = ACTIONS(782),
    [anon_sym_LT_LT_DASH] = ACTIONS(782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(782),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(782),
    [anon_sym_LF] = ACTIONS(784),
    [anon_sym_SEMI] = ACTIONS(782),
    [sym_raw_string] = ACTIONS(782),
    [sym_file_descriptor] = ACTIONS(784),
    [anon_sym_AMP] = ACTIONS(782),
    [anon_sym_GT] = ACTIONS(782),
    [anon_sym_AMP_GT] = ACTIONS(782),
    [anon_sym_EQ_EQ] = ACTIONS(782),
    [anon_sym_DQUOTE] = ACTIONS(782),
    [anon_sym_LT_LT_LT] = ACTIONS(782),
    [anon_sym_GT_AMP] = ACTIONS(782),
    [ts_builtin_sym_end] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(782),
    [anon_sym_GT_LPAREN] = ACTIONS(782),
    [sym_ansii_c_string] = ACTIONS(782),
    [anon_sym_AMP_AMP] = ACTIONS(782),
    [anon_sym_SEMI_SEMI] = ACTIONS(782),
    [anon_sym_PIPE_AMP] = ACTIONS(782),
  },
  [110] = {
    [sym_command_substitution] = STATE(109),
    [sym_simple_expansion] = STATE(109),
    [sym_string_expansion] = STATE(109),
    [sym_string] = STATE(109),
    [sym_process_substitution] = STATE(109),
    [sym_expansion] = STATE(109),
    [sym_word] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(49),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(37),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_DOLLAR] = ACTIONS(786),
    [anon_sym_GT_LPAREN] = ACTIONS(17),
    [sym_ansii_c_string] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(17),
    [sym__special_character] = ACTIONS(353),
    [sym_comment] = ACTIONS(19),
  },
  [111] = {
    [aux_sym_concatenation_repeat1] = STATE(111),
    [sym_word] = ACTIONS(782),
    [anon_sym_AMP_GT_GT] = ACTIONS(782),
    [anon_sym_DOLLAR] = ACTIONS(782),
    [anon_sym_LT_LT] = ACTIONS(782),
    [anon_sym_LT_LPAREN] = ACTIONS(782),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(782),
    [sym__concat] = ACTIONS(788),
    [anon_sym_PIPE] = ACTIONS(782),
    [anon_sym_LT] = ACTIONS(782),
    [anon_sym_LT_AMP] = ACTIONS(782),
    [anon_sym_GT_GT] = ACTIONS(782),
    [anon_sym_EQ_TILDE] = ACTIONS(782),
    [sym__special_character] = ACTIONS(782),
    [anon_sym_LT_LT_DASH] = ACTIONS(782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(782),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(782),
    [anon_sym_LF] = ACTIONS(784),
    [anon_sym_SEMI] = ACTIONS(782),
    [sym_raw_string] = ACTIONS(782),
    [sym_file_descriptor] = ACTIONS(784),
    [anon_sym_AMP] = ACTIONS(782),
    [anon_sym_GT] = ACTIONS(782),
    [anon_sym_AMP_GT] = ACTIONS(782),
    [anon_sym_EQ_EQ] = ACTIONS(782),
    [anon_sym_DQUOTE] = ACTIONS(782),
    [anon_sym_LT_LT_LT] = ACTIONS(782),
    [anon_sym_GT_AMP] = ACTIONS(782),
    [ts_builtin_sym_end] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(782),
    [anon_sym_GT_LPAREN] = ACTIONS(782),
    [sym_ansii_c_string] = ACTIONS(782),
    [anon_sym_AMP_AMP] = ACTIONS(782),
    [anon_sym_SEMI_SEMI] = ACTIONS(782),
    [anon_sym_PIPE_AMP] = ACTIONS(782),
  },
  [112] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(791),
    [anon_sym_AMP_GT_GT] = ACTIONS(791),
    [anon_sym_LF] = ACTIONS(793),
    [anon_sym_SEMI] = ACTIONS(791),
    [anon_sym_LT_LT] = ACTIONS(791),
    [anon_sym_AMP] = ACTIONS(791),
    [anon_sym_GT] = ACTIONS(791),
    [sym_file_descriptor] = ACTIONS(793),
    [anon_sym_AMP_GT] = ACTIONS(791),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(791),
    [ts_builtin_sym_end] = ACTIONS(793),
    [anon_sym_LT_LT_LT] = ACTIONS(791),
    [anon_sym_PIPE] = ACTIONS(791),
    [anon_sym_GT_AMP] = ACTIONS(791),
    [anon_sym_LT] = ACTIONS(791),
    [anon_sym_LT_AMP] = ACTIONS(791),
    [anon_sym_GT_GT] = ACTIONS(791),
    [anon_sym_AMP_AMP] = ACTIONS(791),
    [anon_sym_SEMI_SEMI] = ACTIONS(791),
    [anon_sym_PIPE_AMP] = ACTIONS(791),
  },
  [113] = {
    [sym_command_substitution] = STATE(44),
    [aux_sym__literal_repeat1] = STATE(45),
    [sym_string] = STATE(44),
    [aux_sym_declaration_command_repeat1] = STATE(113),
    [sym_process_substitution] = STATE(44),
    [sym_simple_expansion] = STATE(44),
    [sym_subscript] = STATE(2444),
    [sym_string_expansion] = STATE(44),
    [sym_variable_assignment] = STATE(113),
    [sym_concatenation] = STATE(113),
    [sym_expansion] = STATE(44),
    [sym_word] = ACTIONS(795),
    [anon_sym_AMP_GT_GT] = ACTIONS(798),
    [anon_sym_DOLLAR] = ACTIONS(800),
    [anon_sym_LT_LT] = ACTIONS(798),
    [anon_sym_LT_LPAREN] = ACTIONS(803),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(798),
    [anon_sym_PIPE] = ACTIONS(798),
    [anon_sym_LT] = ACTIONS(798),
    [anon_sym_LT_AMP] = ACTIONS(798),
    [anon_sym_GT_GT] = ACTIONS(798),
    [sym__special_character] = ACTIONS(806),
    [anon_sym_LT_LT_DASH] = ACTIONS(798),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(809),
    [aux_sym__simple_variable_name_token1] = ACTIONS(812),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(815),
    [anon_sym_LF] = ACTIONS(818),
    [anon_sym_SEMI] = ACTIONS(798),
    [sym_raw_string] = ACTIONS(795),
    [sym_variable_name] = ACTIONS(820),
    [sym_file_descriptor] = ACTIONS(818),
    [anon_sym_AMP] = ACTIONS(798),
    [anon_sym_GT] = ACTIONS(798),
    [anon_sym_AMP_GT] = ACTIONS(798),
    [anon_sym_DQUOTE] = ACTIONS(823),
    [anon_sym_LT_LT_LT] = ACTIONS(798),
    [anon_sym_GT_AMP] = ACTIONS(798),
    [ts_builtin_sym_end] = ACTIONS(818),
    [anon_sym_BQUOTE] = ACTIONS(826),
    [anon_sym_GT_LPAREN] = ACTIONS(803),
    [sym_ansii_c_string] = ACTIONS(795),
    [anon_sym_AMP_AMP] = ACTIONS(798),
    [anon_sym_SEMI_SEMI] = ACTIONS(798),
    [anon_sym_PIPE_AMP] = ACTIONS(798),
  },
  [114] = {
    [sym_command_substitution] = STATE(47),
    [aux_sym__literal_repeat1] = STATE(48),
    [sym_string] = STATE(47),
    [aux_sym_unset_command_repeat1] = STATE(114),
    [sym_process_substitution] = STATE(47),
    [sym_simple_expansion] = STATE(47),
    [sym_string_expansion] = STATE(47),
    [sym_concatenation] = STATE(114),
    [sym_expansion] = STATE(47),
    [sym_word] = ACTIONS(829),
    [anon_sym_AMP_GT_GT] = ACTIONS(832),
    [anon_sym_DOLLAR] = ACTIONS(834),
    [anon_sym_LT_LT] = ACTIONS(832),
    [anon_sym_LT_LPAREN] = ACTIONS(837),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(832),
    [anon_sym_PIPE] = ACTIONS(832),
    [anon_sym_LT] = ACTIONS(832),
    [anon_sym_LT_AMP] = ACTIONS(832),
    [anon_sym_GT_GT] = ACTIONS(832),
    [sym__special_character] = ACTIONS(840),
    [anon_sym_LT_LT_DASH] = ACTIONS(832),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(843),
    [aux_sym__simple_variable_name_token1] = ACTIONS(846),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(849),
    [anon_sym_LF] = ACTIONS(852),
    [anon_sym_SEMI] = ACTIONS(832),
    [sym_raw_string] = ACTIONS(829),
    [sym_file_descriptor] = ACTIONS(852),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_GT] = ACTIONS(832),
    [anon_sym_AMP_GT] = ACTIONS(832),
    [anon_sym_DQUOTE] = ACTIONS(854),
    [anon_sym_LT_LT_LT] = ACTIONS(832),
    [anon_sym_GT_AMP] = ACTIONS(832),
    [ts_builtin_sym_end] = ACTIONS(852),
    [anon_sym_BQUOTE] = ACTIONS(857),
    [anon_sym_GT_LPAREN] = ACTIONS(837),
    [sym_ansii_c_string] = ACTIONS(829),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_SEMI_SEMI] = ACTIONS(832),
    [anon_sym_PIPE_AMP] = ACTIONS(832),
  },
  [115] = {
    [sym_word] = ACTIONS(860),
    [anon_sym_AMP_GT_GT] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(860),
    [anon_sym_LT_LT] = ACTIONS(860),
    [anon_sym_LT_LPAREN] = ACTIONS(860),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(860),
    [sym__concat] = ACTIONS(862),
    [anon_sym_PIPE] = ACTIONS(860),
    [anon_sym_LT] = ACTIONS(860),
    [anon_sym_LT_AMP] = ACTIONS(860),
    [anon_sym_GT_GT] = ACTIONS(860),
    [anon_sym_EQ_TILDE] = ACTIONS(860),
    [sym__special_character] = ACTIONS(860),
    [anon_sym_LT_LT_DASH] = ACTIONS(860),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(860),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(860),
    [anon_sym_LF] = ACTIONS(862),
    [anon_sym_SEMI] = ACTIONS(860),
    [sym_raw_string] = ACTIONS(860),
    [sym_file_descriptor] = ACTIONS(862),
    [anon_sym_AMP] = ACTIONS(860),
    [anon_sym_GT] = ACTIONS(860),
    [anon_sym_AMP_GT] = ACTIONS(860),
    [anon_sym_EQ_EQ] = ACTIONS(860),
    [anon_sym_DQUOTE] = ACTIONS(860),
    [anon_sym_LT_LT_LT] = ACTIONS(860),
    [anon_sym_GT_AMP] = ACTIONS(860),
    [ts_builtin_sym_end] = ACTIONS(862),
    [anon_sym_BQUOTE] = ACTIONS(860),
    [anon_sym_GT_LPAREN] = ACTIONS(860),
    [sym_ansii_c_string] = ACTIONS(860),
    [anon_sym_AMP_AMP] = ACTIONS(860),
    [anon_sym_SEMI_SEMI] = ACTIONS(860),
    [anon_sym_PIPE_AMP] = ACTIONS(860),
  },
  [116] = {
    [anon_sym_RPAREN] = ACTIONS(864),
    [sym_comment] = ACTIONS(19),
  },
  [117] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(866),
    [anon_sym_AMP_GT_GT] = ACTIONS(866),
    [anon_sym_LF] = ACTIONS(868),
    [anon_sym_SEMI] = ACTIONS(866),
    [anon_sym_LT_LT] = ACTIONS(866),
    [anon_sym_AMP] = ACTIONS(866),
    [anon_sym_GT] = ACTIONS(866),
    [sym_file_descriptor] = ACTIONS(868),
    [anon_sym_AMP_GT] = ACTIONS(866),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(866),
    [ts_builtin_sym_end] = ACTIONS(868),
    [anon_sym_LT_LT_LT] = ACTIONS(866),
    [anon_sym_PIPE] = ACTIONS(866),
    [anon_sym_GT_AMP] = ACTIONS(866),
    [anon_sym_LT] = ACTIONS(866),
    [anon_sym_LT_AMP] = ACTIONS(866),
    [anon_sym_GT_GT] = ACTIONS(866),
    [anon_sym_AMP_AMP] = ACTIONS(866),
    [anon_sym_SEMI_SEMI] = ACTIONS(866),
    [anon_sym_PIPE_AMP] = ACTIONS(866),
  },
  [118] = {
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [anon_sym_RBRACE] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [119] = {
    [sym_heredoc_body] = STATE(190),
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__simple_heredoc_body] = ACTIONS(870),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [anon_sym_RBRACE] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [sym__heredoc_body_beginning] = ACTIONS(872),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [120] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(874),
    [anon_sym_AMP_GT_GT] = ACTIONS(874),
    [anon_sym_LF] = ACTIONS(876),
    [anon_sym_SEMI] = ACTIONS(874),
    [anon_sym_LT_LT] = ACTIONS(874),
    [anon_sym_AMP] = ACTIONS(874),
    [anon_sym_GT] = ACTIONS(874),
    [sym_file_descriptor] = ACTIONS(876),
    [anon_sym_AMP_GT] = ACTIONS(874),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(874),
    [ts_builtin_sym_end] = ACTIONS(876),
    [anon_sym_LT_LT_LT] = ACTIONS(874),
    [anon_sym_PIPE] = ACTIONS(874),
    [anon_sym_GT_AMP] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(874),
    [anon_sym_LT_AMP] = ACTIONS(874),
    [anon_sym_GT_GT] = ACTIONS(874),
    [anon_sym_AMP_AMP] = ACTIONS(874),
    [anon_sym_SEMI_SEMI] = ACTIONS(874),
    [anon_sym_PIPE_AMP] = ACTIONS(874),
  },
  [121] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(194),
    [sym_function_definition] = STATE(194),
    [sym_negated_command] = STATE(194),
    [sym_test_command] = STATE(194),
    [sym_variable_assignment] = STATE(195),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(194),
    [sym_for_statement] = STATE(194),
    [sym_elif_clause] = STATE(197),
    [sym_else_clause] = STATE(196),
    [sym_compound_statement] = STATE(194),
    [sym_subshell] = STATE(194),
    [sym_declaration_command] = STATE(194),
    [sym_unset_command] = STATE(194),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_if_statement_repeat1] = STATE(197),
    [aux_sym_command_repeat1] = STATE(391),
    [aux_sym__statements2] = STATE(198),
    [sym_c_style_for_statement] = STATE(194),
    [sym_while_statement] = STATE(194),
    [sym_case_statement] = STATE(194),
    [sym_pipeline] = STATE(194),
    [sym_list] = STATE(194),
    [sym_command] = STATE(194),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [anon_sym_fi] = ACTIONS(878),
    [anon_sym_else] = ACTIONS(880),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_elif] = ACTIONS(882),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
  },
  [122] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_then] = ACTIONS(884),
    [anon_sym_do] = ACTIONS(884),
  },
  [123] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_in] = ACTIONS(886),
  },
  [124] = {
    [anon_sym_AMP] = ACTIONS(888),
    [anon_sym_LF] = ACTIONS(890),
    [anon_sym_SEMI] = ACTIONS(888),
    [anon_sym_SEMI_SEMI] = ACTIONS(888),
    [sym_comment] = ACTIONS(3),
  },
  [125] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_in] = ACTIONS(892),
  },
  [126] = {
    [anon_sym_AMP] = ACTIONS(894),
    [anon_sym_LF] = ACTIONS(896),
    [anon_sym_SEMI] = ACTIONS(894),
    [anon_sym_SEMI_SEMI] = ACTIONS(894),
    [sym_comment] = ACTIONS(3),
  },
  [127] = {
    [anon_sym_PLUS_EQ] = ACTIONS(483),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(487),
    [sym_comment] = ACTIONS(19),
    [anon_sym_PIPE_PIPE] = ACTIONS(483),
    [sym_test_operator] = ACTIONS(483),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_EQ_TILDE] = ACTIONS(489),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(483),
    [anon_sym_DASH_EQ] = ACTIONS(483),
    [anon_sym_BANG_EQ] = ACTIONS(483),
    [anon_sym_RPAREN] = ACTIONS(898),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_EQ] = ACTIONS(487),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_GT_EQ] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_AMP_AMP] = ACTIONS(483),
  },
  [128] = {
    [anon_sym_PLUS_EQ] = ACTIONS(483),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(487),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(900),
    [anon_sym_PIPE_PIPE] = ACTIONS(483),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(900),
    [sym_test_operator] = ACTIONS(483),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_EQ_TILDE] = ACTIONS(489),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(483),
    [anon_sym_DASH_EQ] = ACTIONS(483),
    [anon_sym_BANG_EQ] = ACTIONS(483),
    [anon_sym_RPAREN] = ACTIONS(902),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_EQ] = ACTIONS(487),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_GT_EQ] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_AMP_AMP] = ACTIONS(483),
  },
  [129] = {
    [aux_sym__literal_repeat1] = STATE(68),
    [sym_unary_expression] = STATE(204),
    [sym_postfix_expression] = STATE(204),
    [sym_string] = STATE(65),
    [sym_process_substitution] = STATE(65),
    [sym__expression] = STATE(204),
    [sym_binary_expression] = STATE(204),
    [sym_concatenation] = STATE(204),
    [sym_expansion] = STATE(65),
    [sym_command_substitution] = STATE(65),
    [sym_parenthesized_expression] = STATE(204),
    [sym_simple_expansion] = STATE(65),
    [sym_string_expansion] = STATE(65),
    [sym_word] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_BANG] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [sym_test_operator] = ACTIONS(227),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [sym_ansii_c_string] = ACTIONS(217),
    [sym__special_character] = ACTIONS(231),
  },
  [130] = {
    [anon_sym_PLUS_EQ] = ACTIONS(904),
    [anon_sym_PLUS_PLUS] = ACTIONS(904),
    [anon_sym_DASH] = ACTIONS(906),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(904),
    [anon_sym_PIPE_PIPE] = ACTIONS(904),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(904),
    [sym_test_operator] = ACTIONS(904),
    [anon_sym_LT] = ACTIONS(906),
    [anon_sym_EQ_TILDE] = ACTIONS(904),
    [anon_sym_DASH_DASH] = ACTIONS(904),
    [anon_sym_LT_EQ] = ACTIONS(904),
    [anon_sym_DASH_EQ] = ACTIONS(904),
    [anon_sym_BANG_EQ] = ACTIONS(904),
    [anon_sym_RPAREN] = ACTIONS(906),
    [anon_sym_GT] = ACTIONS(906),
    [anon_sym_EQ] = ACTIONS(906),
    [anon_sym_EQ_EQ] = ACTIONS(904),
    [anon_sym_GT_EQ] = ACTIONS(904),
    [anon_sym_PLUS] = ACTIONS(906),
    [anon_sym_AMP_AMP] = ACTIONS(904),
  },
  [131] = {
    [aux_sym__literal_repeat1] = STATE(68),
    [sym_unary_expression] = STATE(204),
    [sym_postfix_expression] = STATE(204),
    [sym_string] = STATE(65),
    [sym_process_substitution] = STATE(65),
    [sym__expression] = STATE(204),
    [sym_binary_expression] = STATE(204),
    [sym_concatenation] = STATE(204),
    [sym_expansion] = STATE(65),
    [sym_command_substitution] = STATE(65),
    [sym_parenthesized_expression] = STATE(204),
    [sym_simple_expansion] = STATE(65),
    [sym_string_expansion] = STATE(65),
    [sym_word] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_BANG] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [sym_test_operator] = ACTIONS(227),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [sym_ansii_c_string] = ACTIONS(217),
    [sym__special_character] = ACTIONS(231),
    [sym_regex] = ACTIONS(908),
  },
  [132] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(910),
    [anon_sym_AMP_GT_GT] = ACTIONS(910),
    [anon_sym_LF] = ACTIONS(912),
    [anon_sym_SEMI] = ACTIONS(910),
    [anon_sym_LT_LT] = ACTIONS(910),
    [anon_sym_AMP] = ACTIONS(910),
    [anon_sym_GT] = ACTIONS(910),
    [sym_file_descriptor] = ACTIONS(912),
    [anon_sym_AMP_GT] = ACTIONS(910),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(910),
    [ts_builtin_sym_end] = ACTIONS(912),
    [anon_sym_LT_LT_LT] = ACTIONS(910),
    [anon_sym_PIPE] = ACTIONS(910),
    [anon_sym_GT_AMP] = ACTIONS(910),
    [anon_sym_LT] = ACTIONS(910),
    [anon_sym_LT_AMP] = ACTIONS(910),
    [anon_sym_GT_GT] = ACTIONS(910),
    [anon_sym_AMP_AMP] = ACTIONS(910),
    [anon_sym_SEMI_SEMI] = ACTIONS(910),
    [anon_sym_PIPE_AMP] = ACTIONS(910),
  },
  [133] = {
    [aux_sym_concatenation_repeat1] = STATE(905),
    [sym_word] = ACTIONS(914),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(916),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(916),
    [sym_raw_string] = ACTIONS(916),
    [anon_sym_COLON] = ACTIONS(914),
    [anon_sym_DOLLAR] = ACTIONS(914),
    [anon_sym_RBRACE] = ACTIONS(916),
    [anon_sym_DASH] = ACTIONS(914),
    [anon_sym_PERCENT] = ACTIONS(914),
    [anon_sym_EQ] = ACTIONS(914),
    [anon_sym_POUND] = ACTIONS(916),
    [anon_sym_COLON_DASH] = ACTIONS(914),
    [anon_sym_LT_LPAREN] = ACTIONS(916),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(916),
    [sym__concat] = ACTIONS(918),
    [anon_sym_BQUOTE] = ACTIONS(916),
    [anon_sym_GT_LPAREN] = ACTIONS(916),
    [sym_ansii_c_string] = ACTIONS(916),
    [anon_sym_COLON_QMARK] = ACTIONS(914),
    [sym__special_character] = ACTIONS(914),
  },
  [134] = {
    [sym_word] = ACTIONS(920),
    [anon_sym_AMP_GT_GT] = ACTIONS(920),
    [anon_sym_DOLLAR] = ACTIONS(920),
    [anon_sym_LT_LT] = ACTIONS(920),
    [anon_sym_LT_LPAREN] = ACTIONS(920),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(920),
    [sym__concat] = ACTIONS(922),
    [anon_sym_PIPE] = ACTIONS(920),
    [anon_sym_LT] = ACTIONS(920),
    [anon_sym_LT_AMP] = ACTIONS(920),
    [anon_sym_GT_GT] = ACTIONS(920),
    [anon_sym_EQ_TILDE] = ACTIONS(920),
    [sym__special_character] = ACTIONS(920),
    [anon_sym_LT_LT_DASH] = ACTIONS(920),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(920),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(920),
    [anon_sym_LF] = ACTIONS(922),
    [anon_sym_SEMI] = ACTIONS(920),
    [sym_raw_string] = ACTIONS(920),
    [sym_file_descriptor] = ACTIONS(922),
    [anon_sym_AMP] = ACTIONS(920),
    [anon_sym_GT] = ACTIONS(920),
    [anon_sym_AMP_GT] = ACTIONS(920),
    [anon_sym_EQ_EQ] = ACTIONS(920),
    [anon_sym_DQUOTE] = ACTIONS(920),
    [anon_sym_LT_LT_LT] = ACTIONS(920),
    [anon_sym_GT_AMP] = ACTIONS(920),
    [ts_builtin_sym_end] = ACTIONS(922),
    [anon_sym_BQUOTE] = ACTIONS(920),
    [anon_sym_GT_LPAREN] = ACTIONS(920),
    [sym_ansii_c_string] = ACTIONS(920),
    [anon_sym_AMP_AMP] = ACTIONS(920),
    [anon_sym_SEMI_SEMI] = ACTIONS(920),
    [anon_sym_PIPE_AMP] = ACTIONS(920),
  },
  [135] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(208),
    [sym_concatenation] = STATE(208),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(924),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(926),
    [anon_sym_DASH] = ACTIONS(924),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_PERCENT] = ACTIONS(924),
    [anon_sym_POUND] = ACTIONS(928),
    [anon_sym_COLON_DASH] = ACTIONS(924),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(924),
    [sym__special_character] = ACTIONS(517),
    [sym_regex] = ACTIONS(930),
  },
  [136] = {
    [aux_sym__literal_repeat1] = STATE(911),
    [sym_word] = ACTIONS(932),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(934),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(934),
    [sym_raw_string] = ACTIONS(934),
    [anon_sym_COLON] = ACTIONS(932),
    [anon_sym_DOLLAR] = ACTIONS(932),
    [anon_sym_RBRACE] = ACTIONS(934),
    [anon_sym_DASH] = ACTIONS(932),
    [anon_sym_PERCENT] = ACTIONS(932),
    [anon_sym_EQ] = ACTIONS(932),
    [anon_sym_POUND] = ACTIONS(934),
    [anon_sym_COLON_DASH] = ACTIONS(932),
    [anon_sym_LT_LPAREN] = ACTIONS(934),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(934),
    [anon_sym_BQUOTE] = ACTIONS(934),
    [anon_sym_GT_LPAREN] = ACTIONS(934),
    [sym_ansii_c_string] = ACTIONS(934),
    [anon_sym_COLON_QMARK] = ACTIONS(932),
    [sym__special_character] = ACTIONS(936),
  },
  [137] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(938),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(926),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(938),
    [anon_sym_PERCENT] = ACTIONS(938),
    [anon_sym_POUND] = ACTIONS(940),
    [anon_sym_COLON_DASH] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(938),
    [sym__special_character] = ACTIONS(517),
  },
  [138] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(208),
    [sym_concatenation] = STATE(208),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(924),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(926),
    [anon_sym_DASH] = ACTIONS(924),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(924),
    [anon_sym_PERCENT] = ACTIONS(924),
    [anon_sym_POUND] = ACTIONS(928),
    [anon_sym_SLASH] = ACTIONS(942),
    [anon_sym_COLON_DASH] = ACTIONS(924),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(924),
    [sym__special_character] = ACTIONS(517),
  },
  [139] = {
    [anon_sym_EQ] = ACTIONS(944),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(529),
  },
  [140] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(214),
    [sym_concatenation] = STATE(214),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(946),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(948),
    [anon_sym_DASH] = ACTIONS(946),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(946),
    [anon_sym_PERCENT] = ACTIONS(946),
    [anon_sym_POUND] = ACTIONS(950),
    [anon_sym_SLASH] = ACTIONS(952),
    [anon_sym_COLON_DASH] = ACTIONS(946),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(946),
    [sym__special_character] = ACTIONS(517),
  },
  [141] = {
    [sym_command_substitution] = STATE(215),
    [aux_sym__literal_repeat1] = STATE(216),
    [sym_string] = STATE(215),
    [sym_process_substitution] = STATE(215),
    [sym_simple_expansion] = STATE(215),
    [sym_string_expansion] = STATE(215),
    [sym_concatenation] = STATE(217),
    [sym_expansion] = STATE(215),
    [sym_word] = ACTIONS(954),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(956),
    [anon_sym_DQUOTE] = ACTIONS(958),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(960),
    [sym_raw_string] = ACTIONS(954),
    [anon_sym_BQUOTE] = ACTIONS(962),
    [anon_sym_DOLLAR] = ACTIONS(964),
    [sym_ansii_c_string] = ACTIONS(954),
    [anon_sym_GT_LPAREN] = ACTIONS(966),
    [anon_sym_LT_LPAREN] = ACTIONS(966),
    [anon_sym_RBRACE] = ACTIONS(926),
    [sym__special_character] = ACTIONS(968),
    [sym_comment] = ACTIONS(19),
  },
  [142] = {
    [sym_word] = ACTIONS(970),
    [anon_sym_AMP_GT_GT] = ACTIONS(970),
    [anon_sym_DOLLAR] = ACTIONS(970),
    [anon_sym_LT_LT] = ACTIONS(970),
    [anon_sym_LT_LPAREN] = ACTIONS(970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(970),
    [sym__concat] = ACTIONS(972),
    [anon_sym_PIPE] = ACTIONS(970),
    [anon_sym_LT] = ACTIONS(970),
    [anon_sym_LT_AMP] = ACTIONS(970),
    [anon_sym_GT_GT] = ACTIONS(970),
    [anon_sym_EQ_TILDE] = ACTIONS(970),
    [sym__special_character] = ACTIONS(970),
    [anon_sym_LT_LT_DASH] = ACTIONS(970),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(970),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(970),
    [anon_sym_LF] = ACTIONS(972),
    [anon_sym_SEMI] = ACTIONS(970),
    [sym_raw_string] = ACTIONS(970),
    [sym_file_descriptor] = ACTIONS(972),
    [anon_sym_AMP] = ACTIONS(970),
    [anon_sym_GT] = ACTIONS(970),
    [anon_sym_AMP_GT] = ACTIONS(970),
    [anon_sym_EQ_EQ] = ACTIONS(970),
    [anon_sym_DQUOTE] = ACTIONS(970),
    [anon_sym_LT_LT_LT] = ACTIONS(970),
    [anon_sym_GT_AMP] = ACTIONS(970),
    [ts_builtin_sym_end] = ACTIONS(972),
    [anon_sym_BQUOTE] = ACTIONS(970),
    [anon_sym_GT_LPAREN] = ACTIONS(970),
    [sym_ansii_c_string] = ACTIONS(970),
    [anon_sym_AMP_AMP] = ACTIONS(970),
    [anon_sym_SEMI_SEMI] = ACTIONS(970),
    [anon_sym_PIPE_AMP] = ACTIONS(970),
  },
  [143] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(220),
    [sym_concatenation] = STATE(220),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(974),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(976),
    [anon_sym_DASH] = ACTIONS(974),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(974),
    [anon_sym_PERCENT] = ACTIONS(974),
    [anon_sym_POUND] = ACTIONS(978),
    [anon_sym_COLON_DASH] = ACTIONS(974),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(974),
    [sym__special_character] = ACTIONS(517),
    [sym_regex] = ACTIONS(980),
  },
  [144] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(938),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(976),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(938),
    [anon_sym_PERCENT] = ACTIONS(938),
    [anon_sym_POUND] = ACTIONS(940),
    [anon_sym_COLON_DASH] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(938),
    [sym__special_character] = ACTIONS(517),
  },
  [145] = {
    [aux_sym_concatenation_repeat1] = STATE(937),
    [sym_word] = ACTIONS(982),
    [anon_sym_AMP_GT_GT] = ACTIONS(982),
    [anon_sym_DOLLAR] = ACTIONS(982),
    [anon_sym_LT_LT] = ACTIONS(982),
    [anon_sym_LT_LPAREN] = ACTIONS(982),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(982),
    [sym__concat] = ACTIONS(984),
    [anon_sym_PIPE] = ACTIONS(982),
    [anon_sym_LT] = ACTIONS(982),
    [anon_sym_LT_AMP] = ACTIONS(982),
    [anon_sym_GT_GT] = ACTIONS(982),
    [sym__special_character] = ACTIONS(982),
    [anon_sym_LT_LT_DASH] = ACTIONS(982),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(982),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(982),
    [anon_sym_LF] = ACTIONS(986),
    [anon_sym_SEMI] = ACTIONS(982),
    [sym_raw_string] = ACTIONS(982),
    [sym_variable_name] = ACTIONS(986),
    [sym_file_descriptor] = ACTIONS(986),
    [anon_sym_AMP] = ACTIONS(982),
    [anon_sym_GT] = ACTIONS(982),
    [anon_sym_AMP_GT] = ACTIONS(982),
    [anon_sym_DQUOTE] = ACTIONS(982),
    [anon_sym_LT_LT_LT] = ACTIONS(982),
    [anon_sym_GT_AMP] = ACTIONS(982),
    [ts_builtin_sym_end] = ACTIONS(986),
    [anon_sym_BQUOTE] = ACTIONS(982),
    [anon_sym_GT_LPAREN] = ACTIONS(982),
    [sym_ansii_c_string] = ACTIONS(982),
    [anon_sym_AMP_AMP] = ACTIONS(982),
    [anon_sym_SEMI_SEMI] = ACTIONS(982),
    [anon_sym_PIPE_AMP] = ACTIONS(982),
  },
  [146] = {
    [sym_command_substitution] = STATE(221),
    [aux_sym__literal_repeat1] = STATE(223),
    [sym_string] = STATE(221),
    [sym_process_substitution] = STATE(221),
    [aux_sym_for_statement_repeat1] = STATE(224),
    [sym_simple_expansion] = STATE(221),
    [sym_string_expansion] = STATE(221),
    [sym_concatenation] = STATE(224),
    [sym_expansion] = STATE(221),
    [sym_word] = ACTIONS(988),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(990),
    [anon_sym_DQUOTE] = ACTIONS(992),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(994),
    [sym_raw_string] = ACTIONS(988),
    [anon_sym_BQUOTE] = ACTIONS(996),
    [anon_sym_DOLLAR] = ACTIONS(998),
    [sym_ansii_c_string] = ACTIONS(988),
    [anon_sym_GT_LPAREN] = ACTIONS(1000),
    [anon_sym_LT_LPAREN] = ACTIONS(1000),
    [anon_sym_RPAREN] = ACTIONS(1002),
    [sym__special_character] = ACTIONS(1004),
    [sym_comment] = ACTIONS(19),
  },
  [147] = {
    [sym_word] = ACTIONS(982),
    [anon_sym_AMP_GT_GT] = ACTIONS(982),
    [anon_sym_DOLLAR] = ACTIONS(982),
    [anon_sym_LT_LT] = ACTIONS(982),
    [anon_sym_LT_LPAREN] = ACTIONS(982),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(982),
    [anon_sym_PIPE] = ACTIONS(982),
    [anon_sym_LT] = ACTIONS(982),
    [anon_sym_LT_AMP] = ACTIONS(982),
    [anon_sym_GT_GT] = ACTIONS(982),
    [sym__special_character] = ACTIONS(982),
    [anon_sym_LT_LT_DASH] = ACTIONS(982),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(982),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(982),
    [anon_sym_LF] = ACTIONS(986),
    [anon_sym_SEMI] = ACTIONS(982),
    [sym_raw_string] = ACTIONS(982),
    [sym_variable_name] = ACTIONS(986),
    [sym_file_descriptor] = ACTIONS(986),
    [anon_sym_AMP] = ACTIONS(982),
    [anon_sym_GT] = ACTIONS(982),
    [anon_sym_AMP_GT] = ACTIONS(982),
    [anon_sym_DQUOTE] = ACTIONS(982),
    [anon_sym_LT_LT_LT] = ACTIONS(982),
    [anon_sym_GT_AMP] = ACTIONS(982),
    [ts_builtin_sym_end] = ACTIONS(986),
    [anon_sym_BQUOTE] = ACTIONS(982),
    [anon_sym_GT_LPAREN] = ACTIONS(982),
    [sym_ansii_c_string] = ACTIONS(982),
    [anon_sym_AMP_AMP] = ACTIONS(982),
    [anon_sym_SEMI_SEMI] = ACTIONS(982),
    [anon_sym_PIPE_AMP] = ACTIONS(982),
  },
  [148] = {
    [aux_sym__literal_repeat1] = STATE(943),
    [sym_word] = ACTIONS(1006),
    [anon_sym_AMP_GT_GT] = ACTIONS(1006),
    [anon_sym_DOLLAR] = ACTIONS(1006),
    [anon_sym_LT_LT] = ACTIONS(1006),
    [anon_sym_LT_LPAREN] = ACTIONS(1006),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1006),
    [anon_sym_PIPE] = ACTIONS(1006),
    [anon_sym_LT] = ACTIONS(1006),
    [anon_sym_LT_AMP] = ACTIONS(1006),
    [anon_sym_GT_GT] = ACTIONS(1006),
    [sym__special_character] = ACTIONS(1008),
    [anon_sym_LT_LT_DASH] = ACTIONS(1006),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1006),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1006),
    [anon_sym_LF] = ACTIONS(1010),
    [anon_sym_SEMI] = ACTIONS(1006),
    [sym_raw_string] = ACTIONS(1006),
    [sym_variable_name] = ACTIONS(1010),
    [sym_file_descriptor] = ACTIONS(1010),
    [anon_sym_AMP] = ACTIONS(1006),
    [anon_sym_GT] = ACTIONS(1006),
    [anon_sym_AMP_GT] = ACTIONS(1006),
    [anon_sym_DQUOTE] = ACTIONS(1006),
    [anon_sym_LT_LT_LT] = ACTIONS(1006),
    [anon_sym_GT_AMP] = ACTIONS(1006),
    [ts_builtin_sym_end] = ACTIONS(1010),
    [anon_sym_BQUOTE] = ACTIONS(1006),
    [anon_sym_GT_LPAREN] = ACTIONS(1006),
    [sym_ansii_c_string] = ACTIONS(1006),
    [anon_sym_AMP_AMP] = ACTIONS(1006),
    [anon_sym_SEMI_SEMI] = ACTIONS(1006),
    [anon_sym_PIPE_AMP] = ACTIONS(1006),
  },
  [149] = {
    [aux_sym_concatenation_repeat1] = STATE(2432),
    [anon_sym_RBRACK] = ACTIONS(1012),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1014),
  },
  [150] = {
    [aux_sym__literal_repeat1] = STATE(975),
    [anon_sym_RBRACK] = ACTIONS(1016),
    [sym__concat] = ACTIONS(1018),
    [sym__special_character] = ACTIONS(1020),
    [sym_comment] = ACTIONS(19),
  },
  [151] = {
    [anon_sym_RBRACK] = ACTIONS(1012),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1022),
  },
  [152] = {
    [aux_sym_concatenation_repeat1] = STATE(546),
    [sym_word] = ACTIONS(1024),
    [anon_sym_AMP_GT_GT] = ACTIONS(1024),
    [anon_sym_DOLLAR] = ACTIONS(1026),
    [anon_sym_LT_LPAREN] = ACTIONS(1024),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(1026),
    [anon_sym_LT_AMP] = ACTIONS(1024),
    [anon_sym_GT_GT] = ACTIONS(1024),
    [sym__special_character] = ACTIONS(1024),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1024),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1024),
    [sym_raw_string] = ACTIONS(1024),
    [sym_variable_name] = ACTIONS(1024),
    [sym_file_descriptor] = ACTIONS(1024),
    [anon_sym_RPAREN] = ACTIONS(1024),
    [anon_sym_GT] = ACTIONS(1026),
    [anon_sym_AMP_GT] = ACTIONS(1026),
    [anon_sym_DQUOTE] = ACTIONS(1024),
    [anon_sym_GT_AMP] = ACTIONS(1024),
    [anon_sym_BQUOTE] = ACTIONS(1024),
    [anon_sym_GT_LPAREN] = ACTIONS(1024),
    [sym_ansii_c_string] = ACTIONS(1024),
  },
  [153] = {
    [aux_sym__literal_repeat1] = STATE(564),
    [sym_word] = ACTIONS(1028),
    [anon_sym_AMP_GT_GT] = ACTIONS(1028),
    [anon_sym_DOLLAR] = ACTIONS(1030),
    [anon_sym_LT_LPAREN] = ACTIONS(1028),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(1030),
    [anon_sym_LT_AMP] = ACTIONS(1028),
    [anon_sym_GT_GT] = ACTIONS(1028),
    [sym__special_character] = ACTIONS(373),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1028),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1028),
    [sym_raw_string] = ACTIONS(1028),
    [sym_variable_name] = ACTIONS(1028),
    [sym_file_descriptor] = ACTIONS(1028),
    [anon_sym_RPAREN] = ACTIONS(1028),
    [anon_sym_GT] = ACTIONS(1030),
    [anon_sym_AMP_GT] = ACTIONS(1030),
    [anon_sym_DQUOTE] = ACTIONS(1028),
    [anon_sym_GT_AMP] = ACTIONS(1028),
    [anon_sym_BQUOTE] = ACTIONS(1028),
    [anon_sym_GT_LPAREN] = ACTIONS(1028),
    [sym_ansii_c_string] = ACTIONS(1028),
  },
  [154] = {
    [sym_word] = ACTIONS(1024),
    [anon_sym_AMP_GT_GT] = ACTIONS(1024),
    [anon_sym_DOLLAR] = ACTIONS(1026),
    [anon_sym_LT_LPAREN] = ACTIONS(1024),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(1026),
    [anon_sym_LT_AMP] = ACTIONS(1024),
    [anon_sym_GT_GT] = ACTIONS(1024),
    [sym__special_character] = ACTIONS(1024),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1024),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1024),
    [sym_raw_string] = ACTIONS(1024),
    [sym_variable_name] = ACTIONS(1024),
    [sym_file_descriptor] = ACTIONS(1024),
    [anon_sym_RPAREN] = ACTIONS(1024),
    [anon_sym_GT] = ACTIONS(1026),
    [anon_sym_AMP_GT] = ACTIONS(1026),
    [anon_sym_DQUOTE] = ACTIONS(1024),
    [anon_sym_GT_AMP] = ACTIONS(1024),
    [anon_sym_BQUOTE] = ACTIONS(1024),
    [anon_sym_GT_LPAREN] = ACTIONS(1024),
    [sym_ansii_c_string] = ACTIONS(1024),
  },
  [155] = {
    [sym_word] = ACTIONS(1032),
    [anon_sym_AMP_GT_GT] = ACTIONS(1032),
    [anon_sym_DOLLAR] = ACTIONS(1032),
    [anon_sym_LT_LT] = ACTIONS(1032),
    [anon_sym_LT_LPAREN] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1032),
    [sym__concat] = ACTIONS(1034),
    [anon_sym_PIPE] = ACTIONS(1032),
    [anon_sym_LT] = ACTIONS(1032),
    [anon_sym_LT_AMP] = ACTIONS(1032),
    [anon_sym_GT_GT] = ACTIONS(1032),
    [anon_sym_EQ_TILDE] = ACTIONS(1032),
    [sym__special_character] = ACTIONS(1032),
    [anon_sym_LT_LT_DASH] = ACTIONS(1032),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1032),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1032),
    [anon_sym_LF] = ACTIONS(1034),
    [anon_sym_SEMI] = ACTIONS(1032),
    [sym_raw_string] = ACTIONS(1032),
    [sym_file_descriptor] = ACTIONS(1034),
    [anon_sym_AMP] = ACTIONS(1032),
    [anon_sym_GT] = ACTIONS(1032),
    [anon_sym_AMP_GT] = ACTIONS(1032),
    [anon_sym_EQ_EQ] = ACTIONS(1032),
    [anon_sym_DQUOTE] = ACTIONS(1032),
    [anon_sym_LT_LT_LT] = ACTIONS(1032),
    [anon_sym_GT_AMP] = ACTIONS(1032),
    [ts_builtin_sym_end] = ACTIONS(1034),
    [anon_sym_BQUOTE] = ACTIONS(1032),
    [anon_sym_GT_LPAREN] = ACTIONS(1032),
    [sym_ansii_c_string] = ACTIONS(1032),
    [anon_sym_AMP_AMP] = ACTIONS(1032),
    [anon_sym_SEMI_SEMI] = ACTIONS(1032),
    [anon_sym_PIPE_AMP] = ACTIONS(1032),
  },
  [156] = {
    [sym_word] = ACTIONS(1036),
    [anon_sym_AMP_GT_GT] = ACTIONS(1036),
    [anon_sym_DOLLAR] = ACTIONS(1036),
    [anon_sym_LT_LT] = ACTIONS(1036),
    [anon_sym_LT_LPAREN] = ACTIONS(1036),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1036),
    [sym__concat] = ACTIONS(1038),
    [anon_sym_PIPE] = ACTIONS(1036),
    [anon_sym_LT] = ACTIONS(1036),
    [anon_sym_LT_AMP] = ACTIONS(1036),
    [anon_sym_GT_GT] = ACTIONS(1036),
    [anon_sym_EQ_TILDE] = ACTIONS(1036),
    [sym__special_character] = ACTIONS(1036),
    [anon_sym_LT_LT_DASH] = ACTIONS(1036),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1036),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1036),
    [anon_sym_LF] = ACTIONS(1038),
    [anon_sym_SEMI] = ACTIONS(1036),
    [sym_raw_string] = ACTIONS(1036),
    [sym_file_descriptor] = ACTIONS(1038),
    [anon_sym_AMP] = ACTIONS(1036),
    [anon_sym_GT] = ACTIONS(1036),
    [anon_sym_AMP_GT] = ACTIONS(1036),
    [anon_sym_EQ_EQ] = ACTIONS(1036),
    [anon_sym_DQUOTE] = ACTIONS(1036),
    [anon_sym_LT_LT_LT] = ACTIONS(1036),
    [anon_sym_GT_AMP] = ACTIONS(1036),
    [ts_builtin_sym_end] = ACTIONS(1038),
    [anon_sym_BQUOTE] = ACTIONS(1036),
    [anon_sym_GT_LPAREN] = ACTIONS(1036),
    [sym_ansii_c_string] = ACTIONS(1036),
    [anon_sym_AMP_AMP] = ACTIONS(1036),
    [anon_sym_SEMI_SEMI] = ACTIONS(1036),
    [anon_sym_PIPE_AMP] = ACTIONS(1036),
  },
  [157] = {
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1040),
    [anon_sym_DQUOTE] = ACTIONS(1040),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1040),
    [sym__concat] = ACTIONS(1042),
    [anon_sym_BQUOTE] = ACTIONS(1040),
    [sym__string_content] = ACTIONS(1040),
    [anon_sym_DOLLAR] = ACTIONS(1040),
    [sym_comment] = ACTIONS(3),
  },
  [158] = {
    [anon_sym_DOLLAR] = ACTIONS(1040),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1040),
    [anon_sym_DQUOTE] = ACTIONS(1040),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1040),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1040),
    [sym__string_content] = ACTIONS(1040),
  },
  [159] = {
    [aux_sym__simple_variable_name_token1] = ACTIONS(571),
    [anon_sym__] = ACTIONS(571),
    [anon_sym_AT] = ACTIONS(571),
    [anon_sym_DQUOTE] = ACTIONS(1044),
    [anon_sym_BANG] = ACTIONS(575),
    [anon_sym_STAR] = ACTIONS(571),
    [anon_sym_DOLLAR] = ACTIONS(575),
    [anon_sym_QMARK] = ACTIONS(571),
    [anon_sym_DASH] = ACTIONS(575),
    [sym__string_content] = ACTIONS(577),
    [sym_comment] = ACTIONS(3),
    [anon_sym_POUND] = ACTIONS(575),
    [anon_sym_0] = ACTIONS(571),
  },
  [160] = {
    [sym_command_substitution] = STATE(82),
    [sym_simple_expansion] = STATE(82),
    [aux_sym_string_repeat1] = STATE(160),
    [sym_expansion] = STATE(82),
    [anon_sym_DOLLAR] = ACTIONS(1046),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1049),
    [anon_sym_DQUOTE] = ACTIONS(1040),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1052),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1055),
    [sym__string_content] = ACTIONS(1058),
  },
  [161] = {
    [sym_word] = ACTIONS(1032),
    [anon_sym_AMP_GT_GT] = ACTIONS(1032),
    [anon_sym_DOLLAR] = ACTIONS(1032),
    [anon_sym_LT_LT] = ACTIONS(1032),
    [anon_sym_LT_LPAREN] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1032),
    [sym__concat] = ACTIONS(1034),
    [anon_sym_PIPE] = ACTIONS(1032),
    [anon_sym_LT] = ACTIONS(1032),
    [anon_sym_LT_AMP] = ACTIONS(1032),
    [anon_sym_GT_GT] = ACTIONS(1032),
    [anon_sym_EQ_TILDE] = ACTIONS(1032),
    [sym__special_character] = ACTIONS(1032),
    [anon_sym_LT_LT_DASH] = ACTIONS(1032),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1032),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1032),
    [anon_sym_LF] = ACTIONS(1034),
    [anon_sym_SEMI] = ACTIONS(1032),
    [sym_raw_string] = ACTIONS(1032),
    [sym_file_descriptor] = ACTIONS(1034),
    [anon_sym_AMP] = ACTIONS(1032),
    [anon_sym_GT] = ACTIONS(1032),
    [anon_sym_AMP_GT] = ACTIONS(1032),
    [anon_sym_EQ_EQ] = ACTIONS(1032),
    [anon_sym_DQUOTE] = ACTIONS(1032),
    [anon_sym_LT_LT_LT] = ACTIONS(1032),
    [anon_sym_GT_AMP] = ACTIONS(1032),
    [ts_builtin_sym_end] = ACTIONS(1034),
    [anon_sym_BQUOTE] = ACTIONS(1032),
    [anon_sym_GT_LPAREN] = ACTIONS(1032),
    [sym_ansii_c_string] = ACTIONS(1032),
    [anon_sym_AMP_AMP] = ACTIONS(1032),
    [anon_sym_SEMI_SEMI] = ACTIONS(1032),
    [anon_sym_PIPE_AMP] = ACTIONS(1032),
  },
  [162] = {
    [sym_do_group] = STATE(233),
    [sym_comment] = ACTIONS(19),
    [anon_sym_do] = ACTIONS(619),
  },
  [163] = {
    [sym_command_substitution] = STATE(482),
    [aux_sym__literal_repeat1] = STATE(484),
    [sym_string] = STATE(482),
    [sym_process_substitution] = STATE(482),
    [aux_sym_for_statement_repeat1] = STATE(234),
    [sym_simple_expansion] = STATE(482),
    [sym_string_expansion] = STATE(482),
    [sym_concatenation] = STATE(234),
    [sym_expansion] = STATE(482),
    [sym_word] = ACTIONS(1061),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1063),
    [anon_sym_DQUOTE] = ACTIONS(1065),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1067),
    [sym_raw_string] = ACTIONS(1061),
    [anon_sym_BQUOTE] = ACTIONS(1069),
    [anon_sym_DOLLAR] = ACTIONS(1071),
    [sym_ansii_c_string] = ACTIONS(1061),
    [anon_sym_GT_LPAREN] = ACTIONS(1073),
    [anon_sym_LT_LPAREN] = ACTIONS(1073),
    [sym__special_character] = ACTIONS(1075),
    [sym_comment] = ACTIONS(19),
  },
  [164] = {
    [sym_command_substitution] = STATE(559),
    [sym_unary_expression] = STATE(236),
    [sym_postfix_expression] = STATE(236),
    [sym_string] = STATE(559),
    [aux_sym__literal_repeat1] = STATE(561),
    [sym_process_substitution] = STATE(559),
    [sym_parenthesized_expression] = STATE(236),
    [sym_simple_expansion] = STATE(559),
    [sym_string_expansion] = STATE(559),
    [sym__expression] = STATE(236),
    [sym_binary_expression] = STATE(236),
    [sym_concatenation] = STATE(236),
    [sym_expansion] = STATE(559),
    [sym_word] = ACTIONS(597),
    [anon_sym_LPAREN] = ACTIONS(599),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(601),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(603),
    [sym_raw_string] = ACTIONS(597),
    [anon_sym_LF] = ACTIONS(1077),
    [anon_sym_BANG] = ACTIONS(607),
    [anon_sym_SEMI] = ACTIONS(1077),
    [anon_sym_DOLLAR] = ACTIONS(609),
    [anon_sym_AMP] = ACTIONS(1077),
    [anon_sym_LT_LPAREN] = ACTIONS(611),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [sym_test_operator] = ACTIONS(607),
    [anon_sym_BQUOTE] = ACTIONS(615),
    [anon_sym_GT_LPAREN] = ACTIONS(611),
    [sym_ansii_c_string] = ACTIONS(597),
    [sym__special_character] = ACTIONS(617),
    [anon_sym_SEMI_SEMI] = ACTIONS(1077),
  },
  [165] = {
    [anon_sym_BANG_EQ] = ACTIONS(1079),
    [anon_sym_PLUS_EQ] = ACTIONS(1079),
    [anon_sym_LF] = ACTIONS(1081),
    [anon_sym_SEMI] = ACTIONS(1081),
    [anon_sym_PLUS_PLUS] = ACTIONS(1083),
    [anon_sym_DASH] = ACTIONS(1079),
    [anon_sym_GT] = ACTIONS(1079),
    [anon_sym_EQ] = ACTIONS(1079),
    [anon_sym_AMP] = ACTIONS(1081),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(1085),
    [anon_sym_PIPE_PIPE] = ACTIONS(1079),
    [anon_sym_GT_EQ] = ACTIONS(1079),
    [anon_sym_PLUS] = ACTIONS(1079),
    [anon_sym_LT] = ACTIONS(1079),
    [sym_test_operator] = ACTIONS(1079),
    [anon_sym_EQ_TILDE] = ACTIONS(1085),
    [anon_sym_DASH_DASH] = ACTIONS(1083),
    [anon_sym_LT_EQ] = ACTIONS(1079),
    [anon_sym_AMP_AMP] = ACTIONS(1079),
    [anon_sym_SEMI_SEMI] = ACTIONS(1081),
    [anon_sym_DASH_EQ] = ACTIONS(1079),
  },
  [166] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(194),
    [sym_function_definition] = STATE(194),
    [sym_negated_command] = STATE(194),
    [sym_test_command] = STATE(194),
    [sym_variable_assignment] = STATE(195),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(194),
    [sym_for_statement] = STATE(194),
    [sym_compound_statement] = STATE(194),
    [sym_subshell] = STATE(194),
    [sym_declaration_command] = STATE(194),
    [sym_unset_command] = STATE(194),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [aux_sym__statements2] = STATE(239),
    [sym_c_style_for_statement] = STATE(194),
    [sym_while_statement] = STATE(194),
    [sym_case_statement] = STATE(194),
    [sym_pipeline] = STATE(194),
    [sym_list] = STATE(194),
    [sym_command] = STATE(194),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [anon_sym_done] = ACTIONS(1087),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [167] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1089),
    [anon_sym_AMP_GT_GT] = ACTIONS(1089),
    [anon_sym_LF] = ACTIONS(1091),
    [anon_sym_SEMI] = ACTIONS(1089),
    [anon_sym_LT_LT] = ACTIONS(1089),
    [anon_sym_AMP] = ACTIONS(1089),
    [anon_sym_GT] = ACTIONS(1089),
    [sym_file_descriptor] = ACTIONS(1091),
    [anon_sym_AMP_GT] = ACTIONS(1089),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1089),
    [ts_builtin_sym_end] = ACTIONS(1091),
    [anon_sym_LT_LT_LT] = ACTIONS(1089),
    [anon_sym_PIPE] = ACTIONS(1089),
    [anon_sym_GT_AMP] = ACTIONS(1089),
    [anon_sym_LT] = ACTIONS(1089),
    [anon_sym_LT_AMP] = ACTIONS(1089),
    [anon_sym_GT_GT] = ACTIONS(1089),
    [anon_sym_AMP_AMP] = ACTIONS(1089),
    [anon_sym_SEMI_SEMI] = ACTIONS(1089),
    [anon_sym_PIPE_AMP] = ACTIONS(1089),
  },
  [168] = {
    [sym_heredoc_redirect] = STATE(98),
    [aux_sym_redirected_statement_repeat1] = STATE(98),
    [sym_herestring_redirect] = STATE(98),
    [sym_file_redirect] = STATE(98),
    [anon_sym_LT_LT_DASH] = ACTIONS(1093),
    [anon_sym_AMP_GT_GT] = ACTIONS(1093),
    [anon_sym_LF] = ACTIONS(1095),
    [anon_sym_SEMI] = ACTIONS(1093),
    [anon_sym_LT_LT] = ACTIONS(1093),
    [anon_sym_AMP] = ACTIONS(1093),
    [anon_sym_GT] = ACTIONS(1093),
    [sym_file_descriptor] = ACTIONS(1095),
    [anon_sym_AMP_GT] = ACTIONS(1093),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1093),
    [ts_builtin_sym_end] = ACTIONS(1095),
    [anon_sym_LT_LT_LT] = ACTIONS(1093),
    [anon_sym_PIPE] = ACTIONS(1093),
    [anon_sym_GT_AMP] = ACTIONS(1093),
    [anon_sym_LT] = ACTIONS(1093),
    [anon_sym_LT_AMP] = ACTIONS(1093),
    [anon_sym_GT_GT] = ACTIONS(1093),
    [anon_sym_AMP_AMP] = ACTIONS(1093),
    [anon_sym_SEMI_SEMI] = ACTIONS(1093),
    [anon_sym_PIPE_AMP] = ACTIONS(1093),
  },
  [169] = {
    [sym_heredoc_redirect] = STATE(98),
    [aux_sym_redirected_statement_repeat1] = STATE(98),
    [sym_herestring_redirect] = STATE(98),
    [sym_file_redirect] = STATE(98),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(1093),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(1093),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1093),
    [anon_sym_PIPE] = ACTIONS(1093),
    [anon_sym_LT] = ACTIONS(1093),
    [anon_sym_LT_AMP] = ACTIONS(1093),
    [anon_sym_GT_GT] = ACTIONS(1093),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(1093),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(1095),
    [anon_sym_SEMI] = ACTIONS(1093),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(1095),
    [anon_sym_AMP] = ACTIONS(1093),
    [anon_sym_GT] = ACTIONS(1093),
    [anon_sym_AMP_GT] = ACTIONS(1093),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(1093),
    [anon_sym_GT_AMP] = ACTIONS(1093),
    [ts_builtin_sym_end] = ACTIONS(1095),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(1093),
    [anon_sym_SEMI_SEMI] = ACTIONS(1093),
    [anon_sym_PIPE_AMP] = ACTIONS(1093),
  },
  [170] = {
    [anon_sym_AMP] = ACTIONS(1097),
    [ts_builtin_sym_end] = ACTIONS(1099),
    [anon_sym_LF] = ACTIONS(1099),
    [anon_sym_SEMI] = ACTIONS(1097),
    [anon_sym_SEMI_SEMI] = ACTIONS(1097),
    [sym_comment] = ACTIONS(3),
  },
  [171] = {
    [sym_command_substitution] = STATE(242),
    [sym_simple_expansion] = STATE(242),
    [sym_expansion] = STATE(242),
    [aux_sym_heredoc_body_repeat1] = STATE(242),
    [anon_sym_DOLLAR] = ACTIONS(1101),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1103),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1105),
    [sym__heredoc_body_end] = ACTIONS(1107),
    [sym_comment] = ACTIONS(19),
    [anon_sym_BQUOTE] = ACTIONS(1109),
    [sym__heredoc_body_middle] = ACTIONS(1111),
  },
  [172] = {
    [ts_builtin_sym_end] = ACTIONS(1113),
    [anon_sym_AMP] = ACTIONS(1115),
    [anon_sym_LF] = ACTIONS(1117),
    [anon_sym_SEMI] = ACTIONS(1115),
    [anon_sym_SEMI_SEMI] = ACTIONS(1115),
    [sym_comment] = ACTIONS(3),
  },
  [173] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1119),
    [anon_sym_AMP_GT_GT] = ACTIONS(1119),
    [anon_sym_LF] = ACTIONS(1121),
    [anon_sym_SEMI] = ACTIONS(1119),
    [anon_sym_LT_LT] = ACTIONS(1119),
    [anon_sym_AMP] = ACTIONS(1119),
    [anon_sym_GT] = ACTIONS(1119),
    [sym_file_descriptor] = ACTIONS(1121),
    [anon_sym_AMP_GT] = ACTIONS(1119),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1119),
    [ts_builtin_sym_end] = ACTIONS(1121),
    [anon_sym_LT_LT_LT] = ACTIONS(1119),
    [anon_sym_PIPE] = ACTIONS(1119),
    [anon_sym_GT_AMP] = ACTIONS(1119),
    [anon_sym_LT] = ACTIONS(1119),
    [anon_sym_LT_AMP] = ACTIONS(1119),
    [anon_sym_GT_GT] = ACTIONS(1119),
    [anon_sym_AMP_AMP] = ACTIONS(1119),
    [anon_sym_SEMI_SEMI] = ACTIONS(1119),
    [anon_sym_PIPE_AMP] = ACTIONS(1119),
  },
  [174] = {
    [sym_heredoc_redirect] = STATE(98),
    [aux_sym_redirected_statement_repeat1] = STATE(98),
    [sym_herestring_redirect] = STATE(98),
    [sym_file_redirect] = STATE(98),
    [anon_sym_LT_LT_DASH] = ACTIONS(1123),
    [anon_sym_AMP_GT_GT] = ACTIONS(1123),
    [anon_sym_LF] = ACTIONS(1125),
    [anon_sym_SEMI] = ACTIONS(1123),
    [anon_sym_LT_LT] = ACTIONS(1123),
    [anon_sym_AMP] = ACTIONS(1123),
    [anon_sym_GT] = ACTIONS(1123),
    [sym_file_descriptor] = ACTIONS(1125),
    [anon_sym_AMP_GT] = ACTIONS(1123),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1123),
    [ts_builtin_sym_end] = ACTIONS(1125),
    [anon_sym_LT_LT_LT] = ACTIONS(1123),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_GT_AMP] = ACTIONS(1123),
    [anon_sym_LT] = ACTIONS(1123),
    [anon_sym_LT_AMP] = ACTIONS(1123),
    [anon_sym_GT_GT] = ACTIONS(1123),
    [anon_sym_AMP_AMP] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(1123),
    [anon_sym_PIPE_AMP] = ACTIONS(321),
  },
  [175] = {
    [sym_heredoc_redirect] = STATE(98),
    [aux_sym_redirected_statement_repeat1] = STATE(98),
    [sym_herestring_redirect] = STATE(98),
    [sym_file_redirect] = STATE(98),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(1123),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1123),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(1123),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(1125),
    [anon_sym_SEMI] = ACTIONS(1123),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(1123),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(1123),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [ts_builtin_sym_end] = ACTIONS(1125),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(1123),
    [anon_sym_PIPE_AMP] = ACTIONS(321),
  },
  [176] = {
    [aux_sym_concatenation_repeat1] = STATE(1001),
    [anon_sym_LT_LT_DASH] = ACTIONS(1127),
    [anon_sym_AMP_GT_GT] = ACTIONS(1127),
    [anon_sym_LF] = ACTIONS(1129),
    [anon_sym_SEMI] = ACTIONS(1127),
    [anon_sym_LT_LT] = ACTIONS(1127),
    [anon_sym_AMP] = ACTIONS(1127),
    [anon_sym_GT] = ACTIONS(1127),
    [sym_file_descriptor] = ACTIONS(1129),
    [anon_sym_AMP_GT] = ACTIONS(1127),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1127),
    [ts_builtin_sym_end] = ACTIONS(1129),
    [anon_sym_LT_LT_LT] = ACTIONS(1127),
    [anon_sym_PIPE] = ACTIONS(1127),
    [anon_sym_GT_AMP] = ACTIONS(1127),
    [anon_sym_LT] = ACTIONS(1127),
    [anon_sym_LT_AMP] = ACTIONS(1127),
    [anon_sym_GT_GT] = ACTIONS(1127),
    [sym__concat] = ACTIONS(1131),
    [anon_sym_AMP_AMP] = ACTIONS(1127),
    [anon_sym_SEMI_SEMI] = ACTIONS(1127),
    [anon_sym_PIPE_AMP] = ACTIONS(1127),
  },
  [177] = {
    [aux_sym__literal_repeat1] = STATE(1039),
    [anon_sym_LT_LT_DASH] = ACTIONS(1133),
    [anon_sym_AMP_GT_GT] = ACTIONS(1133),
    [anon_sym_LF] = ACTIONS(1135),
    [anon_sym_SEMI] = ACTIONS(1133),
    [anon_sym_LT_LT] = ACTIONS(1133),
    [anon_sym_AMP] = ACTIONS(1133),
    [anon_sym_GT] = ACTIONS(1133),
    [sym_file_descriptor] = ACTIONS(1135),
    [anon_sym_AMP_GT] = ACTIONS(1133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1133),
    [ts_builtin_sym_end] = ACTIONS(1135),
    [anon_sym_LT_LT_LT] = ACTIONS(1133),
    [anon_sym_PIPE] = ACTIONS(1133),
    [anon_sym_GT_AMP] = ACTIONS(1133),
    [anon_sym_LT] = ACTIONS(1133),
    [anon_sym_LT_AMP] = ACTIONS(1133),
    [anon_sym_GT_GT] = ACTIONS(1133),
    [anon_sym_AMP_AMP] = ACTIONS(1133),
    [sym__special_character] = ACTIONS(1137),
    [anon_sym_SEMI_SEMI] = ACTIONS(1133),
    [anon_sym_PIPE_AMP] = ACTIONS(1133),
  },
  [178] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1127),
    [anon_sym_AMP_GT_GT] = ACTIONS(1127),
    [anon_sym_LF] = ACTIONS(1129),
    [anon_sym_SEMI] = ACTIONS(1127),
    [anon_sym_LT_LT] = ACTIONS(1127),
    [anon_sym_AMP] = ACTIONS(1127),
    [anon_sym_GT] = ACTIONS(1127),
    [sym_file_descriptor] = ACTIONS(1129),
    [anon_sym_AMP_GT] = ACTIONS(1127),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1127),
    [ts_builtin_sym_end] = ACTIONS(1129),
    [anon_sym_LT_LT_LT] = ACTIONS(1127),
    [anon_sym_PIPE] = ACTIONS(1127),
    [anon_sym_GT_AMP] = ACTIONS(1127),
    [anon_sym_LT] = ACTIONS(1127),
    [anon_sym_LT_AMP] = ACTIONS(1127),
    [anon_sym_GT_GT] = ACTIONS(1127),
    [anon_sym_AMP_AMP] = ACTIONS(1127),
    [anon_sym_SEMI_SEMI] = ACTIONS(1127),
    [anon_sym_PIPE_AMP] = ACTIONS(1127),
  },
  [179] = {
    [sym_heredoc_redirect] = STATE(179),
    [aux_sym_redirected_statement_repeat1] = STATE(179),
    [sym_herestring_redirect] = STATE(179),
    [sym_file_redirect] = STATE(179),
    [anon_sym_LT_LT_DASH] = ACTIONS(1139),
    [anon_sym_AMP_GT_GT] = ACTIONS(1142),
    [anon_sym_LF] = ACTIONS(1145),
    [anon_sym_SEMI] = ACTIONS(1147),
    [anon_sym_LT_LT] = ACTIONS(1139),
    [anon_sym_AMP] = ACTIONS(1147),
    [anon_sym_GT] = ACTIONS(1142),
    [sym_file_descriptor] = ACTIONS(1149),
    [anon_sym_AMP_GT] = ACTIONS(1142),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1147),
    [ts_builtin_sym_end] = ACTIONS(1145),
    [anon_sym_LT_LT_LT] = ACTIONS(1152),
    [anon_sym_PIPE] = ACTIONS(1147),
    [anon_sym_GT_AMP] = ACTIONS(1142),
    [anon_sym_LT] = ACTIONS(1142),
    [anon_sym_LT_AMP] = ACTIONS(1142),
    [anon_sym_GT_GT] = ACTIONS(1142),
    [anon_sym_AMP_AMP] = ACTIONS(1147),
    [anon_sym_SEMI_SEMI] = ACTIONS(1147),
    [anon_sym_PIPE_AMP] = ACTIONS(1147),
  },
  [180] = {
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [ts_builtin_sym_end] = ACTIONS(1113),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [181] = {
    [sym_heredoc_body] = STATE(244),
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__simple_heredoc_body] = ACTIONS(640),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [sym__heredoc_body_beginning] = ACTIONS(642),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [ts_builtin_sym_end] = ACTIONS(1113),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [182] = {
    [sym_command_substitution] = STATE(104),
    [aux_sym__literal_repeat1] = STATE(106),
    [sym_string] = STATE(104),
    [sym_process_substitution] = STATE(104),
    [sym_simple_expansion] = STATE(104),
    [sym_string_expansion] = STATE(104),
    [aux_sym_command_repeat2] = STATE(186),
    [sym_concatenation] = STATE(186),
    [sym_expansion] = STATE(104),
    [sym_word] = ACTIONS(333),
    [anon_sym_AMP_GT_GT] = ACTIONS(1155),
    [anon_sym_DOLLAR] = ACTIONS(15),
    [anon_sym_LT_LT] = ACTIONS(1155),
    [anon_sym_LT_LPAREN] = ACTIONS(337),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1155),
    [anon_sym_PIPE] = ACTIONS(1155),
    [anon_sym_LT] = ACTIONS(1155),
    [anon_sym_LT_AMP] = ACTIONS(1155),
    [anon_sym_GT_GT] = ACTIONS(1155),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [sym__special_character] = ACTIONS(27),
    [anon_sym_LT_LT_DASH] = ACTIONS(1155),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(341),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(343),
    [anon_sym_LF] = ACTIONS(1157),
    [anon_sym_SEMI] = ACTIONS(1155),
    [sym_raw_string] = ACTIONS(333),
    [sym_file_descriptor] = ACTIONS(1157),
    [anon_sym_AMP] = ACTIONS(1155),
    [anon_sym_GT] = ACTIONS(1155),
    [anon_sym_AMP_GT] = ACTIONS(1155),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [ts_builtin_sym_end] = ACTIONS(1157),
    [anon_sym_LT_LT_LT] = ACTIONS(1155),
    [anon_sym_GT_AMP] = ACTIONS(1155),
    [anon_sym_DQUOTE] = ACTIONS(347),
    [anon_sym_BQUOTE] = ACTIONS(349),
    [anon_sym_GT_LPAREN] = ACTIONS(337),
    [sym_ansii_c_string] = ACTIONS(333),
    [anon_sym_AMP_AMP] = ACTIONS(1155),
    [anon_sym_SEMI_SEMI] = ACTIONS(1155),
    [anon_sym_PIPE_AMP] = ACTIONS(1155),
  },
  [183] = {
    [aux_sym_concatenation_repeat1] = STATE(39),
    [sym_word] = ACTIONS(1159),
    [anon_sym_AMP_GT_GT] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(1159),
    [anon_sym_LT_LT] = ACTIONS(1159),
    [anon_sym_LT_LPAREN] = ACTIONS(1159),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1159),
    [sym__concat] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1159),
    [anon_sym_LT_AMP] = ACTIONS(1159),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_EQ_TILDE] = ACTIONS(1159),
    [sym__special_character] = ACTIONS(1159),
    [anon_sym_LT_LT_DASH] = ACTIONS(1159),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1159),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1159),
    [anon_sym_LF] = ACTIONS(1161),
    [anon_sym_SEMI] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(1159),
    [sym_file_descriptor] = ACTIONS(1161),
    [anon_sym_AMP] = ACTIONS(1159),
    [anon_sym_GT] = ACTIONS(1159),
    [anon_sym_AMP_GT] = ACTIONS(1159),
    [anon_sym_EQ_EQ] = ACTIONS(1159),
    [anon_sym_DQUOTE] = ACTIONS(1159),
    [anon_sym_LT_LT_LT] = ACTIONS(1159),
    [anon_sym_GT_AMP] = ACTIONS(1159),
    [ts_builtin_sym_end] = ACTIONS(1161),
    [anon_sym_BQUOTE] = ACTIONS(1159),
    [anon_sym_GT_LPAREN] = ACTIONS(1159),
    [sym_ansii_c_string] = ACTIONS(1159),
    [anon_sym_AMP_AMP] = ACTIONS(1159),
    [anon_sym_SEMI_SEMI] = ACTIONS(1159),
    [anon_sym_PIPE_AMP] = ACTIONS(1159),
  },
  [184] = {
    [sym_word] = ACTIONS(1159),
    [anon_sym_AMP_GT_GT] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(1159),
    [anon_sym_LT_LT] = ACTIONS(1159),
    [anon_sym_LT_LPAREN] = ACTIONS(1159),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1159),
    [anon_sym_PIPE] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1159),
    [anon_sym_LT_AMP] = ACTIONS(1159),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_EQ_TILDE] = ACTIONS(1159),
    [sym__special_character] = ACTIONS(1159),
    [anon_sym_LT_LT_DASH] = ACTIONS(1159),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1159),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1159),
    [anon_sym_LF] = ACTIONS(1161),
    [anon_sym_SEMI] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(1159),
    [sym_file_descriptor] = ACTIONS(1161),
    [anon_sym_AMP] = ACTIONS(1159),
    [anon_sym_GT] = ACTIONS(1159),
    [anon_sym_AMP_GT] = ACTIONS(1159),
    [anon_sym_EQ_EQ] = ACTIONS(1159),
    [anon_sym_DQUOTE] = ACTIONS(1159),
    [anon_sym_LT_LT_LT] = ACTIONS(1159),
    [anon_sym_GT_AMP] = ACTIONS(1159),
    [ts_builtin_sym_end] = ACTIONS(1161),
    [anon_sym_BQUOTE] = ACTIONS(1159),
    [anon_sym_GT_LPAREN] = ACTIONS(1159),
    [sym_ansii_c_string] = ACTIONS(1159),
    [anon_sym_AMP_AMP] = ACTIONS(1159),
    [anon_sym_SEMI_SEMI] = ACTIONS(1159),
    [anon_sym_PIPE_AMP] = ACTIONS(1159),
  },
  [185] = {
    [aux_sym__literal_repeat1] = STATE(91),
    [sym_word] = ACTIONS(1163),
    [anon_sym_AMP_GT_GT] = ACTIONS(1163),
    [anon_sym_DOLLAR] = ACTIONS(1163),
    [anon_sym_LT_LT] = ACTIONS(1163),
    [anon_sym_LT_LPAREN] = ACTIONS(1163),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1163),
    [anon_sym_PIPE] = ACTIONS(1163),
    [anon_sym_LT] = ACTIONS(1163),
    [anon_sym_LT_AMP] = ACTIONS(1163),
    [anon_sym_GT_GT] = ACTIONS(1163),
    [anon_sym_EQ_TILDE] = ACTIONS(1163),
    [sym__special_character] = ACTIONS(301),
    [anon_sym_LT_LT_DASH] = ACTIONS(1163),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1163),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1163),
    [anon_sym_LF] = ACTIONS(1165),
    [anon_sym_SEMI] = ACTIONS(1163),
    [sym_raw_string] = ACTIONS(1163),
    [sym_file_descriptor] = ACTIONS(1165),
    [anon_sym_AMP] = ACTIONS(1163),
    [anon_sym_GT] = ACTIONS(1163),
    [anon_sym_AMP_GT] = ACTIONS(1163),
    [anon_sym_EQ_EQ] = ACTIONS(1163),
    [anon_sym_DQUOTE] = ACTIONS(1163),
    [anon_sym_LT_LT_LT] = ACTIONS(1163),
    [anon_sym_GT_AMP] = ACTIONS(1163),
    [ts_builtin_sym_end] = ACTIONS(1165),
    [anon_sym_BQUOTE] = ACTIONS(1163),
    [anon_sym_GT_LPAREN] = ACTIONS(1163),
    [sym_ansii_c_string] = ACTIONS(1163),
    [anon_sym_AMP_AMP] = ACTIONS(1163),
    [anon_sym_SEMI_SEMI] = ACTIONS(1163),
    [anon_sym_PIPE_AMP] = ACTIONS(1163),
  },
  [186] = {
    [sym_command_substitution] = STATE(104),
    [aux_sym__literal_repeat1] = STATE(106),
    [sym_string] = STATE(104),
    [sym_process_substitution] = STATE(104),
    [sym_simple_expansion] = STATE(104),
    [sym_string_expansion] = STATE(104),
    [aux_sym_command_repeat2] = STATE(186),
    [sym_concatenation] = STATE(186),
    [sym_expansion] = STATE(104),
    [sym_word] = ACTIONS(1167),
    [anon_sym_AMP_GT_GT] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(1170),
    [anon_sym_LT_LT] = ACTIONS(1159),
    [anon_sym_LT_LPAREN] = ACTIONS(1173),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1159),
    [anon_sym_PIPE] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1159),
    [anon_sym_LT_AMP] = ACTIONS(1159),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_EQ_TILDE] = ACTIONS(1176),
    [sym__special_character] = ACTIONS(1179),
    [anon_sym_LT_LT_DASH] = ACTIONS(1159),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1182),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1185),
    [anon_sym_LF] = ACTIONS(1161),
    [anon_sym_SEMI] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(1167),
    [sym_file_descriptor] = ACTIONS(1161),
    [anon_sym_AMP] = ACTIONS(1159),
    [anon_sym_GT] = ACTIONS(1159),
    [anon_sym_AMP_GT] = ACTIONS(1159),
    [anon_sym_EQ_EQ] = ACTIONS(1176),
    [anon_sym_DQUOTE] = ACTIONS(1188),
    [anon_sym_LT_LT_LT] = ACTIONS(1159),
    [anon_sym_GT_AMP] = ACTIONS(1159),
    [ts_builtin_sym_end] = ACTIONS(1161),
    [anon_sym_BQUOTE] = ACTIONS(1191),
    [anon_sym_GT_LPAREN] = ACTIONS(1173),
    [sym_ansii_c_string] = ACTIONS(1167),
    [anon_sym_AMP_AMP] = ACTIONS(1159),
    [anon_sym_SEMI_SEMI] = ACTIONS(1159),
    [anon_sym_PIPE_AMP] = ACTIONS(1159),
  },
  [187] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1194),
    [anon_sym_AMP_GT_GT] = ACTIONS(1194),
    [anon_sym_LF] = ACTIONS(1196),
    [anon_sym_SEMI] = ACTIONS(1194),
    [anon_sym_LT_LT] = ACTIONS(1194),
    [anon_sym_AMP] = ACTIONS(1194),
    [anon_sym_GT] = ACTIONS(1194),
    [sym_file_descriptor] = ACTIONS(1196),
    [anon_sym_AMP_GT] = ACTIONS(1194),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1194),
    [ts_builtin_sym_end] = ACTIONS(1196),
    [anon_sym_LT_LT_LT] = ACTIONS(1194),
    [anon_sym_PIPE] = ACTIONS(1194),
    [anon_sym_GT_AMP] = ACTIONS(1194),
    [anon_sym_LT] = ACTIONS(1194),
    [anon_sym_LT_AMP] = ACTIONS(1194),
    [anon_sym_GT_GT] = ACTIONS(1194),
    [anon_sym_AMP_AMP] = ACTIONS(1194),
    [anon_sym_SEMI_SEMI] = ACTIONS(1194),
    [anon_sym_PIPE_AMP] = ACTIONS(1194),
  },
  [188] = {
    [sym_string] = STATE(52),
    [sym_word] = ACTIONS(1198),
    [anon_sym_0] = ACTIONS(177),
    [anon_sym_AMP_GT_GT] = ACTIONS(1198),
    [anon_sym_DOLLAR] = ACTIONS(1200),
    [anon_sym_LT_LT] = ACTIONS(1198),
    [anon_sym_DASH] = ACTIONS(1200),
    [anon_sym_LT_LPAREN] = ACTIONS(1198),
    [sym_comment] = ACTIONS(3),
    [anon_sym_POUND] = ACTIONS(1200),
    [anon_sym_PIPE_PIPE] = ACTIONS(1198),
    [anon_sym__] = ACTIONS(177),
    [anon_sym_PIPE] = ACTIONS(1198),
    [anon_sym_AT] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(1198),
    [anon_sym_LT_AMP] = ACTIONS(1198),
    [anon_sym_GT_GT] = ACTIONS(1198),
    [anon_sym_EQ_TILDE] = ACTIONS(1198),
    [sym__special_character] = ACTIONS(1198),
    [anon_sym_LT_LT_DASH] = ACTIONS(1198),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1198),
    [aux_sym__simple_variable_name_token1] = ACTIONS(177),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1198),
    [anon_sym_LF] = ACTIONS(1202),
    [anon_sym_SEMI] = ACTIONS(1198),
    [sym_raw_string] = ACTIONS(1204),
    [anon_sym_BANG] = ACTIONS(1200),
    [sym_file_descriptor] = ACTIONS(1202),
    [anon_sym_AMP] = ACTIONS(1198),
    [anon_sym_GT] = ACTIONS(1198),
    [anon_sym_QMARK] = ACTIONS(177),
    [anon_sym_AMP_GT] = ACTIONS(1198),
    [anon_sym_EQ_EQ] = ACTIONS(1198),
    [anon_sym_DQUOTE] = ACTIONS(347),
    [anon_sym_LT_LT_LT] = ACTIONS(1198),
    [anon_sym_GT_AMP] = ACTIONS(1198),
    [ts_builtin_sym_end] = ACTIONS(1202),
    [anon_sym_BQUOTE] = ACTIONS(1198),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_GT_LPAREN] = ACTIONS(1198),
    [sym_ansii_c_string] = ACTIONS(1198),
    [anon_sym_AMP_AMP] = ACTIONS(1198),
    [anon_sym_SEMI_SEMI] = ACTIONS(1198),
    [anon_sym_PIPE_AMP] = ACTIONS(1198),
  },
  [189] = {
    [sym_compound_statement] = STATE(245),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_comment] = ACTIONS(19),
  },
  [190] = {
    [anon_sym_AMP] = ACTIONS(1206),
    [anon_sym_LF] = ACTIONS(1208),
    [anon_sym_SEMI] = ACTIONS(1206),
    [anon_sym_SEMI_SEMI] = ACTIONS(1206),
    [sym_comment] = ACTIONS(3),
  },
  [191] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1210),
    [anon_sym_AMP_GT_GT] = ACTIONS(1210),
    [anon_sym_LF] = ACTIONS(1212),
    [anon_sym_SEMI] = ACTIONS(1210),
    [anon_sym_LT_LT] = ACTIONS(1210),
    [anon_sym_AMP] = ACTIONS(1210),
    [anon_sym_GT] = ACTIONS(1210),
    [sym_file_descriptor] = ACTIONS(1212),
    [anon_sym_AMP_GT] = ACTIONS(1210),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1210),
    [ts_builtin_sym_end] = ACTIONS(1212),
    [anon_sym_LT_LT_LT] = ACTIONS(1210),
    [anon_sym_PIPE] = ACTIONS(1210),
    [anon_sym_GT_AMP] = ACTIONS(1210),
    [anon_sym_LT] = ACTIONS(1210),
    [anon_sym_LT_AMP] = ACTIONS(1210),
    [anon_sym_GT_GT] = ACTIONS(1210),
    [anon_sym_AMP_AMP] = ACTIONS(1210),
    [anon_sym_SEMI_SEMI] = ACTIONS(1210),
    [anon_sym_PIPE_AMP] = ACTIONS(1210),
  },
  [192] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(194),
    [sym_function_definition] = STATE(194),
    [sym_negated_command] = STATE(194),
    [sym_test_command] = STATE(194),
    [sym_variable_assignment] = STATE(195),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(194),
    [sym_for_statement] = STATE(194),
    [sym_compound_statement] = STATE(194),
    [sym_subshell] = STATE(194),
    [sym_declaration_command] = STATE(194),
    [sym_unset_command] = STATE(194),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [aux_sym__statements2] = STATE(247),
    [sym_c_style_for_statement] = STATE(194),
    [sym_while_statement] = STATE(194),
    [sym_case_statement] = STATE(194),
    [sym_pipeline] = STATE(194),
    [sym_list] = STATE(194),
    [sym_command] = STATE(194),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_fi] = ACTIONS(1214),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [193] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym__terminated_statement] = STATE(248),
    [sym_if_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_negated_command] = STATE(60),
    [sym_test_command] = STATE(60),
    [sym_variable_assignment] = STATE(61),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_compound_statement] = STATE(60),
    [sym_subshell] = STATE(60),
    [sym_declaration_command] = STATE(60),
    [sym_unset_command] = STATE(60),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_c_style_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_case_statement] = STATE(60),
    [sym_pipeline] = STATE(60),
    [sym_list] = STATE(60),
    [sym_command] = STATE(60),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [194] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_LF] = ACTIONS(1216),
    [anon_sym_SEMI] = ACTIONS(1218),
    [sym_file_descriptor] = ACTIONS(439),
    [anon_sym_AMP] = ACTIONS(1218),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(433),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_SEMI_SEMI] = ACTIONS(1218),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [195] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(1216),
    [anon_sym_SEMI] = ACTIONS(1218),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(1218),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_SEMI_SEMI] = ACTIONS(1218),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [196] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_fi] = ACTIONS(1220),
  },
  [197] = {
    [aux_sym_if_statement_repeat1] = STATE(252),
    [sym_elif_clause] = STATE(252),
    [sym_else_clause] = STATE(253),
    [anon_sym_elif] = ACTIONS(1222),
    [anon_sym_fi] = ACTIONS(1220),
    [anon_sym_else] = ACTIONS(1224),
    [sym_comment] = ACTIONS(19),
  },
  [198] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(194),
    [sym_function_definition] = STATE(194),
    [sym_negated_command] = STATE(194),
    [sym_test_command] = STATE(194),
    [sym_variable_assignment] = STATE(195),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(194),
    [sym_for_statement] = STATE(194),
    [sym_elif_clause] = STATE(254),
    [sym_else_clause] = STATE(253),
    [sym_compound_statement] = STATE(194),
    [sym_subshell] = STATE(194),
    [sym_declaration_command] = STATE(194),
    [sym_unset_command] = STATE(194),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_if_statement_repeat1] = STATE(254),
    [aux_sym_command_repeat1] = STATE(391),
    [aux_sym__statements2] = STATE(255),
    [sym_c_style_for_statement] = STATE(194),
    [sym_while_statement] = STATE(194),
    [sym_case_statement] = STATE(194),
    [sym_pipeline] = STATE(194),
    [sym_list] = STATE(194),
    [sym_command] = STATE(194),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [anon_sym_fi] = ACTIONS(1226),
    [anon_sym_else] = ACTIONS(880),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_elif] = ACTIONS(882),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
  },
  [199] = {
    [anon_sym_AMP] = ACTIONS(1228),
    [anon_sym_LF] = ACTIONS(1230),
    [anon_sym_SEMI] = ACTIONS(1228),
    [anon_sym_SEMI_SEMI] = ACTIONS(1228),
    [sym_comment] = ACTIONS(3),
  },
  [200] = {
    [sym_command_substitution] = STATE(257),
    [aux_sym__literal_repeat1] = STATE(259),
    [sym_case_item] = STATE(261),
    [sym_string] = STATE(257),
    [sym_process_substitution] = STATE(257),
    [sym_last_case_item] = STATE(260),
    [sym_simple_expansion] = STATE(257),
    [sym_string_expansion] = STATE(257),
    [aux_sym_case_statement_repeat1] = STATE(261),
    [sym_concatenation] = STATE(262),
    [sym_expansion] = STATE(257),
    [sym_word] = ACTIONS(1232),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(1234),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_esac] = ACTIONS(1236),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(1234),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym__special_character] = ACTIONS(231),
    [sym_comment] = ACTIONS(19),
  },
  [201] = {
    [anon_sym_AMP] = ACTIONS(1238),
    [anon_sym_LF] = ACTIONS(1240),
    [anon_sym_SEMI] = ACTIONS(1238),
    [anon_sym_SEMI_SEMI] = ACTIONS(1238),
    [sym_comment] = ACTIONS(3),
  },
  [202] = {
    [sym_command_substitution] = STATE(257),
    [aux_sym__literal_repeat1] = STATE(259),
    [sym_case_item] = STATE(266),
    [sym_string] = STATE(257),
    [sym_process_substitution] = STATE(257),
    [sym_last_case_item] = STATE(265),
    [sym_simple_expansion] = STATE(257),
    [sym_string_expansion] = STATE(257),
    [aux_sym_case_statement_repeat1] = STATE(266),
    [sym_concatenation] = STATE(262),
    [sym_expansion] = STATE(257),
    [sym_word] = ACTIONS(1232),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(1234),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_esac] = ACTIONS(1242),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(1234),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym__special_character] = ACTIONS(231),
    [sym_comment] = ACTIONS(19),
  },
  [203] = {
    [anon_sym_PLUS_EQ] = ACTIONS(1244),
    [anon_sym_PLUS_PLUS] = ACTIONS(1244),
    [anon_sym_DASH] = ACTIONS(1246),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1244),
    [anon_sym_PIPE_PIPE] = ACTIONS(1244),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1244),
    [sym_test_operator] = ACTIONS(1244),
    [anon_sym_LT] = ACTIONS(1246),
    [anon_sym_EQ_TILDE] = ACTIONS(1244),
    [anon_sym_DASH_DASH] = ACTIONS(1244),
    [anon_sym_LT_EQ] = ACTIONS(1244),
    [anon_sym_DASH_EQ] = ACTIONS(1244),
    [anon_sym_BANG_EQ] = ACTIONS(1244),
    [anon_sym_RPAREN] = ACTIONS(1246),
    [anon_sym_GT] = ACTIONS(1246),
    [anon_sym_EQ] = ACTIONS(1246),
    [anon_sym_EQ_EQ] = ACTIONS(1244),
    [anon_sym_GT_EQ] = ACTIONS(1244),
    [anon_sym_PLUS] = ACTIONS(1246),
    [anon_sym_AMP_AMP] = ACTIONS(1244),
  },
  [204] = {
    [anon_sym_PLUS_EQ] = ACTIONS(1248),
    [anon_sym_PLUS_PLUS] = ACTIONS(1248),
    [anon_sym_DASH] = ACTIONS(1250),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1248),
    [anon_sym_PIPE_PIPE] = ACTIONS(1248),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1248),
    [sym_test_operator] = ACTIONS(1248),
    [anon_sym_LT] = ACTIONS(1250),
    [anon_sym_EQ_TILDE] = ACTIONS(1248),
    [anon_sym_DASH_DASH] = ACTIONS(1248),
    [anon_sym_LT_EQ] = ACTIONS(1248),
    [anon_sym_DASH_EQ] = ACTIONS(1248),
    [anon_sym_BANG_EQ] = ACTIONS(1248),
    [anon_sym_RPAREN] = ACTIONS(1250),
    [anon_sym_GT] = ACTIONS(1250),
    [anon_sym_EQ] = ACTIONS(1250),
    [anon_sym_EQ_EQ] = ACTIONS(1248),
    [anon_sym_GT_EQ] = ACTIONS(1248),
    [anon_sym_PLUS] = ACTIONS(1250),
    [anon_sym_AMP_AMP] = ACTIONS(1248),
  },
  [205] = {
    [anon_sym_PLUS_EQ] = ACTIONS(1248),
    [anon_sym_PLUS_PLUS] = ACTIONS(1248),
    [anon_sym_DASH] = ACTIONS(1250),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1248),
    [anon_sym_PIPE_PIPE] = ACTIONS(1248),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1248),
    [sym_test_operator] = ACTIONS(1248),
    [anon_sym_LT] = ACTIONS(1250),
    [anon_sym_EQ_TILDE] = ACTIONS(1248),
    [anon_sym_DASH_DASH] = ACTIONS(1248),
    [anon_sym_LT_EQ] = ACTIONS(1248),
    [anon_sym_DASH_EQ] = ACTIONS(1248),
    [anon_sym_BANG_EQ] = ACTIONS(1248),
    [anon_sym_RPAREN] = ACTIONS(1250),
    [anon_sym_GT] = ACTIONS(1250),
    [anon_sym_EQ] = ACTIONS(1250),
    [anon_sym_EQ_EQ] = ACTIONS(1248),
    [anon_sym_GT_EQ] = ACTIONS(1248),
    [anon_sym_PLUS] = ACTIONS(1250),
    [anon_sym_AMP_AMP] = ACTIONS(1248),
  },
  [206] = {
    [sym_word] = ACTIONS(1252),
    [anon_sym_AMP_GT_GT] = ACTIONS(1252),
    [anon_sym_DOLLAR] = ACTIONS(1252),
    [anon_sym_LT_LT] = ACTIONS(1252),
    [anon_sym_LT_LPAREN] = ACTIONS(1252),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1252),
    [sym__concat] = ACTIONS(1254),
    [anon_sym_PIPE] = ACTIONS(1252),
    [anon_sym_LT] = ACTIONS(1252),
    [anon_sym_LT_AMP] = ACTIONS(1252),
    [anon_sym_GT_GT] = ACTIONS(1252),
    [anon_sym_EQ_TILDE] = ACTIONS(1252),
    [sym__special_character] = ACTIONS(1252),
    [anon_sym_LT_LT_DASH] = ACTIONS(1252),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1252),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1252),
    [anon_sym_LF] = ACTIONS(1254),
    [anon_sym_SEMI] = ACTIONS(1252),
    [sym_raw_string] = ACTIONS(1252),
    [sym_file_descriptor] = ACTIONS(1254),
    [anon_sym_AMP] = ACTIONS(1252),
    [anon_sym_GT] = ACTIONS(1252),
    [anon_sym_AMP_GT] = ACTIONS(1252),
    [anon_sym_EQ_EQ] = ACTIONS(1252),
    [anon_sym_DQUOTE] = ACTIONS(1252),
    [anon_sym_LT_LT_LT] = ACTIONS(1252),
    [anon_sym_GT_AMP] = ACTIONS(1252),
    [ts_builtin_sym_end] = ACTIONS(1254),
    [anon_sym_BQUOTE] = ACTIONS(1252),
    [anon_sym_GT_LPAREN] = ACTIONS(1252),
    [sym_ansii_c_string] = ACTIONS(1252),
    [anon_sym_AMP_AMP] = ACTIONS(1252),
    [anon_sym_SEMI_SEMI] = ACTIONS(1252),
    [anon_sym_PIPE_AMP] = ACTIONS(1252),
  },
  [207] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(268),
    [sym_concatenation] = STATE(268),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(1256),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1258),
    [anon_sym_DASH] = ACTIONS(1256),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(1256),
    [anon_sym_PERCENT] = ACTIONS(1256),
    [anon_sym_POUND] = ACTIONS(1260),
    [anon_sym_COLON_DASH] = ACTIONS(1256),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(1256),
    [sym__special_character] = ACTIONS(517),
  },
  [208] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(938),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1258),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(938),
    [anon_sym_PERCENT] = ACTIONS(938),
    [anon_sym_POUND] = ACTIONS(940),
    [anon_sym_COLON_DASH] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(938),
    [sym__special_character] = ACTIONS(517),
  },
  [209] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(1262),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1265),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1268),
    [sym_raw_string] = ACTIONS(1271),
    [anon_sym_COLON] = ACTIONS(1274),
    [anon_sym_DOLLAR] = ACTIONS(1277),
    [anon_sym_RBRACE] = ACTIONS(1280),
    [anon_sym_DASH] = ACTIONS(1274),
    [anon_sym_PERCENT] = ACTIONS(1274),
    [anon_sym_EQ] = ACTIONS(1274),
    [anon_sym_POUND] = ACTIONS(1282),
    [anon_sym_COLON_DASH] = ACTIONS(1274),
    [anon_sym_LT_LPAREN] = ACTIONS(1285),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1288),
    [anon_sym_BQUOTE] = ACTIONS(1291),
    [anon_sym_GT_LPAREN] = ACTIONS(1285),
    [sym_ansii_c_string] = ACTIONS(1271),
    [anon_sym_COLON_QMARK] = ACTIONS(1274),
    [sym__special_character] = ACTIONS(1294),
  },
  [210] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(268),
    [sym_concatenation] = STATE(268),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(1256),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1258),
    [anon_sym_DASH] = ACTIONS(1256),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(1256),
    [anon_sym_PERCENT] = ACTIONS(1256),
    [anon_sym_POUND] = ACTIONS(1260),
    [anon_sym_COLON_DASH] = ACTIONS(1256),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(1256),
    [sym__special_character] = ACTIONS(517),
    [sym_regex] = ACTIONS(1297),
  },
  [211] = {
    [sym_command_substitution] = STATE(270),
    [aux_sym__literal_repeat1] = STATE(271),
    [sym_string] = STATE(270),
    [sym_process_substitution] = STATE(270),
    [sym_simple_expansion] = STATE(270),
    [sym_string_expansion] = STATE(270),
    [sym_concatenation] = STATE(272),
    [sym_expansion] = STATE(270),
    [sym_word] = ACTIONS(1299),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(956),
    [anon_sym_DQUOTE] = ACTIONS(958),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(960),
    [sym_raw_string] = ACTIONS(1299),
    [anon_sym_BQUOTE] = ACTIONS(962),
    [anon_sym_DOLLAR] = ACTIONS(964),
    [sym_ansii_c_string] = ACTIONS(1299),
    [anon_sym_GT_LPAREN] = ACTIONS(966),
    [anon_sym_LT_LPAREN] = ACTIONS(966),
    [anon_sym_RBRACE] = ACTIONS(1258),
    [sym__special_character] = ACTIONS(968),
    [sym_comment] = ACTIONS(19),
  },
  [212] = {
    [sym_word] = ACTIONS(1301),
    [anon_sym_AMP_GT_GT] = ACTIONS(1301),
    [anon_sym_DOLLAR] = ACTIONS(1301),
    [anon_sym_LT_LT] = ACTIONS(1301),
    [anon_sym_LT_LPAREN] = ACTIONS(1301),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1301),
    [sym__concat] = ACTIONS(1303),
    [anon_sym_PIPE] = ACTIONS(1301),
    [anon_sym_LT] = ACTIONS(1301),
    [anon_sym_LT_AMP] = ACTIONS(1301),
    [anon_sym_GT_GT] = ACTIONS(1301),
    [anon_sym_EQ_TILDE] = ACTIONS(1301),
    [sym__special_character] = ACTIONS(1301),
    [anon_sym_LT_LT_DASH] = ACTIONS(1301),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1301),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1301),
    [anon_sym_LF] = ACTIONS(1303),
    [anon_sym_SEMI] = ACTIONS(1301),
    [sym_raw_string] = ACTIONS(1301),
    [sym_file_descriptor] = ACTIONS(1303),
    [anon_sym_AMP] = ACTIONS(1301),
    [anon_sym_GT] = ACTIONS(1301),
    [anon_sym_AMP_GT] = ACTIONS(1301),
    [anon_sym_EQ_EQ] = ACTIONS(1301),
    [anon_sym_DQUOTE] = ACTIONS(1301),
    [anon_sym_LT_LT_LT] = ACTIONS(1301),
    [anon_sym_GT_AMP] = ACTIONS(1301),
    [ts_builtin_sym_end] = ACTIONS(1303),
    [anon_sym_BQUOTE] = ACTIONS(1301),
    [anon_sym_GT_LPAREN] = ACTIONS(1301),
    [sym_ansii_c_string] = ACTIONS(1301),
    [anon_sym_AMP_AMP] = ACTIONS(1301),
    [anon_sym_SEMI_SEMI] = ACTIONS(1301),
    [anon_sym_PIPE_AMP] = ACTIONS(1301),
  },
  [213] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(275),
    [sym_concatenation] = STATE(275),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(1305),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1307),
    [anon_sym_DASH] = ACTIONS(1305),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(1305),
    [anon_sym_PERCENT] = ACTIONS(1305),
    [anon_sym_POUND] = ACTIONS(1309),
    [anon_sym_COLON_DASH] = ACTIONS(1305),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(1305),
    [sym__special_character] = ACTIONS(517),
    [sym_regex] = ACTIONS(1311),
  },
  [214] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(938),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1307),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(938),
    [anon_sym_PERCENT] = ACTIONS(938),
    [anon_sym_POUND] = ACTIONS(940),
    [anon_sym_COLON_DASH] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(938),
    [sym__special_character] = ACTIONS(517),
  },
  [215] = {
    [aux_sym_concatenation_repeat1] = STATE(1097),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(1258),
    [sym__concat] = ACTIONS(1313),
  },
  [216] = {
    [aux_sym__literal_repeat1] = STATE(1135),
    [sym__special_character] = ACTIONS(1315),
    [anon_sym_RBRACE] = ACTIONS(1317),
    [sym_comment] = ACTIONS(19),
  },
  [217] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(1258),
  },
  [218] = {
    [sym_word] = ACTIONS(1319),
    [anon_sym_AMP_GT_GT] = ACTIONS(1319),
    [anon_sym_DOLLAR] = ACTIONS(1319),
    [anon_sym_LT_LT] = ACTIONS(1319),
    [anon_sym_LT_LPAREN] = ACTIONS(1319),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1319),
    [sym__concat] = ACTIONS(1321),
    [anon_sym_PIPE] = ACTIONS(1319),
    [anon_sym_LT] = ACTIONS(1319),
    [anon_sym_LT_AMP] = ACTIONS(1319),
    [anon_sym_GT_GT] = ACTIONS(1319),
    [anon_sym_EQ_TILDE] = ACTIONS(1319),
    [sym__special_character] = ACTIONS(1319),
    [anon_sym_LT_LT_DASH] = ACTIONS(1319),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1319),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1319),
    [anon_sym_LF] = ACTIONS(1321),
    [anon_sym_SEMI] = ACTIONS(1319),
    [sym_raw_string] = ACTIONS(1319),
    [sym_file_descriptor] = ACTIONS(1321),
    [anon_sym_AMP] = ACTIONS(1319),
    [anon_sym_GT] = ACTIONS(1319),
    [anon_sym_AMP_GT] = ACTIONS(1319),
    [anon_sym_EQ_EQ] = ACTIONS(1319),
    [anon_sym_DQUOTE] = ACTIONS(1319),
    [anon_sym_LT_LT_LT] = ACTIONS(1319),
    [anon_sym_GT_AMP] = ACTIONS(1319),
    [ts_builtin_sym_end] = ACTIONS(1321),
    [anon_sym_BQUOTE] = ACTIONS(1319),
    [anon_sym_GT_LPAREN] = ACTIONS(1319),
    [sym_ansii_c_string] = ACTIONS(1319),
    [anon_sym_AMP_AMP] = ACTIONS(1319),
    [anon_sym_SEMI_SEMI] = ACTIONS(1319),
    [anon_sym_PIPE_AMP] = ACTIONS(1319),
  },
  [219] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(278),
    [sym_concatenation] = STATE(278),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(1323),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1325),
    [anon_sym_DASH] = ACTIONS(1323),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(1323),
    [anon_sym_PERCENT] = ACTIONS(1323),
    [anon_sym_POUND] = ACTIONS(1327),
    [anon_sym_COLON_DASH] = ACTIONS(1323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(1323),
    [sym__special_character] = ACTIONS(517),
  },
  [220] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(938),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1325),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(938),
    [anon_sym_PERCENT] = ACTIONS(938),
    [anon_sym_POUND] = ACTIONS(940),
    [anon_sym_COLON_DASH] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(938),
    [sym__special_character] = ACTIONS(517),
  },
  [221] = {
    [aux_sym_concatenation_repeat1] = STATE(1129),
    [sym_word] = ACTIONS(1329),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1329),
    [anon_sym_DQUOTE] = ACTIONS(1329),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1329),
    [sym_raw_string] = ACTIONS(1329),
    [sym__concat] = ACTIONS(1331),
    [anon_sym_BQUOTE] = ACTIONS(1329),
    [anon_sym_DOLLAR] = ACTIONS(1333),
    [anon_sym_RPAREN] = ACTIONS(1329),
    [sym_ansii_c_string] = ACTIONS(1329),
    [anon_sym_LT_LPAREN] = ACTIONS(1329),
    [anon_sym_GT_LPAREN] = ACTIONS(1329),
    [sym__special_character] = ACTIONS(1329),
    [sym_comment] = ACTIONS(19),
  },
  [222] = {
    [sym_word] = ACTIONS(1335),
    [anon_sym_AMP_GT_GT] = ACTIONS(1335),
    [anon_sym_DOLLAR] = ACTIONS(1335),
    [anon_sym_LT_LT] = ACTIONS(1335),
    [anon_sym_LT_LPAREN] = ACTIONS(1335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1335),
    [anon_sym_PIPE] = ACTIONS(1335),
    [anon_sym_LT] = ACTIONS(1335),
    [anon_sym_LT_AMP] = ACTIONS(1335),
    [anon_sym_GT_GT] = ACTIONS(1335),
    [sym__special_character] = ACTIONS(1335),
    [anon_sym_LT_LT_DASH] = ACTIONS(1335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1335),
    [anon_sym_LF] = ACTIONS(1337),
    [anon_sym_SEMI] = ACTIONS(1335),
    [sym_raw_string] = ACTIONS(1335),
    [sym_variable_name] = ACTIONS(1337),
    [sym_file_descriptor] = ACTIONS(1337),
    [anon_sym_AMP] = ACTIONS(1335),
    [anon_sym_GT] = ACTIONS(1335),
    [anon_sym_AMP_GT] = ACTIONS(1335),
    [anon_sym_DQUOTE] = ACTIONS(1335),
    [anon_sym_LT_LT_LT] = ACTIONS(1335),
    [anon_sym_GT_AMP] = ACTIONS(1335),
    [ts_builtin_sym_end] = ACTIONS(1337),
    [anon_sym_BQUOTE] = ACTIONS(1335),
    [anon_sym_GT_LPAREN] = ACTIONS(1335),
    [sym_ansii_c_string] = ACTIONS(1335),
    [anon_sym_AMP_AMP] = ACTIONS(1335),
    [anon_sym_SEMI_SEMI] = ACTIONS(1335),
    [anon_sym_PIPE_AMP] = ACTIONS(1335),
  },
  [223] = {
    [aux_sym__literal_repeat1] = STATE(1167),
    [sym_word] = ACTIONS(1339),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1339),
    [anon_sym_DQUOTE] = ACTIONS(1339),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1339),
    [sym_raw_string] = ACTIONS(1339),
    [anon_sym_BQUOTE] = ACTIONS(1339),
    [anon_sym_DOLLAR] = ACTIONS(1341),
    [anon_sym_RPAREN] = ACTIONS(1339),
    [sym_ansii_c_string] = ACTIONS(1339),
    [anon_sym_LT_LPAREN] = ACTIONS(1339),
    [anon_sym_GT_LPAREN] = ACTIONS(1339),
    [sym__special_character] = ACTIONS(1343),
    [sym_comment] = ACTIONS(19),
  },
  [224] = {
    [sym_command_substitution] = STATE(221),
    [aux_sym__literal_repeat1] = STATE(223),
    [sym_string] = STATE(221),
    [sym_process_substitution] = STATE(221),
    [aux_sym_for_statement_repeat1] = STATE(280),
    [sym_simple_expansion] = STATE(221),
    [sym_string_expansion] = STATE(221),
    [sym_concatenation] = STATE(280),
    [sym_expansion] = STATE(221),
    [sym_word] = ACTIONS(988),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(990),
    [anon_sym_DQUOTE] = ACTIONS(992),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(994),
    [sym_raw_string] = ACTIONS(988),
    [anon_sym_BQUOTE] = ACTIONS(996),
    [anon_sym_DOLLAR] = ACTIONS(998),
    [sym_ansii_c_string] = ACTIONS(988),
    [anon_sym_GT_LPAREN] = ACTIONS(1000),
    [anon_sym_LT_LPAREN] = ACTIONS(1000),
    [anon_sym_RPAREN] = ACTIONS(1345),
    [sym__special_character] = ACTIONS(1004),
    [sym_comment] = ACTIONS(19),
  },
  [225] = {
    [anon_sym_PLUS_EQ] = ACTIONS(1347),
    [sym__concat] = ACTIONS(1349),
    [anon_sym_EQ] = ACTIONS(1347),
    [sym_comment] = ACTIONS(19),
  },
  [226] = {
    [sym_command_substitution] = STATE(816),
    [sym_simple_expansion] = STATE(816),
    [sym_string_expansion] = STATE(816),
    [sym_string] = STATE(816),
    [sym_process_substitution] = STATE(816),
    [sym_expansion] = STATE(816),
    [sym_word] = ACTIONS(1351),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(279),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(281),
    [sym_raw_string] = ACTIONS(1351),
    [anon_sym_BQUOTE] = ACTIONS(295),
    [anon_sym_DOLLAR] = ACTIONS(287),
    [anon_sym_GT_LPAREN] = ACTIONS(289),
    [sym_ansii_c_string] = ACTIONS(1351),
    [anon_sym_LT_LPAREN] = ACTIONS(289),
    [anon_sym_RBRACK] = ACTIONS(1353),
    [sym__special_character] = ACTIONS(1355),
    [sym_comment] = ACTIONS(19),
  },
  [227] = {
    [anon_sym_PLUS_EQ] = ACTIONS(1357),
    [sym__concat] = ACTIONS(1359),
    [anon_sym_EQ] = ACTIONS(1357),
    [sym_comment] = ACTIONS(19),
  },
  [228] = {
    [anon_sym_RBRACK] = ACTIONS(1361),
    [sym_comment] = ACTIONS(19),
  },
  [229] = {
    [anon_sym_RBRACK] = ACTIONS(1353),
    [sym_comment] = ACTIONS(19),
  },
  [230] = {
    [anon_sym_DOLLAR] = ACTIONS(1363),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1363),
    [anon_sym_DQUOTE] = ACTIONS(1363),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1363),
    [sym__string_content] = ACTIONS(1363),
  },
  [231] = {
    [sym_word] = ACTIONS(1365),
    [anon_sym_AMP_GT_GT] = ACTIONS(1365),
    [anon_sym_DOLLAR] = ACTIONS(1365),
    [anon_sym_LT_LT] = ACTIONS(1365),
    [anon_sym_LT_LPAREN] = ACTIONS(1365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1365),
    [sym__concat] = ACTIONS(1367),
    [anon_sym_PIPE] = ACTIONS(1365),
    [anon_sym_LT] = ACTIONS(1365),
    [anon_sym_LT_AMP] = ACTIONS(1365),
    [anon_sym_GT_GT] = ACTIONS(1365),
    [anon_sym_EQ_TILDE] = ACTIONS(1365),
    [sym__special_character] = ACTIONS(1365),
    [anon_sym_LT_LT_DASH] = ACTIONS(1365),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1365),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1365),
    [anon_sym_LF] = ACTIONS(1367),
    [anon_sym_SEMI] = ACTIONS(1365),
    [sym_raw_string] = ACTIONS(1365),
    [sym_file_descriptor] = ACTIONS(1367),
    [anon_sym_AMP] = ACTIONS(1365),
    [anon_sym_GT] = ACTIONS(1365),
    [anon_sym_AMP_GT] = ACTIONS(1365),
    [anon_sym_EQ_EQ] = ACTIONS(1365),
    [anon_sym_DQUOTE] = ACTIONS(1365),
    [anon_sym_LT_LT_LT] = ACTIONS(1365),
    [anon_sym_GT_AMP] = ACTIONS(1365),
    [ts_builtin_sym_end] = ACTIONS(1367),
    [anon_sym_BQUOTE] = ACTIONS(1365),
    [anon_sym_GT_LPAREN] = ACTIONS(1365),
    [sym_ansii_c_string] = ACTIONS(1365),
    [anon_sym_AMP_AMP] = ACTIONS(1365),
    [anon_sym_SEMI_SEMI] = ACTIONS(1365),
    [anon_sym_PIPE_AMP] = ACTIONS(1365),
  },
  [232] = {
    [aux_sym__simple_variable_name_token1] = ACTIONS(571),
    [anon_sym__] = ACTIONS(571),
    [anon_sym_AT] = ACTIONS(571),
    [anon_sym_BANG] = ACTIONS(575),
    [anon_sym_STAR] = ACTIONS(571),
    [anon_sym_DOLLAR] = ACTIONS(575),
    [anon_sym_QMARK] = ACTIONS(571),
    [anon_sym_DASH] = ACTIONS(575),
    [sym__string_content] = ACTIONS(577),
    [sym_comment] = ACTIONS(3),
    [anon_sym_POUND] = ACTIONS(575),
    [anon_sym_0] = ACTIONS(571),
  },
  [233] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1369),
    [anon_sym_AMP_GT_GT] = ACTIONS(1369),
    [anon_sym_LF] = ACTIONS(1371),
    [anon_sym_SEMI] = ACTIONS(1369),
    [anon_sym_LT_LT] = ACTIONS(1369),
    [anon_sym_AMP] = ACTIONS(1369),
    [anon_sym_GT] = ACTIONS(1369),
    [sym_file_descriptor] = ACTIONS(1371),
    [anon_sym_AMP_GT] = ACTIONS(1369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1369),
    [ts_builtin_sym_end] = ACTIONS(1371),
    [anon_sym_LT_LT_LT] = ACTIONS(1369),
    [anon_sym_PIPE] = ACTIONS(1369),
    [anon_sym_GT_AMP] = ACTIONS(1369),
    [anon_sym_LT] = ACTIONS(1369),
    [anon_sym_LT_AMP] = ACTIONS(1369),
    [anon_sym_GT_GT] = ACTIONS(1369),
    [anon_sym_AMP_AMP] = ACTIONS(1369),
    [anon_sym_SEMI_SEMI] = ACTIONS(1369),
    [anon_sym_PIPE_AMP] = ACTIONS(1369),
  },
  [234] = {
    [sym_command_substitution] = STATE(482),
    [aux_sym__literal_repeat1] = STATE(484),
    [sym_string] = STATE(482),
    [sym_process_substitution] = STATE(482),
    [aux_sym_for_statement_repeat1] = STATE(503),
    [sym_simple_expansion] = STATE(482),
    [sym_string_expansion] = STATE(482),
    [sym_concatenation] = STATE(503),
    [sym_expansion] = STATE(482),
    [sym_word] = ACTIONS(1373),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1375),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1377),
    [sym_raw_string] = ACTIONS(1373),
    [anon_sym_LF] = ACTIONS(1379),
    [anon_sym_SEMI] = ACTIONS(1381),
    [anon_sym_DOLLAR] = ACTIONS(1071),
    [anon_sym_AMP] = ACTIONS(1381),
    [anon_sym_LT_LPAREN] = ACTIONS(1383),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1385),
    [anon_sym_BQUOTE] = ACTIONS(1387),
    [anon_sym_GT_LPAREN] = ACTIONS(1383),
    [sym_ansii_c_string] = ACTIONS(1373),
    [sym__special_character] = ACTIONS(1389),
    [anon_sym_SEMI_SEMI] = ACTIONS(1381),
  },
  [235] = {
    [sym_command_substitution] = STATE(65),
    [sym_unary_expression] = STATE(287),
    [sym_postfix_expression] = STATE(287),
    [sym_string] = STATE(65),
    [aux_sym__literal_repeat1] = STATE(68),
    [sym_process_substitution] = STATE(65),
    [sym_parenthesized_expression] = STATE(287),
    [sym_simple_expansion] = STATE(65),
    [sym_string_expansion] = STATE(65),
    [sym__expression] = STATE(287),
    [sym_binary_expression] = STATE(287),
    [sym_concatenation] = STATE(287),
    [sym_expansion] = STATE(65),
    [sym_word] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_BANG] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1391),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [sym_test_operator] = ACTIONS(227),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [sym_ansii_c_string] = ACTIONS(217),
    [sym__special_character] = ACTIONS(231),
  },
  [236] = {
    [anon_sym_BANG_EQ] = ACTIONS(1079),
    [anon_sym_PLUS_EQ] = ACTIONS(1079),
    [anon_sym_LF] = ACTIONS(1393),
    [anon_sym_SEMI] = ACTIONS(1393),
    [anon_sym_PLUS_PLUS] = ACTIONS(1083),
    [anon_sym_DASH] = ACTIONS(1079),
    [anon_sym_GT] = ACTIONS(1079),
    [anon_sym_EQ] = ACTIONS(1079),
    [anon_sym_AMP] = ACTIONS(1393),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(1085),
    [anon_sym_PIPE_PIPE] = ACTIONS(1079),
    [anon_sym_GT_EQ] = ACTIONS(1079),
    [anon_sym_PLUS] = ACTIONS(1079),
    [anon_sym_LT] = ACTIONS(1079),
    [sym_test_operator] = ACTIONS(1079),
    [anon_sym_EQ_TILDE] = ACTIONS(1085),
    [anon_sym_DASH_DASH] = ACTIONS(1083),
    [anon_sym_LT_EQ] = ACTIONS(1079),
    [anon_sym_AMP_AMP] = ACTIONS(1079),
    [anon_sym_SEMI_SEMI] = ACTIONS(1393),
    [anon_sym_DASH_EQ] = ACTIONS(1079),
  },
  [237] = {
    [sym_command_substitution] = STATE(559),
    [sym_unary_expression] = STATE(289),
    [sym_postfix_expression] = STATE(289),
    [sym_string] = STATE(559),
    [aux_sym__literal_repeat1] = STATE(561),
    [sym_process_substitution] = STATE(559),
    [sym_parenthesized_expression] = STATE(289),
    [sym_simple_expansion] = STATE(559),
    [sym_string_expansion] = STATE(559),
    [sym__expression] = STATE(289),
    [sym_binary_expression] = STATE(289),
    [sym_concatenation] = STATE(289),
    [sym_expansion] = STATE(559),
    [sym_word] = ACTIONS(597),
    [anon_sym_LPAREN] = ACTIONS(599),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(601),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(603),
    [sym_raw_string] = ACTIONS(597),
    [anon_sym_LF] = ACTIONS(1393),
    [anon_sym_BANG] = ACTIONS(607),
    [anon_sym_SEMI] = ACTIONS(1393),
    [anon_sym_DOLLAR] = ACTIONS(609),
    [anon_sym_AMP] = ACTIONS(1393),
    [anon_sym_LT_LPAREN] = ACTIONS(611),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [sym_test_operator] = ACTIONS(607),
    [anon_sym_BQUOTE] = ACTIONS(615),
    [anon_sym_GT_LPAREN] = ACTIONS(611),
    [sym_ansii_c_string] = ACTIONS(597),
    [sym__special_character] = ACTIONS(617),
    [anon_sym_SEMI_SEMI] = ACTIONS(1393),
  },
  [238] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1395),
    [anon_sym_AMP_GT_GT] = ACTIONS(1395),
    [anon_sym_LF] = ACTIONS(1397),
    [anon_sym_SEMI] = ACTIONS(1395),
    [anon_sym_LT_LT] = ACTIONS(1395),
    [anon_sym_AMP] = ACTIONS(1395),
    [anon_sym_GT] = ACTIONS(1395),
    [sym_file_descriptor] = ACTIONS(1397),
    [anon_sym_AMP_GT] = ACTIONS(1395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1395),
    [ts_builtin_sym_end] = ACTIONS(1397),
    [anon_sym_LT_LT_LT] = ACTIONS(1395),
    [anon_sym_PIPE] = ACTIONS(1395),
    [anon_sym_GT_AMP] = ACTIONS(1395),
    [anon_sym_LT] = ACTIONS(1395),
    [anon_sym_LT_AMP] = ACTIONS(1395),
    [anon_sym_GT_GT] = ACTIONS(1395),
    [anon_sym_AMP_AMP] = ACTIONS(1395),
    [anon_sym_SEMI_SEMI] = ACTIONS(1395),
    [anon_sym_PIPE_AMP] = ACTIONS(1395),
  },
  [239] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(194),
    [sym_function_definition] = STATE(194),
    [sym_negated_command] = STATE(194),
    [sym_test_command] = STATE(194),
    [sym_variable_assignment] = STATE(195),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(194),
    [sym_for_statement] = STATE(194),
    [sym_compound_statement] = STATE(194),
    [sym_subshell] = STATE(194),
    [sym_declaration_command] = STATE(194),
    [sym_unset_command] = STATE(194),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [aux_sym__statements2] = STATE(255),
    [sym_c_style_for_statement] = STATE(194),
    [sym_while_statement] = STATE(194),
    [sym_case_statement] = STATE(194),
    [sym_pipeline] = STATE(194),
    [sym_list] = STATE(194),
    [sym_command] = STATE(194),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [anon_sym_done] = ACTIONS(1399),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [240] = {
    [aux_sym__simple_variable_name_token1] = ACTIONS(1401),
    [anon_sym__] = ACTIONS(1401),
    [anon_sym_AT] = ACTIONS(1403),
    [anon_sym_BANG] = ACTIONS(1405),
    [anon_sym_STAR] = ACTIONS(1403),
    [anon_sym_DOLLAR] = ACTIONS(1405),
    [anon_sym_QMARK] = ACTIONS(1403),
    [anon_sym_DASH] = ACTIONS(1405),
    [sym_comment] = ACTIONS(3),
    [anon_sym_POUND] = ACTIONS(1405),
    [anon_sym_0] = ACTIONS(1401),
  },
  [241] = {
    [anon_sym_AMP] = ACTIONS(1407),
    [ts_builtin_sym_end] = ACTIONS(1409),
    [anon_sym_LF] = ACTIONS(1409),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_SEMI_SEMI] = ACTIONS(1407),
    [sym_comment] = ACTIONS(3),
  },
  [242] = {
    [sym_command_substitution] = STATE(292),
    [sym_simple_expansion] = STATE(292),
    [sym_expansion] = STATE(292),
    [aux_sym_heredoc_body_repeat1] = STATE(292),
    [anon_sym_DOLLAR] = ACTIONS(1101),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1103),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1105),
    [sym__heredoc_body_end] = ACTIONS(1411),
    [sym_comment] = ACTIONS(19),
    [anon_sym_BQUOTE] = ACTIONS(1109),
    [sym__heredoc_body_middle] = ACTIONS(1413),
  },
  [243] = {
    [anon_sym_LPAREN] = ACTIONS(1415),
    [sym_word] = ACTIONS(1415),
    [anon_sym_AMP_GT_GT] = ACTIONS(1417),
    [anon_sym_local] = ACTIONS(1415),
    [anon_sym_typeset] = ACTIONS(1415),
    [anon_sym_unsetenv] = ACTIONS(1415),
    [anon_sym_DOLLAR] = ACTIONS(1415),
    [anon_sym_LT_LPAREN] = ACTIONS(1417),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(1415),
    [anon_sym_LBRACE] = ACTIONS(1417),
    [anon_sym_LT] = ACTIONS(1415),
    [anon_sym_LT_AMP] = ACTIONS(1417),
    [anon_sym_GT_GT] = ACTIONS(1417),
    [anon_sym_export] = ACTIONS(1415),
    [sym__special_character] = ACTIONS(1415),
    [anon_sym_if] = ACTIONS(1415),
    [anon_sym_case] = ACTIONS(1415),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1417),
    [sym_raw_string] = ACTIONS(1417),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1417),
    [anon_sym_BANG] = ACTIONS(1415),
    [anon_sym_declare] = ACTIONS(1415),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1417),
    [sym_file_descriptor] = ACTIONS(1417),
    [sym_variable_name] = ACTIONS(1417),
    [anon_sym_GT] = ACTIONS(1415),
    [anon_sym_AMP_GT] = ACTIONS(1415),
    [anon_sym_readonly] = ACTIONS(1415),
    [anon_sym_unset] = ACTIONS(1415),
    [ts_builtin_sym_end] = ACTIONS(1419),
    [anon_sym_DQUOTE] = ACTIONS(1417),
    [anon_sym_GT_AMP] = ACTIONS(1417),
    [anon_sym_BQUOTE] = ACTIONS(1417),
    [anon_sym_GT_LPAREN] = ACTIONS(1417),
    [anon_sym_for] = ACTIONS(1415),
    [anon_sym_while] = ACTIONS(1415),
    [anon_sym_LBRACK] = ACTIONS(1415),
    [sym_ansii_c_string] = ACTIONS(1417),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1417),
  },
  [244] = {
    [ts_builtin_sym_end] = ACTIONS(1419),
    [anon_sym_AMP] = ACTIONS(1421),
    [anon_sym_LF] = ACTIONS(1423),
    [anon_sym_SEMI] = ACTIONS(1421),
    [anon_sym_SEMI_SEMI] = ACTIONS(1421),
    [sym_comment] = ACTIONS(3),
  },
  [245] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1425),
    [anon_sym_AMP_GT_GT] = ACTIONS(1425),
    [anon_sym_LF] = ACTIONS(1427),
    [anon_sym_SEMI] = ACTIONS(1425),
    [anon_sym_LT_LT] = ACTIONS(1425),
    [anon_sym_AMP] = ACTIONS(1425),
    [anon_sym_GT] = ACTIONS(1425),
    [sym_file_descriptor] = ACTIONS(1427),
    [anon_sym_AMP_GT] = ACTIONS(1425),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1425),
    [ts_builtin_sym_end] = ACTIONS(1427),
    [anon_sym_LT_LT_LT] = ACTIONS(1425),
    [anon_sym_PIPE] = ACTIONS(1425),
    [anon_sym_GT_AMP] = ACTIONS(1425),
    [anon_sym_LT] = ACTIONS(1425),
    [anon_sym_LT_AMP] = ACTIONS(1425),
    [anon_sym_GT_GT] = ACTIONS(1425),
    [anon_sym_AMP_AMP] = ACTIONS(1425),
    [anon_sym_SEMI_SEMI] = ACTIONS(1425),
    [anon_sym_PIPE_AMP] = ACTIONS(1425),
  },
  [246] = {
    [anon_sym_LPAREN] = ACTIONS(1415),
    [sym_word] = ACTIONS(1415),
    [anon_sym_AMP_GT_GT] = ACTIONS(1417),
    [anon_sym_local] = ACTIONS(1415),
    [anon_sym_typeset] = ACTIONS(1415),
    [anon_sym_unsetenv] = ACTIONS(1415),
    [anon_sym_DOLLAR] = ACTIONS(1415),
    [anon_sym_LT_LPAREN] = ACTIONS(1417),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(1415),
    [anon_sym_LBRACE] = ACTIONS(1417),
    [anon_sym_LT] = ACTIONS(1415),
    [anon_sym_LT_AMP] = ACTIONS(1417),
    [anon_sym_GT_GT] = ACTIONS(1417),
    [anon_sym_export] = ACTIONS(1415),
    [sym__special_character] = ACTIONS(1415),
    [anon_sym_if] = ACTIONS(1415),
    [anon_sym_case] = ACTIONS(1415),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1417),
    [sym_raw_string] = ACTIONS(1417),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1417),
    [anon_sym_BANG] = ACTIONS(1415),
    [anon_sym_declare] = ACTIONS(1415),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1417),
    [sym_file_descriptor] = ACTIONS(1417),
    [anon_sym_RBRACE] = ACTIONS(1417),
    [anon_sym_GT] = ACTIONS(1415),
    [sym_variable_name] = ACTIONS(1417),
    [anon_sym_AMP_GT] = ACTIONS(1415),
    [anon_sym_readonly] = ACTIONS(1415),
    [anon_sym_unset] = ACTIONS(1415),
    [anon_sym_DQUOTE] = ACTIONS(1417),
    [anon_sym_GT_AMP] = ACTIONS(1417),
    [anon_sym_BQUOTE] = ACTIONS(1417),
    [anon_sym_GT_LPAREN] = ACTIONS(1417),
    [anon_sym_for] = ACTIONS(1415),
    [anon_sym_while] = ACTIONS(1415),
    [anon_sym_LBRACK] = ACTIONS(1415),
    [sym_ansii_c_string] = ACTIONS(1417),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1417),
  },
  [247] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(194),
    [sym_function_definition] = STATE(194),
    [sym_negated_command] = STATE(194),
    [sym_test_command] = STATE(194),
    [sym_variable_assignment] = STATE(195),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(194),
    [sym_for_statement] = STATE(194),
    [sym_compound_statement] = STATE(194),
    [sym_subshell] = STATE(194),
    [sym_declaration_command] = STATE(194),
    [sym_unset_command] = STATE(194),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [aux_sym__statements2] = STATE(255),
    [sym_c_style_for_statement] = STATE(194),
    [sym_while_statement] = STATE(194),
    [sym_case_statement] = STATE(194),
    [sym_pipeline] = STATE(194),
    [sym_list] = STATE(194),
    [sym_command] = STATE(194),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_fi] = ACTIONS(1429),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [248] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_then] = ACTIONS(1431),
  },
  [249] = {
    [sym_heredoc_body] = STATE(295),
    [sym_word] = ACTIONS(1433),
    [anon_sym_AMP_GT_GT] = ACTIONS(1435),
    [anon_sym_typeset] = ACTIONS(1433),
    [anon_sym_DOLLAR] = ACTIONS(1433),
    [anon_sym_LT_LPAREN] = ACTIONS(1435),
    [anon_sym_done] = ACTIONS(1433),
    [sym_comment] = ACTIONS(19),
    [sym__simple_heredoc_body] = ACTIONS(870),
    [anon_sym_LT_AMP] = ACTIONS(1435),
    [anon_sym_export] = ACTIONS(1433),
    [sym__special_character] = ACTIONS(1433),
    [anon_sym_if] = ACTIONS(1433),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1435),
    [sym_raw_string] = ACTIONS(1435),
    [anon_sym_declare] = ACTIONS(1433),
    [sym_variable_name] = ACTIONS(1435),
    [sym__heredoc_body_beginning] = ACTIONS(872),
    [anon_sym_readonly] = ACTIONS(1433),
    [anon_sym_unset] = ACTIONS(1433),
    [anon_sym_DQUOTE] = ACTIONS(1435),
    [anon_sym_GT_AMP] = ACTIONS(1435),
    [anon_sym_elif] = ACTIONS(1433),
    [sym_ansii_c_string] = ACTIONS(1435),
    [anon_sym_while] = ACTIONS(1433),
    [anon_sym_LPAREN] = ACTIONS(1433),
    [anon_sym_local] = ACTIONS(1433),
    [anon_sym_unsetenv] = ACTIONS(1433),
    [anon_sym_fi] = ACTIONS(1433),
    [anon_sym_else] = ACTIONS(1433),
    [anon_sym_function] = ACTIONS(1433),
    [anon_sym_LBRACE] = ACTIONS(1435),
    [anon_sym_LT] = ACTIONS(1433),
    [anon_sym_GT_GT] = ACTIONS(1435),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1435),
    [anon_sym_case] = ACTIONS(1433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1435),
    [anon_sym_BANG] = ACTIONS(1433),
    [sym_file_descriptor] = ACTIONS(1435),
    [anon_sym_GT] = ACTIONS(1433),
    [anon_sym_AMP_GT] = ACTIONS(1433),
    [anon_sym_BQUOTE] = ACTIONS(1435),
    [anon_sym_GT_LPAREN] = ACTIONS(1435),
    [anon_sym_for] = ACTIONS(1433),
    [anon_sym_LBRACK] = ACTIONS(1433),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1435),
  },
  [250] = {
    [sym_word] = ACTIONS(1433),
    [anon_sym_AMP_GT_GT] = ACTIONS(1435),
    [anon_sym_typeset] = ACTIONS(1433),
    [anon_sym_DOLLAR] = ACTIONS(1433),
    [anon_sym_LT_LPAREN] = ACTIONS(1435),
    [anon_sym_done] = ACTIONS(1433),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT_AMP] = ACTIONS(1435),
    [anon_sym_export] = ACTIONS(1433),
    [sym__special_character] = ACTIONS(1433),
    [anon_sym_if] = ACTIONS(1433),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1435),
    [sym_raw_string] = ACTIONS(1435),
    [anon_sym_declare] = ACTIONS(1433),
    [sym_variable_name] = ACTIONS(1435),
    [anon_sym_readonly] = ACTIONS(1433),
    [anon_sym_unset] = ACTIONS(1433),
    [anon_sym_DQUOTE] = ACTIONS(1435),
    [anon_sym_GT_AMP] = ACTIONS(1435),
    [anon_sym_elif] = ACTIONS(1433),
    [sym_ansii_c_string] = ACTIONS(1435),
    [anon_sym_while] = ACTIONS(1433),
    [anon_sym_LPAREN] = ACTIONS(1433),
    [anon_sym_local] = ACTIONS(1433),
    [anon_sym_unsetenv] = ACTIONS(1433),
    [anon_sym_fi] = ACTIONS(1433),
    [anon_sym_else] = ACTIONS(1433),
    [anon_sym_function] = ACTIONS(1433),
    [anon_sym_LBRACE] = ACTIONS(1435),
    [anon_sym_LT] = ACTIONS(1433),
    [anon_sym_GT_GT] = ACTIONS(1435),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1435),
    [anon_sym_case] = ACTIONS(1433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1435),
    [anon_sym_BANG] = ACTIONS(1433),
    [sym_file_descriptor] = ACTIONS(1435),
    [anon_sym_GT] = ACTIONS(1433),
    [anon_sym_AMP_GT] = ACTIONS(1433),
    [anon_sym_BQUOTE] = ACTIONS(1435),
    [anon_sym_GT_LPAREN] = ACTIONS(1435),
    [anon_sym_for] = ACTIONS(1433),
    [anon_sym_LBRACK] = ACTIONS(1433),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1435),
  },
  [251] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1437),
    [anon_sym_AMP_GT_GT] = ACTIONS(1437),
    [anon_sym_LF] = ACTIONS(1439),
    [anon_sym_SEMI] = ACTIONS(1437),
    [anon_sym_LT_LT] = ACTIONS(1437),
    [anon_sym_AMP] = ACTIONS(1437),
    [anon_sym_GT] = ACTIONS(1437),
    [sym_file_descriptor] = ACTIONS(1439),
    [anon_sym_AMP_GT] = ACTIONS(1437),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1437),
    [ts_builtin_sym_end] = ACTIONS(1439),
    [anon_sym_LT_LT_LT] = ACTIONS(1437),
    [anon_sym_PIPE] = ACTIONS(1437),
    [anon_sym_GT_AMP] = ACTIONS(1437),
    [anon_sym_LT] = ACTIONS(1437),
    [anon_sym_LT_AMP] = ACTIONS(1437),
    [anon_sym_GT_GT] = ACTIONS(1437),
    [anon_sym_AMP_AMP] = ACTIONS(1437),
    [anon_sym_SEMI_SEMI] = ACTIONS(1437),
    [anon_sym_PIPE_AMP] = ACTIONS(1437),
  },
  [252] = {
    [aux_sym_if_statement_repeat1] = STATE(252),
    [sym_elif_clause] = STATE(252),
    [anon_sym_elif] = ACTIONS(1441),
    [anon_sym_fi] = ACTIONS(1444),
    [anon_sym_else] = ACTIONS(1444),
    [sym_comment] = ACTIONS(19),
  },
  [253] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_fi] = ACTIONS(1446),
  },
  [254] = {
    [aux_sym_if_statement_repeat1] = STATE(252),
    [sym_elif_clause] = STATE(252),
    [sym_else_clause] = STATE(297),
    [anon_sym_elif] = ACTIONS(1222),
    [anon_sym_fi] = ACTIONS(1446),
    [anon_sym_else] = ACTIONS(1224),
    [sym_comment] = ACTIONS(19),
  },
  [255] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(194),
    [sym_function_definition] = STATE(194),
    [sym_negated_command] = STATE(194),
    [sym_test_command] = STATE(194),
    [sym_variable_assignment] = STATE(195),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(194),
    [sym_for_statement] = STATE(194),
    [sym_compound_statement] = STATE(194),
    [sym_subshell] = STATE(194),
    [sym_declaration_command] = STATE(194),
    [sym_unset_command] = STATE(194),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [aux_sym__statements2] = STATE(255),
    [sym_c_style_for_statement] = STATE(194),
    [sym_while_statement] = STATE(194),
    [sym_case_statement] = STATE(194),
    [sym_pipeline] = STATE(194),
    [sym_list] = STATE(194),
    [sym_command] = STATE(194),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(1448),
    [anon_sym_AMP_GT_GT] = ACTIONS(1451),
    [anon_sym_typeset] = ACTIONS(1454),
    [anon_sym_DOLLAR] = ACTIONS(1457),
    [anon_sym_LT_LPAREN] = ACTIONS(1460),
    [anon_sym_done] = ACTIONS(1433),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT_AMP] = ACTIONS(1451),
    [anon_sym_export] = ACTIONS(1454),
    [sym__special_character] = ACTIONS(1463),
    [anon_sym_if] = ACTIONS(1466),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1469),
    [sym_raw_string] = ACTIONS(1472),
    [anon_sym_declare] = ACTIONS(1454),
    [sym_variable_name] = ACTIONS(1475),
    [anon_sym_readonly] = ACTIONS(1454),
    [anon_sym_unset] = ACTIONS(1478),
    [anon_sym_DQUOTE] = ACTIONS(1481),
    [anon_sym_GT_AMP] = ACTIONS(1451),
    [anon_sym_elif] = ACTIONS(1433),
    [sym_ansii_c_string] = ACTIONS(1472),
    [anon_sym_while] = ACTIONS(1484),
    [anon_sym_LPAREN] = ACTIONS(1487),
    [anon_sym_local] = ACTIONS(1454),
    [anon_sym_unsetenv] = ACTIONS(1478),
    [anon_sym_fi] = ACTIONS(1433),
    [anon_sym_else] = ACTIONS(1433),
    [anon_sym_function] = ACTIONS(1490),
    [anon_sym_LBRACE] = ACTIONS(1493),
    [anon_sym_LT] = ACTIONS(1496),
    [anon_sym_GT_GT] = ACTIONS(1451),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1499),
    [anon_sym_case] = ACTIONS(1502),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1505),
    [anon_sym_BANG] = ACTIONS(1508),
    [sym_file_descriptor] = ACTIONS(1511),
    [anon_sym_GT] = ACTIONS(1496),
    [anon_sym_AMP_GT] = ACTIONS(1496),
    [anon_sym_BQUOTE] = ACTIONS(1514),
    [anon_sym_GT_LPAREN] = ACTIONS(1460),
    [anon_sym_for] = ACTIONS(1517),
    [anon_sym_LBRACK] = ACTIONS(1520),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1523),
  },
  [256] = {
    [sym_command_substitution] = STATE(257),
    [aux_sym__literal_repeat1] = STATE(259),
    [sym_case_item] = STATE(300),
    [sym_string] = STATE(257),
    [sym_process_substitution] = STATE(257),
    [sym_last_case_item] = STATE(299),
    [sym_simple_expansion] = STATE(257),
    [sym_string_expansion] = STATE(257),
    [aux_sym_case_statement_repeat1] = STATE(300),
    [sym_concatenation] = STATE(262),
    [sym_expansion] = STATE(257),
    [sym_word] = ACTIONS(1232),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(1234),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_esac] = ACTIONS(1526),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(1234),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym__special_character] = ACTIONS(231),
    [sym_comment] = ACTIONS(19),
  },
  [257] = {
    [aux_sym_concatenation_repeat1] = STATE(772),
    [aux_sym_case_item_repeat1] = STATE(303),
    [anon_sym_RPAREN] = ACTIONS(1528),
    [sym__concat] = ACTIONS(475),
    [anon_sym_PIPE] = ACTIONS(1530),
    [sym_comment] = ACTIONS(19),
  },
  [258] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1532),
    [anon_sym_AMP_GT_GT] = ACTIONS(1532),
    [anon_sym_LF] = ACTIONS(1534),
    [anon_sym_SEMI] = ACTIONS(1532),
    [anon_sym_LT_LT] = ACTIONS(1532),
    [anon_sym_AMP] = ACTIONS(1532),
    [anon_sym_GT] = ACTIONS(1532),
    [sym_file_descriptor] = ACTIONS(1534),
    [anon_sym_AMP_GT] = ACTIONS(1532),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1532),
    [ts_builtin_sym_end] = ACTIONS(1534),
    [anon_sym_LT_LT_LT] = ACTIONS(1532),
    [anon_sym_PIPE] = ACTIONS(1532),
    [anon_sym_GT_AMP] = ACTIONS(1532),
    [anon_sym_LT] = ACTIONS(1532),
    [anon_sym_LT_AMP] = ACTIONS(1532),
    [anon_sym_GT_GT] = ACTIONS(1532),
    [anon_sym_AMP_AMP] = ACTIONS(1532),
    [anon_sym_SEMI_SEMI] = ACTIONS(1532),
    [anon_sym_PIPE_AMP] = ACTIONS(1532),
  },
  [259] = {
    [aux_sym__literal_repeat1] = STATE(778),
    [aux_sym_case_item_repeat1] = STATE(305),
    [anon_sym_RPAREN] = ACTIONS(1536),
    [anon_sym_PIPE] = ACTIONS(1530),
    [sym__special_character] = ACTIONS(1538),
    [sym_comment] = ACTIONS(19),
  },
  [260] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_esac] = ACTIONS(1540),
  },
  [261] = {
    [sym_command_substitution] = STATE(257),
    [aux_sym__literal_repeat1] = STATE(259),
    [sym_case_item] = STATE(306),
    [sym_string] = STATE(257),
    [sym_process_substitution] = STATE(257),
    [sym_last_case_item] = STATE(299),
    [sym_simple_expansion] = STATE(257),
    [sym_string_expansion] = STATE(257),
    [aux_sym_case_statement_repeat1] = STATE(306),
    [sym_concatenation] = STATE(262),
    [sym_expansion] = STATE(257),
    [sym_word] = ACTIONS(1234),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(1234),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(1234),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym__special_character] = ACTIONS(231),
    [sym_comment] = ACTIONS(19),
  },
  [262] = {
    [aux_sym_case_item_repeat1] = STATE(303),
    [anon_sym_PIPE] = ACTIONS(1530),
    [anon_sym_RPAREN] = ACTIONS(1528),
    [sym_comment] = ACTIONS(19),
  },
  [263] = {
    [sym_command_substitution] = STATE(257),
    [aux_sym__literal_repeat1] = STATE(259),
    [sym_case_item] = STATE(309),
    [sym_string] = STATE(257),
    [sym_process_substitution] = STATE(257),
    [sym_last_case_item] = STATE(308),
    [sym_simple_expansion] = STATE(257),
    [sym_string_expansion] = STATE(257),
    [aux_sym_case_statement_repeat1] = STATE(309),
    [sym_concatenation] = STATE(262),
    [sym_expansion] = STATE(257),
    [sym_word] = ACTIONS(1232),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(1234),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_esac] = ACTIONS(1542),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(1234),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym__special_character] = ACTIONS(231),
    [sym_comment] = ACTIONS(19),
  },
  [264] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1544),
    [anon_sym_AMP_GT_GT] = ACTIONS(1544),
    [anon_sym_LF] = ACTIONS(1546),
    [anon_sym_SEMI] = ACTIONS(1544),
    [anon_sym_LT_LT] = ACTIONS(1544),
    [anon_sym_AMP] = ACTIONS(1544),
    [anon_sym_GT] = ACTIONS(1544),
    [sym_file_descriptor] = ACTIONS(1546),
    [anon_sym_AMP_GT] = ACTIONS(1544),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1544),
    [ts_builtin_sym_end] = ACTIONS(1546),
    [anon_sym_LT_LT_LT] = ACTIONS(1544),
    [anon_sym_PIPE] = ACTIONS(1544),
    [anon_sym_GT_AMP] = ACTIONS(1544),
    [anon_sym_LT] = ACTIONS(1544),
    [anon_sym_LT_AMP] = ACTIONS(1544),
    [anon_sym_GT_GT] = ACTIONS(1544),
    [anon_sym_AMP_AMP] = ACTIONS(1544),
    [anon_sym_SEMI_SEMI] = ACTIONS(1544),
    [anon_sym_PIPE_AMP] = ACTIONS(1544),
  },
  [265] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_esac] = ACTIONS(1548),
  },
  [266] = {
    [sym_command_substitution] = STATE(257),
    [aux_sym__literal_repeat1] = STATE(259),
    [sym_case_item] = STATE(306),
    [sym_string] = STATE(257),
    [sym_process_substitution] = STATE(257),
    [sym_last_case_item] = STATE(308),
    [sym_simple_expansion] = STATE(257),
    [sym_string_expansion] = STATE(257),
    [aux_sym_case_statement_repeat1] = STATE(306),
    [sym_concatenation] = STATE(262),
    [sym_expansion] = STATE(257),
    [sym_word] = ACTIONS(1234),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(1234),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(1234),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym__special_character] = ACTIONS(231),
    [sym_comment] = ACTIONS(19),
  },
  [267] = {
    [sym_word] = ACTIONS(1550),
    [anon_sym_AMP_GT_GT] = ACTIONS(1550),
    [anon_sym_DOLLAR] = ACTIONS(1550),
    [anon_sym_LT_LT] = ACTIONS(1550),
    [anon_sym_LT_LPAREN] = ACTIONS(1550),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1550),
    [sym__concat] = ACTIONS(1552),
    [anon_sym_PIPE] = ACTIONS(1550),
    [anon_sym_LT] = ACTIONS(1550),
    [anon_sym_LT_AMP] = ACTIONS(1550),
    [anon_sym_GT_GT] = ACTIONS(1550),
    [anon_sym_EQ_TILDE] = ACTIONS(1550),
    [sym__special_character] = ACTIONS(1550),
    [anon_sym_LT_LT_DASH] = ACTIONS(1550),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1550),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1550),
    [anon_sym_LF] = ACTIONS(1552),
    [anon_sym_SEMI] = ACTIONS(1550),
    [sym_raw_string] = ACTIONS(1550),
    [sym_file_descriptor] = ACTIONS(1552),
    [anon_sym_AMP] = ACTIONS(1550),
    [anon_sym_GT] = ACTIONS(1550),
    [anon_sym_AMP_GT] = ACTIONS(1550),
    [anon_sym_EQ_EQ] = ACTIONS(1550),
    [anon_sym_DQUOTE] = ACTIONS(1550),
    [anon_sym_LT_LT_LT] = ACTIONS(1550),
    [anon_sym_GT_AMP] = ACTIONS(1550),
    [ts_builtin_sym_end] = ACTIONS(1552),
    [anon_sym_BQUOTE] = ACTIONS(1550),
    [anon_sym_GT_LPAREN] = ACTIONS(1550),
    [sym_ansii_c_string] = ACTIONS(1550),
    [anon_sym_AMP_AMP] = ACTIONS(1550),
    [anon_sym_SEMI_SEMI] = ACTIONS(1550),
    [anon_sym_PIPE_AMP] = ACTIONS(1550),
  },
  [268] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(938),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1554),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(938),
    [anon_sym_PERCENT] = ACTIONS(938),
    [anon_sym_POUND] = ACTIONS(940),
    [anon_sym_COLON_DASH] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(938),
    [sym__special_character] = ACTIONS(517),
  },
  [269] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(311),
    [sym_concatenation] = STATE(311),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(1556),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1554),
    [anon_sym_DASH] = ACTIONS(1556),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(1556),
    [anon_sym_PERCENT] = ACTIONS(1556),
    [anon_sym_POUND] = ACTIONS(1558),
    [anon_sym_COLON_DASH] = ACTIONS(1556),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(1556),
    [sym__special_character] = ACTIONS(517),
  },
  [270] = {
    [aux_sym_concatenation_repeat1] = STATE(1097),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(1554),
    [sym__concat] = ACTIONS(1313),
  },
  [271] = {
    [aux_sym__literal_repeat1] = STATE(1135),
    [sym__special_character] = ACTIONS(1315),
    [anon_sym_RBRACE] = ACTIONS(1560),
    [sym_comment] = ACTIONS(19),
  },
  [272] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(1554),
  },
  [273] = {
    [sym_word] = ACTIONS(1562),
    [anon_sym_AMP_GT_GT] = ACTIONS(1562),
    [anon_sym_DOLLAR] = ACTIONS(1562),
    [anon_sym_LT_LT] = ACTIONS(1562),
    [anon_sym_LT_LPAREN] = ACTIONS(1562),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1562),
    [sym__concat] = ACTIONS(1564),
    [anon_sym_PIPE] = ACTIONS(1562),
    [anon_sym_LT] = ACTIONS(1562),
    [anon_sym_LT_AMP] = ACTIONS(1562),
    [anon_sym_GT_GT] = ACTIONS(1562),
    [anon_sym_EQ_TILDE] = ACTIONS(1562),
    [sym__special_character] = ACTIONS(1562),
    [anon_sym_LT_LT_DASH] = ACTIONS(1562),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1562),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1562),
    [anon_sym_LF] = ACTIONS(1564),
    [anon_sym_SEMI] = ACTIONS(1562),
    [sym_raw_string] = ACTIONS(1562),
    [sym_file_descriptor] = ACTIONS(1564),
    [anon_sym_AMP] = ACTIONS(1562),
    [anon_sym_GT] = ACTIONS(1562),
    [anon_sym_AMP_GT] = ACTIONS(1562),
    [anon_sym_EQ_EQ] = ACTIONS(1562),
    [anon_sym_DQUOTE] = ACTIONS(1562),
    [anon_sym_LT_LT_LT] = ACTIONS(1562),
    [anon_sym_GT_AMP] = ACTIONS(1562),
    [ts_builtin_sym_end] = ACTIONS(1564),
    [anon_sym_BQUOTE] = ACTIONS(1562),
    [anon_sym_GT_LPAREN] = ACTIONS(1562),
    [sym_ansii_c_string] = ACTIONS(1562),
    [anon_sym_AMP_AMP] = ACTIONS(1562),
    [anon_sym_SEMI_SEMI] = ACTIONS(1562),
    [anon_sym_PIPE_AMP] = ACTIONS(1562),
  },
  [274] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(314),
    [sym_concatenation] = STATE(314),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(1566),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1568),
    [anon_sym_DASH] = ACTIONS(1566),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(1566),
    [anon_sym_PERCENT] = ACTIONS(1566),
    [anon_sym_POUND] = ACTIONS(1570),
    [anon_sym_COLON_DASH] = ACTIONS(1566),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(1566),
    [sym__special_character] = ACTIONS(517),
  },
  [275] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(938),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1568),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(938),
    [anon_sym_PERCENT] = ACTIONS(938),
    [anon_sym_POUND] = ACTIONS(940),
    [anon_sym_COLON_DASH] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(938),
    [sym__special_character] = ACTIONS(517),
  },
  [276] = {
    [sym_word] = ACTIONS(1572),
    [anon_sym_AMP_GT_GT] = ACTIONS(1572),
    [anon_sym_DOLLAR] = ACTIONS(1572),
    [anon_sym_LT_LT] = ACTIONS(1572),
    [anon_sym_LT_LPAREN] = ACTIONS(1572),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1572),
    [sym__concat] = ACTIONS(1574),
    [anon_sym_PIPE] = ACTIONS(1572),
    [anon_sym_LT] = ACTIONS(1572),
    [anon_sym_LT_AMP] = ACTIONS(1572),
    [anon_sym_GT_GT] = ACTIONS(1572),
    [anon_sym_EQ_TILDE] = ACTIONS(1572),
    [sym__special_character] = ACTIONS(1572),
    [anon_sym_LT_LT_DASH] = ACTIONS(1572),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1572),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1572),
    [anon_sym_LF] = ACTIONS(1574),
    [anon_sym_SEMI] = ACTIONS(1572),
    [sym_raw_string] = ACTIONS(1572),
    [sym_file_descriptor] = ACTIONS(1574),
    [anon_sym_AMP] = ACTIONS(1572),
    [anon_sym_GT] = ACTIONS(1572),
    [anon_sym_AMP_GT] = ACTIONS(1572),
    [anon_sym_EQ_EQ] = ACTIONS(1572),
    [anon_sym_DQUOTE] = ACTIONS(1572),
    [anon_sym_LT_LT_LT] = ACTIONS(1572),
    [anon_sym_GT_AMP] = ACTIONS(1572),
    [ts_builtin_sym_end] = ACTIONS(1574),
    [anon_sym_BQUOTE] = ACTIONS(1572),
    [anon_sym_GT_LPAREN] = ACTIONS(1572),
    [sym_ansii_c_string] = ACTIONS(1572),
    [anon_sym_AMP_AMP] = ACTIONS(1572),
    [anon_sym_SEMI_SEMI] = ACTIONS(1572),
    [anon_sym_PIPE_AMP] = ACTIONS(1572),
  },
  [277] = {
    [sym_word] = ACTIONS(1576),
    [anon_sym_AMP_GT_GT] = ACTIONS(1576),
    [anon_sym_DOLLAR] = ACTIONS(1576),
    [anon_sym_LT_LT] = ACTIONS(1576),
    [anon_sym_LT_LPAREN] = ACTIONS(1576),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1576),
    [sym__concat] = ACTIONS(1578),
    [anon_sym_PIPE] = ACTIONS(1576),
    [anon_sym_LT] = ACTIONS(1576),
    [anon_sym_LT_AMP] = ACTIONS(1576),
    [anon_sym_GT_GT] = ACTIONS(1576),
    [anon_sym_EQ_TILDE] = ACTIONS(1576),
    [sym__special_character] = ACTIONS(1576),
    [anon_sym_LT_LT_DASH] = ACTIONS(1576),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1576),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1576),
    [anon_sym_LF] = ACTIONS(1578),
    [anon_sym_SEMI] = ACTIONS(1576),
    [sym_raw_string] = ACTIONS(1576),
    [sym_file_descriptor] = ACTIONS(1578),
    [anon_sym_AMP] = ACTIONS(1576),
    [anon_sym_GT] = ACTIONS(1576),
    [anon_sym_AMP_GT] = ACTIONS(1576),
    [anon_sym_EQ_EQ] = ACTIONS(1576),
    [anon_sym_DQUOTE] = ACTIONS(1576),
    [anon_sym_LT_LT_LT] = ACTIONS(1576),
    [anon_sym_GT_AMP] = ACTIONS(1576),
    [ts_builtin_sym_end] = ACTIONS(1578),
    [anon_sym_BQUOTE] = ACTIONS(1576),
    [anon_sym_GT_LPAREN] = ACTIONS(1576),
    [sym_ansii_c_string] = ACTIONS(1576),
    [anon_sym_AMP_AMP] = ACTIONS(1576),
    [anon_sym_SEMI_SEMI] = ACTIONS(1576),
    [anon_sym_PIPE_AMP] = ACTIONS(1576),
  },
  [278] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(938),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1580),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(938),
    [anon_sym_PERCENT] = ACTIONS(938),
    [anon_sym_POUND] = ACTIONS(940),
    [anon_sym_COLON_DASH] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(938),
    [sym__special_character] = ACTIONS(517),
  },
  [279] = {
    [sym_word] = ACTIONS(1582),
    [anon_sym_AMP_GT_GT] = ACTIONS(1582),
    [anon_sym_DOLLAR] = ACTIONS(1582),
    [anon_sym_LT_LT] = ACTIONS(1582),
    [anon_sym_LT_LPAREN] = ACTIONS(1582),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1582),
    [anon_sym_PIPE] = ACTIONS(1582),
    [anon_sym_LT] = ACTIONS(1582),
    [anon_sym_LT_AMP] = ACTIONS(1582),
    [anon_sym_GT_GT] = ACTIONS(1582),
    [sym__special_character] = ACTIONS(1582),
    [anon_sym_LT_LT_DASH] = ACTIONS(1582),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1582),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1582),
    [anon_sym_LF] = ACTIONS(1584),
    [anon_sym_SEMI] = ACTIONS(1582),
    [sym_raw_string] = ACTIONS(1582),
    [sym_variable_name] = ACTIONS(1584),
    [sym_file_descriptor] = ACTIONS(1584),
    [anon_sym_AMP] = ACTIONS(1582),
    [anon_sym_GT] = ACTIONS(1582),
    [anon_sym_AMP_GT] = ACTIONS(1582),
    [anon_sym_DQUOTE] = ACTIONS(1582),
    [anon_sym_LT_LT_LT] = ACTIONS(1582),
    [anon_sym_GT_AMP] = ACTIONS(1582),
    [ts_builtin_sym_end] = ACTIONS(1584),
    [anon_sym_BQUOTE] = ACTIONS(1582),
    [anon_sym_GT_LPAREN] = ACTIONS(1582),
    [sym_ansii_c_string] = ACTIONS(1582),
    [anon_sym_AMP_AMP] = ACTIONS(1582),
    [anon_sym_SEMI_SEMI] = ACTIONS(1582),
    [anon_sym_PIPE_AMP] = ACTIONS(1582),
  },
  [280] = {
    [sym_command_substitution] = STATE(221),
    [aux_sym__literal_repeat1] = STATE(223),
    [sym_string] = STATE(221),
    [sym_process_substitution] = STATE(221),
    [aux_sym_for_statement_repeat1] = STATE(280),
    [sym_simple_expansion] = STATE(221),
    [sym_string_expansion] = STATE(221),
    [sym_concatenation] = STATE(280),
    [sym_expansion] = STATE(221),
    [sym_word] = ACTIONS(1586),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1589),
    [anon_sym_DQUOTE] = ACTIONS(1592),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1595),
    [sym_raw_string] = ACTIONS(1586),
    [anon_sym_BQUOTE] = ACTIONS(1598),
    [anon_sym_DOLLAR] = ACTIONS(1601),
    [anon_sym_RPAREN] = ACTIONS(1604),
    [sym_ansii_c_string] = ACTIONS(1586),
    [anon_sym_LT_LPAREN] = ACTIONS(1606),
    [anon_sym_GT_LPAREN] = ACTIONS(1606),
    [sym__special_character] = ACTIONS(1609),
    [sym_comment] = ACTIONS(19),
  },
  [281] = {
    [anon_sym_EQ] = ACTIONS(1612),
    [anon_sym_PLUS_EQ] = ACTIONS(1612),
    [sym_comment] = ACTIONS(19),
  },
  [282] = {
    [anon_sym_PLUS_EQ] = ACTIONS(1612),
    [sym__concat] = ACTIONS(1614),
    [anon_sym_EQ] = ACTIONS(1612),
    [sym_comment] = ACTIONS(19),
  },
  [283] = {
    [anon_sym_EQ] = ACTIONS(1616),
    [anon_sym_PLUS_EQ] = ACTIONS(1616),
    [sym_comment] = ACTIONS(19),
  },
  [284] = {
    [anon_sym_PLUS_EQ] = ACTIONS(1616),
    [sym__concat] = ACTIONS(1618),
    [anon_sym_EQ] = ACTIONS(1616),
    [sym_comment] = ACTIONS(19),
  },
  [285] = {
    [sym_do_group] = STATE(318),
    [sym_comment] = ACTIONS(19),
    [anon_sym_do] = ACTIONS(619),
  },
  [286] = {
    [sym_do_group] = STATE(320),
    [sym_compound_statement] = STATE(320),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(1620),
    [anon_sym_do] = ACTIONS(619),
  },
  [287] = {
    [anon_sym_BANG_EQ] = ACTIONS(483),
    [anon_sym_PLUS_EQ] = ACTIONS(483),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_EQ] = ACTIONS(487),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1622),
    [anon_sym_PIPE_PIPE] = ACTIONS(483),
    [anon_sym_GT_EQ] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_LT] = ACTIONS(487),
    [sym_test_operator] = ACTIONS(483),
    [anon_sym_EQ_TILDE] = ACTIONS(489),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(483),
    [anon_sym_AMP_AMP] = ACTIONS(483),
    [anon_sym_DASH_EQ] = ACTIONS(483),
  },
  [288] = {
    [sym_command_substitution] = STATE(65),
    [sym_unary_expression] = STATE(322),
    [sym_postfix_expression] = STATE(322),
    [sym_string] = STATE(65),
    [aux_sym__literal_repeat1] = STATE(68),
    [sym_process_substitution] = STATE(65),
    [sym_parenthesized_expression] = STATE(322),
    [sym_simple_expansion] = STATE(65),
    [sym_string_expansion] = STATE(65),
    [sym__expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_concatenation] = STATE(322),
    [sym_expansion] = STATE(65),
    [sym_word] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_BANG] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1622),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [sym_test_operator] = ACTIONS(227),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [sym_ansii_c_string] = ACTIONS(217),
    [sym__special_character] = ACTIONS(231),
  },
  [289] = {
    [anon_sym_BANG_EQ] = ACTIONS(1079),
    [anon_sym_PLUS_EQ] = ACTIONS(1079),
    [anon_sym_LF] = ACTIONS(1624),
    [anon_sym_SEMI] = ACTIONS(1624),
    [anon_sym_PLUS_PLUS] = ACTIONS(1083),
    [anon_sym_DASH] = ACTIONS(1079),
    [anon_sym_GT] = ACTIONS(1079),
    [anon_sym_EQ] = ACTIONS(1079),
    [anon_sym_AMP] = ACTIONS(1624),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(1085),
    [anon_sym_PIPE_PIPE] = ACTIONS(1079),
    [anon_sym_GT_EQ] = ACTIONS(1079),
    [anon_sym_PLUS] = ACTIONS(1079),
    [anon_sym_LT] = ACTIONS(1079),
    [sym_test_operator] = ACTIONS(1079),
    [anon_sym_EQ_TILDE] = ACTIONS(1085),
    [anon_sym_DASH_DASH] = ACTIONS(1083),
    [anon_sym_LT_EQ] = ACTIONS(1079),
    [anon_sym_AMP_AMP] = ACTIONS(1079),
    [anon_sym_SEMI_SEMI] = ACTIONS(1624),
    [anon_sym_DASH_EQ] = ACTIONS(1079),
  },
  [290] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1626),
    [anon_sym_AMP_GT_GT] = ACTIONS(1626),
    [anon_sym_LF] = ACTIONS(1628),
    [anon_sym_SEMI] = ACTIONS(1626),
    [anon_sym_LT_LT] = ACTIONS(1626),
    [anon_sym_AMP] = ACTIONS(1626),
    [anon_sym_GT] = ACTIONS(1626),
    [sym_file_descriptor] = ACTIONS(1628),
    [anon_sym_AMP_GT] = ACTIONS(1626),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1626),
    [ts_builtin_sym_end] = ACTIONS(1628),
    [anon_sym_LT_LT_LT] = ACTIONS(1626),
    [anon_sym_PIPE] = ACTIONS(1626),
    [anon_sym_GT_AMP] = ACTIONS(1626),
    [anon_sym_LT] = ACTIONS(1626),
    [anon_sym_LT_AMP] = ACTIONS(1626),
    [anon_sym_GT_GT] = ACTIONS(1626),
    [anon_sym_AMP_AMP] = ACTIONS(1626),
    [anon_sym_SEMI_SEMI] = ACTIONS(1626),
    [anon_sym_PIPE_AMP] = ACTIONS(1626),
  },
  [291] = {
    [anon_sym_AMP] = ACTIONS(1630),
    [ts_builtin_sym_end] = ACTIONS(1632),
    [anon_sym_LF] = ACTIONS(1632),
    [anon_sym_SEMI] = ACTIONS(1630),
    [anon_sym_SEMI_SEMI] = ACTIONS(1630),
    [sym_comment] = ACTIONS(3),
  },
  [292] = {
    [sym_command_substitution] = STATE(292),
    [sym_simple_expansion] = STATE(292),
    [sym_expansion] = STATE(292),
    [aux_sym_heredoc_body_repeat1] = STATE(292),
    [anon_sym_DOLLAR] = ACTIONS(1634),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1637),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1640),
    [sym__heredoc_body_end] = ACTIONS(1643),
    [sym_comment] = ACTIONS(19),
    [anon_sym_BQUOTE] = ACTIONS(1645),
    [sym__heredoc_body_middle] = ACTIONS(1648),
  },
  [293] = {
    [anon_sym_LPAREN] = ACTIONS(1415),
    [sym_word] = ACTIONS(1415),
    [anon_sym_AMP_GT_GT] = ACTIONS(1417),
    [anon_sym_local] = ACTIONS(1415),
    [anon_sym_typeset] = ACTIONS(1415),
    [anon_sym_unsetenv] = ACTIONS(1415),
    [anon_sym_DOLLAR] = ACTIONS(1415),
    [anon_sym_LT_LPAREN] = ACTIONS(1417),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(1415),
    [anon_sym_LBRACE] = ACTIONS(1417),
    [anon_sym_LT] = ACTIONS(1415),
    [anon_sym_LT_AMP] = ACTIONS(1417),
    [anon_sym_GT_GT] = ACTIONS(1417),
    [anon_sym_export] = ACTIONS(1415),
    [sym__special_character] = ACTIONS(1415),
    [anon_sym_if] = ACTIONS(1415),
    [anon_sym_case] = ACTIONS(1415),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1417),
    [sym_raw_string] = ACTIONS(1417),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1417),
    [anon_sym_BANG] = ACTIONS(1415),
    [anon_sym_declare] = ACTIONS(1415),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1417),
    [sym_file_descriptor] = ACTIONS(1417),
    [sym_variable_name] = ACTIONS(1417),
    [anon_sym_GT] = ACTIONS(1415),
    [anon_sym_AMP_GT] = ACTIONS(1415),
    [anon_sym_readonly] = ACTIONS(1415),
    [anon_sym_unset] = ACTIONS(1415),
    [anon_sym_DQUOTE] = ACTIONS(1417),
    [ts_builtin_sym_end] = ACTIONS(1651),
    [anon_sym_GT_AMP] = ACTIONS(1417),
    [anon_sym_BQUOTE] = ACTIONS(1417),
    [anon_sym_GT_LPAREN] = ACTIONS(1417),
    [anon_sym_for] = ACTIONS(1415),
    [anon_sym_while] = ACTIONS(1415),
    [anon_sym_LBRACK] = ACTIONS(1415),
    [sym_ansii_c_string] = ACTIONS(1417),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1417),
  },
  [294] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(194),
    [sym_function_definition] = STATE(194),
    [sym_negated_command] = STATE(194),
    [sym_test_command] = STATE(194),
    [sym_variable_assignment] = STATE(195),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(194),
    [sym_for_statement] = STATE(194),
    [sym_compound_statement] = STATE(194),
    [sym_subshell] = STATE(194),
    [sym_declaration_command] = STATE(194),
    [sym_unset_command] = STATE(194),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [aux_sym__statements2] = STATE(324),
    [sym_c_style_for_statement] = STATE(194),
    [sym_while_statement] = STATE(194),
    [sym_case_statement] = STATE(194),
    [sym_pipeline] = STATE(194),
    [sym_list] = STATE(194),
    [sym_command] = STATE(194),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_fi] = ACTIONS(1653),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [anon_sym_else] = ACTIONS(1653),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_elif] = ACTIONS(1653),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [295] = {
    [anon_sym_LF] = ACTIONS(1655),
    [anon_sym_SEMI] = ACTIONS(1657),
    [anon_sym_AMP] = ACTIONS(1657),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI_SEMI] = ACTIONS(1657),
  },
  [296] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1659),
    [anon_sym_AMP_GT_GT] = ACTIONS(1659),
    [anon_sym_LF] = ACTIONS(1661),
    [anon_sym_SEMI] = ACTIONS(1659),
    [anon_sym_LT_LT] = ACTIONS(1659),
    [anon_sym_AMP] = ACTIONS(1659),
    [anon_sym_GT] = ACTIONS(1659),
    [sym_file_descriptor] = ACTIONS(1661),
    [anon_sym_AMP_GT] = ACTIONS(1659),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1659),
    [ts_builtin_sym_end] = ACTIONS(1661),
    [anon_sym_LT_LT_LT] = ACTIONS(1659),
    [anon_sym_PIPE] = ACTIONS(1659),
    [anon_sym_GT_AMP] = ACTIONS(1659),
    [anon_sym_LT] = ACTIONS(1659),
    [anon_sym_LT_AMP] = ACTIONS(1659),
    [anon_sym_GT_GT] = ACTIONS(1659),
    [anon_sym_AMP_AMP] = ACTIONS(1659),
    [anon_sym_SEMI_SEMI] = ACTIONS(1659),
    [anon_sym_PIPE_AMP] = ACTIONS(1659),
  },
  [297] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_fi] = ACTIONS(1663),
  },
  [298] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1665),
    [anon_sym_AMP_GT_GT] = ACTIONS(1665),
    [anon_sym_LF] = ACTIONS(1667),
    [anon_sym_SEMI] = ACTIONS(1665),
    [anon_sym_LT_LT] = ACTIONS(1665),
    [anon_sym_AMP] = ACTIONS(1665),
    [anon_sym_GT] = ACTIONS(1665),
    [sym_file_descriptor] = ACTIONS(1667),
    [anon_sym_AMP_GT] = ACTIONS(1665),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1665),
    [ts_builtin_sym_end] = ACTIONS(1667),
    [anon_sym_LT_LT_LT] = ACTIONS(1665),
    [anon_sym_PIPE] = ACTIONS(1665),
    [anon_sym_GT_AMP] = ACTIONS(1665),
    [anon_sym_LT] = ACTIONS(1665),
    [anon_sym_LT_AMP] = ACTIONS(1665),
    [anon_sym_GT_GT] = ACTIONS(1665),
    [anon_sym_AMP_AMP] = ACTIONS(1665),
    [anon_sym_SEMI_SEMI] = ACTIONS(1665),
    [anon_sym_PIPE_AMP] = ACTIONS(1665),
  },
  [299] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_esac] = ACTIONS(1669),
  },
  [300] = {
    [sym_command_substitution] = STATE(257),
    [aux_sym__literal_repeat1] = STATE(259),
    [sym_case_item] = STATE(306),
    [sym_string] = STATE(257),
    [sym_process_substitution] = STATE(257),
    [sym_last_case_item] = STATE(328),
    [sym_simple_expansion] = STATE(257),
    [sym_string_expansion] = STATE(257),
    [aux_sym_case_statement_repeat1] = STATE(306),
    [sym_concatenation] = STATE(262),
    [sym_expansion] = STATE(257),
    [sym_word] = ACTIONS(1234),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(1234),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(1234),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym__special_character] = ACTIONS(231),
    [sym_comment] = ACTIONS(19),
  },
  [301] = {
    [sym_command_substitution] = STATE(329),
    [aux_sym__literal_repeat1] = STATE(330),
    [sym_string] = STATE(329),
    [sym_process_substitution] = STATE(329),
    [sym_simple_expansion] = STATE(329),
    [sym_string_expansion] = STATE(329),
    [sym_concatenation] = STATE(331),
    [sym_expansion] = STATE(329),
    [sym_word] = ACTIONS(1671),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(1671),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(1671),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym__special_character] = ACTIONS(231),
    [sym_comment] = ACTIONS(19),
  },
  [302] = {
    [aux_sym__literal_repeat1] = STATE(539),
    [sym_if_statement] = STATE(540),
    [sym_function_definition] = STATE(540),
    [sym_negated_command] = STATE(540),
    [sym_test_command] = STATE(540),
    [sym_variable_assignment] = STATE(635),
    [sym_subscript] = STATE(2473),
    [sym_concatenation] = STATE(542),
    [sym_expansion] = STATE(537),
    [sym_command_substitution] = STATE(537),
    [aux_sym__statements_repeat1] = STATE(636),
    [sym_redirected_statement] = STATE(540),
    [sym_for_statement] = STATE(540),
    [sym_compound_statement] = STATE(540),
    [sym_subshell] = STATE(540),
    [sym_declaration_command] = STATE(540),
    [sym_unset_command] = STATE(540),
    [sym_file_redirect] = STATE(544),
    [sym_string] = STATE(537),
    [sym_process_substitution] = STATE(537),
    [aux_sym_command_repeat1] = STATE(544),
    [sym__statements] = STATE(333),
    [sym_c_style_for_statement] = STATE(540),
    [sym_while_statement] = STATE(540),
    [sym_case_statement] = STATE(540),
    [sym_pipeline] = STATE(540),
    [sym_list] = STATE(540),
    [sym_command] = STATE(540),
    [sym_command_name] = STATE(637),
    [sym_simple_expansion] = STATE(537),
    [sym_string_expansion] = STATE(537),
    [sym_word] = ACTIONS(1673),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(1675),
    [anon_sym_typeset] = ACTIONS(1675),
    [anon_sym_unsetenv] = ACTIONS(1677),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LPAREN] = ACTIONS(1681),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(1675),
    [sym__special_character] = ACTIONS(1683),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(1685),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1687),
    [anon_sym_BANG] = ACTIONS(1689),
    [anon_sym_declare] = ACTIONS(1675),
    [sym_variable_name] = ACTIONS(1691),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1693),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(1675),
    [anon_sym_unset] = ACTIONS(1677),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(1697),
    [anon_sym_esac] = ACTIONS(1699),
    [anon_sym_GT_LPAREN] = ACTIONS(1681),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(1685),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [anon_sym_SEMI_SEMI] = ACTIONS(1701),
  },
  [303] = {
    [aux_sym_case_item_repeat1] = STATE(335),
    [anon_sym_PIPE] = ACTIONS(1530),
    [anon_sym_RPAREN] = ACTIONS(1703),
    [sym_comment] = ACTIONS(19),
  },
  [304] = {
    [aux_sym__literal_repeat1] = STATE(539),
    [sym_if_statement] = STATE(540),
    [sym_function_definition] = STATE(540),
    [sym_negated_command] = STATE(540),
    [sym_test_command] = STATE(540),
    [sym_variable_assignment] = STATE(635),
    [sym_subscript] = STATE(2473),
    [sym_concatenation] = STATE(542),
    [sym_expansion] = STATE(537),
    [sym_command_substitution] = STATE(537),
    [aux_sym__statements_repeat1] = STATE(636),
    [sym_redirected_statement] = STATE(540),
    [sym_for_statement] = STATE(540),
    [sym_compound_statement] = STATE(540),
    [sym_subshell] = STATE(540),
    [sym_declaration_command] = STATE(540),
    [sym_unset_command] = STATE(540),
    [sym_file_redirect] = STATE(544),
    [sym_string] = STATE(537),
    [sym_process_substitution] = STATE(537),
    [aux_sym_command_repeat1] = STATE(544),
    [sym__statements] = STATE(337),
    [sym_c_style_for_statement] = STATE(540),
    [sym_while_statement] = STATE(540),
    [sym_case_statement] = STATE(540),
    [sym_pipeline] = STATE(540),
    [sym_list] = STATE(540),
    [sym_command] = STATE(540),
    [sym_command_name] = STATE(637),
    [sym_simple_expansion] = STATE(537),
    [sym_string_expansion] = STATE(537),
    [sym_word] = ACTIONS(1673),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(1675),
    [anon_sym_typeset] = ACTIONS(1675),
    [anon_sym_unsetenv] = ACTIONS(1677),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LPAREN] = ACTIONS(1681),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(1675),
    [sym__special_character] = ACTIONS(1683),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(1685),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1687),
    [anon_sym_BANG] = ACTIONS(1689),
    [anon_sym_declare] = ACTIONS(1675),
    [sym_variable_name] = ACTIONS(1691),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1693),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(1675),
    [anon_sym_unset] = ACTIONS(1677),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(1697),
    [anon_sym_esac] = ACTIONS(1705),
    [anon_sym_GT_LPAREN] = ACTIONS(1681),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(1685),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [anon_sym_SEMI_SEMI] = ACTIONS(1707),
  },
  [305] = {
    [aux_sym_case_item_repeat1] = STATE(335),
    [anon_sym_PIPE] = ACTIONS(1530),
    [anon_sym_RPAREN] = ACTIONS(1709),
    [sym_comment] = ACTIONS(19),
  },
  [306] = {
    [sym_command_substitution] = STATE(339),
    [aux_sym__literal_repeat1] = STATE(340),
    [sym_case_item] = STATE(306),
    [sym_string] = STATE(339),
    [sym_process_substitution] = STATE(339),
    [sym_simple_expansion] = STATE(339),
    [sym_string_expansion] = STATE(339),
    [aux_sym_case_statement_repeat1] = STATE(306),
    [sym_concatenation] = STATE(341),
    [sym_expansion] = STATE(339),
    [sym_word] = ACTIONS(1711),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1714),
    [anon_sym_DQUOTE] = ACTIONS(1717),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1720),
    [sym_raw_string] = ACTIONS(1711),
    [anon_sym_BQUOTE] = ACTIONS(1723),
    [anon_sym_DOLLAR] = ACTIONS(1726),
    [sym_ansii_c_string] = ACTIONS(1711),
    [anon_sym_GT_LPAREN] = ACTIONS(1729),
    [anon_sym_LT_LPAREN] = ACTIONS(1729),
    [sym__special_character] = ACTIONS(1732),
    [sym_comment] = ACTIONS(19),
  },
  [307] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1735),
    [anon_sym_AMP_GT_GT] = ACTIONS(1735),
    [anon_sym_LF] = ACTIONS(1737),
    [anon_sym_SEMI] = ACTIONS(1735),
    [anon_sym_LT_LT] = ACTIONS(1735),
    [anon_sym_AMP] = ACTIONS(1735),
    [anon_sym_GT] = ACTIONS(1735),
    [sym_file_descriptor] = ACTIONS(1737),
    [anon_sym_AMP_GT] = ACTIONS(1735),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1735),
    [ts_builtin_sym_end] = ACTIONS(1737),
    [anon_sym_LT_LT_LT] = ACTIONS(1735),
    [anon_sym_PIPE] = ACTIONS(1735),
    [anon_sym_GT_AMP] = ACTIONS(1735),
    [anon_sym_LT] = ACTIONS(1735),
    [anon_sym_LT_AMP] = ACTIONS(1735),
    [anon_sym_GT_GT] = ACTIONS(1735),
    [anon_sym_AMP_AMP] = ACTIONS(1735),
    [anon_sym_SEMI_SEMI] = ACTIONS(1735),
    [anon_sym_PIPE_AMP] = ACTIONS(1735),
  },
  [308] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_esac] = ACTIONS(1739),
  },
  [309] = {
    [sym_command_substitution] = STATE(257),
    [aux_sym__literal_repeat1] = STATE(259),
    [sym_case_item] = STATE(306),
    [sym_string] = STATE(257),
    [sym_process_substitution] = STATE(257),
    [sym_last_case_item] = STATE(343),
    [sym_simple_expansion] = STATE(257),
    [sym_string_expansion] = STATE(257),
    [aux_sym_case_statement_repeat1] = STATE(306),
    [sym_concatenation] = STATE(262),
    [sym_expansion] = STATE(257),
    [sym_word] = ACTIONS(1234),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(1234),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [sym_ansii_c_string] = ACTIONS(1234),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym__special_character] = ACTIONS(231),
    [sym_comment] = ACTIONS(19),
  },
  [310] = {
    [sym_word] = ACTIONS(1741),
    [anon_sym_AMP_GT_GT] = ACTIONS(1741),
    [anon_sym_DOLLAR] = ACTIONS(1741),
    [anon_sym_LT_LT] = ACTIONS(1741),
    [anon_sym_LT_LPAREN] = ACTIONS(1741),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1741),
    [sym__concat] = ACTIONS(1743),
    [anon_sym_PIPE] = ACTIONS(1741),
    [anon_sym_LT] = ACTIONS(1741),
    [anon_sym_LT_AMP] = ACTIONS(1741),
    [anon_sym_GT_GT] = ACTIONS(1741),
    [anon_sym_EQ_TILDE] = ACTIONS(1741),
    [sym__special_character] = ACTIONS(1741),
    [anon_sym_LT_LT_DASH] = ACTIONS(1741),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1741),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1741),
    [anon_sym_LF] = ACTIONS(1743),
    [anon_sym_SEMI] = ACTIONS(1741),
    [sym_raw_string] = ACTIONS(1741),
    [sym_file_descriptor] = ACTIONS(1743),
    [anon_sym_AMP] = ACTIONS(1741),
    [anon_sym_GT] = ACTIONS(1741),
    [anon_sym_AMP_GT] = ACTIONS(1741),
    [anon_sym_EQ_EQ] = ACTIONS(1741),
    [anon_sym_DQUOTE] = ACTIONS(1741),
    [anon_sym_LT_LT_LT] = ACTIONS(1741),
    [anon_sym_GT_AMP] = ACTIONS(1741),
    [ts_builtin_sym_end] = ACTIONS(1743),
    [anon_sym_BQUOTE] = ACTIONS(1741),
    [anon_sym_GT_LPAREN] = ACTIONS(1741),
    [sym_ansii_c_string] = ACTIONS(1741),
    [anon_sym_AMP_AMP] = ACTIONS(1741),
    [anon_sym_SEMI_SEMI] = ACTIONS(1741),
    [anon_sym_PIPE_AMP] = ACTIONS(1741),
  },
  [311] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(938),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1745),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(938),
    [anon_sym_PERCENT] = ACTIONS(938),
    [anon_sym_POUND] = ACTIONS(940),
    [anon_sym_COLON_DASH] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(938),
    [sym__special_character] = ACTIONS(517),
  },
  [312] = {
    [sym_word] = ACTIONS(1747),
    [anon_sym_AMP_GT_GT] = ACTIONS(1747),
    [anon_sym_DOLLAR] = ACTIONS(1747),
    [anon_sym_LT_LT] = ACTIONS(1747),
    [anon_sym_LT_LPAREN] = ACTIONS(1747),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1747),
    [sym__concat] = ACTIONS(1749),
    [anon_sym_PIPE] = ACTIONS(1747),
    [anon_sym_LT] = ACTIONS(1747),
    [anon_sym_LT_AMP] = ACTIONS(1747),
    [anon_sym_GT_GT] = ACTIONS(1747),
    [anon_sym_EQ_TILDE] = ACTIONS(1747),
    [sym__special_character] = ACTIONS(1747),
    [anon_sym_LT_LT_DASH] = ACTIONS(1747),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1747),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1747),
    [anon_sym_LF] = ACTIONS(1749),
    [anon_sym_SEMI] = ACTIONS(1747),
    [sym_raw_string] = ACTIONS(1747),
    [sym_file_descriptor] = ACTIONS(1749),
    [anon_sym_AMP] = ACTIONS(1747),
    [anon_sym_GT] = ACTIONS(1747),
    [anon_sym_AMP_GT] = ACTIONS(1747),
    [anon_sym_EQ_EQ] = ACTIONS(1747),
    [anon_sym_DQUOTE] = ACTIONS(1747),
    [anon_sym_LT_LT_LT] = ACTIONS(1747),
    [anon_sym_GT_AMP] = ACTIONS(1747),
    [ts_builtin_sym_end] = ACTIONS(1749),
    [anon_sym_BQUOTE] = ACTIONS(1747),
    [anon_sym_GT_LPAREN] = ACTIONS(1747),
    [sym_ansii_c_string] = ACTIONS(1747),
    [anon_sym_AMP_AMP] = ACTIONS(1747),
    [anon_sym_SEMI_SEMI] = ACTIONS(1747),
    [anon_sym_PIPE_AMP] = ACTIONS(1747),
  },
  [313] = {
    [sym_word] = ACTIONS(1751),
    [anon_sym_AMP_GT_GT] = ACTIONS(1751),
    [anon_sym_DOLLAR] = ACTIONS(1751),
    [anon_sym_LT_LT] = ACTIONS(1751),
    [anon_sym_LT_LPAREN] = ACTIONS(1751),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1751),
    [sym__concat] = ACTIONS(1753),
    [anon_sym_PIPE] = ACTIONS(1751),
    [anon_sym_LT] = ACTIONS(1751),
    [anon_sym_LT_AMP] = ACTIONS(1751),
    [anon_sym_GT_GT] = ACTIONS(1751),
    [anon_sym_EQ_TILDE] = ACTIONS(1751),
    [sym__special_character] = ACTIONS(1751),
    [anon_sym_LT_LT_DASH] = ACTIONS(1751),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1751),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1751),
    [anon_sym_LF] = ACTIONS(1753),
    [anon_sym_SEMI] = ACTIONS(1751),
    [sym_raw_string] = ACTIONS(1751),
    [sym_file_descriptor] = ACTIONS(1753),
    [anon_sym_AMP] = ACTIONS(1751),
    [anon_sym_GT] = ACTIONS(1751),
    [anon_sym_AMP_GT] = ACTIONS(1751),
    [anon_sym_EQ_EQ] = ACTIONS(1751),
    [anon_sym_DQUOTE] = ACTIONS(1751),
    [anon_sym_LT_LT_LT] = ACTIONS(1751),
    [anon_sym_GT_AMP] = ACTIONS(1751),
    [ts_builtin_sym_end] = ACTIONS(1753),
    [anon_sym_BQUOTE] = ACTIONS(1751),
    [anon_sym_GT_LPAREN] = ACTIONS(1751),
    [sym_ansii_c_string] = ACTIONS(1751),
    [anon_sym_AMP_AMP] = ACTIONS(1751),
    [anon_sym_SEMI_SEMI] = ACTIONS(1751),
    [anon_sym_PIPE_AMP] = ACTIONS(1751),
  },
  [314] = {
    [sym_command_substitution] = STATE(133),
    [aux_sym__literal_repeat1] = STATE(136),
    [sym_string] = STATE(133),
    [sym_process_substitution] = STATE(133),
    [sym_simple_expansion] = STATE(133),
    [sym_string_expansion] = STATE(133),
    [aux_sym_expansion_repeat1] = STATE(209),
    [sym_concatenation] = STATE(209),
    [sym_expansion] = STATE(133),
    [sym_word] = ACTIONS(493),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(495),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(497),
    [sym_raw_string] = ACTIONS(499),
    [anon_sym_COLON] = ACTIONS(938),
    [anon_sym_DOLLAR] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(1755),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_LT_LPAREN] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(938),
    [anon_sym_PERCENT] = ACTIONS(938),
    [anon_sym_POUND] = ACTIONS(940),
    [anon_sym_COLON_DASH] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(513),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [anon_sym_GT_LPAREN] = ACTIONS(507),
    [sym_ansii_c_string] = ACTIONS(499),
    [anon_sym_COLON_QMARK] = ACTIONS(938),
    [sym__special_character] = ACTIONS(517),
  },
  [315] = {
    [sym_word] = ACTIONS(1757),
    [anon_sym_AMP_GT_GT] = ACTIONS(1757),
    [anon_sym_DOLLAR] = ACTIONS(1757),
    [anon_sym_LT_LT] = ACTIONS(1757),
    [anon_sym_LT_LPAREN] = ACTIONS(1757),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1757),
    [sym__concat] = ACTIONS(1759),
    [anon_sym_PIPE] = ACTIONS(1757),
    [anon_sym_LT] = ACTIONS(1757),
    [anon_sym_LT_AMP] = ACTIONS(1757),
    [anon_sym_GT_GT] = ACTIONS(1757),
    [anon_sym_EQ_TILDE] = ACTIONS(1757),
    [sym__special_character] = ACTIONS(1757),
    [anon_sym_LT_LT_DASH] = ACTIONS(1757),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1757),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1757),
    [anon_sym_LF] = ACTIONS(1759),
    [anon_sym_SEMI] = ACTIONS(1757),
    [sym_raw_string] = ACTIONS(1757),
    [sym_file_descriptor] = ACTIONS(1759),
    [anon_sym_AMP] = ACTIONS(1757),
    [anon_sym_GT] = ACTIONS(1757),
    [anon_sym_AMP_GT] = ACTIONS(1757),
    [anon_sym_EQ_EQ] = ACTIONS(1757),
    [anon_sym_DQUOTE] = ACTIONS(1757),
    [anon_sym_LT_LT_LT] = ACTIONS(1757),
    [anon_sym_GT_AMP] = ACTIONS(1757),
    [ts_builtin_sym_end] = ACTIONS(1759),
    [anon_sym_BQUOTE] = ACTIONS(1757),
    [anon_sym_GT_LPAREN] = ACTIONS(1757),
    [sym_ansii_c_string] = ACTIONS(1757),
    [anon_sym_AMP_AMP] = ACTIONS(1757),
    [anon_sym_SEMI_SEMI] = ACTIONS(1757),
    [anon_sym_PIPE_AMP] = ACTIONS(1757),
  },
  [316] = {
    [anon_sym_EQ] = ACTIONS(1761),
    [anon_sym_PLUS_EQ] = ACTIONS(1761),
    [sym_comment] = ACTIONS(19),
  },
  [317] = {
    [anon_sym_EQ] = ACTIONS(1763),
    [anon_sym_PLUS_EQ] = ACTIONS(1763),
    [sym_comment] = ACTIONS(19),
  },
  [318] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1765),
    [anon_sym_AMP_GT_GT] = ACTIONS(1765),
    [anon_sym_LF] = ACTIONS(1767),
    [anon_sym_SEMI] = ACTIONS(1765),
    [anon_sym_LT_LT] = ACTIONS(1765),
    [anon_sym_AMP] = ACTIONS(1765),
    [anon_sym_GT] = ACTIONS(1765),
    [sym_file_descriptor] = ACTIONS(1767),
    [anon_sym_AMP_GT] = ACTIONS(1765),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1765),
    [ts_builtin_sym_end] = ACTIONS(1767),
    [anon_sym_LT_LT_LT] = ACTIONS(1765),
    [anon_sym_PIPE] = ACTIONS(1765),
    [anon_sym_GT_AMP] = ACTIONS(1765),
    [anon_sym_LT] = ACTIONS(1765),
    [anon_sym_LT_AMP] = ACTIONS(1765),
    [anon_sym_GT_GT] = ACTIONS(1765),
    [anon_sym_AMP_AMP] = ACTIONS(1765),
    [anon_sym_SEMI_SEMI] = ACTIONS(1765),
    [anon_sym_PIPE_AMP] = ACTIONS(1765),
  },
  [319] = {
    [sym_do_group] = STATE(346),
    [sym_compound_statement] = STATE(346),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_comment] = ACTIONS(19),
    [anon_sym_do] = ACTIONS(619),
  },
  [320] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1769),
    [anon_sym_AMP_GT_GT] = ACTIONS(1769),
    [anon_sym_LF] = ACTIONS(1771),
    [anon_sym_SEMI] = ACTIONS(1769),
    [anon_sym_LT_LT] = ACTIONS(1769),
    [anon_sym_AMP] = ACTIONS(1769),
    [anon_sym_GT] = ACTIONS(1769),
    [sym_file_descriptor] = ACTIONS(1771),
    [anon_sym_AMP_GT] = ACTIONS(1769),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1769),
    [ts_builtin_sym_end] = ACTIONS(1771),
    [anon_sym_LT_LT_LT] = ACTIONS(1769),
    [anon_sym_PIPE] = ACTIONS(1769),
    [anon_sym_GT_AMP] = ACTIONS(1769),
    [anon_sym_LT] = ACTIONS(1769),
    [anon_sym_LT_AMP] = ACTIONS(1769),
    [anon_sym_GT_GT] = ACTIONS(1769),
    [anon_sym_AMP_AMP] = ACTIONS(1769),
    [anon_sym_SEMI_SEMI] = ACTIONS(1769),
    [anon_sym_PIPE_AMP] = ACTIONS(1769),
  },
  [321] = {
    [sym_do_group] = STATE(346),
    [sym_compound_statement] = STATE(346),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(1773),
    [anon_sym_do] = ACTIONS(619),
  },
  [322] = {
    [anon_sym_BANG_EQ] = ACTIONS(483),
    [anon_sym_PLUS_EQ] = ACTIONS(483),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_EQ] = ACTIONS(487),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1775),
    [anon_sym_PIPE_PIPE] = ACTIONS(483),
    [anon_sym_GT_EQ] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_LT] = ACTIONS(487),
    [sym_test_operator] = ACTIONS(483),
    [anon_sym_EQ_TILDE] = ACTIONS(489),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(483),
    [anon_sym_AMP_AMP] = ACTIONS(483),
    [anon_sym_DASH_EQ] = ACTIONS(483),
  },
  [323] = {
    [sym_command_substitution] = STATE(65),
    [sym_unary_expression] = STATE(349),
    [sym_postfix_expression] = STATE(349),
    [sym_string] = STATE(65),
    [aux_sym__literal_repeat1] = STATE(68),
    [sym_process_substitution] = STATE(65),
    [sym_parenthesized_expression] = STATE(349),
    [sym_simple_expansion] = STATE(65),
    [sym_string_expansion] = STATE(65),
    [sym__expression] = STATE(349),
    [sym_binary_expression] = STATE(349),
    [sym_concatenation] = STATE(349),
    [sym_expansion] = STATE(65),
    [sym_word] = ACTIONS(209),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(213),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(215),
    [sym_raw_string] = ACTIONS(217),
    [anon_sym_BANG] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(223),
    [sym_comment] = ACTIONS(19),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1775),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [sym_test_operator] = ACTIONS(227),
    [anon_sym_BQUOTE] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(223),
    [sym_ansii_c_string] = ACTIONS(217),
    [sym__special_character] = ACTIONS(231),
  },
  [324] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(194),
    [sym_function_definition] = STATE(194),
    [sym_negated_command] = STATE(194),
    [sym_test_command] = STATE(194),
    [sym_variable_assignment] = STATE(195),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(194),
    [sym_for_statement] = STATE(194),
    [sym_compound_statement] = STATE(194),
    [sym_subshell] = STATE(194),
    [sym_declaration_command] = STATE(194),
    [sym_unset_command] = STATE(194),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [aux_sym__statements2] = STATE(255),
    [sym_c_style_for_statement] = STATE(194),
    [sym_while_statement] = STATE(194),
    [sym_case_statement] = STATE(194),
    [sym_pipeline] = STATE(194),
    [sym_list] = STATE(194),
    [sym_command] = STATE(194),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_fi] = ACTIONS(1777),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [anon_sym_else] = ACTIONS(1777),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_elif] = ACTIONS(1777),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [325] = {
    [sym_word] = ACTIONS(1779),
    [anon_sym_AMP_GT_GT] = ACTIONS(1781),
    [anon_sym_typeset] = ACTIONS(1779),
    [anon_sym_DOLLAR] = ACTIONS(1779),
    [anon_sym_LT_LPAREN] = ACTIONS(1781),
    [anon_sym_done] = ACTIONS(1779),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT_AMP] = ACTIONS(1781),
    [anon_sym_export] = ACTIONS(1779),
    [sym__special_character] = ACTIONS(1779),
    [anon_sym_if] = ACTIONS(1779),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1781),
    [sym_raw_string] = ACTIONS(1781),
    [anon_sym_declare] = ACTIONS(1779),
    [sym_variable_name] = ACTIONS(1781),
    [anon_sym_readonly] = ACTIONS(1779),
    [anon_sym_unset] = ACTIONS(1779),
    [anon_sym_DQUOTE] = ACTIONS(1781),
    [anon_sym_GT_AMP] = ACTIONS(1781),
    [anon_sym_elif] = ACTIONS(1779),
    [sym_ansii_c_string] = ACTIONS(1781),
    [anon_sym_while] = ACTIONS(1779),
    [anon_sym_LPAREN] = ACTIONS(1779),
    [anon_sym_local] = ACTIONS(1779),
    [anon_sym_unsetenv] = ACTIONS(1779),
    [anon_sym_fi] = ACTIONS(1779),
    [anon_sym_else] = ACTIONS(1779),
    [anon_sym_function] = ACTIONS(1779),
    [anon_sym_LBRACE] = ACTIONS(1781),
    [anon_sym_LT] = ACTIONS(1779),
    [anon_sym_GT_GT] = ACTIONS(1781),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1781),
    [anon_sym_case] = ACTIONS(1779),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1781),
    [anon_sym_BANG] = ACTIONS(1779),
    [sym_file_descriptor] = ACTIONS(1781),
    [anon_sym_GT] = ACTIONS(1779),
    [anon_sym_AMP_GT] = ACTIONS(1779),
    [anon_sym_BQUOTE] = ACTIONS(1781),
    [anon_sym_GT_LPAREN] = ACTIONS(1781),
    [anon_sym_for] = ACTIONS(1779),
    [anon_sym_LBRACK] = ACTIONS(1779),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1781),
  },
  [326] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1783),
    [anon_sym_AMP_GT_GT] = ACTIONS(1783),
    [anon_sym_LF] = ACTIONS(1785),
    [anon_sym_SEMI] = ACTIONS(1783),
    [anon_sym_LT_LT] = ACTIONS(1783),
    [anon_sym_AMP] = ACTIONS(1783),
    [anon_sym_GT] = ACTIONS(1783),
    [sym_file_descriptor] = ACTIONS(1785),
    [anon_sym_AMP_GT] = ACTIONS(1783),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1783),
    [ts_builtin_sym_end] = ACTIONS(1785),
    [anon_sym_LT_LT_LT] = ACTIONS(1783),
    [anon_sym_PIPE] = ACTIONS(1783),
    [anon_sym_GT_AMP] = ACTIONS(1783),
    [anon_sym_LT] = ACTIONS(1783),
    [anon_sym_LT_AMP] = ACTIONS(1783),
    [anon_sym_GT_GT] = ACTIONS(1783),
    [anon_sym_AMP_AMP] = ACTIONS(1783),
    [anon_sym_SEMI_SEMI] = ACTIONS(1783),
    [anon_sym_PIPE_AMP] = ACTIONS(1783),
  },
  [327] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_AMP_GT_GT] = ACTIONS(1787),
    [anon_sym_LF] = ACTIONS(1789),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_LT_LT] = ACTIONS(1787),
    [anon_sym_AMP] = ACTIONS(1787),
    [anon_sym_GT] = ACTIONS(1787),
    [sym_file_descriptor] = ACTIONS(1789),
    [anon_sym_AMP_GT] = ACTIONS(1787),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [ts_builtin_sym_end] = ACTIONS(1789),
    [anon_sym_LT_LT_LT] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1787),
    [anon_sym_GT_AMP] = ACTIONS(1787),
    [anon_sym_LT] = ACTIONS(1787),
    [anon_sym_LT_AMP] = ACTIONS(1787),
    [anon_sym_GT_GT] = ACTIONS(1787),
    [anon_sym_AMP_AMP] = ACTIONS(1787),
    [anon_sym_SEMI_SEMI] = ACTIONS(1787),
    [anon_sym_PIPE_AMP] = ACTIONS(1787),
  },
  [328] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_esac] = ACTIONS(1791),
  },
  [329] = {
    [aux_sym_concatenation_repeat1] = STATE(772),
    [anon_sym_RPAREN] = ACTIONS(1793),
    [sym__concat] = ACTIONS(475),
    [anon_sym_PIPE] = ACTIONS(1793),
    [sym_comment] = ACTIONS(19),
  },
  [330] = {
    [aux_sym__literal_repeat1] = STATE(778),
    [anon_sym_RPAREN] = ACTIONS(1795),
    [anon_sym_PIPE] = ACTIONS(1795),
    [sym__special_character] = ACTIONS(1538),
    [sym_comment] = ACTIONS(19),
  },
  [331] = {
    [anon_sym_PIPE] = ACTIONS(1793),
    [anon_sym_RPAREN] = ACTIONS(1793),
    [sym_comment] = ACTIONS(19),
  },
  [332] = {
    [sym_word] = ACTIONS(1797),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1799),
    [anon_sym_DQUOTE] = ACTIONS(1799),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1799),
    [sym_raw_string] = ACTIONS(1799),
    [anon_sym_BQUOTE] = ACTIONS(1799),
    [anon_sym_esac] = ACTIONS(1801),
    [anon_sym_DOLLAR] = ACTIONS(1797),
    [sym_ansii_c_string] = ACTIONS(1799),
    [anon_sym_GT_LPAREN] = ACTIONS(1799),
    [anon_sym_LT_LPAREN] = ACTIONS(1799),
    [sym__special_character] = ACTIONS(1799),
    [sym_comment] = ACTIONS(19),
  },
  [333] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_SEMI_SEMI] = ACTIONS(1803),
    [anon_sym_esac] = ACTIONS(1805),
  },
  [334] = {
    [aux_sym__literal_repeat1] = STATE(539),
    [sym_if_statement] = STATE(540),
    [sym_function_definition] = STATE(540),
    [sym_negated_command] = STATE(540),
    [sym_test_command] = STATE(540),
    [sym_variable_assignment] = STATE(635),
    [sym_subscript] = STATE(2473),
    [sym_concatenation] = STATE(542),
    [sym_expansion] = STATE(537),
    [sym_command_substitution] = STATE(537),
    [aux_sym__statements_repeat1] = STATE(636),
    [sym_redirected_statement] = STATE(540),
    [sym_for_statement] = STATE(540),
    [sym_compound_statement] = STATE(540),
    [sym_subshell] = STATE(540),
    [sym_declaration_command] = STATE(540),
    [sym_unset_command] = STATE(540),
    [sym_file_redirect] = STATE(544),
    [sym_string] = STATE(537),
    [sym_process_substitution] = STATE(537),
    [aux_sym_command_repeat1] = STATE(544),
    [sym__statements] = STATE(352),
    [sym_c_style_for_statement] = STATE(540),
    [sym_while_statement] = STATE(540),
    [sym_case_statement] = STATE(540),
    [sym_pipeline] = STATE(540),
    [sym_list] = STATE(540),
    [sym_command] = STATE(540),
    [sym_command_name] = STATE(637),
    [sym_simple_expansion] = STATE(537),
    [sym_string_expansion] = STATE(537),
    [sym_word] = ACTIONS(1673),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(1675),
    [anon_sym_typeset] = ACTIONS(1675),
    [anon_sym_unsetenv] = ACTIONS(1677),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LPAREN] = ACTIONS(1681),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(1675),
    [sym__special_character] = ACTIONS(1683),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(1685),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1687),
    [anon_sym_BANG] = ACTIONS(1689),
    [anon_sym_declare] = ACTIONS(1675),
    [sym_variable_name] = ACTIONS(1691),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1693),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(1675),
    [anon_sym_unset] = ACTIONS(1677),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(1697),
    [anon_sym_esac] = ACTIONS(1801),
    [anon_sym_GT_LPAREN] = ACTIONS(1681),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(1685),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [anon_sym_SEMI_SEMI] = ACTIONS(1803),
  },
  [335] = {
    [aux_sym_case_item_repeat1] = STATE(335),
    [anon_sym_PIPE] = ACTIONS(1807),
    [anon_sym_RPAREN] = ACTIONS(1793),
    [sym_comment] = ACTIONS(19),
  },
  [336] = {
    [sym_word] = ACTIONS(1810),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1812),
    [anon_sym_DQUOTE] = ACTIONS(1812),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1812),
    [sym_raw_string] = ACTIONS(1812),
    [anon_sym_BQUOTE] = ACTIONS(1812),
    [anon_sym_esac] = ACTIONS(1814),
    [anon_sym_DOLLAR] = ACTIONS(1810),
    [sym_ansii_c_string] = ACTIONS(1812),
    [anon_sym_GT_LPAREN] = ACTIONS(1812),
    [anon_sym_LT_LPAREN] = ACTIONS(1812),
    [sym__special_character] = ACTIONS(1812),
    [sym_comment] = ACTIONS(19),
  },
  [337] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_SEMI_SEMI] = ACTIONS(1816),
    [anon_sym_esac] = ACTIONS(1818),
  },
  [338] = {
    [aux_sym__literal_repeat1] = STATE(539),
    [sym_if_statement] = STATE(540),
    [sym_function_definition] = STATE(540),
    [sym_negated_command] = STATE(540),
    [sym_test_command] = STATE(540),
    [sym_variable_assignment] = STATE(635),
    [sym_subscript] = STATE(2473),
    [sym_concatenation] = STATE(542),
    [sym_expansion] = STATE(537),
    [sym_command_substitution] = STATE(537),
    [aux_sym__statements_repeat1] = STATE(636),
    [sym_redirected_statement] = STATE(540),
    [sym_for_statement] = STATE(540),
    [sym_compound_statement] = STATE(540),
    [sym_subshell] = STATE(540),
    [sym_declaration_command] = STATE(540),
    [sym_unset_command] = STATE(540),
    [sym_file_redirect] = STATE(544),
    [sym_string] = STATE(537),
    [sym_process_substitution] = STATE(537),
    [aux_sym_command_repeat1] = STATE(544),
    [sym__statements] = STATE(354),
    [sym_c_style_for_statement] = STATE(540),
    [sym_while_statement] = STATE(540),
    [sym_case_statement] = STATE(540),
    [sym_pipeline] = STATE(540),
    [sym_list] = STATE(540),
    [sym_command] = STATE(540),
    [sym_command_name] = STATE(637),
    [sym_simple_expansion] = STATE(537),
    [sym_string_expansion] = STATE(537),
    [sym_word] = ACTIONS(1673),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(1675),
    [anon_sym_typeset] = ACTIONS(1675),
    [anon_sym_unsetenv] = ACTIONS(1677),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LPAREN] = ACTIONS(1681),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(1675),
    [sym__special_character] = ACTIONS(1683),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(1685),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1687),
    [anon_sym_BANG] = ACTIONS(1689),
    [anon_sym_declare] = ACTIONS(1675),
    [sym_variable_name] = ACTIONS(1691),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1693),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(1675),
    [anon_sym_unset] = ACTIONS(1677),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(1697),
    [anon_sym_esac] = ACTIONS(1814),
    [anon_sym_GT_LPAREN] = ACTIONS(1681),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(1685),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [anon_sym_SEMI_SEMI] = ACTIONS(1816),
  },
  [339] = {
    [aux_sym_concatenation_repeat1] = STATE(772),
    [aux_sym_case_item_repeat1] = STATE(356),
    [anon_sym_RPAREN] = ACTIONS(1820),
    [sym__concat] = ACTIONS(475),
    [anon_sym_PIPE] = ACTIONS(1530),
    [sym_comment] = ACTIONS(19),
  },
  [340] = {
    [aux_sym__literal_repeat1] = STATE(778),
    [aux_sym_case_item_repeat1] = STATE(358),
    [anon_sym_RPAREN] = ACTIONS(1822),
    [anon_sym_PIPE] = ACTIONS(1530),
    [sym__special_character] = ACTIONS(1538),
    [sym_comment] = ACTIONS(19),
  },
  [341] = {
    [aux_sym_case_item_repeat1] = STATE(356),
    [anon_sym_PIPE] = ACTIONS(1530),
    [anon_sym_RPAREN] = ACTIONS(1820),
    [sym_comment] = ACTIONS(19),
  },
  [342] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1824),
    [anon_sym_AMP_GT_GT] = ACTIONS(1824),
    [anon_sym_LF] = ACTIONS(1826),
    [anon_sym_SEMI] = ACTIONS(1824),
    [anon_sym_LT_LT] = ACTIONS(1824),
    [anon_sym_AMP] = ACTIONS(1824),
    [anon_sym_GT] = ACTIONS(1824),
    [sym_file_descriptor] = ACTIONS(1826),
    [anon_sym_AMP_GT] = ACTIONS(1824),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1824),
    [ts_builtin_sym_end] = ACTIONS(1826),
    [anon_sym_LT_LT_LT] = ACTIONS(1824),
    [anon_sym_PIPE] = ACTIONS(1824),
    [anon_sym_GT_AMP] = ACTIONS(1824),
    [anon_sym_LT] = ACTIONS(1824),
    [anon_sym_LT_AMP] = ACTIONS(1824),
    [anon_sym_GT_GT] = ACTIONS(1824),
    [anon_sym_AMP_AMP] = ACTIONS(1824),
    [anon_sym_SEMI_SEMI] = ACTIONS(1824),
    [anon_sym_PIPE_AMP] = ACTIONS(1824),
  },
  [343] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_esac] = ACTIONS(1828),
  },
  [344] = {
    [sym_word] = ACTIONS(1830),
    [anon_sym_AMP_GT_GT] = ACTIONS(1830),
    [anon_sym_DOLLAR] = ACTIONS(1830),
    [anon_sym_LT_LT] = ACTIONS(1830),
    [anon_sym_LT_LPAREN] = ACTIONS(1830),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1830),
    [sym__concat] = ACTIONS(1832),
    [anon_sym_PIPE] = ACTIONS(1830),
    [anon_sym_LT] = ACTIONS(1830),
    [anon_sym_LT_AMP] = ACTIONS(1830),
    [anon_sym_GT_GT] = ACTIONS(1830),
    [anon_sym_EQ_TILDE] = ACTIONS(1830),
    [sym__special_character] = ACTIONS(1830),
    [anon_sym_LT_LT_DASH] = ACTIONS(1830),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1830),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1830),
    [anon_sym_LF] = ACTIONS(1832),
    [anon_sym_SEMI] = ACTIONS(1830),
    [sym_raw_string] = ACTIONS(1830),
    [sym_file_descriptor] = ACTIONS(1832),
    [anon_sym_AMP] = ACTIONS(1830),
    [anon_sym_GT] = ACTIONS(1830),
    [anon_sym_AMP_GT] = ACTIONS(1830),
    [anon_sym_EQ_EQ] = ACTIONS(1830),
    [anon_sym_DQUOTE] = ACTIONS(1830),
    [anon_sym_LT_LT_LT] = ACTIONS(1830),
    [anon_sym_GT_AMP] = ACTIONS(1830),
    [ts_builtin_sym_end] = ACTIONS(1832),
    [anon_sym_BQUOTE] = ACTIONS(1830),
    [anon_sym_GT_LPAREN] = ACTIONS(1830),
    [sym_ansii_c_string] = ACTIONS(1830),
    [anon_sym_AMP_AMP] = ACTIONS(1830),
    [anon_sym_SEMI_SEMI] = ACTIONS(1830),
    [anon_sym_PIPE_AMP] = ACTIONS(1830),
  },
  [345] = {
    [sym_word] = ACTIONS(1834),
    [anon_sym_AMP_GT_GT] = ACTIONS(1834),
    [anon_sym_DOLLAR] = ACTIONS(1834),
    [anon_sym_LT_LT] = ACTIONS(1834),
    [anon_sym_LT_LPAREN] = ACTIONS(1834),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1834),
    [sym__concat] = ACTIONS(1836),
    [anon_sym_PIPE] = ACTIONS(1834),
    [anon_sym_LT] = ACTIONS(1834),
    [anon_sym_LT_AMP] = ACTIONS(1834),
    [anon_sym_GT_GT] = ACTIONS(1834),
    [anon_sym_EQ_TILDE] = ACTIONS(1834),
    [sym__special_character] = ACTIONS(1834),
    [anon_sym_LT_LT_DASH] = ACTIONS(1834),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1834),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1834),
    [anon_sym_LF] = ACTIONS(1836),
    [anon_sym_SEMI] = ACTIONS(1834),
    [sym_raw_string] = ACTIONS(1834),
    [sym_file_descriptor] = ACTIONS(1836),
    [anon_sym_AMP] = ACTIONS(1834),
    [anon_sym_GT] = ACTIONS(1834),
    [anon_sym_AMP_GT] = ACTIONS(1834),
    [anon_sym_EQ_EQ] = ACTIONS(1834),
    [anon_sym_DQUOTE] = ACTIONS(1834),
    [anon_sym_LT_LT_LT] = ACTIONS(1834),
    [anon_sym_GT_AMP] = ACTIONS(1834),
    [ts_builtin_sym_end] = ACTIONS(1836),
    [anon_sym_BQUOTE] = ACTIONS(1834),
    [anon_sym_GT_LPAREN] = ACTIONS(1834),
    [sym_ansii_c_string] = ACTIONS(1834),
    [anon_sym_AMP_AMP] = ACTIONS(1834),
    [anon_sym_SEMI_SEMI] = ACTIONS(1834),
    [anon_sym_PIPE_AMP] = ACTIONS(1834),
  },
  [346] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1838),
    [anon_sym_AMP_GT_GT] = ACTIONS(1838),
    [anon_sym_LF] = ACTIONS(1840),
    [anon_sym_SEMI] = ACTIONS(1838),
    [anon_sym_LT_LT] = ACTIONS(1838),
    [anon_sym_AMP] = ACTIONS(1838),
    [anon_sym_GT] = ACTIONS(1838),
    [sym_file_descriptor] = ACTIONS(1840),
    [anon_sym_AMP_GT] = ACTIONS(1838),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1838),
    [ts_builtin_sym_end] = ACTIONS(1840),
    [anon_sym_LT_LT_LT] = ACTIONS(1838),
    [anon_sym_PIPE] = ACTIONS(1838),
    [anon_sym_GT_AMP] = ACTIONS(1838),
    [anon_sym_LT] = ACTIONS(1838),
    [anon_sym_LT_AMP] = ACTIONS(1838),
    [anon_sym_GT_GT] = ACTIONS(1838),
    [anon_sym_AMP_AMP] = ACTIONS(1838),
    [anon_sym_SEMI_SEMI] = ACTIONS(1838),
    [anon_sym_PIPE_AMP] = ACTIONS(1838),
  },
  [347] = {
    [sym_do_group] = STATE(360),
    [sym_compound_statement] = STATE(360),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_comment] = ACTIONS(19),
    [anon_sym_do] = ACTIONS(619),
  },
  [348] = {
    [sym_do_group] = STATE(360),
    [sym_compound_statement] = STATE(360),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(1842),
    [anon_sym_do] = ACTIONS(619),
  },
  [349] = {
    [anon_sym_BANG_EQ] = ACTIONS(483),
    [anon_sym_PLUS_EQ] = ACTIONS(483),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_EQ] = ACTIONS(487),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1844),
    [anon_sym_PIPE_PIPE] = ACTIONS(483),
    [anon_sym_GT_EQ] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_LT] = ACTIONS(487),
    [sym_test_operator] = ACTIONS(483),
    [anon_sym_EQ_TILDE] = ACTIONS(489),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(483),
    [anon_sym_AMP_AMP] = ACTIONS(483),
    [anon_sym_DASH_EQ] = ACTIONS(483),
  },
  [350] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1846),
    [anon_sym_AMP_GT_GT] = ACTIONS(1846),
    [anon_sym_LF] = ACTIONS(1848),
    [anon_sym_SEMI] = ACTIONS(1846),
    [anon_sym_LT_LT] = ACTIONS(1846),
    [anon_sym_AMP] = ACTIONS(1846),
    [anon_sym_GT] = ACTIONS(1846),
    [sym_file_descriptor] = ACTIONS(1848),
    [anon_sym_AMP_GT] = ACTIONS(1846),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1846),
    [ts_builtin_sym_end] = ACTIONS(1848),
    [anon_sym_LT_LT_LT] = ACTIONS(1846),
    [anon_sym_PIPE] = ACTIONS(1846),
    [anon_sym_GT_AMP] = ACTIONS(1846),
    [anon_sym_LT] = ACTIONS(1846),
    [anon_sym_LT_AMP] = ACTIONS(1846),
    [anon_sym_GT_GT] = ACTIONS(1846),
    [anon_sym_AMP_AMP] = ACTIONS(1846),
    [anon_sym_SEMI_SEMI] = ACTIONS(1846),
    [anon_sym_PIPE_AMP] = ACTIONS(1846),
  },
  [351] = {
    [sym_word] = ACTIONS(1850),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1852),
    [anon_sym_DQUOTE] = ACTIONS(1852),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1852),
    [sym_raw_string] = ACTIONS(1852),
    [anon_sym_BQUOTE] = ACTIONS(1852),
    [anon_sym_esac] = ACTIONS(1854),
    [anon_sym_DOLLAR] = ACTIONS(1850),
    [sym_ansii_c_string] = ACTIONS(1852),
    [anon_sym_GT_LPAREN] = ACTIONS(1852),
    [anon_sym_LT_LPAREN] = ACTIONS(1852),
    [sym__special_character] = ACTIONS(1852),
    [sym_comment] = ACTIONS(19),
  },
  [352] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_SEMI_SEMI] = ACTIONS(1856),
    [anon_sym_esac] = ACTIONS(1858),
  },
  [353] = {
    [sym_word] = ACTIONS(1860),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1862),
    [anon_sym_DQUOTE] = ACTIONS(1862),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1862),
    [sym_raw_string] = ACTIONS(1862),
    [anon_sym_BQUOTE] = ACTIONS(1862),
    [anon_sym_esac] = ACTIONS(1864),
    [anon_sym_DOLLAR] = ACTIONS(1860),
    [sym_ansii_c_string] = ACTIONS(1862),
    [anon_sym_GT_LPAREN] = ACTIONS(1862),
    [anon_sym_LT_LPAREN] = ACTIONS(1862),
    [sym__special_character] = ACTIONS(1862),
    [sym_comment] = ACTIONS(19),
  },
  [354] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_SEMI_SEMI] = ACTIONS(1866),
    [anon_sym_esac] = ACTIONS(1868),
  },
  [355] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(634),
    [sym_function_definition] = STATE(634),
    [sym_negated_command] = STATE(634),
    [sym_test_command] = STATE(634),
    [sym_variable_assignment] = STATE(695),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(1463),
    [sym_redirected_statement] = STATE(634),
    [sym_for_statement] = STATE(634),
    [sym_compound_statement] = STATE(634),
    [sym_subshell] = STATE(634),
    [sym_declaration_command] = STATE(634),
    [sym_unset_command] = STATE(634),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym__statements] = STATE(366),
    [sym_c_style_for_statement] = STATE(634),
    [sym_while_statement] = STATE(634),
    [sym_case_statement] = STATE(634),
    [sym_pipeline] = STATE(634),
    [sym_list] = STATE(634),
    [sym_command] = STATE(634),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [anon_sym_SEMI_SEMI] = ACTIONS(1870),
  },
  [356] = {
    [aux_sym_case_item_repeat1] = STATE(335),
    [anon_sym_PIPE] = ACTIONS(1530),
    [anon_sym_RPAREN] = ACTIONS(1872),
    [sym_comment] = ACTIONS(19),
  },
  [357] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(634),
    [sym_function_definition] = STATE(634),
    [sym_negated_command] = STATE(634),
    [sym_test_command] = STATE(634),
    [sym_variable_assignment] = STATE(695),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(1463),
    [sym_redirected_statement] = STATE(634),
    [sym_for_statement] = STATE(634),
    [sym_compound_statement] = STATE(634),
    [sym_subshell] = STATE(634),
    [sym_declaration_command] = STATE(634),
    [sym_unset_command] = STATE(634),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym__statements] = STATE(369),
    [sym_c_style_for_statement] = STATE(634),
    [sym_while_statement] = STATE(634),
    [sym_case_statement] = STATE(634),
    [sym_pipeline] = STATE(634),
    [sym_list] = STATE(634),
    [sym_command] = STATE(634),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [anon_sym_SEMI_SEMI] = ACTIONS(1874),
  },
  [358] = {
    [aux_sym_case_item_repeat1] = STATE(335),
    [anon_sym_PIPE] = ACTIONS(1530),
    [anon_sym_RPAREN] = ACTIONS(1876),
    [sym_comment] = ACTIONS(19),
  },
  [359] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1878),
    [anon_sym_AMP_GT_GT] = ACTIONS(1878),
    [anon_sym_LF] = ACTIONS(1880),
    [anon_sym_SEMI] = ACTIONS(1878),
    [anon_sym_LT_LT] = ACTIONS(1878),
    [anon_sym_AMP] = ACTIONS(1878),
    [anon_sym_GT] = ACTIONS(1878),
    [sym_file_descriptor] = ACTIONS(1880),
    [anon_sym_AMP_GT] = ACTIONS(1878),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1878),
    [ts_builtin_sym_end] = ACTIONS(1880),
    [anon_sym_LT_LT_LT] = ACTIONS(1878),
    [anon_sym_PIPE] = ACTIONS(1878),
    [anon_sym_GT_AMP] = ACTIONS(1878),
    [anon_sym_LT] = ACTIONS(1878),
    [anon_sym_LT_AMP] = ACTIONS(1878),
    [anon_sym_GT_GT] = ACTIONS(1878),
    [anon_sym_AMP_AMP] = ACTIONS(1878),
    [anon_sym_SEMI_SEMI] = ACTIONS(1878),
    [anon_sym_PIPE_AMP] = ACTIONS(1878),
  },
  [360] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1882),
    [anon_sym_AMP_GT_GT] = ACTIONS(1882),
    [anon_sym_LF] = ACTIONS(1884),
    [anon_sym_SEMI] = ACTIONS(1882),
    [anon_sym_LT_LT] = ACTIONS(1882),
    [anon_sym_AMP] = ACTIONS(1882),
    [anon_sym_GT] = ACTIONS(1882),
    [sym_file_descriptor] = ACTIONS(1884),
    [anon_sym_AMP_GT] = ACTIONS(1882),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1882),
    [ts_builtin_sym_end] = ACTIONS(1884),
    [anon_sym_LT_LT_LT] = ACTIONS(1882),
    [anon_sym_PIPE] = ACTIONS(1882),
    [anon_sym_GT_AMP] = ACTIONS(1882),
    [anon_sym_LT] = ACTIONS(1882),
    [anon_sym_LT_AMP] = ACTIONS(1882),
    [anon_sym_GT_GT] = ACTIONS(1882),
    [anon_sym_AMP_AMP] = ACTIONS(1882),
    [anon_sym_SEMI_SEMI] = ACTIONS(1882),
    [anon_sym_PIPE_AMP] = ACTIONS(1882),
  },
  [361] = {
    [sym_do_group] = STATE(371),
    [sym_compound_statement] = STATE(371),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_comment] = ACTIONS(19),
    [anon_sym_do] = ACTIONS(619),
  },
  [362] = {
    [sym_do_group] = STATE(371),
    [sym_compound_statement] = STATE(371),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(1886),
    [anon_sym_do] = ACTIONS(619),
  },
  [363] = {
    [sym_word] = ACTIONS(1888),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1890),
    [anon_sym_DQUOTE] = ACTIONS(1890),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1890),
    [sym_raw_string] = ACTIONS(1890),
    [anon_sym_BQUOTE] = ACTIONS(1890),
    [anon_sym_esac] = ACTIONS(1892),
    [anon_sym_DOLLAR] = ACTIONS(1888),
    [sym_ansii_c_string] = ACTIONS(1890),
    [anon_sym_GT_LPAREN] = ACTIONS(1890),
    [anon_sym_LT_LPAREN] = ACTIONS(1890),
    [sym__special_character] = ACTIONS(1890),
    [sym_comment] = ACTIONS(19),
  },
  [364] = {
    [sym_word] = ACTIONS(1894),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1896),
    [anon_sym_DQUOTE] = ACTIONS(1896),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1896),
    [sym_raw_string] = ACTIONS(1896),
    [anon_sym_BQUOTE] = ACTIONS(1896),
    [anon_sym_esac] = ACTIONS(1898),
    [anon_sym_DOLLAR] = ACTIONS(1894),
    [sym_ansii_c_string] = ACTIONS(1896),
    [anon_sym_GT_LPAREN] = ACTIONS(1896),
    [anon_sym_LT_LPAREN] = ACTIONS(1896),
    [sym__special_character] = ACTIONS(1896),
    [sym_comment] = ACTIONS(19),
  },
  [365] = {
    [sym_word] = ACTIONS(1799),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1799),
    [anon_sym_DQUOTE] = ACTIONS(1799),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1799),
    [sym_raw_string] = ACTIONS(1799),
    [anon_sym_BQUOTE] = ACTIONS(1799),
    [anon_sym_DOLLAR] = ACTIONS(1797),
    [sym_ansii_c_string] = ACTIONS(1799),
    [anon_sym_GT_LPAREN] = ACTIONS(1799),
    [anon_sym_LT_LPAREN] = ACTIONS(1799),
    [sym__special_character] = ACTIONS(1799),
    [sym_comment] = ACTIONS(19),
  },
  [366] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_SEMI_SEMI] = ACTIONS(1900),
  },
  [367] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(634),
    [sym_function_definition] = STATE(634),
    [sym_negated_command] = STATE(634),
    [sym_test_command] = STATE(634),
    [sym_variable_assignment] = STATE(695),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(1463),
    [sym_redirected_statement] = STATE(634),
    [sym_for_statement] = STATE(634),
    [sym_compound_statement] = STATE(634),
    [sym_subshell] = STATE(634),
    [sym_declaration_command] = STATE(634),
    [sym_unset_command] = STATE(634),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym__statements] = STATE(374),
    [sym_c_style_for_statement] = STATE(634),
    [sym_while_statement] = STATE(634),
    [sym_case_statement] = STATE(634),
    [sym_pipeline] = STATE(634),
    [sym_list] = STATE(634),
    [sym_command] = STATE(634),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [anon_sym_SEMI_SEMI] = ACTIONS(1900),
  },
  [368] = {
    [sym_word] = ACTIONS(1812),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1812),
    [anon_sym_DQUOTE] = ACTIONS(1812),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1812),
    [sym_raw_string] = ACTIONS(1812),
    [anon_sym_BQUOTE] = ACTIONS(1812),
    [anon_sym_DOLLAR] = ACTIONS(1810),
    [sym_ansii_c_string] = ACTIONS(1812),
    [anon_sym_GT_LPAREN] = ACTIONS(1812),
    [anon_sym_LT_LPAREN] = ACTIONS(1812),
    [sym__special_character] = ACTIONS(1812),
    [sym_comment] = ACTIONS(19),
  },
  [369] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_SEMI_SEMI] = ACTIONS(1902),
  },
  [370] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(634),
    [sym_function_definition] = STATE(634),
    [sym_negated_command] = STATE(634),
    [sym_test_command] = STATE(634),
    [sym_variable_assignment] = STATE(695),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(1463),
    [sym_redirected_statement] = STATE(634),
    [sym_for_statement] = STATE(634),
    [sym_compound_statement] = STATE(634),
    [sym_subshell] = STATE(634),
    [sym_declaration_command] = STATE(634),
    [sym_unset_command] = STATE(634),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym__statements] = STATE(376),
    [sym_c_style_for_statement] = STATE(634),
    [sym_while_statement] = STATE(634),
    [sym_case_statement] = STATE(634),
    [sym_pipeline] = STATE(634),
    [sym_list] = STATE(634),
    [sym_command] = STATE(634),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [anon_sym_SEMI_SEMI] = ACTIONS(1902),
  },
  [371] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1904),
    [anon_sym_AMP_GT_GT] = ACTIONS(1904),
    [anon_sym_LF] = ACTIONS(1906),
    [anon_sym_SEMI] = ACTIONS(1904),
    [anon_sym_LT_LT] = ACTIONS(1904),
    [anon_sym_AMP] = ACTIONS(1904),
    [anon_sym_GT] = ACTIONS(1904),
    [sym_file_descriptor] = ACTIONS(1906),
    [anon_sym_AMP_GT] = ACTIONS(1904),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1904),
    [ts_builtin_sym_end] = ACTIONS(1906),
    [anon_sym_LT_LT_LT] = ACTIONS(1904),
    [anon_sym_PIPE] = ACTIONS(1904),
    [anon_sym_GT_AMP] = ACTIONS(1904),
    [anon_sym_LT] = ACTIONS(1904),
    [anon_sym_LT_AMP] = ACTIONS(1904),
    [anon_sym_GT_GT] = ACTIONS(1904),
    [anon_sym_AMP_AMP] = ACTIONS(1904),
    [anon_sym_SEMI_SEMI] = ACTIONS(1904),
    [anon_sym_PIPE_AMP] = ACTIONS(1904),
  },
  [372] = {
    [sym_do_group] = STATE(377),
    [sym_compound_statement] = STATE(377),
    [anon_sym_LBRACE] = ACTIONS(23),
    [sym_comment] = ACTIONS(19),
    [anon_sym_do] = ACTIONS(619),
  },
  [373] = {
    [sym_word] = ACTIONS(1852),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1852),
    [anon_sym_DQUOTE] = ACTIONS(1852),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1852),
    [sym_raw_string] = ACTIONS(1852),
    [anon_sym_BQUOTE] = ACTIONS(1852),
    [anon_sym_DOLLAR] = ACTIONS(1850),
    [sym_ansii_c_string] = ACTIONS(1852),
    [anon_sym_GT_LPAREN] = ACTIONS(1852),
    [anon_sym_LT_LPAREN] = ACTIONS(1852),
    [sym__special_character] = ACTIONS(1852),
    [sym_comment] = ACTIONS(19),
  },
  [374] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_SEMI_SEMI] = ACTIONS(1908),
  },
  [375] = {
    [sym_word] = ACTIONS(1862),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1862),
    [anon_sym_DQUOTE] = ACTIONS(1862),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1862),
    [sym_raw_string] = ACTIONS(1862),
    [anon_sym_BQUOTE] = ACTIONS(1862),
    [anon_sym_DOLLAR] = ACTIONS(1860),
    [sym_ansii_c_string] = ACTIONS(1862),
    [anon_sym_GT_LPAREN] = ACTIONS(1862),
    [anon_sym_LT_LPAREN] = ACTIONS(1862),
    [sym__special_character] = ACTIONS(1862),
    [sym_comment] = ACTIONS(19),
  },
  [376] = {
    [sym_comment] = ACTIONS(19),
    [anon_sym_SEMI_SEMI] = ACTIONS(1910),
  },
  [377] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1912),
    [anon_sym_AMP_GT_GT] = ACTIONS(1912),
    [anon_sym_LF] = ACTIONS(1914),
    [anon_sym_SEMI] = ACTIONS(1912),
    [anon_sym_LT_LT] = ACTIONS(1912),
    [anon_sym_AMP] = ACTIONS(1912),
    [anon_sym_GT] = ACTIONS(1912),
    [sym_file_descriptor] = ACTIONS(1914),
    [anon_sym_AMP_GT] = ACTIONS(1912),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1912),
    [ts_builtin_sym_end] = ACTIONS(1914),
    [anon_sym_LT_LT_LT] = ACTIONS(1912),
    [anon_sym_PIPE] = ACTIONS(1912),
    [anon_sym_GT_AMP] = ACTIONS(1912),
    [anon_sym_LT] = ACTIONS(1912),
    [anon_sym_LT_AMP] = ACTIONS(1912),
    [anon_sym_GT_GT] = ACTIONS(1912),
    [anon_sym_AMP_AMP] = ACTIONS(1912),
    [anon_sym_SEMI_SEMI] = ACTIONS(1912),
    [anon_sym_PIPE_AMP] = ACTIONS(1912),
  },
  [378] = {
    [sym_word] = ACTIONS(1890),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1890),
    [anon_sym_DQUOTE] = ACTIONS(1890),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1890),
    [sym_raw_string] = ACTIONS(1890),
    [anon_sym_BQUOTE] = ACTIONS(1890),
    [anon_sym_DOLLAR] = ACTIONS(1888),
    [sym_ansii_c_string] = ACTIONS(1890),
    [anon_sym_GT_LPAREN] = ACTIONS(1890),
    [anon_sym_LT_LPAREN] = ACTIONS(1890),
    [sym__special_character] = ACTIONS(1890),
    [sym_comment] = ACTIONS(19),
  },
  [379] = {
    [sym_word] = ACTIONS(1896),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1896),
    [anon_sym_DQUOTE] = ACTIONS(1896),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1896),
    [sym_raw_string] = ACTIONS(1896),
    [anon_sym_BQUOTE] = ACTIONS(1896),
    [anon_sym_DOLLAR] = ACTIONS(1894),
    [sym_ansii_c_string] = ACTIONS(1896),
    [anon_sym_GT_LPAREN] = ACTIONS(1896),
    [anon_sym_LT_LPAREN] = ACTIONS(1896),
    [sym__special_character] = ACTIONS(1896),
    [sym_comment] = ACTIONS(19),
  },
  [380] = {
    [aux_sym_concatenation_repeat1] = STATE(393),
    [sym_word] = ACTIONS(61),
    [anon_sym_LPAREN] = ACTIONS(1916),
    [anon_sym_AMP_GT_GT] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_LT_LT] = ACTIONS(61),
    [anon_sym_LT_LPAREN] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [sym__concat] = ACTIONS(1918),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_LT_AMP] = ACTIONS(61),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_EQ_TILDE] = ACTIONS(61),
    [sym__special_character] = ACTIONS(61),
    [anon_sym_LT_LT_DASH] = ACTIONS(61),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(61),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(61),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(61),
    [sym_raw_string] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_AMP] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(67),
    [anon_sym_AMP_GT] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_LT_LT_LT] = ACTIONS(61),
    [anon_sym_GT_AMP] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(61),
    [anon_sym_GT_LPAREN] = ACTIONS(61),
    [sym_ansii_c_string] = ACTIONS(61),
    [anon_sym_AMP_AMP] = ACTIONS(61),
    [anon_sym_SEMI_SEMI] = ACTIONS(61),
    [anon_sym_PIPE_AMP] = ACTIONS(61),
  },
  [381] = {
    [aux_sym__literal_repeat1] = STATE(398),
    [sym_string] = STATE(397),
    [sym_process_substitution] = STATE(397),
    [sym_variable_assignment] = STATE(399),
    [sym_subscript] = STATE(2464),
    [sym_concatenation] = STATE(399),
    [sym_expansion] = STATE(397),
    [sym_command_substitution] = STATE(397),
    [aux_sym_declaration_command_repeat1] = STATE(399),
    [sym_simple_expansion] = STATE(397),
    [sym_string_expansion] = STATE(397),
    [sym_word] = ACTIONS(1920),
    [anon_sym_AMP_GT_GT] = ACTIONS(133),
    [anon_sym_DOLLAR] = ACTIONS(1922),
    [anon_sym_LT_LT] = ACTIONS(133),
    [anon_sym_LT_LPAREN] = ACTIONS(1924),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(133),
    [anon_sym_PIPE] = ACTIONS(133),
    [anon_sym_LT] = ACTIONS(133),
    [anon_sym_LT_AMP] = ACTIONS(133),
    [anon_sym_GT_GT] = ACTIONS(133),
    [sym__special_character] = ACTIONS(1926),
    [anon_sym_LT_LT_DASH] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1928),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1930),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1932),
    [anon_sym_LF] = ACTIONS(147),
    [anon_sym_SEMI] = ACTIONS(133),
    [sym_raw_string] = ACTIONS(1920),
    [sym_variable_name] = ACTIONS(1934),
    [anon_sym_RPAREN] = ACTIONS(133),
    [anon_sym_AMP] = ACTIONS(133),
    [anon_sym_GT] = ACTIONS(133),
    [sym_file_descriptor] = ACTIONS(147),
    [anon_sym_AMP_GT] = ACTIONS(133),
    [anon_sym_DQUOTE] = ACTIONS(1936),
    [anon_sym_LT_LT_LT] = ACTIONS(133),
    [anon_sym_GT_AMP] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(1938),
    [anon_sym_GT_LPAREN] = ACTIONS(1924),
    [sym_ansii_c_string] = ACTIONS(1920),
    [anon_sym_AMP_AMP] = ACTIONS(133),
    [anon_sym_SEMI_SEMI] = ACTIONS(133),
    [anon_sym_PIPE_AMP] = ACTIONS(133),
  },
  [382] = {
    [sym_command_substitution] = STATE(400),
    [aux_sym__literal_repeat1] = STATE(401),
    [sym_string] = STATE(400),
    [aux_sym_unset_command_repeat1] = STATE(402),
    [sym_process_substitution] = STATE(400),
    [sym_simple_expansion] = STATE(400),
    [sym_string_expansion] = STATE(400),
    [sym_concatenation] = STATE(402),
    [sym_expansion] = STATE(400),
    [sym_word] = ACTIONS(1940),
    [anon_sym_AMP_GT_GT] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(1942),
    [anon_sym_LT_LT] = ACTIONS(157),
    [anon_sym_LT_LPAREN] = ACTIONS(1944),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(157),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_AMP] = ACTIONS(157),
    [anon_sym_GT_GT] = ACTIONS(157),
    [sym__special_character] = ACTIONS(1946),
    [anon_sym_LT_LT_DASH] = ACTIONS(157),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1948),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1950),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1952),
    [anon_sym_LF] = ACTIONS(171),
    [anon_sym_SEMI] = ACTIONS(157),
    [sym_raw_string] = ACTIONS(1940),
    [anon_sym_RPAREN] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_GT] = ACTIONS(157),
    [sym_file_descriptor] = ACTIONS(171),
    [anon_sym_AMP_GT] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(1954),
    [anon_sym_LT_LT_LT] = ACTIONS(157),
    [anon_sym_GT_AMP] = ACTIONS(157),
    [anon_sym_BQUOTE] = ACTIONS(1956),
    [anon_sym_GT_LPAREN] = ACTIONS(1944),
    [sym_ansii_c_string] = ACTIONS(1940),
    [anon_sym_AMP_AMP] = ACTIONS(157),
    [anon_sym_SEMI_SEMI] = ACTIONS(157),
    [anon_sym_PIPE_AMP] = ACTIONS(157),
  },
  [383] = {
    [aux_sym_concatenation_repeat1] = STATE(393),
    [sym_word] = ACTIONS(189),
    [anon_sym_AMP_GT_GT] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [anon_sym_LT_LT] = ACTIONS(189),
    [anon_sym_LT_LPAREN] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [sym__concat] = ACTIONS(1918),
    [anon_sym_PIPE] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(189),
    [anon_sym_LT_AMP] = ACTIONS(189),
    [anon_sym_GT_GT] = ACTIONS(189),
    [anon_sym_EQ_TILDE] = ACTIONS(189),
    [sym__special_character] = ACTIONS(189),
    [anon_sym_LT_LT_DASH] = ACTIONS(189),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(189),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(189),
    [anon_sym_RPAREN] = ACTIONS(189),
    [anon_sym_AMP] = ACTIONS(189),
    [anon_sym_GT] = ACTIONS(189),
    [sym_file_descriptor] = ACTIONS(191),
    [anon_sym_AMP_GT] = ACTIONS(189),
    [anon_sym_EQ_EQ] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_LT_LT_LT] = ACTIONS(189),
    [anon_sym_GT_AMP] = ACTIONS(189),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [anon_sym_GT_LPAREN] = ACTIONS(189),
    [sym_ansii_c_string] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_SEMI_SEMI] = ACTIONS(189),
    [anon_sym_PIPE_AMP] = ACTIONS(189),
  },
  [384] = {
    [aux_sym_concatenation_repeat1] = STATE(393),
    [sym_word] = ACTIONS(61),
    [anon_sym_AMP_GT_GT] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_LT_LT] = ACTIONS(61),
    [anon_sym_LT_LPAREN] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [sym__concat] = ACTIONS(1918),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_LT_AMP] = ACTIONS(61),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_EQ_TILDE] = ACTIONS(61),
    [sym__special_character] = ACTIONS(61),
    [anon_sym_LT_LT_DASH] = ACTIONS(61),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(61),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(61),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(61),
    [sym_raw_string] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_AMP] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(67),
    [anon_sym_AMP_GT] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_LT_LT_LT] = ACTIONS(61),
    [anon_sym_GT_AMP] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(61),
    [anon_sym_GT_LPAREN] = ACTIONS(61),
    [sym_ansii_c_string] = ACTIONS(61),
    [anon_sym_AMP_AMP] = ACTIONS(61),
    [anon_sym_SEMI_SEMI] = ACTIONS(61),
    [anon_sym_PIPE_AMP] = ACTIONS(61),
  },
  [385] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [sym_test_command] = STATE(410),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_subscript] = STATE(2455),
    [sym_variable_assignment] = STATE(391),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_command] = STATE(410),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_subshell] = STATE(410),
    [sym_file_redirect] = STATE(391),
    [anon_sym_LPAREN] = ACTIONS(71),
    [sym_word] = ACTIONS(93),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [sym_variable_name] = ACTIONS(243),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [386] = {
    [aux_sym__literal_repeat1] = STATE(413),
    [sym_word] = ACTIONS(299),
    [anon_sym_AMP_GT_GT] = ACTIONS(299),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_LT_LT] = ACTIONS(299),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(299),
    [anon_sym_PIPE] = ACTIONS(299),
    [anon_sym_LT] = ACTIONS(299),
    [anon_sym_LT_AMP] = ACTIONS(299),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_EQ_TILDE] = ACTIONS(299),
    [sym__special_character] = ACTIONS(1958),
    [anon_sym_LT_LT_DASH] = ACTIONS(299),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(299),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(299),
    [anon_sym_LF] = ACTIONS(303),
    [anon_sym_SEMI] = ACTIONS(299),
    [sym_raw_string] = ACTIONS(299),
    [anon_sym_RPAREN] = ACTIONS(299),
    [anon_sym_AMP] = ACTIONS(299),
    [anon_sym_GT] = ACTIONS(299),
    [sym_file_descriptor] = ACTIONS(303),
    [anon_sym_AMP_GT] = ACTIONS(299),
    [anon_sym_EQ_EQ] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [anon_sym_LT_LT_LT] = ACTIONS(299),
    [anon_sym_GT_AMP] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_ansii_c_string] = ACTIONS(299),
    [anon_sym_AMP_AMP] = ACTIONS(299),
    [anon_sym_SEMI_SEMI] = ACTIONS(299),
    [anon_sym_PIPE_AMP] = ACTIONS(299),
  },
  [387] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [anon_sym_SEMI_SEMI] = ACTIONS(1960),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LF] = ACTIONS(1962),
    [anon_sym_SEMI] = ACTIONS(1960),
    [anon_sym_RPAREN] = ACTIONS(1964),
    [sym_file_descriptor] = ACTIONS(439),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_AMP] = ACTIONS(1960),
    [anon_sym_AMP_GT] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [388] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(1962),
    [anon_sym_SEMI] = ACTIONS(1960),
    [sym_variable_name] = ACTIONS(325),
    [anon_sym_RPAREN] = ACTIONS(1964),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP] = ACTIONS(1960),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_SEMI_SEMI] = ACTIONS(1960),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [389] = {
    [sym_word] = ACTIONS(61),
    [anon_sym_AMP_GT_GT] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_LT_LT] = ACTIONS(61),
    [anon_sym_LT_LPAREN] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_LT_AMP] = ACTIONS(61),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_EQ_TILDE] = ACTIONS(61),
    [sym__special_character] = ACTIONS(61),
    [anon_sym_LT_LT_DASH] = ACTIONS(61),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(61),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(61),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(61),
    [sym_raw_string] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_AMP] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(67),
    [anon_sym_AMP_GT] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_LT_LT_LT] = ACTIONS(61),
    [anon_sym_GT_AMP] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(61),
    [anon_sym_GT_LPAREN] = ACTIONS(61),
    [sym_ansii_c_string] = ACTIONS(61),
    [anon_sym_AMP_AMP] = ACTIONS(61),
    [anon_sym_SEMI_SEMI] = ACTIONS(61),
    [anon_sym_PIPE_AMP] = ACTIONS(61),
  },
  [390] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(419),
    [sym_function_definition] = STATE(419),
    [sym_negated_command] = STATE(419),
    [sym_test_command] = STATE(419),
    [sym_variable_assignment] = STATE(420),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(101),
    [sym_redirected_statement] = STATE(419),
    [sym_for_statement] = STATE(419),
    [sym_compound_statement] = STATE(419),
    [sym_subshell] = STATE(419),
    [sym_declaration_command] = STATE(419),
    [sym_unset_command] = STATE(419),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_c_style_for_statement] = STATE(419),
    [sym_while_statement] = STATE(419),
    [sym_case_statement] = STATE(419),
    [sym_pipeline] = STATE(419),
    [sym_list] = STATE(419),
    [sym_command] = STATE(419),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [391] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [sym_variable_assignment] = STATE(103),
    [sym_subscript] = STATE(2455),
    [aux_sym_command_repeat1] = STATE(103),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_command_name] = STATE(422),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_file_redirect] = STATE(103),
    [sym_word] = ACTIONS(93),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [sym__special_character] = ACTIONS(1966),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [sym_raw_string] = ACTIONS(93),
    [sym_variable_name] = ACTIONS(243),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [sym_ansii_c_string] = ACTIONS(93),
  },
  [392] = {
    [sym_command_substitution] = STATE(423),
    [aux_sym__literal_repeat1] = STATE(425),
    [sym_string] = STATE(423),
    [sym_process_substitution] = STATE(423),
    [sym_simple_expansion] = STATE(423),
    [sym_string_expansion] = STATE(423),
    [aux_sym_command_repeat2] = STATE(426),
    [sym_concatenation] = STATE(426),
    [sym_expansion] = STATE(423),
    [sym_word] = ACTIONS(1968),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LT] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(1970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(1972),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1974),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1976),
    [anon_sym_LF] = ACTIONS(345),
    [anon_sym_SEMI] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(1968),
    [anon_sym_RPAREN] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(345),
    [anon_sym_AMP_GT] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(1972),
    [anon_sym_DQUOTE] = ACTIONS(1978),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(1980),
    [anon_sym_GT_LPAREN] = ACTIONS(1970),
    [sym_ansii_c_string] = ACTIONS(1968),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
  },
  [393] = {
    [aux_sym_concatenation_repeat1] = STATE(429),
    [sym_word] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LPAREN] = ACTIONS(355),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [sym__concat] = ACTIONS(1982),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_LT_AMP] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(355),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [sym__special_character] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(355),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(355),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(355),
    [sym_raw_string] = ACTIONS(355),
    [anon_sym_RPAREN] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [sym_file_descriptor] = ACTIONS(359),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_LT_LT_LT] = ACTIONS(355),
    [anon_sym_GT_AMP] = ACTIONS(355),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_GT_LPAREN] = ACTIONS(355),
    [sym_ansii_c_string] = ACTIONS(355),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(355),
    [anon_sym_PIPE_AMP] = ACTIONS(355),
  },
  [394] = {
    [aux_sym_concatenation_repeat1] = STATE(1001),
    [anon_sym_LT_LT_DASH] = ACTIONS(365),
    [anon_sym_AMP_GT_GT] = ACTIONS(365),
    [anon_sym_LF] = ACTIONS(363),
    [anon_sym_SEMI] = ACTIONS(365),
    [anon_sym_LT_LT] = ACTIONS(365),
    [anon_sym_AMP] = ACTIONS(365),
    [anon_sym_GT] = ACTIONS(365),
    [sym_file_descriptor] = ACTIONS(363),
    [anon_sym_AMP_GT] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(365),
    [ts_builtin_sym_end] = ACTIONS(363),
    [anon_sym_LT_LT_LT] = ACTIONS(365),
    [anon_sym_PIPE] = ACTIONS(365),
    [anon_sym_GT_AMP] = ACTIONS(365),
    [anon_sym_LT] = ACTIONS(365),
    [anon_sym_LT_AMP] = ACTIONS(365),
    [anon_sym_GT_GT] = ACTIONS(365),
    [sym__concat] = ACTIONS(1131),
    [anon_sym_AMP_AMP] = ACTIONS(365),
    [anon_sym_SEMI_SEMI] = ACTIONS(365),
    [anon_sym_PIPE_AMP] = ACTIONS(365),
  },
  [395] = {
    [aux_sym__literal_repeat1] = STATE(1039),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LF] = ACTIONS(369),
    [anon_sym_SEMI] = ACTIONS(371),
    [anon_sym_LT_LT] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [sym_file_descriptor] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [ts_builtin_sym_end] = ACTIONS(369),
    [anon_sym_LT_LT_LT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [sym__special_character] = ACTIONS(1137),
    [anon_sym_SEMI_SEMI] = ACTIONS(371),
    [anon_sym_PIPE_AMP] = ACTIONS(371),
  },
  [396] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(365),
    [anon_sym_AMP_GT_GT] = ACTIONS(365),
    [anon_sym_LF] = ACTIONS(363),
    [anon_sym_SEMI] = ACTIONS(365),
    [anon_sym_LT_LT] = ACTIONS(365),
    [anon_sym_AMP] = ACTIONS(365),
    [anon_sym_GT] = ACTIONS(365),
    [sym_file_descriptor] = ACTIONS(363),
    [anon_sym_AMP_GT] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(365),
    [ts_builtin_sym_end] = ACTIONS(363),
    [anon_sym_LT_LT_LT] = ACTIONS(365),
    [anon_sym_PIPE] = ACTIONS(365),
    [anon_sym_GT_AMP] = ACTIONS(365),
    [anon_sym_LT] = ACTIONS(365),
    [anon_sym_LT_AMP] = ACTIONS(365),
    [anon_sym_GT_GT] = ACTIONS(365),
    [anon_sym_AMP_AMP] = ACTIONS(365),
    [anon_sym_SEMI_SEMI] = ACTIONS(365),
    [anon_sym_PIPE_AMP] = ACTIONS(365),
  },
  [397] = {
    [aux_sym_concatenation_repeat1] = STATE(841),
    [sym_word] = ACTIONS(375),
    [anon_sym_AMP_GT_GT] = ACTIONS(375),
    [anon_sym_DOLLAR] = ACTIONS(375),
    [anon_sym_LT_LT] = ACTIONS(375),
    [anon_sym_LT_LPAREN] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(375),
    [sym__concat] = ACTIONS(1984),
    [anon_sym_PIPE] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(375),
    [anon_sym_LT_AMP] = ACTIONS(375),
    [anon_sym_GT_GT] = ACTIONS(375),
    [sym__special_character] = ACTIONS(375),
    [anon_sym_LT_LT_DASH] = ACTIONS(375),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(375),
    [aux_sym__simple_variable_name_token1] = ACTIONS(375),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(375),
    [anon_sym_LF] = ACTIONS(379),
    [anon_sym_SEMI] = ACTIONS(375),
    [sym_raw_string] = ACTIONS(375),
    [sym_variable_name] = ACTIONS(379),
    [anon_sym_RPAREN] = ACTIONS(375),
    [anon_sym_AMP] = ACTIONS(375),
    [anon_sym_GT] = ACTIONS(375),
    [sym_file_descriptor] = ACTIONS(379),
    [anon_sym_AMP_GT] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [anon_sym_LT_LT_LT] = ACTIONS(375),
    [anon_sym_GT_AMP] = ACTIONS(375),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [anon_sym_GT_LPAREN] = ACTIONS(375),
    [sym_ansii_c_string] = ACTIONS(375),
    [anon_sym_AMP_AMP] = ACTIONS(375),
    [anon_sym_SEMI_SEMI] = ACTIONS(375),
    [anon_sym_PIPE_AMP] = ACTIONS(375),
  },
  [398] = {
    [aux_sym__literal_repeat1] = STATE(847),
    [sym_word] = ACTIONS(381),
    [anon_sym_AMP_GT_GT] = ACTIONS(381),
    [anon_sym_DOLLAR] = ACTIONS(381),
    [anon_sym_LT_LT] = ACTIONS(381),
    [anon_sym_LT_LPAREN] = ACTIONS(381),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(381),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_LT_AMP] = ACTIONS(381),
    [anon_sym_GT_GT] = ACTIONS(381),
    [sym__special_character] = ACTIONS(1986),
    [anon_sym_LT_LT_DASH] = ACTIONS(381),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(381),
    [aux_sym__simple_variable_name_token1] = ACTIONS(381),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(381),
    [anon_sym_LF] = ACTIONS(385),
    [anon_sym_SEMI] = ACTIONS(381),
    [sym_raw_string] = ACTIONS(381),
    [sym_variable_name] = ACTIONS(385),
    [anon_sym_RPAREN] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_GT] = ACTIONS(381),
    [sym_file_descriptor] = ACTIONS(385),
    [anon_sym_AMP_GT] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [anon_sym_LT_LT_LT] = ACTIONS(381),
    [anon_sym_GT_AMP] = ACTIONS(381),
    [anon_sym_BQUOTE] = ACTIONS(381),
    [anon_sym_GT_LPAREN] = ACTIONS(381),
    [sym_ansii_c_string] = ACTIONS(381),
    [anon_sym_AMP_AMP] = ACTIONS(381),
    [anon_sym_SEMI_SEMI] = ACTIONS(381),
    [anon_sym_PIPE_AMP] = ACTIONS(381),
  },
  [399] = {
    [aux_sym__literal_repeat1] = STATE(398),
    [sym_string] = STATE(397),
    [sym_process_substitution] = STATE(397),
    [sym_variable_assignment] = STATE(431),
    [sym_subscript] = STATE(2464),
    [sym_concatenation] = STATE(431),
    [sym_expansion] = STATE(397),
    [sym_command_substitution] = STATE(397),
    [aux_sym_declaration_command_repeat1] = STATE(431),
    [sym_simple_expansion] = STATE(397),
    [sym_string_expansion] = STATE(397),
    [sym_word] = ACTIONS(1920),
    [anon_sym_AMP_GT_GT] = ACTIONS(387),
    [anon_sym_DOLLAR] = ACTIONS(1922),
    [anon_sym_LT_LT] = ACTIONS(387),
    [anon_sym_LT_LPAREN] = ACTIONS(1924),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_PIPE] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(387),
    [anon_sym_LT_AMP] = ACTIONS(387),
    [anon_sym_GT_GT] = ACTIONS(387),
    [sym__special_character] = ACTIONS(1926),
    [anon_sym_LT_LT_DASH] = ACTIONS(387),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1928),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1988),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1932),
    [anon_sym_LF] = ACTIONS(391),
    [anon_sym_SEMI] = ACTIONS(387),
    [sym_raw_string] = ACTIONS(1920),
    [sym_variable_name] = ACTIONS(1934),
    [anon_sym_RPAREN] = ACTIONS(387),
    [anon_sym_AMP] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(387),
    [sym_file_descriptor] = ACTIONS(391),
    [anon_sym_AMP_GT] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(1936),
    [anon_sym_LT_LT_LT] = ACTIONS(387),
    [anon_sym_GT_AMP] = ACTIONS(387),
    [anon_sym_BQUOTE] = ACTIONS(1938),
    [anon_sym_GT_LPAREN] = ACTIONS(1924),
    [sym_ansii_c_string] = ACTIONS(1920),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_SEMI_SEMI] = ACTIONS(387),
    [anon_sym_PIPE_AMP] = ACTIONS(387),
  },
  [400] = {
    [aux_sym_concatenation_repeat1] = STATE(873),
    [sym_word] = ACTIONS(393),
    [anon_sym_AMP_GT_GT] = ACTIONS(393),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [anon_sym_LT_LT] = ACTIONS(393),
    [anon_sym_LT_LPAREN] = ACTIONS(393),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(393),
    [sym__concat] = ACTIONS(1990),
    [anon_sym_PIPE] = ACTIONS(393),
    [anon_sym_LT] = ACTIONS(393),
    [anon_sym_LT_AMP] = ACTIONS(393),
    [anon_sym_GT_GT] = ACTIONS(393),
    [sym__special_character] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(393),
    [aux_sym__simple_variable_name_token1] = ACTIONS(393),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(393),
    [anon_sym_LF] = ACTIONS(397),
    [anon_sym_SEMI] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(393),
    [anon_sym_RPAREN] = ACTIONS(393),
    [anon_sym_AMP] = ACTIONS(393),
    [anon_sym_GT] = ACTIONS(393),
    [sym_file_descriptor] = ACTIONS(397),
    [anon_sym_AMP_GT] = ACTIONS(393),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_LT_LT_LT] = ACTIONS(393),
    [anon_sym_GT_AMP] = ACTIONS(393),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [anon_sym_GT_LPAREN] = ACTIONS(393),
    [sym_ansii_c_string] = ACTIONS(393),
    [anon_sym_AMP_AMP] = ACTIONS(393),
    [anon_sym_SEMI_SEMI] = ACTIONS(393),
    [anon_sym_PIPE_AMP] = ACTIONS(393),
  },
  [401] = {
    [aux_sym__literal_repeat1] = STATE(879),
    [sym_word] = ACTIONS(399),
    [anon_sym_AMP_GT_GT] = ACTIONS(399),
    [anon_sym_DOLLAR] = ACTIONS(399),
    [anon_sym_LT_LT] = ACTIONS(399),
    [anon_sym_LT_LPAREN] = ACTIONS(399),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_PIPE] = ACTIONS(399),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_LT_AMP] = ACTIONS(399),
    [anon_sym_GT_GT] = ACTIONS(399),
    [sym__special_character] = ACTIONS(1992),
    [anon_sym_LT_LT_DASH] = ACTIONS(399),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [aux_sym__simple_variable_name_token1] = ACTIONS(399),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(399),
    [anon_sym_LF] = ACTIONS(403),
    [anon_sym_SEMI] = ACTIONS(399),
    [sym_raw_string] = ACTIONS(399),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_GT] = ACTIONS(399),
    [sym_file_descriptor] = ACTIONS(403),
    [anon_sym_AMP_GT] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_LT_LT_LT] = ACTIONS(399),
    [anon_sym_GT_AMP] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(399),
    [anon_sym_GT_LPAREN] = ACTIONS(399),
    [sym_ansii_c_string] = ACTIONS(399),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_SEMI_SEMI] = ACTIONS(399),
    [anon_sym_PIPE_AMP] = ACTIONS(399),
  },
  [402] = {
    [sym_command_substitution] = STATE(400),
    [aux_sym__literal_repeat1] = STATE(401),
    [sym_string] = STATE(400),
    [aux_sym_unset_command_repeat1] = STATE(432),
    [sym_process_substitution] = STATE(400),
    [sym_simple_expansion] = STATE(400),
    [sym_string_expansion] = STATE(400),
    [sym_concatenation] = STATE(432),
    [sym_expansion] = STATE(400),
    [sym_word] = ACTIONS(1940),
    [anon_sym_AMP_GT_GT] = ACTIONS(405),
    [anon_sym_DOLLAR] = ACTIONS(1942),
    [anon_sym_LT_LT] = ACTIONS(405),
    [anon_sym_LT_LPAREN] = ACTIONS(1944),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(405),
    [anon_sym_PIPE] = ACTIONS(405),
    [anon_sym_LT] = ACTIONS(405),
    [anon_sym_LT_AMP] = ACTIONS(405),
    [anon_sym_GT_GT] = ACTIONS(405),
    [sym__special_character] = ACTIONS(1946),
    [anon_sym_LT_LT_DASH] = ACTIONS(405),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1948),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1994),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1952),
    [anon_sym_LF] = ACTIONS(409),
    [anon_sym_SEMI] = ACTIONS(405),
    [sym_raw_string] = ACTIONS(1940),
    [anon_sym_RPAREN] = ACTIONS(405),
    [anon_sym_AMP] = ACTIONS(405),
    [anon_sym_GT] = ACTIONS(405),
    [sym_file_descriptor] = ACTIONS(409),
    [anon_sym_AMP_GT] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(1954),
    [anon_sym_LT_LT_LT] = ACTIONS(405),
    [anon_sym_GT_AMP] = ACTIONS(405),
    [anon_sym_BQUOTE] = ACTIONS(1956),
    [anon_sym_GT_LPAREN] = ACTIONS(1944),
    [sym_ansii_c_string] = ACTIONS(1940),
    [anon_sym_AMP_AMP] = ACTIONS(405),
    [anon_sym_SEMI_SEMI] = ACTIONS(405),
    [anon_sym_PIPE_AMP] = ACTIONS(405),
  },
  [403] = {
    [sym_word] = ACTIONS(411),
    [anon_sym_AMP_GT_GT] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(411),
    [anon_sym_LT_LT] = ACTIONS(411),
    [anon_sym_LT_LPAREN] = ACTIONS(411),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(411),
    [sym__concat] = ACTIONS(413),
    [anon_sym_PIPE] = ACTIONS(411),
    [anon_sym_LT] = ACTIONS(411),
    [anon_sym_LT_AMP] = ACTIONS(411),
    [anon_sym_GT_GT] = ACTIONS(411),
    [anon_sym_EQ_TILDE] = ACTIONS(411),
    [sym__special_character] = ACTIONS(411),
    [anon_sym_LT_LT_DASH] = ACTIONS(411),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(411),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(411),
    [anon_sym_LF] = ACTIONS(413),
    [anon_sym_SEMI] = ACTIONS(411),
    [sym_raw_string] = ACTIONS(411),
    [anon_sym_RPAREN] = ACTIONS(411),
    [anon_sym_AMP] = ACTIONS(411),
    [anon_sym_GT] = ACTIONS(411),
    [sym_file_descriptor] = ACTIONS(413),
    [anon_sym_AMP_GT] = ACTIONS(411),
    [anon_sym_EQ_EQ] = ACTIONS(411),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_LT_LT_LT] = ACTIONS(411),
    [anon_sym_GT_AMP] = ACTIONS(411),
    [anon_sym_BQUOTE] = ACTIONS(411),
    [anon_sym_GT_LPAREN] = ACTIONS(411),
    [sym_ansii_c_string] = ACTIONS(411),
    [anon_sym_AMP_AMP] = ACTIONS(411),
    [anon_sym_SEMI_SEMI] = ACTIONS(411),
    [anon_sym_PIPE_AMP] = ACTIONS(411),
  },
  [404] = {
    [sym_word] = ACTIONS(415),
    [anon_sym_AMP_GT_GT] = ACTIONS(415),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LPAREN] = ACTIONS(415),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(415),
    [sym__concat] = ACTIONS(417),
    [anon_sym_PIPE] = ACTIONS(415),
    [anon_sym_LT] = ACTIONS(415),
    [anon_sym_LT_AMP] = ACTIONS(415),
    [anon_sym_GT_GT] = ACTIONS(415),
    [anon_sym_EQ_TILDE] = ACTIONS(415),
    [sym__special_character] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(415),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(415),
    [anon_sym_LF] = ACTIONS(417),
    [anon_sym_SEMI] = ACTIONS(415),
    [sym_raw_string] = ACTIONS(415),
    [anon_sym_RPAREN] = ACTIONS(415),
    [anon_sym_AMP] = ACTIONS(415),
    [anon_sym_GT] = ACTIONS(415),
    [sym_file_descriptor] = ACTIONS(417),
    [anon_sym_AMP_GT] = ACTIONS(415),
    [anon_sym_EQ_EQ] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [anon_sym_LT_LT_LT] = ACTIONS(415),
    [anon_sym_GT_AMP] = ACTIONS(415),
    [anon_sym_BQUOTE] = ACTIONS(415),
    [anon_sym_GT_LPAREN] = ACTIONS(415),
    [sym_ansii_c_string] = ACTIONS(415),
    [anon_sym_AMP_AMP] = ACTIONS(415),
    [anon_sym_SEMI_SEMI] = ACTIONS(415),
    [anon_sym_PIPE_AMP] = ACTIONS(415),
  },
  [405] = {
    [sym_word] = ACTIONS(419),
    [anon_sym_AMP_GT_GT] = ACTIONS(419),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_LT_LT] = ACTIONS(419),
    [anon_sym_LT_LPAREN] = ACTIONS(419),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(419),
    [sym__concat] = ACTIONS(421),
    [anon_sym_PIPE] = ACTIONS(419),
    [anon_sym_LT] = ACTIONS(419),
    [anon_sym_LT_AMP] = ACTIONS(419),
    [anon_sym_GT_GT] = ACTIONS(419),
    [anon_sym_EQ_TILDE] = ACTIONS(419),
    [sym__special_character] = ACTIONS(419),
    [anon_sym_LT_LT_DASH] = ACTIONS(419),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(419),
    [anon_sym_LF] = ACTIONS(421),
    [anon_sym_SEMI] = ACTIONS(419),
    [sym_raw_string] = ACTIONS(419),
    [anon_sym_RPAREN] = ACTIONS(419),
    [anon_sym_AMP] = ACTIONS(419),
    [anon_sym_GT] = ACTIONS(419),
    [sym_file_descriptor] = ACTIONS(421),
    [anon_sym_AMP_GT] = ACTIONS(419),
    [anon_sym_EQ_EQ] = ACTIONS(419),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [anon_sym_LT_LT_LT] = ACTIONS(419),
    [anon_sym_GT_AMP] = ACTIONS(419),
    [anon_sym_BQUOTE] = ACTIONS(419),
    [anon_sym_GT_LPAREN] = ACTIONS(419),
    [sym_ansii_c_string] = ACTIONS(419),
    [anon_sym_AMP_AMP] = ACTIONS(419),
    [anon_sym_SEMI_SEMI] = ACTIONS(419),
    [anon_sym_PIPE_AMP] = ACTIONS(419),
  },
  [406] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(427),
    [anon_sym_LT_LT] = ACTIONS(427),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [anon_sym_PIPE] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(427),
    [anon_sym_LT_AMP] = ACTIONS(427),
    [anon_sym_GT_GT] = ACTIONS(427),
    [anon_sym_LT_LT_DASH] = ACTIONS(427),
    [anon_sym_LF] = ACTIONS(429),
    [anon_sym_SEMI] = ACTIONS(427),
    [anon_sym_RPAREN] = ACTIONS(427),
    [anon_sym_AMP] = ACTIONS(427),
    [anon_sym_GT] = ACTIONS(427),
    [sym_file_descriptor] = ACTIONS(429),
    [anon_sym_AMP_GT] = ACTIONS(427),
    [anon_sym_LT_LT_LT] = ACTIONS(427),
    [anon_sym_GT_AMP] = ACTIONS(427),
    [anon_sym_BQUOTE] = ACTIONS(427),
    [anon_sym_esac] = ACTIONS(427),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_SEMI_SEMI] = ACTIONS(427),
    [anon_sym_PIPE_AMP] = ACTIONS(427),
  },
  [407] = {
    [aux_sym_concatenation_repeat1] = STATE(809),
    [anon_sym_BANG_EQ] = ACTIONS(471),
    [anon_sym_PLUS_EQ] = ACTIONS(471),
    [anon_sym_PLUS_PLUS] = ACTIONS(471),
    [anon_sym_RBRACK] = ACTIONS(471),
    [anon_sym_DASH] = ACTIONS(473),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_EQ] = ACTIONS(473),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(471),
    [anon_sym_PIPE_PIPE] = ACTIONS(471),
    [anon_sym_GT_EQ] = ACTIONS(471),
    [sym__concat] = ACTIONS(1996),
    [anon_sym_PLUS] = ACTIONS(473),
    [anon_sym_LT] = ACTIONS(473),
    [sym_test_operator] = ACTIONS(471),
    [anon_sym_EQ_TILDE] = ACTIONS(471),
    [anon_sym_DASH_DASH] = ACTIONS(471),
    [anon_sym_LT_EQ] = ACTIONS(471),
    [anon_sym_AMP_AMP] = ACTIONS(471),
    [anon_sym_DASH_EQ] = ACTIONS(471),
  },
  [408] = {
    [sym_command_substitution] = STATE(407),
    [sym_unary_expression] = STATE(438),
    [sym_postfix_expression] = STATE(438),
    [sym_string] = STATE(407),
    [aux_sym__literal_repeat1] = STATE(409),
    [sym_process_substitution] = STATE(407),
    [sym_parenthesized_expression] = STATE(438),
    [sym_simple_expansion] = STATE(407),
    [sym_string_expansion] = STATE(407),
    [sym__expression] = STATE(438),
    [sym_binary_expression] = STATE(438),
    [sym_concatenation] = STATE(438),
    [sym_expansion] = STATE(407),
    [sym_word] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(277),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(279),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(281),
    [sym_raw_string] = ACTIONS(283),
    [anon_sym_BANG] = ACTIONS(285),
    [anon_sym_DOLLAR] = ACTIONS(287),
    [anon_sym_LT_LPAREN] = ACTIONS(289),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [sym_test_operator] = ACTIONS(293),
    [anon_sym_BQUOTE] = ACTIONS(295),
    [anon_sym_GT_LPAREN] = ACTIONS(289),
    [sym_ansii_c_string] = ACTIONS(283),
    [sym__special_character] = ACTIONS(297),
  },
  [409] = {
    [aux_sym__literal_repeat1] = STATE(815),
    [anon_sym_BANG_EQ] = ACTIONS(477),
    [anon_sym_PLUS_EQ] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(477),
    [anon_sym_RBRACK] = ACTIONS(477),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(479),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(479),
    [sym_test_operator] = ACTIONS(477),
    [anon_sym_EQ_TILDE] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(477),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [anon_sym_AMP_AMP] = ACTIONS(477),
    [sym__special_character] = ACTIONS(1998),
    [anon_sym_DASH_EQ] = ACTIONS(477),
  },
  [410] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(539),
    [anon_sym_LT_LT] = ACTIONS(539),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(539),
    [anon_sym_PIPE] = ACTIONS(539),
    [anon_sym_LT] = ACTIONS(539),
    [anon_sym_LT_AMP] = ACTIONS(539),
    [anon_sym_GT_GT] = ACTIONS(539),
    [anon_sym_LT_LT_DASH] = ACTIONS(539),
    [anon_sym_LF] = ACTIONS(541),
    [anon_sym_SEMI] = ACTIONS(539),
    [anon_sym_RPAREN] = ACTIONS(539),
    [anon_sym_AMP] = ACTIONS(539),
    [anon_sym_GT] = ACTIONS(539),
    [sym_file_descriptor] = ACTIONS(541),
    [anon_sym_AMP_GT] = ACTIONS(539),
    [anon_sym_LT_LT_LT] = ACTIONS(539),
    [anon_sym_GT_AMP] = ACTIONS(539),
    [anon_sym_BQUOTE] = ACTIONS(539),
    [anon_sym_esac] = ACTIONS(539),
    [anon_sym_AMP_AMP] = ACTIONS(539),
    [anon_sym_SEMI_SEMI] = ACTIONS(539),
    [anon_sym_PIPE_AMP] = ACTIONS(539),
  },
  [411] = {
    [sym_word] = ACTIONS(579),
    [anon_sym_AMP_GT_GT] = ACTIONS(579),
    [anon_sym_DOLLAR] = ACTIONS(579),
    [anon_sym_LT_LT] = ACTIONS(579),
    [anon_sym_LT_LPAREN] = ACTIONS(579),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(579),
    [sym__concat] = ACTIONS(581),
    [anon_sym_PIPE] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(579),
    [anon_sym_LT_AMP] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(579),
    [anon_sym_EQ_TILDE] = ACTIONS(579),
    [sym__special_character] = ACTIONS(579),
    [anon_sym_LT_LT_DASH] = ACTIONS(579),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(579),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(579),
    [anon_sym_LF] = ACTIONS(581),
    [anon_sym_SEMI] = ACTIONS(579),
    [sym_raw_string] = ACTIONS(579),
    [anon_sym_RPAREN] = ACTIONS(579),
    [anon_sym_AMP] = ACTIONS(579),
    [anon_sym_GT] = ACTIONS(579),
    [sym_file_descriptor] = ACTIONS(581),
    [anon_sym_AMP_GT] = ACTIONS(579),
    [anon_sym_EQ_EQ] = ACTIONS(579),
    [anon_sym_DQUOTE] = ACTIONS(579),
    [anon_sym_LT_LT_LT] = ACTIONS(579),
    [anon_sym_GT_AMP] = ACTIONS(579),
    [anon_sym_BQUOTE] = ACTIONS(579),
    [anon_sym_GT_LPAREN] = ACTIONS(579),
    [sym_ansii_c_string] = ACTIONS(579),
    [anon_sym_AMP_AMP] = ACTIONS(579),
    [anon_sym_SEMI_SEMI] = ACTIONS(579),
    [anon_sym_PIPE_AMP] = ACTIONS(579),
  },
  [412] = {
    [sym_word] = ACTIONS(189),
    [anon_sym_AMP_GT_GT] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [anon_sym_LT_LT] = ACTIONS(189),
    [anon_sym_LT_LPAREN] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_PIPE] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(189),
    [anon_sym_LT_AMP] = ACTIONS(189),
    [anon_sym_GT_GT] = ACTIONS(189),
    [anon_sym_EQ_TILDE] = ACTIONS(189),
    [sym__special_character] = ACTIONS(189),
    [anon_sym_LT_LT_DASH] = ACTIONS(189),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(189),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(189),
    [anon_sym_RPAREN] = ACTIONS(189),
    [anon_sym_AMP] = ACTIONS(189),
    [anon_sym_GT] = ACTIONS(189),
    [sym_file_descriptor] = ACTIONS(191),
    [anon_sym_AMP_GT] = ACTIONS(189),
    [anon_sym_EQ_EQ] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_LT_LT_LT] = ACTIONS(189),
    [anon_sym_GT_AMP] = ACTIONS(189),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [anon_sym_GT_LPAREN] = ACTIONS(189),
    [sym_ansii_c_string] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_SEMI_SEMI] = ACTIONS(189),
    [anon_sym_PIPE_AMP] = ACTIONS(189),
  },
  [413] = {
    [aux_sym__literal_repeat1] = STATE(413),
    [sym_word] = ACTIONS(629),
    [anon_sym_AMP_GT_GT] = ACTIONS(629),
    [anon_sym_DOLLAR] = ACTIONS(629),
    [anon_sym_LT_LT] = ACTIONS(629),
    [anon_sym_LT_LPAREN] = ACTIONS(629),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(629),
    [anon_sym_PIPE] = ACTIONS(629),
    [anon_sym_LT] = ACTIONS(629),
    [anon_sym_LT_AMP] = ACTIONS(629),
    [anon_sym_GT_GT] = ACTIONS(629),
    [anon_sym_EQ_TILDE] = ACTIONS(629),
    [sym__special_character] = ACTIONS(2000),
    [anon_sym_LT_LT_DASH] = ACTIONS(629),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(629),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(629),
    [anon_sym_LF] = ACTIONS(634),
    [anon_sym_SEMI] = ACTIONS(629),
    [sym_raw_string] = ACTIONS(629),
    [anon_sym_RPAREN] = ACTIONS(629),
    [anon_sym_AMP] = ACTIONS(629),
    [anon_sym_GT] = ACTIONS(629),
    [sym_file_descriptor] = ACTIONS(634),
    [anon_sym_AMP_GT] = ACTIONS(629),
    [anon_sym_EQ_EQ] = ACTIONS(629),
    [anon_sym_DQUOTE] = ACTIONS(629),
    [anon_sym_LT_LT_LT] = ACTIONS(629),
    [anon_sym_GT_AMP] = ACTIONS(629),
    [anon_sym_BQUOTE] = ACTIONS(629),
    [anon_sym_GT_LPAREN] = ACTIONS(629),
    [sym_ansii_c_string] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(629),
    [anon_sym_SEMI_SEMI] = ACTIONS(629),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
  },
  [414] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(455),
    [sym_function_definition] = STATE(455),
    [sym_negated_command] = STATE(455),
    [sym_test_command] = STATE(455),
    [sym_variable_assignment] = STATE(456),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(455),
    [sym_for_statement] = STATE(455),
    [sym_compound_statement] = STATE(455),
    [sym_subshell] = STATE(455),
    [sym_declaration_command] = STATE(455),
    [sym_unset_command] = STATE(455),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_c_style_for_statement] = STATE(455),
    [sym_while_statement] = STATE(455),
    [sym_case_statement] = STATE(455),
    [sym_pipeline] = STATE(455),
    [sym_list] = STATE(455),
    [sym_command] = STATE(455),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [415] = {
    [sym_heredoc_body] = STATE(458),
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__simple_heredoc_body] = ACTIONS(870),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [anon_sym_RPAREN] = ACTIONS(644),
    [sym_file_descriptor] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [sym__heredoc_body_beginning] = ACTIONS(872),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [416] = {
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_declare] = ACTIONS(636),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_RPAREN] = ACTIONS(644),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_SEMI_SEMI] = ACTIONS(644),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [sym_file_descriptor] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [417] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(460),
    [sym_function_definition] = STATE(460),
    [sym_negated_command] = STATE(460),
    [sym_test_command] = STATE(460),
    [sym_variable_assignment] = STATE(461),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(460),
    [sym_for_statement] = STATE(460),
    [sym_compound_statement] = STATE(460),
    [sym_subshell] = STATE(460),
    [sym_declaration_command] = STATE(460),
    [sym_unset_command] = STATE(460),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_c_style_for_statement] = STATE(460),
    [sym_while_statement] = STATE(460),
    [sym_case_statement] = STATE(460),
    [sym_pipeline] = STATE(460),
    [sym_list] = STATE(460),
    [sym_command] = STATE(460),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_typeset] = ACTIONS(73),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(73),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(73),
    [sym_variable_name] = ACTIONS(99),
    [anon_sym_readonly] = ACTIONS(73),
    [anon_sym_unset] = ACTIONS(75),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_local] = ACTIONS(73),
    [anon_sym_unsetenv] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(97),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [418] = {
    [sym_heredoc_redirect] = STATE(465),
    [aux_sym_redirected_statement_repeat1] = STATE(465),
    [sym_herestring_redirect] = STATE(465),
    [sym_file_redirect] = STATE(465),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(666),
    [anon_sym_PIPE] = ACTIONS(666),
    [anon_sym_LT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_LF] = ACTIONS(664),
    [anon_sym_SEMI] = ACTIONS(666),
    [anon_sym_RPAREN] = ACTIONS(666),
    [anon_sym_AMP] = ACTIONS(666),
    [anon_sym_GT] = ACTIONS(433),
    [sym_file_descriptor] = ACTIONS(439),
    [anon_sym_AMP_GT] = ACTIONS(433),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(666),
    [anon_sym_AMP_AMP] = ACTIONS(666),
    [anon_sym_SEMI_SEMI] = ACTIONS(666),
    [anon_sym_PIPE_AMP] = ACTIONS(666),
  },
  [419] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LF] = ACTIONS(2003),
    [anon_sym_SEMI] = ACTIONS(2005),
    [anon_sym_RPAREN] = ACTIONS(2007),
    [sym_file_descriptor] = ACTIONS(439),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_AMP] = ACTIONS(2005),
    [anon_sym_AMP_GT] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_SEMI_SEMI] = ACTIONS(2005),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
  },
  [420] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(2003),
    [anon_sym_SEMI] = ACTIONS(2005),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_RPAREN] = ACTIONS(2007),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP] = ACTIONS(2005),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_SEMI_SEMI] = ACTIONS(2005),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [421] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(56),
    [sym_function_definition] = STATE(56),
    [sym_negated_command] = STATE(56),
    [sym_test_command] = STATE(56),
    [sym_variable_assignment] = STATE(57),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(421),
    [sym_redirected_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_compound_statement] = STATE(56),
    [sym_subshell] = STATE(56),
    [sym_declaration_command] = STATE(56),
    [sym_unset_command] = STATE(56),
    [sym_file_redirect] = STATE(391),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(391),
    [sym_c_style_for_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_case_statement] = STATE(56),
    [sym_pipeline] = STATE(56),
    [sym_list] = STATE(56),
    [sym_command] = STATE(56),
    [sym_command_name] = STATE(392),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [anon_sym_LPAREN] = ACTIONS(672),
    [sym_word] = ACTIONS(675),
    [anon_sym_AMP_GT_GT] = ACTIONS(678),
    [anon_sym_local] = ACTIONS(681),
    [anon_sym_typeset] = ACTIONS(681),
    [anon_sym_unsetenv] = ACTIONS(684),
    [anon_sym_DOLLAR] = ACTIONS(687),
    [anon_sym_LT_LPAREN] = ACTIONS(690),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(693),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_LT] = ACTIONS(699),
    [anon_sym_LT_AMP] = ACTIONS(678),
    [anon_sym_GT_GT] = ACTIONS(678),
    [anon_sym_export] = ACTIONS(681),
    [sym__special_character] = ACTIONS(702),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_case] = ACTIONS(708),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(711),
    [sym_raw_string] = ACTIONS(714),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_declare] = ACTIONS(681),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(723),
    [sym_file_descriptor] = ACTIONS(726),
    [anon_sym_RBRACE] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(699),
    [sym_variable_name] = ACTIONS(729),
    [anon_sym_AMP_GT] = ACTIONS(699),
    [anon_sym_readonly] = ACTIONS(681),
    [anon_sym_unset] = ACTIONS(684),
    [anon_sym_DQUOTE] = ACTIONS(732),
    [anon_sym_GT_AMP] = ACTIONS(678),
    [anon_sym_BQUOTE] = ACTIONS(735),
    [anon_sym_GT_LPAREN] = ACTIONS(690),
    [anon_sym_for] = ACTIONS(738),
    [anon_sym_while] = ACTIONS(741),
    [anon_sym_LBRACK] = ACTIONS(744),
    [sym_ansii_c_string] = ACTIONS(714),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(747),
  },
  [422] = {
    [sym_command_substitution] = STATE(423),
    [aux_sym__literal_repeat1] = STATE(425),
    [sym_string] = STATE(423),
    [sym_process_substitution] = STATE(423),
    [sym_simple_expansion] = STATE(423),
    [sym_string_expansion] = STATE(423),
    [aux_sym_command_repeat2] = STATE(468),
    [sym_concatenation] = STATE(468),
    [sym_expansion] = STATE(423),
    [sym_word] = ACTIONS(1968),
    [anon_sym_AMP_GT_GT] = ACTIONS(750),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LT] = ACTIONS(750),
    [anon_sym_LT_LPAREN] = ACTIONS(1970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(750),
    [anon_sym_PIPE] = ACTIONS(750),
    [anon_sym_LT] = ACTIONS(750),
    [anon_sym_LT_AMP] = ACTIONS(750),
    [anon_sym_GT_GT] = ACTIONS(750),
    [anon_sym_EQ_TILDE] = ACTIONS(1972),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_LT_LT_DASH] = ACTIONS(750),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1974),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1976),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [sym_raw_string] = ACTIONS(1968),
    [anon_sym_RPAREN] = ACTIONS(750),
    [anon_sym_AMP] = ACTIONS(750),
    [anon_sym_GT] = ACTIONS(750),
    [sym_file_descriptor] = ACTIONS(752),
    [anon_sym_AMP_GT] = ACTIONS(750),
    [anon_sym_EQ_EQ] = ACTIONS(1972),
    [anon_sym_DQUOTE] = ACTIONS(1978),
    [anon_sym_LT_LT_LT] = ACTIONS(750),
    [anon_sym_GT_AMP] = ACTIONS(750),
    [anon_sym_BQUOTE] = ACTIONS(1980),
    [anon_sym_GT_LPAREN] = ACTIONS(1970),
    [sym_ansii_c_string] = ACTIONS(1968),
    [anon_sym_AMP_AMP] = ACTIONS(750),
    [anon_sym_SEMI_SEMI] = ACTIONS(750),
    [anon_sym_PIPE_AMP] = ACTIONS(750),
  },
  [423] = {
    [aux_sym_concatenation_repeat1] = STATE(393),
    [sym_word] = ACTIONS(770),
    [anon_sym_AMP_GT_GT] = ACTIONS(770),
    [anon_sym_DOLLAR] = ACTIONS(770),
    [anon_sym_LT_LT] = ACTIONS(770),
    [anon_sym_LT_LPAREN] = ACTIONS(770),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(770),
    [sym__concat] = ACTIONS(1918),
    [anon_sym_PIPE] = ACTIONS(770),
    [anon_sym_LT] = ACTIONS(770),
    [anon_sym_LT_AMP] = ACTIONS(770),
    [anon_sym_GT_GT] = ACTIONS(770),
    [anon_sym_EQ_TILDE] = ACTIONS(770),
    [sym__special_character] = ACTIONS(770),
    [anon_sym_LT_LT_DASH] = ACTIONS(770),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(770),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(770),
    [anon_sym_LF] = ACTIONS(772),
    [anon_sym_SEMI] = ACTIONS(770),
    [sym_raw_string] = ACTIONS(770),
    [anon_sym_RPAREN] = ACTIONS(770),
    [anon_sym_AMP] = ACTIONS(770),
    [anon_sym_GT] = ACTIONS(770),
    [sym_file_descriptor] = ACTIONS(772),
    [anon_sym_AMP_GT] = ACTIONS(770),
    [anon_sym_EQ_EQ] = ACTIONS(770),
    [anon_sym_DQUOTE] = ACTIONS(770),
    [anon_sym_LT_LT_LT] = ACTIONS(770),
    [anon_sym_GT_AMP] = ACTIONS(770),
    [anon_sym_BQUOTE] = ACTIONS(770),
    [anon_sym_GT_LPAREN] = ACTIONS(770),
    [sym_ansii_c_string] = ACTIONS(770),
    [anon_sym_AMP_AMP] = ACTIONS(770),
    [anon_sym_SEMI_SEMI] = ACTIONS(770),
    [anon_sym_PIPE_AMP] = ACTIONS(770),
  },
  [424] = {
    [sym_command_substitution] = STATE(469),
    [aux_sym__literal_repeat1] = STATE(471),
    [sym_string] = STATE(469),
    [sym_process_substitution] = STATE(469),
    [sym_simple_expansion] = STATE(469),
    [sym_string_expansion] = STATE(469),
    [sym_concatenation] = STATE(470),
    [sym_expansion] = STATE(469),
    [sym_word] = ACTIONS(2009),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [sym_raw_string] = ACTIONS(2009),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [sym_ansii_c_string] = ACTIONS(2009),
    [sym__special_character] = ACTIONS(1966),
    [sym_regex] = ACTIONS(2011),
  },
  [425] = {
    [aux_sym__literal_repeat1] = STATE(413),
    [sym_word] = ACTIONS(778),
    [anon_sym_AMP_GT_GT] = ACTIONS(778),
    [anon_sym_DOLLAR] = ACTIONS(778),
    [anon_sym_LT_LT] = ACTIONS(778),
    [anon_sym_LT_LPAREN] = ACTIONS(778),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_LT] = ACTIONS(778),
    [anon_sym_LT_AMP] = ACTIONS(778),
    [anon_sym_GT_GT] = ACTIONS(778),
    [anon_sym_EQ_TILDE] = ACTIONS(778),
    [sym__special_character] = ACTIONS(1958),
    [anon_sym_LT_LT_DASH] = ACTIONS(778),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(778),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(778),
    [anon_sym_LF] = ACTIONS(780),
    [anon_sym_SEMI] = ACTIONS(778),
    [sym_raw_string] = ACTIONS(778),
    [anon_sym_RPAREN] = ACTIONS(778),
    [anon_sym_AMP] = ACTIONS(778),
    [anon_sym_GT] = ACTIONS(778),
    [sym_file_descriptor] = ACTIONS(780),
    [anon_sym_AMP_GT] = ACTIONS(778),
    [anon_sym_EQ_EQ] = ACTIONS(778),
    [anon_sym_DQUOTE] = ACTIONS(778),
    [anon_sym_LT_LT_LT] = ACTIONS(778),
    [anon_sym_GT_AMP] = ACTIONS(778),
    [anon_sym_BQUOTE] = ACTIONS(778),
    [anon_sym_GT_LPAREN] = ACTIONS(778),
    [sym_ansii_c_string] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(778),
    [anon_sym_SEMI_SEMI] = ACTIONS(778),
    [anon_sym_PIPE_AMP] = ACTIONS(778),
  },
  [426] = {
    [sym_command_substitution] = STATE(423),
    [aux_sym__literal_repeat1] = STATE(425),
    [sym_string] = STATE(423),
    [sym_process_substitution] = STATE(423),
    [sym_simple_expansion] = STATE(423),
    [sym_string_expansion] = STATE(423),
    [aux_sym_command_repeat2] = STATE(472),
    [sym_concatenation] = STATE(472),
    [sym_expansion] = STATE(423),
    [sym_word] = ACTIONS(1968),
    [anon_sym_AMP_GT_GT] = ACTIONS(750),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LT] = ACTIONS(750),
    [anon_sym_LT_LPAREN] = ACTIONS(1970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(750),
    [anon_sym_PIPE] = ACTIONS(750),
    [anon_sym_LT] = ACTIONS(750),
    [anon_sym_LT_AMP] = ACTIONS(750),
    [anon_sym_GT_GT] = ACTIONS(750),
    [anon_sym_EQ_TILDE] = ACTIONS(1972),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_LT_LT_DASH] = ACTIONS(750),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1974),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1976),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [sym_raw_string] = ACTIONS(1968),
    [anon_sym_RPAREN] = ACTIONS(750),
    [anon_sym_AMP] = ACTIONS(750),
    [anon_sym_GT] = ACTIONS(750),
    [sym_file_descriptor] = ACTIONS(752),
    [anon_sym_AMP_GT] = ACTIONS(750),
    [anon_sym_EQ_EQ] = ACTIONS(1972),
    [anon_sym_DQUOTE] = ACTIONS(1978),
    [anon_sym_LT_LT_LT] = ACTIONS(750),
    [anon_sym_GT_AMP] = ACTIONS(750),
    [anon_sym_BQUOTE] = ACTIONS(1980),
    [anon_sym_GT_LPAREN] = ACTIONS(1970),
    [sym_ansii_c_string] = ACTIONS(1968),
    [anon_sym_AMP_AMP] = ACTIONS(750),
    [anon_sym_SEMI_SEMI] = ACTIONS(750),
    [anon_sym_PIPE_AMP] = ACTIONS(750),
  },
  [427] = {
    [sym_word] = ACTIONS(782),
    [anon_sym_AMP_GT_GT] = ACTIONS(782),
    [anon_sym_DOLLAR] = ACTIONS(782),
    [anon_sym_LT_LT] = ACTIONS(782),
    [anon_sym_LT_LPAREN] = ACTIONS(782),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(782),
    [sym__concat] = ACTIONS(784),
    [anon_sym_PIPE] = ACTIONS(782),
    [anon_sym_LT] = ACTIONS(782),
    [anon_sym_LT_AMP] = ACTIONS(782),
    [anon_sym_GT_GT] = ACTIONS(782),
    [anon_sym_EQ_TILDE] = ACTIONS(782),
    [sym__special_character] = ACTIONS(782),
    [anon_sym_LT_LT_DASH] = ACTIONS(782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(782),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(782),
    [anon_sym_LF] = ACTIONS(784),
    [anon_sym_SEMI] = ACTIONS(782),
    [sym_raw_string] = ACTIONS(782),
    [anon_sym_RPAREN] = ACTIONS(782),
    [anon_sym_AMP] = ACTIONS(782),
    [anon_sym_GT] = ACTIONS(782),
    [sym_file_descriptor] = ACTIONS(784),
    [anon_sym_AMP_GT] = ACTIONS(782),
    [anon_sym_EQ_EQ] = ACTIONS(782),
    [anon_sym_DQUOTE] = ACTIONS(782),
    [anon_sym_LT_LT_LT] = ACTIONS(782),
    [anon_sym_GT_AMP] = ACTIONS(782),
    [anon_sym_BQUOTE] = ACTIONS(782),
    [anon_sym_GT_LPAREN] = ACTIONS(782),
    [sym_ansii_c_string] = ACTIONS(782),
    [anon_sym_AMP_AMP] = ACTIONS(782),
    [anon_sym_SEMI_SEMI] = ACTIONS(782),
    [anon_sym_PIPE_AMP] = ACTIONS(782),
  },
  [428] = {
    [sym_command_substitution] = STATE(427),
    [sym_string] = STATE(427),
    [sym_process_substitution] = STATE(427),
    [sym_simple_expansion] = STATE(427),
    [sym_string_expansion] = STATE(427),
    [sym_expansion] = STATE(427),
    [sym_word] = ACTIONS(2013),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [sym_raw_string] = ACTIONS(2013),
    [anon_sym_DOLLAR] = ACTIONS(2015),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [sym_ansii_c_string] = ACTIONS(2013),
    [sym__special_character] = ACTIONS(2013),
  },
  [429] = {
    [aux_sym_concatenation_repeat1] = STATE(429),
    [sym_word] = ACTIONS(782),
    [anon_sym_AMP_GT_GT] = ACTIONS(782),
    [anon_sym_DOLLAR] = ACTIONS(782),
    [anon_sym_LT_LT] = ACTIONS(782),
    [anon_sym_LT_LPAREN] = ACTIONS(782),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(782),
    [sym__concat] = ACTIONS(2017),
    [anon_sym_PIPE] = ACTIONS(782),
    [anon_sym_LT] = ACTIONS(782),
    [anon_sym_LT_AMP] = ACTIONS(782),
    [anon_sym_GT_GT] = ACTIONS(782),
    [anon_sym_EQ_TILDE] = ACTIONS(782),
    [sym__special_character] = ACTIONS(782),
    [anon_sym_LT_LT_DASH] = ACTIONS(782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(782),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(782),
    [anon_sym_LF] = ACTIONS(784),
    [anon_sym_SEMI] = ACTIONS(782),
    [sym_raw_string] = ACTIONS(782),
    [anon_sym_RPAREN] = ACTIONS(782),
    [anon_sym_AMP] = ACTIONS(782),
    [anon_sym_GT] = ACTIONS(782),
    [sym_file_descriptor] = ACTIONS(784),
    [anon_sym_AMP_GT] = ACTIONS(782),
    [anon_sym_EQ_EQ] = ACTIONS(782),
    [anon_sym_DQUOTE] = ACTIONS(782),
    [anon_sym_LT_LT_LT] = ACTIONS(782),
    [anon_sym_GT_AMP] = ACTIONS(782),
    [anon_sym_BQUOTE] = ACTIONS(782),
    [anon_sym_GT_LPAREN] = ACTIONS(782),
    [sym_ansii_c_string] = ACTIONS(782),
    [anon_sym_AMP_AMP] = ACTIONS(782),
    [anon_sym_SEMI_SEMI] = ACTIONS(782),
    [anon_sym_PIPE_AMP] = ACTIONS(782),
  },
  [430] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(791),
    [anon_sym_LT_LT] = ACTIONS(791),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(791),
    [anon_sym_PIPE] = ACTIONS(791),
    [anon_sym_LT] = ACTIONS(791),
    [anon_sym_LT_AMP] = ACTIONS(791),
    [anon_sym_GT_GT] = ACTIONS(791),
    [anon_sym_LT_LT_DASH] = ACTIONS(791),
    [anon_sym_LF] = ACTIONS(793),
    [anon_sym_SEMI] = ACTIONS(791),
    [anon_sym_RPAREN] = ACTIONS(791),
    [anon_sym_AMP] = ACTIONS(791),
    [anon_sym_GT] = ACTIONS(791),
    [sym_file_descriptor] = ACTIONS(793),
    [anon_sym_AMP_GT] = ACTIONS(791),
    [anon_sym_LT_LT_LT] = ACTIONS(791),
    [anon_sym_GT_AMP] = ACTIONS(791),
    [anon_sym_BQUOTE] = ACTIONS(791),
    [anon_sym_esac] = ACTIONS(791),
    [anon_sym_AMP_AMP] = ACTIONS(791),
    [anon_sym_SEMI_SEMI] = ACTIONS(791),
    [anon_sym_PIPE_AMP] = ACTIONS(791),
  },
  [431] = {
    [aux_sym__literal_repeat1] = STATE(398),
    [sym_string] = STATE(397),
    [sym_process_substitution] = STATE(397),
    [sym_variable_assignment] = STATE(431),
    [sym_subscript] = STATE(2464),
    [sym_concatenation] = STATE(431),
    [sym_expansion] = STATE(397),
    [sym_command_substitution] = STATE(397),
    [aux_sym_declaration_command_repeat1] = STATE(431),
    [sym_simple_expansion] = STATE(397),
    [sym_string_expansion] = STATE(397),
    [sym_word] = ACTIONS(2020),
    [anon_sym_AMP_GT_GT] = ACTIONS(798),
    [anon_sym_DOLLAR] = ACTIONS(2023),
    [anon_sym_LT_LT] = ACTIONS(798),
    [anon_sym_LT_LPAREN] = ACTIONS(2026),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(798),
    [anon_sym_PIPE] = ACTIONS(798),
    [anon_sym_LT] = ACTIONS(798),
    [anon_sym_LT_AMP] = ACTIONS(798),
    [anon_sym_GT_GT] = ACTIONS(798),
    [sym__special_character] = ACTIONS(2029),
    [anon_sym_LT_LT_DASH] = ACTIONS(798),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2032),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2035),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2038),
    [anon_sym_LF] = ACTIONS(818),
    [anon_sym_SEMI] = ACTIONS(798),
    [sym_raw_string] = ACTIONS(2020),
    [sym_variable_name] = ACTIONS(2041),
    [anon_sym_RPAREN] = ACTIONS(798),
    [anon_sym_AMP] = ACTIONS(798),
    [anon_sym_GT] = ACTIONS(798),
    [sym_file_descriptor] = ACTIONS(818),
    [anon_sym_AMP_GT] = ACTIONS(798),
    [anon_sym_DQUOTE] = ACTIONS(2044),
    [anon_sym_LT_LT_LT] = ACTIONS(798),
    [anon_sym_GT_AMP] = ACTIONS(798),
    [anon_sym_BQUOTE] = ACTIONS(2047),
    [anon_sym_GT_LPAREN] = ACTIONS(2026),
    [sym_ansii_c_string] = ACTIONS(2020),
    [anon_sym_AMP_AMP] = ACTIONS(798),
    [anon_sym_SEMI_SEMI] = ACTIONS(798),
    [anon_sym_PIPE_AMP] = ACTIONS(798),
  },
  [432] = {
    [sym_command_substitution] = STATE(400),
    [aux_sym__literal_repeat1] = STATE(401),
    [sym_string] = STATE(400),
    [aux_sym_unset_command_repeat1] = STATE(432),
    [sym_process_substitution] = STATE(400),
    [sym_simple_expansion] = STATE(400),
    [sym_string_expansion] = STATE(400),
    [sym_concatenation] = STATE(432),
    [sym_expansion] = STATE(400),
    [sym_word] = ACTIONS(2050),
    [anon_sym_AMP_GT_GT] = ACTIONS(832),
    [anon_sym_DOLLAR] = ACTIONS(2053),
    [anon_sym_LT_LT] = ACTIONS(832),
    [anon_sym_LT_LPAREN] = ACTIONS(2056),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(832),
    [anon_sym_PIPE] = ACTIONS(832),
    [anon_sym_LT] = ACTIONS(832),
    [anon_sym_LT_AMP] = ACTIONS(832),
    [anon_sym_GT_GT] = ACTIONS(832),
    [sym__special_character] = ACTIONS(2059),
    [anon_sym_LT_LT_DASH] = ACTIONS(832),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2062),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2065),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2068),
    [anon_sym_LF] = ACTIONS(852),
    [anon_sym_SEMI] = ACTIONS(832),
    [sym_raw_string] = ACTIONS(2050),
    [anon_sym_RPAREN] = ACTIONS(832),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_GT] = ACTIONS(832),
    [sym_file_descriptor] = ACTIONS(852),
    [anon_sym_AMP_GT] = ACTIONS(832),
    [anon_sym_DQUOTE] = ACTIONS(2071),
    [anon_sym_LT_LT_LT] = ACTIONS(832),
    [anon_sym_GT_AMP] = ACTIONS(832),
    [anon_sym_BQUOTE] = ACTIONS(2074),
    [anon_sym_GT_LPAREN] = ACTIONS(2056),
    [sym_ansii_c_string] = ACTIONS(2050),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_SEMI_SEMI] = ACTIONS(832),
    [anon_sym_PIPE_AMP] = ACTIONS(832),
  },
  [433] = {
    [sym_word] = ACTIONS(860),
    [anon_sym_AMP_GT_GT] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(860),
    [anon_sym_LT_LT] = ACTIONS(860),
    [anon_sym_LT_LPAREN] = ACTIONS(860),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(860),
    [sym__concat] = ACTIONS(862),
    [anon_sym_PIPE] = ACTIONS(860),
    [anon_sym_LT] = ACTIONS(860),
    [anon_sym_LT_AMP] = ACTIONS(860),
    [anon_sym_GT_GT] = ACTIONS(860),
    [anon_sym_EQ_TILDE] = ACTIONS(860),
    [sym__special_character] = ACTIONS(860),
    [anon_sym_LT_LT_DASH] = ACTIONS(860),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(860),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(860),
    [anon_sym_LF] = ACTIONS(862),
    [anon_sym_SEMI] = ACTIONS(860),
    [sym_raw_string] = ACTIONS(860),
    [anon_sym_RPAREN] = ACTIONS(860),
    [anon_sym_AMP] = ACTIONS(860),
    [anon_sym_GT] = ACTIONS(860),
    [sym_file_descriptor] = ACTIONS(862),
    [anon_sym_AMP_GT] = ACTIONS(860),
    [anon_sym_EQ_EQ] = ACTIONS(860),
    [anon_sym_DQUOTE] = ACTIONS(860),
    [anon_sym_LT_LT_LT] = ACTIONS(860),
    [anon_sym_GT_AMP] = ACTIONS(860),
    [anon_sym_BQUOTE] = ACTIONS(860),
    [anon_sym_GT_LPAREN] = ACTIONS(860),
    [sym_ansii_c_string] = ACTIONS(860),
    [anon_sym_AMP_AMP] = ACTIONS(860),
    [anon_sym_SEMI_SEMI] = ACTIONS(860),
    [anon_sym_PIPE_AMP] = ACTIONS(860),
  },
  [434] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(866),
    [anon_sym_LT_LT] = ACTIONS(866),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(866),
    [anon_sym_PIPE] = ACTIONS(866),
    [anon_sym_LT] = ACTIONS(866),
    [anon_sym_LT_AMP] = ACTIONS(866),
    [anon_sym_GT_GT] = ACTIONS(866),
    [anon_sym_LT_LT_DASH] = ACTIONS(866),
    [anon_sym_LF] = ACTIONS(868),
    [anon_sym_SEMI] = ACTIONS(866),
    [anon_sym_RPAREN] = ACTIONS(866),
    [anon_sym_AMP] = ACTIONS(866),
    [anon_sym_GT] = ACTIONS(866),
    [sym_file_descriptor] = ACTIONS(868),
    [anon_sym_AMP_GT] = ACTIONS(866),
    [anon_sym_LT_LT_LT] = ACTIONS(866),
    [anon_sym_GT_AMP] = ACTIONS(866),
    [anon_sym_BQUOTE] = ACTIONS(866),
    [anon_sym_esac] = ACTIONS(866),
    [anon_sym_AMP_AMP] = ACTIONS(866),
    [anon_sym_SEMI_SEMI] = ACTIONS(866),
    [anon_sym_PIPE_AMP] = ACTIONS(866),
  },
  [435] = {
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [436] = {
    [sym_heredoc_body] = STATE(1408),
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__simple_heredoc_body] = ACTIONS(870),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [sym__heredoc_body_beginning] = ACTIONS(872),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [437] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(874),
    [anon_sym_LT_LT] = ACTIONS(874),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(874),
    [anon_sym_PIPE] = ACTIONS(874),
    [anon_sym_LT] = ACTIONS(874),
    [anon_sym_LT_AMP] = ACTIONS(874),
    [anon_sym_GT_GT] = ACTIONS(874),
    [anon_sym_LT_LT_DASH] = ACTIONS(874),
    [anon_sym_LF] = ACTIONS(876),
    [anon_sym_SEMI] = ACTIONS(874),
    [anon_sym_RPAREN] = ACTIONS(874),
    [anon_sym_AMP] = ACTIONS(874),
    [anon_sym_GT] = ACTIONS(874),
    [sym_file_descriptor] = ACTIONS(876),
    [anon_sym_AMP_GT] = ACTIONS(874),
    [anon_sym_LT_LT_LT] = ACTIONS(874),
    [anon_sym_GT_AMP] = ACTIONS(874),
    [anon_sym_BQUOTE] = ACTIONS(874),
    [anon_sym_esac] = ACTIONS(874),
    [anon_sym_AMP_AMP] = ACTIONS(874),
    [anon_sym_SEMI_SEMI] = ACTIONS(874),
    [anon_sym_PIPE_AMP] = ACTIONS(874),
  },
  [438] = {
    [anon_sym_BANG_EQ] = ACTIONS(621),
    [anon_sym_PLUS_EQ] = ACTIONS(621),
    [anon_sym_PLUS_PLUS] = ACTIONS(623),
    [anon_sym_RBRACK] = ACTIONS(900),
    [anon_sym_DASH] = ACTIONS(625),
    [anon_sym_GT] = ACTIONS(625),
    [anon_sym_EQ] = ACTIONS(625),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(627),
    [anon_sym_PIPE_PIPE] = ACTIONS(621),
    [anon_sym_GT_EQ] = ACTIONS(621),
    [anon_sym_PLUS] = ACTIONS(625),
    [anon_sym_LT] = ACTIONS(625),
    [sym_test_operator] = ACTIONS(621),
    [anon_sym_EQ_TILDE] = ACTIONS(627),
    [anon_sym_DASH_DASH] = ACTIONS(623),
    [anon_sym_LT_EQ] = ACTIONS(621),
    [anon_sym_AMP_AMP] = ACTIONS(621),
    [anon_sym_DASH_EQ] = ACTIONS(621),
  },
  [439] = {
    [sym_command_substitution] = STATE(407),
    [sym_unary_expression] = STATE(477),
    [sym_postfix_expression] = STATE(477),
    [sym_string] = STATE(407),
    [aux_sym__literal_repeat1] = STATE(409),
    [sym_process_substitution] = STATE(407),
    [sym_parenthesized_expression] = STATE(477),
    [sym_simple_expansion] = STATE(407),
    [sym_string_expansion] = STATE(407),
    [sym__expression] = STATE(477),
    [sym_binary_expression] = STATE(477),
    [sym_concatenation] = STATE(477),
    [sym_expansion] = STATE(407),
    [sym_word] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(277),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(279),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(281),
    [sym_raw_string] = ACTIONS(283),
    [anon_sym_BANG] = ACTIONS(285),
    [anon_sym_DOLLAR] = ACTIONS(287),
    [anon_sym_LT_LPAREN] = ACTIONS(289),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [sym_test_operator] = ACTIONS(293),
    [anon_sym_BQUOTE] = ACTIONS(295),
    [anon_sym_GT_LPAREN] = ACTIONS(289),
    [sym_ansii_c_string] = ACTIONS(283),
    [sym__special_character] = ACTIONS(297),
  },
  [440] = {
    [anon_sym_BANG_EQ] = ACTIONS(904),
    [anon_sym_PLUS_EQ] = ACTIONS(904),
    [anon_sym_PLUS_PLUS] = ACTIONS(904),
    [anon_sym_RBRACK] = ACTIONS(904),
    [anon_sym_DASH] = ACTIONS(906),
    [anon_sym_GT] = ACTIONS(906),
    [anon_sym_EQ] = ACTIONS(906),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(904),
    [anon_sym_PIPE_PIPE] = ACTIONS(904),
    [anon_sym_GT_EQ] = ACTIONS(904),
    [anon_sym_PLUS] = ACTIONS(906),
    [anon_sym_LT] = ACTIONS(906),
    [sym_test_operator] = ACTIONS(904),
    [anon_sym_EQ_TILDE] = ACTIONS(904),
    [anon_sym_DASH_DASH] = ACTIONS(904),
    [anon_sym_LT_EQ] = ACTIONS(904),
    [anon_sym_AMP_AMP] = ACTIONS(904),
    [anon_sym_DASH_EQ] = ACTIONS(904),
  },
  [441] = {
    [sym_command_substitution] = STATE(407),
    [sym_unary_expression] = STATE(477),
    [sym_postfix_expression] = STATE(477),
    [sym_string] = STATE(407),
    [aux_sym__literal_repeat1] = STATE(409),
    [sym_process_substitution] = STATE(407),
    [sym_parenthesized_expression] = STATE(477),
    [sym_simple_expansion] = STATE(407),
    [sym_string_expansion] = STATE(407),
    [sym__expression] = STATE(477),
    [sym_binary_expression] = STATE(477),
    [sym_concatenation] = STATE(477),
    [sym_expansion] = STATE(407),
    [sym_word] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(277),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(279),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(281),
    [sym_raw_string] = ACTIONS(283),
    [anon_sym_BANG] = ACTIONS(285),
    [anon_sym_DOLLAR] = ACTIONS(287),
    [anon_sym_LT_LPAREN] = ACTIONS(289),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(291),
    [sym_test_operator] = ACTIONS(293),
    [anon_sym_BQUOTE] = ACTIONS(295),
    [anon_sym_GT_LPAREN] = ACTIONS(289),
    [sym_ansii_c_string] = ACTIONS(283),
    [sym__special_character] = ACTIONS(297),
    [sym_regex] = ACTIONS(2077),
  },
  [442] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(910),
    [anon_sym_LT_LT] = ACTIONS(910),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(910),
    [anon_sym_PIPE] = ACTIONS(910),
    [anon_sym_LT] = ACTIONS(910),
    [anon_sym_LT_AMP] = ACTIONS(910),
    [anon_sym_GT_GT] = ACTIONS(910),
    [anon_sym_LT_LT_DASH] = ACTIONS(910),
    [anon_sym_LF] = ACTIONS(912),
    [anon_sym_SEMI] = ACTIONS(910),
    [anon_sym_RPAREN] = ACTIONS(910),
    [anon_sym_AMP] = ACTIONS(910),
    [anon_sym_GT] = ACTIONS(910),
    [sym_file_descriptor] = ACTIONS(912),
    [anon_sym_AMP_GT] = ACTIONS(910),
    [anon_sym_LT_LT_LT] = ACTIONS(910),
    [anon_sym_GT_AMP] = ACTIONS(910),
    [anon_sym_BQUOTE] = ACTIONS(910),
    [anon_sym_esac] = ACTIONS(910),
    [anon_sym_AMP_AMP] = ACTIONS(910),
    [anon_sym_SEMI_SEMI] = ACTIONS(910),
    [anon_sym_PIPE_AMP] = ACTIONS(910),
  },
  [443] = {
    [sym_word] = ACTIONS(920),
    [anon_sym_AMP_GT_GT] = ACTIONS(920),
    [anon_sym_DOLLAR] = ACTIONS(920),
    [anon_sym_LT_LT] = ACTIONS(920),
    [anon_sym_LT_LPAREN] = ACTIONS(920),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(920),
    [sym__concat] = ACTIONS(922),
    [anon_sym_PIPE] = ACTIONS(920),
    [anon_sym_LT] = ACTIONS(920),
    [anon_sym_LT_AMP] = ACTIONS(920),
    [anon_sym_GT_GT] = ACTIONS(920),
    [anon_sym_EQ_TILDE] = ACTIONS(920),
    [sym__special_character] = ACTIONS(920),
    [anon_sym_LT_LT_DASH] = ACTIONS(920),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(920),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(920),
    [anon_sym_LF] = ACTIONS(922),
    [anon_sym_SEMI] = ACTIONS(920),
    [sym_raw_string] = ACTIONS(920),
    [anon_sym_RPAREN] = ACTIONS(920),
    [anon_sym_AMP] = ACTIONS(920),
    [anon_sym_GT] = ACTIONS(920),
    [sym_file_descriptor] = ACTIONS(922),
    [anon_sym_AMP_GT] = ACTIONS(920),
    [anon_sym_EQ_EQ] = ACTIONS(920),
    [anon_sym_DQUOTE] = ACTIONS(920),
    [anon_sym_LT_LT_LT] = ACTIONS(920),
    [anon_sym_GT_AMP] = ACTIONS(920),
    [anon_sym_BQUOTE] = ACTIONS(920),
    [anon_sym_GT_LPAREN] = ACTIONS(920),
    [sym_ansii_c_string] = ACTIONS(920),
    [anon_sym_AMP_AMP] = ACTIONS(920),
    [anon_sym_SEMI_SEMI] = ACTIONS(920),
    [anon_sym_PIPE_AMP] = ACTIONS(920),
  },
  [444] = {
    [sym_word] = ACTIONS(970),
    [anon_sym_AMP_GT_GT] = ACTIONS(970),
    [anon_sym_DOLLAR] = ACTIONS(970),
    [anon_sym_LT_LT] = ACTIONS(970),
    [anon_sym_LT_LPAREN] = ACTIONS(970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(970),
    [sym__concat] = ACTIONS(972),
    [anon_sym_PIPE] = ACTIONS(970),
    [anon_sym_LT] = ACTIONS(970),
    [anon_sym_LT_AMP] = ACTIONS(970),
    [anon_sym_GT_GT] = ACTIONS(970),
    [anon_sym_EQ_TILDE] = ACTIONS(970),
    [sym__special_character] = ACTIONS(970),
    [anon_sym_LT_LT_DASH] = ACTIONS(970),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(970),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(970),
    [anon_sym_LF] = ACTIONS(972),
    [anon_sym_SEMI] = ACTIONS(970),
    [sym_raw_string] = ACTIONS(970),
    [anon_sym_RPAREN] = ACTIONS(970),
    [anon_sym_AMP] = ACTIONS(970),
    [anon_sym_GT] = ACTIONS(970),
    [sym_file_descriptor] = ACTIONS(972),
    [anon_sym_AMP_GT] = ACTIONS(970),
    [anon_sym_EQ_EQ] = ACTIONS(970),
    [anon_sym_DQUOTE] = ACTIONS(970),
    [anon_sym_LT_LT_LT] = ACTIONS(970),
    [anon_sym_GT_AMP] = ACTIONS(970),
    [anon_sym_BQUOTE] = ACTIONS(970),
    [anon_sym_GT_LPAREN] = ACTIONS(970),
    [sym_ansii_c_string] = ACTIONS(970),
    [anon_sym_AMP_AMP] = ACTIONS(970),
    [anon_sym_SEMI_SEMI] = ACTIONS(970),
    [anon_sym_PIPE_AMP] = ACTIONS(970),
  },
  [445] = {
    [aux_sym_concatenation_repeat1] = STATE(1033),
    [sym_word] = ACTIONS(982),
    [anon_sym_AMP_GT_GT] = ACTIONS(982),
    [anon_sym_DOLLAR] = ACTIONS(982),
    [anon_sym_LT_LT] = ACTIONS(982),
    [anon_sym_LT_LPAREN] = ACTIONS(982),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(982),
    [sym__concat] = ACTIONS(2079),
    [anon_sym_PIPE] = ACTIONS(982),
    [anon_sym_LT] = ACTIONS(982),
    [anon_sym_LT_AMP] = ACTIONS(982),
    [anon_sym_GT_GT] = ACTIONS(982),
    [sym__special_character] = ACTIONS(982),
    [anon_sym_LT_LT_DASH] = ACTIONS(982),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(982),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(982),
    [anon_sym_LF] = ACTIONS(986),
    [anon_sym_SEMI] = ACTIONS(982),
    [sym_raw_string] = ACTIONS(982),
    [sym_variable_name] = ACTIONS(986),
    [anon_sym_RPAREN] = ACTIONS(982),
    [anon_sym_AMP] = ACTIONS(982),
    [anon_sym_GT] = ACTIONS(982),
    [sym_file_descriptor] = ACTIONS(986),
    [anon_sym_AMP_GT] = ACTIONS(982),
    [anon_sym_DQUOTE] = ACTIONS(982),
    [anon_sym_LT_LT_LT] = ACTIONS(982),
    [anon_sym_GT_AMP] = ACTIONS(982),
    [anon_sym_BQUOTE] = ACTIONS(982),
    [anon_sym_GT_LPAREN] = ACTIONS(982),
    [sym_ansii_c_string] = ACTIONS(982),
    [anon_sym_AMP_AMP] = ACTIONS(982),
    [anon_sym_SEMI_SEMI] = ACTIONS(982),
    [anon_sym_PIPE_AMP] = ACTIONS(982),
  },
  [446] = {
    [sym_word] = ACTIONS(982),
    [anon_sym_AMP_GT_GT] = ACTIONS(982),
    [anon_sym_DOLLAR] = ACTIONS(982),
    [anon_sym_LT_LT] = ACTIONS(982),
    [anon_sym_LT_LPAREN] = ACTIONS(982),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(982),
    [anon_sym_PIPE] = ACTIONS(982),
    [anon_sym_LT] = ACTIONS(982),
    [anon_sym_LT_AMP] = ACTIONS(982),
    [anon_sym_GT_GT] = ACTIONS(982),
    [sym__special_character] = ACTIONS(982),
    [anon_sym_LT_LT_DASH] = ACTIONS(982),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(982),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(982),
    [anon_sym_LF] = ACTIONS(986),
    [anon_sym_SEMI] = ACTIONS(982),
    [sym_raw_string] = ACTIONS(982),
    [sym_variable_name] = ACTIONS(986),
    [anon_sym_RPAREN] = ACTIONS(982),
    [anon_sym_AMP] = ACTIONS(982),
    [anon_sym_GT] = ACTIONS(982),
    [sym_file_descriptor] = ACTIONS(986),
    [anon_sym_AMP_GT] = ACTIONS(982),
    [anon_sym_DQUOTE] = ACTIONS(982),
    [anon_sym_LT_LT_LT] = ACTIONS(982),
    [anon_sym_GT_AMP] = ACTIONS(982),
    [anon_sym_BQUOTE] = ACTIONS(982),
    [anon_sym_GT_LPAREN] = ACTIONS(982),
    [sym_ansii_c_string] = ACTIONS(982),
    [anon_sym_AMP_AMP] = ACTIONS(982),
    [anon_sym_SEMI_SEMI] = ACTIONS(982),
    [anon_sym_PIPE_AMP] = ACTIONS(982),
  },
  [447] = {
    [aux_sym__literal_repeat1] = STATE(1071),
    [sym_word] = ACTIONS(1006),
    [anon_sym_AMP_GT_GT] = ACTIONS(1006),
    [anon_sym_DOLLAR] = ACTIONS(1006),
    [anon_sym_LT_LT] = ACTIONS(1006),
    [anon_sym_LT_LPAREN] = ACTIONS(1006),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1006),
    [anon_sym_PIPE] = ACTIONS(1006),
    [anon_sym_LT] = ACTIONS(1006),
    [anon_sym_LT_AMP] = ACTIONS(1006),
    [anon_sym_GT_GT] = ACTIONS(1006),
    [sym__special_character] = ACTIONS(2081),
    [anon_sym_LT_LT_DASH] = ACTIONS(1006),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1006),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1006),
    [anon_sym_LF] = ACTIONS(1010),
    [anon_sym_SEMI] = ACTIONS(1006),
    [sym_raw_string] = ACTIONS(1006),
    [sym_variable_name] = ACTIONS(1010),
    [anon_sym_RPAREN] = ACTIONS(1006),
    [anon_sym_AMP] = ACTIONS(1006),
    [anon_sym_GT] = ACTIONS(1006),
    [sym_file_descriptor] = ACTIONS(1010),
    [anon_sym_AMP_GT] = ACTIONS(1006),
    [anon_sym_DQUOTE] = ACTIONS(1006),
    [anon_sym_LT_LT_LT] = ACTIONS(1006),
    [anon_sym_GT_AMP] = ACTIONS(1006),
    [anon_sym_BQUOTE] = ACTIONS(1006),
    [anon_sym_GT_LPAREN] = ACTIONS(1006),
    [sym_ansii_c_string] = ACTIONS(1006),
    [anon_sym_AMP_AMP] = ACTIONS(1006),
    [anon_sym_SEMI_SEMI] = ACTIONS(1006),
    [anon_sym_PIPE_AMP] = ACTIONS(1006),
  },
  [448] = {
    [aux_sym_concatenation_repeat1] = STATE(1001),
    [anon_sym_LT_LT_DASH] = ACTIONS(1026),
    [anon_sym_AMP_GT_GT] = ACTIONS(1026),
    [anon_sym_LF] = ACTIONS(1024),
    [anon_sym_SEMI] = ACTIONS(1026),
    [anon_sym_LT_LT] = ACTIONS(1026),
    [anon_sym_AMP] = ACTIONS(1026),
    [anon_sym_GT] = ACTIONS(1026),
    [sym_file_descriptor] = ACTIONS(1024),
    [anon_sym_AMP_GT] = ACTIONS(1026),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1026),
    [ts_builtin_sym_end] = ACTIONS(1024),
    [anon_sym_LT_LT_LT] = ACTIONS(1026),
    [anon_sym_PIPE] = ACTIONS(1026),
    [anon_sym_GT_AMP] = ACTIONS(1026),
    [anon_sym_LT] = ACTIONS(1026),
    [anon_sym_LT_AMP] = ACTIONS(1026),
    [anon_sym_GT_GT] = ACTIONS(1026),
    [sym__concat] = ACTIONS(1131),
    [anon_sym_AMP_AMP] = ACTIONS(1026),
    [anon_sym_SEMI_SEMI] = ACTIONS(1026),
    [anon_sym_PIPE_AMP] = ACTIONS(1026),
  },
  [449] = {
    [aux_sym__literal_repeat1] = STATE(1039),
    [anon_sym_LT_LT_DASH] = ACTIONS(1030),
    [anon_sym_AMP_GT_GT] = ACTIONS(1030),
    [anon_sym_LF] = ACTIONS(1028),
    [anon_sym_SEMI] = ACTIONS(1030),
    [anon_sym_LT_LT] = ACTIONS(1030),
    [anon_sym_AMP] = ACTIONS(1030),
    [anon_sym_GT] = ACTIONS(1030),
    [sym_file_descriptor] = ACTIONS(1028),
    [anon_sym_AMP_GT] = ACTIONS(1030),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1030),
    [ts_builtin_sym_end] = ACTIONS(1028),
    [anon_sym_LT_LT_LT] = ACTIONS(1030),
    [anon_sym_PIPE] = ACTIONS(1030),
    [anon_sym_GT_AMP] = ACTIONS(1030),
    [anon_sym_LT] = ACTIONS(1030),
    [anon_sym_LT_AMP] = ACTIONS(1030),
    [anon_sym_GT_GT] = ACTIONS(1030),
    [anon_sym_AMP_AMP] = ACTIONS(1030),
    [sym__special_character] = ACTIONS(1137),
    [anon_sym_SEMI_SEMI] = ACTIONS(1030),
    [anon_sym_PIPE_AMP] = ACTIONS(1030),
  },
  [450] = {
    [anon_sym_LT_LT_DASH] = ACTIONS(1026),
    [anon_sym_AMP_GT_GT] = ACTIONS(1026),
    [anon_sym_LF] = ACTIONS(1024),
    [anon_sym_SEMI] = ACTIONS(1026),
    [anon_sym_LT_LT] = ACTIONS(1026),
    [anon_sym_AMP] = ACTIONS(1026),
    [anon_sym_GT] = ACTIONS(1026),
    [sym_file_descriptor] = ACTIONS(1024),
    [anon_sym_AMP_GT] = ACTIONS(1026),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1026),
    [ts_builtin_sym_end] = ACTIONS(1024),
    [anon_sym_LT_LT_LT] = ACTIONS(1026),
    [anon_sym_PIPE] = ACTIONS(1026),
    [anon_sym_GT_AMP] = ACTIONS(1026),
    [anon_sym_LT] = ACTIONS(1026),
    [anon_sym_LT_AMP] = ACTIONS(1026),
    [anon_sym_GT_GT] = ACTIONS(1026),
    [anon_sym_AMP_AMP] = ACTIONS(1026),
    [anon_sym_SEMI_SEMI] = ACTIONS(1026),
    [anon_sym_PIPE_AMP] = ACTIONS(1026),
  },
  [451] = {
    [sym_word] = ACTIONS(1032),
    [anon_sym_AMP_GT_GT] = ACTIONS(1032),
    [anon_sym_DOLLAR] = ACTIONS(1032),
    [anon_sym_LT_LT] = ACTIONS(1032),
    [anon_sym_LT_LPAREN] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1032),
    [sym__concat] = ACTIONS(1034),
    [anon_sym_PIPE] = ACTIONS(1032),
    [anon_sym_LT] = ACTIONS(1032),
    [anon_sym_LT_AMP] = ACTIONS(1032),
    [anon_sym_GT_GT] = ACTIONS(1032),
    [anon_sym_EQ_TILDE] = ACTIONS(1032),
    [sym__special_character] = ACTIONS(1032),
    [anon_sym_LT_LT_DASH] = ACTIONS(1032),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1032),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1032),
    [anon_sym_LF] = ACTIONS(1034),
    [anon_sym_SEMI] = ACTIONS(1032),
    [sym_raw_string] = ACTIONS(1032),
    [anon_sym_RPAREN] = ACTIONS(1032),
    [anon_sym_AMP] = ACTIONS(1032),
    [anon_sym_GT] = ACTIONS(1032),
    [sym_file_descriptor] = ACTIONS(1034),
    [anon_sym_AMP_GT] = ACTIONS(1032),
    [anon_sym_EQ_EQ] = ACTIONS(1032),
    [anon_sym_DQUOTE] = ACTIONS(1032),
    [anon_sym_LT_LT_LT] = ACTIONS(1032),
    [anon_sym_GT_AMP] = ACTIONS(1032),
    [anon_sym_BQUOTE] = ACTIONS(1032),
    [anon_sym_GT_LPAREN] = ACTIONS(1032),
    [sym_ansii_c_string] = ACTIONS(1032),
    [anon_sym_AMP_AMP] = ACTIONS(1032),
    [anon_sym_SEMI_SEMI] = ACTIONS(1032),
    [anon_sym_PIPE_AMP] = ACTIONS(1032),
  },
  [452] = {
    [sym_word] = ACTIONS(1036),
    [anon_sym_AMP_GT_GT] = ACTIONS(1036),
    [anon_sym_DOLLAR] = ACTIONS(1036),
    [anon_sym_LT_LT] = ACTIONS(1036),
    [anon_sym_LT_LPAREN] = ACTIONS(1036),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1036),
    [sym__concat] = ACTIONS(1038),
    [anon_sym_PIPE] = ACTIONS(1036),
    [anon_sym_LT] = ACTIONS(1036),
    [anon_sym_LT_AMP] = ACTIONS(1036),
    [anon_sym_GT_GT] = ACTIONS(1036),
    [anon_sym_EQ_TILDE] = ACTIONS(1036),
    [sym__special_character] = ACTIONS(1036),
    [anon_sym_LT_LT_DASH] = ACTIONS(1036),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1036),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1036),
    [anon_sym_LF] = ACTIONS(1038),
    [anon_sym_SEMI] = ACTIONS(1036),
    [sym_raw_string] = ACTIONS(1036),
    [anon_sym_RPAREN] = ACTIONS(1036),
    [anon_sym_AMP] = ACTIONS(1036),
    [anon_sym_GT] = ACTIONS(1036),
    [sym_file_descriptor] = ACTIONS(1038),
    [anon_sym_AMP_GT] = ACTIONS(1036),
    [anon_sym_EQ_EQ] = ACTIONS(1036),
    [anon_sym_DQUOTE] = ACTIONS(1036),
    [anon_sym_LT_LT_LT] = ACTIONS(1036),
    [anon_sym_GT_AMP] = ACTIONS(1036),
    [anon_sym_BQUOTE] = ACTIONS(1036),
    [anon_sym_GT_LPAREN] = ACTIONS(1036),
    [sym_ansii_c_string] = ACTIONS(1036),
    [anon_sym_AMP_AMP] = ACTIONS(1036),
    [anon_sym_SEMI_SEMI] = ACTIONS(1036),
    [anon_sym_PIPE_AMP] = ACTIONS(1036),
  },
  [453] = {
    [sym_word] = ACTIONS(1032),
    [anon_sym_AMP_GT_GT] = ACTIONS(1032),
    [anon_sym_DOLLAR] = ACTIONS(1032),
    [anon_sym_LT_LT] = ACTIONS(1032),
    [anon_sym_LT_LPAREN] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1032),
    [sym__concat] = ACTIONS(1034),
    [anon_sym_PIPE] = ACTIONS(1032),
    [anon_sym_LT] = ACTIONS(1032),
    [anon_sym_LT_AMP] = ACTIONS(1032),
    [anon_sym_GT_GT] = ACTIONS(1032),
    [anon_sym_EQ_TILDE] = ACTIONS(1032),
    [sym__special_character] = ACTIONS(1032),
    [anon_sym_LT_LT_DASH] = ACTIONS(1032),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1032),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1032),
    [anon_sym_LF] = ACTIONS(1034),
    [anon_sym_SEMI] = ACTIONS(1032),
    [sym_raw_string] = ACTIONS(1032),
    [anon_sym_RPAREN] = ACTIONS(1032),
    [anon_sym_AMP] = ACTIONS(1032),
    [anon_sym_GT] = ACTIONS(1032),
    [sym_file_descriptor] = ACTIONS(1034),
    [anon_sym_AMP_GT] = ACTIONS(1032),
    [anon_sym_EQ_EQ] = ACTIONS(1032),
    [anon_sym_DQUOTE] = ACTIONS(1032),
    [anon_sym_LT_LT_LT] = ACTIONS(1032),
    [anon_sym_GT_AMP] = ACTIONS(1032),
    [anon_sym_BQUOTE] = ACTIONS(1032),
    [anon_sym_GT_LPAREN] = ACTIONS(1032),
    [sym_ansii_c_string] = ACTIONS(1032),
    [anon_sym_AMP_AMP] = ACTIONS(1032),
    [anon_sym_SEMI_SEMI] = ACTIONS(1032),
    [anon_sym_PIPE_AMP] = ACTIONS(1032),
  },
  [454] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1089),
    [anon_sym_LT_LT] = ACTIONS(1089),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1089),
    [anon_sym_PIPE] = ACTIONS(1089),
    [anon_sym_LT] = ACTIONS(1089),
    [anon_sym_LT_AMP] = ACTIONS(1089),
    [anon_sym_GT_GT] = ACTIONS(1089),
    [anon_sym_LT_LT_DASH] = ACTIONS(1089),
    [anon_sym_LF] = ACTIONS(1091),
    [anon_sym_SEMI] = ACTIONS(1089),
    [anon_sym_RPAREN] = ACTIONS(1089),
    [anon_sym_AMP] = ACTIONS(1089),
    [anon_sym_GT] = ACTIONS(1089),
    [sym_file_descriptor] = ACTIONS(1091),
    [anon_sym_AMP_GT] = ACTIONS(1089),
    [anon_sym_LT_LT_LT] = ACTIONS(1089),
    [anon_sym_GT_AMP] = ACTIONS(1089),
    [anon_sym_BQUOTE] = ACTIONS(1089),
    [anon_sym_esac] = ACTIONS(1089),
    [anon_sym_AMP_AMP] = ACTIONS(1089),
    [anon_sym_SEMI_SEMI] = ACTIONS(1089),
    [anon_sym_PIPE_AMP] = ACTIONS(1089),
  },
  [455] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [anon_sym_AMP_GT_GT] = ACTIONS(1093),
    [anon_sym_LT_LT] = ACTIONS(1093),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1093),
    [anon_sym_PIPE] = ACTIONS(1093),
    [anon_sym_LT] = ACTIONS(1093),
    [anon_sym_LT_AMP] = ACTIONS(1093),
    [anon_sym_GT_GT] = ACTIONS(1093),
    [anon_sym_LT_LT_DASH] = ACTIONS(1093),
    [anon_sym_LF] = ACTIONS(1095),
    [anon_sym_SEMI] = ACTIONS(1093),
    [anon_sym_RPAREN] = ACTIONS(1093),
    [anon_sym_AMP] = ACTIONS(1093),
    [anon_sym_GT] = ACTIONS(1093),
    [sym_file_descriptor] = ACTIONS(1095),
    [anon_sym_AMP_GT] = ACTIONS(1093),
    [anon_sym_LT_LT_LT] = ACTIONS(1093),
    [anon_sym_GT_AMP] = ACTIONS(1093),
    [anon_sym_BQUOTE] = ACTIONS(1093),
    [anon_sym_AMP_AMP] = ACTIONS(1093),
    [anon_sym_SEMI_SEMI] = ACTIONS(1093),
    [anon_sym_PIPE_AMP] = ACTIONS(1093),
  },
  [456] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(1093),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(1093),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1093),
    [anon_sym_PIPE] = ACTIONS(1093),
    [anon_sym_LT] = ACTIONS(1093),
    [anon_sym_LT_AMP] = ACTIONS(1093),
    [anon_sym_GT_GT] = ACTIONS(1093),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(1093),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(1095),
    [anon_sym_SEMI] = ACTIONS(1093),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(1095),
    [anon_sym_RPAREN] = ACTIONS(1093),
    [anon_sym_GT] = ACTIONS(1093),
    [anon_sym_AMP] = ACTIONS(1093),
    [anon_sym_AMP_GT] = ACTIONS(1093),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(1093),
    [anon_sym_GT_AMP] = ACTIONS(1093),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(1093),
    [anon_sym_SEMI_SEMI] = ACTIONS(1093),
    [anon_sym_PIPE_AMP] = ACTIONS(1093),
  },
  [457] = {
    [anon_sym_LF] = ACTIONS(1099),
    [anon_sym_SEMI] = ACTIONS(1097),
    [anon_sym_BQUOTE] = ACTIONS(1097),
    [anon_sym_esac] = ACTIONS(1097),
    [anon_sym_RPAREN] = ACTIONS(1097),
    [anon_sym_AMP] = ACTIONS(1097),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI_SEMI] = ACTIONS(1097),
  },
  [458] = {
    [anon_sym_RPAREN] = ACTIONS(2083),
    [anon_sym_AMP] = ACTIONS(2085),
    [anon_sym_LF] = ACTIONS(2087),
    [anon_sym_SEMI] = ACTIONS(2085),
    [anon_sym_SEMI_SEMI] = ACTIONS(2085),
    [sym_comment] = ACTIONS(3),
  },
  [459] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1119),
    [anon_sym_LT_LT] = ACTIONS(1119),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1119),
    [anon_sym_PIPE] = ACTIONS(1119),
    [anon_sym_LT] = ACTIONS(1119),
    [anon_sym_LT_AMP] = ACTIONS(1119),
    [anon_sym_GT_GT] = ACTIONS(1119),
    [anon_sym_LT_LT_DASH] = ACTIONS(1119),
    [anon_sym_LF] = ACTIONS(1121),
    [anon_sym_SEMI] = ACTIONS(1119),
    [anon_sym_RPAREN] = ACTIONS(1119),
    [anon_sym_AMP] = ACTIONS(1119),
    [anon_sym_GT] = ACTIONS(1119),
    [sym_file_descriptor] = ACTIONS(1121),
    [anon_sym_AMP_GT] = ACTIONS(1119),
    [anon_sym_LT_LT_LT] = ACTIONS(1119),
    [anon_sym_GT_AMP] = ACTIONS(1119),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [anon_sym_esac] = ACTIONS(1119),
    [anon_sym_AMP_AMP] = ACTIONS(1119),
    [anon_sym_SEMI_SEMI] = ACTIONS(1119),
    [anon_sym_PIPE_AMP] = ACTIONS(1119),
  },
  [460] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [anon_sym_AMP_GT_GT] = ACTIONS(1123),
    [anon_sym_LT_LT] = ACTIONS(1123),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1123),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(1123),
    [anon_sym_LT_AMP] = ACTIONS(1123),
    [anon_sym_GT_GT] = ACTIONS(1123),
    [anon_sym_LT_LT_DASH] = ACTIONS(1123),
    [anon_sym_LF] = ACTIONS(1125),
    [anon_sym_SEMI] = ACTIONS(1123),
    [anon_sym_RPAREN] = ACTIONS(1123),
    [anon_sym_AMP] = ACTIONS(1123),
    [anon_sym_GT] = ACTIONS(1123),
    [sym_file_descriptor] = ACTIONS(1125),
    [anon_sym_AMP_GT] = ACTIONS(1123),
    [anon_sym_LT_LT_LT] = ACTIONS(1123),
    [anon_sym_GT_AMP] = ACTIONS(1123),
    [anon_sym_AMP_AMP] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(1123),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [461] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(1123),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1123),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(1123),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(1125),
    [anon_sym_SEMI] = ACTIONS(1123),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_RPAREN] = ACTIONS(1123),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP] = ACTIONS(1123),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(1123),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(1123),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [462] = {
    [aux_sym_concatenation_repeat1] = STATE(1065),
    [anon_sym_AMP_GT_GT] = ACTIONS(1127),
    [anon_sym_LT_LT] = ACTIONS(1127),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1127),
    [sym__concat] = ACTIONS(2089),
    [anon_sym_PIPE] = ACTIONS(1127),
    [anon_sym_LT] = ACTIONS(1127),
    [anon_sym_LT_AMP] = ACTIONS(1127),
    [anon_sym_GT_GT] = ACTIONS(1127),
    [anon_sym_LT_LT_DASH] = ACTIONS(1127),
    [anon_sym_LF] = ACTIONS(1129),
    [anon_sym_SEMI] = ACTIONS(1127),
    [anon_sym_RPAREN] = ACTIONS(1127),
    [anon_sym_AMP] = ACTIONS(1127),
    [anon_sym_GT] = ACTIONS(1127),
    [sym_file_descriptor] = ACTIONS(1129),
    [anon_sym_AMP_GT] = ACTIONS(1127),
    [anon_sym_LT_LT_LT] = ACTIONS(1127),
    [anon_sym_GT_AMP] = ACTIONS(1127),
    [anon_sym_BQUOTE] = ACTIONS(1127),
    [anon_sym_AMP_AMP] = ACTIONS(1127),
    [anon_sym_SEMI_SEMI] = ACTIONS(1127),
    [anon_sym_PIPE_AMP] = ACTIONS(1127),
  },
  [463] = {
    [aux_sym__literal_repeat1] = STATE(1103),
    [anon_sym_AMP_GT_GT] = ACTIONS(1133),
    [anon_sym_LT_LT] = ACTIONS(1133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1133),
    [anon_sym_PIPE] = ACTIONS(1133),
    [anon_sym_LT] = ACTIONS(1133),
    [anon_sym_LT_AMP] = ACTIONS(1133),
    [anon_sym_GT_GT] = ACTIONS(1133),
    [sym__special_character] = ACTIONS(2091),
    [anon_sym_LT_LT_DASH] = ACTIONS(1133),
    [anon_sym_LF] = ACTIONS(1135),
    [anon_sym_SEMI] = ACTIONS(1133),
    [anon_sym_RPAREN] = ACTIONS(1133),
    [anon_sym_AMP] = ACTIONS(1133),
    [anon_sym_GT] = ACTIONS(1133),
    [sym_file_descriptor] = ACTIONS(1135),
    [anon_sym_AMP_GT] = ACTIONS(1133),
    [anon_sym_LT_LT_LT] = ACTIONS(1133),
    [anon_sym_GT_AMP] = ACTIONS(1133),
    [anon_sym_BQUOTE] = ACTIONS(1133),
    [anon_sym_esac] = ACTIONS(1133),
    [anon_sym_AMP_AMP] = ACTIONS(1133),
    [anon_sym_SEMI_SEMI] = ACTIONS(1133),
    [anon_sym_PIPE_AMP] = ACTIONS(1133),
  },
  [464] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1127),
    [anon_sym_LT_LT] = ACTIONS(1127),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1127),
    [anon_sym_PIPE] = ACTIONS(1127),
    [anon_sym_LT] = ACTIONS(1127),
    [anon_sym_LT_AMP] = ACTIONS(1127),
    [anon_sym_GT_GT] = ACTIONS(1127),
    [anon_sym_LT_LT_DASH] = ACTIONS(1127),
    [anon_sym_LF] = ACTIONS(1129),
    [anon_sym_SEMI] = ACTIONS(1127),
    [anon_sym_RPAREN] = ACTIONS(1127),
    [anon_sym_AMP] = ACTIONS(1127),
    [anon_sym_GT] = ACTIONS(1127),
    [sym_file_descriptor] = ACTIONS(1129),
    [anon_sym_AMP_GT] = ACTIONS(1127),
    [anon_sym_LT_LT_LT] = ACTIONS(1127),
    [anon_sym_GT_AMP] = ACTIONS(1127),
    [anon_sym_BQUOTE] = ACTIONS(1127),
    [anon_sym_esac] = ACTIONS(1127),
    [anon_sym_AMP_AMP] = ACTIONS(1127),
    [anon_sym_SEMI_SEMI] = ACTIONS(1127),
    [anon_sym_PIPE_AMP] = ACTIONS(1127),
  },
  [465] = {
    [sym_heredoc_redirect] = STATE(465),
    [aux_sym_redirected_statement_repeat1] = STATE(465),
    [sym_herestring_redirect] = STATE(465),
    [sym_file_redirect] = STATE(465),
    [anon_sym_AMP_GT_GT] = ACTIONS(2093),
    [anon_sym_LT_LT] = ACTIONS(2096),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1147),
    [anon_sym_PIPE] = ACTIONS(1147),
    [anon_sym_LT] = ACTIONS(2093),
    [anon_sym_LT_AMP] = ACTIONS(2093),
    [anon_sym_GT_GT] = ACTIONS(2093),
    [anon_sym_LT_LT_DASH] = ACTIONS(2096),
    [anon_sym_LF] = ACTIONS(1145),
    [anon_sym_SEMI] = ACTIONS(1147),
    [anon_sym_RPAREN] = ACTIONS(1147),
    [anon_sym_AMP] = ACTIONS(1147),
    [anon_sym_GT] = ACTIONS(2093),
    [sym_file_descriptor] = ACTIONS(2099),
    [anon_sym_AMP_GT] = ACTIONS(2093),
    [anon_sym_LT_LT_LT] = ACTIONS(2102),
    [anon_sym_GT_AMP] = ACTIONS(2093),
    [anon_sym_BQUOTE] = ACTIONS(1147),
    [anon_sym_AMP_AMP] = ACTIONS(1147),
    [anon_sym_SEMI_SEMI] = ACTIONS(1147),
    [anon_sym_PIPE_AMP] = ACTIONS(1147),
  },
  [466] = {
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_declare] = ACTIONS(636),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_RPAREN] = ACTIONS(1113),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_SEMI_SEMI] = ACTIONS(1113),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [sym_file_descriptor] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [467] = {
    [sym_heredoc_body] = STATE(492),
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__simple_heredoc_body] = ACTIONS(870),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(1113),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [sym__heredoc_body_beginning] = ACTIONS(872),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [468] = {
    [sym_command_substitution] = STATE(423),
    [aux_sym__literal_repeat1] = STATE(425),
    [sym_string] = STATE(423),
    [sym_process_substitution] = STATE(423),
    [sym_simple_expansion] = STATE(423),
    [sym_string_expansion] = STATE(423),
    [aux_sym_command_repeat2] = STATE(472),
    [sym_concatenation] = STATE(472),
    [sym_expansion] = STATE(423),
    [sym_word] = ACTIONS(1968),
    [anon_sym_AMP_GT_GT] = ACTIONS(1155),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LT] = ACTIONS(1155),
    [anon_sym_LT_LPAREN] = ACTIONS(1970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1155),
    [anon_sym_PIPE] = ACTIONS(1155),
    [anon_sym_LT] = ACTIONS(1155),
    [anon_sym_LT_AMP] = ACTIONS(1155),
    [anon_sym_GT_GT] = ACTIONS(1155),
    [anon_sym_EQ_TILDE] = ACTIONS(1972),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_LT_LT_DASH] = ACTIONS(1155),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1974),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1976),
    [anon_sym_LF] = ACTIONS(1157),
    [anon_sym_SEMI] = ACTIONS(1155),
    [sym_raw_string] = ACTIONS(1968),
    [anon_sym_RPAREN] = ACTIONS(1155),
    [anon_sym_AMP] = ACTIONS(1155),
    [anon_sym_GT] = ACTIONS(1155),
    [sym_file_descriptor] = ACTIONS(1157),
    [anon_sym_AMP_GT] = ACTIONS(1155),
    [anon_sym_EQ_EQ] = ACTIONS(1972),
    [anon_sym_DQUOTE] = ACTIONS(1978),
    [anon_sym_LT_LT_LT] = ACTIONS(1155),
    [anon_sym_GT_AMP] = ACTIONS(1155),
    [anon_sym_BQUOTE] = ACTIONS(1980),
    [anon_sym_GT_LPAREN] = ACTIONS(1970),
    [sym_ansii_c_string] = ACTIONS(1968),
    [anon_sym_AMP_AMP] = ACTIONS(1155),
    [anon_sym_SEMI_SEMI] = ACTIONS(1155),
    [anon_sym_PIPE_AMP] = ACTIONS(1155),
  },
  [469] = {
    [aux_sym_concatenation_repeat1] = STATE(393),
    [sym_word] = ACTIONS(1159),
    [anon_sym_AMP_GT_GT] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(1159),
    [anon_sym_LT_LT] = ACTIONS(1159),
    [anon_sym_LT_LPAREN] = ACTIONS(1159),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1159),
    [sym__concat] = ACTIONS(1918),
    [anon_sym_PIPE] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1159),
    [anon_sym_LT_AMP] = ACTIONS(1159),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_EQ_TILDE] = ACTIONS(1159),
    [sym__special_character] = ACTIONS(1159),
    [anon_sym_LT_LT_DASH] = ACTIONS(1159),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1159),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1159),
    [anon_sym_LF] = ACTIONS(1161),
    [anon_sym_SEMI] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(1159),
    [anon_sym_RPAREN] = ACTIONS(1159),
    [anon_sym_AMP] = ACTIONS(1159),
    [anon_sym_GT] = ACTIONS(1159),
    [sym_file_descriptor] = ACTIONS(1161),
    [anon_sym_AMP_GT] = ACTIONS(1159),
    [anon_sym_EQ_EQ] = ACTIONS(1159),
    [anon_sym_DQUOTE] = ACTIONS(1159),
    [anon_sym_LT_LT_LT] = ACTIONS(1159),
    [anon_sym_GT_AMP] = ACTIONS(1159),
    [anon_sym_BQUOTE] = ACTIONS(1159),
    [anon_sym_GT_LPAREN] = ACTIONS(1159),
    [sym_ansii_c_string] = ACTIONS(1159),
    [anon_sym_AMP_AMP] = ACTIONS(1159),
    [anon_sym_SEMI_SEMI] = ACTIONS(1159),
    [anon_sym_PIPE_AMP] = ACTIONS(1159),
  },
  [470] = {
    [sym_word] = ACTIONS(1159),
    [anon_sym_AMP_GT_GT] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(1159),
    [anon_sym_LT_LT] = ACTIONS(1159),
    [anon_sym_LT_LPAREN] = ACTIONS(1159),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1159),
    [anon_sym_PIPE] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1159),
    [anon_sym_LT_AMP] = ACTIONS(1159),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_EQ_TILDE] = ACTIONS(1159),
    [sym__special_character] = ACTIONS(1159),
    [anon_sym_LT_LT_DASH] = ACTIONS(1159),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1159),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1159),
    [anon_sym_LF] = ACTIONS(1161),
    [anon_sym_SEMI] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(1159),
    [anon_sym_RPAREN] = ACTIONS(1159),
    [anon_sym_AMP] = ACTIONS(1159),
    [anon_sym_GT] = ACTIONS(1159),
    [sym_file_descriptor] = ACTIONS(1161),
    [anon_sym_AMP_GT] = ACTIONS(1159),
    [anon_sym_EQ_EQ] = ACTIONS(1159),
    [anon_sym_DQUOTE] = ACTIONS(1159),
    [anon_sym_LT_LT_LT] = ACTIONS(1159),
    [anon_sym_GT_AMP] = ACTIONS(1159),
    [anon_sym_BQUOTE] = ACTIONS(1159),
    [anon_sym_GT_LPAREN] = ACTIONS(1159),
    [sym_ansii_c_string] = ACTIONS(1159),
    [anon_sym_AMP_AMP] = ACTIONS(1159),
    [anon_sym_SEMI_SEMI] = ACTIONS(1159),
    [anon_sym_PIPE_AMP] = ACTIONS(1159),
  },
  [471] = {
    [aux_sym__literal_repeat1] = STATE(413),
    [sym_word] = ACTIONS(1163),
    [anon_sym_AMP_GT_GT] = ACTIONS(1163),
    [anon_sym_DOLLAR] = ACTIONS(1163),
    [anon_sym_LT_LT] = ACTIONS(1163),
    [anon_sym_LT_LPAREN] = ACTIONS(1163),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1163),
    [anon_sym_PIPE] = ACTIONS(1163),
    [anon_sym_LT] = ACTIONS(1163),
    [anon_sym_LT_AMP] = ACTIONS(1163),
    [anon_sym_GT_GT] = ACTIONS(1163),
    [anon_sym_EQ_TILDE] = ACTIONS(1163),
    [sym__special_character] = ACTIONS(1958),
    [anon_sym_LT_LT_DASH] = ACTIONS(1163),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1163),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1163),
    [anon_sym_LF] = ACTIONS(1165),
    [anon_sym_SEMI] = ACTIONS(1163),
    [sym_raw_string] = ACTIONS(1163),
    [anon_sym_RPAREN] = ACTIONS(1163),
    [anon_sym_AMP] = ACTIONS(1163),
    [anon_sym_GT] = ACTIONS(1163),
    [sym_file_descriptor] = ACTIONS(1165),
    [anon_sym_AMP_GT] = ACTIONS(1163),
    [anon_sym_EQ_EQ] = ACTIONS(1163),
    [anon_sym_DQUOTE] = ACTIONS(1163),
    [anon_sym_LT_LT_LT] = ACTIONS(1163),
    [anon_sym_GT_AMP] = ACTIONS(1163),
    [anon_sym_BQUOTE] = ACTIONS(1163),
    [anon_sym_GT_LPAREN] = ACTIONS(1163),
    [sym_ansii_c_string] = ACTIONS(1163),
    [anon_sym_AMP_AMP] = ACTIONS(1163),
    [anon_sym_SEMI_SEMI] = ACTIONS(1163),
    [anon_sym_PIPE_AMP] = ACTIONS(1163),
  },
  [472] = {
    [sym_command_substitution] = STATE(423),
    [aux_sym__literal_repeat1] = STATE(425),
    [sym_string] = STATE(423),
    [sym_process_substitution] = STATE(423),
    [sym_simple_expansion] = STATE(423),
    [sym_string_expansion] = STATE(423),
    [aux_sym_command_repeat2] = STATE(472),
    [sym_concatenation] = STATE(472),
    [sym_expansion] = STATE(423),
    [sym_word] = ACTIONS(2105),
    [anon_sym_AMP_GT_GT] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(2108),
    [anon_sym_LT_LT] = ACTIONS(1159),
    [anon_sym_LT_LPAREN] = ACTIONS(2111),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1159),
    [anon_sym_PIPE] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1159),
    [anon_sym_LT_AMP] = ACTIONS(1159),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_EQ_TILDE] = ACTIONS(2114),
    [sym__special_character] = ACTIONS(2117),
    [anon_sym_LT_LT_DASH] = ACTIONS(1159),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2120),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2123),
    [anon_sym_LF] = ACTIONS(1161),
    [anon_sym_SEMI] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(2105),
    [anon_sym_RPAREN] = ACTIONS(1159),
    [anon_sym_AMP] = ACTIONS(1159),
    [anon_sym_GT] = ACTIONS(1159),
    [sym_file_descriptor] = ACTIONS(1161),
    [anon_sym_AMP_GT] = ACTIONS(1159),
    [anon_sym_EQ_EQ] = ACTIONS(2114),
    [anon_sym_DQUOTE] = ACTIONS(2126),
    [anon_sym_LT_LT_LT] = ACTIONS(1159),
    [anon_sym_GT_AMP] = ACTIONS(1159),
    [anon_sym_BQUOTE] = ACTIONS(2129),
    [anon_sym_GT_LPAREN] = ACTIONS(2111),
    [sym_ansii_c_string] = ACTIONS(2105),
    [anon_sym_AMP_AMP] = ACTIONS(1159),
    [anon_sym_SEMI_SEMI] = ACTIONS(1159),
    [anon_sym_PIPE_AMP] = ACTIONS(1159),
  },
  [473] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1194),
    [anon_sym_LT_LT] = ACTIONS(1194),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1194),
    [anon_sym_PIPE] = ACTIONS(1194),
    [anon_sym_LT] = ACTIONS(1194),
    [anon_sym_LT_AMP] = ACTIONS(1194),
    [anon_sym_GT_GT] = ACTIONS(1194),
    [anon_sym_LT_LT_DASH] = ACTIONS(1194),
    [anon_sym_LF] = ACTIONS(1196),
    [anon_sym_SEMI] = ACTIONS(1194),
    [anon_sym_RPAREN] = ACTIONS(1194),
    [anon_sym_AMP] = ACTIONS(1194),
    [anon_sym_GT] = ACTIONS(1194),
    [sym_file_descriptor] = ACTIONS(1196),
    [anon_sym_AMP_GT] = ACTIONS(1194),
    [anon_sym_LT_LT_LT] = ACTIONS(1194),
    [anon_sym_GT_AMP] = ACTIONS(1194),
    [anon_sym_BQUOTE] = ACTIONS(1194),
    [anon_sym_esac] = ACTIONS(1194),
    [anon_sym_AMP_AMP] = ACTIONS(1194),
    [anon_sym_SEMI_SEMI] = ACTIONS(1194),
    [anon_sym_PIPE_AMP] = ACTIONS(1194),
  },
  [474] = {
    [sym_string] = STATE(405),
    [sym_word] = ACTIONS(1198),
    [anon_sym_AMP_GT_GT] = ACTIONS(1198),
    [anon_sym_DOLLAR] = ACTIONS(2132),
    [anon_sym_DASH] = ACTIONS(2132),
    [anon_sym_LT_LPAREN] = ACTIONS(1198),
    [sym_comment] = ACTIONS(3),
    [anon_sym__] = ACTIONS(2134),
    [anon_sym_PIPE] = ACTIONS(1198),
    [anon_sym_LT_AMP] = ACTIONS(1198),
    [sym__special_character] = ACTIONS(1198),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2134),
    [sym_raw_string] = ACTIONS(2136),
    [anon_sym_SEMI] = ACTIONS(1198),
    [anon_sym_RPAREN] = ACTIONS(1198),
    [anon_sym_AMP] = ACTIONS(1198),
    [anon_sym_DQUOTE] = ACTIONS(1978),
    [anon_sym_GT_AMP] = ACTIONS(1198),
    [anon_sym_STAR] = ACTIONS(2134),
    [sym_ansii_c_string] = ACTIONS(1198),
    [anon_sym_AMP_AMP] = ACTIONS(1198),
    [anon_sym_SEMI_SEMI] = ACTIONS(1198),
    [anon_sym_LT_LT] = ACTIONS(1198),
    [anon_sym_POUND] = ACTIONS(2132),
    [anon_sym_PIPE_PIPE] = ACTIONS(1198),
    [anon_sym_AT] = ACTIONS(2134),
    [anon_sym_LT] = ACTIONS(1198),
    [anon_sym_GT_GT] = ACTIONS(1198),
    [anon_sym_EQ_TILDE] = ACTIONS(1198),
    [anon_sym_LT_LT_DASH] = ACTIONS(1198),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1198),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1198),
    [anon_sym_LF] = ACTIONS(1202),
    [anon_sym_BANG] = ACTIONS(2132),
    [sym_file_descriptor] = ACTIONS(1202),
    [anon_sym_QMARK] = ACTIONS(2134),
    [anon_sym_GT] = ACTIONS(1198),
    [anon_sym_AMP_GT] = ACTIONS(1198),
    [anon_sym_EQ_EQ] = ACTIONS(1198),
    [anon_sym_LT_LT_LT] = ACTIONS(1198),
    [anon_sym_BQUOTE] = ACTIONS(1198),
    [anon_sym_GT_LPAREN] = ACTIONS(1198),
    [anon_sym_0] = ACTIONS(2134),
    [anon_sym_PIPE_AMP] = ACTIONS(1198),
  },
  [475] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1210),
    [anon_sym_LT_LT] = ACTIONS(1210),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1210),
    [anon_sym_PIPE] = ACTIONS(1210),
    [anon_sym_LT] = ACTIONS(1210),
    [anon_sym_LT_AMP] = ACTIONS(1210),
    [anon_sym_GT_GT] = ACTIONS(1210),
    [anon_sym_LT_LT_DASH] = ACTIONS(1210),
    [anon_sym_LF] = ACTIONS(1212),
    [anon_sym_SEMI] = ACTIONS(1210),
    [anon_sym_RPAREN] = ACTIONS(1210),
    [anon_sym_AMP] = ACTIONS(1210),
    [anon_sym_GT] = ACTIONS(1210),
    [sym_file_descriptor] = ACTIONS(1212),
    [anon_sym_AMP_GT] = ACTIONS(1210),
    [anon_sym_LT_LT_LT] = ACTIONS(1210),
    [anon_sym_GT_AMP] = ACTIONS(1210),
    [anon_sym_BQUOTE] = ACTIONS(1210),
    [anon_sym_esac] = ACTIONS(1210),
    [anon_sym_AMP_AMP] = ACTIONS(1210),
    [anon_sym_SEMI_SEMI] = ACTIONS(1210),
    [anon_sym_PIPE_AMP] = ACTIONS(1210),
  },
  [476] = {
    [anon_sym_BANG_EQ] = ACTIONS(1244),
    [anon_sym_PLUS_EQ] = ACTIONS(1244),
    [anon_sym_PLUS_PLUS] = ACTIONS(1244),
    [anon_sym_RBRACK] = ACTIONS(1244),
    [anon_sym_DASH] = ACTIONS(1246),
    [anon_sym_GT] = ACTIONS(1246),
    [anon_sym_EQ] = ACTIONS(1246),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(1244),
    [anon_sym_PIPE_PIPE] = ACTIONS(1244),
    [anon_sym_GT_EQ] = ACTIONS(1244),
    [anon_sym_PLUS] = ACTIONS(1246),
    [anon_sym_LT] = ACTIONS(1246),
    [sym_test_operator] = ACTIONS(1244),
    [anon_sym_EQ_TILDE] = ACTIONS(1244),
    [anon_sym_DASH_DASH] = ACTIONS(1244),
    [anon_sym_LT_EQ] = ACTIONS(1244),
    [anon_sym_AMP_AMP] = ACTIONS(1244),
    [anon_sym_DASH_EQ] = ACTIONS(1244),
  },
  [477] = {
    [anon_sym_BANG_EQ] = ACTIONS(1248),
    [anon_sym_PLUS_EQ] = ACTIONS(1248),
    [anon_sym_PLUS_PLUS] = ACTIONS(1248),
    [anon_sym_RBRACK] = ACTIONS(1248),
    [anon_sym_DASH] = ACTIONS(1250),
    [anon_sym_GT] = ACTIONS(1250),
    [anon_sym_EQ] = ACTIONS(1250),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(1248),
    [anon_sym_PIPE_PIPE] = ACTIONS(1248),
    [anon_sym_GT_EQ] = ACTIONS(1248),
    [anon_sym_PLUS] = ACTIONS(1250),
    [anon_sym_LT] = ACTIONS(1250),
    [sym_test_operator] = ACTIONS(1248),
    [anon_sym_EQ_TILDE] = ACTIONS(1248),
    [anon_sym_DASH_DASH] = ACTIONS(1248),
    [anon_sym_LT_EQ] = ACTIONS(1248),
    [anon_sym_AMP_AMP] = ACTIONS(1248),
    [anon_sym_DASH_EQ] = ACTIONS(1248),
  },
  [478] = {
    [anon_sym_BANG_EQ] = ACTIONS(1248),
    [anon_sym_PLUS_EQ] = ACTIONS(1248),
    [anon_sym_PLUS_PLUS] = ACTIONS(1248),
    [anon_sym_RBRACK] = ACTIONS(1248),
    [anon_sym_DASH] = ACTIONS(1250),
    [anon_sym_GT] = ACTIONS(1250),
    [anon_sym_EQ] = ACTIONS(1250),
    [sym_comment] = ACTIONS(19),
    [anon_sym_EQ_EQ] = ACTIONS(1248),
    [anon_sym_PIPE_PIPE] = ACTIONS(1248),
    [anon_sym_GT_EQ] = ACTIONS(1248),
    [anon_sym_PLUS] = ACTIONS(1250),
    [anon_sym_LT] = ACTIONS(1250),
    [sym_test_operator] = ACTIONS(1248),
    [anon_sym_EQ_TILDE] = ACTIONS(1248),
    [anon_sym_DASH_DASH] = ACTIONS(1248),
    [anon_sym_LT_EQ] = ACTIONS(1248),
    [anon_sym_AMP_AMP] = ACTIONS(1248),
    [anon_sym_DASH_EQ] = ACTIONS(1248),
  },
  [479] = {
    [sym_word] = ACTIONS(1252),
    [anon_sym_AMP_GT_GT] = ACTIONS(1252),
    [anon_sym_DOLLAR] = ACTIONS(1252),
    [anon_sym_LT_LT] = ACTIONS(1252),
    [anon_sym_LT_LPAREN] = ACTIONS(1252),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1252),
    [sym__concat] = ACTIONS(1254),
    [anon_sym_PIPE] = ACTIONS(1252),
    [anon_sym_LT] = ACTIONS(1252),
    [anon_sym_LT_AMP] = ACTIONS(1252),
    [anon_sym_GT_GT] = ACTIONS(1252),
    [anon_sym_EQ_TILDE] = ACTIONS(1252),
    [sym__special_character] = ACTIONS(1252),
    [anon_sym_LT_LT_DASH] = ACTIONS(1252),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1252),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1252),
    [anon_sym_LF] = ACTIONS(1254),
    [anon_sym_SEMI] = ACTIONS(1252),
    [sym_raw_string] = ACTIONS(1252),
    [anon_sym_RPAREN] = ACTIONS(1252),
    [anon_sym_AMP] = ACTIONS(1252),
    [anon_sym_GT] = ACTIONS(1252),
    [sym_file_descriptor] = ACTIONS(1254),
    [anon_sym_AMP_GT] = ACTIONS(1252),
    [anon_sym_EQ_EQ] = ACTIONS(1252),
    [anon_sym_DQUOTE] = ACTIONS(1252),
    [anon_sym_LT_LT_LT] = ACTIONS(1252),
    [anon_sym_GT_AMP] = ACTIONS(1252),
    [anon_sym_BQUOTE] = ACTIONS(1252),
    [anon_sym_GT_LPAREN] = ACTIONS(1252),
    [sym_ansii_c_string] = ACTIONS(1252),
    [anon_sym_AMP_AMP] = ACTIONS(1252),
    [anon_sym_SEMI_SEMI] = ACTIONS(1252),
    [anon_sym_PIPE_AMP] = ACTIONS(1252),
  },
  [480] = {
    [sym_word] = ACTIONS(1301),
    [anon_sym_AMP_GT_GT] = ACTIONS(1301),
    [anon_sym_DOLLAR] = ACTIONS(1301),
    [anon_sym_LT_LT] = ACTIONS(1301),
    [anon_sym_LT_LPAREN] = ACTIONS(1301),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1301),
    [sym__concat] = ACTIONS(1303),
    [anon_sym_PIPE] = ACTIONS(1301),
    [anon_sym_LT] = ACTIONS(1301),
    [anon_sym_LT_AMP] = ACTIONS(1301),
    [anon_sym_GT_GT] = ACTIONS(1301),
    [anon_sym_EQ_TILDE] = ACTIONS(1301),
    [sym__special_character] = ACTIONS(1301),
    [anon_sym_LT_LT_DASH] = ACTIONS(1301),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1301),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1301),
    [anon_sym_LF] = ACTIONS(1303),
    [anon_sym_SEMI] = ACTIONS(1301),
    [sym_raw_string] = ACTIONS(1301),
    [anon_sym_RPAREN] = ACTIONS(1301),
    [anon_sym_AMP] = ACTIONS(1301),
    [anon_sym_GT] = ACTIONS(1301),
    [sym_file_descriptor] = ACTIONS(1303),
    [anon_sym_AMP_GT] = ACTIONS(1301),
    [anon_sym_EQ_EQ] = ACTIONS(1301),
    [anon_sym_DQUOTE] = ACTIONS(1301),
    [anon_sym_LT_LT_LT] = ACTIONS(1301),
    [anon_sym_GT_AMP] = ACTIONS(1301),
    [anon_sym_BQUOTE] = ACTIONS(1301),
    [anon_sym_GT_LPAREN] = ACTIONS(1301),
    [sym_ansii_c_string] = ACTIONS(1301),
    [anon_sym_AMP_AMP] = ACTIONS(1301),
    [anon_sym_SEMI_SEMI] = ACTIONS(1301),
    [anon_sym_PIPE_AMP] = ACTIONS(1301),
  },
  [481] = {
    [sym_word] = ACTIONS(1319),
    [anon_sym_AMP_GT_GT] = ACTIONS(1319),
    [anon_sym_DOLLAR] = ACTIONS(1319),
    [anon_sym_LT_LT] = ACTIONS(1319),
    [anon_sym_LT_LPAREN] = ACTIONS(1319),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1319),
    [sym__concat] = ACTIONS(1321),
    [anon_sym_PIPE] = ACTIONS(1319),
    [anon_sym_LT] = ACTIONS(1319),
    [anon_sym_LT_AMP] = ACTIONS(1319),
    [anon_sym_GT_GT] = ACTIONS(1319),
    [anon_sym_EQ_TILDE] = ACTIONS(1319),
    [sym__special_character] = ACTIONS(1319),
    [anon_sym_LT_LT_DASH] = ACTIONS(1319),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1319),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1319),
    [anon_sym_LF] = ACTIONS(1321),
    [anon_sym_SEMI] = ACTIONS(1319),
    [sym_raw_string] = ACTIONS(1319),
    [anon_sym_RPAREN] = ACTIONS(1319),
    [anon_sym_AMP] = ACTIONS(1319),
    [anon_sym_GT] = ACTIONS(1319),
    [sym_file_descriptor] = ACTIONS(1321),
    [anon_sym_AMP_GT] = ACTIONS(1319),
    [anon_sym_EQ_EQ] = ACTIONS(1319),
    [anon_sym_DQUOTE] = ACTIONS(1319),
    [anon_sym_LT_LT_LT] = ACTIONS(1319),
    [anon_sym_GT_AMP] = ACTIONS(1319),
    [anon_sym_BQUOTE] = ACTIONS(1319),
    [anon_sym_GT_LPAREN] = ACTIONS(1319),
    [sym_ansii_c_string] = ACTIONS(1319),
    [anon_sym_AMP_AMP] = ACTIONS(1319),
    [anon_sym_SEMI_SEMI] = ACTIONS(1319),
    [anon_sym_PIPE_AMP] = ACTIONS(1319),
  },
  [482] = {
    [aux_sym_concatenation_repeat1] = STATE(1161),
    [sym_word] = ACTIONS(1333),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1333),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1333),
    [sym_raw_string] = ACTIONS(1333),
    [anon_sym_LF] = ACTIONS(1329),
    [anon_sym_SEMI] = ACTIONS(1333),
    [anon_sym_DOLLAR] = ACTIONS(1333),
    [anon_sym_AMP] = ACTIONS(1333),
    [anon_sym_LT_LPAREN] = ACTIONS(1333),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1333),
    [sym__concat] = ACTIONS(2138),
    [anon_sym_BQUOTE] = ACTIONS(1333),
    [anon_sym_GT_LPAREN] = ACTIONS(1333),
    [sym_ansii_c_string] = ACTIONS(1333),
    [sym__special_character] = ACTIONS(1333),
    [anon_sym_SEMI_SEMI] = ACTIONS(1333),
  },
  [483] = {
    [sym_word] = ACTIONS(1335),
    [anon_sym_AMP_GT_GT] = ACTIONS(1335),
    [anon_sym_DOLLAR] = ACTIONS(1335),
    [anon_sym_LT_LT] = ACTIONS(1335),
    [anon_sym_LT_LPAREN] = ACTIONS(1335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1335),
    [anon_sym_PIPE] = ACTIONS(1335),
    [anon_sym_LT] = ACTIONS(1335),
    [anon_sym_LT_AMP] = ACTIONS(1335),
    [anon_sym_GT_GT] = ACTIONS(1335),
    [sym__special_character] = ACTIONS(1335),
    [anon_sym_LT_LT_DASH] = ACTIONS(1335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1335),
    [anon_sym_LF] = ACTIONS(1337),
    [anon_sym_SEMI] = ACTIONS(1335),
    [sym_raw_string] = ACTIONS(1335),
    [sym_variable_name] = ACTIONS(1337),
    [anon_sym_RPAREN] = ACTIONS(1335),
    [anon_sym_AMP] = ACTIONS(1335),
    [anon_sym_GT] = ACTIONS(1335),
    [sym_file_descriptor] = ACTIONS(1337),
    [anon_sym_AMP_GT] = ACTIONS(1335),
    [anon_sym_DQUOTE] = ACTIONS(1335),
    [anon_sym_LT_LT_LT] = ACTIONS(1335),
    [anon_sym_GT_AMP] = ACTIONS(1335),
    [anon_sym_BQUOTE] = ACTIONS(1335),
    [anon_sym_GT_LPAREN] = ACTIONS(1335),
    [sym_ansii_c_string] = ACTIONS(1335),
    [anon_sym_AMP_AMP] = ACTIONS(1335),
    [anon_sym_SEMI_SEMI] = ACTIONS(1335),
    [anon_sym_PIPE_AMP] = ACTIONS(1335),
  },
  [484] = {
    [aux_sym__literal_repeat1] = STATE(1199),
    [sym_word] = ACTIONS(1341),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1341),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1341),
    [sym_raw_string] = ACTIONS(1341),
    [anon_sym_LF] = ACTIONS(1339),
    [anon_sym_SEMI] = ACTIONS(1341),
    [anon_sym_DOLLAR] = ACTIONS(1341),
    [anon_sym_AMP] = ACTIONS(1341),
    [anon_sym_LT_LPAREN] = ACTIONS(1341),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1341),
    [anon_sym_BQUOTE] = ACTIONS(1341),
    [anon_sym_GT_LPAREN] = ACTIONS(1341),
    [sym_ansii_c_string] = ACTIONS(1341),
    [sym__special_character] = ACTIONS(2140),
    [anon_sym_SEMI_SEMI] = ACTIONS(1341),
  },
  [485] = {
    [sym_word] = ACTIONS(2142),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1347),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1347),
    [sym_raw_string] = ACTIONS(1347),
    [anon_sym_COLON] = ACTIONS(2142),
    [anon_sym_DOLLAR] = ACTIONS(2142),
    [anon_sym_RBRACE] = ACTIONS(1347),
    [anon_sym_DASH] = ACTIONS(2142),
    [anon_sym_EQ] = ACTIONS(2142),
    [anon_sym_PERCENT] = ACTIONS(2142),
    [anon_sym_POUND] = ACTIONS(1347),
    [anon_sym_COLON_DASH] = ACTIONS(2142),
    [anon_sym_SLASH] = ACTIONS(1347),
    [anon_sym_LT_LPAREN] = ACTIONS(1347),
    [anon_sym_DQUOTE] = ACTIONS(1347),
    [sym__concat] = ACTIONS(2144),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1347),
    [anon_sym_GT_LPAREN] = ACTIONS(1347),
    [sym_ansii_c_string] = ACTIONS(1347),
    [anon_sym_COLON_QMARK] = ACTIONS(2142),
    [sym__special_character] = ACTIONS(2142),
  },
  [486] = {
    [sym_word] = ACTIONS(2146),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1357),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1357),
    [sym_raw_string] = ACTIONS(1357),
    [anon_sym_COLON] = ACTIONS(2146),
    [anon_sym_DOLLAR] = ACTIONS(2146),
    [anon_sym_RBRACE] = ACTIONS(1357),
    [anon_sym_DASH] = ACTIONS(2146),
    [anon_sym_EQ] = ACTIONS(2146),
    [anon_sym_PERCENT] = ACTIONS(2146),
    [anon_sym_POUND] = ACTIONS(1357),
    [anon_sym_COLON_DASH] = ACTIONS(2146),
    [anon_sym_SLASH] = ACTIONS(1357),
    [anon_sym_LT_LPAREN] = ACTIONS(1357),
    [anon_sym_DQUOTE] = ACTIONS(1357),
    [sym__concat] = ACTIONS(2148),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1357),
    [anon_sym_GT_LPAREN] = ACTIONS(1357),
    [sym_ansii_c_string] = ACTIONS(1357),
    [anon_sym_COLON_QMARK] = ACTIONS(2146),
    [sym__special_character] = ACTIONS(2146),
  },
  [487] = {
    [sym_word] = ACTIONS(1365),
    [anon_sym_AMP_GT_GT] = ACTIONS(1365),
    [anon_sym_DOLLAR] = ACTIONS(1365),
    [anon_sym_LT_LT] = ACTIONS(1365),
    [anon_sym_LT_LPAREN] = ACTIONS(1365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1365),
    [sym__concat] = ACTIONS(1367),
    [anon_sym_PIPE] = ACTIONS(1365),
    [anon_sym_LT] = ACTIONS(1365),
    [anon_sym_LT_AMP] = ACTIONS(1365),
    [anon_sym_GT_GT] = ACTIONS(1365),
    [anon_sym_EQ_TILDE] = ACTIONS(1365),
    [sym__special_character] = ACTIONS(1365),
    [anon_sym_LT_LT_DASH] = ACTIONS(1365),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1365),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1365),
    [anon_sym_LF] = ACTIONS(1367),
    [anon_sym_SEMI] = ACTIONS(1365),
    [sym_raw_string] = ACTIONS(1365),
    [anon_sym_RPAREN] = ACTIONS(1365),
    [anon_sym_AMP] = ACTIONS(1365),
    [anon_sym_GT] = ACTIONS(1365),
    [sym_file_descriptor] = ACTIONS(1367),
    [anon_sym_AMP_GT] = ACTIONS(1365),
    [anon_sym_EQ_EQ] = ACTIONS(1365),
    [anon_sym_DQUOTE] = ACTIONS(1365),
    [anon_sym_LT_LT_LT] = ACTIONS(1365),
    [anon_sym_GT_AMP] = ACTIONS(1365),
    [anon_sym_BQUOTE] = ACTIONS(1365),
    [anon_sym_GT_LPAREN] = ACTIONS(1365),
    [sym_ansii_c_string] = ACTIONS(1365),
    [anon_sym_AMP_AMP] = ACTIONS(1365),
    [anon_sym_SEMI_SEMI] = ACTIONS(1365),
    [anon_sym_PIPE_AMP] = ACTIONS(1365),
  },
  [488] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1369),
    [anon_sym_LT_LT] = ACTIONS(1369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1369),
    [anon_sym_PIPE] = ACTIONS(1369),
    [anon_sym_LT] = ACTIONS(1369),
    [anon_sym_LT_AMP] = ACTIONS(1369),
    [anon_sym_GT_GT] = ACTIONS(1369),
    [anon_sym_LT_LT_DASH] = ACTIONS(1369),
    [anon_sym_LF] = ACTIONS(1371),
    [anon_sym_SEMI] = ACTIONS(1369),
    [anon_sym_RPAREN] = ACTIONS(1369),
    [anon_sym_AMP] = ACTIONS(1369),
    [anon_sym_GT] = ACTIONS(1369),
    [sym_file_descriptor] = ACTIONS(1371),
    [anon_sym_AMP_GT] = ACTIONS(1369),
    [anon_sym_LT_LT_LT] = ACTIONS(1369),
    [anon_sym_GT_AMP] = ACTIONS(1369),
    [anon_sym_BQUOTE] = ACTIONS(1369),
    [anon_sym_esac] = ACTIONS(1369),
    [anon_sym_AMP_AMP] = ACTIONS(1369),
    [anon_sym_SEMI_SEMI] = ACTIONS(1369),
    [anon_sym_PIPE_AMP] = ACTIONS(1369),
  },
  [489] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1395),
    [anon_sym_LT_LT] = ACTIONS(1395),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1395),
    [anon_sym_PIPE] = ACTIONS(1395),
    [anon_sym_LT] = ACTIONS(1395),
    [anon_sym_LT_AMP] = ACTIONS(1395),
    [anon_sym_GT_GT] = ACTIONS(1395),
    [anon_sym_LT_LT_DASH] = ACTIONS(1395),
    [anon_sym_LF] = ACTIONS(1397),
    [anon_sym_SEMI] = ACTIONS(1395),
    [anon_sym_RPAREN] = ACTIONS(1395),
    [anon_sym_AMP] = ACTIONS(1395),
    [anon_sym_GT] = ACTIONS(1395),
    [sym_file_descriptor] = ACTIONS(1397),
    [anon_sym_AMP_GT] = ACTIONS(1395),
    [anon_sym_LT_LT_LT] = ACTIONS(1395),
    [anon_sym_GT_AMP] = ACTIONS(1395),
    [anon_sym_BQUOTE] = ACTIONS(1395),
    [anon_sym_esac] = ACTIONS(1395),
    [anon_sym_AMP_AMP] = ACTIONS(1395),
    [anon_sym_SEMI_SEMI] = ACTIONS(1395),
    [anon_sym_PIPE_AMP] = ACTIONS(1395),
  },
  [490] = {
    [anon_sym_LF] = ACTIONS(1409),
    [anon_sym_SEMI] = ACTIONS(1407),
    [anon_sym_BQUOTE] = ACTIONS(1407),
    [anon_sym_esac] = ACTIONS(1407),
    [anon_sym_RPAREN] = ACTIONS(1407),
    [anon_sym_AMP] = ACTIONS(1407),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI_SEMI] = ACTIONS(1407),
  },
  [491] = {
    [sym_word] = ACTIONS(1415),
    [anon_sym_AMP_GT_GT] = ACTIONS(1417),
    [anon_sym_typeset] = ACTIONS(1415),
    [anon_sym_DOLLAR] = ACTIONS(1415),
    [anon_sym_LT_LPAREN] = ACTIONS(1417),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT_AMP] = ACTIONS(1417),
    [anon_sym_export] = ACTIONS(1415),
    [sym__special_character] = ACTIONS(1415),
    [anon_sym_if] = ACTIONS(1415),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1417),
    [sym_raw_string] = ACTIONS(1417),
    [anon_sym_declare] = ACTIONS(1415),
    [sym_variable_name] = ACTIONS(1417),
    [anon_sym_RPAREN] = ACTIONS(1419),
    [anon_sym_readonly] = ACTIONS(1415),
    [anon_sym_unset] = ACTIONS(1415),
    [anon_sym_DQUOTE] = ACTIONS(1417),
    [anon_sym_GT_AMP] = ACTIONS(1417),
    [sym_ansii_c_string] = ACTIONS(1417),
    [anon_sym_while] = ACTIONS(1415),
    [anon_sym_SEMI_SEMI] = ACTIONS(1419),
    [anon_sym_LPAREN] = ACTIONS(1415),
    [anon_sym_local] = ACTIONS(1415),
    [anon_sym_unsetenv] = ACTIONS(1415),
    [anon_sym_function] = ACTIONS(1415),
    [anon_sym_LBRACE] = ACTIONS(1417),
    [anon_sym_LT] = ACTIONS(1415),
    [anon_sym_GT_GT] = ACTIONS(1417),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1417),
    [anon_sym_case] = ACTIONS(1415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1417),
    [anon_sym_BANG] = ACTIONS(1415),
    [sym_file_descriptor] = ACTIONS(1417),
    [anon_sym_GT] = ACTIONS(1415),
    [anon_sym_AMP_GT] = ACTIONS(1415),
    [anon_sym_BQUOTE] = ACTIONS(1417),
    [anon_sym_GT_LPAREN] = ACTIONS(1417),
    [anon_sym_for] = ACTIONS(1415),
    [anon_sym_LBRACK] = ACTIONS(1415),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1417),
  },
  [492] = {
    [anon_sym_RPAREN] = ACTIONS(2150),
    [anon_sym_AMP] = ACTIONS(2152),
    [anon_sym_LF] = ACTIONS(2154),
    [anon_sym_SEMI] = ACTIONS(2152),
    [anon_sym_SEMI_SEMI] = ACTIONS(2152),
    [sym_comment] = ACTIONS(3),
  },
  [493] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1425),
    [anon_sym_LT_LT] = ACTIONS(1425),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1425),
    [anon_sym_PIPE] = ACTIONS(1425),
    [anon_sym_LT] = ACTIONS(1425),
    [anon_sym_LT_AMP] = ACTIONS(1425),
    [anon_sym_GT_GT] = ACTIONS(1425),
    [anon_sym_LT_LT_DASH] = ACTIONS(1425),
    [anon_sym_LF] = ACTIONS(1427),
    [anon_sym_SEMI] = ACTIONS(1425),
    [anon_sym_RPAREN] = ACTIONS(1425),
    [anon_sym_AMP] = ACTIONS(1425),
    [anon_sym_GT] = ACTIONS(1425),
    [sym_file_descriptor] = ACTIONS(1427),
    [anon_sym_AMP_GT] = ACTIONS(1425),
    [anon_sym_LT_LT_LT] = ACTIONS(1425),
    [anon_sym_GT_AMP] = ACTIONS(1425),
    [anon_sym_BQUOTE] = ACTIONS(1425),
    [anon_sym_esac] = ACTIONS(1425),
    [anon_sym_AMP_AMP] = ACTIONS(1425),
    [anon_sym_SEMI_SEMI] = ACTIONS(1425),
    [anon_sym_PIPE_AMP] = ACTIONS(1425),
  },
  [494] = {
    [anon_sym_LPAREN] = ACTIONS(1415),
    [sym_word] = ACTIONS(1415),
    [anon_sym_AMP_GT_GT] = ACTIONS(1417),
    [anon_sym_local] = ACTIONS(1415),
    [anon_sym_typeset] = ACTIONS(1415),
    [anon_sym_unsetenv] = ACTIONS(1415),
    [anon_sym_DOLLAR] = ACTIONS(1415),
    [anon_sym_LT_LPAREN] = ACTIONS(1417),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(1415),
    [anon_sym_LBRACE] = ACTIONS(1417),
    [anon_sym_LT] = ACTIONS(1415),
    [anon_sym_LT_AMP] = ACTIONS(1417),
    [anon_sym_GT_GT] = ACTIONS(1417),
    [anon_sym_export] = ACTIONS(1415),
    [sym__special_character] = ACTIONS(1415),
    [anon_sym_if] = ACTIONS(1415),
    [anon_sym_case] = ACTIONS(1415),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1417),
    [sym_raw_string] = ACTIONS(1417),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1417),
    [anon_sym_BANG] = ACTIONS(1415),
    [anon_sym_declare] = ACTIONS(1415),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1417),
    [sym_file_descriptor] = ACTIONS(1417),
    [sym_variable_name] = ACTIONS(1417),
    [anon_sym_GT] = ACTIONS(1415),
    [anon_sym_AMP_GT] = ACTIONS(1415),
    [anon_sym_readonly] = ACTIONS(1415),
    [anon_sym_unset] = ACTIONS(1415),
    [anon_sym_DQUOTE] = ACTIONS(1417),
    [anon_sym_GT_AMP] = ACTIONS(1417),
    [anon_sym_BQUOTE] = ACTIONS(1417),
    [anon_sym_GT_LPAREN] = ACTIONS(1417),
    [anon_sym_for] = ACTIONS(1415),
    [anon_sym_while] = ACTIONS(1415),
    [anon_sym_LBRACK] = ACTIONS(1415),
    [sym_ansii_c_string] = ACTIONS(1417),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1417),
  },
  [495] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1437),
    [anon_sym_LT_LT] = ACTIONS(1437),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1437),
    [anon_sym_PIPE] = ACTIONS(1437),
    [anon_sym_LT] = ACTIONS(1437),
    [anon_sym_LT_AMP] = ACTIONS(1437),
    [anon_sym_GT_GT] = ACTIONS(1437),
    [anon_sym_LT_LT_DASH] = ACTIONS(1437),
    [anon_sym_LF] = ACTIONS(1439),
    [anon_sym_SEMI] = ACTIONS(1437),
    [anon_sym_RPAREN] = ACTIONS(1437),
    [anon_sym_AMP] = ACTIONS(1437),
    [anon_sym_GT] = ACTIONS(1437),
    [sym_file_descriptor] = ACTIONS(1439),
    [anon_sym_AMP_GT] = ACTIONS(1437),
    [anon_sym_LT_LT_LT] = ACTIONS(1437),
    [anon_sym_GT_AMP] = ACTIONS(1437),
    [anon_sym_BQUOTE] = ACTIONS(1437),
    [anon_sym_esac] = ACTIONS(1437),
    [anon_sym_AMP_AMP] = ACTIONS(1437),
    [anon_sym_SEMI_SEMI] = ACTIONS(1437),
    [anon_sym_PIPE_AMP] = ACTIONS(1437),
  },
  [496] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1532),
    [anon_sym_LT_LT] = ACTIONS(1532),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1532),
    [anon_sym_PIPE] = ACTIONS(1532),
    [anon_sym_LT] = ACTIONS(1532),
    [anon_sym_LT_AMP] = ACTIONS(1532),
    [anon_sym_GT_GT] = ACTIONS(1532),
    [anon_sym_LT_LT_DASH] = ACTIONS(1532),
    [anon_sym_LF] = ACTIONS(1534),
    [anon_sym_SEMI] = ACTIONS(1532),
    [anon_sym_RPAREN] = ACTIONS(1532),
    [anon_sym_AMP] = ACTIONS(1532),
    [anon_sym_GT] = ACTIONS(1532),
    [sym_file_descriptor] = ACTIONS(1534),
    [anon_sym_AMP_GT] = ACTIONS(1532),
    [anon_sym_LT_LT_LT] = ACTIONS(1532),
    [anon_sym_GT_AMP] = ACTIONS(1532),
    [anon_sym_BQUOTE] = ACTIONS(1532),
    [anon_sym_esac] = ACTIONS(1532),
    [anon_sym_AMP_AMP] = ACTIONS(1532),
    [anon_sym_SEMI_SEMI] = ACTIONS(1532),
    [anon_sym_PIPE_AMP] = ACTIONS(1532),
  },
  [497] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1544),
    [anon_sym_LT_LT] = ACTIONS(1544),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1544),
    [anon_sym_PIPE] = ACTIONS(1544),
    [anon_sym_LT] = ACTIONS(1544),
    [anon_sym_LT_AMP] = ACTIONS(1544),
    [anon_sym_GT_GT] = ACTIONS(1544),
    [anon_sym_LT_LT_DASH] = ACTIONS(1544),
    [anon_sym_LF] = ACTIONS(1546),
    [anon_sym_SEMI] = ACTIONS(1544),
    [anon_sym_RPAREN] = ACTIONS(1544),
    [anon_sym_AMP] = ACTIONS(1544),
    [anon_sym_GT] = ACTIONS(1544),
    [sym_file_descriptor] = ACTIONS(1546),
    [anon_sym_AMP_GT] = ACTIONS(1544),
    [anon_sym_LT_LT_LT] = ACTIONS(1544),
    [anon_sym_GT_AMP] = ACTIONS(1544),
    [anon_sym_BQUOTE] = ACTIONS(1544),
    [anon_sym_esac] = ACTIONS(1544),
    [anon_sym_AMP_AMP] = ACTIONS(1544),
    [anon_sym_SEMI_SEMI] = ACTIONS(1544),
    [anon_sym_PIPE_AMP] = ACTIONS(1544),
  },
  [498] = {
    [sym_word] = ACTIONS(1550),
    [anon_sym_AMP_GT_GT] = ACTIONS(1550),
    [anon_sym_DOLLAR] = ACTIONS(1550),
    [anon_sym_LT_LT] = ACTIONS(1550),
    [anon_sym_LT_LPAREN] = ACTIONS(1550),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1550),
    [sym__concat] = ACTIONS(1552),
    [anon_sym_PIPE] = ACTIONS(1550),
    [anon_sym_LT] = ACTIONS(1550),
    [anon_sym_LT_AMP] = ACTIONS(1550),
    [anon_sym_GT_GT] = ACTIONS(1550),
    [anon_sym_EQ_TILDE] = ACTIONS(1550),
    [sym__special_character] = ACTIONS(1550),
    [anon_sym_LT_LT_DASH] = ACTIONS(1550),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1550),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1550),
    [anon_sym_LF] = ACTIONS(1552),
    [anon_sym_SEMI] = ACTIONS(1550),
    [sym_raw_string] = ACTIONS(1550),
    [anon_sym_RPAREN] = ACTIONS(1550),
    [anon_sym_AMP] = ACTIONS(1550),
    [anon_sym_GT] = ACTIONS(1550),
    [sym_file_descriptor] = ACTIONS(1552),
    [anon_sym_AMP_GT] = ACTIONS(1550),
    [anon_sym_EQ_EQ] = ACTIONS(1550),
    [anon_sym_DQUOTE] = ACTIONS(1550),
    [anon_sym_LT_LT_LT] = ACTIONS(1550),
    [anon_sym_GT_AMP] = ACTIONS(1550),
    [anon_sym_BQUOTE] = ACTIONS(1550),
    [anon_sym_GT_LPAREN] = ACTIONS(1550),
    [sym_ansii_c_string] = ACTIONS(1550),
    [anon_sym_AMP_AMP] = ACTIONS(1550),
    [anon_sym_SEMI_SEMI] = ACTIONS(1550),
    [anon_sym_PIPE_AMP] = ACTIONS(1550),
  },
  [499] = {
    [sym_word] = ACTIONS(1562),
    [anon_sym_AMP_GT_GT] = ACTIONS(1562),
    [anon_sym_DOLLAR] = ACTIONS(1562),
    [anon_sym_LT_LT] = ACTIONS(1562),
    [anon_sym_LT_LPAREN] = ACTIONS(1562),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1562),
    [sym__concat] = ACTIONS(1564),
    [anon_sym_PIPE] = ACTIONS(1562),
    [anon_sym_LT] = ACTIONS(1562),
    [anon_sym_LT_AMP] = ACTIONS(1562),
    [anon_sym_GT_GT] = ACTIONS(1562),
    [anon_sym_EQ_TILDE] = ACTIONS(1562),
    [sym__special_character] = ACTIONS(1562),
    [anon_sym_LT_LT_DASH] = ACTIONS(1562),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1562),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1562),
    [anon_sym_LF] = ACTIONS(1564),
    [anon_sym_SEMI] = ACTIONS(1562),
    [sym_raw_string] = ACTIONS(1562),
    [anon_sym_RPAREN] = ACTIONS(1562),
    [anon_sym_AMP] = ACTIONS(1562),
    [anon_sym_GT] = ACTIONS(1562),
    [sym_file_descriptor] = ACTIONS(1564),
    [anon_sym_AMP_GT] = ACTIONS(1562),
    [anon_sym_EQ_EQ] = ACTIONS(1562),
    [anon_sym_DQUOTE] = ACTIONS(1562),
    [anon_sym_LT_LT_LT] = ACTIONS(1562),
    [anon_sym_GT_AMP] = ACTIONS(1562),
    [anon_sym_BQUOTE] = ACTIONS(1562),
    [anon_sym_GT_LPAREN] = ACTIONS(1562),
    [sym_ansii_c_string] = ACTIONS(1562),
    [anon_sym_AMP_AMP] = ACTIONS(1562),
    [anon_sym_SEMI_SEMI] = ACTIONS(1562),
    [anon_sym_PIPE_AMP] = ACTIONS(1562),
  },
  [500] = {
    [sym_word] = ACTIONS(1572),
    [anon_sym_AMP_GT_GT] = ACTIONS(1572),
    [anon_sym_DOLLAR] = ACTIONS(1572),
    [anon_sym_LT_LT] = ACTIONS(1572),
    [anon_sym_LT_LPAREN] = ACTIONS(1572),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1572),
    [sym__concat] = ACTIONS(1574),
    [anon_sym_PIPE] = ACTIONS(1572),
    [anon_sym_LT] = ACTIONS(1572),
    [anon_sym_LT_AMP] = ACTIONS(1572),
    [anon_sym_GT_GT] = ACTIONS(1572),
    [anon_sym_EQ_TILDE] = ACTIONS(1572),
    [sym__special_character] = ACTIONS(1572),
    [anon_sym_LT_LT_DASH] = ACTIONS(1572),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1572),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1572),
    [anon_sym_LF] = ACTIONS(1574),
    [anon_sym_SEMI] = ACTIONS(1572),
    [sym_raw_string] = ACTIONS(1572),
    [anon_sym_RPAREN] = ACTIONS(1572),
    [anon_sym_AMP] = ACTIONS(1572),
    [anon_sym_GT] = ACTIONS(1572),
    [sym_file_descriptor] = ACTIONS(1574),
    [anon_sym_AMP_GT] = ACTIONS(1572),
    [anon_sym_EQ_EQ] = ACTIONS(1572),
    [anon_sym_DQUOTE] = ACTIONS(1572),
    [anon_sym_LT_LT_LT] = ACTIONS(1572),
    [anon_sym_GT_AMP] = ACTIONS(1572),
    [anon_sym_BQUOTE] = ACTIONS(1572),
    [anon_sym_GT_LPAREN] = ACTIONS(1572),
    [sym_ansii_c_string] = ACTIONS(1572),
    [anon_sym_AMP_AMP] = ACTIONS(1572),
    [anon_sym_SEMI_SEMI] = ACTIONS(1572),
    [anon_sym_PIPE_AMP] = ACTIONS(1572),
  },
  [501] = {
    [sym_word] = ACTIONS(1576),
    [anon_sym_AMP_GT_GT] = ACTIONS(1576),
    [anon_sym_DOLLAR] = ACTIONS(1576),
    [anon_sym_LT_LT] = ACTIONS(1576),
    [anon_sym_LT_LPAREN] = ACTIONS(1576),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1576),
    [sym__concat] = ACTIONS(1578),
    [anon_sym_PIPE] = ACTIONS(1576),
    [anon_sym_LT] = ACTIONS(1576),
    [anon_sym_LT_AMP] = ACTIONS(1576),
    [anon_sym_GT_GT] = ACTIONS(1576),
    [anon_sym_EQ_TILDE] = ACTIONS(1576),
    [sym__special_character] = ACTIONS(1576),
    [anon_sym_LT_LT_DASH] = ACTIONS(1576),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1576),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1576),
    [anon_sym_LF] = ACTIONS(1578),
    [anon_sym_SEMI] = ACTIONS(1576),
    [sym_raw_string] = ACTIONS(1576),
    [anon_sym_RPAREN] = ACTIONS(1576),
    [anon_sym_AMP] = ACTIONS(1576),
    [anon_sym_GT] = ACTIONS(1576),
    [sym_file_descriptor] = ACTIONS(1578),
    [anon_sym_AMP_GT] = ACTIONS(1576),
    [anon_sym_EQ_EQ] = ACTIONS(1576),
    [anon_sym_DQUOTE] = ACTIONS(1576),
    [anon_sym_LT_LT_LT] = ACTIONS(1576),
    [anon_sym_GT_AMP] = ACTIONS(1576),
    [anon_sym_BQUOTE] = ACTIONS(1576),
    [anon_sym_GT_LPAREN] = ACTIONS(1576),
    [sym_ansii_c_string] = ACTIONS(1576),
    [anon_sym_AMP_AMP] = ACTIONS(1576),
    [anon_sym_SEMI_SEMI] = ACTIONS(1576),
    [anon_sym_PIPE_AMP] = ACTIONS(1576),
  },
  [502] = {
    [sym_word] = ACTIONS(1582),
    [anon_sym_AMP_GT_GT] = ACTIONS(1582),
    [anon_sym_DOLLAR] = ACTIONS(1582),
    [anon_sym_LT_LT] = ACTIONS(1582),
    [anon_sym_LT_LPAREN] = ACTIONS(1582),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1582),
    [anon_sym_PIPE] = ACTIONS(1582),
    [anon_sym_LT] = ACTIONS(1582),
    [anon_sym_LT_AMP] = ACTIONS(1582),
    [anon_sym_GT_GT] = ACTIONS(1582),
    [sym__special_character] = ACTIONS(1582),
    [anon_sym_LT_LT_DASH] = ACTIONS(1582),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1582),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1582),
    [anon_sym_LF] = ACTIONS(1584),
    [anon_sym_SEMI] = ACTIONS(1582),
    [sym_raw_string] = ACTIONS(1582),
    [sym_variable_name] = ACTIONS(1584),
    [anon_sym_RPAREN] = ACTIONS(1582),
    [anon_sym_AMP] = ACTIONS(1582),
    [anon_sym_GT] = ACTIONS(1582),
    [sym_file_descriptor] = ACTIONS(1584),
    [anon_sym_AMP_GT] = ACTIONS(1582),
    [anon_sym_DQUOTE] = ACTIONS(1582),
    [anon_sym_LT_LT_LT] = ACTIONS(1582),
    [anon_sym_GT_AMP] = ACTIONS(1582),
    [anon_sym_BQUOTE] = ACTIONS(1582),
    [anon_sym_GT_LPAREN] = ACTIONS(1582),
    [sym_ansii_c_string] = ACTIONS(1582),
    [anon_sym_AMP_AMP] = ACTIONS(1582),
    [anon_sym_SEMI_SEMI] = ACTIONS(1582),
    [anon_sym_PIPE_AMP] = ACTIONS(1582),
  },
  [503] = {
    [sym_command_substitution] = STATE(482),
    [aux_sym__literal_repeat1] = STATE(484),
    [sym_string] = STATE(482),
    [sym_process_substitution] = STATE(482),
    [aux_sym_for_statement_repeat1] = STATE(503),
    [sym_simple_expansion] = STATE(482),
    [sym_string_expansion] = STATE(482),
    [sym_concatenation] = STATE(503),
    [sym_expansion] = STATE(482),
    [sym_word] = ACTIONS(2156),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2159),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2162),
    [sym_raw_string] = ACTIONS(2156),
    [anon_sym_LF] = ACTIONS(1604),
    [anon_sym_SEMI] = ACTIONS(2165),
    [anon_sym_DOLLAR] = ACTIONS(2167),
    [anon_sym_AMP] = ACTIONS(2165),
    [anon_sym_LT_LPAREN] = ACTIONS(2170),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(2173),
    [anon_sym_BQUOTE] = ACTIONS(2176),
    [anon_sym_GT_LPAREN] = ACTIONS(2170),
    [sym_ansii_c_string] = ACTIONS(2156),
    [sym__special_character] = ACTIONS(2179),
    [anon_sym_SEMI_SEMI] = ACTIONS(2165),
  },
  [504] = {
    [sym_word] = ACTIONS(2182),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1612),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1612),
    [sym_raw_string] = ACTIONS(1612),
    [anon_sym_COLON] = ACTIONS(2182),
    [anon_sym_DOLLAR] = ACTIONS(2182),
    [anon_sym_RBRACE] = ACTIONS(1612),
    [anon_sym_DASH] = ACTIONS(2182),
    [anon_sym_EQ] = ACTIONS(2182),
    [anon_sym_PERCENT] = ACTIONS(2182),
    [anon_sym_POUND] = ACTIONS(1612),
    [anon_sym_COLON_DASH] = ACTIONS(2182),
    [anon_sym_SLASH] = ACTIONS(1612),
    [anon_sym_LT_LPAREN] = ACTIONS(1612),
    [anon_sym_DQUOTE] = ACTIONS(1612),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1612),
    [anon_sym_GT_LPAREN] = ACTIONS(1612),
    [sym_ansii_c_string] = ACTIONS(1612),
    [anon_sym_COLON_QMARK] = ACTIONS(2182),
    [sym__special_character] = ACTIONS(2182),
  },
  [505] = {
    [sym_word] = ACTIONS(2182),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1612),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1612),
    [sym_raw_string] = ACTIONS(1612),
    [anon_sym_COLON] = ACTIONS(2182),
    [anon_sym_DOLLAR] = ACTIONS(2182),
    [anon_sym_RBRACE] = ACTIONS(1612),
    [anon_sym_DASH] = ACTIONS(2182),
    [anon_sym_EQ] = ACTIONS(2182),
    [anon_sym_PERCENT] = ACTIONS(2182),
    [anon_sym_POUND] = ACTIONS(1612),
    [anon_sym_COLON_DASH] = ACTIONS(2182),
    [anon_sym_SLASH] = ACTIONS(1612),
    [anon_sym_LT_LPAREN] = ACTIONS(1612),
    [anon_sym_DQUOTE] = ACTIONS(1612),
    [sym__concat] = ACTIONS(2184),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1612),
    [anon_sym_GT_LPAREN] = ACTIONS(1612),
    [sym_ansii_c_string] = ACTIONS(1612),
    [anon_sym_COLON_QMARK] = ACTIONS(2182),
    [sym__special_character] = ACTIONS(2182),
  },
  [506] = {
    [sym_word] = ACTIONS(2186),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1616),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1616),
    [sym_raw_string] = ACTIONS(1616),
    [anon_sym_COLON] = ACTIONS(2186),
    [anon_sym_DOLLAR] = ACTIONS(2186),
    [anon_sym_RBRACE] = ACTIONS(1616),
    [anon_sym_DASH] = ACTIONS(2186),
    [anon_sym_EQ] = ACTIONS(2186),
    [anon_sym_PERCENT] = ACTIONS(2186),
    [anon_sym_POUND] = ACTIONS(1616),
    [anon_sym_COLON_DASH] = ACTIONS(2186),
    [anon_sym_SLASH] = ACTIONS(1616),
    [anon_sym_LT_LPAREN] = ACTIONS(1616),
    [anon_sym_DQUOTE] = ACTIONS(1616),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1616),
    [anon_sym_GT_LPAREN] = ACTIONS(1616),
    [sym_ansii_c_string] = ACTIONS(1616),
    [anon_sym_COLON_QMARK] = ACTIONS(2186),
    [sym__special_character] = ACTIONS(2186),
  },
  [507] = {
    [sym_word] = ACTIONS(2186),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1616),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1616),
    [sym_raw_string] = ACTIONS(1616),
    [anon_sym_COLON] = ACTIONS(2186),
    [anon_sym_DOLLAR] = ACTIONS(2186),
    [anon_sym_RBRACE] = ACTIONS(1616),
    [anon_sym_DASH] = ACTIONS(2186),
    [anon_sym_EQ] = ACTIONS(2186),
    [anon_sym_PERCENT] = ACTIONS(2186),
    [anon_sym_POUND] = ACTIONS(1616),
    [anon_sym_COLON_DASH] = ACTIONS(2186),
    [anon_sym_SLASH] = ACTIONS(1616),
    [anon_sym_LT_LPAREN] = ACTIONS(1616),
    [anon_sym_DQUOTE] = ACTIONS(1616),
    [sym__concat] = ACTIONS(2188),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1616),
    [anon_sym_GT_LPAREN] = ACTIONS(1616),
    [sym_ansii_c_string] = ACTIONS(1616),
    [anon_sym_COLON_QMARK] = ACTIONS(2186),
    [sym__special_character] = ACTIONS(2186),
  },
  [508] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1626),
    [anon_sym_LT_LT] = ACTIONS(1626),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1626),
    [anon_sym_PIPE] = ACTIONS(1626),
    [anon_sym_LT] = ACTIONS(1626),
    [anon_sym_LT_AMP] = ACTIONS(1626),
    [anon_sym_GT_GT] = ACTIONS(1626),
    [anon_sym_LT_LT_DASH] = ACTIONS(1626),
    [anon_sym_LF] = ACTIONS(1628),
    [anon_sym_SEMI] = ACTIONS(1626),
    [anon_sym_RPAREN] = ACTIONS(1626),
    [anon_sym_AMP] = ACTIONS(1626),
    [anon_sym_GT] = ACTIONS(1626),
    [sym_file_descriptor] = ACTIONS(1628),
    [anon_sym_AMP_GT] = ACTIONS(1626),
    [anon_sym_LT_LT_LT] = ACTIONS(1626),
    [anon_sym_GT_AMP] = ACTIONS(1626),
    [anon_sym_BQUOTE] = ACTIONS(1626),
    [anon_sym_esac] = ACTIONS(1626),
    [anon_sym_AMP_AMP] = ACTIONS(1626),
    [anon_sym_SEMI_SEMI] = ACTIONS(1626),
    [anon_sym_PIPE_AMP] = ACTIONS(1626),
  },
  [509] = {
    [anon_sym_LF] = ACTIONS(1632),
    [anon_sym_SEMI] = ACTIONS(1630),
    [anon_sym_BQUOTE] = ACTIONS(1630),
    [anon_sym_esac] = ACTIONS(1630),
    [anon_sym_RPAREN] = ACTIONS(1630),
    [anon_sym_AMP] = ACTIONS(1630),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI_SEMI] = ACTIONS(1630),
  },
  [510] = {
    [sym_word] = ACTIONS(1415),
    [anon_sym_AMP_GT_GT] = ACTIONS(1417),
    [anon_sym_typeset] = ACTIONS(1415),
    [anon_sym_DOLLAR] = ACTIONS(1415),
    [anon_sym_LT_LPAREN] = ACTIONS(1417),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT_AMP] = ACTIONS(1417),
    [anon_sym_export] = ACTIONS(1415),
    [sym__special_character] = ACTIONS(1415),
    [anon_sym_if] = ACTIONS(1415),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1417),
    [sym_raw_string] = ACTIONS(1417),
    [anon_sym_declare] = ACTIONS(1415),
    [sym_variable_name] = ACTIONS(1417),
    [anon_sym_RPAREN] = ACTIONS(1651),
    [anon_sym_readonly] = ACTIONS(1415),
    [anon_sym_unset] = ACTIONS(1415),
    [anon_sym_DQUOTE] = ACTIONS(1417),
    [anon_sym_GT_AMP] = ACTIONS(1417),
    [sym_ansii_c_string] = ACTIONS(1417),
    [anon_sym_while] = ACTIONS(1415),
    [anon_sym_SEMI_SEMI] = ACTIONS(1651),
    [anon_sym_LPAREN] = ACTIONS(1415),
    [anon_sym_local] = ACTIONS(1415),
    [anon_sym_unsetenv] = ACTIONS(1415),
    [anon_sym_function] = ACTIONS(1415),
    [anon_sym_LBRACE] = ACTIONS(1417),
    [anon_sym_LT] = ACTIONS(1415),
    [anon_sym_GT_GT] = ACTIONS(1417),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1417),
    [anon_sym_case] = ACTIONS(1415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1417),
    [anon_sym_BANG] = ACTIONS(1415),
    [sym_file_descriptor] = ACTIONS(1417),
    [anon_sym_GT] = ACTIONS(1415),
    [anon_sym_AMP_GT] = ACTIONS(1415),
    [anon_sym_BQUOTE] = ACTIONS(1417),
    [anon_sym_GT_LPAREN] = ACTIONS(1417),
    [anon_sym_for] = ACTIONS(1415),
    [anon_sym_LBRACK] = ACTIONS(1415),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1417),
  },
  [511] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1659),
    [anon_sym_LT_LT] = ACTIONS(1659),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1659),
    [anon_sym_PIPE] = ACTIONS(1659),
    [anon_sym_LT] = ACTIONS(1659),
    [anon_sym_LT_AMP] = ACTIONS(1659),
    [anon_sym_GT_GT] = ACTIONS(1659),
    [anon_sym_LT_LT_DASH] = ACTIONS(1659),
    [anon_sym_LF] = ACTIONS(1661),
    [anon_sym_SEMI] = ACTIONS(1659),
    [anon_sym_RPAREN] = ACTIONS(1659),
    [anon_sym_AMP] = ACTIONS(1659),
    [anon_sym_GT] = ACTIONS(1659),
    [sym_file_descriptor] = ACTIONS(1661),
    [anon_sym_AMP_GT] = ACTIONS(1659),
    [anon_sym_LT_LT_LT] = ACTIONS(1659),
    [anon_sym_GT_AMP] = ACTIONS(1659),
    [anon_sym_BQUOTE] = ACTIONS(1659),
    [anon_sym_esac] = ACTIONS(1659),
    [anon_sym_AMP_AMP] = ACTIONS(1659),
    [anon_sym_SEMI_SEMI] = ACTIONS(1659),
    [anon_sym_PIPE_AMP] = ACTIONS(1659),
  },
  [512] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1665),
    [anon_sym_LT_LT] = ACTIONS(1665),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1665),
    [anon_sym_PIPE] = ACTIONS(1665),
    [anon_sym_LT] = ACTIONS(1665),
    [anon_sym_LT_AMP] = ACTIONS(1665),
    [anon_sym_GT_GT] = ACTIONS(1665),
    [anon_sym_LT_LT_DASH] = ACTIONS(1665),
    [anon_sym_LF] = ACTIONS(1667),
    [anon_sym_SEMI] = ACTIONS(1665),
    [anon_sym_RPAREN] = ACTIONS(1665),
    [anon_sym_AMP] = ACTIONS(1665),
    [anon_sym_GT] = ACTIONS(1665),
    [sym_file_descriptor] = ACTIONS(1667),
    [anon_sym_AMP_GT] = ACTIONS(1665),
    [anon_sym_LT_LT_LT] = ACTIONS(1665),
    [anon_sym_GT_AMP] = ACTIONS(1665),
    [anon_sym_BQUOTE] = ACTIONS(1665),
    [anon_sym_esac] = ACTIONS(1665),
    [anon_sym_AMP_AMP] = ACTIONS(1665),
    [anon_sym_SEMI_SEMI] = ACTIONS(1665),
    [anon_sym_PIPE_AMP] = ACTIONS(1665),
  },
  [513] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1735),
    [anon_sym_LT_LT] = ACTIONS(1735),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1735),
    [anon_sym_PIPE] = ACTIONS(1735),
    [anon_sym_LT] = ACTIONS(1735),
    [anon_sym_LT_AMP] = ACTIONS(1735),
    [anon_sym_GT_GT] = ACTIONS(1735),
    [anon_sym_LT_LT_DASH] = ACTIONS(1735),
    [anon_sym_LF] = ACTIONS(1737),
    [anon_sym_SEMI] = ACTIONS(1735),
    [anon_sym_RPAREN] = ACTIONS(1735),
    [anon_sym_AMP] = ACTIONS(1735),
    [anon_sym_GT] = ACTIONS(1735),
    [sym_file_descriptor] = ACTIONS(1737),
    [anon_sym_AMP_GT] = ACTIONS(1735),
    [anon_sym_LT_LT_LT] = ACTIONS(1735),
    [anon_sym_GT_AMP] = ACTIONS(1735),
    [anon_sym_BQUOTE] = ACTIONS(1735),
    [anon_sym_esac] = ACTIONS(1735),
    [anon_sym_AMP_AMP] = ACTIONS(1735),
    [anon_sym_SEMI_SEMI] = ACTIONS(1735),
    [anon_sym_PIPE_AMP] = ACTIONS(1735),
  },
  [514] = {
    [sym_word] = ACTIONS(1741),
    [anon_sym_AMP_GT_GT] = ACTIONS(1741),
    [anon_sym_DOLLAR] = ACTIONS(1741),
    [anon_sym_LT_LT] = ACTIONS(1741),
    [anon_sym_LT_LPAREN] = ACTIONS(1741),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1741),
    [sym__concat] = ACTIONS(1743),
    [anon_sym_PIPE] = ACTIONS(1741),
    [anon_sym_LT] = ACTIONS(1741),
    [anon_sym_LT_AMP] = ACTIONS(1741),
    [anon_sym_GT_GT] = ACTIONS(1741),
    [anon_sym_EQ_TILDE] = ACTIONS(1741),
    [sym__special_character] = ACTIONS(1741),
    [anon_sym_LT_LT_DASH] = ACTIONS(1741),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1741),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1741),
    [anon_sym_LF] = ACTIONS(1743),
    [anon_sym_SEMI] = ACTIONS(1741),
    [sym_raw_string] = ACTIONS(1741),
    [anon_sym_RPAREN] = ACTIONS(1741),
    [anon_sym_AMP] = ACTIONS(1741),
    [anon_sym_GT] = ACTIONS(1741),
    [sym_file_descriptor] = ACTIONS(1743),
    [anon_sym_AMP_GT] = ACTIONS(1741),
    [anon_sym_EQ_EQ] = ACTIONS(1741),
    [anon_sym_DQUOTE] = ACTIONS(1741),
    [anon_sym_LT_LT_LT] = ACTIONS(1741),
    [anon_sym_GT_AMP] = ACTIONS(1741),
    [anon_sym_BQUOTE] = ACTIONS(1741),
    [anon_sym_GT_LPAREN] = ACTIONS(1741),
    [sym_ansii_c_string] = ACTIONS(1741),
    [anon_sym_AMP_AMP] = ACTIONS(1741),
    [anon_sym_SEMI_SEMI] = ACTIONS(1741),
    [anon_sym_PIPE_AMP] = ACTIONS(1741),
  },
  [515] = {
    [sym_word] = ACTIONS(1747),
    [anon_sym_AMP_GT_GT] = ACTIONS(1747),
    [anon_sym_DOLLAR] = ACTIONS(1747),
    [anon_sym_LT_LT] = ACTIONS(1747),
    [anon_sym_LT_LPAREN] = ACTIONS(1747),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1747),
    [sym__concat] = ACTIONS(1749),
    [anon_sym_PIPE] = ACTIONS(1747),
    [anon_sym_LT] = ACTIONS(1747),
    [anon_sym_LT_AMP] = ACTIONS(1747),
    [anon_sym_GT_GT] = ACTIONS(1747),
    [anon_sym_EQ_TILDE] = ACTIONS(1747),
    [sym__special_character] = ACTIONS(1747),
    [anon_sym_LT_LT_DASH] = ACTIONS(1747),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1747),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1747),
    [anon_sym_LF] = ACTIONS(1749),
    [anon_sym_SEMI] = ACTIONS(1747),
    [sym_raw_string] = ACTIONS(1747),
    [anon_sym_RPAREN] = ACTIONS(1747),
    [anon_sym_AMP] = ACTIONS(1747),
    [anon_sym_GT] = ACTIONS(1747),
    [sym_file_descriptor] = ACTIONS(1749),
    [anon_sym_AMP_GT] = ACTIONS(1747),
    [anon_sym_EQ_EQ] = ACTIONS(1747),
    [anon_sym_DQUOTE] = ACTIONS(1747),
    [anon_sym_LT_LT_LT] = ACTIONS(1747),
    [anon_sym_GT_AMP] = ACTIONS(1747),
    [anon_sym_BQUOTE] = ACTIONS(1747),
    [anon_sym_GT_LPAREN] = ACTIONS(1747),
    [sym_ansii_c_string] = ACTIONS(1747),
    [anon_sym_AMP_AMP] = ACTIONS(1747),
    [anon_sym_SEMI_SEMI] = ACTIONS(1747),
    [anon_sym_PIPE_AMP] = ACTIONS(1747),
  },
  [516] = {
    [sym_word] = ACTIONS(1751),
    [anon_sym_AMP_GT_GT] = ACTIONS(1751),
    [anon_sym_DOLLAR] = ACTIONS(1751),
    [anon_sym_LT_LT] = ACTIONS(1751),
    [anon_sym_LT_LPAREN] = ACTIONS(1751),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1751),
    [sym__concat] = ACTIONS(1753),
    [anon_sym_PIPE] = ACTIONS(1751),
    [anon_sym_LT] = ACTIONS(1751),
    [anon_sym_LT_AMP] = ACTIONS(1751),
    [anon_sym_GT_GT] = ACTIONS(1751),
    [anon_sym_EQ_TILDE] = ACTIONS(1751),
    [sym__special_character] = ACTIONS(1751),
    [anon_sym_LT_LT_DASH] = ACTIONS(1751),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1751),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1751),
    [anon_sym_LF] = ACTIONS(1753),
    [anon_sym_SEMI] = ACTIONS(1751),
    [sym_raw_string] = ACTIONS(1751),
    [anon_sym_RPAREN] = ACTIONS(1751),
    [anon_sym_AMP] = ACTIONS(1751),
    [anon_sym_GT] = ACTIONS(1751),
    [sym_file_descriptor] = ACTIONS(1753),
    [anon_sym_AMP_GT] = ACTIONS(1751),
    [anon_sym_EQ_EQ] = ACTIONS(1751),
    [anon_sym_DQUOTE] = ACTIONS(1751),
    [anon_sym_LT_LT_LT] = ACTIONS(1751),
    [anon_sym_GT_AMP] = ACTIONS(1751),
    [anon_sym_BQUOTE] = ACTIONS(1751),
    [anon_sym_GT_LPAREN] = ACTIONS(1751),
    [sym_ansii_c_string] = ACTIONS(1751),
    [anon_sym_AMP_AMP] = ACTIONS(1751),
    [anon_sym_SEMI_SEMI] = ACTIONS(1751),
    [anon_sym_PIPE_AMP] = ACTIONS(1751),
  },
  [517] = {
    [sym_word] = ACTIONS(1757),
    [anon_sym_AMP_GT_GT] = ACTIONS(1757),
    [anon_sym_DOLLAR] = ACTIONS(1757),
    [anon_sym_LT_LT] = ACTIONS(1757),
    [anon_sym_LT_LPAREN] = ACTIONS(1757),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1757),
    [sym__concat] = ACTIONS(1759),
    [anon_sym_PIPE] = ACTIONS(1757),
    [anon_sym_LT] = ACTIONS(1757),
    [anon_sym_LT_AMP] = ACTIONS(1757),
    [anon_sym_GT_GT] = ACTIONS(1757),
    [anon_sym_EQ_TILDE] = ACTIONS(1757),
    [sym__special_character] = ACTIONS(1757),
    [anon_sym_LT_LT_DASH] = ACTIONS(1757),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1757),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1757),
    [anon_sym_LF] = ACTIONS(1759),
    [anon_sym_SEMI] = ACTIONS(1757),
    [sym_raw_string] = ACTIONS(1757),
    [anon_sym_RPAREN] = ACTIONS(1757),
    [anon_sym_AMP] = ACTIONS(1757),
    [anon_sym_GT] = ACTIONS(1757),
    [sym_file_descriptor] = ACTIONS(1759),
    [anon_sym_AMP_GT] = ACTIONS(1757),
    [anon_sym_EQ_EQ] = ACTIONS(1757),
    [anon_sym_DQUOTE] = ACTIONS(1757),
    [anon_sym_LT_LT_LT] = ACTIONS(1757),
    [anon_sym_GT_AMP] = ACTIONS(1757),
    [anon_sym_BQUOTE] = ACTIONS(1757),
    [anon_sym_GT_LPAREN] = ACTIONS(1757),
    [sym_ansii_c_string] = ACTIONS(1757),
    [anon_sym_AMP_AMP] = ACTIONS(1757),
    [anon_sym_SEMI_SEMI] = ACTIONS(1757),
    [anon_sym_PIPE_AMP] = ACTIONS(1757),
  },
  [518] = {
    [sym_word] = ACTIONS(2190),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1761),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1761),
    [sym_raw_string] = ACTIONS(1761),
    [anon_sym_COLON] = ACTIONS(2190),
    [anon_sym_DOLLAR] = ACTIONS(2190),
    [anon_sym_RBRACE] = ACTIONS(1761),
    [anon_sym_DASH] = ACTIONS(2190),
    [anon_sym_EQ] = ACTIONS(2190),
    [anon_sym_PERCENT] = ACTIONS(2190),
    [anon_sym_POUND] = ACTIONS(1761),
    [anon_sym_COLON_DASH] = ACTIONS(2190),
    [anon_sym_SLASH] = ACTIONS(1761),
    [anon_sym_LT_LPAREN] = ACTIONS(1761),
    [anon_sym_DQUOTE] = ACTIONS(1761),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1761),
    [anon_sym_GT_LPAREN] = ACTIONS(1761),
    [sym_ansii_c_string] = ACTIONS(1761),
    [anon_sym_COLON_QMARK] = ACTIONS(2190),
    [sym__special_character] = ACTIONS(2190),
  },
  [519] = {
    [sym_word] = ACTIONS(2192),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1763),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1763),
    [sym_raw_string] = ACTIONS(1763),
    [anon_sym_COLON] = ACTIONS(2192),
    [anon_sym_DOLLAR] = ACTIONS(2192),
    [anon_sym_RBRACE] = ACTIONS(1763),
    [anon_sym_DASH] = ACTIONS(2192),
    [anon_sym_EQ] = ACTIONS(2192),
    [anon_sym_PERCENT] = ACTIONS(2192),
    [anon_sym_POUND] = ACTIONS(1763),
    [anon_sym_COLON_DASH] = ACTIONS(2192),
    [anon_sym_SLASH] = ACTIONS(1763),
    [anon_sym_LT_LPAREN] = ACTIONS(1763),
    [anon_sym_DQUOTE] = ACTIONS(1763),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1763),
    [anon_sym_GT_LPAREN] = ACTIONS(1763),
    [sym_ansii_c_string] = ACTIONS(1763),
    [anon_sym_COLON_QMARK] = ACTIONS(2192),
    [sym__special_character] = ACTIONS(2192),
  },
  [520] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1765),
    [anon_sym_LT_LT] = ACTIONS(1765),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1765),
    [anon_sym_PIPE] = ACTIONS(1765),
    [anon_sym_LT] = ACTIONS(1765),
    [anon_sym_LT_AMP] = ACTIONS(1765),
    [anon_sym_GT_GT] = ACTIONS(1765),
    [anon_sym_LT_LT_DASH] = ACTIONS(1765),
    [anon_sym_LF] = ACTIONS(1767),
    [anon_sym_SEMI] = ACTIONS(1765),
    [anon_sym_RPAREN] = ACTIONS(1765),
    [anon_sym_AMP] = ACTIONS(1765),
    [anon_sym_GT] = ACTIONS(1765),
    [sym_file_descriptor] = ACTIONS(1767),
    [anon_sym_AMP_GT] = ACTIONS(1765),
    [anon_sym_LT_LT_LT] = ACTIONS(1765),
    [anon_sym_GT_AMP] = ACTIONS(1765),
    [anon_sym_BQUOTE] = ACTIONS(1765),
    [anon_sym_esac] = ACTIONS(1765),
    [anon_sym_AMP_AMP] = ACTIONS(1765),
    [anon_sym_SEMI_SEMI] = ACTIONS(1765),
    [anon_sym_PIPE_AMP] = ACTIONS(1765),
  },
  [521] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1769),
    [anon_sym_LT_LT] = ACTIONS(1769),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1769),
    [anon_sym_PIPE] = ACTIONS(1769),
    [anon_sym_LT] = ACTIONS(1769),
    [anon_sym_LT_AMP] = ACTIONS(1769),
    [anon_sym_GT_GT] = ACTIONS(1769),
    [anon_sym_LT_LT_DASH] = ACTIONS(1769),
    [anon_sym_LF] = ACTIONS(1771),
    [anon_sym_SEMI] = ACTIONS(1769),
    [anon_sym_RPAREN] = ACTIONS(1769),
    [anon_sym_AMP] = ACTIONS(1769),
    [anon_sym_GT] = ACTIONS(1769),
    [sym_file_descriptor] = ACTIONS(1771),
    [anon_sym_AMP_GT] = ACTIONS(1769),
    [anon_sym_LT_LT_LT] = ACTIONS(1769),
    [anon_sym_GT_AMP] = ACTIONS(1769),
    [anon_sym_BQUOTE] = ACTIONS(1769),
    [anon_sym_esac] = ACTIONS(1769),
    [anon_sym_AMP_AMP] = ACTIONS(1769),
    [anon_sym_SEMI_SEMI] = ACTIONS(1769),
    [anon_sym_PIPE_AMP] = ACTIONS(1769),
  },
  [522] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1783),
    [anon_sym_LT_LT] = ACTIONS(1783),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1783),
    [anon_sym_PIPE] = ACTIONS(1783),
    [anon_sym_LT] = ACTIONS(1783),
    [anon_sym_LT_AMP] = ACTIONS(1783),
    [anon_sym_GT_GT] = ACTIONS(1783),
    [anon_sym_LT_LT_DASH] = ACTIONS(1783),
    [anon_sym_LF] = ACTIONS(1785),
    [anon_sym_SEMI] = ACTIONS(1783),
    [anon_sym_RPAREN] = ACTIONS(1783),
    [anon_sym_AMP] = ACTIONS(1783),
    [anon_sym_GT] = ACTIONS(1783),
    [sym_file_descriptor] = ACTIONS(1785),
    [anon_sym_AMP_GT] = ACTIONS(1783),
    [anon_sym_LT_LT_LT] = ACTIONS(1783),
    [anon_sym_GT_AMP] = ACTIONS(1783),
    [anon_sym_BQUOTE] = ACTIONS(1783),
    [anon_sym_esac] = ACTIONS(1783),
    [anon_sym_AMP_AMP] = ACTIONS(1783),
    [anon_sym_SEMI_SEMI] = ACTIONS(1783),
    [anon_sym_PIPE_AMP] = ACTIONS(1783),
  },
  [523] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1787),
    [anon_sym_LT_LT] = ACTIONS(1787),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1787),
    [anon_sym_LT] = ACTIONS(1787),
    [anon_sym_LT_AMP] = ACTIONS(1787),
    [anon_sym_GT_GT] = ACTIONS(1787),
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_LF] = ACTIONS(1789),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_AMP] = ACTIONS(1787),
    [anon_sym_GT] = ACTIONS(1787),
    [sym_file_descriptor] = ACTIONS(1789),
    [anon_sym_AMP_GT] = ACTIONS(1787),
    [anon_sym_LT_LT_LT] = ACTIONS(1787),
    [anon_sym_GT_AMP] = ACTIONS(1787),
    [anon_sym_BQUOTE] = ACTIONS(1787),
    [anon_sym_esac] = ACTIONS(1787),
    [anon_sym_AMP_AMP] = ACTIONS(1787),
    [anon_sym_SEMI_SEMI] = ACTIONS(1787),
    [anon_sym_PIPE_AMP] = ACTIONS(1787),
  },
  [524] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1824),
    [anon_sym_LT_LT] = ACTIONS(1824),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1824),
    [anon_sym_PIPE] = ACTIONS(1824),
    [anon_sym_LT] = ACTIONS(1824),
    [anon_sym_LT_AMP] = ACTIONS(1824),
    [anon_sym_GT_GT] = ACTIONS(1824),
    [anon_sym_LT_LT_DASH] = ACTIONS(1824),
    [anon_sym_LF] = ACTIONS(1826),
    [anon_sym_SEMI] = ACTIONS(1824),
    [anon_sym_RPAREN] = ACTIONS(1824),
    [anon_sym_AMP] = ACTIONS(1824),
    [anon_sym_GT] = ACTIONS(1824),
    [sym_file_descriptor] = ACTIONS(1826),
    [anon_sym_AMP_GT] = ACTIONS(1824),
    [anon_sym_LT_LT_LT] = ACTIONS(1824),
    [anon_sym_GT_AMP] = ACTIONS(1824),
    [anon_sym_BQUOTE] = ACTIONS(1824),
    [anon_sym_esac] = ACTIONS(1824),
    [anon_sym_AMP_AMP] = ACTIONS(1824),
    [anon_sym_SEMI_SEMI] = ACTIONS(1824),
    [anon_sym_PIPE_AMP] = ACTIONS(1824),
  },
  [525] = {
    [sym_word] = ACTIONS(1830),
    [anon_sym_AMP_GT_GT] = ACTIONS(1830),
    [anon_sym_DOLLAR] = ACTIONS(1830),
    [anon_sym_LT_LT] = ACTIONS(1830),
    [anon_sym_LT_LPAREN] = ACTIONS(1830),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1830),
    [sym__concat] = ACTIONS(1832),
    [anon_sym_PIPE] = ACTIONS(1830),
    [anon_sym_LT] = ACTIONS(1830),
    [anon_sym_LT_AMP] = ACTIONS(1830),
    [anon_sym_GT_GT] = ACTIONS(1830),
    [anon_sym_EQ_TILDE] = ACTIONS(1830),
    [sym__special_character] = ACTIONS(1830),
    [anon_sym_LT_LT_DASH] = ACTIONS(1830),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1830),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1830),
    [anon_sym_LF] = ACTIONS(1832),
    [anon_sym_SEMI] = ACTIONS(1830),
    [sym_raw_string] = ACTIONS(1830),
    [anon_sym_RPAREN] = ACTIONS(1830),
    [anon_sym_AMP] = ACTIONS(1830),
    [anon_sym_GT] = ACTIONS(1830),
    [sym_file_descriptor] = ACTIONS(1832),
    [anon_sym_AMP_GT] = ACTIONS(1830),
    [anon_sym_EQ_EQ] = ACTIONS(1830),
    [anon_sym_DQUOTE] = ACTIONS(1830),
    [anon_sym_LT_LT_LT] = ACTIONS(1830),
    [anon_sym_GT_AMP] = ACTIONS(1830),
    [anon_sym_BQUOTE] = ACTIONS(1830),
    [anon_sym_GT_LPAREN] = ACTIONS(1830),
    [sym_ansii_c_string] = ACTIONS(1830),
    [anon_sym_AMP_AMP] = ACTIONS(1830),
    [anon_sym_SEMI_SEMI] = ACTIONS(1830),
    [anon_sym_PIPE_AMP] = ACTIONS(1830),
  },
  [526] = {
    [sym_word] = ACTIONS(1834),
    [anon_sym_AMP_GT_GT] = ACTIONS(1834),
    [anon_sym_DOLLAR] = ACTIONS(1834),
    [anon_sym_LT_LT] = ACTIONS(1834),
    [anon_sym_LT_LPAREN] = ACTIONS(1834),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1834),
    [sym__concat] = ACTIONS(1836),
    [anon_sym_PIPE] = ACTIONS(1834),
    [anon_sym_LT] = ACTIONS(1834),
    [anon_sym_LT_AMP] = ACTIONS(1834),
    [anon_sym_GT_GT] = ACTIONS(1834),
    [anon_sym_EQ_TILDE] = ACTIONS(1834),
    [sym__special_character] = ACTIONS(1834),
    [anon_sym_LT_LT_DASH] = ACTIONS(1834),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1834),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1834),
    [anon_sym_LF] = ACTIONS(1836),
    [anon_sym_SEMI] = ACTIONS(1834),
    [sym_raw_string] = ACTIONS(1834),
    [anon_sym_RPAREN] = ACTIONS(1834),
    [anon_sym_AMP] = ACTIONS(1834),
    [anon_sym_GT] = ACTIONS(1834),
    [sym_file_descriptor] = ACTIONS(1836),
    [anon_sym_AMP_GT] = ACTIONS(1834),
    [anon_sym_EQ_EQ] = ACTIONS(1834),
    [anon_sym_DQUOTE] = ACTIONS(1834),
    [anon_sym_LT_LT_LT] = ACTIONS(1834),
    [anon_sym_GT_AMP] = ACTIONS(1834),
    [anon_sym_BQUOTE] = ACTIONS(1834),
    [anon_sym_GT_LPAREN] = ACTIONS(1834),
    [sym_ansii_c_string] = ACTIONS(1834),
    [anon_sym_AMP_AMP] = ACTIONS(1834),
    [anon_sym_SEMI_SEMI] = ACTIONS(1834),
    [anon_sym_PIPE_AMP] = ACTIONS(1834),
  },
  [527] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1838),
    [anon_sym_LT_LT] = ACTIONS(1838),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1838),
    [anon_sym_PIPE] = ACTIONS(1838),
    [anon_sym_LT] = ACTIONS(1838),
    [anon_sym_LT_AMP] = ACTIONS(1838),
    [anon_sym_GT_GT] = ACTIONS(1838),
    [anon_sym_LT_LT_DASH] = ACTIONS(1838),
    [anon_sym_LF] = ACTIONS(1840),
    [anon_sym_SEMI] = ACTIONS(1838),
    [anon_sym_RPAREN] = ACTIONS(1838),
    [anon_sym_AMP] = ACTIONS(1838),
    [anon_sym_GT] = ACTIONS(1838),
    [sym_file_descriptor] = ACTIONS(1840),
    [anon_sym_AMP_GT] = ACTIONS(1838),
    [anon_sym_LT_LT_LT] = ACTIONS(1838),
    [anon_sym_GT_AMP] = ACTIONS(1838),
    [anon_sym_BQUOTE] = ACTIONS(1838),
    [anon_sym_esac] = ACTIONS(1838),
    [anon_sym_AMP_AMP] = ACTIONS(1838),
    [anon_sym_SEMI_SEMI] = ACTIONS(1838),
    [anon_sym_PIPE_AMP] = ACTIONS(1838),
  },
  [528] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1846),
    [anon_sym_LT_LT] = ACTIONS(1846),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1846),
    [anon_sym_PIPE] = ACTIONS(1846),
    [anon_sym_LT] = ACTIONS(1846),
    [anon_sym_LT_AMP] = ACTIONS(1846),
    [anon_sym_GT_GT] = ACTIONS(1846),
    [anon_sym_LT_LT_DASH] = ACTIONS(1846),
    [anon_sym_LF] = ACTIONS(1848),
    [anon_sym_SEMI] = ACTIONS(1846),
    [anon_sym_RPAREN] = ACTIONS(1846),
    [anon_sym_AMP] = ACTIONS(1846),
    [anon_sym_GT] = ACTIONS(1846),
    [sym_file_descriptor] = ACTIONS(1848),
    [anon_sym_AMP_GT] = ACTIONS(1846),
    [anon_sym_LT_LT_LT] = ACTIONS(1846),
    [anon_sym_GT_AMP] = ACTIONS(1846),
    [anon_sym_BQUOTE] = ACTIONS(1846),
    [anon_sym_esac] = ACTIONS(1846),
    [anon_sym_AMP_AMP] = ACTIONS(1846),
    [anon_sym_SEMI_SEMI] = ACTIONS(1846),
    [anon_sym_PIPE_AMP] = ACTIONS(1846),
  },
  [529] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1878),
    [anon_sym_LT_LT] = ACTIONS(1878),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1878),
    [anon_sym_PIPE] = ACTIONS(1878),
    [anon_sym_LT] = ACTIONS(1878),
    [anon_sym_LT_AMP] = ACTIONS(1878),
    [anon_sym_GT_GT] = ACTIONS(1878),
    [anon_sym_LT_LT_DASH] = ACTIONS(1878),
    [anon_sym_LF] = ACTIONS(1880),
    [anon_sym_SEMI] = ACTIONS(1878),
    [anon_sym_RPAREN] = ACTIONS(1878),
    [anon_sym_AMP] = ACTIONS(1878),
    [anon_sym_GT] = ACTIONS(1878),
    [sym_file_descriptor] = ACTIONS(1880),
    [anon_sym_AMP_GT] = ACTIONS(1878),
    [anon_sym_LT_LT_LT] = ACTIONS(1878),
    [anon_sym_GT_AMP] = ACTIONS(1878),
    [anon_sym_BQUOTE] = ACTIONS(1878),
    [anon_sym_esac] = ACTIONS(1878),
    [anon_sym_AMP_AMP] = ACTIONS(1878),
    [anon_sym_SEMI_SEMI] = ACTIONS(1878),
    [anon_sym_PIPE_AMP] = ACTIONS(1878),
  },
  [530] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1882),
    [anon_sym_LT_LT] = ACTIONS(1882),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1882),
    [anon_sym_PIPE] = ACTIONS(1882),
    [anon_sym_LT] = ACTIONS(1882),
    [anon_sym_LT_AMP] = ACTIONS(1882),
    [anon_sym_GT_GT] = ACTIONS(1882),
    [anon_sym_LT_LT_DASH] = ACTIONS(1882),
    [anon_sym_LF] = ACTIONS(1884),
    [anon_sym_SEMI] = ACTIONS(1882),
    [anon_sym_RPAREN] = ACTIONS(1882),
    [anon_sym_AMP] = ACTIONS(1882),
    [anon_sym_GT] = ACTIONS(1882),
    [sym_file_descriptor] = ACTIONS(1884),
    [anon_sym_AMP_GT] = ACTIONS(1882),
    [anon_sym_LT_LT_LT] = ACTIONS(1882),
    [anon_sym_GT_AMP] = ACTIONS(1882),
    [anon_sym_BQUOTE] = ACTIONS(1882),
    [anon_sym_esac] = ACTIONS(1882),
    [anon_sym_AMP_AMP] = ACTIONS(1882),
    [anon_sym_SEMI_SEMI] = ACTIONS(1882),
    [anon_sym_PIPE_AMP] = ACTIONS(1882),
  },
  [531] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1904),
    [anon_sym_LT_LT] = ACTIONS(1904),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1904),
    [anon_sym_PIPE] = ACTIONS(1904),
    [anon_sym_LT] = ACTIONS(1904),
    [anon_sym_LT_AMP] = ACTIONS(1904),
    [anon_sym_GT_GT] = ACTIONS(1904),
    [anon_sym_LT_LT_DASH] = ACTIONS(1904),
    [anon_sym_LF] = ACTIONS(1906),
    [anon_sym_SEMI] = ACTIONS(1904),
    [anon_sym_RPAREN] = ACTIONS(1904),
    [anon_sym_AMP] = ACTIONS(1904),
    [anon_sym_GT] = ACTIONS(1904),
    [sym_file_descriptor] = ACTIONS(1906),
    [anon_sym_AMP_GT] = ACTIONS(1904),
    [anon_sym_LT_LT_LT] = ACTIONS(1904),
    [anon_sym_GT_AMP] = ACTIONS(1904),
    [anon_sym_BQUOTE] = ACTIONS(1904),
    [anon_sym_esac] = ACTIONS(1904),
    [anon_sym_AMP_AMP] = ACTIONS(1904),
    [anon_sym_SEMI_SEMI] = ACTIONS(1904),
    [anon_sym_PIPE_AMP] = ACTIONS(1904),
  },
  [532] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1912),
    [anon_sym_LT_LT] = ACTIONS(1912),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1912),
    [anon_sym_PIPE] = ACTIONS(1912),
    [anon_sym_LT] = ACTIONS(1912),
    [anon_sym_LT_AMP] = ACTIONS(1912),
    [anon_sym_GT_GT] = ACTIONS(1912),
    [anon_sym_LT_LT_DASH] = ACTIONS(1912),
    [anon_sym_LF] = ACTIONS(1914),
    [anon_sym_SEMI] = ACTIONS(1912),
    [anon_sym_RPAREN] = ACTIONS(1912),
    [anon_sym_AMP] = ACTIONS(1912),
    [anon_sym_GT] = ACTIONS(1912),
    [sym_file_descriptor] = ACTIONS(1914),
    [anon_sym_AMP_GT] = ACTIONS(1912),
    [anon_sym_LT_LT_LT] = ACTIONS(1912),
    [anon_sym_GT_AMP] = ACTIONS(1912),
    [anon_sym_BQUOTE] = ACTIONS(1912),
    [anon_sym_esac] = ACTIONS(1912),
    [anon_sym_AMP_AMP] = ACTIONS(1912),
    [anon_sym_SEMI_SEMI] = ACTIONS(1912),
    [anon_sym_PIPE_AMP] = ACTIONS(1912),
  },
  [533] = {
    [aux_sym_concatenation_repeat1] = STATE(1193),
    [sym_word] = ACTIONS(61),
    [anon_sym_LPAREN] = ACTIONS(1916),
    [anon_sym_AMP_GT_GT] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_LT_LT] = ACTIONS(61),
    [anon_sym_LT_LPAREN] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [sym__concat] = ACTIONS(2194),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_LT_AMP] = ACTIONS(61),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_EQ_TILDE] = ACTIONS(61),
    [sym__special_character] = ACTIONS(61),
    [anon_sym_LT_LT_DASH] = ACTIONS(61),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(61),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(61),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(61),
    [sym_raw_string] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [anon_sym_AMP_GT] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_LT_LT_LT] = ACTIONS(61),
    [anon_sym_GT_AMP] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(61),
    [anon_sym_esac] = ACTIONS(61),
    [anon_sym_GT_LPAREN] = ACTIONS(61),
    [sym_ansii_c_string] = ACTIONS(61),
    [anon_sym_AMP_AMP] = ACTIONS(61),
    [anon_sym_SEMI_SEMI] = ACTIONS(61),
    [anon_sym_PIPE_AMP] = ACTIONS(61),
  },
  [534] = {
    [sym_command_substitution] = STATE(397),
    [aux_sym__literal_repeat1] = STATE(398),
    [sym_string] = STATE(397),
    [aux_sym_declaration_command_repeat1] = STATE(552),
    [sym_process_substitution] = STATE(397),
    [sym_simple_expansion] = STATE(397),
    [sym_subscript] = STATE(2464),
    [sym_string_expansion] = STATE(397),
    [sym_variable_assignment] = STATE(552),
    [sym_concatenation] = STATE(552),
    [sym_expansion] = STATE(397),
    [sym_word] = ACTIONS(1920),
    [anon_sym_AMP_GT_GT] = ACTIONS(133),
    [anon_sym_DOLLAR] = ACTIONS(1922),
    [anon_sym_LT_LT] = ACTIONS(133),
    [anon_sym_LT_LPAREN] = ACTIONS(1924),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(133),
    [anon_sym_PIPE] = ACTIONS(133),
    [anon_sym_LT] = ACTIONS(133),
    [anon_sym_LT_AMP] = ACTIONS(133),
    [anon_sym_GT_GT] = ACTIONS(133),
    [sym__special_character] = ACTIONS(1926),
    [anon_sym_LT_LT_DASH] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1928),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2196),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1932),
    [anon_sym_LF] = ACTIONS(147),
    [anon_sym_SEMI] = ACTIONS(133),
    [sym_raw_string] = ACTIONS(1920),
    [sym_variable_name] = ACTIONS(1934),
    [sym_file_descriptor] = ACTIONS(147),
    [anon_sym_AMP] = ACTIONS(133),
    [anon_sym_GT] = ACTIONS(133),
    [anon_sym_AMP_GT] = ACTIONS(133),
    [anon_sym_DQUOTE] = ACTIONS(1936),
    [anon_sym_LT_LT_LT] = ACTIONS(133),
    [anon_sym_GT_AMP] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(133),
    [anon_sym_GT_LPAREN] = ACTIONS(1924),
    [sym_ansii_c_string] = ACTIONS(1920),
    [anon_sym_AMP_AMP] = ACTIONS(133),
    [anon_sym_SEMI_SEMI] = ACTIONS(133),
    [anon_sym_PIPE_AMP] = ACTIONS(133),
  },
  [535] = {
    [sym_command_substitution] = STATE(400),
    [aux_sym__literal_repeat1] = STATE(401),
    [sym_string] = STATE(400),
    [aux_sym_unset_command_repeat1] = STATE(555),
    [sym_process_substitution] = STATE(400),
    [sym_simple_expansion] = STATE(400),
    [sym_string_expansion] = STATE(400),
    [sym_concatenation] = STATE(555),
    [sym_expansion] = STATE(400),
    [sym_word] = ACTIONS(1940),
    [anon_sym_AMP_GT_GT] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(1942),
    [anon_sym_LT_LT] = ACTIONS(157),
    [anon_sym_LT_LPAREN] = ACTIONS(1944),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(157),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_AMP] = ACTIONS(157),
    [anon_sym_GT_GT] = ACTIONS(157),
    [sym__special_character] = ACTIONS(1946),
    [anon_sym_LT_LT_DASH] = ACTIONS(157),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1948),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2198),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1952),
    [anon_sym_LF] = ACTIONS(171),
    [anon_sym_SEMI] = ACTIONS(157),
    [sym_raw_string] = ACTIONS(1940),
    [sym_file_descriptor] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_AMP_GT] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(1954),
    [anon_sym_LT_LT_LT] = ACTIONS(157),
    [anon_sym_GT_AMP] = ACTIONS(157),
    [anon_sym_BQUOTE] = ACTIONS(157),
    [anon_sym_GT_LPAREN] = ACTIONS(1944),
    [sym_ansii_c_string] = ACTIONS(1940),
    [anon_sym_AMP_AMP] = ACTIONS(157),
    [anon_sym_SEMI_SEMI] = ACTIONS(157),
    [anon_sym_PIPE_AMP] = ACTIONS(157),
  },
  [536] = {
    [aux_sym_concatenation_repeat1] = STATE(546),
    [sym_word] = ACTIONS(191),
    [anon_sym_AMP_GT_GT] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [anon_sym_LT_LPAREN] = ACTIONS(191),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(189),
    [anon_sym_LT_AMP] = ACTIONS(191),
    [anon_sym_GT_GT] = ACTIONS(191),
    [sym__special_character] = ACTIONS(191),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(191),
    [sym_variable_name] = ACTIONS(191),
    [sym_file_descriptor] = ACTIONS(191),
    [anon_sym_RPAREN] = ACTIONS(191),
    [anon_sym_GT] = ACTIONS(189),
    [anon_sym_AMP_GT] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [anon_sym_GT_AMP] = ACTIONS(191),
    [anon_sym_BQUOTE] = ACTIONS(191),
    [anon_sym_GT_LPAREN] = ACTIONS(191),
    [sym_ansii_c_string] = ACTIONS(191),
  },
  [537] = {
    [aux_sym_concatenation_repeat1] = STATE(1193),
    [sym_word] = ACTIONS(61),
    [anon_sym_AMP_GT_GT] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_LT_LT] = ACTIONS(61),
    [anon_sym_LT_LPAREN] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [sym__concat] = ACTIONS(2194),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_LT_AMP] = ACTIONS(61),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_EQ_TILDE] = ACTIONS(61),
    [sym__special_character] = ACTIONS(61),
    [anon_sym_LT_LT_DASH] = ACTIONS(61),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(61),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(61),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(61),
    [sym_raw_string] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [anon_sym_AMP_GT] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_LT_LT_LT] = ACTIONS(61),
    [anon_sym_GT_AMP] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(61),
    [anon_sym_esac] = ACTIONS(61),
    [anon_sym_GT_LPAREN] = ACTIONS(61),
    [sym_ansii_c_string] = ACTIONS(61),
    [anon_sym_AMP_AMP] = ACTIONS(61),
    [anon_sym_SEMI_SEMI] = ACTIONS(61),
    [anon_sym_PIPE_AMP] = ACTIONS(61),
  },
  [538] = {
    [aux_sym__literal_repeat1] = STATE(539),
    [sym_string] = STATE(537),
    [sym_process_substitution] = STATE(537),
    [sym_test_command] = STATE(410),
    [aux_sym_command_repeat1] = STATE(544),
    [sym_subscript] = STATE(2455),
    [sym_variable_assignment] = STATE(544),
    [sym_concatenation] = STATE(542),
    [sym_expansion] = STATE(537),
    [sym_command_substitution] = STATE(537),
    [sym_command] = STATE(410),
    [sym_command_name] = STATE(637),
    [sym_simple_expansion] = STATE(537),
    [sym_string_expansion] = STATE(537),
    [sym_subshell] = STATE(410),
    [sym_file_redirect] = STATE(544),
    [anon_sym_LPAREN] = ACTIONS(71),
    [sym_word] = ACTIONS(1685),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(1685),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1687),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1693),
    [sym_variable_name] = ACTIONS(243),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_LT_LPAREN] = ACTIONS(1681),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [sym_ansii_c_string] = ACTIONS(1685),
    [anon_sym_BQUOTE] = ACTIONS(1697),
    [anon_sym_LBRACK] = ACTIONS(111),
    [anon_sym_GT_LPAREN] = ACTIONS(1681),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
    [sym__special_character] = ACTIONS(1683),
  },
  [539] = {
    [aux_sym__literal_repeat1] = STATE(1231),
    [sym_word] = ACTIONS(299),
    [anon_sym_AMP_GT_GT] = ACTIONS(299),
    [anon_sym_DOLLAR] = ACTIONS(299),
    [anon_sym_LT_LT] = ACTIONS(299),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(299),
    [anon_sym_PIPE] = ACTIONS(299),
    [anon_sym_LT] = ACTIONS(299),
    [anon_sym_LT_AMP] = ACTIONS(299),
    [anon_sym_GT_GT] = ACTIONS(299),
    [anon_sym_EQ_TILDE] = ACTIONS(299),
    [sym__special_character] = ACTIONS(2200),
    [anon_sym_LT_LT_DASH] = ACTIONS(299),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(299),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(299),
    [anon_sym_LF] = ACTIONS(303),
    [anon_sym_SEMI] = ACTIONS(299),
    [sym_raw_string] = ACTIONS(299),
    [sym_file_descriptor] = ACTIONS(303),
    [anon_sym_AMP] = ACTIONS(299),
    [anon_sym_GT] = ACTIONS(299),
    [anon_sym_AMP_GT] = ACTIONS(299),
    [anon_sym_EQ_EQ] = ACTIONS(299),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [anon_sym_LT_LT_LT] = ACTIONS(299),
    [anon_sym_GT_AMP] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(299),
    [anon_sym_esac] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_ansii_c_string] = ACTIONS(299),
    [anon_sym_AMP_AMP] = ACTIONS(299),
    [anon_sym_SEMI_SEMI] = ACTIONS(299),
    [anon_sym_PIPE_AMP] = ACTIONS(299),
  },
  [540] = {
    [sym_heredoc_redirect] = STATE(2622),
    [aux_sym_redirected_statement_repeat1] = STATE(2622),
    [sym_herestring_redirect] = STATE(2622),
    [sym_file_redirect] = STATE(2622),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_AMP_GT_GT] = ACTIONS(2202),
    [anon_sym_LF] = ACTIONS(2204),
    [anon_sym_SEMI] = ACTIONS(2206),
    [sym_file_descriptor] = ACTIONS(2208),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(2202),
    [anon_sym_AMP] = ACTIONS(2206),
    [anon_sym_AMP_GT] = ACTIONS(2202),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(2210),
    [anon_sym_LT_LT_LT] = ACTIONS(2212),
    [anon_sym_GT_AMP] = ACTIONS(2202),
    [anon_sym_PIPE] = ACTIONS(2214),
    [anon_sym_LT] = ACTIONS(2202),
    [anon_sym_esac] = ACTIONS(1964),
    [anon_sym_LT_AMP] = ACTIONS(2202),
    [anon_sym_GT_GT] = ACTIONS(2202),
    [anon_sym_AMP_AMP] = ACTIONS(2210),
    [anon_sym_SEMI_SEMI] = ACTIONS(1964),
    [anon_sym_PIPE_AMP] = ACTIONS(2214),
  },
  [541] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(2216),
    [anon_sym_PIPE] = ACTIONS(2218),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(2220),
    [anon_sym_SEMI] = ACTIONS(2222),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(2222),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(1964),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(2216),
    [anon_sym_SEMI_SEMI] = ACTIONS(2222),
    [anon_sym_PIPE_AMP] = ACTIONS(2218),
  },
  [542] = {
    [sym_word] = ACTIONS(61),
    [anon_sym_AMP_GT_GT] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_LT_LT] = ACTIONS(61),
    [anon_sym_LT_LPAREN] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_LT_AMP] = ACTIONS(61),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_EQ_TILDE] = ACTIONS(61),
    [sym__special_character] = ACTIONS(61),
    [anon_sym_LT_LT_DASH] = ACTIONS(61),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(61),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(61),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_SEMI] = ACTIONS(61),
    [sym_raw_string] = ACTIONS(61),
    [sym_file_descriptor] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [anon_sym_AMP_GT] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(61),
    [anon_sym_LT_LT_LT] = ACTIONS(61),
    [anon_sym_GT_AMP] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(61),
    [anon_sym_esac] = ACTIONS(61),
    [anon_sym_GT_LPAREN] = ACTIONS(61),
    [sym_ansii_c_string] = ACTIONS(61),
    [anon_sym_AMP_AMP] = ACTIONS(61),
    [anon_sym_SEMI_SEMI] = ACTIONS(61),
    [anon_sym_PIPE_AMP] = ACTIONS(61),
  },
  [543] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(569),
    [sym_function_definition] = STATE(569),
    [sym_negated_command] = STATE(569),
    [sym_test_command] = STATE(569),
    [sym_variable_assignment] = STATE(570),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [aux_sym__statements_repeat1] = STATE(101),
    [sym_redirected_statement] = STATE(569),
    [sym_for_statement] = STATE(569),
    [sym_compound_statement] = STATE(569),
    [sym_subshell] = STATE(569),
    [sym_declaration_command] = STATE(569),
    [sym_unset_command] = STATE(569),
    [sym_file_redirect] = STATE(1464),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(1464),
    [sym_c_style_for_statement] = STATE(569),
    [sym_while_statement] = STATE(569),
    [sym_case_statement] = STATE(569),
    [sym_pipeline] = STATE(569),
    [sym_list] = STATE(569),
    [sym_command] = STATE(569),
    [sym_command_name] = STATE(545),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(265),
    [anon_sym_typeset] = ACTIONS(265),
    [anon_sym_unsetenv] = ACTIONS(267),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(265),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(269),
    [anon_sym_declare] = ACTIONS(265),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(265),
    [anon_sym_unset] = ACTIONS(267),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [544] = {
    [sym_command_substitution] = STATE(537),
    [aux_sym__literal_repeat1] = STATE(539),
    [sym_expansion] = STATE(537),
    [sym_string] = STATE(537),
    [sym_command_name] = STATE(653),
    [sym_process_substitution] = STATE(537),
    [sym_simple_expansion] = STATE(537),
    [sym_string_expansion] = STATE(537),
    [sym_subscript] = STATE(2455),
    [sym_variable_assignment] = STATE(103),
    [aux_sym_command_repeat1] = STATE(103),
    [sym_concatenation] = STATE(542),
    [sym_file_redirect] = STATE(103),
    [sym_word] = ACTIONS(1685),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1693),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1687),
    [sym_raw_string] = ACTIONS(1685),
    [sym_variable_name] = ACTIONS(243),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_LT_LPAREN] = ACTIONS(1681),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [sym_ansii_c_string] = ACTIONS(1685),
    [anon_sym_BQUOTE] = ACTIONS(1697),
    [anon_sym_GT_LPAREN] = ACTIONS(1681),
    [sym__special_character] = ACTIONS(2224),
  },
  [545] = {
    [sym_command_substitution] = STATE(423),
    [aux_sym__literal_repeat1] = STATE(425),
    [sym_string] = STATE(423),
    [sym_process_substitution] = STATE(423),
    [sym_simple_expansion] = STATE(423),
    [sym_string_expansion] = STATE(423),
    [aux_sym_command_repeat2] = STATE(575),
    [sym_concatenation] = STATE(575),
    [sym_expansion] = STATE(423),
    [sym_word] = ACTIONS(1968),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LT] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(1970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(1972),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1974),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1976),
    [anon_sym_LF] = ACTIONS(345),
    [anon_sym_SEMI] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(1968),
    [sym_file_descriptor] = ACTIONS(345),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(1972),
    [anon_sym_DQUOTE] = ACTIONS(1978),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(1970),
    [sym_ansii_c_string] = ACTIONS(1968),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
  },
  [546] = {
    [aux_sym_concatenation_repeat1] = STATE(578),
    [sym_word] = ACTIONS(359),
    [anon_sym_AMP_GT_GT] = ACTIONS(359),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [anon_sym_LT_LPAREN] = ACTIONS(359),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(2226),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_LT_AMP] = ACTIONS(359),
    [anon_sym_GT_GT] = ACTIONS(359),
    [sym__special_character] = ACTIONS(359),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(359),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(359),
    [sym_raw_string] = ACTIONS(359),
    [sym_variable_name] = ACTIONS(359),
    [sym_file_descriptor] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(359),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(359),
    [anon_sym_GT_AMP] = ACTIONS(359),
    [anon_sym_BQUOTE] = ACTIONS(359),
    [anon_sym_GT_LPAREN] = ACTIONS(359),
    [sym_ansii_c_string] = ACTIONS(359),
  },
  [547] = {
    [aux_sym_concatenation_repeat1] = STATE(1065),
    [anon_sym_AMP_GT_GT] = ACTIONS(365),
    [anon_sym_LT_LT] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(365),
    [sym__concat] = ACTIONS(2089),
    [anon_sym_PIPE] = ACTIONS(365),
    [anon_sym_LT] = ACTIONS(365),
    [anon_sym_LT_AMP] = ACTIONS(365),
    [anon_sym_GT_GT] = ACTIONS(365),
    [anon_sym_LT_LT_DASH] = ACTIONS(365),
    [anon_sym_LF] = ACTIONS(363),
    [anon_sym_SEMI] = ACTIONS(365),
    [anon_sym_RPAREN] = ACTIONS(365),
    [anon_sym_AMP] = ACTIONS(365),
    [anon_sym_GT] = ACTIONS(365),
    [sym_file_descriptor] = ACTIONS(363),
    [anon_sym_AMP_GT] = ACTIONS(365),
    [anon_sym_LT_LT_LT] = ACTIONS(365),
    [anon_sym_GT_AMP] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [anon_sym_AMP_AMP] = ACTIONS(365),
    [anon_sym_SEMI_SEMI] = ACTIONS(365),
    [anon_sym_PIPE_AMP] = ACTIONS(365),
  },
  [548] = {
    [aux_sym__literal_repeat1] = STATE(1103),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_LT] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [sym__special_character] = ACTIONS(2091),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_LF] = ACTIONS(369),
    [anon_sym_SEMI] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [sym_file_descriptor] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_LT_LT_LT] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_esac] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_SEMI_SEMI] = ACTIONS(371),
    [anon_sym_PIPE_AMP] = ACTIONS(371),
  },
  [549] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(365),
    [anon_sym_LT_LT] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(365),
    [anon_sym_PIPE] = ACTIONS(365),
    [anon_sym_LT] = ACTIONS(365),
    [anon_sym_LT_AMP] = ACTIONS(365),
    [anon_sym_GT_GT] = ACTIONS(365),
    [anon_sym_LT_LT_DASH] = ACTIONS(365),
    [anon_sym_LF] = ACTIONS(363),
    [anon_sym_SEMI] = ACTIONS(365),
    [anon_sym_RPAREN] = ACTIONS(365),
    [anon_sym_AMP] = ACTIONS(365),
    [anon_sym_GT] = ACTIONS(365),
    [sym_file_descriptor] = ACTIONS(363),
    [anon_sym_AMP_GT] = ACTIONS(365),
    [anon_sym_LT_LT_LT] = ACTIONS(365),
    [anon_sym_GT_AMP] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [anon_sym_esac] = ACTIONS(365),
    [anon_sym_AMP_AMP] = ACTIONS(365),
    [anon_sym_SEMI_SEMI] = ACTIONS(365),
    [anon_sym_PIPE_AMP] = ACTIONS(365),
  },
  [550] = {
    [aux_sym_concatenation_repeat1] = STATE(1225),
    [sym_word] = ACTIONS(375),
    [anon_sym_AMP_GT_GT] = ACTIONS(375),
    [anon_sym_DOLLAR] = ACTIONS(375),
    [anon_sym_LT_LT] = ACTIONS(375),
    [anon_sym_LT_LPAREN] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(375),
    [sym__concat] = ACTIONS(2228),
    [anon_sym_PIPE] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(375),
    [anon_sym_LT_AMP] = ACTIONS(375),
    [anon_sym_GT_GT] = ACTIONS(375),
    [sym__special_character] = ACTIONS(375),
    [anon_sym_LT_LT_DASH] = ACTIONS(375),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(375),
    [aux_sym__simple_variable_name_token1] = ACTIONS(375),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(375),
    [anon_sym_LF] = ACTIONS(379),
    [anon_sym_SEMI] = ACTIONS(375),
    [sym_raw_string] = ACTIONS(375),
    [sym_variable_name] = ACTIONS(379),
    [sym_file_descriptor] = ACTIONS(379),
    [anon_sym_AMP] = ACTIONS(375),
    [anon_sym_GT] = ACTIONS(375),
    [anon_sym_AMP_GT] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [anon_sym_LT_LT_LT] = ACTIONS(375),
    [anon_sym_GT_AMP] = ACTIONS(375),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [anon_sym_esac] = ACTIONS(375),
    [anon_sym_GT_LPAREN] = ACTIONS(375),
    [sym_ansii_c_string] = ACTIONS(375),
    [anon_sym_AMP_AMP] = ACTIONS(375),
    [anon_sym_SEMI_SEMI] = ACTIONS(375),
    [anon_sym_PIPE_AMP] = ACTIONS(375),
  },
  [551] = {
    [aux_sym__literal_repeat1] = STATE(1263),
    [sym_word] = ACTIONS(381),
    [anon_sym_AMP_GT_GT] = ACTIONS(381),
    [anon_sym_DOLLAR] = ACTIONS(381),
    [anon_sym_LT_LT] = ACTIONS(381),
    [anon_sym_LT_LPAREN] = ACTIONS(381),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(381),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_LT_AMP] = ACTIONS(381),
    [anon_sym_GT_GT] = ACTIONS(381),
    [sym__special_character] = ACTIONS(2230),
    [anon_sym_LT_LT_DASH] = ACTIONS(381),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(381),
    [aux_sym__simple_variable_name_token1] = ACTIONS(381),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(381),
    [anon_sym_LF] = ACTIONS(385),
    [anon_sym_SEMI] = ACTIONS(381),
    [sym_raw_string] = ACTIONS(381),
    [sym_variable_name] = ACTIONS(385),
    [sym_file_descriptor] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_GT] = ACTIONS(381),
    [anon_sym_AMP_GT] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [anon_sym_LT_LT_LT] = ACTIONS(381),
    [anon_sym_GT_AMP] = ACTIONS(381),
    [anon_sym_BQUOTE] = ACTIONS(381),
    [anon_sym_esac] = ACTIONS(381),
    [anon_sym_GT_LPAREN] = ACTIONS(381),
    [sym_ansii_c_string] = ACTIONS(381),
    [anon_sym_AMP_AMP] = ACTIONS(381),
    [anon_sym_SEMI_SEMI] = ACTIONS(381),
    [anon_sym_PIPE_AMP] = ACTIONS(381),
  },
  [552] = {
    [sym_command_substitution] = STATE(397),
    [aux_sym__literal_repeat1] = STATE(398),
    [sym_string] = STATE(397),
    [aux_sym_declaration_command_repeat1] = STATE(431),
    [sym_process_substitution] = STATE(397),
    [sym_simple_expansion] = STATE(397),
    [sym_subscript] = STATE(2464),
    [sym_string_expansion] = STATE(397),
    [sym_variable_assignment] = STATE(431),
    [sym_concatenation] = STATE(431),
    [sym_expansion] = STATE(397),
    [sym_word] = ACTIONS(1920),
    [anon_sym_AMP_GT_GT] = ACTIONS(387),
    [anon_sym_DOLLAR] = ACTIONS(1922),
    [anon_sym_LT_LT] = ACTIONS(387),
    [anon_sym_LT_LPAREN] = ACTIONS(1924),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_PIPE] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(387),
    [anon_sym_LT_AMP] = ACTIONS(387),
    [anon_sym_GT_GT] = ACTIONS(387),
    [sym__special_character] = ACTIONS(1926),
    [anon_sym_LT_LT_DASH] = ACTIONS(387),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1928),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1988),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1932),
    [anon_sym_LF] = ACTIONS(391),
    [anon_sym_SEMI] = ACTIONS(387),
    [sym_raw_string] = ACTIONS(1920),
    [sym_variable_name] = ACTIONS(1934),
    [sym_file_descriptor] = ACTIONS(391),
    [anon_sym_AMP] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(387),
    [anon_sym_AMP_GT] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(1936),
    [anon_sym_LT_LT_LT] = ACTIONS(387),
    [anon_sym_GT_AMP] = ACTIONS(387),
    [anon_sym_BQUOTE] = ACTIONS(387),
    [anon_sym_GT_LPAREN] = ACTIONS(1924),
    [sym_ansii_c_string] = ACTIONS(1920),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_SEMI_SEMI] = ACTIONS(387),
    [anon_sym_PIPE_AMP] = ACTIONS(387),
  },
  [553] = {
    [aux_sym_concatenation_repeat1] = STATE(1257),
    [sym_word] = ACTIONS(393),
    [anon_sym_AMP_GT_GT] = ACTIONS(393),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [anon_sym_LT_LT] = ACTIONS(393),
    [anon_sym_LT_LPAREN] = ACTIONS(393),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(393),
    [sym__concat] = ACTIONS(2232),
    [anon_sym_PIPE] = ACTIONS(393),
    [anon_sym_LT] = ACTIONS(393),
    [anon_sym_LT_AMP] = ACTIONS(393),
    [anon_sym_GT_GT] = ACTIONS(393),
    [sym__special_character] = ACTIONS(393),
    [anon_sym_LT_LT_DASH] = ACTIONS(393),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(393),
    [aux_sym__simple_variable_name_token1] = ACTIONS(393),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(393),
    [anon_sym_LF] = ACTIONS(397),
    [anon_sym_SEMI] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(393),
    [sym_file_descriptor] = ACTIONS(397),
    [anon_sym_AMP] = ACTIONS(393),
    [anon_sym_GT] = ACTIONS(393),
    [anon_sym_AMP_GT] = ACTIONS(393),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_LT_LT_LT] = ACTIONS(393),
    [anon_sym_GT_AMP] = ACTIONS(393),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [anon_sym_esac] = ACTIONS(393),
    [anon_sym_GT_LPAREN] = ACTIONS(393),
    [sym_ansii_c_string] = ACTIONS(393),
    [anon_sym_AMP_AMP] = ACTIONS(393),
    [anon_sym_SEMI_SEMI] = ACTIONS(393),
    [anon_sym_PIPE_AMP] = ACTIONS(393),
  },
  [554] = {
    [aux_sym__literal_repeat1] = STATE(1295),
    [sym_word] = ACTIONS(399),
    [anon_sym_AMP_GT_GT] = ACTIONS(399),
    [anon_sym_DOLLAR] = ACTIONS(399),
    [anon_sym_LT_LT] = ACTIONS(399),
    [anon_sym_LT_LPAREN] = ACTIONS(399),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_PIPE] = ACTIONS(399),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_LT_AMP] = ACTIONS(399),
    [anon_sym_GT_GT] = ACTIONS(399),
    [sym__special_character] = ACTIONS(2234),
    [anon_sym_LT_LT_DASH] = ACTIONS(399),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [aux_sym__simple_variable_name_token1] = ACTIONS(399),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(399),
    [anon_sym_LF] = ACTIONS(403),
    [anon_sym_SEMI] = ACTIONS(399),
    [sym_raw_string] = ACTIONS(399),
    [sym_file_descriptor] = ACTIONS(403),
    [anon_sym_AMP] = ACTIONS(399),
    [anon_sym_GT] = ACTIONS(399),
    [anon_sym_AMP_GT] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_LT_LT_LT] = ACTIONS(399),
    [anon_sym_GT_AMP] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(399),
    [anon_sym_esac] = ACTIONS(399),
    [anon_sym_GT_LPAREN] = ACTIONS(399),
    [sym_ansii_c_string] = ACTIONS(399),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_SEMI_SEMI] = ACTIONS(399),
    [anon_sym_PIPE_AMP] = ACTIONS(399),
  },
  [555] = {
    [sym_command_substitution] = STATE(400),
    [aux_sym__literal_repeat1] = STATE(401),
    [sym_string] = STATE(400),
    [aux_sym_unset_command_repeat1] = STATE(432),
    [sym_process_substitution] = STATE(400),
    [sym_simple_expansion] = STATE(400),
    [sym_string_expansion] = STATE(400),
    [sym_concatenation] = STATE(432),
    [sym_expansion] = STATE(400),
    [sym_word] = ACTIONS(1940),
    [anon_sym_AMP_GT_GT] = ACTIONS(405),
    [anon_sym_DOLLAR] = ACTIONS(1942),
    [anon_sym_LT_LT] = ACTIONS(405),
    [anon_sym_LT_LPAREN] = ACTIONS(1944),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(405),
    [anon_sym_PIPE] = ACTIONS(405),
    [anon_sym_LT] = ACTIONS(405),
    [anon_sym_LT_AMP] = ACTIONS(405),
    [anon_sym_GT_GT] = ACTIONS(405),
    [sym__special_character] = ACTIONS(1946),
    [anon_sym_LT_LT_DASH] = ACTIONS(405),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1948),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1994),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1952),
    [anon_sym_LF] = ACTIONS(409),
    [anon_sym_SEMI] = ACTIONS(405),
    [sym_raw_string] = ACTIONS(1940),
    [sym_file_descriptor] = ACTIONS(409),
    [anon_sym_AMP] = ACTIONS(405),
    [anon_sym_GT] = ACTIONS(405),
    [anon_sym_AMP_GT] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(1954),
    [anon_sym_LT_LT_LT] = ACTIONS(405),
    [anon_sym_GT_AMP] = ACTIONS(405),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_GT_LPAREN] = ACTIONS(1944),
    [sym_ansii_c_string] = ACTIONS(1940),
    [anon_sym_AMP_AMP] = ACTIONS(405),
    [anon_sym_SEMI_SEMI] = ACTIONS(405),
    [anon_sym_PIPE_AMP] = ACTIONS(405),
  },
  [556] = {
    [sym_word] = ACTIONS(413),
    [anon_sym_AMP_GT_GT] = ACTIONS(413),
    [anon_sym_DOLLAR] = ACTIONS(411),
    [anon_sym_LT_LPAREN] = ACTIONS(413),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(413),
    [anon_sym_LT] = ACTIONS(411),
    [anon_sym_LT_AMP] = ACTIONS(413),
    [anon_sym_GT_GT] = ACTIONS(413),
    [sym__special_character] = ACTIONS(413),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(413),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(413),
    [sym_raw_string] = ACTIONS(413),
    [sym_variable_name] = ACTIONS(413),
    [sym_file_descriptor] = ACTIONS(413),
    [anon_sym_RPAREN] = ACTIONS(413),
    [anon_sym_GT] = ACTIONS(411),
    [anon_sym_AMP_GT] = ACTIONS(411),
    [anon_sym_DQUOTE] = ACTIONS(413),
    [anon_sym_GT_AMP] = ACTIONS(413),
    [anon_sym_BQUOTE] = ACTIONS(413),
    [anon_sym_GT_LPAREN] = ACTIONS(413),
    [sym_ansii_c_string] = ACTIONS(413),
  },
  [557] = {
    [sym_word] = ACTIONS(417),
    [anon_sym_AMP_GT_GT] = ACTIONS(417),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_LT_LPAREN] = ACTIONS(417),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(417),
    [anon_sym_LT] = ACTIONS(415),
    [anon_sym_LT_AMP] = ACTIONS(417),
    [anon_sym_GT_GT] = ACTIONS(417),
    [sym__special_character] = ACTIONS(417),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(417),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(417),
    [sym_raw_string] = ACTIONS(417),
    [sym_variable_name] = ACTIONS(417),
    [sym_file_descriptor] = ACTIONS(417),
    [anon_sym_RPAREN] = ACTIONS(417),
    [anon_sym_GT] = ACTIONS(415),
    [anon_sym_AMP_GT] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(417),
    [anon_sym_GT_AMP] = ACTIONS(417),
    [anon_sym_BQUOTE] = ACTIONS(417),
    [anon_sym_GT_LPAREN] = ACTIONS(417),
    [sym_ansii_c_string] = ACTIONS(417),
  },
  [558] = {
    [sym_word] = ACTIONS(421),
    [anon_sym_AMP_GT_GT] = ACTIONS(421),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_LT_LPAREN] = ACTIONS(421),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(421),
    [anon_sym_LT] = ACTIONS(419),
    [anon_sym_LT_AMP] = ACTIONS(421),
    [anon_sym_GT_GT] = ACTIONS(421),
    [sym__special_character] = ACTIONS(421),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(421),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(421),
    [sym_raw_string] = ACTIONS(421),
    [sym_variable_name] = ACTIONS(421),
    [sym_file_descriptor] = ACTIONS(421),
    [anon_sym_RPAREN] = ACTIONS(421),
    [anon_sym_GT] = ACTIONS(419),
    [anon_sym_AMP_GT] = ACTIONS(419),
    [anon_sym_DQUOTE] = ACTIONS(421),
    [anon_sym_GT_AMP] = ACTIONS(421),
    [anon_sym_BQUOTE] = ACTIONS(421),
    [anon_sym_GT_LPAREN] = ACTIONS(421),
    [sym_ansii_c_string] = ACTIONS(421),
  },
  [559] = {
    [aux_sym_concatenation_repeat1] = STATE(969),
    [anon_sym_BANG_EQ] = ACTIONS(473),
    [anon_sym_PLUS_EQ] = ACTIONS(473),
    [anon_sym_LF] = ACTIONS(473),
    [anon_sym_SEMI] = ACTIONS(473),
    [anon_sym_PLUS_PLUS] = ACTIONS(473),
    [anon_sym_DASH] = ACTIONS(473),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_AMP] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_GT_EQ] = ACTIONS(473),
    [sym__concat] = ACTIONS(2236),
    [anon_sym_PLUS] = ACTIONS(473),
    [anon_sym_LT] = ACTIONS(473),
    [sym_test_operator] = ACTIONS(473),
    [anon_sym_EQ_TILDE] = ACTIONS(473),
    [anon_sym_DASH_DASH] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(473),
    [anon_sym_LT_EQ] = ACTIONS(473),
    [anon_sym_SEMI_SEMI] = ACTIONS(473),
    [anon_sym_DASH_EQ] = ACTIONS(473),
  },
  [560] = {
    [sym_command_substitution] = STATE(559),
    [sym_unary_expression] = STATE(582),
    [sym_postfix_expression] = STATE(582),
    [sym_string] = STATE(559),
    [aux_sym__literal_repeat1] = STATE(561),
    [sym_process_substitution] = STATE(559),
    [sym_parenthesized_expression] = STATE(582),
    [sym_simple_expansion] = STATE(559),
    [sym_string_expansion] = STATE(559),
    [sym__expression] = STATE(582),
    [sym_binary_expression] = STATE(582),
    [sym_concatenation] = STATE(582),
    [sym_expansion] = STATE(559),
    [sym_word] = ACTIONS(597),
    [anon_sym_LPAREN] = ACTIONS(2238),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2240),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2242),
    [sym_raw_string] = ACTIONS(2244),
    [anon_sym_BANG] = ACTIONS(607),
    [anon_sym_DOLLAR] = ACTIONS(609),
    [anon_sym_LT_LPAREN] = ACTIONS(2246),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(2248),
    [sym_test_operator] = ACTIONS(2250),
    [anon_sym_BQUOTE] = ACTIONS(2252),
    [anon_sym_GT_LPAREN] = ACTIONS(2246),
    [sym_ansii_c_string] = ACTIONS(2244),
    [sym__special_character] = ACTIONS(2254),
  },
  [561] = {
    [aux_sym__literal_repeat1] = STATE(1007),
    [anon_sym_BANG_EQ] = ACTIONS(479),
    [anon_sym_PLUS_EQ] = ACTIONS(479),
    [sym__special_character] = ACTIONS(2256),
    [anon_sym_LF] = ACTIONS(479),
    [anon_sym_SEMI] = ACTIONS(479),
    [anon_sym_PLUS_PLUS] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(479),
    [anon_sym_AMP] = ACTIONS(479),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [anon_sym_GT_EQ] = ACTIONS(479),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(479),
    [sym_test_operator] = ACTIONS(479),
    [anon_sym_EQ_TILDE] = ACTIONS(479),
    [anon_sym_DASH_DASH] = ACTIONS(479),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_LT_EQ] = ACTIONS(479),
    [anon_sym_SEMI_SEMI] = ACTIONS(479),
    [anon_sym_DASH_EQ] = ACTIONS(479),
  },
  [562] = {
    [sym_word] = ACTIONS(581),
    [anon_sym_AMP_GT_GT] = ACTIONS(581),
    [anon_sym_DOLLAR] = ACTIONS(579),
    [anon_sym_LT_LPAREN] = ACTIONS(581),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(581),
    [anon_sym_LT] = ACTIONS(579),
    [anon_sym_LT_AMP] = ACTIONS(581),
    [anon_sym_GT_GT] = ACTIONS(581),
    [sym__special_character] = ACTIONS(581),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(581),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(581),
    [sym_raw_string] = ACTIONS(581),
    [sym_variable_name] = ACTIONS(581),
    [sym_file_descriptor] = ACTIONS(581),
    [anon_sym_RPAREN] = ACTIONS(581),
    [anon_sym_GT] = ACTIONS(579),
    [anon_sym_AMP_GT] = ACTIONS(579),
    [anon_sym_DQUOTE] = ACTIONS(581),
    [anon_sym_GT_AMP] = ACTIONS(581),
    [anon_sym_BQUOTE] = ACTIONS(581),
    [anon_sym_GT_LPAREN] = ACTIONS(581),
    [sym_ansii_c_string] = ACTIONS(581),
  },
  [563] = {
    [sym_word] = ACTIONS(191),
    [anon_sym_AMP_GT_GT] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [anon_sym_LT_LPAREN] = ACTIONS(191),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(189),
    [anon_sym_LT_AMP] = ACTIONS(191),
    [anon_sym_GT_GT] = ACTIONS(191),
    [sym__special_character] = ACTIONS(191),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(191),
    [sym_raw_string] = ACTIONS(191),
    [sym_variable_name] = ACTIONS(191),
    [sym_file_descriptor] = ACTIONS(191),
    [anon_sym_RPAREN] = ACTIONS(191),
    [anon_sym_GT] = ACTIONS(189),
    [anon_sym_AMP_GT] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [anon_sym_GT_AMP] = ACTIONS(191),
    [anon_sym_BQUOTE] = ACTIONS(191),
    [anon_sym_GT_LPAREN] = ACTIONS(191),
    [sym_ansii_c_string] = ACTIONS(191),
  },
  [564] = {
    [aux_sym__literal_repeat1] = STATE(564),
    [sym_word] = ACTIONS(634),
    [anon_sym_AMP_GT_GT] = ACTIONS(634),
    [anon_sym_DOLLAR] = ACTIONS(629),
    [anon_sym_LT_LPAREN] = ACTIONS(634),
    [sym_comment] = ACTIONS(19),
    [anon_sym_LT] = ACTIONS(629),
    [anon_sym_LT_AMP] = ACTIONS(634),
    [anon_sym_GT_GT] = ACTIONS(634),
    [sym__special_character] = ACTIONS(2258),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(634),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(634),
    [sym_raw_string] = ACTIONS(634),
    [sym_variable_name] = ACTIONS(634),
    [sym_file_descriptor] = ACTIONS(634),
    [anon_sym_RPAREN] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(629),
    [anon_sym_AMP_GT] = ACTIONS(629),
    [anon_sym_DQUOTE] = ACTIONS(634),
    [anon_sym_GT_AMP] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [anon_sym_GT_LPAREN] = ACTIONS(634),
    [sym_ansii_c_string] = ACTIONS(634),
  },
  [565] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(455),
    [sym_function_definition] = STATE(455),
    [sym_negated_command] = STATE(455),
    [sym_test_command] = STATE(455),
    [sym_variable_assignment] = STATE(597),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(455),
    [sym_for_statement] = STATE(455),
    [sym_compound_statement] = STATE(455),
    [sym_subshell] = STATE(455),
    [sym_declaration_command] = STATE(455),
    [sym_unset_command] = STATE(455),
    [sym_file_redirect] = STATE(1464),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(1464),
    [sym_c_style_for_statement] = STATE(455),
    [sym_while_statement] = STATE(455),
    [sym_case_statement] = STATE(455),
    [sym_pipeline] = STATE(455),
    [sym_list] = STATE(455),
    [sym_command] = STATE(455),
    [sym_command_name] = STATE(545),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(265),
    [anon_sym_typeset] = ACTIONS(265),
    [anon_sym_unsetenv] = ACTIONS(267),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(265),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(269),
    [anon_sym_declare] = ACTIONS(265),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(265),
    [anon_sym_unset] = ACTIONS(267),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [566] = {
    [sym_heredoc_body] = STATE(1466),
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__simple_heredoc_body] = ACTIONS(870),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [sym__heredoc_body_beginning] = ACTIONS(872),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(644),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [567] = {
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(644),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [568] = {
    [aux_sym__literal_repeat1] = STATE(386),
    [sym_if_statement] = STATE(599),
    [sym_function_definition] = STATE(599),
    [sym_negated_command] = STATE(599),
    [sym_test_command] = STATE(599),
    [sym_variable_assignment] = STATE(600),
    [sym_subscript] = STATE(2407),
    [sym_concatenation] = STATE(389),
    [sym_expansion] = STATE(384),
    [sym_command_substitution] = STATE(384),
    [sym_redirected_statement] = STATE(599),
    [sym_for_statement] = STATE(599),
    [sym_compound_statement] = STATE(599),
    [sym_subshell] = STATE(599),
    [sym_declaration_command] = STATE(599),
    [sym_unset_command] = STATE(599),
    [sym_file_redirect] = STATE(1464),
    [sym_string] = STATE(384),
    [sym_process_substitution] = STATE(384),
    [aux_sym_command_repeat1] = STATE(1464),
    [sym_c_style_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_case_statement] = STATE(599),
    [sym_pipeline] = STATE(599),
    [sym_list] = STATE(599),
    [sym_command] = STATE(599),
    [sym_command_name] = STATE(545),
    [sym_simple_expansion] = STATE(384),
    [sym_string_expansion] = STATE(384),
    [sym_word] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(265),
    [anon_sym_typeset] = ACTIONS(265),
    [anon_sym_unsetenv] = ACTIONS(267),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LPAREN] = ACTIONS(79),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(265),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(93),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(95),
    [anon_sym_BANG] = ACTIONS(269),
    [anon_sym_declare] = ACTIONS(265),
    [sym_variable_name] = ACTIONS(99),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(101),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(265),
    [anon_sym_unset] = ACTIONS(267),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(105),
    [anon_sym_GT_LPAREN] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [569] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [anon_sym_PIPE_AMP] = ACTIONS(2218),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LF] = ACTIONS(2261),
    [anon_sym_SEMI] = ACTIONS(2263),
    [sym_file_descriptor] = ACTIONS(439),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_AMP] = ACTIONS(2263),
    [anon_sym_AMP_GT] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(2216),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_PIPE] = ACTIONS(2218),
    [anon_sym_BQUOTE] = ACTIONS(2007),
    [anon_sym_LT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(2216),
    [anon_sym_SEMI_SEMI] = ACTIONS(2263),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
  },
  [570] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(2216),
    [anon_sym_PIPE] = ACTIONS(2218),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(2261),
    [anon_sym_SEMI] = ACTIONS(2263),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(2263),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(2007),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(2216),
    [anon_sym_SEMI_SEMI] = ACTIONS(2263),
    [anon_sym_PIPE_AMP] = ACTIONS(2218),
  },
  [571] = {
    [sym_command_substitution] = STATE(423),
    [aux_sym__literal_repeat1] = STATE(425),
    [sym_string] = STATE(423),
    [sym_process_substitution] = STATE(423),
    [sym_simple_expansion] = STATE(423),
    [sym_string_expansion] = STATE(423),
    [aux_sym_command_repeat2] = STATE(603),
    [sym_concatenation] = STATE(603),
    [sym_expansion] = STATE(423),
    [sym_word] = ACTIONS(1968),
    [anon_sym_AMP_GT_GT] = ACTIONS(750),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LT] = ACTIONS(750),
    [anon_sym_LT_LPAREN] = ACTIONS(1970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(750),
    [anon_sym_PIPE] = ACTIONS(750),
    [anon_sym_LT] = ACTIONS(750),
    [anon_sym_LT_AMP] = ACTIONS(750),
    [anon_sym_GT_GT] = ACTIONS(750),
    [anon_sym_EQ_TILDE] = ACTIONS(1972),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_LT_LT_DASH] = ACTIONS(750),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1974),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1976),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [sym_raw_string] = ACTIONS(1968),
    [sym_file_descriptor] = ACTIONS(752),
    [anon_sym_AMP] = ACTIONS(750),
    [anon_sym_GT] = ACTIONS(750),
    [anon_sym_AMP_GT] = ACTIONS(750),
    [anon_sym_EQ_EQ] = ACTIONS(1972),
    [anon_sym_DQUOTE] = ACTIONS(1978),
    [anon_sym_LT_LT_LT] = ACTIONS(750),
    [anon_sym_GT_AMP] = ACTIONS(750),
    [anon_sym_BQUOTE] = ACTIONS(750),
    [anon_sym_GT_LPAREN] = ACTIONS(1970),
    [sym_ansii_c_string] = ACTIONS(1968),
    [anon_sym_AMP_AMP] = ACTIONS(750),
    [anon_sym_SEMI_SEMI] = ACTIONS(750),
    [anon_sym_PIPE_AMP] = ACTIONS(750),
  },
  [572] = {
    [aux_sym_concatenation_repeat1] = STATE(1193),
    [sym_word] = ACTIONS(770),
    [anon_sym_AMP_GT_GT] = ACTIONS(770),
    [anon_sym_DOLLAR] = ACTIONS(770),
    [anon_sym_LT_LT] = ACTIONS(770),
    [anon_sym_LT_LPAREN] = ACTIONS(770),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(770),
    [sym__concat] = ACTIONS(2194),
    [anon_sym_PIPE] = ACTIONS(770),
    [anon_sym_LT] = ACTIONS(770),
    [anon_sym_LT_AMP] = ACTIONS(770),
    [anon_sym_GT_GT] = ACTIONS(770),
    [anon_sym_EQ_TILDE] = ACTIONS(770),
    [sym__special_character] = ACTIONS(770),
    [anon_sym_LT_LT_DASH] = ACTIONS(770),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(770),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(770),
    [anon_sym_LF] = ACTIONS(772),
    [anon_sym_SEMI] = ACTIONS(770),
    [sym_raw_string] = ACTIONS(770),
    [sym_file_descriptor] = ACTIONS(772),
    [anon_sym_AMP] = ACTIONS(770),
    [anon_sym_GT] = ACTIONS(770),
    [anon_sym_AMP_GT] = ACTIONS(770),
    [anon_sym_EQ_EQ] = ACTIONS(770),
    [anon_sym_DQUOTE] = ACTIONS(770),
    [anon_sym_LT_LT_LT] = ACTIONS(770),
    [anon_sym_GT_AMP] = ACTIONS(770),
    [anon_sym_BQUOTE] = ACTIONS(770),
    [anon_sym_esac] = ACTIONS(770),
    [anon_sym_GT_LPAREN] = ACTIONS(770),
    [sym_ansii_c_string] = ACTIONS(770),
    [anon_sym_AMP_AMP] = ACTIONS(770),
    [anon_sym_SEMI_SEMI] = ACTIONS(770),
    [anon_sym_PIPE_AMP] = ACTIONS(770),
  },
  [573] = {
    [sym_command_substitution] = STATE(604),
    [aux_sym__literal_repeat1] = STATE(606),
    [sym_string] = STATE(604),
    [sym_process_substitution] = STATE(604),
    [sym_simple_expansion] = STATE(604),
    [sym_string_expansion] = STATE(604),
    [sym_concatenation] = STATE(605),
    [sym_expansion] = STATE(604),
    [sym_word] = ACTIONS(2265),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1693),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1687),
    [sym_raw_string] = ACTIONS(2265),
    [anon_sym_BQUOTE] = ACTIONS(1697),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [sym_ansii_c_string] = ACTIONS(2265),
    [anon_sym_GT_LPAREN] = ACTIONS(1681),
    [anon_sym_LT_LPAREN] = ACTIONS(1681),
    [sym__special_character] = ACTIONS(2224),
    [sym_regex] = ACTIONS(2267),
    [sym_comment] = ACTIONS(19),
  },
  [574] = {
    [aux_sym__literal_repeat1] = STATE(1231),
    [sym_word] = ACTIONS(778),
    [anon_sym_AMP_GT_GT] = ACTIONS(778),
    [anon_sym_DOLLAR] = ACTIONS(778),
    [anon_sym_LT_LT] = ACTIONS(778),
    [anon_sym_LT_LPAREN] = ACTIONS(778),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_LT] = ACTIONS(778),
    [anon_sym_LT_AMP] = ACTIONS(778),
    [anon_sym_GT_GT] = ACTIONS(778),
    [anon_sym_EQ_TILDE] = ACTIONS(778),
    [sym__special_character] = ACTIONS(2200),
    [anon_sym_LT_LT_DASH] = ACTIONS(778),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(778),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(778),
    [anon_sym_LF] = ACTIONS(780),
    [anon_sym_SEMI] = ACTIONS(778),
    [sym_raw_string] = ACTIONS(778),
    [sym_file_descriptor] = ACTIONS(780),
    [anon_sym_AMP] = ACTIONS(778),
    [anon_sym_GT] = ACTIONS(778),
    [anon_sym_AMP_GT] = ACTIONS(778),
    [anon_sym_EQ_EQ] = ACTIONS(778),
    [anon_sym_DQUOTE] = ACTIONS(778),
    [anon_sym_LT_LT_LT] = ACTIONS(778),
    [anon_sym_GT_AMP] = ACTIONS(778),
    [anon_sym_BQUOTE] = ACTIONS(778),
    [anon_sym_esac] = ACTIONS(778),
    [anon_sym_GT_LPAREN] = ACTIONS(778),
    [sym_ansii_c_string] = ACTIONS(778),
    [anon_sym_AMP_AMP] = ACTIONS(778),
    [anon_sym_SEMI_SEMI] = ACTIONS(778),
    [anon_sym_PIPE_AMP] = ACTIONS(778),
  },
  [575] = {
    [sym_command_substitution] = STATE(423),
    [aux_sym__literal_repeat1] = STATE(425),
    [sym_string] = STATE(423),
    [sym_process_substitution] = STATE(423),
    [sym_simple_expansion] = STATE(423),
    [sym_string_expansion] = STATE(423),
    [aux_sym_command_repeat2] = STATE(472),
    [sym_concatenation] = STATE(472),
    [sym_expansion] = STATE(423),
    [sym_word] = ACTIONS(1968),
    [anon_sym_AMP_GT_GT] = ACTIONS(750),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LT] = ACTIONS(750),
    [anon_sym_LT_LPAREN] = ACTIONS(1970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(750),
    [anon_sym_PIPE] = ACTIONS(750),
    [anon_sym_LT] = ACTIONS(750),
    [anon_sym_LT_AMP] = ACTIONS(750),
    [anon_sym_GT_GT] = ACTIONS(750),
    [anon_sym_EQ_TILDE] = ACTIONS(1972),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_LT_LT_DASH] = ACTIONS(750),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1974),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1976),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [sym_raw_string] = ACTIONS(1968),
    [sym_file_descriptor] = ACTIONS(752),
    [anon_sym_AMP] = ACTIONS(750),
    [anon_sym_GT] = ACTIONS(750),
    [anon_sym_AMP_GT] = ACTIONS(750),
    [anon_sym_EQ_EQ] = ACTIONS(1972),
    [anon_sym_DQUOTE] = ACTIONS(1978),
    [anon_sym_LT_LT_LT] = ACTIONS(750),
    [anon_sym_GT_AMP] = ACTIONS(750),
    [anon_sym_BQUOTE] = ACTIONS(750),
    [anon_sym_GT_LPAREN] = ACTIONS(1970),
    [sym_ansii_c_string] = ACTIONS(1968),
    [anon_sym_AMP_AMP] = ACTIONS(750),
    [anon_sym_SEMI_SEMI] = ACTIONS(750),
    [anon_sym_PIPE_AMP] = ACTIONS(750),
  },
  [576] = {
    [sym_word] = ACTIONS(784),
    [anon_sym_AMP_GT_GT] = ACTIONS(784),
    [anon_sym_DOLLAR] = ACTIONS(782),
    [anon_sym_LT_LPAREN] = ACTIONS(784),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(784),
    [anon_sym_LT] = ACTIONS(782),
    [anon_sym_LT_AMP] = ACTIONS(784),
    [anon_sym_GT_GT] = ACTIONS(784),
    [sym__special_character] = ACTIONS(784),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(784),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(784),
    [sym_raw_string] = ACTIONS(784),
    [sym_variable_name] = ACTIONS(784),
    [sym_file_descriptor] = ACTIONS(784),
    [anon_sym_RPAREN] = ACTIONS(784),
    [anon_sym_GT] = ACTIONS(782),
    [anon_sym_AMP_GT] = ACTIONS(782),
    [anon_sym_DQUOTE] = ACTIONS(784),
    [anon_sym_GT_AMP] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(784),
    [anon_sym_GT_LPAREN] = ACTIONS(784),
    [sym_ansii_c_string] = ACTIONS(784),
  },
  [577] = {
    [sym_command_substitution] = STATE(576),
    [sym_string] = STATE(576),
    [sym_process_substitution] = STATE(576),
    [sym_simple_expansion] = STATE(576),
    [sym_string_expansion] = STATE(576),
    [sym_expansion] = STATE(576),
    [sym_word] = ACTIONS(2269),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(117),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(119),
    [sym_raw_string] = ACTIONS(2269),
    [anon_sym_DOLLAR] = ACTIONS(2271),
    [anon_sym_LT_LPAREN] = ACTIONS(123),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_BQUOTE] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(123),
    [sym_ansii_c_string] = ACTIONS(2269),
    [sym__special_character] = ACTIONS(2269),
  },
  [578] = {
    [aux_sym_concatenation_repeat1] = STATE(578),
    [sym_word] = ACTIONS(784),
    [anon_sym_AMP_GT_GT] = ACTIONS(784),
    [anon_sym_DOLLAR] = ACTIONS(782),
    [anon_sym_LT_LPAREN] = ACTIONS(784),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(2273),
    [anon_sym_LT] = ACTIONS(782),
    [anon_sym_LT_AMP] = ACTIONS(784),
    [anon_sym_GT_GT] = ACTIONS(784),
    [sym__special_character] = ACTIONS(784),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(784),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(784),
    [sym_raw_string] = ACTIONS(784),
    [sym_variable_name] = ACTIONS(784),
    [sym_file_descriptor] = ACTIONS(784),
    [anon_sym_RPAREN] = ACTIONS(784),
    [anon_sym_GT] = ACTIONS(782),
    [anon_sym_AMP_GT] = ACTIONS(782),
    [anon_sym_DQUOTE] = ACTIONS(784),
    [anon_sym_GT_AMP] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(784),
    [anon_sym_GT_LPAREN] = ACTIONS(784),
    [sym_ansii_c_string] = ACTIONS(784),
  },
  [579] = {
    [sym_command_substitution] = STATE(550),
    [aux_sym__literal_repeat1] = STATE(551),
    [sym_string] = STATE(550),
    [aux_sym_declaration_command_repeat1] = STATE(579),
    [sym_process_substitution] = STATE(550),
    [sym_simple_expansion] = STATE(550),
    [sym_subscript] = STATE(2482),
    [sym_string_expansion] = STATE(550),
    [sym_variable_assignment] = STATE(579),
    [sym_concatenation] = STATE(579),
    [sym_expansion] = STATE(550),
    [sym_word] = ACTIONS(2276),
    [anon_sym_AMP_GT_GT] = ACTIONS(798),
    [anon_sym_DOLLAR] = ACTIONS(2279),
    [anon_sym_LT_LT] = ACTIONS(798),
    [anon_sym_LT_LPAREN] = ACTIONS(2282),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(798),
    [anon_sym_PIPE] = ACTIONS(798),
    [anon_sym_LT] = ACTIONS(798),
    [anon_sym_LT_AMP] = ACTIONS(798),
    [anon_sym_GT_GT] = ACTIONS(798),
    [sym__special_character] = ACTIONS(2285),
    [anon_sym_LT_LT_DASH] = ACTIONS(798),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2288),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2294),
    [anon_sym_LF] = ACTIONS(818),
    [anon_sym_SEMI] = ACTIONS(798),
    [sym_raw_string] = ACTIONS(2276),
    [sym_variable_name] = ACTIONS(2297),
    [sym_file_descriptor] = ACTIONS(818),
    [anon_sym_AMP] = ACTIONS(798),
    [anon_sym_GT] = ACTIONS(798),
    [anon_sym_AMP_GT] = ACTIONS(798),
    [anon_sym_DQUOTE] = ACTIONS(2300),
    [anon_sym_LT_LT_LT] = ACTIONS(798),
    [anon_sym_GT_AMP] = ACTIONS(798),
    [anon_sym_BQUOTE] = ACTIONS(2303),
    [anon_sym_esac] = ACTIONS(798),
    [anon_sym_GT_LPAREN] = ACTIONS(2282),
    [sym_ansii_c_string] = ACTIONS(2276),
    [anon_sym_AMP_AMP] = ACTIONS(798),
    [anon_sym_SEMI_SEMI] = ACTIONS(798),
    [anon_sym_PIPE_AMP] = ACTIONS(798),
  },
  [580] = {
    [sym_command_substitution] = STATE(553),
    [aux_sym__literal_repeat1] = STATE(554),
    [sym_string] = STATE(553),
    [aux_sym_unset_command_repeat1] = STATE(580),
    [sym_process_substitution] = STATE(553),
    [sym_simple_expansion] = STATE(553),
    [sym_string_expansion] = STATE(553),
    [sym_concatenation] = STATE(580),
    [sym_expansion] = STATE(553),
    [sym_word] = ACTIONS(2306),
    [anon_sym_AMP_GT_GT] = ACTIONS(832),
    [anon_sym_DOLLAR] = ACTIONS(2309),
    [anon_sym_LT_LT] = ACTIONS(832),
    [anon_sym_LT_LPAREN] = ACTIONS(2312),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(832),
    [anon_sym_PIPE] = ACTIONS(832),
    [anon_sym_LT] = ACTIONS(832),
    [anon_sym_LT_AMP] = ACTIONS(832),
    [anon_sym_GT_GT] = ACTIONS(832),
    [sym__special_character] = ACTIONS(2315),
    [anon_sym_LT_LT_DASH] = ACTIONS(832),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2318),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2324),
    [anon_sym_LF] = ACTIONS(852),
    [anon_sym_SEMI] = ACTIONS(832),
    [sym_raw_string] = ACTIONS(2306),
    [sym_file_descriptor] = ACTIONS(852),
    [anon_sym_AMP] = ACTIONS(832),
    [anon_sym_GT] = ACTIONS(832),
    [anon_sym_AMP_GT] = ACTIONS(832),
    [anon_sym_DQUOTE] = ACTIONS(2327),
    [anon_sym_LT_LT_LT] = ACTIONS(832),
    [anon_sym_GT_AMP] = ACTIONS(832),
    [anon_sym_BQUOTE] = ACTIONS(2330),
    [anon_sym_esac] = ACTIONS(832),
    [anon_sym_GT_LPAREN] = ACTIONS(2312),
    [sym_ansii_c_string] = ACTIONS(2306),
    [anon_sym_AMP_AMP] = ACTIONS(832),
    [anon_sym_SEMI_SEMI] = ACTIONS(832),
    [anon_sym_PIPE_AMP] = ACTIONS(832),
  },
  [581] = {
    [sym_word] = ACTIONS(862),
    [anon_sym_AMP_GT_GT] = ACTIONS(862),
    [anon_sym_DOLLAR] = ACTIONS(860),
    [anon_sym_LT_LPAREN] = ACTIONS(862),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(862),
    [anon_sym_LT] = ACTIONS(860),
    [anon_sym_LT_AMP] = ACTIONS(862),
    [anon_sym_GT_GT] = ACTIONS(862),
    [sym__special_character] = ACTIONS(862),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(862),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(862),
    [sym_raw_string] = ACTIONS(862),
    [sym_variable_name] = ACTIONS(862),
    [sym_file_descriptor] = ACTIONS(862),
    [anon_sym_RPAREN] = ACTIONS(862),
    [anon_sym_GT] = ACTIONS(860),
    [anon_sym_AMP_GT] = ACTIONS(860),
    [anon_sym_DQUOTE] = ACTIONS(862),
    [anon_sym_GT_AMP] = ACTIONS(862),
    [anon_sym_BQUOTE] = ACTIONS(862),
    [anon_sym_GT_LPAREN] = ACTIONS(862),
    [sym_ansii_c_string] = ACTIONS(862),
  },
  [582] = {
    [anon_sym_BANG_EQ] = ACTIONS(1079),
    [anon_sym_PLUS_EQ] = ACTIONS(1079),
    [anon_sym_LF] = ACTIONS(902),
    [anon_sym_SEMI] = ACTIONS(902),
    [anon_sym_PLUS_PLUS] = ACTIONS(1083),
    [anon_sym_DASH] = ACTIONS(1079),
    [anon_sym_GT] = ACTIONS(1079),
    [anon_sym_EQ] = ACTIONS(1079),
    [anon_sym_AMP] = ACTIONS(902),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(1085),
    [anon_sym_PIPE_PIPE] = ACTIONS(1079),
    [anon_sym_GT_EQ] = ACTIONS(1079),
    [anon_sym_PLUS] = ACTIONS(1079),
    [anon_sym_LT] = ACTIONS(1079),
    [sym_test_operator] = ACTIONS(1079),
    [anon_sym_EQ_TILDE] = ACTIONS(1085),
    [anon_sym_DASH_DASH] = ACTIONS(1083),
    [anon_sym_AMP_AMP] = ACTIONS(1079),
    [anon_sym_LT_EQ] = ACTIONS(1079),
    [anon_sym_SEMI_SEMI] = ACTIONS(902),
    [anon_sym_DASH_EQ] = ACTIONS(1079),
  },
  [583] = {
    [sym_command_substitution] = STATE(559),
    [sym_unary_expression] = STATE(610),
    [sym_postfix_expression] = STATE(610),
    [sym_string] = STATE(559),
    [aux_sym__literal_repeat1] = STATE(561),
    [sym_process_substitution] = STATE(559),
    [sym_parenthesized_expression] = STATE(610),
    [sym_simple_expansion] = STATE(559),
    [sym_string_expansion] = STATE(559),
    [sym__expression] = STATE(610),
    [sym_binary_expression] = STATE(610),
    [sym_concatenation] = STATE(610),
    [sym_expansion] = STATE(559),
    [sym_word] = ACTIONS(597),
    [anon_sym_LPAREN] = ACTIONS(2238),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2240),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2242),
    [sym_raw_string] = ACTIONS(2244),
    [anon_sym_BANG] = ACTIONS(607),
    [anon_sym_DOLLAR] = ACTIONS(609),
    [anon_sym_LT_LPAREN] = ACTIONS(2246),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(2248),
    [sym_test_operator] = ACTIONS(2250),
    [anon_sym_BQUOTE] = ACTIONS(2252),
    [anon_sym_GT_LPAREN] = ACTIONS(2246),
    [sym_ansii_c_string] = ACTIONS(2244),
    [sym__special_character] = ACTIONS(2254),
  },
  [584] = {
    [anon_sym_BANG_EQ] = ACTIONS(906),
    [anon_sym_PLUS_EQ] = ACTIONS(906),
    [anon_sym_LF] = ACTIONS(906),
    [anon_sym_SEMI] = ACTIONS(906),
    [anon_sym_PLUS_PLUS] = ACTIONS(906),
    [anon_sym_DASH] = ACTIONS(906),
    [anon_sym_GT] = ACTIONS(906),
    [anon_sym_EQ] = ACTIONS(906),
    [anon_sym_AMP] = ACTIONS(906),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(906),
    [anon_sym_PIPE_PIPE] = ACTIONS(906),
    [anon_sym_GT_EQ] = ACTIONS(906),
    [anon_sym_PLUS] = ACTIONS(906),
    [anon_sym_LT] = ACTIONS(906),
    [sym_test_operator] = ACTIONS(906),
    [anon_sym_EQ_TILDE] = ACTIONS(906),
    [anon_sym_DASH_DASH] = ACTIONS(906),
    [anon_sym_AMP_AMP] = ACTIONS(906),
    [anon_sym_LT_EQ] = ACTIONS(906),
    [anon_sym_SEMI_SEMI] = ACTIONS(906),
    [anon_sym_DASH_EQ] = ACTIONS(906),
  },
  [585] = {
    [sym_command_substitution] = STATE(559),
    [sym_unary_expression] = STATE(610),
    [sym_postfix_expression] = STATE(610),
    [sym_string] = STATE(559),
    [aux_sym__literal_repeat1] = STATE(561),
    [sym_process_substitution] = STATE(559),
    [sym_parenthesized_expression] = STATE(610),
    [sym_simple_expansion] = STATE(559),
    [sym_string_expansion] = STATE(559),
    [sym__expression] = STATE(610),
    [sym_binary_expression] = STATE(610),
    [sym_concatenation] = STATE(610),
    [sym_expansion] = STATE(559),
    [sym_word] = ACTIONS(597),
    [anon_sym_LPAREN] = ACTIONS(2238),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2240),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2242),
    [sym_raw_string] = ACTIONS(2244),
    [anon_sym_BANG] = ACTIONS(607),
    [anon_sym_DOLLAR] = ACTIONS(609),
    [anon_sym_LT_LPAREN] = ACTIONS(2246),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(2248),
    [sym_test_operator] = ACTIONS(2250),
    [anon_sym_BQUOTE] = ACTIONS(2252),
    [anon_sym_GT_LPAREN] = ACTIONS(2246),
    [sym_ansii_c_string] = ACTIONS(2244),
    [sym__special_character] = ACTIONS(2254),
    [sym_regex] = ACTIONS(2333),
  },
  [586] = {
    [sym_word] = ACTIONS(922),
    [anon_sym_AMP_GT_GT] = ACTIONS(922),
    [anon_sym_DOLLAR] = ACTIONS(920),
    [anon_sym_LT_LPAREN] = ACTIONS(922),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(922),
    [anon_sym_LT] = ACTIONS(920),
    [anon_sym_LT_AMP] = ACTIONS(922),
    [anon_sym_GT_GT] = ACTIONS(922),
    [sym__special_character] = ACTIONS(922),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(922),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(922),
    [sym_raw_string] = ACTIONS(922),
    [sym_variable_name] = ACTIONS(922),
    [sym_file_descriptor] = ACTIONS(922),
    [anon_sym_RPAREN] = ACTIONS(922),
    [anon_sym_GT] = ACTIONS(920),
    [anon_sym_AMP_GT] = ACTIONS(920),
    [anon_sym_DQUOTE] = ACTIONS(922),
    [anon_sym_GT_AMP] = ACTIONS(922),
    [anon_sym_BQUOTE] = ACTIONS(922),
    [anon_sym_GT_LPAREN] = ACTIONS(922),
    [sym_ansii_c_string] = ACTIONS(922),
  },
  [587] = {
    [sym_word] = ACTIONS(972),
    [anon_sym_AMP_GT_GT] = ACTIONS(972),
    [anon_sym_DOLLAR] = ACTIONS(970),
    [anon_sym_LT_LPAREN] = ACTIONS(972),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(972),
    [anon_sym_LT] = ACTIONS(970),
    [anon_sym_LT_AMP] = ACTIONS(972),
    [anon_sym_GT_GT] = ACTIONS(972),
    [sym__special_character] = ACTIONS(972),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(972),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(972),
    [sym_raw_string] = ACTIONS(972),
    [sym_variable_name] = ACTIONS(972),
    [sym_file_descriptor] = ACTIONS(972),
    [anon_sym_RPAREN] = ACTIONS(972),
    [anon_sym_GT] = ACTIONS(970),
    [anon_sym_AMP_GT] = ACTIONS(970),
    [anon_sym_DQUOTE] = ACTIONS(972),
    [anon_sym_GT_AMP] = ACTIONS(972),
    [anon_sym_BQUOTE] = ACTIONS(972),
    [anon_sym_GT_LPAREN] = ACTIONS(972),
    [sym_ansii_c_string] = ACTIONS(972),
  },
  [588] = {
    [aux_sym_concatenation_repeat1] = STATE(638),
    [sym_word] = ACTIONS(982),
    [anon_sym_AMP_GT_GT] = ACTIONS(982),
    [anon_sym_DOLLAR] = ACTIONS(982),
    [anon_sym_LT_LT] = ACTIONS(982),
    [anon_sym_LT_LPAREN] = ACTIONS(982),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(982),
    [sym__concat] = ACTIONS(377),
    [anon_sym_PIPE] = ACTIONS(982),
    [anon_sym_LT] = ACTIONS(982),
    [anon_sym_LT_AMP] = ACTIONS(982),
    [anon_sym_GT_GT] = ACTIONS(982),
    [sym__special_character] = ACTIONS(982),
    [anon_sym_LT_LT_DASH] = ACTIONS(982),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(982),
    [aux_sym__simple_variable_name_token1] = ACTIONS(982),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(982),
    [anon_sym_LF] = ACTIONS(986),
    [anon_sym_SEMI] = ACTIONS(982),
    [sym_raw_string] = ACTIONS(982),
    [sym_variable_name] = ACTIONS(986),
    [sym_file_descriptor] = ACTIONS(986),
    [anon_sym_AMP] = ACTIONS(982),
    [anon_sym_GT] = ACTIONS(982),
    [anon_sym_AMP_GT] = ACTIONS(982),
    [anon_sym_DQUOTE] = ACTIONS(982),
    [anon_sym_LT_LT_LT] = ACTIONS(982),
    [anon_sym_GT_AMP] = ACTIONS(982),
    [ts_builtin_sym_end] = ACTIONS(986),
    [anon_sym_BQUOTE] = ACTIONS(982),
    [anon_sym_GT_LPAREN] = ACTIONS(982),
    [sym_ansii_c_string] = ACTIONS(982),
    [anon_sym_AMP_AMP] = ACTIONS(982),
    [anon_sym_SEMI_SEMI] = ACTIONS(982),
    [anon_sym_PIPE_AMP] = ACTIONS(982),
  },
  [589] = {
    [sym_word] = ACTIONS(982),
    [anon_sym_AMP_GT_GT] = ACTIONS(982),
    [anon_sym_DOLLAR] = ACTIONS(982),
    [anon_sym_LT_LT] = ACTIONS(982),
    [anon_sym_LT_LPAREN] = ACTIONS(982),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(982),
    [anon_sym_PIPE] = ACTIONS(982),
    [anon_sym_LT] = ACTIONS(982),
    [anon_sym_LT_AMP] = ACTIONS(982),
    [anon_sym_GT_GT] = ACTIONS(982),
    [sym__special_character] = ACTIONS(982),
    [anon_sym_LT_LT_DASH] = ACTIONS(982),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(982),
    [aux_sym__simple_variable_name_token1] = ACTIONS(982),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(982),
    [anon_sym_LF] = ACTIONS(986),
    [anon_sym_SEMI] = ACTIONS(982),
    [sym_raw_string] = ACTIONS(982),
    [sym_variable_name] = ACTIONS(986),
    [sym_file_descriptor] = ACTIONS(986),
    [anon_sym_AMP] = ACTIONS(982),
    [anon_sym_GT] = ACTIONS(982),
    [anon_sym_AMP_GT] = ACTIONS(982),
    [anon_sym_DQUOTE] = ACTIONS(982),
    [anon_sym_LT_LT_LT] = ACTIONS(982),
    [anon_sym_GT_AMP] = ACTIONS(982),
    [ts_builtin_sym_end] = ACTIONS(986),
    [anon_sym_BQUOTE] = ACTIONS(982),
    [anon_sym_GT_LPAREN] = ACTIONS(982),
    [sym_ansii_c_string] = ACTIONS(982),
    [anon_sym_AMP_AMP] = ACTIONS(982),
    [anon_sym_SEMI_SEMI] = ACTIONS(982),
    [anon_sym_PIPE_AMP] = ACTIONS(982),
  },
  [590] = {
    [aux_sym__literal_repeat1] = STATE(646),
    [sym_word] = ACTIONS(1006),
    [anon_sym_AMP_GT_GT] = ACTIONS(1006),
    [anon_sym_DOLLAR] = ACTIONS(1006),
    [anon_sym_LT_LT] = ACTIONS(1006),
    [anon_sym_LT_LPAREN] = ACTIONS(1006),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1006),
    [anon_sym_PIPE] = ACTIONS(1006),
    [anon_sym_LT] = ACTIONS(1006),
    [anon_sym_LT_AMP] = ACTIONS(1006),
    [anon_sym_GT_GT] = ACTIONS(1006),
    [sym__special_character] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(1006),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1006),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1006),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1006),
    [anon_sym_LF] = ACTIONS(1010),
    [anon_sym_SEMI] = ACTIONS(1006),
    [sym_raw_string] = ACTIONS(1006),
    [sym_variable_name] = ACTIONS(1010),
    [sym_file_descriptor] = ACTIONS(1010),
    [anon_sym_AMP] = ACTIONS(1006),
    [anon_sym_GT] = ACTIONS(1006),
    [anon_sym_AMP_GT] = ACTIONS(1006),
    [anon_sym_DQUOTE] = ACTIONS(1006),
    [anon_sym_LT_LT_LT] = ACTIONS(1006),
    [anon_sym_GT_AMP] = ACTIONS(1006),
    [ts_builtin_sym_end] = ACTIONS(1010),
    [anon_sym_BQUOTE] = ACTIONS(1006),
    [anon_sym_GT_LPAREN] = ACTIONS(1006),
    [sym_ansii_c_string] = ACTIONS(1006),
    [anon_sym_AMP_AMP] = ACTIONS(1006),
    [anon_sym_SEMI_SEMI] = ACTIONS(1006),
    [anon_sym_PIPE_AMP] = ACTIONS(1006),
  },
  [591] = {
    [aux_sym_concatenation_repeat1] = STATE(1065),
    [anon_sym_AMP_GT_GT] = ACTIONS(1026),
    [anon_sym_LT_LT] = ACTIONS(1026),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1026),
    [sym__concat] = ACTIONS(2089),
    [anon_sym_PIPE] = ACTIONS(1026),
    [anon_sym_LT] = ACTIONS(1026),
    [anon_sym_LT_AMP] = ACTIONS(1026),
    [anon_sym_GT_GT] = ACTIONS(1026),
    [anon_sym_LT_LT_DASH] = ACTIONS(1026),
    [anon_sym_LF] = ACTIONS(1024),
    [anon_sym_SEMI] = ACTIONS(1026),
    [anon_sym_RPAREN] = ACTIONS(1026),
    [anon_sym_AMP] = ACTIONS(1026),
    [anon_sym_GT] = ACTIONS(1026),
    [sym_file_descriptor] = ACTIONS(1024),
    [anon_sym_AMP_GT] = ACTIONS(1026),
    [anon_sym_LT_LT_LT] = ACTIONS(1026),
    [anon_sym_GT_AMP] = ACTIONS(1026),
    [anon_sym_BQUOTE] = ACTIONS(1026),
    [anon_sym_AMP_AMP] = ACTIONS(1026),
    [anon_sym_SEMI_SEMI] = ACTIONS(1026),
    [anon_sym_PIPE_AMP] = ACTIONS(1026),
  },
  [592] = {
    [aux_sym__literal_repeat1] = STATE(1103),
    [anon_sym_AMP_GT_GT] = ACTIONS(1030),
    [anon_sym_LT_LT] = ACTIONS(1030),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1030),
    [anon_sym_PIPE] = ACTIONS(1030),
    [anon_sym_LT] = ACTIONS(1030),
    [anon_sym_LT_AMP] = ACTIONS(1030),
    [anon_sym_GT_GT] = ACTIONS(1030),
    [sym__special_character] = ACTIONS(2091),
    [anon_sym_LT_LT_DASH] = ACTIONS(1030),
    [anon_sym_LF] = ACTIONS(1028),
    [anon_sym_SEMI] = ACTIONS(1030),
    [anon_sym_RPAREN] = ACTIONS(1030),
    [anon_sym_AMP] = ACTIONS(1030),
    [anon_sym_GT] = ACTIONS(1030),
    [sym_file_descriptor] = ACTIONS(1028),
    [anon_sym_AMP_GT] = ACTIONS(1030),
    [anon_sym_LT_LT_LT] = ACTIONS(1030),
    [anon_sym_GT_AMP] = ACTIONS(1030),
    [anon_sym_BQUOTE] = ACTIONS(1030),
    [anon_sym_esac] = ACTIONS(1030),
    [anon_sym_AMP_AMP] = ACTIONS(1030),
    [anon_sym_SEMI_SEMI] = ACTIONS(1030),
    [anon_sym_PIPE_AMP] = ACTIONS(1030),
  },
  [593] = {
    [anon_sym_AMP_GT_GT] = ACTIONS(1026),
    [anon_sym_LT_LT] = ACTIONS(1026),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1026),
    [anon_sym_PIPE] = ACTIONS(1026),
    [anon_sym_LT] = ACTIONS(1026),
    [anon_sym_LT_AMP] = ACTIONS(1026),
    [anon_sym_GT_GT] = ACTIONS(1026),
    [anon_sym_LT_LT_DASH] = ACTIONS(1026),
    [anon_sym_LF] = ACTIONS(1024),
    [anon_sym_SEMI] = ACTIONS(1026),
    [anon_sym_RPAREN] = ACTIONS(1026),
    [anon_sym_AMP] = ACTIONS(1026),
    [anon_sym_GT] = ACTIONS(1026),
    [sym_file_descriptor] = ACTIONS(1024),
    [anon_sym_AMP_GT] = ACTIONS(1026),
    [anon_sym_LT_LT_LT] = ACTIONS(1026),
    [anon_sym_GT_AMP] = ACTIONS(1026),
    [anon_sym_BQUOTE] = ACTIONS(1026),
    [anon_sym_esac] = ACTIONS(1026),
    [anon_sym_AMP_AMP] = ACTIONS(1026),
    [anon_sym_SEMI_SEMI] = ACTIONS(1026),
    [anon_sym_PIPE_AMP] = ACTIONS(1026),
  },
  [594] = {
    [sym_word] = ACTIONS(1034),
    [anon_sym_AMP_GT_GT] = ACTIONS(1034),
    [anon_sym_DOLLAR] = ACTIONS(1032),
    [anon_sym_LT_LPAREN] = ACTIONS(1034),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1034),
    [anon_sym_LT] = ACTIONS(1032),
    [anon_sym_LT_AMP] = ACTIONS(1034),
    [anon_sym_GT_GT] = ACTIONS(1034),
    [sym__special_character] = ACTIONS(1034),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1034),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1034),
    [sym_raw_string] = ACTIONS(1034),
    [sym_variable_name] = ACTIONS(1034),
    [sym_file_descriptor] = ACTIONS(1034),
    [anon_sym_RPAREN] = ACTIONS(1034),
    [anon_sym_GT] = ACTIONS(1032),
    [anon_sym_AMP_GT] = ACTIONS(1032),
    [anon_sym_DQUOTE] = ACTIONS(1034),
    [anon_sym_GT_AMP] = ACTIONS(1034),
    [anon_sym_BQUOTE] = ACTIONS(1034),
    [anon_sym_GT_LPAREN] = ACTIONS(1034),
    [sym_ansii_c_string] = ACTIONS(1034),
  },
  [595] = {
    [sym_word] = ACTIONS(1038),
    [anon_sym_AMP_GT_GT] = ACTIONS(1038),
    [anon_sym_DOLLAR] = ACTIONS(1036),
    [anon_sym_LT_LPAREN] = ACTIONS(1038),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1038),
    [anon_sym_LT] = ACTIONS(1036),
    [anon_sym_LT_AMP] = ACTIONS(1038),
    [anon_sym_GT_GT] = ACTIONS(1038),
    [sym__special_character] = ACTIONS(1038),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1038),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1038),
    [sym_raw_string] = ACTIONS(1038),
    [sym_variable_name] = ACTIONS(1038),
    [sym_file_descriptor] = ACTIONS(1038),
    [anon_sym_RPAREN] = ACTIONS(1038),
    [anon_sym_GT] = ACTIONS(1036),
    [anon_sym_AMP_GT] = ACTIONS(1036),
    [anon_sym_DQUOTE] = ACTIONS(1038),
    [anon_sym_GT_AMP] = ACTIONS(1038),
    [anon_sym_BQUOTE] = ACTIONS(1038),
    [anon_sym_GT_LPAREN] = ACTIONS(1038),
    [sym_ansii_c_string] = ACTIONS(1038),
  },
  [596] = {
    [sym_word] = ACTIONS(1034),
    [anon_sym_AMP_GT_GT] = ACTIONS(1034),
    [anon_sym_DOLLAR] = ACTIONS(1032),
    [anon_sym_LT_LPAREN] = ACTIONS(1034),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1034),
    [anon_sym_LT] = ACTIONS(1032),
    [anon_sym_LT_AMP] = ACTIONS(1034),
    [anon_sym_GT_GT] = ACTIONS(1034),
    [sym__special_character] = ACTIONS(1034),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1034),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1034),
    [sym_raw_string] = ACTIONS(1034),
    [sym_variable_name] = ACTIONS(1034),
    [sym_file_descriptor] = ACTIONS(1034),
    [anon_sym_RPAREN] = ACTIONS(1034),
    [anon_sym_GT] = ACTIONS(1032),
    [anon_sym_AMP_GT] = ACTIONS(1032),
    [anon_sym_DQUOTE] = ACTIONS(1034),
    [anon_sym_GT_AMP] = ACTIONS(1034),
    [anon_sym_BQUOTE] = ACTIONS(1034),
    [anon_sym_GT_LPAREN] = ACTIONS(1034),
    [sym_ansii_c_string] = ACTIONS(1034),
  },
  [597] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(1093),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(1093),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1093),
    [anon_sym_PIPE] = ACTIONS(1093),
    [anon_sym_LT] = ACTIONS(1093),
    [anon_sym_LT_AMP] = ACTIONS(1093),
    [anon_sym_GT_GT] = ACTIONS(1093),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(1093),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(1095),
    [anon_sym_SEMI] = ACTIONS(1093),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(1095),
    [anon_sym_AMP] = ACTIONS(1093),
    [anon_sym_GT] = ACTIONS(1093),
    [anon_sym_AMP_GT] = ACTIONS(1093),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(1093),
    [anon_sym_GT_AMP] = ACTIONS(1093),
    [anon_sym_BQUOTE] = ACTIONS(1093),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(1093),
    [anon_sym_SEMI_SEMI] = ACTIONS(1093),
    [anon_sym_PIPE_AMP] = ACTIONS(1093),
  },
  [598] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(2335),
    [anon_sym_LF] = ACTIONS(2337),
    [anon_sym_SEMI] = ACTIONS(2335),
    [anon_sym_SEMI_SEMI] = ACTIONS(2083),
    [anon_sym_esac] = ACTIONS(2083),
  },
  [599] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [anon_sym_LT_LT_DASH] = ACTIONS(1123),
    [anon_sym_AMP_GT_GT] = ACTIONS(1123),
    [anon_sym_LF] = ACTIONS(1125),
    [anon_sym_SEMI] = ACTIONS(1123),
    [anon_sym_LT_LT] = ACTIONS(1123),
    [anon_sym_AMP] = ACTIONS(1123),
    [anon_sym_GT] = ACTIONS(1123),
    [sym_file_descriptor] = ACTIONS(1125),
    [anon_sym_AMP_GT] = ACTIONS(1123),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1123),
    [anon_sym_LT_LT_LT] = ACTIONS(1123),
    [anon_sym_PIPE] = ACTIONS(2218),
    [anon_sym_GT_AMP] = ACTIONS(1123),
    [anon_sym_LT] = ACTIONS(1123),
    [anon_sym_LT_AMP] = ACTIONS(1123),
    [anon_sym_GT_GT] = ACTIONS(1123),
    [anon_sym_BQUOTE] = ACTIONS(1123),
    [anon_sym_AMP_AMP] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(1123),
    [anon_sym_PIPE_AMP] = ACTIONS(2218),
  },
  [600] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(1123),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1123),
    [anon_sym_PIPE] = ACTIONS(2218),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(1123),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(1125),
    [anon_sym_SEMI] = ACTIONS(1123),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(1123),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(1123),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(1123),
    [anon_sym_PIPE_AMP] = ACTIONS(2218),
  },
  [601] = {
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(1113),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [602] = {
    [sym_heredoc_body] = STATE(1468),
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__simple_heredoc_body] = ACTIONS(870),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [sym__heredoc_body_beginning] = ACTIONS(872),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(1113),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
  },
  [603] = {
    [sym_command_substitution] = STATE(423),
    [aux_sym__literal_repeat1] = STATE(425),
    [sym_string] = STATE(423),
    [sym_process_substitution] = STATE(423),
    [sym_simple_expansion] = STATE(423),
    [sym_string_expansion] = STATE(423),
    [aux_sym_command_repeat2] = STATE(472),
    [sym_concatenation] = STATE(472),
    [sym_expansion] = STATE(423),
    [sym_word] = ACTIONS(1968),
    [anon_sym_AMP_GT_GT] = ACTIONS(1155),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [anon_sym_LT_LT] = ACTIONS(1155),
    [anon_sym_LT_LPAREN] = ACTIONS(1970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1155),
    [anon_sym_PIPE] = ACTIONS(1155),
    [anon_sym_LT] = ACTIONS(1155),
    [anon_sym_LT_AMP] = ACTIONS(1155),
    [anon_sym_GT_GT] = ACTIONS(1155),
    [anon_sym_EQ_TILDE] = ACTIONS(1972),
    [sym__special_character] = ACTIONS(85),
    [anon_sym_LT_LT_DASH] = ACTIONS(1155),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1974),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1976),
    [anon_sym_LF] = ACTIONS(1157),
    [anon_sym_SEMI] = ACTIONS(1155),
    [sym_raw_string] = ACTIONS(1968),
    [sym_file_descriptor] = ACTIONS(1157),
    [anon_sym_AMP] = ACTIONS(1155),
    [anon_sym_GT] = ACTIONS(1155),
    [anon_sym_AMP_GT] = ACTIONS(1155),
    [anon_sym_EQ_EQ] = ACTIONS(1972),
    [anon_sym_DQUOTE] = ACTIONS(1978),
    [anon_sym_LT_LT_LT] = ACTIONS(1155),
    [anon_sym_GT_AMP] = ACTIONS(1155),
    [anon_sym_BQUOTE] = ACTIONS(1155),
    [anon_sym_GT_LPAREN] = ACTIONS(1970),
    [sym_ansii_c_string] = ACTIONS(1968),
    [anon_sym_AMP_AMP] = ACTIONS(1155),
    [anon_sym_SEMI_SEMI] = ACTIONS(1155),
    [anon_sym_PIPE_AMP] = ACTIONS(1155),
  },
  [604] = {
    [aux_sym_concatenation_repeat1] = STATE(1193),
    [sym_word] = ACTIONS(1159),
    [anon_sym_AMP_GT_GT] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(1159),
    [anon_sym_LT_LT] = ACTIONS(1159),
    [anon_sym_LT_LPAREN] = ACTIONS(1159),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1159),
    [sym__concat] = ACTIONS(2194),
    [anon_sym_PIPE] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1159),
    [anon_sym_LT_AMP] = ACTIONS(1159),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_EQ_TILDE] = ACTIONS(1159),
    [sym__special_character] = ACTIONS(1159),
    [anon_sym_LT_LT_DASH] = ACTIONS(1159),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1159),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1159),
    [anon_sym_LF] = ACTIONS(1161),
    [anon_sym_SEMI] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(1159),
    [sym_file_descriptor] = ACTIONS(1161),
    [anon_sym_AMP] = ACTIONS(1159),
    [anon_sym_GT] = ACTIONS(1159),
    [anon_sym_AMP_GT] = ACTIONS(1159),
    [anon_sym_EQ_EQ] = ACTIONS(1159),
    [anon_sym_DQUOTE] = ACTIONS(1159),
    [anon_sym_LT_LT_LT] = ACTIONS(1159),
    [anon_sym_GT_AMP] = ACTIONS(1159),
    [anon_sym_BQUOTE] = ACTIONS(1159),
    [anon_sym_esac] = ACTIONS(1159),
    [anon_sym_GT_LPAREN] = ACTIONS(1159),
    [sym_ansii_c_string] = ACTIONS(1159),
    [anon_sym_AMP_AMP] = ACTIONS(1159),
    [anon_sym_SEMI_SEMI] = ACTIONS(1159),
    [anon_sym_PIPE_AMP] = ACTIONS(1159),
  },
  [605] = {
    [sym_word] = ACTIONS(1159),
    [anon_sym_AMP_GT_GT] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(1159),
    [anon_sym_LT_LT] = ACTIONS(1159),
    [anon_sym_LT_LPAREN] = ACTIONS(1159),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1159),
    [anon_sym_PIPE] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1159),
    [anon_sym_LT_AMP] = ACTIONS(1159),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_EQ_TILDE] = ACTIONS(1159),
    [sym__special_character] = ACTIONS(1159),
    [anon_sym_LT_LT_DASH] = ACTIONS(1159),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1159),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1159),
    [anon_sym_LF] = ACTIONS(1161),
    [anon_sym_SEMI] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(1159),
    [sym_file_descriptor] = ACTIONS(1161),
    [anon_sym_AMP] = ACTIONS(1159),
    [anon_sym_GT] = ACTIONS(1159),
    [anon_sym_AMP_GT] = ACTIONS(1159),
    [anon_sym_EQ_EQ] = ACTIONS(1159),
    [anon_sym_DQUOTE] = ACTIONS(1159),
    [anon_sym_LT_LT_LT] = ACTIONS(1159),
    [anon_sym_GT_AMP] = ACTIONS(1159),
    [anon_sym_BQUOTE] = ACTIONS(1159),
    [anon_sym_esac] = ACTIONS(1159),
    [anon_sym_GT_LPAREN] = ACTIONS(1159),
    [sym_ansii_c_string] = ACTIONS(1159),
    [anon_sym_AMP_AMP] = ACTIONS(1159),
    [anon_sym_SEMI_SEMI] = ACTIONS(1159),
    [anon_sym_PIPE_AMP] = ACTIONS(1159),
  },
  [606] = {
    [aux_sym__literal_repeat1] = STATE(1231),
    [sym_word] = ACTIONS(1163),
    [anon_sym_AMP_GT_GT] = ACTIONS(1163),
    [anon_sym_DOLLAR] = ACTIONS(1163),
    [anon_sym_LT_LT] = ACTIONS(1163),
    [anon_sym_LT_LPAREN] = ACTIONS(1163),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1163),
    [anon_sym_PIPE] = ACTIONS(1163),
    [anon_sym_LT] = ACTIONS(1163),
    [anon_sym_LT_AMP] = ACTIONS(1163),
    [anon_sym_GT_GT] = ACTIONS(1163),
    [anon_sym_EQ_TILDE] = ACTIONS(1163),
    [sym__special_character] = ACTIONS(2200),
    [anon_sym_LT_LT_DASH] = ACTIONS(1163),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1163),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1163),
    [anon_sym_LF] = ACTIONS(1165),
    [anon_sym_SEMI] = ACTIONS(1163),
    [sym_raw_string] = ACTIONS(1163),
    [sym_file_descriptor] = ACTIONS(1165),
    [anon_sym_AMP] = ACTIONS(1163),
    [anon_sym_GT] = ACTIONS(1163),
    [anon_sym_AMP_GT] = ACTIONS(1163),
    [anon_sym_EQ_EQ] = ACTIONS(1163),
    [anon_sym_DQUOTE] = ACTIONS(1163),
    [anon_sym_LT_LT_LT] = ACTIONS(1163),
    [anon_sym_GT_AMP] = ACTIONS(1163),
    [anon_sym_BQUOTE] = ACTIONS(1163),
    [anon_sym_esac] = ACTIONS(1163),
    [anon_sym_GT_LPAREN] = ACTIONS(1163),
    [sym_ansii_c_string] = ACTIONS(1163),
    [anon_sym_AMP_AMP] = ACTIONS(1163),
    [anon_sym_SEMI_SEMI] = ACTIONS(1163),
    [anon_sym_PIPE_AMP] = ACTIONS(1163),
  },
  [607] = {
    [sym_command_substitution] = STATE(572),
    [aux_sym__literal_repeat1] = STATE(574),
    [sym_string] = STATE(572),
    [sym_process_substitution] = STATE(572),
    [sym_simple_expansion] = STATE(572),
    [sym_string_expansion] = STATE(572),
    [aux_sym_command_repeat2] = STATE(607),
    [sym_concatenation] = STATE(607),
    [sym_expansion] = STATE(572),
    [sym_word] = ACTIONS(2339),
    [anon_sym_AMP_GT_GT] = ACTIONS(1159),
    [anon_sym_DOLLAR] = ACTIONS(2342),
    [anon_sym_LT_LT] = ACTIONS(1159),
    [anon_sym_LT_LPAREN] = ACTIONS(2345),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1159),
    [anon_sym_PIPE] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1159),
    [anon_sym_LT_AMP] = ACTIONS(1159),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_EQ_TILDE] = ACTIONS(2348),
    [sym__special_character] = ACTIONS(2351),
    [anon_sym_LT_LT_DASH] = ACTIONS(1159),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2354),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2357),
    [anon_sym_LF] = ACTIONS(1161),
    [anon_sym_SEMI] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(2339),
    [sym_file_descriptor] = ACTIONS(1161),
    [anon_sym_AMP] = ACTIONS(1159),
    [anon_sym_GT] = ACTIONS(1159),
    [anon_sym_AMP_GT] = ACTIONS(1159),
    [anon_sym_EQ_EQ] = ACTIONS(2348),
    [anon_sym_DQUOTE] = ACTIONS(2360),
    [anon_sym_LT_LT_LT] = ACTIONS(1159),
    [anon_sym_GT_AMP] = ACTIONS(1159),
    [anon_sym_BQUOTE] = ACTIONS(2363),
    [anon_sym_esac] = ACTIONS(1159),
    [anon_sym_GT_LPAREN] = ACTIONS(2345),
    [sym_ansii_c_string] = ACTIONS(2339),
    [anon_sym_AMP_AMP] = ACTIONS(1159),
    [anon_sym_SEMI_SEMI] = ACTIONS(1159),
    [anon_sym_PIPE_AMP] = ACTIONS(1159),
  },
  [608] = {
    [sym_string] = STATE(558),
    [sym_word] = ACTIONS(1198),
    [anon_sym_AMP_GT_GT] = ACTIONS(1202),
    [anon_sym_DOLLAR] = ACTIONS(2366),
    [anon_sym_DASH] = ACTIONS(2366),
    [anon_sym_LT_LPAREN] = ACTIONS(1202),
    [sym_comment] = ACTIONS(3),
    [anon_sym_POUND] = ACTIONS(2368),
    [anon_sym__] = ACTIONS(2370),
    [anon_sym_AT] = ACTIONS(2370),
    [anon_sym_LT] = ACTIONS(1198),
    [anon_sym_LT_AMP] = ACTIONS(1202),
    [anon_sym_GT_GT] = ACTIONS(1202),
    [sym__special_character] = ACTIONS(1202),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1202),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2370),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1202),
    [sym_raw_string] = ACTIONS(2372),
    [anon_sym_BANG] = ACTIONS(2366),
    [sym_variable_name] = ACTIONS(1202),
    [sym_file_descriptor] = ACTIONS(1202),
    [anon_sym_QMARK] = ACTIONS(2370),
    [anon_sym_GT] = ACTIONS(1198),
    [anon_sym_RPAREN] = ACTIONS(1202),
    [anon_sym_AMP_GT] = ACTIONS(1198),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_GT_AMP] = ACTIONS(1202),
    [anon_sym_BQUOTE] = ACTIONS(1202),
    [anon_sym_STAR] = ACTIONS(2370),
    [anon_sym_GT_LPAREN] = ACTIONS(1202),
    [sym_ansii_c_string] = ACTIONS(1202),
    [anon_sym_0] = ACTIONS(2370),
  },
  [609] = {
    [anon_sym_BANG_EQ] = ACTIONS(1246),
    [anon_sym_PLUS_EQ] = ACTIONS(1246),
    [anon_sym_LF] = ACTIONS(1246),
    [anon_sym_SEMI] = ACTIONS(1246),
    [anon_sym_PLUS_PLUS] = ACTIONS(1246),
    [anon_sym_DASH] = ACTIONS(1246),
    [anon_sym_GT] = ACTIONS(1246),
    [anon_sym_EQ] = ACTIONS(1246),
    [anon_sym_AMP] = ACTIONS(1246),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(1246),
    [anon_sym_PIPE_PIPE] = ACTIONS(1246),
    [anon_sym_GT_EQ] = ACTIONS(1246),
    [anon_sym_PLUS] = ACTIONS(1246),
    [anon_sym_LT] = ACTIONS(1246),
    [sym_test_operator] = ACTIONS(1246),
    [anon_sym_EQ_TILDE] = ACTIONS(1246),
    [anon_sym_DASH_DASH] = ACTIONS(1246),
    [anon_sym_AMP_AMP] = ACTIONS(1246),
    [anon_sym_LT_EQ] = ACTIONS(1246),
    [anon_sym_SEMI_SEMI] = ACTIONS(1246),
    [anon_sym_DASH_EQ] = ACTIONS(1246),
  },
  [610] = {
    [anon_sym_BANG_EQ] = ACTIONS(1250),
    [anon_sym_PLUS_EQ] = ACTIONS(1250),
    [anon_sym_LF] = ACTIONS(1250),
    [anon_sym_SEMI] = ACTIONS(1250),
    [anon_sym_PLUS_PLUS] = ACTIONS(1250),
    [anon_sym_DASH] = ACTIONS(1250),
    [anon_sym_GT] = ACTIONS(1250),
    [anon_sym_EQ] = ACTIONS(1250),
    [anon_sym_AMP] = ACTIONS(1250),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(1250),
    [anon_sym_PIPE_PIPE] = ACTIONS(1250),
    [anon_sym_GT_EQ] = ACTIONS(1250),
    [anon_sym_PLUS] = ACTIONS(1250),
    [anon_sym_LT] = ACTIONS(1250),
    [sym_test_operator] = ACTIONS(1250),
    [anon_sym_EQ_TILDE] = ACTIONS(1250),
    [anon_sym_DASH_DASH] = ACTIONS(1250),
    [anon_sym_AMP_AMP] = ACTIONS(1250),
    [anon_sym_LT_EQ] = ACTIONS(1250),
    [anon_sym_SEMI_SEMI] = ACTIONS(1250),
    [anon_sym_DASH_EQ] = ACTIONS(1250),
  },
  [611] = {
    [anon_sym_BANG_EQ] = ACTIONS(1250),
    [anon_sym_PLUS_EQ] = ACTIONS(1250),
    [anon_sym_LF] = ACTIONS(1250),
    [anon_sym_SEMI] = ACTIONS(1250),
    [anon_sym_PLUS_PLUS] = ACTIONS(1250),
    [anon_sym_DASH] = ACTIONS(1250),
    [anon_sym_GT] = ACTIONS(1250),
    [anon_sym_EQ] = ACTIONS(1250),
    [anon_sym_AMP] = ACTIONS(1250),
    [sym_comment] = ACTIONS(3),
    [anon_sym_EQ_EQ] = ACTIONS(1250),
    [anon_sym_PIPE_PIPE] = ACTIONS(1250),
    [anon_sym_GT_EQ] = ACTIONS(1250),
    [anon_sym_PLUS] = ACTIONS(1250),
    [anon_sym_LT] = ACTIONS(1250),
    [sym_test_operator] = ACTIONS(1250),
    [anon_sym_EQ_TILDE] = ACTIONS(1250),
    [anon_sym_DASH_DASH] = ACTIONS(1250),
    [anon_sym_AMP_AMP] = ACTIONS(1250),
    [anon_sym_LT_EQ] = ACTIONS(1250),
    [anon_sym_SEMI_SEMI] = ACTIONS(1250),
    [anon_sym_DASH_EQ] = ACTIONS(1250),
  },
  [612] = {
    [sym_word] = ACTIONS(1254),
    [anon_sym_AMP_GT_GT] = ACTIONS(1254),
    [anon_sym_DOLLAR] = ACTIONS(1252),
    [anon_sym_LT_LPAREN] = ACTIONS(1254),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1254),
    [anon_sym_LT] = ACTIONS(1252),
    [anon_sym_LT_AMP] = ACTIONS(1254),
    [anon_sym_GT_GT] = ACTIONS(1254),
    [sym__special_character] = ACTIONS(1254),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1254),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1254),
    [sym_raw_string] = ACTIONS(1254),
    [sym_variable_name] = ACTIONS(1254),
    [sym_file_descriptor] = ACTIONS(1254),
    [anon_sym_RPAREN] = ACTIONS(1254),
    [anon_sym_GT] = ACTIONS(1252),
    [anon_sym_AMP_GT] = ACTIONS(1252),
    [anon_sym_DQUOTE] = ACTIONS(1254),
    [anon_sym_GT_AMP] = ACTIONS(1254),
    [anon_sym_BQUOTE] = ACTIONS(1254),
    [anon_sym_GT_LPAREN] = ACTIONS(1254),
    [sym_ansii_c_string] = ACTIONS(1254),
  },
  [613] = {
    [sym_word] = ACTIONS(1303),
    [anon_sym_AMP_GT_GT] = ACTIONS(1303),
    [anon_sym_DOLLAR] = ACTIONS(1301),
    [anon_sym_LT_LPAREN] = ACTIONS(1303),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1303),
    [anon_sym_LT] = ACTIONS(1301),
    [anon_sym_LT_AMP] = ACTIONS(1303),
    [anon_sym_GT_GT] = ACTIONS(1303),
    [sym__special_character] = ACTIONS(1303),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1303),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1303),
    [sym_raw_string] = ACTIONS(1303),
    [sym_variable_name] = ACTIONS(1303),
    [sym_file_descriptor] = ACTIONS(1303),
    [anon_sym_RPAREN] = ACTIONS(1303),
    [anon_sym_GT] = ACTIONS(1301),
    [anon_sym_AMP_GT] = ACTIONS(1301),
    [anon_sym_DQUOTE] = ACTIONS(1303),
    [anon_sym_GT_AMP] = ACTIONS(1303),
    [anon_sym_BQUOTE] = ACTIONS(1303),
    [anon_sym_GT_LPAREN] = ACTIONS(1303),
    [sym_ansii_c_string] = ACTIONS(1303),
  },
  [614] = {
    [sym_word] = ACTIONS(1321),
    [anon_sym_AMP_GT_GT] = ACTIONS(1321),
    [anon_sym_DOLLAR] = ACTIONS(1319),
    [anon_sym_LT_LPAREN] = ACTIONS(1321),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1321),
    [anon_sym_LT] = ACTIONS(1319),
    [anon_sym_LT_AMP] = ACTIONS(1321),
    [anon_sym_GT_GT] = ACTIONS(1321),
    [sym__special_character] = ACTIONS(1321),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1321),
    [sym_raw_string] = ACTIONS(1321),
    [sym_variable_name] = ACTIONS(1321),
    [sym_file_descriptor] = ACTIONS(1321),
    [anon_sym_RPAREN] = ACTIONS(1321),
    [anon_sym_GT] = ACTIONS(1319),
    [anon_sym_AMP_GT] = ACTIONS(1319),
    [anon_sym_DQUOTE] = ACTIONS(1321),
    [anon_sym_GT_AMP] = ACTIONS(1321),
    [anon_sym_BQUOTE] = ACTIONS(1321),
    [anon_sym_GT_LPAREN] = ACTIONS(1321),
    [sym_ansii_c_string] = ACTIONS(1321),
  },
  [615] = {
    [sym_word] = ACTIONS(1335),
    [anon_sym_AMP_GT_GT] = ACTIONS(1335),
    [anon_sym_DOLLAR] = ACTIONS(1335),
    [anon_sym_LT_LT] = ACTIONS(1335),
    [anon_sym_LT_LPAREN] = ACTIONS(1335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1335),
    [anon_sym_PIPE] = ACTIONS(1335),
    [anon_sym_LT] = ACTIONS(1335),
    [anon_sym_LT_AMP] = ACTIONS(1335),
    [anon_sym_GT_GT] = ACTIONS(1335),
    [sym__special_character] = ACTIONS(1335),
    [anon_sym_LT_LT_DASH] = ACTIONS(1335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1335),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1335),
    [anon_sym_LF] = ACTIONS(1337),
    [anon_sym_SEMI] = ACTIONS(1335),
    [sym_raw_string] = ACTIONS(1335),
    [sym_variable_name] = ACTIONS(1337),
    [sym_file_descriptor] = ACTIONS(1337),
    [anon_sym_AMP] = ACTIONS(1335),
    [anon_sym_GT] = ACTIONS(1335),
    [anon_sym_AMP_GT] = ACTIONS(1335),
    [anon_sym_DQUOTE] = ACTIONS(1335),
    [anon_sym_LT_LT_LT] = ACTIONS(1335),
    [anon_sym_GT_AMP] = ACTIONS(1335),
    [ts_builtin_sym_end] = ACTIONS(1337),
    [anon_sym_BQUOTE] = ACTIONS(1335),
    [anon_sym_GT_LPAREN] = ACTIONS(1335),
    [sym_ansii_c_string] = ACTIONS(1335),
    [anon_sym_AMP_AMP] = ACTIONS(1335),
    [anon_sym_SEMI_SEMI] = ACTIONS(1335),
    [anon_sym_PIPE_AMP] = ACTIONS(1335),
  },
  [616] = {
    [sym_word] = ACTIONS(1367),
    [anon_sym_AMP_GT_GT] = ACTIONS(1367),
    [anon_sym_DOLLAR] = ACTIONS(1365),
    [anon_sym_LT_LPAREN] = ACTIONS(1367),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1367),
    [anon_sym_LT] = ACTIONS(1365),
    [anon_sym_LT_AMP] = ACTIONS(1367),
    [anon_sym_GT_GT] = ACTIONS(1367),
    [sym__special_character] = ACTIONS(1367),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1367),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1367),
    [sym_raw_string] = ACTIONS(1367),
    [sym_variable_name] = ACTIONS(1367),
    [sym_file_descriptor] = ACTIONS(1367),
    [anon_sym_RPAREN] = ACTIONS(1367),
    [anon_sym_GT] = ACTIONS(1365),
    [anon_sym_AMP_GT] = ACTIONS(1365),
    [anon_sym_DQUOTE] = ACTIONS(1367),
    [anon_sym_GT_AMP] = ACTIONS(1367),
    [anon_sym_BQUOTE] = ACTIONS(1367),
    [anon_sym_GT_LPAREN] = ACTIONS(1367),
    [sym_ansii_c_string] = ACTIONS(1367),
  },
  [617] = {
    [anon_sym_LPAREN] = ACTIONS(1415),
    [sym_word] = ACTIONS(1415),
    [anon_sym_AMP_GT_GT] = ACTIONS(1417),
    [anon_sym_local] = ACTIONS(1415),
    [anon_sym_typeset] = ACTIONS(1415),
    [anon_sym_unsetenv] = ACTIONS(1415),
    [anon_sym_DOLLAR] = ACTIONS(1415),
    [anon_sym_LT_LPAREN] = ACTIONS(1417),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(1415),
    [anon_sym_LBRACE] = ACTIONS(1417),
    [anon_sym_LT] = ACTIONS(1415),
    [anon_sym_LT_AMP] = ACTIONS(1417),
    [anon_sym_GT_GT] = ACTIONS(1417),
    [anon_sym_export] = ACTIONS(1415),
    [sym__special_character] = ACTIONS(1415),
    [anon_sym_if] = ACTIONS(1415),
    [anon_sym_case] = ACTIONS(1415),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1417),
    [sym_raw_string] = ACTIONS(1417),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1417),
    [anon_sym_BANG] = ACTIONS(1415),
    [anon_sym_declare] = ACTIONS(1415),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1417),
    [sym_file_descriptor] = ACTIONS(1417),
    [sym_variable_name] = ACTIONS(1417),
    [anon_sym_GT] = ACTIONS(1415),
    [anon_sym_AMP_GT] = ACTIONS(1415),
    [anon_sym_readonly] = ACTIONS(1415),
    [anon_sym_unset] = ACTIONS(1415),
    [anon_sym_DQUOTE] = ACTIONS(1417),
    [anon_sym_GT_AMP] = ACTIONS(1417),
    [anon_sym_BQUOTE] = ACTIONS(1419),
    [anon_sym_GT_LPAREN] = ACTIONS(1417),
    [anon_sym_for] = ACTIONS(1415),
    [anon_sym_while] = ACTIONS(1415),
    [anon_sym_LBRACK] = ACTIONS(1415),
    [sym_ansii_c_string] = ACTIONS(1417),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1417),
  },
  [618] = {
    [sym_comment] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(2374),
    [anon_sym_LF] = ACTIONS(2376),
    [anon_sym_SEMI] = ACTIONS(2374),
    [anon_sym_SEMI_SEMI] = ACTIONS(2150),
    [anon_sym_esac] = ACTIONS(2150),
  },
  [619] = {
    [sym_word] = ACTIONS(1552),
    [anon_sym_AMP_GT_GT] = ACTIONS(1552),
    [anon_sym_DOLLAR] = ACTIONS(1550),
    [anon_sym_LT_LPAREN] = ACTIONS(1552),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1552),
    [anon_sym_LT] = ACTIONS(1550),
    [anon_sym_LT_AMP] = ACTIONS(1552),
    [anon_sym_GT_GT] = ACTIONS(1552),
    [sym__special_character] = ACTIONS(1552),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1552),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1552),
    [sym_raw_string] = ACTIONS(1552),
    [sym_variable_name] = ACTIONS(1552),
    [sym_file_descriptor] = ACTIONS(1552),
    [anon_sym_RPAREN] = ACTIONS(1552),
    [anon_sym_GT] = ACTIONS(1550),
    [anon_sym_AMP_GT] = ACTIONS(1550),
    [anon_sym_DQUOTE] = ACTIONS(1552),
    [anon_sym_GT_AMP] = ACTIONS(1552),
    [anon_sym_BQUOTE] = ACTIONS(1552),
    [anon_sym_GT_LPAREN] = ACTIONS(1552),
    [sym_ansii_c_string] = ACTIONS(1552),
  },
  [620] = {
    [sym_word] = ACTIONS(1564),
    [anon_sym_AMP_GT_GT] = ACTIONS(1564),
    [anon_sym_DOLLAR] = ACTIONS(1562),
    [anon_sym_LT_LPAREN] = ACTIONS(1564),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1564),
    [anon_sym_LT] = ACTIONS(1562),
    [anon_sym_LT_AMP] = ACTIONS(1564),
    [anon_sym_GT_GT] = ACTIONS(1564),
    [sym__special_character] = ACTIONS(1564),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1564),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1564),
    [sym_raw_string] = ACTIONS(1564),
    [sym_variable_name] = ACTIONS(1564),
    [sym_file_descriptor] = ACTIONS(1564),
    [anon_sym_RPAREN] = ACTIONS(1564),
    [anon_sym_GT] = ACTIONS(1562),
    [anon_sym_AMP_GT] = ACTIONS(1562),
    [anon_sym_DQUOTE] = ACTIONS(1564),
    [anon_sym_GT_AMP] = ACTIONS(1564),
    [anon_sym_BQUOTE] = ACTIONS(1564),
    [anon_sym_GT_LPAREN] = ACTIONS(1564),
    [sym_ansii_c_string] = ACTIONS(1564),
  },
  [621] = {
    [sym_word] = ACTIONS(1574),
    [anon_sym_AMP_GT_GT] = ACTIONS(1574),
    [anon_sym_DOLLAR] = ACTIONS(1572),
    [anon_sym_LT_LPAREN] = ACTIONS(1574),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1574),
    [anon_sym_LT] = ACTIONS(1572),
    [anon_sym_LT_AMP] = ACTIONS(1574),
    [anon_sym_GT_GT] = ACTIONS(1574),
    [sym__special_character] = ACTIONS(1574),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1574),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1574),
    [sym_raw_string] = ACTIONS(1574),
    [sym_variable_name] = ACTIONS(1574),
    [sym_file_descriptor] = ACTIONS(1574),
    [anon_sym_RPAREN] = ACTIONS(1574),
    [anon_sym_GT] = ACTIONS(1572),
    [anon_sym_AMP_GT] = ACTIONS(1572),
    [anon_sym_DQUOTE] = ACTIONS(1574),
    [anon_sym_GT_AMP] = ACTIONS(1574),
    [anon_sym_BQUOTE] = ACTIONS(1574),
    [anon_sym_GT_LPAREN] = ACTIONS(1574),
    [sym_ansii_c_string] = ACTIONS(1574),
  },
  [622] = {
    [sym_word] = ACTIONS(1578),
    [anon_sym_AMP_GT_GT] = ACTIONS(1578),
    [anon_sym_DOLLAR] = ACTIONS(1576),
    [anon_sym_LT_LPAREN] = ACTIONS(1578),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1578),
    [anon_sym_LT] = ACTIONS(1576),
    [anon_sym_LT_AMP] = ACTIONS(1578),
    [anon_sym_GT_GT] = ACTIONS(1578),
    [sym__special_character] = ACTIONS(1578),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1578),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1578),
    [sym_raw_string] = ACTIONS(1578),
    [sym_variable_name] = ACTIONS(1578),
    [sym_file_descriptor] = ACTIONS(1578),
    [anon_sym_RPAREN] = ACTIONS(1578),
    [anon_sym_GT] = ACTIONS(1576),
    [anon_sym_AMP_GT] = ACTIONS(1576),
    [anon_sym_DQUOTE] = ACTIONS(1578),
    [anon_sym_GT_AMP] = ACTIONS(1578),
    [anon_sym_BQUOTE] = ACTIONS(1578),
    [anon_sym_GT_LPAREN] = ACTIONS(1578),
    [sym_ansii_c_string] = ACTIONS(1578),
  },
  [623] = {
    [sym_word] = ACTIONS(1582),
    [anon_sym_AMP_GT_GT] = ACTIONS(1582),
    [anon_sym_DOLLAR] = ACTIONS(1582),
    [anon_sym_LT_LT] = ACTIONS(1582),
    [anon_sym_LT_LPAREN] = ACTIONS(1582),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1582),
    [anon_sym_PIPE] = ACTIONS(1582),
    [anon_sym_LT] = ACTIONS(1582),
    [anon_sym_LT_AMP] = ACTIONS(1582),
    [anon_sym_GT_GT] = ACTIONS(1582),
    [sym__special_character] = ACTIONS(1582),
    [anon_sym_LT_LT_DASH] = ACTIONS(1582),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1582),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1582),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1582),
    [anon_sym_LF] = ACTIONS(1584),
    [anon_sym_SEMI] = ACTIONS(1582),
    [sym_raw_string] = ACTIONS(1582),
    [sym_variable_name] = ACTIONS(1584),
    [sym_file_descriptor] = ACTIONS(1584),
    [anon_sym_AMP] = ACTIONS(1582),
    [anon_sym_GT] = ACTIONS(1582),
    [anon_sym_AMP_GT] = ACTIONS(1582),
    [anon_sym_DQUOTE] = ACTIONS(1582),
    [anon_sym_LT_LT_LT] = ACTIONS(1582),
    [anon_sym_GT_AMP] = ACTIONS(1582),
    [ts_builtin_sym_end] = ACTIONS(1584),
    [anon_sym_BQUOTE] = ACTIONS(1582),
    [anon_sym_GT_LPAREN] = ACTIONS(1582),
    [sym_ansii_c_string] = ACTIONS(1582),
    [anon_sym_AMP_AMP] = ACTIONS(1582),
    [anon_sym_SEMI_SEMI] = ACTIONS(1582),
    [anon_sym_PIPE_AMP] = ACTIONS(1582),
  },
  [624] = {
    [anon_sym_LPAREN] = ACTIONS(1415),
    [sym_word] = ACTIONS(1415),
    [anon_sym_AMP_GT_GT] = ACTIONS(1417),
    [anon_sym_local] = ACTIONS(1415),
    [anon_sym_typeset] = ACTIONS(1415),
    [anon_sym_unsetenv] = ACTIONS(1415),
    [anon_sym_DOLLAR] = ACTIONS(1415),
    [anon_sym_LT_LPAREN] = ACTIONS(1417),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(1415),
    [anon_sym_LBRACE] = ACTIONS(1417),
    [anon_sym_LT] = ACTIONS(1415),
    [anon_sym_LT_AMP] = ACTIONS(1417),
    [anon_sym_GT_GT] = ACTIONS(1417),
    [anon_sym_export] = ACTIONS(1415),
    [sym__special_character] = ACTIONS(1415),
    [anon_sym_if] = ACTIONS(1415),
    [anon_sym_case] = ACTIONS(1415),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1417),
    [sym_raw_string] = ACTIONS(1417),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1417),
    [anon_sym_BANG] = ACTIONS(1415),
    [anon_sym_declare] = ACTIONS(1415),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1417),
    [sym_file_descriptor] = ACTIONS(1417),
    [sym_variable_name] = ACTIONS(1417),
    [anon_sym_GT] = ACTIONS(1415),
    [anon_sym_AMP_GT] = ACTIONS(1415),
    [anon_sym_readonly] = ACTIONS(1415),
    [anon_sym_unset] = ACTIONS(1415),
    [anon_sym_DQUOTE] = ACTIONS(1417),
    [anon_sym_GT_AMP] = ACTIONS(1417),
    [anon_sym_BQUOTE] = ACTIONS(1651),
    [anon_sym_GT_LPAREN] = ACTIONS(1417),
    [anon_sym_for] = ACTIONS(1415),
    [anon_sym_while] = ACTIONS(1415),
    [anon_sym_LBRACK] = ACTIONS(1415),
    [sym_ansii_c_string] = ACTIONS(1417),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1417),
  },
  [625] = {
    [sym_word] = ACTIONS(1743),
    [anon_sym_AMP_GT_GT] = ACTIONS(1743),
    [anon_sym_DOLLAR] = ACTIONS(1741),
    [anon_sym_LT_LPAREN] = ACTIONS(1743),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1743),
    [anon_sym_LT] = ACTIONS(1741),
    [anon_sym_LT_AMP] = ACTIONS(1743),
    [anon_sym_GT_GT] = ACTIONS(1743),
    [sym__special_character] = ACTIONS(1743),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1743),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1743),
    [sym_raw_string] = ACTIONS(1743),
    [sym_variable_name] = ACTIONS(1743),
    [sym_file_descriptor] = ACTIONS(1743),
    [anon_sym_RPAREN] = ACTIONS(1743),
    [anon_sym_GT] = ACTIONS(1741),
    [anon_sym_AMP_GT] = ACTIONS(1741),
    [anon_sym_DQUOTE] = ACTIONS(1743),
    [anon_sym_GT_AMP] = ACTIONS(1743),
    [anon_sym_BQUOTE] = ACTIONS(1743),
    [anon_sym_GT_LPAREN] = ACTIONS(1743),
    [sym_ansii_c_string] = ACTIONS(1743),
  },
  [626] = {
    [sym_word] = ACTIONS(1749),
    [anon_sym_AMP_GT_GT] = ACTIONS(1749),
    [anon_sym_DOLLAR] = ACTIONS(1747),
    [anon_sym_LT_LPAREN] = ACTIONS(1749),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1749),
    [anon_sym_LT] = ACTIONS(1747),
    [anon_sym_LT_AMP] = ACTIONS(1749),
    [anon_sym_GT_GT] = ACTIONS(1749),
    [sym__special_character] = ACTIONS(1749),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1749),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1749),
    [sym_raw_string] = ACTIONS(1749),
    [sym_variable_name] = ACTIONS(1749),
    [sym_file_descriptor] = ACTIONS(1749),
    [anon_sym_RPAREN] = ACTIONS(1749),
    [anon_sym_GT] = ACTIONS(1747),
    [anon_sym_AMP_GT] = ACTIONS(1747),
    [anon_sym_DQUOTE] = ACTIONS(1749),
    [anon_sym_GT_AMP] = ACTIONS(1749),
    [anon_sym_BQUOTE] = ACTIONS(1749),
    [anon_sym_GT_LPAREN] = ACTIONS(1749),
    [sym_ansii_c_string] = ACTIONS(1749),
  },
  [627] = {
    [sym_word] = ACTIONS(1753),
    [anon_sym_AMP_GT_GT] = ACTIONS(1753),
    [anon_sym_DOLLAR] = ACTIONS(1751),
    [anon_sym_LT_LPAREN] = ACTIONS(1753),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1753),
    [anon_sym_LT] = ACTIONS(1751),
    [anon_sym_LT_AMP] = ACTIONS(1753),
    [anon_sym_GT_GT] = ACTIONS(1753),
    [sym__special_character] = ACTIONS(1753),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1753),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1753),
    [sym_raw_string] = ACTIONS(1753),
    [sym_variable_name] = ACTIONS(1753),
    [sym_file_descriptor] = ACTIONS(1753),
    [anon_sym_RPAREN] = ACTIONS(1753),
    [anon_sym_GT] = ACTIONS(1751),
    [anon_sym_AMP_GT] = ACTIONS(1751),
    [anon_sym_DQUOTE] = ACTIONS(1753),
    [anon_sym_GT_AMP] = ACTIONS(1753),
    [anon_sym_BQUOTE] = ACTIONS(1753),
    [anon_sym_GT_LPAREN] = ACTIONS(1753),
    [sym_ansii_c_string] = ACTIONS(1753),
  },
  [628] = {
    [sym_word] = ACTIONS(1759),
    [anon_sym_AMP_GT_GT] = ACTIONS(1759),
    [anon_sym_DOLLAR] = ACTIONS(1757),
    [anon_sym_LT_LPAREN] = ACTIONS(1759),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1759),
    [anon_sym_LT] = ACTIONS(1757),
    [anon_sym_LT_AMP] = ACTIONS(1759),
    [anon_sym_GT_GT] = ACTIONS(1759),
    [sym__special_character] = ACTIONS(1759),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1759),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1759),
    [sym_raw_string] = ACTIONS(1759),
    [sym_variable_name] = ACTIONS(1759),
    [sym_file_descriptor] = ACTIONS(1759),
    [anon_sym_RPAREN] = ACTIONS(1759),
    [anon_sym_GT] = ACTIONS(1757),
    [anon_sym_AMP_GT] = ACTIONS(1757),
    [anon_sym_DQUOTE] = ACTIONS(1759),
    [anon_sym_GT_AMP] = ACTIONS(1759),
    [anon_sym_BQUOTE] = ACTIONS(1759),
    [anon_sym_GT_LPAREN] = ACTIONS(1759),
    [sym_ansii_c_string] = ACTIONS(1759),
  },
  [629] = {
    [sym_word] = ACTIONS(1832),
    [anon_sym_AMP_GT_GT] = ACTIONS(1832),
    [anon_sym_DOLLAR] = ACTIONS(1830),
    [anon_sym_LT_LPAREN] = ACTIONS(1832),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1832),
    [anon_sym_LT] = ACTIONS(1830),
    [anon_sym_LT_AMP] = ACTIONS(1832),
    [anon_sym_GT_GT] = ACTIONS(1832),
    [sym__special_character] = ACTIONS(1832),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1832),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1832),
    [sym_raw_string] = ACTIONS(1832),
    [sym_variable_name] = ACTIONS(1832),
    [sym_file_descriptor] = ACTIONS(1832),
    [anon_sym_RPAREN] = ACTIONS(1832),
    [anon_sym_GT] = ACTIONS(1830),
    [anon_sym_AMP_GT] = ACTIONS(1830),
    [anon_sym_DQUOTE] = ACTIONS(1832),
    [anon_sym_GT_AMP] = ACTIONS(1832),
    [anon_sym_BQUOTE] = ACTIONS(1832),
    [anon_sym_GT_LPAREN] = ACTIONS(1832),
    [sym_ansii_c_string] = ACTIONS(1832),
  },
  [630] = {
    [sym_word] = ACTIONS(1836),
    [anon_sym_AMP_GT_GT] = ACTIONS(1836),
    [anon_sym_DOLLAR] = ACTIONS(1834),
    [anon_sym_LT_LPAREN] = ACTIONS(1836),
    [sym_comment] = ACTIONS(19),
    [sym__concat] = ACTIONS(1836),
    [anon_sym_LT] = ACTIONS(1834),
    [anon_sym_LT_AMP] = ACTIONS(1836),
    [anon_sym_GT_GT] = ACTIONS(1836),
    [sym__special_character] = ACTIONS(1836),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1836),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1836),
    [sym_raw_string] = ACTIONS(1836),
    [sym_variable_name] = ACTIONS(1836),
    [sym_file_descriptor] = ACTIONS(1836),
    [anon_sym_RPAREN] = ACTIONS(1836),
    [anon_sym_GT] = ACTIONS(1834),
    [anon_sym_AMP_GT] = ACTIONS(1834),
    [anon_sym_DQUOTE] = ACTIONS(1836),
    [anon_sym_GT_AMP] = ACTIONS(1836),
    [anon_sym_BQUOTE] = ACTIONS(1836),
    [anon_sym_GT_LPAREN] = ACTIONS(1836),
    [sym_ansii_c_string] = ACTIONS(1836),
  },
  [631] = {
    [sym_command_substitution] = STATE(550),
    [aux_sym__literal_repeat1] = STATE(551),
    [sym_string] = STATE(550),
    [aux_sym_declaration_command_repeat1] = STATE(639),
    [sym_process_substitution] = STATE(550),
    [sym_simple_expansion] = STATE(550),
    [sym_subscript] = STATE(2482),
    [sym_string_expansion] = STATE(550),
    [sym_variable_assignment] = STATE(639),
    [sym_concatenation] = STATE(639),
    [sym_expansion] = STATE(550),
    [sym_word] = ACTIONS(2378),
    [anon_sym_AMP_GT_GT] = ACTIONS(133),
    [anon_sym_DOLLAR] = ACTIONS(2380),
    [anon_sym_LT_LT] = ACTIONS(133),
    [anon_sym_LT_LPAREN] = ACTIONS(2382),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(133),
    [anon_sym_PIPE] = ACTIONS(133),
    [anon_sym_LT] = ACTIONS(133),
    [anon_sym_LT_AMP] = ACTIONS(133),
    [anon_sym_GT_GT] = ACTIONS(133),
    [sym__special_character] = ACTIONS(2384),
    [anon_sym_LT_LT_DASH] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2386),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2388),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2390),
    [anon_sym_LF] = ACTIONS(147),
    [anon_sym_SEMI] = ACTIONS(133),
    [sym_raw_string] = ACTIONS(2378),
    [sym_variable_name] = ACTIONS(2392),
    [sym_file_descriptor] = ACTIONS(147),
    [anon_sym_AMP] = ACTIONS(133),
    [anon_sym_GT] = ACTIONS(133),
    [anon_sym_AMP_GT] = ACTIONS(133),
    [anon_sym_DQUOTE] = ACTIONS(2394),
    [anon_sym_LT_LT_LT] = ACTIONS(133),
    [anon_sym_GT_AMP] = ACTIONS(133),
    [anon_sym_BQUOTE] = ACTIONS(2396),
    [anon_sym_esac] = ACTIONS(133),
    [anon_sym_GT_LPAREN] = ACTIONS(2382),
    [sym_ansii_c_string] = ACTIONS(2378),
    [anon_sym_AMP_AMP] = ACTIONS(133),
    [anon_sym_SEMI_SEMI] = ACTIONS(133),
    [anon_sym_PIPE_AMP] = ACTIONS(133),
  },
  [632] = {
    [sym_command_substitution] = STATE(553),
    [aux_sym__literal_repeat1] = STATE(554),
    [sym_string] = STATE(553),
    [aux_sym_unset_command_repeat1] = STATE(640),
    [sym_process_substitution] = STATE(553),
    [sym_simple_expansion] = STATE(553),
    [sym_string_expansion] = STATE(553),
    [sym_concatenation] = STATE(640),
    [sym_expansion] = STATE(553),
    [sym_word] = ACTIONS(2398),
    [anon_sym_AMP_GT_GT] = ACTIONS(157),
    [anon_sym_DOLLAR] = ACTIONS(2400),
    [anon_sym_LT_LT] = ACTIONS(157),
    [anon_sym_LT_LPAREN] = ACTIONS(2402),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(157),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(157),
    [anon_sym_LT_AMP] = ACTIONS(157),
    [anon_sym_GT_GT] = ACTIONS(157),
    [sym__special_character] = ACTIONS(2404),
    [anon_sym_LT_LT_DASH] = ACTIONS(157),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2406),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2408),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2410),
    [anon_sym_LF] = ACTIONS(171),
    [anon_sym_SEMI] = ACTIONS(157),
    [sym_raw_string] = ACTIONS(2398),
    [sym_file_descriptor] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(157),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_AMP_GT] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(2412),
    [anon_sym_LT_LT_LT] = ACTIONS(157),
    [anon_sym_GT_AMP] = ACTIONS(157),
    [anon_sym_BQUOTE] = ACTIONS(2414),
    [anon_sym_esac] = ACTIONS(157),
    [anon_sym_GT_LPAREN] = ACTIONS(2402),
    [sym_ansii_c_string] = ACTIONS(2398),
    [anon_sym_AMP_AMP] = ACTIONS(157),
    [anon_sym_SEMI_SEMI] = ACTIONS(157),
    [anon_sym_PIPE_AMP] = ACTIONS(157),
  },
  [633] = {
    [aux_sym_concatenation_repeat1] = STATE(638),
    [sym_word] = ACTIONS(189),
    [anon_sym_AMP_GT_GT] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [anon_sym_LT_LT] = ACTIONS(189),
    [anon_sym_LT_LPAREN] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [sym__concat] = ACTIONS(377),
    [anon_sym_PIPE] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(189),
    [anon_sym_LT_AMP] = ACTIONS(189),
    [anon_sym_GT_GT] = ACTIONS(189),
    [sym__special_character] = ACTIONS(189),
    [anon_sym_LT_LT_DASH] = ACTIONS(189),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(189),
    [aux_sym__simple_variable_name_token1] = ACTIONS(189),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(189),
    [sym_variable_name] = ACTIONS(191),
    [sym_file_descriptor] = ACTIONS(191),
    [anon_sym_AMP] = ACTIONS(189),
    [anon_sym_GT] = ACTIONS(189),
    [anon_sym_AMP_GT] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_LT_LT_LT] = ACTIONS(189),
    [anon_sym_GT_AMP] = ACTIONS(189),
    [ts_builtin_sym_end] = ACTIONS(191),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [anon_sym_GT_LPAREN] = ACTIONS(189),
    [sym_ansii_c_string] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_SEMI_SEMI] = ACTIONS(189),
    [anon_sym_PIPE_AMP] = ACTIONS(189),
  },
  [634] = {
    [sym_heredoc_redirect] = STATE(418),
    [aux_sym_redirected_statement_repeat1] = STATE(418),
    [sym_herestring_redirect] = STATE(418),
    [sym_file_redirect] = STATE(418),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LF] = ACTIONS(2416),
    [anon_sym_SEMI] = ACTIONS(1960),
    [sym_file_descriptor] = ACTIONS(439),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_AMP] = ACTIONS(1960),
    [anon_sym_AMP_GT] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_LT_LT_LT] = ACTIONS(445),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_SEMI_SEMI] = ACTIONS(1964),
    [anon_sym_PIPE_AMP] = ACTIONS(431),
  },
  [635] = {
    [sym_heredoc_redirect] = STATE(2622),
    [aux_sym_redirected_statement_repeat1] = STATE(2622),
    [sym_herestring_redirect] = STATE(2622),
    [sym_file_redirect] = STATE(2622),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(2210),
    [anon_sym_PIPE] = ACTIONS(2214),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(2204),
    [anon_sym_SEMI] = ACTIONS(2206),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(2206),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(2212),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_esac] = ACTIONS(1964),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(2210),
    [anon_sym_SEMI_SEMI] = ACTIONS(1964),
    [anon_sym_PIPE_AMP] = ACTIONS(2214),
  },
  [636] = {
    [aux_sym__literal_repeat1] = STATE(539),
    [sym_if_statement] = STATE(651),
    [sym_function_definition] = STATE(651),
    [sym_negated_command] = STATE(651),
    [sym_test_command] = STATE(651),
    [sym_variable_assignment] = STATE(652),
    [sym_subscript] = STATE(2473),
    [sym_concatenation] = STATE(542),
    [sym_expansion] = STATE(537),
    [sym_command_substitution] = STATE(537),
    [aux_sym__statements_repeat1] = STATE(101),
    [sym_redirected_statement] = STATE(651),
    [sym_for_statement] = STATE(651),
    [sym_compound_statement] = STATE(651),
    [sym_subshell] = STATE(651),
    [sym_declaration_command] = STATE(651),
    [sym_unset_command] = STATE(651),
    [sym_file_redirect] = STATE(544),
    [sym_string] = STATE(537),
    [sym_process_substitution] = STATE(537),
    [aux_sym_command_repeat1] = STATE(544),
    [sym_c_style_for_statement] = STATE(651),
    [sym_while_statement] = STATE(651),
    [sym_case_statement] = STATE(651),
    [sym_pipeline] = STATE(651),
    [sym_list] = STATE(651),
    [sym_command] = STATE(651),
    [sym_command_name] = STATE(637),
    [sym_simple_expansion] = STATE(537),
    [sym_string_expansion] = STATE(537),
    [sym_word] = ACTIONS(1673),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(1675),
    [anon_sym_typeset] = ACTIONS(1675),
    [anon_sym_unsetenv] = ACTIONS(1677),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LPAREN] = ACTIONS(1681),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(1675),
    [sym__special_character] = ACTIONS(1683),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(1685),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1687),
    [anon_sym_BANG] = ACTIONS(1689),
    [anon_sym_declare] = ACTIONS(1675),
    [sym_variable_name] = ACTIONS(1691),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1693),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(1675),
    [anon_sym_unset] = ACTIONS(1677),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(1697),
    [anon_sym_GT_LPAREN] = ACTIONS(1681),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(1685),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [637] = {
    [sym_command_substitution] = STATE(572),
    [aux_sym__literal_repeat1] = STATE(574),
    [sym_string] = STATE(572),
    [sym_process_substitution] = STATE(572),
    [sym_simple_expansion] = STATE(572),
    [sym_string_expansion] = STATE(572),
    [aux_sym_command_repeat2] = STATE(654),
    [sym_concatenation] = STATE(654),
    [sym_expansion] = STATE(572),
    [sym_word] = ACTIONS(2418),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LT] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(2420),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(2422),
    [sym__special_character] = ACTIONS(1683),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2424),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2426),
    [anon_sym_LF] = ACTIONS(345),
    [anon_sym_SEMI] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(2418),
    [sym_file_descriptor] = ACTIONS(345),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(2422),
    [anon_sym_DQUOTE] = ACTIONS(2428),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(2430),
    [anon_sym_esac] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(2420),
    [sym_ansii_c_string] = ACTIONS(2418),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
  },
  [638] = {
    [aux_sym_concatenation_repeat1] = STATE(657),
    [sym_word] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LPAREN] = ACTIONS(355),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [sym__concat] = ACTIONS(2432),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_LT_AMP] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(355),
    [sym__special_character] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(355),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(355),
    [aux_sym__simple_variable_name_token1] = ACTIONS(355),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(355),
    [sym_raw_string] = ACTIONS(355),
    [sym_variable_name] = ACTIONS(359),
    [sym_file_descriptor] = ACTIONS(359),
    [anon_sym_AMP] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_LT_LT_LT] = ACTIONS(355),
    [anon_sym_GT_AMP] = ACTIONS(355),
    [ts_builtin_sym_end] = ACTIONS(359),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_GT_LPAREN] = ACTIONS(355),
    [sym_ansii_c_string] = ACTIONS(355),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(355),
    [anon_sym_PIPE_AMP] = ACTIONS(355),
  },
  [639] = {
    [sym_command_substitution] = STATE(550),
    [aux_sym__literal_repeat1] = STATE(551),
    [sym_string] = STATE(550),
    [aux_sym_declaration_command_repeat1] = STATE(579),
    [sym_process_substitution] = STATE(550),
    [sym_simple_expansion] = STATE(550),
    [sym_subscript] = STATE(2482),
    [sym_string_expansion] = STATE(550),
    [sym_variable_assignment] = STATE(579),
    [sym_concatenation] = STATE(579),
    [sym_expansion] = STATE(550),
    [sym_word] = ACTIONS(2378),
    [anon_sym_AMP_GT_GT] = ACTIONS(387),
    [anon_sym_DOLLAR] = ACTIONS(2380),
    [anon_sym_LT_LT] = ACTIONS(387),
    [anon_sym_LT_LPAREN] = ACTIONS(2382),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_PIPE] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(387),
    [anon_sym_LT_AMP] = ACTIONS(387),
    [anon_sym_GT_GT] = ACTIONS(387),
    [sym__special_character] = ACTIONS(2384),
    [anon_sym_LT_LT_DASH] = ACTIONS(387),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2386),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2434),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2390),
    [anon_sym_LF] = ACTIONS(391),
    [anon_sym_SEMI] = ACTIONS(387),
    [sym_raw_string] = ACTIONS(2378),
    [sym_variable_name] = ACTIONS(2392),
    [sym_file_descriptor] = ACTIONS(391),
    [anon_sym_AMP] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(387),
    [anon_sym_AMP_GT] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(2394),
    [anon_sym_LT_LT_LT] = ACTIONS(387),
    [anon_sym_GT_AMP] = ACTIONS(387),
    [anon_sym_BQUOTE] = ACTIONS(2396),
    [anon_sym_esac] = ACTIONS(387),
    [anon_sym_GT_LPAREN] = ACTIONS(2382),
    [sym_ansii_c_string] = ACTIONS(2378),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_SEMI_SEMI] = ACTIONS(387),
    [anon_sym_PIPE_AMP] = ACTIONS(387),
  },
  [640] = {
    [sym_command_substitution] = STATE(553),
    [aux_sym__literal_repeat1] = STATE(554),
    [sym_string] = STATE(553),
    [aux_sym_unset_command_repeat1] = STATE(580),
    [sym_process_substitution] = STATE(553),
    [sym_simple_expansion] = STATE(553),
    [sym_string_expansion] = STATE(553),
    [sym_concatenation] = STATE(580),
    [sym_expansion] = STATE(553),
    [sym_word] = ACTIONS(2398),
    [anon_sym_AMP_GT_GT] = ACTIONS(405),
    [anon_sym_DOLLAR] = ACTIONS(2400),
    [anon_sym_LT_LT] = ACTIONS(405),
    [anon_sym_LT_LPAREN] = ACTIONS(2402),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(405),
    [anon_sym_PIPE] = ACTIONS(405),
    [anon_sym_LT] = ACTIONS(405),
    [anon_sym_LT_AMP] = ACTIONS(405),
    [anon_sym_GT_GT] = ACTIONS(405),
    [sym__special_character] = ACTIONS(2404),
    [anon_sym_LT_LT_DASH] = ACTIONS(405),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2406),
    [aux_sym__simple_variable_name_token1] = ACTIONS(2436),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2410),
    [anon_sym_LF] = ACTIONS(409),
    [anon_sym_SEMI] = ACTIONS(405),
    [sym_raw_string] = ACTIONS(2398),
    [sym_file_descriptor] = ACTIONS(409),
    [anon_sym_AMP] = ACTIONS(405),
    [anon_sym_GT] = ACTIONS(405),
    [anon_sym_AMP_GT] = ACTIONS(405),
    [anon_sym_DQUOTE] = ACTIONS(2412),
    [anon_sym_LT_LT_LT] = ACTIONS(405),
    [anon_sym_GT_AMP] = ACTIONS(405),
    [anon_sym_BQUOTE] = ACTIONS(2414),
    [anon_sym_esac] = ACTIONS(405),
    [anon_sym_GT_LPAREN] = ACTIONS(2402),
    [sym_ansii_c_string] = ACTIONS(2398),
    [anon_sym_AMP_AMP] = ACTIONS(405),
    [anon_sym_SEMI_SEMI] = ACTIONS(405),
    [anon_sym_PIPE_AMP] = ACTIONS(405),
  },
  [641] = {
    [sym_word] = ACTIONS(411),
    [anon_sym_AMP_GT_GT] = ACTIONS(411),
    [anon_sym_DOLLAR] = ACTIONS(411),
    [anon_sym_LT_LT] = ACTIONS(411),
    [anon_sym_LT_LPAREN] = ACTIONS(411),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(411),
    [sym__concat] = ACTIONS(413),
    [anon_sym_PIPE] = ACTIONS(411),
    [anon_sym_LT] = ACTIONS(411),
    [anon_sym_LT_AMP] = ACTIONS(411),
    [anon_sym_GT_GT] = ACTIONS(411),
    [sym__special_character] = ACTIONS(411),
    [anon_sym_LT_LT_DASH] = ACTIONS(411),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(411),
    [aux_sym__simple_variable_name_token1] = ACTIONS(411),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(411),
    [anon_sym_LF] = ACTIONS(413),
    [anon_sym_SEMI] = ACTIONS(411),
    [sym_raw_string] = ACTIONS(411),
    [sym_variable_name] = ACTIONS(413),
    [sym_file_descriptor] = ACTIONS(413),
    [anon_sym_AMP] = ACTIONS(411),
    [anon_sym_GT] = ACTIONS(411),
    [anon_sym_AMP_GT] = ACTIONS(411),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_LT_LT_LT] = ACTIONS(411),
    [anon_sym_GT_AMP] = ACTIONS(411),
    [ts_builtin_sym_end] = ACTIONS(413),
    [anon_sym_BQUOTE] = ACTIONS(411),
    [anon_sym_GT_LPAREN] = ACTIONS(411),
    [sym_ansii_c_string] = ACTIONS(411),
    [anon_sym_AMP_AMP] = ACTIONS(411),
    [anon_sym_SEMI_SEMI] = ACTIONS(411),
    [anon_sym_PIPE_AMP] = ACTIONS(411),
  },
  [642] = {
    [sym_word] = ACTIONS(415),
    [anon_sym_AMP_GT_GT] = ACTIONS(415),
    [anon_sym_DOLLAR] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LPAREN] = ACTIONS(415),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(415),
    [sym__concat] = ACTIONS(417),
    [anon_sym_PIPE] = ACTIONS(415),
    [anon_sym_LT] = ACTIONS(415),
    [anon_sym_LT_AMP] = ACTIONS(415),
    [anon_sym_GT_GT] = ACTIONS(415),
    [sym__special_character] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(415),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(415),
    [aux_sym__simple_variable_name_token1] = ACTIONS(415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(415),
    [anon_sym_LF] = ACTIONS(417),
    [anon_sym_SEMI] = ACTIONS(415),
    [sym_raw_string] = ACTIONS(415),
    [sym_variable_name] = ACTIONS(417),
    [sym_file_descriptor] = ACTIONS(417),
    [anon_sym_AMP] = ACTIONS(415),
    [anon_sym_GT] = ACTIONS(415),
    [anon_sym_AMP_GT] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [anon_sym_LT_LT_LT] = ACTIONS(415),
    [anon_sym_GT_AMP] = ACTIONS(415),
    [ts_builtin_sym_end] = ACTIONS(417),
    [anon_sym_BQUOTE] = ACTIONS(415),
    [anon_sym_GT_LPAREN] = ACTIONS(415),
    [sym_ansii_c_string] = ACTIONS(415),
    [anon_sym_AMP_AMP] = ACTIONS(415),
    [anon_sym_SEMI_SEMI] = ACTIONS(415),
    [anon_sym_PIPE_AMP] = ACTIONS(415),
  },
  [643] = {
    [sym_word] = ACTIONS(419),
    [anon_sym_AMP_GT_GT] = ACTIONS(419),
    [anon_sym_DOLLAR] = ACTIONS(419),
    [anon_sym_LT_LT] = ACTIONS(419),
    [anon_sym_LT_LPAREN] = ACTIONS(419),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(419),
    [sym__concat] = ACTIONS(421),
    [anon_sym_PIPE] = ACTIONS(419),
    [anon_sym_LT] = ACTIONS(419),
    [anon_sym_LT_AMP] = ACTIONS(419),
    [anon_sym_GT_GT] = ACTIONS(419),
    [sym__special_character] = ACTIONS(419),
    [anon_sym_LT_LT_DASH] = ACTIONS(419),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [aux_sym__simple_variable_name_token1] = ACTIONS(419),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(419),
    [anon_sym_LF] = ACTIONS(421),
    [anon_sym_SEMI] = ACTIONS(419),
    [sym_raw_string] = ACTIONS(419),
    [sym_variable_name] = ACTIONS(421),
    [sym_file_descriptor] = ACTIONS(421),
    [anon_sym_AMP] = ACTIONS(419),
    [anon_sym_GT] = ACTIONS(419),
    [anon_sym_AMP_GT] = ACTIONS(419),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [anon_sym_LT_LT_LT] = ACTIONS(419),
    [anon_sym_GT_AMP] = ACTIONS(419),
    [ts_builtin_sym_end] = ACTIONS(421),
    [anon_sym_BQUOTE] = ACTIONS(419),
    [anon_sym_GT_LPAREN] = ACTIONS(419),
    [sym_ansii_c_string] = ACTIONS(419),
    [anon_sym_AMP_AMP] = ACTIONS(419),
    [anon_sym_SEMI_SEMI] = ACTIONS(419),
    [anon_sym_PIPE_AMP] = ACTIONS(419),
  },
  [644] = {
    [sym_word] = ACTIONS(579),
    [anon_sym_AMP_GT_GT] = ACTIONS(579),
    [anon_sym_DOLLAR] = ACTIONS(579),
    [anon_sym_LT_LT] = ACTIONS(579),
    [anon_sym_LT_LPAREN] = ACTIONS(579),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(579),
    [sym__concat] = ACTIONS(581),
    [anon_sym_PIPE] = ACTIONS(579),
    [anon_sym_LT] = ACTIONS(579),
    [anon_sym_LT_AMP] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(579),
    [sym__special_character] = ACTIONS(579),
    [anon_sym_LT_LT_DASH] = ACTIONS(579),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(579),
    [aux_sym__simple_variable_name_token1] = ACTIONS(579),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(579),
    [anon_sym_LF] = ACTIONS(581),
    [anon_sym_SEMI] = ACTIONS(579),
    [sym_raw_string] = ACTIONS(579),
    [sym_variable_name] = ACTIONS(581),
    [sym_file_descriptor] = ACTIONS(581),
    [anon_sym_AMP] = ACTIONS(579),
    [anon_sym_GT] = ACTIONS(579),
    [anon_sym_AMP_GT] = ACTIONS(579),
    [anon_sym_DQUOTE] = ACTIONS(579),
    [anon_sym_LT_LT_LT] = ACTIONS(579),
    [anon_sym_GT_AMP] = ACTIONS(579),
    [ts_builtin_sym_end] = ACTIONS(581),
    [anon_sym_BQUOTE] = ACTIONS(579),
    [anon_sym_GT_LPAREN] = ACTIONS(579),
    [sym_ansii_c_string] = ACTIONS(579),
    [anon_sym_AMP_AMP] = ACTIONS(579),
    [anon_sym_SEMI_SEMI] = ACTIONS(579),
    [anon_sym_PIPE_AMP] = ACTIONS(579),
  },
  [645] = {
    [sym_word] = ACTIONS(189),
    [anon_sym_AMP_GT_GT] = ACTIONS(189),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [anon_sym_LT_LT] = ACTIONS(189),
    [anon_sym_LT_LPAREN] = ACTIONS(189),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(189),
    [anon_sym_PIPE] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(189),
    [anon_sym_LT_AMP] = ACTIONS(189),
    [anon_sym_GT_GT] = ACTIONS(189),
    [sym__special_character] = ACTIONS(189),
    [anon_sym_LT_LT_DASH] = ACTIONS(189),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(189),
    [aux_sym__simple_variable_name_token1] = ACTIONS(189),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(189),
    [anon_sym_LF] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(189),
    [sym_variable_name] = ACTIONS(191),
    [sym_file_descriptor] = ACTIONS(191),
    [anon_sym_AMP] = ACTIONS(189),
    [anon_sym_GT] = ACTIONS(189),
    [anon_sym_AMP_GT] = ACTIONS(189),
    [anon_sym_DQUOTE] = ACTIONS(189),
    [anon_sym_LT_LT_LT] = ACTIONS(189),
    [anon_sym_GT_AMP] = ACTIONS(189),
    [ts_builtin_sym_end] = ACTIONS(191),
    [anon_sym_BQUOTE] = ACTIONS(189),
    [anon_sym_GT_LPAREN] = ACTIONS(189),
    [sym_ansii_c_string] = ACTIONS(189),
    [anon_sym_AMP_AMP] = ACTIONS(189),
    [anon_sym_SEMI_SEMI] = ACTIONS(189),
    [anon_sym_PIPE_AMP] = ACTIONS(189),
  },
  [646] = {
    [aux_sym__literal_repeat1] = STATE(646),
    [sym_word] = ACTIONS(629),
    [anon_sym_AMP_GT_GT] = ACTIONS(629),
    [anon_sym_DOLLAR] = ACTIONS(629),
    [anon_sym_LT_LT] = ACTIONS(629),
    [anon_sym_LT_LPAREN] = ACTIONS(629),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(629),
    [anon_sym_PIPE] = ACTIONS(629),
    [anon_sym_LT] = ACTIONS(629),
    [anon_sym_LT_AMP] = ACTIONS(629),
    [anon_sym_GT_GT] = ACTIONS(629),
    [sym__special_character] = ACTIONS(2438),
    [anon_sym_LT_LT_DASH] = ACTIONS(629),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(629),
    [aux_sym__simple_variable_name_token1] = ACTIONS(629),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(629),
    [anon_sym_LF] = ACTIONS(634),
    [anon_sym_SEMI] = ACTIONS(629),
    [sym_raw_string] = ACTIONS(629),
    [sym_variable_name] = ACTIONS(634),
    [sym_file_descriptor] = ACTIONS(634),
    [anon_sym_AMP] = ACTIONS(629),
    [anon_sym_GT] = ACTIONS(629),
    [anon_sym_AMP_GT] = ACTIONS(629),
    [anon_sym_DQUOTE] = ACTIONS(629),
    [anon_sym_LT_LT_LT] = ACTIONS(629),
    [anon_sym_GT_AMP] = ACTIONS(629),
    [ts_builtin_sym_end] = ACTIONS(634),
    [anon_sym_BQUOTE] = ACTIONS(629),
    [anon_sym_GT_LPAREN] = ACTIONS(629),
    [sym_ansii_c_string] = ACTIONS(629),
    [anon_sym_AMP_AMP] = ACTIONS(629),
    [anon_sym_SEMI_SEMI] = ACTIONS(629),
    [anon_sym_PIPE_AMP] = ACTIONS(629),
  },
  [647] = {
    [aux_sym__literal_repeat1] = STATE(539),
    [sym_if_statement] = STATE(2623),
    [sym_function_definition] = STATE(2623),
    [sym_negated_command] = STATE(2623),
    [sym_test_command] = STATE(2623),
    [sym_variable_assignment] = STATE(667),
    [sym_subscript] = STATE(2473),
    [sym_concatenation] = STATE(542),
    [sym_expansion] = STATE(537),
    [sym_command_substitution] = STATE(537),
    [sym_redirected_statement] = STATE(2623),
    [sym_for_statement] = STATE(2623),
    [sym_compound_statement] = STATE(2623),
    [sym_subshell] = STATE(2623),
    [sym_declaration_command] = STATE(2623),
    [sym_unset_command] = STATE(2623),
    [sym_file_redirect] = STATE(544),
    [sym_string] = STATE(537),
    [sym_process_substitution] = STATE(537),
    [aux_sym_command_repeat1] = STATE(544),
    [sym_c_style_for_statement] = STATE(2623),
    [sym_while_statement] = STATE(2623),
    [sym_case_statement] = STATE(2623),
    [sym_pipeline] = STATE(2623),
    [sym_list] = STATE(2623),
    [sym_command] = STATE(2623),
    [sym_command_name] = STATE(637),
    [sym_simple_expansion] = STATE(537),
    [sym_string_expansion] = STATE(537),
    [sym_word] = ACTIONS(1673),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(1675),
    [anon_sym_typeset] = ACTIONS(1675),
    [anon_sym_unsetenv] = ACTIONS(1677),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LPAREN] = ACTIONS(1681),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(1675),
    [sym__special_character] = ACTIONS(1683),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(1685),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1687),
    [anon_sym_BANG] = ACTIONS(1689),
    [anon_sym_declare] = ACTIONS(1675),
    [sym_variable_name] = ACTIONS(1691),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1693),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(1675),
    [anon_sym_unset] = ACTIONS(1677),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(1697),
    [anon_sym_GT_LPAREN] = ACTIONS(1681),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(1685),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [648] = {
    [sym_heredoc_body] = STATE(598),
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__simple_heredoc_body] = ACTIONS(870),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [sym__heredoc_body_beginning] = ACTIONS(872),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_esac] = ACTIONS(2007),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
    [anon_sym_SEMI_SEMI] = ACTIONS(644),
  },
  [649] = {
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_esac] = ACTIONS(2007),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
    [anon_sym_SEMI_SEMI] = ACTIONS(644),
  },
  [650] = {
    [aux_sym__literal_repeat1] = STATE(539),
    [sym_if_statement] = STATE(669),
    [sym_function_definition] = STATE(669),
    [sym_negated_command] = STATE(669),
    [sym_test_command] = STATE(669),
    [sym_variable_assignment] = STATE(670),
    [sym_subscript] = STATE(2473),
    [sym_concatenation] = STATE(542),
    [sym_expansion] = STATE(537),
    [sym_command_substitution] = STATE(537),
    [sym_redirected_statement] = STATE(669),
    [sym_for_statement] = STATE(669),
    [sym_compound_statement] = STATE(669),
    [sym_subshell] = STATE(669),
    [sym_declaration_command] = STATE(669),
    [sym_unset_command] = STATE(669),
    [sym_file_redirect] = STATE(544),
    [sym_string] = STATE(537),
    [sym_process_substitution] = STATE(537),
    [aux_sym_command_repeat1] = STATE(544),
    [sym_c_style_for_statement] = STATE(669),
    [sym_while_statement] = STATE(669),
    [sym_case_statement] = STATE(669),
    [sym_pipeline] = STATE(669),
    [sym_list] = STATE(669),
    [sym_command] = STATE(669),
    [sym_command_name] = STATE(637),
    [sym_simple_expansion] = STATE(537),
    [sym_string_expansion] = STATE(537),
    [sym_word] = ACTIONS(1673),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_AMP_GT_GT] = ACTIONS(9),
    [anon_sym_local] = ACTIONS(1675),
    [anon_sym_typeset] = ACTIONS(1675),
    [anon_sym_unsetenv] = ACTIONS(1677),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LPAREN] = ACTIONS(1681),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(25),
    [anon_sym_LT_AMP] = ACTIONS(9),
    [anon_sym_GT_GT] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(1675),
    [sym__special_character] = ACTIONS(1683),
    [anon_sym_if] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(91),
    [sym_raw_string] = ACTIONS(1685),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1687),
    [anon_sym_BANG] = ACTIONS(1689),
    [anon_sym_declare] = ACTIONS(1675),
    [sym_variable_name] = ACTIONS(1691),
    [sym_file_descriptor] = ACTIONS(43),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1693),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_AMP_GT] = ACTIONS(25),
    [anon_sym_readonly] = ACTIONS(1675),
    [anon_sym_unset] = ACTIONS(1677),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [anon_sym_GT_AMP] = ACTIONS(9),
    [anon_sym_BQUOTE] = ACTIONS(1697),
    [anon_sym_GT_LPAREN] = ACTIONS(1681),
    [anon_sym_for] = ACTIONS(107),
    [anon_sym_while] = ACTIONS(109),
    [anon_sym_LBRACK] = ACTIONS(111),
    [sym_ansii_c_string] = ACTIONS(1685),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(113),
  },
  [651] = {
    [sym_heredoc_redirect] = STATE(2622),
    [aux_sym_redirected_statement_repeat1] = STATE(2622),
    [sym_herestring_redirect] = STATE(2622),
    [sym_file_redirect] = STATE(2622),
    [anon_sym_PIPE_AMP] = ACTIONS(2214),
    [anon_sym_AMP_GT_GT] = ACTIONS(2202),
    [anon_sym_LF] = ACTIONS(2441),
    [anon_sym_SEMI] = ACTIONS(2443),
    [sym_file_descriptor] = ACTIONS(2208),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(2202),
    [anon_sym_AMP] = ACTIONS(2443),
    [anon_sym_AMP_GT] = ACTIONS(2202),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(2210),
    [anon_sym_LT_LT_LT] = ACTIONS(2212),
    [anon_sym_GT_AMP] = ACTIONS(2202),
    [anon_sym_PIPE] = ACTIONS(2214),
    [anon_sym_LT] = ACTIONS(2202),
    [anon_sym_esac] = ACTIONS(2007),
    [anon_sym_LT_AMP] = ACTIONS(2202),
    [anon_sym_GT_GT] = ACTIONS(2202),
    [anon_sym_AMP_AMP] = ACTIONS(2210),
    [anon_sym_SEMI_SEMI] = ACTIONS(2007),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
  },
  [652] = {
    [sym_heredoc_redirect] = STATE(2622),
    [aux_sym_redirected_statement_repeat1] = STATE(2622),
    [sym_herestring_redirect] = STATE(2622),
    [sym_file_redirect] = STATE(2622),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(2210),
    [anon_sym_PIPE] = ACTIONS(2214),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(441),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(2441),
    [anon_sym_SEMI] = ACTIONS(2443),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(2443),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(2212),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_esac] = ACTIONS(2007),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(2210),
    [anon_sym_SEMI_SEMI] = ACTIONS(2007),
    [anon_sym_PIPE_AMP] = ACTIONS(2214),
  },
  [653] = {
    [sym_command_substitution] = STATE(572),
    [aux_sym__literal_repeat1] = STATE(574),
    [sym_string] = STATE(572),
    [sym_process_substitution] = STATE(572),
    [sym_simple_expansion] = STATE(572),
    [sym_string_expansion] = STATE(572),
    [aux_sym_command_repeat2] = STATE(673),
    [sym_concatenation] = STATE(673),
    [sym_expansion] = STATE(572),
    [sym_word] = ACTIONS(2418),
    [anon_sym_AMP_GT_GT] = ACTIONS(750),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LT] = ACTIONS(750),
    [anon_sym_LT_LPAREN] = ACTIONS(2420),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(750),
    [anon_sym_PIPE] = ACTIONS(750),
    [anon_sym_LT] = ACTIONS(750),
    [anon_sym_LT_AMP] = ACTIONS(750),
    [anon_sym_GT_GT] = ACTIONS(750),
    [anon_sym_EQ_TILDE] = ACTIONS(2422),
    [sym__special_character] = ACTIONS(1683),
    [anon_sym_LT_LT_DASH] = ACTIONS(750),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2424),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2426),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [sym_raw_string] = ACTIONS(2418),
    [sym_file_descriptor] = ACTIONS(752),
    [anon_sym_AMP] = ACTIONS(750),
    [anon_sym_GT] = ACTIONS(750),
    [anon_sym_AMP_GT] = ACTIONS(750),
    [anon_sym_EQ_EQ] = ACTIONS(2422),
    [anon_sym_DQUOTE] = ACTIONS(2428),
    [anon_sym_LT_LT_LT] = ACTIONS(750),
    [anon_sym_GT_AMP] = ACTIONS(750),
    [anon_sym_BQUOTE] = ACTIONS(2430),
    [anon_sym_esac] = ACTIONS(750),
    [anon_sym_GT_LPAREN] = ACTIONS(2420),
    [sym_ansii_c_string] = ACTIONS(2418),
    [anon_sym_AMP_AMP] = ACTIONS(750),
    [anon_sym_SEMI_SEMI] = ACTIONS(750),
    [anon_sym_PIPE_AMP] = ACTIONS(750),
  },
  [654] = {
    [sym_command_substitution] = STATE(572),
    [aux_sym__literal_repeat1] = STATE(574),
    [sym_string] = STATE(572),
    [sym_process_substitution] = STATE(572),
    [sym_simple_expansion] = STATE(572),
    [sym_string_expansion] = STATE(572),
    [aux_sym_command_repeat2] = STATE(607),
    [sym_concatenation] = STATE(607),
    [sym_expansion] = STATE(572),
    [sym_word] = ACTIONS(2418),
    [anon_sym_AMP_GT_GT] = ACTIONS(750),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LT] = ACTIONS(750),
    [anon_sym_LT_LPAREN] = ACTIONS(2420),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(750),
    [anon_sym_PIPE] = ACTIONS(750),
    [anon_sym_LT] = ACTIONS(750),
    [anon_sym_LT_AMP] = ACTIONS(750),
    [anon_sym_GT_GT] = ACTIONS(750),
    [anon_sym_EQ_TILDE] = ACTIONS(2422),
    [sym__special_character] = ACTIONS(1683),
    [anon_sym_LT_LT_DASH] = ACTIONS(750),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2424),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2426),
    [anon_sym_LF] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [sym_raw_string] = ACTIONS(2418),
    [sym_file_descriptor] = ACTIONS(752),
    [anon_sym_AMP] = ACTIONS(750),
    [anon_sym_GT] = ACTIONS(750),
    [anon_sym_AMP_GT] = ACTIONS(750),
    [anon_sym_EQ_EQ] = ACTIONS(2422),
    [anon_sym_DQUOTE] = ACTIONS(2428),
    [anon_sym_LT_LT_LT] = ACTIONS(750),
    [anon_sym_GT_AMP] = ACTIONS(750),
    [anon_sym_BQUOTE] = ACTIONS(2430),
    [anon_sym_esac] = ACTIONS(750),
    [anon_sym_GT_LPAREN] = ACTIONS(2420),
    [sym_ansii_c_string] = ACTIONS(2418),
    [anon_sym_AMP_AMP] = ACTIONS(750),
    [anon_sym_SEMI_SEMI] = ACTIONS(750),
    [anon_sym_PIPE_AMP] = ACTIONS(750),
  },
  [655] = {
    [sym_word] = ACTIONS(782),
    [anon_sym_AMP_GT_GT] = ACTIONS(782),
    [anon_sym_DOLLAR] = ACTIONS(782),
    [anon_sym_LT_LT] = ACTIONS(782),
    [anon_sym_LT_LPAREN] = ACTIONS(782),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(782),
    [sym__concat] = ACTIONS(784),
    [anon_sym_PIPE] = ACTIONS(782),
    [anon_sym_LT] = ACTIONS(782),
    [anon_sym_LT_AMP] = ACTIONS(782),
    [anon_sym_GT_GT] = ACTIONS(782),
    [sym__special_character] = ACTIONS(782),
    [anon_sym_LT_LT_DASH] = ACTIONS(782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(782),
    [aux_sym__simple_variable_name_token1] = ACTIONS(782),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(782),
    [anon_sym_LF] = ACTIONS(784),
    [anon_sym_SEMI] = ACTIONS(782),
    [sym_raw_string] = ACTIONS(782),
    [sym_variable_name] = ACTIONS(784),
    [sym_file_descriptor] = ACTIONS(784),
    [anon_sym_AMP] = ACTIONS(782),
    [anon_sym_GT] = ACTIONS(782),
    [anon_sym_AMP_GT] = ACTIONS(782),
    [anon_sym_DQUOTE] = ACTIONS(782),
    [anon_sym_LT_LT_LT] = ACTIONS(782),
    [anon_sym_GT_AMP] = ACTIONS(782),
    [ts_builtin_sym_end] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(782),
    [anon_sym_GT_LPAREN] = ACTIONS(782),
    [sym_ansii_c_string] = ACTIONS(782),
    [anon_sym_AMP_AMP] = ACTIONS(782),
    [anon_sym_SEMI_SEMI] = ACTIONS(782),
    [anon_sym_PIPE_AMP] = ACTIONS(782),
  },
  [656] = {
    [sym_command_substitution] = STATE(655),
    [sym_simple_expansion] = STATE(655),
    [sym_string_expansion] = STATE(655),
    [sym_string] = STATE(655),
    [sym_process_substitution] = STATE(655),
    [sym_expansion] = STATE(655),
    [sym_word] = ACTIONS(2445),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2447),
    [anon_sym_DQUOTE] = ACTIONS(2449),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2451),
    [sym_raw_string] = ACTIONS(2445),
    [anon_sym_BQUOTE] = ACTIONS(2453),
    [anon_sym_DOLLAR] = ACTIONS(2455),
    [anon_sym_GT_LPAREN] = ACTIONS(2457),
    [sym_ansii_c_string] = ACTIONS(2445),
    [anon_sym_LT_LPAREN] = ACTIONS(2457),
    [sym__special_character] = ACTIONS(2445),
    [sym_comment] = ACTIONS(19),
  },
  [657] = {
    [aux_sym_concatenation_repeat1] = STATE(657),
    [sym_word] = ACTIONS(782),
    [anon_sym_AMP_GT_GT] = ACTIONS(782),
    [anon_sym_DOLLAR] = ACTIONS(782),
    [anon_sym_LT_LT] = ACTIONS(782),
    [anon_sym_LT_LPAREN] = ACTIONS(782),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(782),
    [sym__concat] = ACTIONS(2459),
    [anon_sym_PIPE] = ACTIONS(782),
    [anon_sym_LT] = ACTIONS(782),
    [anon_sym_LT_AMP] = ACTIONS(782),
    [anon_sym_GT_GT] = ACTIONS(782),
    [sym__special_character] = ACTIONS(782),
    [anon_sym_LT_LT_DASH] = ACTIONS(782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(782),
    [aux_sym__simple_variable_name_token1] = ACTIONS(782),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(782),
    [anon_sym_LF] = ACTIONS(784),
    [anon_sym_SEMI] = ACTIONS(782),
    [sym_raw_string] = ACTIONS(782),
    [sym_variable_name] = ACTIONS(784),
    [sym_file_descriptor] = ACTIONS(784),
    [anon_sym_AMP] = ACTIONS(782),
    [anon_sym_GT] = ACTIONS(782),
    [anon_sym_AMP_GT] = ACTIONS(782),
    [anon_sym_DQUOTE] = ACTIONS(782),
    [anon_sym_LT_LT_LT] = ACTIONS(782),
    [anon_sym_GT_AMP] = ACTIONS(782),
    [ts_builtin_sym_end] = ACTIONS(784),
    [anon_sym_BQUOTE] = ACTIONS(782),
    [anon_sym_GT_LPAREN] = ACTIONS(782),
    [sym_ansii_c_string] = ACTIONS(782),
    [anon_sym_AMP_AMP] = ACTIONS(782),
    [anon_sym_SEMI_SEMI] = ACTIONS(782),
    [anon_sym_PIPE_AMP] = ACTIONS(782),
  },
  [658] = {
    [sym_word] = ACTIONS(860),
    [anon_sym_AMP_GT_GT] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(860),
    [anon_sym_LT_LT] = ACTIONS(860),
    [anon_sym_LT_LPAREN] = ACTIONS(860),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(860),
    [sym__concat] = ACTIONS(862),
    [anon_sym_PIPE] = ACTIONS(860),
    [anon_sym_LT] = ACTIONS(860),
    [anon_sym_LT_AMP] = ACTIONS(860),
    [anon_sym_GT_GT] = ACTIONS(860),
    [sym__special_character] = ACTIONS(860),
    [anon_sym_LT_LT_DASH] = ACTIONS(860),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(860),
    [aux_sym__simple_variable_name_token1] = ACTIONS(860),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(860),
    [anon_sym_LF] = ACTIONS(862),
    [anon_sym_SEMI] = ACTIONS(860),
    [sym_raw_string] = ACTIONS(860),
    [sym_variable_name] = ACTIONS(862),
    [sym_file_descriptor] = ACTIONS(862),
    [anon_sym_AMP] = ACTIONS(860),
    [anon_sym_GT] = ACTIONS(860),
    [anon_sym_AMP_GT] = ACTIONS(860),
    [anon_sym_DQUOTE] = ACTIONS(860),
    [anon_sym_LT_LT_LT] = ACTIONS(860),
    [anon_sym_GT_AMP] = ACTIONS(860),
    [ts_builtin_sym_end] = ACTIONS(862),
    [anon_sym_BQUOTE] = ACTIONS(860),
    [anon_sym_GT_LPAREN] = ACTIONS(860),
    [sym_ansii_c_string] = ACTIONS(860),
    [anon_sym_AMP_AMP] = ACTIONS(860),
    [anon_sym_SEMI_SEMI] = ACTIONS(860),
    [anon_sym_PIPE_AMP] = ACTIONS(860),
  },
  [659] = {
    [sym_word] = ACTIONS(920),
    [anon_sym_AMP_GT_GT] = ACTIONS(920),
    [anon_sym_DOLLAR] = ACTIONS(920),
    [anon_sym_LT_LT] = ACTIONS(920),
    [anon_sym_LT_LPAREN] = ACTIONS(920),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(920),
    [sym__concat] = ACTIONS(922),
    [anon_sym_PIPE] = ACTIONS(920),
    [anon_sym_LT] = ACTIONS(920),
    [anon_sym_LT_AMP] = ACTIONS(920),
    [anon_sym_GT_GT] = ACTIONS(920),
    [sym__special_character] = ACTIONS(920),
    [anon_sym_LT_LT_DASH] = ACTIONS(920),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(920),
    [aux_sym__simple_variable_name_token1] = ACTIONS(920),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(920),
    [anon_sym_LF] = ACTIONS(922),
    [anon_sym_SEMI] = ACTIONS(920),
    [sym_raw_string] = ACTIONS(920),
    [sym_variable_name] = ACTIONS(922),
    [sym_file_descriptor] = ACTIONS(922),
    [anon_sym_AMP] = ACTIONS(920),
    [anon_sym_GT] = ACTIONS(920),
    [anon_sym_AMP_GT] = ACTIONS(920),
    [anon_sym_DQUOTE] = ACTIONS(920),
    [anon_sym_LT_LT_LT] = ACTIONS(920),
    [anon_sym_GT_AMP] = ACTIONS(920),
    [ts_builtin_sym_end] = ACTIONS(922),
    [anon_sym_BQUOTE] = ACTIONS(920),
    [anon_sym_GT_LPAREN] = ACTIONS(920),
    [sym_ansii_c_string] = ACTIONS(920),
    [anon_sym_AMP_AMP] = ACTIONS(920),
    [anon_sym_SEMI_SEMI] = ACTIONS(920),
    [anon_sym_PIPE_AMP] = ACTIONS(920),
  },
  [660] = {
    [sym_word] = ACTIONS(970),
    [anon_sym_AMP_GT_GT] = ACTIONS(970),
    [anon_sym_DOLLAR] = ACTIONS(970),
    [anon_sym_LT_LT] = ACTIONS(970),
    [anon_sym_LT_LPAREN] = ACTIONS(970),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(970),
    [sym__concat] = ACTIONS(972),
    [anon_sym_PIPE] = ACTIONS(970),
    [anon_sym_LT] = ACTIONS(970),
    [anon_sym_LT_AMP] = ACTIONS(970),
    [anon_sym_GT_GT] = ACTIONS(970),
    [sym__special_character] = ACTIONS(970),
    [anon_sym_LT_LT_DASH] = ACTIONS(970),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(970),
    [aux_sym__simple_variable_name_token1] = ACTIONS(970),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(970),
    [anon_sym_LF] = ACTIONS(972),
    [anon_sym_SEMI] = ACTIONS(970),
    [sym_raw_string] = ACTIONS(970),
    [sym_variable_name] = ACTIONS(972),
    [sym_file_descriptor] = ACTIONS(972),
    [anon_sym_AMP] = ACTIONS(970),
    [anon_sym_GT] = ACTIONS(970),
    [anon_sym_AMP_GT] = ACTIONS(970),
    [anon_sym_DQUOTE] = ACTIONS(970),
    [anon_sym_LT_LT_LT] = ACTIONS(970),
    [anon_sym_GT_AMP] = ACTIONS(970),
    [ts_builtin_sym_end] = ACTIONS(972),
    [anon_sym_BQUOTE] = ACTIONS(970),
    [anon_sym_GT_LPAREN] = ACTIONS(970),
    [sym_ansii_c_string] = ACTIONS(970),
    [anon_sym_AMP_AMP] = ACTIONS(970),
    [anon_sym_SEMI_SEMI] = ACTIONS(970),
    [anon_sym_PIPE_AMP] = ACTIONS(970),
  },
  [661] = {
    [aux_sym_concatenation_repeat1] = STATE(546),
    [sym_word] = ACTIONS(986),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(986),
    [anon_sym_AMP_GT_GT] = ACTIONS(986),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(986),
    [sym_raw_string] = ACTIONS(986),
    [anon_sym_DOLLAR] = ACTIONS(982),
    [sym_file_descriptor] = ACTIONS(986),
    [sym_variable_name] = ACTIONS(986),
    [anon_sym_GT] = ACTIONS(982),
    [anon_sym_LT_LPAREN] = ACTIONS(986),
    [anon_sym_AMP_GT] = ACTIONS(982),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(986),
    [sym__concat] = ACTIONS(367),
    [anon_sym_GT_AMP] = ACTIONS(986),
    [anon_sym_LT] = ACTIONS(982),
    [anon_sym_LT_AMP] = ACTIONS(986),
    [anon_sym_GT_GT] = ACTIONS(986),
    [sym_ansii_c_string] = ACTIONS(986),
    [anon_sym_BQUOTE] = ACTIONS(986),
    [anon_sym_GT_LPAREN] = ACTIONS(986),
    [sym__special_character] = ACTIONS(986),
  },
  [662] = {
    [sym_word] = ACTIONS(986),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(986),
    [anon_sym_AMP_GT_GT] = ACTIONS(986),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(986),
    [sym_raw_string] = ACTIONS(986),
    [anon_sym_DOLLAR] = ACTIONS(982),
    [sym_file_descriptor] = ACTIONS(986),
    [sym_variable_name] = ACTIONS(986),
    [anon_sym_GT] = ACTIONS(982),
    [anon_sym_LT_LPAREN] = ACTIONS(986),
    [anon_sym_AMP_GT] = ACTIONS(982),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(986),
    [anon_sym_GT_AMP] = ACTIONS(986),
    [anon_sym_LT] = ACTIONS(982),
    [anon_sym_LT_AMP] = ACTIONS(986),
    [anon_sym_GT_GT] = ACTIONS(986),
    [sym_ansii_c_string] = ACTIONS(986),
    [anon_sym_BQUOTE] = ACTIONS(986),
    [anon_sym_GT_LPAREN] = ACTIONS(986),
    [sym__special_character] = ACTIONS(986),
  },
  [663] = {
    [aux_sym__literal_repeat1] = STATE(564),
    [sym_word] = ACTIONS(1010),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1010),
    [anon_sym_AMP_GT_GT] = ACTIONS(1010),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1010),
    [sym_raw_string] = ACTIONS(1010),
    [anon_sym_DOLLAR] = ACTIONS(1006),
    [sym_file_descriptor] = ACTIONS(1010),
    [sym_variable_name] = ACTIONS(1010),
    [anon_sym_GT] = ACTIONS(1006),
    [anon_sym_LT_LPAREN] = ACTIONS(1010),
    [anon_sym_AMP_GT] = ACTIONS(1006),
    [sym_comment] = ACTIONS(19),
    [anon_sym_DQUOTE] = ACTIONS(1010),
    [anon_sym_GT_AMP] = ACTIONS(1010),
    [anon_sym_LT] = ACTIONS(1006),
    [anon_sym_LT_AMP] = ACTIONS(1010),
    [anon_sym_GT_GT] = ACTIONS(1010),
    [sym_ansii_c_string] = ACTIONS(1010),
    [anon_sym_BQUOTE] = ACTIONS(1010),
    [anon_sym_GT_LPAREN] = ACTIONS(1010),
    [sym__special_character] = ACTIONS(373),
  },
  [664] = {
    [sym_word] = ACTIONS(1032),
    [anon_sym_AMP_GT_GT] = ACTIONS(1032),
    [anon_sym_DOLLAR] = ACTIONS(1032),
    [anon_sym_LT_LT] = ACTIONS(1032),
    [anon_sym_LT_LPAREN] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1032),
    [sym__concat] = ACTIONS(1034),
    [anon_sym_PIPE] = ACTIONS(1032),
    [anon_sym_LT] = ACTIONS(1032),
    [anon_sym_LT_AMP] = ACTIONS(1032),
    [anon_sym_GT_GT] = ACTIONS(1032),
    [sym__special_character] = ACTIONS(1032),
    [anon_sym_LT_LT_DASH] = ACTIONS(1032),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1032),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1032),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1032),
    [anon_sym_LF] = ACTIONS(1034),
    [anon_sym_SEMI] = ACTIONS(1032),
    [sym_raw_string] = ACTIONS(1032),
    [sym_variable_name] = ACTIONS(1034),
    [sym_file_descriptor] = ACTIONS(1034),
    [anon_sym_AMP] = ACTIONS(1032),
    [anon_sym_GT] = ACTIONS(1032),
    [anon_sym_AMP_GT] = ACTIONS(1032),
    [anon_sym_DQUOTE] = ACTIONS(1032),
    [anon_sym_LT_LT_LT] = ACTIONS(1032),
    [anon_sym_GT_AMP] = ACTIONS(1032),
    [ts_builtin_sym_end] = ACTIONS(1034),
    [anon_sym_BQUOTE] = ACTIONS(1032),
    [anon_sym_GT_LPAREN] = ACTIONS(1032),
    [sym_ansii_c_string] = ACTIONS(1032),
    [anon_sym_AMP_AMP] = ACTIONS(1032),
    [anon_sym_SEMI_SEMI] = ACTIONS(1032),
    [anon_sym_PIPE_AMP] = ACTIONS(1032),
  },
  [665] = {
    [sym_word] = ACTIONS(1036),
    [anon_sym_AMP_GT_GT] = ACTIONS(1036),
    [anon_sym_DOLLAR] = ACTIONS(1036),
    [anon_sym_LT_LT] = ACTIONS(1036),
    [anon_sym_LT_LPAREN] = ACTIONS(1036),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1036),
    [sym__concat] = ACTIONS(1038),
    [anon_sym_PIPE] = ACTIONS(1036),
    [anon_sym_LT] = ACTIONS(1036),
    [anon_sym_LT_AMP] = ACTIONS(1036),
    [anon_sym_GT_GT] = ACTIONS(1036),
    [sym__special_character] = ACTIONS(1036),
    [anon_sym_LT_LT_DASH] = ACTIONS(1036),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1036),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1036),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1036),
    [anon_sym_LF] = ACTIONS(1038),
    [anon_sym_SEMI] = ACTIONS(1036),
    [sym_raw_string] = ACTIONS(1036),
    [sym_variable_name] = ACTIONS(1038),
    [sym_file_descriptor] = ACTIONS(1038),
    [anon_sym_AMP] = ACTIONS(1036),
    [anon_sym_GT] = ACTIONS(1036),
    [anon_sym_AMP_GT] = ACTIONS(1036),
    [anon_sym_DQUOTE] = ACTIONS(1036),
    [anon_sym_LT_LT_LT] = ACTIONS(1036),
    [anon_sym_GT_AMP] = ACTIONS(1036),
    [ts_builtin_sym_end] = ACTIONS(1038),
    [anon_sym_BQUOTE] = ACTIONS(1036),
    [anon_sym_GT_LPAREN] = ACTIONS(1036),
    [sym_ansii_c_string] = ACTIONS(1036),
    [anon_sym_AMP_AMP] = ACTIONS(1036),
    [anon_sym_SEMI_SEMI] = ACTIONS(1036),
    [anon_sym_PIPE_AMP] = ACTIONS(1036),
  },
  [666] = {
    [sym_word] = ACTIONS(1032),
    [anon_sym_AMP_GT_GT] = ACTIONS(1032),
    [anon_sym_DOLLAR] = ACTIONS(1032),
    [anon_sym_LT_LT] = ACTIONS(1032),
    [anon_sym_LT_LPAREN] = ACTIONS(1032),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1032),
    [sym__concat] = ACTIONS(1034),
    [anon_sym_PIPE] = ACTIONS(1032),
    [anon_sym_LT] = ACTIONS(1032),
    [anon_sym_LT_AMP] = ACTIONS(1032),
    [anon_sym_GT_GT] = ACTIONS(1032),
    [sym__special_character] = ACTIONS(1032),
    [anon_sym_LT_LT_DASH] = ACTIONS(1032),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1032),
    [aux_sym__simple_variable_name_token1] = ACTIONS(1032),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1032),
    [anon_sym_LF] = ACTIONS(1034),
    [anon_sym_SEMI] = ACTIONS(1032),
    [sym_raw_string] = ACTIONS(1032),
    [sym_variable_name] = ACTIONS(1034),
    [sym_file_descriptor] = ACTIONS(1034),
    [anon_sym_AMP] = ACTIONS(1032),
    [anon_sym_GT] = ACTIONS(1032),
    [anon_sym_AMP_GT] = ACTIONS(1032),
    [anon_sym_DQUOTE] = ACTIONS(1032),
    [anon_sym_LT_LT_LT] = ACTIONS(1032),
    [anon_sym_GT_AMP] = ACTIONS(1032),
    [ts_builtin_sym_end] = ACTIONS(1034),
    [anon_sym_BQUOTE] = ACTIONS(1032),
    [anon_sym_GT_LPAREN] = ACTIONS(1032),
    [sym_ansii_c_string] = ACTIONS(1032),
    [anon_sym_AMP_AMP] = ACTIONS(1032),
    [anon_sym_SEMI_SEMI] = ACTIONS(1032),
    [anon_sym_PIPE_AMP] = ACTIONS(1032),
  },
  [667] = {
    [sym_heredoc_redirect] = STATE(2622),
    [aux_sym_redirected_statement_repeat1] = STATE(2622),
    [sym_herestring_redirect] = STATE(2622),
    [sym_file_redirect] = STATE(2622),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(1093),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(1093),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1093),
    [anon_sym_PIPE] = ACTIONS(1093),
    [anon_sym_LT] = ACTIONS(1093),
    [anon_sym_LT_AMP] = ACTIONS(1093),
    [anon_sym_GT_GT] = ACTIONS(1093),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(1093),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(1095),
    [anon_sym_SEMI] = ACTIONS(1093),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(1095),
    [anon_sym_AMP] = ACTIONS(1093),
    [anon_sym_GT] = ACTIONS(1093),
    [anon_sym_AMP_GT] = ACTIONS(1093),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(1093),
    [anon_sym_GT_AMP] = ACTIONS(1093),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_esac] = ACTIONS(1093),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(1093),
    [anon_sym_SEMI_SEMI] = ACTIONS(1093),
    [anon_sym_PIPE_AMP] = ACTIONS(1093),
  },
  [668] = {
    [anon_sym_AMP] = ACTIONS(2085),
    [anon_sym_LF] = ACTIONS(2087),
    [anon_sym_SEMI] = ACTIONS(2085),
    [anon_sym_SEMI_SEMI] = ACTIONS(2083),
    [sym_comment] = ACTIONS(3),
  },
  [669] = {
    [sym_heredoc_redirect] = STATE(2622),
    [aux_sym_redirected_statement_repeat1] = STATE(2622),
    [sym_herestring_redirect] = STATE(2622),
    [sym_file_redirect] = STATE(2622),
    [anon_sym_LT_LT_DASH] = ACTIONS(1123),
    [anon_sym_AMP_GT_GT] = ACTIONS(1123),
    [anon_sym_LF] = ACTIONS(1125),
    [anon_sym_SEMI] = ACTIONS(1123),
    [anon_sym_LT_LT] = ACTIONS(1123),
    [anon_sym_AMP] = ACTIONS(1123),
    [anon_sym_GT] = ACTIONS(1123),
    [sym_file_descriptor] = ACTIONS(1125),
    [anon_sym_AMP_GT] = ACTIONS(1123),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1123),
    [anon_sym_LT_LT_LT] = ACTIONS(1123),
    [anon_sym_PIPE] = ACTIONS(2214),
    [anon_sym_GT_AMP] = ACTIONS(1123),
    [anon_sym_LT] = ACTIONS(1123),
    [anon_sym_esac] = ACTIONS(1123),
    [anon_sym_GT_GT] = ACTIONS(1123),
    [anon_sym_LT_AMP] = ACTIONS(1123),
    [anon_sym_AMP_AMP] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(1123),
    [anon_sym_PIPE_AMP] = ACTIONS(2214),
  },
  [670] = {
    [sym_heredoc_redirect] = STATE(2622),
    [aux_sym_redirected_statement_repeat1] = STATE(2622),
    [sym_herestring_redirect] = STATE(2622),
    [sym_file_redirect] = STATE(2622),
    [sym_word] = ACTIONS(323),
    [anon_sym_AMP_GT_GT] = ACTIONS(323),
    [anon_sym_DOLLAR] = ACTIONS(323),
    [anon_sym_LT_LT] = ACTIONS(1123),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1123),
    [anon_sym_PIPE] = ACTIONS(2214),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_LT_AMP] = ACTIONS(323),
    [anon_sym_GT_GT] = ACTIONS(323),
    [sym__special_character] = ACTIONS(323),
    [anon_sym_LT_LT_DASH] = ACTIONS(1123),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(323),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(323),
    [sym_raw_string] = ACTIONS(323),
    [anon_sym_LF] = ACTIONS(1125),
    [anon_sym_SEMI] = ACTIONS(1123),
    [sym_variable_name] = ACTIONS(325),
    [sym_file_descriptor] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(1123),
    [anon_sym_GT] = ACTIONS(323),
    [anon_sym_AMP_GT] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(323),
    [anon_sym_LT_LT_LT] = ACTIONS(1123),
    [anon_sym_GT_AMP] = ACTIONS(323),
    [anon_sym_BQUOTE] = ACTIONS(323),
    [anon_sym_esac] = ACTIONS(1123),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_ansii_c_string] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(1123),
    [anon_sym_SEMI_SEMI] = ACTIONS(1123),
    [anon_sym_PIPE_AMP] = ACTIONS(2214),
  },
  [671] = {
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_esac] = ACTIONS(2083),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
    [anon_sym_SEMI_SEMI] = ACTIONS(1113),
  },
  [672] = {
    [sym_heredoc_body] = STATE(618),
    [anon_sym_LPAREN] = ACTIONS(636),
    [sym_word] = ACTIONS(636),
    [anon_sym_AMP_GT_GT] = ACTIONS(638),
    [anon_sym_local] = ACTIONS(636),
    [anon_sym_typeset] = ACTIONS(636),
    [anon_sym_unsetenv] = ACTIONS(636),
    [anon_sym_DOLLAR] = ACTIONS(636),
    [anon_sym_LT_LPAREN] = ACTIONS(638),
    [sym_comment] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_LT_AMP] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(638),
    [anon_sym_export] = ACTIONS(636),
    [sym__simple_heredoc_body] = ACTIONS(870),
    [sym__special_character] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(638),
    [sym_raw_string] = ACTIONS(638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_declare] = ACTIONS(636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(638),
    [sym_file_descriptor] = ACTIONS(638),
    [sym_variable_name] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(636),
    [sym__heredoc_body_beginning] = ACTIONS(872),
    [anon_sym_AMP_GT] = ACTIONS(636),
    [anon_sym_readonly] = ACTIONS(636),
    [anon_sym_unset] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_GT_AMP] = ACTIONS(638),
    [anon_sym_BQUOTE] = ACTIONS(638),
    [anon_sym_esac] = ACTIONS(2083),
    [anon_sym_GT_LPAREN] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_LBRACK] = ACTIONS(636),
    [sym_ansii_c_string] = ACTIONS(638),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(638),
    [anon_sym_SEMI_SEMI] = ACTIONS(1113),
  },
  [673] = {
    [sym_command_substitution] = STATE(572),
    [aux_sym__literal_repeat1] = STATE(574),
    [sym_string] = STATE(572),
    [sym_process_substitution] = STATE(572),
    [sym_simple_expansion] = STATE(572),
    [sym_string_expansion] = STATE(572),
    [aux_sym_command_repeat2] = STATE(607),
    [sym_concatenation] = STATE(607),
    [sym_expansion] = STATE(572),
    [sym_word] = ACTIONS(2418),
    [anon_sym_AMP_GT_GT] = ACTIONS(1155),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_LT_LT] = ACTIONS(1155),
    [anon_sym_LT_LPAREN] = ACTIONS(2420),
    [sym_comment] = ACTIONS(3),
    [anon_sym_PIPE_PIPE] = ACTIONS(1155),
    [anon_sym_PIPE] = ACTIONS(1155),
    [anon_sym_LT] = ACTIONS(1155),
    [anon_sym_LT_AMP] = ACTI