/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.LocaleProviderAdapter;

public class TimeZoneNameProviderImpl
extends TimeZoneNameProvider {
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    TimeZoneNameProviderImpl(LocaleProviderAdapter.Type type, Set<String> set) {
        this.type = type;
        this.langtags = set;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return LocaleProviderAdapter.isSupportedLocale(locale, this.type, this.langtags);
    }

    @Override
    public String getDisplayName(String string, boolean bl, int n, Locale locale) {
        String[] stringArray = this.getDisplayNameArray(string, locale);
        if (Objects.nonNull(stringArray)) {
            int n2;
            assert (stringArray.length >= 7);
            int n3 = n2 = bl ? 3 : 1;
            if (n == 0) {
                ++n2;
            }
            return stringArray[n2];
        }
        return null;
    }

    @Override
    public String getGenericDisplayName(String string, int n, Locale locale) {
        String[] stringArray = this.getDisplayNameArray(string, locale);
        if (Objects.nonNull(stringArray)) {
            assert (stringArray.length >= 7);
            return stringArray[n == 1 ? 5 : 6];
        }
        return null;
    }

    private String[] getDisplayNameArray(String string, Locale locale) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(locale);
        return LocaleProviderAdapter.forType(this.type).getLocaleResources(locale).getTimeZoneNames(string);
    }

    String[][] getZoneStrings(Locale locale) {
        return LocaleProviderAdapter.forType(this.type).getLocaleResources(locale).getZoneStrings();
    }
}

