/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.DTP;
import gnu.inet.ftp.DTPInputStream;
import java.io.IOException;
import java.io.InputStream;

class BlockInputStream
extends DTPInputStream {
    static final int EOF = 64;
    int descriptor;
    int max = -1;
    int count = -1;

    BlockInputStream(DTP dTP, InputStream inputStream) {
        super(dTP, inputStream);
    }

    @Override
    public int read() throws IOException {
        if (this.transferComplete) {
            return -1;
        }
        if (this.count == -1) {
            this.readHeader();
        }
        if (this.max < 1) {
            this.close();
            return -1;
        }
        int n = this.in.read();
        if (n == -1) {
            this.dtp.transferComplete();
        }
        ++this.count;
        if (this.count >= this.max) {
            this.count = -1;
            if (this.descriptor == 64) {
                this.close();
            }
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.transferComplete) {
            return -1;
        }
        if (this.count == -1) {
            this.readHeader();
        }
        if (this.max < 1) {
            this.close();
            return -1;
        }
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1) {
            this.dtp.transferComplete();
        }
        this.count += n3;
        if (this.count >= this.max) {
            this.count = -1;
            if (this.descriptor == 64) {
                this.close();
            }
        }
        return n3;
    }

    void readHeader() throws IOException {
        this.descriptor = this.in.read();
        int n = this.in.read();
        int n2 = this.in.read();
        this.max = n << 8 | n2;
        this.count = 0;
    }
}

