// Boost.Geometry (aka GGL, Generic Geometry Library)

// Copyright (c) 2008-2012 Barend Gehrels, Amsterdam, the Netherlands.

// This file was modified by Oracle on 2017, 2018.
// Modifications copyright (c) 2017-2018, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_GEOMETRY_PROJECTIONS_EPSG_TRAITS_HPP
#define BOOST_GEOMETRY_PROJECTIONS_EPSG_TRAITS_HPP


#include <boost/geometry/core/tags.hpp>

#include <boost/geometry/srs/projections/factory.hpp>
#include <boost/geometry/srs/projections/impl/projects.hpp>
#include <boost/geometry/srs/projections/spar.hpp>
#include <boost/geometry/srs/projections/srid_traits.hpp>


namespace boost { namespace geometry { namespace projections
{

#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

/*!
    \brief EPSG traits
    \details With help of the EPSG traits library users can statically use projections
        or coordinate systems specifying an EPSG code. The correct projections for transformations
        are used automically then, still keeping static polymorphism.
    \ingroup projection
    \tparam EPSG epsg code
*/
template <int EPSG>
struct epsg_traits
{
    // Specializations define:
    // - type to get projection type
    // - function par to get parameters
};

BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2000) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-62),srs::spar::k<>(0.9995000000000001),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2001) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-62),srs::spar::k<>(0.9995000000000001),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2002) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-62),srs::spar::k<>(0.9995000000000001),srs::spar::x_0<>(400000),srs::spar::y_0<>(0),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(725,685,536,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2003) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-62),srs::spar::k<>(0.9995000000000001),srs::spar::x_0<>(400000),srs::spar::y_0<>(0),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(72,213.7,93,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2004) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-62),srs::spar::k<>(0.9995000000000001),srs::spar::x_0<>(400000),srs::spar::y_0<>(0),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(174,359,365,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2005) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-62),srs::spar::k<>(0.9995000000000001),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2006) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-62),srs::spar::k<>(0.9995000000000001),srs::spar::x_0<>(400000),srs::spar::y_0<>(0),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-149,128,296,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2007) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-62),srs::spar::k<>(0.9995000000000001),srs::spar::x_0<>(400000),srs::spar::y_0<>(0),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(195.671,332.517,274.607,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2008) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-55.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2009) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-58.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2010) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-61.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2011) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-64.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2012) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-67.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2013) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-70.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2014) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-73.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2015) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-76.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2016) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-79.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2017) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-73.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2018) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-76.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2019) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-79.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2020) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-82.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2021) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-81),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2022) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-84),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2023) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-87),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2024) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-90),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2025) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-93),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2026) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-96),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2027) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<15>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2028) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<16>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2029) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<17>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2030) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<18>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2031) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<17>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2032) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<18>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2033) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<19>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2034) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2035) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<21>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2036) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(46.5),srs::spar::lon_0<>(-66.5),srs::spar::k<>(0.999912),srs::spar::x_0<>(2500000),srs::spar::y_0<>(7500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2037) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<19>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<19>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2038) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<20>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2039) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31.73439361111111),srs::spar::lon_0<>(35.20451694444445),srs::spar::k<>(1.0000067),srs::spar::x_0<>(219529.584),srs::spar::y_0<>(626907.39),srs::spar::ellps_grs80(),srs::spar::towgs84<>(-48,55,52,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2040) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<30>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<30>(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-125,53,467,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2041) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<30>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<30>(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-124.76,53,466.79,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2042) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<29>(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-125,53,467,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2043) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<29>(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-124.76,53,466.79,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2044) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(18500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(-17.51,-108.32,-62.39,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2045) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(19500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(-17.51,-108.32,-62.39,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2046)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2047)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2048)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2049)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2050)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2051)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2052)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2053)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2054)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2055)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2056) srs::spar::parameters<srs::spar::proj_somerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_somerc(),srs::spar::lat_0<>(46.95240555555556),srs::spar::lon_0<>(7.439583333333333),srs::spar::k_0<>(1),srs::spar::x_0<>(2600000),srs::spar::y_0<>(1200000),srs::spar::ellps_bessel(),srs::spar::towgs84<>(674.374,15.056,405.346,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2057) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(27.51882880555555),srs::spar::lonc<>(52.60353916666667),srs::spar::alpha<>(0.5716611944444444),srs::spar::k<>(0.999895934),srs::spar::x_0<>(658377.437),srs::spar::y_0<>(3044969.194),srs::spar::ellps_intl(),srs::spar::towgs84<>(-133.63,-157.5,-158.62,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2058) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<38>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2059) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<39>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2060) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<40>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2061) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<41>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2062) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::pm_madrid,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40),srs::spar::lat_0<>(40),srs::spar::lon_0<>(0),srs::spar::k_0<>(0.9988085293),srs::spar::x_0<>(600000),srs::spar::y_0<>(600000),srs::spar::a<>(6378298.3),srs::spar::b<>(6356657.142669561)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2063) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<28>(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356515),srs::spar::towgs84<>(-23,259,-9,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2064) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<29>(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356515),srs::spar::towgs84<>(-23,259,-9,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2065) srs::spar::parameters<srs::spar::proj_krovak,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::pm_ferro,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_krovak(),srs::spar::lat_0<>(49.5),srs::spar::lon_0<>(42.5),srs::spar::alpha<>(30.28813972222222),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2066) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(11.25217861111111),srs::spar::lon_0<>(-60.68600888888889),srs::spar::x_0<>(37718.66159325),srs::spar::y_0<>(36209.91512952),srs::spar::a<>(6378293.645208759),srs::spar::b<>(6356617.987679838),srs::spar::to_meter<>(0.201166195164)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2067) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2068) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(9),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2069) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(11),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2070) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(13),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2071) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2072) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(17),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2073) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(19),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2074) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2075) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(23),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2076) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(25),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2077) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<32>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2078) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<33>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2079) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<34>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2080) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<35>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2081) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-69),srs::spar::k<>(1),srs::spar::x_0<>(2500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2082) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-69),srs::spar::k<>(1),srs::spar::x_0<>(2500000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(27.5,14,186.4,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2083) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-69),srs::spar::k<>(1),srs::spar::x_0<>(2500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2084) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<19>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2085) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(22.35),srs::spar::lat_0<>(22.35),srs::spar::lon_0<>(-81),srs::spar::k_0<>(0.99993602),srs::spar::x_0<>(500000),srs::spar::y_0<>(280296.016)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2086) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(20.71666666666667),srs::spar::lat_0<>(20.71666666666667),srs::spar::lon_0<>(-76.83333333333333),srs::spar::k_0<>(0.99994848),srs::spar::x_0<>(500000),srs::spar::y_0<>(229126.939)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2087) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(12),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2088) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(11),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378249.2),srs::spar::b<>(6356515)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2089) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<38>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<38>(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2090) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<39>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<39>(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2091) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(8500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(-76,-138,67,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2092) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(51),srs::spar::k<>(1),srs::spar::x_0<>(9500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(-76,-138,67,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2093) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(106),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(-17.51,-108.32,-62.39,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2094) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs72,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(106),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_wgs72(),srs::spar::towgs84<>(0,0,1.9,0,0,0.814,-0.38)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2095) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<28>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-173,253,27,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2096) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(200000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2097) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38),srs::spar::lon_0<>(127),srs::spar::k<>(1),srs::spar::x_0<>(200000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2098) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38),srs::spar::lon_0<>(125),srs::spar::k<>(1),srs::spar::x_0<>(200000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2099) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_helmert,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(25.38236111111111),srs::spar::lon_0<>(50.76138888888889),srs::spar::x_0<>(100000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2100) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(-199.87,74.79,246.62,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2101) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(10.16666666666667),srs::spar::lat_0<>(10.16666666666667),srs::spar::lon_0<>(-71.60561777777777),srs::spar::k_0<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(-52684.972)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2102) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(10.16666666666667),srs::spar::lat_0<>(10.16666666666667),srs::spar::lon_0<>(-71.60561777777777),srs::spar::k_0<>(1),srs::spar::x_0<>(200000),srs::spar::y_0<>(147315.028)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2103) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(10.16666666666667),srs::spar::lat_0<>(10.16666666666667),srs::spar::lon_0<>(-71.60561777777777),srs::spar::k_0<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(447315.028)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2104) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(10.16666666666667),srs::spar::lat_0<>(10.16666666666667),srs::spar::lon_0<>(-71.60561777777777),srs::spar::k_0<>(1),srs::spar::x_0<>(-17044),srs::spar::y_0<>(-23139.97)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2105) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-36.87972222222222),srs::spar::lon_0<>(174.7641666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2106) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-37.76111111111111),srs::spar::lon_0<>(176.4661111111111),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2107) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-38.62444444444444),srs::spar::lon_0<>(177.8855555555556),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2108) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-39.65083333333333),srs::spar::lon_0<>(176.6736111111111),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2109) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-39.13555555555556),srs::spar::lon_0<>(174.2277777777778),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2110) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-39.51222222222222),srs::spar::lon_0<>(175.64),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2111) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-40.24194444444444),srs::spar::lon_0<>(175.4880555555555),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2112) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-40.92527777777777),srs::spar::lon_0<>(175.6472222222222),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2113) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-41.3011111111111),srs::spar::lon_0<>(174.7763888888889),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2114) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-40.71472222222223),srs::spar::lon_0<>(172.6719444444444),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2115) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-41.27444444444444),srs::spar::lon_0<>(173.2991666666667),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2116) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-41.28972222222222),srs::spar::lon_0<>(172.1088888888889),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2117) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-41.81055555555555),srs::spar::lon_0<>(171.5811111111111),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2118) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-42.33361111111111),srs::spar::lon_0<>(171.5497222222222),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2119) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-42.68888888888888),srs::spar::lon_0<>(173.01),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2120) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-41.54444444444444),srs::spar::lon_0<>(173.8019444444444),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2121) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-42.88611111111111),srs::spar::lon_0<>(170.9797222222222),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2122) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-43.11),srs::spar::lon_0<>(170.2608333333333),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2123) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-43.97777777777778),srs::spar::lon_0<>(168.6061111111111),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2124) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-43.59055555555556),srs::spar::lon_0<>(172.7269444444445),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2125) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-43.74861111111111),srs::spar::lon_0<>(171.3605555555555),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2126) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-44.40194444444445),srs::spar::lon_0<>(171.0572222222222),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2127) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-44.735),srs::spar::lon_0<>(169.4675),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2128) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-45.13277777777778),srs::spar::lon_0<>(168.3986111111111),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2129) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-45.56361111111111),srs::spar::lon_0<>(167.7386111111111),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2130) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-45.81611111111111),srs::spar::lon_0<>(170.6283333333333),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2131) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-45.86138888888889),srs::spar::lon_0<>(170.2825),srs::spar::k<>(0.99996),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2132) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-46.6),srs::spar::lon_0<>(168.3427777777778),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2133) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<58>(),srs::spar::south(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2134) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<59>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<59>(),srs::spar::south(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2135) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<60>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<60>(),srs::spar::south(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2136) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(4.666666666666667),srs::spar::lon_0<>(-1),srs::spar::k<>(0.99975),srs::spar::x_0<>(274319.7391633579),srs::spar::y_0<>(0),srs::spar::a<>(6378300),srs::spar::b<>(6356751.689189189),srs::spar::towgs84<>(-199,32,322,0,0,0,0),srs::spar::to_meter<>(0.3047997101815088)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2137) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-1),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378300),srs::spar::b<>(6356751.689189189),srs::spar::towgs84<>(-199,32,322,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2138) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(60),srs::spar::lat_2<>(46),srs::spar::lat_0<>(44),srs::spar::lon_0<>(-68.5),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2139) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-55.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2140) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-58.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2141) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-61.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2142) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-64.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2143) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-67.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2144) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-70.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2145) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-73.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2146) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-76.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2147) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-79.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2148) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<21>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<21>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2149) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<18>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<18>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2150) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<17>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<17>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2151) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<13>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<13>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2152) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<12>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<12>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2153) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<11>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<11>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2154) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49),srs::spar::lat_2<>(44),srs::spar::lat_0<>(46.5),srs::spar::lon_0<>(3),srs::spar::x_0<>(700000),srs::spar::y_0<>(6600000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2155) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-14.26666666666667),srs::spar::lat_0<>(-14.26666666666667),srs::spar::lon_0<>(170),srs::spar::k_0<>(1),srs::spar::x_0<>(152400.3048006096),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(-115,118,426,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2156) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<59>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2157) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(53.5),srs::spar::lon_0<>(-8),srs::spar::k<>(0.99982),srs::spar::x_0<>(600000),srs::spar::y_0<>(750000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2158) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<29>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2159) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(6.666666666666667),srs::spar::lon_0<>(-12),srs::spar::k<>(1),srs::spar::x_0<>(152399.8550907544),srs::spar::y_0<>(0),srs::spar::a<>(6378300),srs::spar::b<>(6356751.689189189),srs::spar::to_meter<>(0.3047997101815088)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2160) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(6.666666666666667),srs::spar::lon_0<>(-12),srs::spar::k<>(1),srs::spar::x_0<>(243839.7681452071),srs::spar::y_0<>(182879.8261089053),srs::spar::a<>(6378300),srs::spar::b<>(6356751.689189189),srs::spar::to_meter<>(0.3047997101815088)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2161) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<28>(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-88,4,101,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2162) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<29>(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-88,4,101,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2163) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(45),srs::spar::lon_0<>(-100),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6370997)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-5),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-125,53,467,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-5),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-124.76,53,466.79,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2166) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(9),srs::spar::k<>(1),srs::spar::x_0<>(3500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2167) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(12),srs::spar::k<>(1),srs::spar::x_0<>(4500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2168) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(1),srs::spar::x_0<>(5500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2169) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(49.83333333333334),srs::spar::lon_0<>(6.166666666666667),srs::spar::k<>(1),srs::spar::x_0<>(80000),srs::spar::y_0<>(100000),srs::spar::ellps_intl(),srs::spar::towgs84<>(-193,13.7,-39.3,-0.41,-2.933,2.688,0.43)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2170) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_bessel(),srs::spar::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2171) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(50.625),srs::spar::lon_0<>(21.08333333333333),srs::spar::k<>(0.9998),srs::spar::x_0<>(4637000),srs::spar::y_0<>(5647000),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2172) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(53.00194444444445),srs::spar::lon_0<>(21.50277777777778),srs::spar::k<>(0.9998),srs::spar::x_0<>(4603000),srs::spar::y_0<>(5806000),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2173) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(53.58333333333334),srs::spar::lon_0<>(17.00833333333333),srs::spar::k<>(0.9998),srs::spar::x_0<>(3501000),srs::spar::y_0<>(5999000),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2174) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(51.67083333333333),srs::spar::lon_0<>(16.67222222222222),srs::spar::k<>(0.9998),srs::spar::x_0<>(3703000),srs::spar::y_0<>(5627000),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2175) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18.95833333333333),srs::spar::k<>(0.999983),srs::spar::x_0<>(237000),srs::spar::y_0<>(-4700000),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2176) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(0.999923),srs::spar::x_0<>(5500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2177) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18),srs::spar::k<>(0.999923),srs::spar::x_0<>(6500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2178) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(0.999923),srs::spar::x_0<>(7500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2179) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(0.999923),srs::spar::x_0<>(8500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2180) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(19),srs::spar::k<>(0.9993),srs::spar::x_0<>(500000),srs::spar::y_0<>(-5300000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2188) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<25>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2189) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<26>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<26>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-104,167,-38,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2190) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<26>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<26>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-203,141,53,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2191) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2192) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46.8),srs::spar::lat_0<>(46.8),srs::spar::lon_0<>(2.337229166666667),srs::spar::k_0<>(0.99987742),srs::spar::x_0<>(600000),srs::spar::y_0<>(2200000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2193) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(173),srs::spar::k<>(0.9996),srs::spar::x_0<>(1600000),srs::spar::y_0<>(10000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2194) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-14.26666666666667),srs::spar::lat_0<>(-14.26666666666667),srs::spar::lon_0<>(-170),srs::spar::k_0<>(1),srs::spar::x_0<>(152400.3048006096),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(-115,118,426,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2195) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<2>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2196) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(9.5),srs::spar::k<>(0.99995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2197) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(12),srs::spar::k<>(0.99995),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2198) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(1),srs::spar::x_0<>(900000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2199) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(4500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2200) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(46.5),srs::spar::lon_0<>(-66.5),srs::spar::k<>(0.999912),srs::spar::x_0<>(300000),srs::spar::y_0<>(800000),srs::spar::a<>(6378135),srs::spar::b<>(6356750.304921594)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2201) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<18>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<18>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2202) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<19>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<19>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2203) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<20>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2204) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.25),srs::spar::lat_2<>(36.41666666666666),srs::spar::lat_0<>(34.66666666666666),srs::spar::lon_0<>(-86),srs::spar::x_0<>(609601.2192024384),srs::spar::y_0<>(30480.06096012192),srs::spar::ellps_clrk66(),srs::spar::datum_nad27(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2205) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(38.96666666666667),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-84.25),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2206) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(9500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2207) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(30),srs::spar::k<>(1),srs::spar::x_0<>(10500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2208) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(33),srs::spar::k<>(1),srs::spar::x_0<>(11500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2209) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(36),srs::spar::k<>(1),srs::spar::x_0<>(12500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2210) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(39),srs::spar::k<>(1),srs::spar::x_0<>(13500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2211) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(42),srs::spar::k<>(1),srs::spar::x_0<>(14500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2212) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(15500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2213) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(30),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2214) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(10.5),srs::spar::k<>(0.999),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000),srs::spar::ellps_intl(),srs::spar::towgs84<>(-206.1,-174.7,-87.7,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2215) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<32>,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<32>(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356515),srs::spar::towgs84<>(-70.9,-151.8,-41.4,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2216) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<22>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2217) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<23>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2218)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2219) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<19>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<19>(),srs::spar::a<>(6378135),srs::spar::b<>(6356750.304921594)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2220) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<20>(),srs::spar::a<>(6378135),srs::spar::b<>(6356750.304921594)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2221)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2222) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-110.1666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2223) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-111.9166666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2224) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-113.75),srs::spar::k<>(0.999933333),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2225) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.66666666666666),srs::spar::lat_2<>(40),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2226) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.83333333333334),srs::spar::lat_2<>(38.33333333333334),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2227) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.43333333333333),srs::spar::lat_2<>(37.06666666666667),srs::spar::lat_0<>(36.5),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2228) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.25),srs::spar::lat_2<>(36),srs::spar::lat_0<>(35.33333333333334),srs::spar::lon_0<>(-119),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2229) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.46666666666667),srs::spar::lat_2<>(34.03333333333333),srs::spar::lat_0<>(33.5),srs::spar::lon_0<>(-118),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2230) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.88333333333333),srs::spar::lat_2<>(32.78333333333333),srs::spar::lat_0<>(32.16666666666666),srs::spar::lon_0<>(-116.25),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2231) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.78333333333333),srs::spar::lat_2<>(39.71666666666667),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8288036576),srs::spar::y_0<>(304800.6096012192),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2232) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.75),srs::spar::lat_2<>(38.45),srs::spar::lat_0<>(37.83333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8288036576),srs::spar::y_0<>(304800.6096012192),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2233) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.43333333333333),srs::spar::lat_2<>(37.23333333333333),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8288036576),srs::spar::y_0<>(304800.6096012192),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2234) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.86666666666667),srs::spar::lat_2<>(41.2),srs::spar::lat_0<>(40.83333333333334),srs::spar::lon_0<>(-72.75),srs::spar::x_0<>(304800.6096012192),srs::spar::y_0<>(152400.3048006096),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2235) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-75.41666666666667),srs::spar::k<>(0.999995),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2236) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-81),srs::spar::k<>(0.999941177),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2237) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-82),srs::spar::k<>(0.999941177),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2238) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.75),srs::spar::lat_2<>(29.58333333333333),srs::spar::lat_0<>(29),srs::spar::lon_0<>(-84.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2239) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-82.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2240) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-84.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(699999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2241) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-112.1666666666667),srs::spar::k<>(0.9999473679999999),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2242) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-114),srs::spar::k<>(0.9999473679999999),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2243) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-115.75),srs::spar::k<>(0.999933333),srs::spar::x_0<>(800000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2244) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-85.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(99999.99989839978),srs::spar::y_0<>(249364.9987299975),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2245) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-87.08333333333333),srs::spar::k<>(0.999966667),srs::spar::x_0<>(900000),srs::spar::y_0<>(249364.9987299975),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2246) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(38.96666666666667),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-84.25),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2247) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.93333333333333),srs::spar::lat_2<>(36.73333333333333),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2248) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.45),srs::spar::lat_2<>(38.3),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-77),srs::spar::x_0<>(399999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2249) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.68333333333333),srs::spar::lat_2<>(41.71666666666667),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-71.5),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(750000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2250) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.48333333333333),srs::spar::lat_2<>(41.28333333333333),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-70.5),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2251) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.08333333333334),srs::spar::lat_2<>(45.48333333333333),srs::spar::lat_0<>(44.78333333333333),srs::spar::lon_0<>(-87),srs::spar::x_0<>(7999999.999968001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2252) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.7),srs::spar::lat_2<>(44.18333333333333),srs::spar::lat_0<>(43.31666666666667),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(5999999.999976001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2253) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.66666666666666),srs::spar::lat_2<>(42.1),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(3999999.999984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2254) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-88.83333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2255) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-90.33333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(699999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2256) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49),srs::spar::lat_2<>(45),srs::spar::lat_0<>(44.25),srs::spar::lon_0<>(-109.5),srs::spar::x_0<>(599999.9999976),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2257) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-104.3333333333333),srs::spar::k<>(0.999909091),srs::spar::x_0<>(165000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2258) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-106.25),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2259) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-107.8333333333333),srs::spar::k<>(0.999916667),srs::spar::x_0<>(830000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2260) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2261) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-76.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(249999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2262) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-78.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(350000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2263) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.03333333333333),srs::spar::lat_2<>(40.66666666666666),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-74),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2264) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.16666666666666),srs::spar::lat_2<>(34.33333333333334),srs::spar::lat_0<>(33.75),srs::spar::lon_0<>(-79),srs::spar::x_0<>(609601.2192024384),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2265) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.73333333333333),srs::spar::lat_2<>(47.43333333333333),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(599999.9999976),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2266) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.48333333333333),srs::spar::lat_2<>(46.18333333333333),srs::spar::lat_0<>(45.66666666666666),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(599999.9999976),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2267) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.76666666666667),srs::spar::lat_2<>(35.56666666666667),srs::spar::lat_0<>(35),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2268) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.23333333333333),srs::spar::lat_2<>(33.93333333333333),srs::spar::lat_0<>(33.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2269) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46),srs::spar::lat_2<>(44.33333333333334),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2500000.0001424),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2270) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44),srs::spar::lat_2<>(42.33333333333334),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(1500000.0001464),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2271) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.95),srs::spar::lat_2<>(40.88333333333333),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2272) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.96666666666667),srs::spar::lat_2<>(39.93333333333333),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2273) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.83333333333334),srs::spar::lat_2<>(32.5),srs::spar::lat_0<>(31.83333333333333),srs::spar::lon_0<>(-81),srs::spar::x_0<>(609600),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2274) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.41666666666666),srs::spar::lat_2<>(35.25),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-86),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2275) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.18333333333333),srs::spar::lat_2<>(34.65),srs::spar::lat_0<>(34),srs::spar::lon_0<>(-101.5),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(999999.9998983998),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2276) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.96666666666667),srs::spar::lat_2<>(32.13333333333333),srs::spar::lat_0<>(31.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(2000000.0001016),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2277) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(31.88333333333333),srs::spar::lat_2<>(30.11666666666667),srs::spar::lat_0<>(29.66666666666667),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(699999.9998983998),srs::spar::y_0<>(3000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2278) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.28333333333333),srs::spar::lat_2<>(28.38333333333333),srs::spar::lat_0<>(27.83333333333333),srs::spar::lon_0<>(-99),srs::spar::x_0<>(600000),srs::spar::y_0<>(3999999.9998984),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2279) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.83333333333333),srs::spar::lat_2<>(26.16666666666667),srs::spar::lat_0<>(25.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(5000000.0001016),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2280) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.71666666666667),srs::spar::lat_0<>(40.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0001504),srs::spar::y_0<>(999999.9999960001),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2281) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.65),srs::spar::lat_2<>(39.01666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0001504),srs::spar::y_0<>(1999999.999992),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2282) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.35),srs::spar::lat_2<>(37.21666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0001504),srs::spar::y_0<>(2999999.999988),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2283) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.2),srs::spar::lat_2<>(38.03333333333333),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000.0001016),srs::spar::y_0<>(2000000.0001016),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2284) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(36.76666666666667),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000.0001016),srs::spar::y_0<>(999999.9998983998),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2285) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.73333333333333),srs::spar::lat_2<>(47.5),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-120.8333333333333),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2286) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.33333333333334),srs::spar::lat_2<>(45.83333333333334),srs::spar::lat_0<>(45.33333333333334),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2287) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46.76666666666667),srs::spar::lat_2<>(45.56666666666667),srs::spar::lat_0<>(45.16666666666666),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2288) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.5),srs::spar::lat_2<>(44.25),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2289) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.06666666666667),srs::spar::lat_2<>(42.73333333333333),srs::spar::lat_0<>(42),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2290) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(47.25),srs::spar::lon_0<>(-63),srs::spar::k<>(0.999912),srs::spar::x_0<>(700000),srs::spar::y_0<>(400000),srs::spar::a<>(6378135),srs::spar::b<>(6356750.304921594)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2291) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(47.25),srs::spar::lon_0<>(-63),srs::spar::k<>(0.999912),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::a<>(6378135),srs::spar::b<>(6356750.304921594)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2292) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(47.25),srs::spar::lon_0<>(-63),srs::spar::k<>(0.999912),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2294) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-61.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(4500000),srs::spar::y_0<>(0),srs::spar::a<>(6378135),srs::spar::b<>(6356750.304921594)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2295) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-64.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(5500000),srs::spar::y_0<>(0),srs::spar::a<>(6378135),srs::spar::b<>(6356750.304921594)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2296)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2297)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2298)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2299)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2300)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2301)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2302)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2303)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2304)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2305)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2306)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2307)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2308) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(109),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2309) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(116),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2310) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(132),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2311) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(6),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2312) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<33>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2313) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<33>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2314) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(10.44166666666667),srs::spar::lon_0<>(-61.33333333333334),srs::spar::x_0<>(86501.46392052001),srs::spar::y_0<>(65379.0134283),srs::spar::a<>(6378293.645208759),srs::spar::b<>(6356617.987679838),srs::spar::to_meter<>(0.3047972654)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2315) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<19>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2316) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2317) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(9),srs::spar::lat_2<>(3),srs::spar::lat_0<>(6),srs::spar::lon_0<>(-66),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2318) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(17),srs::spar::lat_2<>(33),srs::spar::lat_0<>(25.08951),srs::spar::lon_0<>(48),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2319) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2320) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(30),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2321) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(33),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2322) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(36),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2323) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(39),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2324) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(42),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2325) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2326) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(22.31213333333334),srs::spar::lon_0<>(114.1785555555556),srs::spar::k<>(1),srs::spar::x_0<>(836694.05),srs::spar::y_0<>(819069.8),srs::spar::ellps_intl(),srs::spar::towgs84<>(-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2327) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(13500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2328) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(14500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2329) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(15500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2330) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(16500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2331) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(17500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2332) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(18500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2333) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(19500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2334) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(20500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2335) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(21500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2336) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(22500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2337) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(23500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2338) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2339) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2340) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2341) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2342) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2343) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2344) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2345) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2346) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2347) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2348) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2349) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(25500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2350) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(78),srs::spar::k<>(1),srs::spar::x_0<>(26500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2351) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(27500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2352) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(84),srs::spar::k<>(1),srs::spar::x_0<>(28500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2353) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(29500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2354) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(90),srs::spar::k<>(1),srs::spar::x_0<>(30500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2355) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(31500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2356) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(96),srs::spar::k<>(1),srs::spar::x_0<>(32500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2357) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(33500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2358) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(102),srs::spar::k<>(1),srs::spar::x_0<>(34500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2359) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(35500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2360) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(108),srs::spar::k<>(1),srs::spar::x_0<>(36500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2361) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(37500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2362) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(114),srs::spar::k<>(1),srs::spar::x_0<>(38500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2363) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(39500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2364) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(120),srs::spar::k<>(1),srs::spar::x_0<>(40500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2365) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(41500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2366) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(126),srs::spar::k<>(1),srs::spar::x_0<>(42500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2367) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(43500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2368) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(132),srs::spar::k<>(1),srs::spar::x_0<>(44500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2369) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(45500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2370) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2371) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(78),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2372) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2373) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(84),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2374) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2375) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(90),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2376) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2377) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(96),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2378) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2379) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(102),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2380) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2381) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(108),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2382) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2383) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(114),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2384) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2385) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(120),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2386) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2387) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(126),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2388) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2389) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(132),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2390) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356755.288157528)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2391) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2392) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(1),srs::spar::x_0<>(2500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2393) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(3500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2394) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(30),srs::spar::k<>(1),srs::spar::x_0<>(4500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2395) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(8500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(-76,-138,67,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2396) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(51),srs::spar::k<>(1),srs::spar::x_0<>(9500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(-76,-138,67,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2397) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(9),srs::spar::k<>(1),srs::spar::x_0<>(3500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2398) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(12),srs::spar::k<>(1),srs::spar::x_0<>(4500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2399) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(1),srs::spar::x_0<>(5500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2400) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15.80827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2401) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(25500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2402) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(78),srs::spar::k<>(1),srs::spar::x_0<>(26500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2403) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(27500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2404) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(84),srs::spar::k<>(1),srs::spar::x_0<>(28500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2405) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(29500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2406) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(90),srs::spar::k<>(1),srs::spar::x_0<>(30500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2407) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(31500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2408) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(96),srs::spar::k<>(1),srs::spar::x_0<>(32500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2409) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(33500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2410) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(102),srs::spar::k<>(1),srs::spar::x_0<>(34500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2411) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(35500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2412) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(108),srs::spar::k<>(1),srs::spar::x_0<>(36500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2413) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(37500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2414) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(114),srs::spar::k<>(1),srs::spar::x_0<>(38500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2415) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(39500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2416) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(120),srs::spar::k<>(1),srs::spar::x_0<>(40500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2417) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(41500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2418) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(126),srs::spar::k<>(1),srs::spar::x_0<>(42500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2419) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(43500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2420) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(132),srs::spar::k<>(1),srs::spar::x_0<>(44500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2421) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(45500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2422) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2423) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(78),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2424) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2425) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(84),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2426) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2427) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(90),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2428) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2429) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(96),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2430) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2431) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(102),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2432) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2433) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(108),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2434) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2435) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(114),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2436) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2437) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(120),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2438) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2439) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(126),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2440) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2441) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(132),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2442) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2443) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(33),srs::spar::lon_0<>(129.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2444) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(33),srs::spar::lon_0<>(131),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2445) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36),srs::spar::lon_0<>(132.1666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2446) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(33),srs::spar::lon_0<>(133.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2447) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36),srs::spar::lon_0<>(134.3333333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2448) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36),srs::spar::lon_0<>(136),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2449) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36),srs::spar::lon_0<>(137.1666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2450) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36),srs::spar::lon_0<>(138.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2451) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36),srs::spar::lon_0<>(139.8333333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2452) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(140.8333333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2453) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(44),srs::spar::lon_0<>(140.25),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2454) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(44),srs::spar::lon_0<>(142.25),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2455) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(44),srs::spar::lon_0<>(144.25),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2456) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(26),srs::spar::lon_0<>(142),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2457) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(26),srs::spar::lon_0<>(127.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2458) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(26),srs::spar::lon_0<>(124),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2459) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(26),srs::spar::lon_0<>(131),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2460) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(20),srs::spar::lon_0<>(136),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2461) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(26),srs::spar::lon_0<>(154),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2462) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(4500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2463) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2464) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2465) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(33),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2466) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(39),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2467) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2468) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(51),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2469) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(57),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2470) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(63),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2471) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(69),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2472) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2473) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2474) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2475) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2476) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2477) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2478) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2479) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2480) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2481) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2482) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2483) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(141),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2484) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(147),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2485) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(153),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2486) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(159),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2487) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(165),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2488) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(171),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2489) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(177),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2490) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-177),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2491) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-171),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2492) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(9),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2493) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2494) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2495) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2496) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(33),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2497) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(39),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2498) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2499) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(51),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2500) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(57),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2501) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(63),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2502) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(69),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2503) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2504) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2505) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2506) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2507) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2508) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2509) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2510) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2511) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2512) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2513) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2514) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(141),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2515) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(147),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2516) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(153),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2517) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(159),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2518) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(165),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2519) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(171),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2520) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(177),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2521) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-177),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2522) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-171),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2523) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(7500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2524) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(1),srs::spar::x_0<>(8500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2525) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(9500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2526) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(30),srs::spar::k<>(1),srs::spar::x_0<>(10500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2527) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(33),srs::spar::k<>(1),srs::spar::x_0<>(11500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2528) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(36),srs::spar::k<>(1),srs::spar::x_0<>(12500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2529) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(39),srs::spar::k<>(1),srs::spar::x_0<>(13500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2530) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(42),srs::spar::k<>(1),srs::spar::x_0<>(14500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2531) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(15500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2532) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(48),srs::spar::k<>(1),srs::spar::x_0<>(16500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2533) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(51),srs::spar::k<>(1),srs::spar::x_0<>(17500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2534) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(54),srs::spar::k<>(1),srs::spar::x_0<>(18500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2535) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(57),srs::spar::k<>(1),srs::spar::x_0<>(19500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2536) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(60),srs::spar::k<>(1),srs::spar::x_0<>(20500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2537) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(63),srs::spar::k<>(1),srs::spar::x_0<>(21500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2538) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(66),srs::spar::k<>(1),srs::spar::x_0<>(22500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2539) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(69),srs::spar::k<>(1),srs::spar::x_0<>(23500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2540) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(72),srs::spar::k<>(1),srs::spar::x_0<>(24500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2541) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(25500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2542) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(78),srs::spar::k<>(1),srs::spar::x_0<>(26500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2543) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(27500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2544) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(84),srs::spar::k<>(1),srs::spar::x_0<>(28500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2545) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(29500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2546) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(90),srs::spar::k<>(1),srs::spar::x_0<>(30500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2547) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(31500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2548) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(96),srs::spar::k<>(1),srs::spar::x_0<>(32500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2549) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(33500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2550) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<50>,srs::spar::south,srs::spar::ellps_bessel,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<50>(),srs::spar::south(),srs::spar::ellps_bessel(),srs::spar::towgs84<>(-404.78,685.68,45.47,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2551) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(102),srs::spar::k<>(1),srs::spar::x_0<>(34500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2552) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(35500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2553) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(108),srs::spar::k<>(1),srs::spar::x_0<>(36500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2554) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(37500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2555) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(114),srs::spar::k<>(1),srs::spar::x_0<>(38500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2556) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(39500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2557) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(120),srs::spar::k<>(1),srs::spar::x_0<>(40500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2558) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(41500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2559) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(126),srs::spar::k<>(1),srs::spar::x_0<>(42500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2560) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(43500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2561) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(132),srs::spar::k<>(1),srs::spar::x_0<>(44500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2562) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(45500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2563) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(138),srs::spar::k<>(1),srs::spar::x_0<>(46500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2564) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(141),srs::spar::k<>(1),srs::spar::x_0<>(47500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2565) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(144),srs::spar::k<>(1),srs::spar::x_0<>(48500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2566) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(147),srs::spar::k<>(1),srs::spar::x_0<>(49500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2567) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(150),srs::spar::k<>(1),srs::spar::x_0<>(50500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2568) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(153),srs::spar::k<>(1),srs::spar::x_0<>(51500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2569) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(156),srs::spar::k<>(1),srs::spar::x_0<>(52500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2570) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(159),srs::spar::k<>(1),srs::spar::x_0<>(53500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2571) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(162),srs::spar::k<>(1),srs::spar::x_0<>(54500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2572) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(165),srs::spar::k<>(1),srs::spar::x_0<>(55500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2573) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(168),srs::spar::k<>(1),srs::spar::x_0<>(56500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2574) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(171),srs::spar::k<>(1),srs::spar::x_0<>(57500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2575) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(174),srs::spar::k<>(1),srs::spar::x_0<>(58500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2576) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(177),srs::spar::k<>(1),srs::spar::x_0<>(59500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2577) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(180),srs::spar::k<>(1),srs::spar::x_0<>(60000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2578) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-177),srs::spar::k<>(1),srs::spar::x_0<>(61500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2579) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-174),srs::spar::k<>(1),srs::spar::x_0<>(62500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2580) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-171),srs::spar::k<>(1),srs::spar::x_0<>(63500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2581) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-168),srs::spar::k<>(1),srs::spar::x_0<>(64500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2582) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2583) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2584) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2585) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(30),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2586) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(33),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2587) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(36),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2588) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(39),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2589) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(42),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2590) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2591) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(48),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2592) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(51),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2593) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(54),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2594) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(57),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2595) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(60),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2596) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(63),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2597) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(66),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2598) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(69),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2599) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(72),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2600) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(0.9998),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2601) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2602) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(78),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2603) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2604) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(84),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2605) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2606) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(90),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2607) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2608) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(96),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2609) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2610) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(102),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2611) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2612) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(108),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2613) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2614) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(114),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2615) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2616) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(120),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2617) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2618) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(126),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2619) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2620) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(132),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2621) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2622) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(138),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2623) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(141),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2624) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(144),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2625) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(147),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2626) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(150),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2627) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(153),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2628) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(156),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2629) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(159),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2630) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(162),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2631) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(165),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2632) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(168),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2633) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(171),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2634) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(174),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2635) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(177),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2636) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(180),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2637) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-177),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2638) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-174),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2639) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-171),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2640) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-168),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2641) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(7500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2642) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(1),srs::spar::x_0<>(8500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2643) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(9500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2644) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(30),srs::spar::k<>(1),srs::spar::x_0<>(10500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2645) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(33),srs::spar::k<>(1),srs::spar::x_0<>(11500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2646) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(36),srs::spar::k<>(1),srs::spar::x_0<>(12500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2647) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(39),srs::spar::k<>(1),srs::spar::x_0<>(13500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2648) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(42),srs::spar::k<>(1),srs::spar::x_0<>(14500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2649) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(15500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2650) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(48),srs::spar::k<>(1),srs::spar::x_0<>(16500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2651) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(51),srs::spar::k<>(1),srs::spar::x_0<>(17500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2652) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(54),srs::spar::k<>(1),srs::spar::x_0<>(18500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2653) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(57),srs::spar::k<>(1),srs::spar::x_0<>(19500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2654) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(60),srs::spar::k<>(1),srs::spar::x_0<>(20500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2655) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(63),srs::spar::k<>(1),srs::spar::x_0<>(21500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2656) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(66),srs::spar::k<>(1),srs::spar::x_0<>(22500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2657) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(69),srs::spar::k<>(1),srs::spar::x_0<>(23500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2658) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(72),srs::spar::k<>(1),srs::spar::x_0<>(24500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2659) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(25500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2660) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(78),srs::spar::k<>(1),srs::spar::x_0<>(26500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2661) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(27500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2662) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(84),srs::spar::k<>(1),srs::spar::x_0<>(28500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2663) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(29500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2664) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(90),srs::spar::k<>(1),srs::spar::x_0<>(30500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2665) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(31500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2666) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(96),srs::spar::k<>(1),srs::spar::x_0<>(32500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2667) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(33500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2668) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(102),srs::spar::k<>(1),srs::spar::x_0<>(34500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2669) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(35500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2670) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(108),srs::spar::k<>(1),srs::spar::x_0<>(36500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2671) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(37500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2672) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(114),srs::spar::k<>(1),srs::spar::x_0<>(38500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2673) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(39500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2674) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(120),srs::spar::k<>(1),srs::spar::x_0<>(40500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2675) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(41500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2676) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(126),srs::spar::k<>(1),srs::spar::x_0<>(42500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2677) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(43500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2678) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(132),srs::spar::k<>(1),srs::spar::x_0<>(44500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2679) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(45500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2680) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(138),srs::spar::k<>(1),srs::spar::x_0<>(46500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2681) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(141),srs::spar::k<>(1),srs::spar::x_0<>(47500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2682) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(144),srs::spar::k<>(1),srs::spar::x_0<>(48500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2683) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(147),srs::spar::k<>(1),srs::spar::x_0<>(49500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2684) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(150),srs::spar::k<>(1),srs::spar::x_0<>(50500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2685) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(153),srs::spar::k<>(1),srs::spar::x_0<>(51500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2686) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(156),srs::spar::k<>(1),srs::spar::x_0<>(52500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2687) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(159),srs::spar::k<>(1),srs::spar::x_0<>(53500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2688) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(162),srs::spar::k<>(1),srs::spar::x_0<>(54500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2689) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(165),srs::spar::k<>(1),srs::spar::x_0<>(55500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2690) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(168),srs::spar::k<>(1),srs::spar::x_0<>(56500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2691) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(171),srs::spar::k<>(1),srs::spar::x_0<>(57500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2692) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(174),srs::spar::k<>(1),srs::spar::x_0<>(58500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2693) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(177),srs::spar::k<>(1),srs::spar::x_0<>(59500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2694) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(180),srs::spar::k<>(1),srs::spar::x_0<>(60000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2695) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-177),srs::spar::k<>(1),srs::spar::x_0<>(61500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2696) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-174),srs::spar::k<>(1),srs::spar::x_0<>(62500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2697) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-171),srs::spar::k<>(1),srs::spar::x_0<>(63500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2698) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-168),srs::spar::k<>(1),srs::spar::x_0<>(64500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2699) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2700) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2701) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2702) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(30),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2703) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(33),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2704) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(36),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2705) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(39),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2706) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(42),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2707) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2708) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(48),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2709) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(51),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2710) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(54),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2711) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(57),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2712) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(60),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2713) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(63),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2714) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(66),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2715) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(69),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2716) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(72),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2717) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2718) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(78),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2719) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(81),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2720) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(84),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2721) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(87),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2722) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(90),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2723) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(93),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2724) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(96),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2725) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(99),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2726) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(102),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2727) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2728) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(108),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2729) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(111),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2730) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(114),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2731) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2732) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(120),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2733) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2734) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(126),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2735) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(129),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2736) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<36>,srs::spar::south,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2737) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<37>,srs::spar::south,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2738) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(132),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2739) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2740) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(138),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2741) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(141),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2742) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(144),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2743) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(147),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2744) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(150),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2745) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(153),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2746) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(156),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2747) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(159),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2748) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(162),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2749) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(165),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2750) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(168),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2751) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(171),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2752) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(174),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2753) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(177),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2754) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(180),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2755) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-177),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2756) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-174),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2757) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-171),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2758) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-168),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2759) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-85.83333333333333),srs::spar::k<>(0.99996),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2760) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-87.5),srs::spar::k<>(0.999933333),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2761) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-110.1666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2762) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-111.9166666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2763) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-113.75),srs::spar::k<>(0.999933333),srs::spar::x_0<>(213360),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2764) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.23333333333333),srs::spar::lat_2<>(34.93333333333333),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-92),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2765) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.76666666666667),srs::spar::lat_2<>(33.3),srs::spar::lat_0<>(32.66666666666666),srs::spar::lon_0<>(-92),srs::spar::x_0<>(400000),srs::spar::y_0<>(400000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2766) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.66666666666666),srs::spar::lat_2<>(40),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2767) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.83333333333334),srs::spar::lat_2<>(38.33333333333334),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2768) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.43333333333333),srs::spar::lat_2<>(37.06666666666667),srs::spar::lat_0<>(36.5),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2769) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.25),srs::spar::lat_2<>(36),srs::spar::lat_0<>(35.33333333333334),srs::spar::lon_0<>(-119),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2770) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.46666666666667),srs::spar::lat_2<>(34.03333333333333),srs::spar::lat_0<>(33.5),srs::spar::lon_0<>(-118),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2771) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.88333333333333),srs::spar::lat_2<>(32.78333333333333),srs::spar::lat_0<>(32.16666666666666),srs::spar::lon_0<>(-116.25),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2772) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.78333333333333),srs::spar::lat_2<>(39.71666666666667),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2773) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.75),srs::spar::lat_2<>(38.45),srs::spar::lat_0<>(37.83333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2774) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.43333333333333),srs::spar::lat_2<>(37.23333333333333),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2775) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.86666666666667),srs::spar::lat_2<>(41.2),srs::spar::lat_0<>(40.83333333333334),srs::spar::lon_0<>(-72.75),srs::spar::x_0<>(304800.6096),srs::spar::y_0<>(152400.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2776) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-75.41666666666667),srs::spar::k<>(0.999995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2777) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-81),srs::spar::k<>(0.999941177),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2778) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-82),srs::spar::k<>(0.999941177),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2779) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.75),srs::spar::lat_2<>(29.58333333333333),srs::spar::lat_0<>(29),srs::spar::lon_0<>(-84.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2780) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-82.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2781) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-84.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(700000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2782) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(18.83333333333333),srs::spar::lon_0<>(-155.5),srs::spar::k<>(0.999966667),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2783) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(20.33333333333333),srs::spar::lon_0<>(-156.6666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2784) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.16666666666667),srs::spar::lon_0<>(-158),srs::spar::k<>(0.99999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2785) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.83333333333333),srs::spar::lon_0<>(-159.5),srs::spar::k<>(0.99999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2786) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.66666666666667),srs::spar::lon_0<>(-160.1666666666667),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2787) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-112.1666666666667),srs::spar::k<>(0.9999473679999999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2788) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-114),srs::spar::k<>(0.9999473679999999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2789) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-115.75),srs::spar::k<>(0.999933333),srs::spar::x_0<>(800000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2790) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-88.33333333333333),srs::spar::k<>(0.9999749999999999),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2791) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-90.16666666666667),srs::spar::k<>(0.999941177),srs::spar::x_0<>(700000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2792) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-85.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(100000),srs::spar::y_0<>(250000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2793) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-87.08333333333333),srs::spar::k<>(0.999966667),srs::spar::x_0<>(900000),srs::spar::y_0<>(250000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2794) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.26666666666667),srs::spar::lat_2<>(42.06666666666667),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(1500000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2795) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.61666666666667),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2796) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.78333333333333),srs::spar::lat_2<>(38.71666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2797) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.56666666666667),srs::spar::lat_2<>(37.26666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(400000),srs::spar::y_0<>(400000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2798) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(38.96666666666667),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-84.25),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2799) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.93333333333333),srs::spar::lat_2<>(36.73333333333333),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(500000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2800) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.66666666666666),srs::spar::lat_2<>(31.16666666666667),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-92.5),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2801) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.7),srs::spar::lat_2<>(29.3),srs::spar::lat_0<>(28.5),srs::spar::lon_0<>(-91.33333333333333),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2802) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-68.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2803) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.83333333333334),srs::spar::lon_0<>(-70.16666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(900000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2804) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.45),srs::spar::lat_2<>(38.3),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-77),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2805) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.68333333333333),srs::spar::lat_2<>(41.71666666666667),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-71.5),srs::spar::x_0<>(200000),srs::spar::y_0<>(750000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2806) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.48333333333333),srs::spar::lat_2<>(41.28333333333333),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-70.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2807) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.08333333333334),srs::spar::lat_2<>(45.48333333333333),srs::spar::lat_0<>(44.78333333333333),srs::spar::lon_0<>(-87),srs::spar::x_0<>(8000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2808) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.7),srs::spar::lat_2<>(44.18333333333333),srs::spar::lat_0<>(43.31666666666667),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(6000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2809) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.66666666666666),srs::spar::lat_2<>(42.1),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(4000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2810) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.63333333333333),srs::spar::lat_2<>(47.03333333333333),srs::spar::lat_0<>(46.5),srs::spar::lon_0<>(-93.09999999999999),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2811) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.05),srs::spar::lat_2<>(45.61666666666667),srs::spar::lat_0<>(45),srs::spar::lon_0<>(-94.25),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2812) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.21666666666667),srs::spar::lat_2<>(43.78333333333333),srs::spar::lat_0<>(43),srs::spar::lon_0<>(-94),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2813) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-88.83333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2814) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-90.33333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(700000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2815) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(35.83333333333334),srs::spar::lon_0<>(-90.5),srs::spar::k<>(0.999933333),srs::spar::x_0<>(250000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2816) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(35.83333333333334),srs::spar::lon_0<>(-92.5),srs::spar::k<>(0.999933333),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2817) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.16666666666666),srs::spar::lon_0<>(-94.5),srs::spar::k<>(0.999941177),srs::spar::x_0<>(850000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2818) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49),srs::spar::lat_2<>(45),srs::spar::lat_0<>(44.25),srs::spar::lon_0<>(-109.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2819) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43),srs::spar::lat_2<>(40),srs::spar::lat_0<>(39.83333333333334),srs::spar::lon_0<>(-100),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2820) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-115.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(8000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2821) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-116.6666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(6000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2822) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-118.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(800000),srs::spar::y_0<>(4000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2823) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-71.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2824) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2825) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-104.3333333333333),srs::spar::k<>(0.999909091),srs::spar::x_0<>(165000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2826) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-106.25),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2827) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-107.8333333333333),srs::spar::k<>(0.999916667),srs::spar::x_0<>(830000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2828) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2829) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-76.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(250000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2830) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-78.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(350000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2831) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.03333333333333),srs::spar::lat_2<>(40.66666666666666),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-74),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2832) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.73333333333333),srs::spar::lat_2<>(47.43333333333333),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2833) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.48333333333333),srs::spar::lat_2<>(46.18333333333333),srs::spar::lat_0<>(45.66666666666666),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2834) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.7),srs::spar::lat_2<>(40.43333333333333),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2835) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.03333333333333),srs::spar::lat_2<>(38.73333333333333),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2836) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.76666666666667),srs::spar::lat_2<>(35.56666666666667),srs::spar::lat_0<>(35),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2837) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.23333333333333),srs::spar::lat_2<>(33.93333333333333),srs::spar::lat_0<>(33.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2838) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46),srs::spar::lat_2<>(44.33333333333334),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2839) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44),srs::spar::lat_2<>(42.33333333333334),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2840) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.08333333333334),srs::spar::lon_0<>(-71.5),srs::spar::k<>(0.99999375),srs::spar::x_0<>(100000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2841) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.68333333333333),srs::spar::lat_2<>(44.41666666666666),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-100),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2842) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.4),srs::spar::lat_2<>(42.83333333333334),srs::spar::lat_0<>(42.33333333333334),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2843) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.41666666666666),srs::spar::lat_2<>(35.25),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-86),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2844) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.18333333333333),srs::spar::lat_2<>(34.65),srs::spar::lat_0<>(34),srs::spar::lon_0<>(-101.5),srs::spar::x_0<>(200000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2845) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.96666666666667),srs::spar::lat_2<>(32.13333333333333),srs::spar::lat_0<>(31.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(2000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2846) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(31.88333333333333),srs::spar::lat_2<>(30.11666666666667),srs::spar::lat_0<>(29.66666666666667),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(700000),srs::spar::y_0<>(3000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2847) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.28333333333333),srs::spar::lat_2<>(28.38333333333333),srs::spar::lat_0<>(27.83333333333333),srs::spar::lon_0<>(-99),srs::spar::x_0<>(600000),srs::spar::y_0<>(4000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2848) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.83333333333333),srs::spar::lat_2<>(26.16666666666667),srs::spar::lat_0<>(25.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(300000),srs::spar::y_0<>(5000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2849) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.71666666666667),srs::spar::lat_0<>(40.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2850) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.65),srs::spar::lat_2<>(39.01666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(2000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2851) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.35),srs::spar::lat_2<>(37.21666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(3000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2852) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-72.5),srs::spar::k<>(0.999964286),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2853) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.2),srs::spar::lat_2<>(38.03333333333333),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000),srs::spar::y_0<>(2000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2854) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(36.76666666666667),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2855) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.73333333333333),srs::spar::lat_2<>(47.5),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-120.8333333333333),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2856) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.33333333333334),srs::spar::lat_2<>(45.83333333333334),srs::spar::lat_0<>(45.33333333333334),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2857) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.25),srs::spar::lat_2<>(39),srs::spar::lat_0<>(38.5),srs::spar::lon_0<>(-79.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2858) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.88333333333333),srs::spar::lat_2<>(37.48333333333333),srs::spar::lat_0<>(37),srs::spar::lon_0<>(-81),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2859) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46.76666666666667),srs::spar::lat_2<>(45.56666666666667),srs::spar::lat_0<>(45.16666666666666),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2860) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.5),srs::spar::lat_2<>(44.25),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2861) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.06666666666667),srs::spar::lat_2<>(42.73333333333333),srs::spar::lat_0<>(42),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2862) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-105.1666666666667),srs::spar::k<>(0.9999375),srs::spar::x_0<>(200000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2863) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-107.3333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(400000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2864) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-108.75),srs::spar::k<>(0.9999375),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2865) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-110.0833333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2866) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(18.43333333333333),srs::spar::lat_2<>(18.03333333333333),srs::spar::lat_0<>(17.83333333333333),srs::spar::lon_0<>(-66.43333333333334),srs::spar::x_0<>(200000),srs::spar::y_0<>(200000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2867) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-110.1666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2868) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-111.9166666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2869) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-113.75),srs::spar::k<>(0.999933333),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2870) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.66666666666666),srs::spar::lat_2<>(40),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2871) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.83333333333334),srs::spar::lat_2<>(38.33333333333334),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2872) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.43333333333333),srs::spar::lat_2<>(37.06666666666667),srs::spar::lat_0<>(36.5),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2873) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.25),srs::spar::lat_2<>(36),srs::spar::lat_0<>(35.33333333333334),srs::spar::lon_0<>(-119),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2874) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.46666666666667),srs::spar::lat_2<>(34.03333333333333),srs::spar::lat_0<>(33.5),srs::spar::lon_0<>(-118),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2875) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.88333333333333),srs::spar::lat_2<>(32.78333333333333),srs::spar::lat_0<>(32.16666666666666),srs::spar::lon_0<>(-116.25),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2876) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.78333333333333),srs::spar::lat_2<>(39.71666666666667),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8288036576),srs::spar::y_0<>(304800.6096012192),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2877) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.75),srs::spar::lat_2<>(38.45),srs::spar::lat_0<>(37.83333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8288036576),srs::spar::y_0<>(304800.6096012192),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2878) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.43333333333333),srs::spar::lat_2<>(37.23333333333333),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8288036576),srs::spar::y_0<>(304800.6096012192),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2879) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.86666666666667),srs::spar::lat_2<>(41.2),srs::spar::lat_0<>(40.83333333333334),srs::spar::lon_0<>(-72.75),srs::spar::x_0<>(304800.6096012192),srs::spar::y_0<>(152400.3048006096),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2880) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-75.41666666666667),srs::spar::k<>(0.999995),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2881) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-81),srs::spar::k<>(0.999941177),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2882) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-82),srs::spar::k<>(0.999941177),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2883) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.75),srs::spar::lat_2<>(29.58333333333333),srs::spar::lat_0<>(29),srs::spar::lon_0<>(-84.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2884) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-82.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2885) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-84.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(699999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2886) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-112.1666666666667),srs::spar::k<>(0.9999473679999999),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2887) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-114),srs::spar::k<>(0.9999473679999999),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2888) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-115.75),srs::spar::k<>(0.999933333),srs::spar::x_0<>(800000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2889) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-85.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(99999.99989839978),srs::spar::y_0<>(249364.9987299975),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2890) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-87.08333333333333),srs::spar::k<>(0.999966667),srs::spar::x_0<>(900000),srs::spar::y_0<>(249364.9987299975),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2891) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(38.96666666666667),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-84.25),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2892) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.93333333333333),srs::spar::lat_2<>(36.73333333333333),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2893) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.45),srs::spar::lat_2<>(38.3),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-77),srs::spar::x_0<>(399999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2894) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.68333333333333),srs::spar::lat_2<>(41.71666666666667),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-71.5),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(750000),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2895) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.48333333333333),srs::spar::lat_2<>(41.28333333333333),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-70.5),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2896) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.08333333333334),srs::spar::lat_2<>(45.48333333333333),srs::spar::lat_0<>(44.78333333333333),srs::spar::lon_0<>(-87),srs::spar::x_0<>(7999999.999968001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2897) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.7),srs::spar::lat_2<>(44.18333333333333),srs::spar::lat_0<>(43.31666666666667),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(5999999.999976001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2898) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.66666666666666),srs::spar::lat_2<>(42.1),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(3999999.999984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2899) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-88.83333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2900) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-90.33333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(699999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2901) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49),srs::spar::lat_2<>(45),srs::spar::lat_0<>(44.25),srs::spar::lon_0<>(-109.5),srs::spar::x_0<>(599999.9999976),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2902) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-104.3333333333333),srs::spar::k<>(0.999909091),srs::spar::x_0<>(165000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2903) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-106.25),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2904) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-107.8333333333333),srs::spar::k<>(0.999916667),srs::spar::x_0<>(830000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2905) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2906) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-76.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(249999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2907) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-78.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(350000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2908) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.03333333333333),srs::spar::lat_2<>(40.66666666666666),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-74),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2909) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.73333333333333),srs::spar::lat_2<>(47.43333333333333),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(599999.9999976),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2910) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.48333333333333),srs::spar::lat_2<>(46.18333333333333),srs::spar::lat_0<>(45.66666666666666),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(599999.9999976),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2911) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.76666666666667),srs::spar::lat_2<>(35.56666666666667),srs::spar::lat_0<>(35),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2912) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.23333333333333),srs::spar::lat_2<>(33.93333333333333),srs::spar::lat_0<>(33.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2913) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46),srs::spar::lat_2<>(44.33333333333334),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2500000.0001424),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2914) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44),srs::spar::lat_2<>(42.33333333333334),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(1500000.0001464),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2915) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.41666666666666),srs::spar::lat_2<>(35.25),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-86),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2916) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.18333333333333),srs::spar::lat_2<>(34.65),srs::spar::lat_0<>(34),srs::spar::lon_0<>(-101.5),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(999999.9998983998),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2917) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.96666666666667),srs::spar::lat_2<>(32.13333333333333),srs::spar::lat_0<>(31.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(2000000.0001016),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2918) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(31.88333333333333),srs::spar::lat_2<>(30.11666666666667),srs::spar::lat_0<>(29.66666666666667),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(699999.9998983998),srs::spar::y_0<>(3000000),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2919) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.28333333333333),srs::spar::lat_2<>(28.38333333333333),srs::spar::lat_0<>(27.83333333333333),srs::spar::lon_0<>(-99),srs::spar::x_0<>(600000),srs::spar::y_0<>(3999999.9998984),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2920) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.83333333333333),srs::spar::lat_2<>(26.16666666666667),srs::spar::lat_0<>(25.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(5000000.0001016),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2921) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.71666666666667),srs::spar::lat_0<>(40.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0001504),srs::spar::y_0<>(999999.9999960001),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2922) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.65),srs::spar::lat_2<>(39.01666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0001504),srs::spar::y_0<>(1999999.999992),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2923) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.35),srs::spar::lat_2<>(37.21666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0001504),srs::spar::y_0<>(2999999.999988),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2924) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.2),srs::spar::lat_2<>(38.03333333333333),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000.0001016),srs::spar::y_0<>(2000000.0001016),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2925) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(36.76666666666667),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000.0001016),srs::spar::y_0<>(999999.9998983998),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2926) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.73333333333333),srs::spar::lat_2<>(47.5),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-120.8333333333333),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2927) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.33333333333334),srs::spar::lat_2<>(45.83333333333334),srs::spar::lat_0<>(45.33333333333334),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2928) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46.76666666666667),srs::spar::lat_2<>(45.56666666666667),srs::spar::lat_0<>(45.16666666666666),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2929) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.5),srs::spar::lat_2<>(44.25),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2930) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.06666666666667),srs::spar::lat_2<>(42.73333333333333),srs::spar::lat_0<>(42),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2931) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(13),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6378249.2),srs::spar::b<>(6356515),srs::spar::towgs84<>(-106,-87,188,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2932) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.45),srs::spar::lon_0<>(51.21666666666667),srs::spar::k<>(0.99999),srs::spar::x_0<>(200000),srs::spar::y_0<>(300000),srs::spar::ellps_intl(),srs::spar::towgs84<>(-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2933) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<50>,srs::spar::south,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2934) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::pm_jakarta,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(110),srs::spar::k<>(0.997),srs::spar::x_0<>(3900000),srs::spar::y_0<>(900000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2935) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0.1166666666666667),srs::spar::lon_0<>(41.53333333333333),srs::spar::k<>(1),srs::spar::x_0<>(1300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2936) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0.1166666666666667),srs::spar::lon_0<>(44.53333333333333),srs::spar::k<>(1),srs::spar::x_0<>(2300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2937) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0.1166666666666667),srs::spar::lon_0<>(47.53333333333333),srs::spar::k<>(1),srs::spar::x_0<>(3300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2938) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0.1166666666666667),srs::spar::lon_0<>(50.53333333333333),srs::spar::k<>(1),srs::spar::x_0<>(4300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2939) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0.1333333333333333),srs::spar::lon_0<>(50.76666666666667),srs::spar::k<>(1),srs::spar::x_0<>(2300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2940) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0.1333333333333333),srs::spar::lon_0<>(53.76666666666667),srs::spar::k<>(1),srs::spar::x_0<>(3300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2941) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0.1333333333333333),srs::spar::lon_0<>(56.76666666666667),srs::spar::k<>(1),srs::spar::x_0<>(4300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2942) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<28>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-499,-249,314,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2943) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2944) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-55.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2945) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-58.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2946) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-61.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2947) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-64.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2948) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-67.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2949) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-70.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2950) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-73.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2951) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-76.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2952) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-79.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(304800),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2953) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(46.5),srs::spar::lon_0<>(-66.5),srs::spar::k<>(0.999912),srs::spar::x_0<>(2500000),srs::spar::y_0<>(7500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2954) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(47.25),srs::spar::lon_0<>(-63),srs::spar::k<>(0.999912),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2955) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<11>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2956) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<12>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2957) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<13>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2958) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<17>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2959) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<18>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2960) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<19>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2961) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2962) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<21>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2963)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2964) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(55),srs::spar::lat_2<>(65),srs::spar::lat_0<>(50),srs::spar::lon_0<>(-154),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::datum_nad27(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-85.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(99999.99989839978),srs::spar::y_0<>(249999.9998983998),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2966) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-87.08333333333333),srs::spar::k<>(0.999966667),srs::spar::x_0<>(900000),srs::spar::y_0<>(249999.9998983998),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2967) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-85.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(99999.99989839978),srs::spar::y_0<>(249999.9998983998),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2968) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-87.08333333333333),srs::spar::k<>(0.999966667),srs::spar::x_0<>(900000),srs::spar::y_0<>(249999.9998983998),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2969) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<20>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(137,248,-430,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2970) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2971) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<22>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<22>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-186,230,110,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2972) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<22>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<22>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(2,2,-2,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2973) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2975) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<40>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<40>(),srs::spar::south(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2976) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<6>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<6>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(162,117,154,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2977) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<5>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2978) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<7>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2979) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<42>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<42>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(145,-187,103,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2980) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<38>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<38>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-382,-59,-262,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2981) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2982) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2983) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<58>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2984) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-20.66666666666667),srs::spar::lat_2<>(-22.33333333333333),srs::spar::lat_0<>(-21.5),srs::spar::lon_0<>(166),srs::spar::x_0<>(400000),srs::spar::y_0<>(300000),srs::spar::ellps_intl(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2985)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2986)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2987) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<21>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<21>(),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(30,430,368,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2988) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<1>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2989) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<20>(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2990) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-21.11666666666667),srs::spar::lon_0<>(55.53333333333333),srs::spar::k<>(1),srs::spar::x_0<>(50000),srs::spar::y_0<>(160000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2991) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43),srs::spar::lat_2<>(45.5),srs::spar::lat_0<>(41.75),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2992) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43),srs::spar::lat_2<>(45.5),srs::spar::lat_0<>(41.75),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(399999.9999984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2993) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43),srs::spar::lat_2<>(45.5),srs::spar::lat_0<>(41.75),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2994) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43),srs::spar::lat_2<>(45.5),srs::spar::lat_0<>(41.75),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(399999.9999984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2995) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2996) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2997) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<58>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2998) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 2999) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<38>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3000) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(110),srs::spar::k<>(0.997),srs::spar::x_0<>(3900000),srs::spar::y_0<>(900000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3001) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(110),srs::spar::k<>(0.997),srs::spar::x_0<>(3900000),srs::spar::y_0<>(900000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3002) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(110),srs::spar::k<>(0.997),srs::spar::x_0<>(3900000),srs::spar::y_0<>(900000),srs::spar::ellps_bessel(),srs::spar::towgs84<>(-587.8,519.75,145.76,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3003) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(9),srs::spar::k<>(0.9996),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3004) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(0.9996),srs::spar::x_0<>(2520000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3005) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(50),srs::spar::lat_2<>(58.5),srs::spar::lat_0<>(45),srs::spar::lon_0<>(-126),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3006) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<33>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<33>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3007) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(12),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3008) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(13.5),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3009) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3010) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(16.5),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3011) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3012) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(14.25),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3013) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15.75),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3014) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(17.25),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3015) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18.75),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3016) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(20.25),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3017) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21.75),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3018) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(23.25),srs::spar::k<>(1),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3019) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(11.30827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3020) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(13.55827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3021) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15.80827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3022) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18.05827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3023) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(20.30827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3024) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(22.55827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3025) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(11.30827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3026) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(13.55827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3027) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15.80827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3028) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18.05827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3029) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(20.30827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3030) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(22.55827777777778),srs::spar::k<>(1),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3031) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-71),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3032) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-71),srs::spar::lon_0<>(70),srs::spar::k<>(1),srs::spar::x_0<>(6000000),srs::spar::y_0<>(6000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3033) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.5),srs::spar::lat_2<>(-74.5),srs::spar::lat_0<>(-50),srs::spar::lon_0<>(70),srs::spar::x_0<>(6000000),srs::spar::y_0<>(6000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3034) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35),srs::spar::lat_2<>(65),srs::spar::lat_0<>(52),srs::spar::lon_0<>(10),srs::spar::x_0<>(4000000),srs::spar::y_0<>(2800000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3035) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(52),srs::spar::lon_0<>(10),srs::spar::x_0<>(4321000),srs::spar::y_0<>(3210000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3036) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<36>,srs::spar::south,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<36>(),srs::spar::south(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,-0,-0,-0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3037) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<37>,srs::spar::south,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<37>(),srs::spar::south(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,-0,-0,-0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3038) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<26>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3039) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<27>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3040) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3041) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3042) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<30>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3043) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<31>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3044) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<32>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3045) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<33>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3046) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<34>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3047) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<35>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3048) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<36>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3049) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<37>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3050) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<38>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3051) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<39>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3052)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3053)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3054) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<26>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<26>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-73,46,-86,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3055) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<27>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<27>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-73,46,-86,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3056) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<28>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-73,46,-86,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3057) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(64.25),srs::spar::lat_2<>(65.75),srs::spar::lat_0<>(65),srs::spar::lon_0<>(-19),srs::spar::x_0<>(500000),srs::spar::y_0<>(500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3058) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-8.5),srs::spar::k<>(1),srs::spar::x_0<>(50000),srs::spar::y_0<>(-7800000),srs::spar::ellps_intl(),srs::spar::towgs84<>(982.609,552.753,-540.873,32.3934,-153.257,-96.2266,16.805)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3059) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(-6000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3060) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3061) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3062) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<26>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3063) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<26>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3064) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<32>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<32>(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3065) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<33>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<33>(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3066) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(37),srs::spar::k<>(0.9998),srs::spar::x_0<>(500000),srs::spar::y_0<>(-3000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3067) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<35>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3068) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::datum_potsdam,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(52.41864827777778),srs::spar::lon_0<>(13.62720366666667),srs::spar::x_0<>(40000),srs::spar::y_0<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3069) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-90),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(-4500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3070) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-90),srs::spar::k<>(0.9996),srs::spar::x_0<>(520000),srs::spar::y_0<>(-4480000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3071) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-90),srs::spar::k<>(0.9996),srs::spar::x_0<>(520000),srs::spar::y_0<>(-4480000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3072) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-67.875),srs::spar::k<>(0.99998),srs::spar::x_0<>(700000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3073) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43),srs::spar::lon_0<>(-69.125),srs::spar::k<>(0.99998),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3074) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.83333333333334),srs::spar::lon_0<>(-70.375),srs::spar::k<>(0.99998),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3075) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-67.875),srs::spar::k<>(0.99998),srs::spar::x_0<>(700000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3076) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43),srs::spar::lon_0<>(-69.125),srs::spar::k<>(0.99998),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3077) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.83333333333334),srs::spar::lon_0<>(-70.375),srs::spar::k<>(0.99998),srs::spar::x_0<>(300000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3078) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(45.30916666666666),srs::spar::lonc<>(-86),srs::spar::alpha<>(337.25556),srs::spar::k<>(0.9996),srs::spar::x_0<>(2546731.496),srs::spar::y_0<>(-4354009.816)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3079) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(45.30916666666666),srs::spar::lonc<>(-86),srs::spar::alpha<>(337.25556),srs::spar::k<>(0.9996),srs::spar::x_0<>(2546731.496),srs::spar::y_0<>(-4354009.816)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3080) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.41666666666667),srs::spar::lat_2<>(34.91666666666666),srs::spar::lat_0<>(31.16666666666667),srs::spar::lon_0<>(-100),srs::spar::x_0<>(914400),srs::spar::y_0<>(914400),srs::spar::ellps_clrk66(),srs::spar::datum_nad27(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3081) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.41666666666667),srs::spar::lat_2<>(34.91666666666666),srs::spar::lat_0<>(31.16666666666667),srs::spar::lon_0<>(-100),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3082) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.5),srs::spar::lat_2<>(35),srs::spar::lat_0<>(18),srs::spar::lon_0<>(-100),srs::spar::x_0<>(1500000),srs::spar::y_0<>(5000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3083) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(27.5),srs::spar::lat_2<>(35),srs::spar::lat_0<>(18),srs::spar::lon_0<>(-100),srs::spar::x_0<>(1500000),srs::spar::y_0<>(6000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3084) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.5),srs::spar::lat_2<>(35),srs::spar::lat_0<>(18),srs::spar::lon_0<>(-100),srs::spar::x_0<>(1500000),srs::spar::y_0<>(5000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3085) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(27.5),srs::spar::lat_2<>(35),srs::spar::lat_0<>(18),srs::spar::lon_0<>(-100),srs::spar::x_0<>(1500000),srs::spar::y_0<>(6000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3086) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(24),srs::spar::lat_2<>(31.5),srs::spar::lat_0<>(24),srs::spar::lon_0<>(-84),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3087) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(24),srs::spar::lat_2<>(31.5),srs::spar::lat_0<>(24),srs::spar::lon_0<>(-84),srs::spar::x_0<>(400000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3088) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.08333333333334),srs::spar::lat_2<>(38.66666666666666),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(1500000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3089) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.08333333333334),srs::spar::lat_2<>(38.66666666666666),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(1500000),srs::spar::y_0<>(999999.9998983998),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3090) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.08333333333334),srs::spar::lat_2<>(38.66666666666666),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(1500000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3091) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.08333333333334),srs::spar::lat_2<>(38.66666666666666),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(1500000),srs::spar::y_0<>(999999.9998983998),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3092) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<51>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3093) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<52>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3094) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<53>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3095) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<54>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3096) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<55>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3097) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<51>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<51>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3098) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<52>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<52>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3099) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<53>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<53>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3100) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<54>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<54>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3101) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<55>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<55>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3102) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-14.26666666666667),srs::spar::lat_0<>(-14.26666666666667),srs::spar::lon_0<>(-170),srs::spar::k_0<>(1),srs::spar::x_0<>(152400.3048006096),srs::spar::y_0<>(95169.31165862332),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(-115,118,426,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3103) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3104) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3105) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<30>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3106) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(90),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6377276.345),srs::spar::b<>(6356075.41314024)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3107) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-28),srs::spar::lat_2<>(-36),srs::spar::lat_0<>(-32),srs::spar::lon_0<>(135),srs::spar::x_0<>(1000000),srs::spar::y_0<>(2000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3108) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(49.5),srs::spar::lon_0<>(-2.416666666666667),srs::spar::k<>(0.999997),srs::spar::x_0<>(47000),srs::spar::y_0<>(50000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3109) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(49.225),srs::spar::lon_0<>(-2.135),srs::spar::k<>(0.9999999000000001),srs::spar::x_0<>(40000),srs::spar::y_0<>(70000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3110) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_aust_sa,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-36),srs::spar::lat_2<>(-38),srs::spar::lat_0<>(-37),srs::spar::lon_0<>(145),srs::spar::x_0<>(2500000),srs::spar::y_0<>(4500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3111) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-36),srs::spar::lat_2<>(-38),srs::spar::lat_0<>(-37),srs::spar::lon_0<>(145),srs::spar::x_0<>(2500000),srs::spar::y_0<>(2500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3112) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-18),srs::spar::lat_2<>(-36),srs::spar::lat_0<>(0),srs::spar::lon_0<>(134),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3113) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-28),srs::spar::lon_0<>(153),srs::spar::k<>(0.99999),srs::spar::x_0<>(50000),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3114) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(4.596200416666666),srs::spar::lon_0<>(-80.07750791666666),srs::spar::k<>(1),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3115) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(4.596200416666666),srs::spar::lon_0<>(-77.07750791666666),srs::spar::k<>(1),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3116) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(4.596200416666666),srs::spar::lon_0<>(-74.07750791666666),srs::spar::k<>(1),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3117) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(4.596200416666666),srs::spar::lon_0<>(-71.07750791666666),srs::spar::k<>(1),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3118) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(4.596200416666666),srs::spar::lon_0<>(-68.07750791666666),srs::spar::k<>(1),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3119) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(10.5),srs::spar::k<>(0.999),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000),srs::spar::ellps_intl(),srs::spar::towgs84<>(-206.1,-174.7,-87.7,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3120) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(50.625),srs::spar::lon_0<>(21.08333333333333),srs::spar::k<>(0.9998),srs::spar::x_0<>(4637000),srs::spar::y_0<>(5467000),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3121) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(117),srs::spar::k<>(0.99995),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3122) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(119),srs::spar::k<>(0.99995),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3123) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(121),srs::spar::k<>(0.99995),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3124) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(123),srs::spar::k<>(0.99995),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3125) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(125),srs::spar::k<>(0.99995),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3126) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(19),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3127) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(20),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3128) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3129) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(22),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3130) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(23),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3131) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3132) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(25),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3133) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(26),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3134) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3135) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(28),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3136) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(29),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3137) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(30),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3138) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(31),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3139)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3140) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(-18),srs::spar::lon_0<>(178),srs::spar::x_0<>(109435.392),srs::spar::y_0<>(141622.272),srs::spar::a<>(6378306.3696),srs::spar::b<>(6356571.996),srs::spar::towgs84<>(51,391,-36,0,0,0,0),srs::spar::to_meter<>(0.201168)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3141) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<60>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<60>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(265.025,384.929,-194.046,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3142) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<1>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<1>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(265.025,384.929,-194.046,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3143) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs72,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-17),srs::spar::lon_0<>(178.75),srs::spar::k<>(0.99985),srs::spar::x_0<>(2000000),srs::spar::y_0<>(4000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3144)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3145)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3146) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18),srs::spar::k<>(1),srs::spar::x_0<>(6500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3147) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3148) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<48>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<48>(),srs::spar::a<>(6377276.345),srs::spar::b<>(6356075.41314024)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3149) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<49>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<49>(),srs::spar::a<>(6377276.345),srs::spar::b<>(6356075.41314024)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3150) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18),srs::spar::k<>(1),srs::spar::x_0<>(6500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3151) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3152) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18.05779),srs::spar::k<>(0.99999425),srs::spar::x_0<>(100178.1808),srs::spar::y_0<>(-6500614.7836),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3153) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(50),srs::spar::lat_2<>(58.5),srs::spar::lat_0<>(45),srs::spar::lon_0<>(-126),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3154) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<7>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3155) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<8>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3156) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<9>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3157) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<10>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3158) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<14>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3159) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<15>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3160) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<16>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3161) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.5),srs::spar::lat_2<>(53.5),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-85),srs::spar::x_0<>(930000),srs::spar::y_0<>(6430000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3162) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.5),srs::spar::lat_2<>(53.5),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-85),srs::spar::x_0<>(930000),srs::spar::y_0<>(6430000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3163) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-20.66666666666667),srs::spar::lat_2<>(-22.33333333333333),srs::spar::lat_0<>(-21.5),srs::spar::lon_0<>(166),srs::spar::x_0<>(400000),srs::spar::y_0<>(300000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3164) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<58>(),srs::spar::south(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(-56.263,16.136,-22.856,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3165) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-22.24469175),srs::spar::lat_2<>(-22.29469175),srs::spar::lat_0<>(-22.26969175),srs::spar::lon_0<>(166.44242575),srs::spar::x_0<>(0.66),srs::spar::y_0<>(1.02)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3166) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-22.24472222222222),srs::spar::lat_2<>(-22.29472222222222),srs::spar::lat_0<>(-22.26972222222222),srs::spar::lon_0<>(166.4425),srs::spar::x_0<>(8.313000000000001),srs::spar::y_0<>(-2.354)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3167) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(4),srs::spar::lonc<>(102.25),srs::spar::alpha<>(323.0257905),srs::spar::k<>(0.99984),srs::spar::x_0<>(40000),srs::spar::y_0<>(0),srs::spar::a<>(6377295.664),srs::spar::b<>(6356094.667915204),srs::spar::to_meter<>(20.116756)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3168) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(4),srs::spar::lonc<>(102.25),srs::spar::alpha<>(323.0257905),srs::spar::k<>(0.99984),srs::spar::x_0<>(804670.24),srs::spar::y_0<>(0),srs::spar::a<>(6377295.664),srs::spar::b<>(6356094.667915204)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3169) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<57>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<57>(),srs::spar::south(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3170) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<58>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<58>(),srs::spar::south(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3171) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<59>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<59>(),srs::spar::south(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3172) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<59>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3173)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3174) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(42.122774),srs::spar::lat_2<>(49.01518),srs::spar::lat_0<>(45.568977),srs::spar::lon_0<>(-84.455955),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3175) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(42.122774),srs::spar::lat_2<>(49.01518),srs::spar::lat_0<>(45.568977),srs::spar::lon_0<>(-83.248627),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3176) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(106),srs::spar::k<>(0.9996),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::a<>(6377276.345),srs::spar::b<>(6356075.41314024)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3177) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(17),srs::spar::k<>(0.9965000000000001),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3178) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<18>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<18>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3179) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<19>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<19>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3180) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<20>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3181) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<21>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<21>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3182) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<22>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<22>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3183) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<23>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<23>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3184) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<24>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<24>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3185) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<25>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<25>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3186) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<26>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<26>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3187) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<27>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<27>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3188) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<28>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3189) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<29>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3190) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(9),srs::spar::k<>(0.99995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3191) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(11),srs::spar::k<>(0.99995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3192) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(13),srs::spar::k<>(0.99995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3193) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(0.99995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3194) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(17),srs::spar::k<>(0.99995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3195) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(19),srs::spar::k<>(0.99995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3196) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(0.99995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3197) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(23),srs::spar::k<>(0.99995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3198) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(25),srs::spar::k<>(0.99995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3199) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<32>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<32>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3200) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.5),srs::spar::lat_0<>(32.5),srs::spar::lon_0<>(45),srs::spar::k_0<>(0.9987864078000001),srs::spar::x_0<>(1500000),srs::spar::y_0<>(1166200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3201) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<33>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<33>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3202) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<34>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<34>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3203) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<35>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<35>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3204) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-60.66666666666666),srs::spar::lat_2<>(-63.33333333333334),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-66),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3205) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-60.66666666666666),srs::spar::lat_2<>(-63.33333333333334),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-54),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3206) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-60.66666666666666),srs::spar::lat_2<>(-63.33333333333334),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-42),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3207) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-174),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3208) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-66),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3209) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-54),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3210) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(42),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3211) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(54),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3212) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(66),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3213) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(78),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3214) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(90),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3215) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(102),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3216) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(114),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3217) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(126),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3218) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(138),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3219) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(150),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3220) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-64.66666666666667),srs::spar::lat_2<>(-67.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(162),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3221) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-102),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3222) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-90),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3223) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-78),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3224) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-66),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3225) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-18),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3226) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-6),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3227) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(6),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3228) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(18),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3229) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(30),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3230) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(42),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3231) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(54),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3232) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(66),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3233) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(78),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3234) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(90),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3235) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(102),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3236) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(114),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3237) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(126),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3238) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(138),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3239) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(150),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3240) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(162),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3241) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-68.66666666666667),srs::spar::lat_2<>(-71.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(174),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3242) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-153),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3243) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-135),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3244) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-117),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3245) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-99),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3246) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-81),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3247) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-63),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3248) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-27),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3249) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-9),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3250) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(9),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3251) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(27),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3252) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(45),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3253) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(63),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3254) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(81),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3255) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(99),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3256) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(117),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3257) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(135),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3258) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(153),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3259) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-72.66666666666667),srs::spar::lat_2<>(-75.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(171),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3260) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-168),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3261) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-144),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3262) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-120),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3263) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-96),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3264) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-72),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3265) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-48),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3266) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(-24),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3267) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3268) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(24),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3269) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(48),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3270) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(72),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3271) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(96),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3272) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(120),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3273) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(144),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3274) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(168),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3275) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(-165),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3276) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(-135),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3277) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(-105),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3278) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(-75),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3279) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(-45),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3280) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(-15),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3281) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(15),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3282) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(45),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3283) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(75),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3284) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(105),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3285) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(135),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3286) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(165),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3287) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(-150),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3288) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(-90),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3289) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(-30),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3290) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(30),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3291) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(90),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3292) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(150),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3293) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-80.23861111111111),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3294) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-76.66666666666667),srs::spar::lat_2<>(-79.33333333333333),srs::spar::lat_0<>(-78),srs::spar::lon_0<>(162),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3295)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3296) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<5>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3297) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<6>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3298) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<7>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3299) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<8>,srs::spar::south,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3300) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(59.33333333333334),srs::spar::lat_2<>(58),srs::spar::lat_0<>(57.51755393055556),srs::spar::lon_0<>(24),srs::spar::x_0<>(500000),srs::spar::y_0<>(6375000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3301) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(59.33333333333334),srs::spar::lat_2<>(58),srs::spar::lat_0<>(57.51755393055556),srs::spar::lon_0<>(24),srs::spar::x_0<>(500000),srs::spar::y_0<>(6375000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3302) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<7>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3303) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<7>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<7>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3304) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<6>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3305) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<6>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<6>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3306) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<5>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<5>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(217.037,86.959,23.956,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3307) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<39>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<39>(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,-0.15,0.68,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3308) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-30.75),srs::spar::lat_2<>(-35.75),srs::spar::lat_0<>(-33.25),srs::spar::lon_0<>(147),srs::spar::x_0<>(9300000),srs::spar::y_0<>(4500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3309) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(34),srs::spar::lat_2<>(40.5),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-120),srs::spar::x_0<>(0),srs::spar::y_0<>(-4000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3310) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(34),srs::spar::lat_2<>(40.5),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-120),srs::spar::x_0<>(0),srs::spar::y_0<>(-4000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3311) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(34),srs::spar::lat_2<>(40.5),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-120),srs::spar::x_0<>(0),srs::spar::y_0<>(-4000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3312) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<21>,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<21>(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-186,230,110,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3313) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<21>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<21>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(2,2,-2,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3314) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-6.5),srs::spar::lat_2<>(-11.5),srs::spar::lat_0<>(0),srs::spar::lon_0<>(26),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3315) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-9),srs::spar::lon_0<>(26),srs::spar::k<>(0.9998),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3316) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(22),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3317) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3318) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(12),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3319) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(14),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3320) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(16),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3321) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3322) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(20),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3323) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(22),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3324) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3325) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(26),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3326) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(28),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3327) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(30),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3328) srs::spar::parameters<srs::spar::proj_sterea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sterea(),srs::spar::lat_0<>(52.16666666666666),srs::spar::lon_0<>(19.16666666666667),srs::spar::k<>(0.999714),srs::spar::x_0<>(500000),srs::spar::y_0<>(500000),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3329) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(1),srs::spar::x_0<>(5500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3330) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18),srs::spar::k<>(1),srs::spar::x_0<>(6500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3331) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(7500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3332) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(1),srs::spar::x_0<>(8500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3333) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(1),srs::spar::x_0<>(3500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3334) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(21),srs::spar::k<>(1),srs::spar::x_0<>(4500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3335) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(27),srs::spar::k<>(1),srs::spar::x_0<>(5500000),srs::spar::y_0<>(0),srs::spar::ellps_krass(),srs::spar::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3336) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<42>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<42>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(145,-187,103,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3337) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-20.19506944444445),srs::spar::lat_0<>(-20.19506944444445),srs::spar::lon_0<>(57.52182777777778),srs::spar::k_0<>(1),srs::spar::x_0<>(1000000),srs::spar::y_0<>(1000000),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-770.1,158.4,-498.2,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3338) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(55),srs::spar::lat_2<>(65),srs::spar::lat_0<>(50),srs::spar::lon_0<>(-154),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3339) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(12),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-79.9,-158,-168.9,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3340) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(14),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-79.9,-158,-168.9,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3341) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(16),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(10000000),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-79.9,-158,-168.9,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3342) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<33>,srs::spar::south,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<33>(),srs::spar::south(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-79.9,-158,-168.9,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3343) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<28>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3344) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<29>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3345) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<30>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<30>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3346) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(24),srs::spar::k<>(0.9998),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3347) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49),srs::spar::lat_2<>(77),srs::spar::lat_0<>(63.390675),srs::spar::lon_0<>(-91.86666666666666),srs::spar::x_0<>(6200000),srs::spar::y_0<>(3000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3348) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49),srs::spar::lat_2<>(77),srs::spar::lat_0<>(63.390675),srs::spar::lon_0<>(-91.86666666666666),srs::spar::x_0<>(6200000),srs::spar::y_0<>(3000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3349) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(-150),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3350) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0.1),srs::spar::lon_0<>(21.95),srs::spar::k<>(1),srs::spar::x_0<>(250000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3351) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0.1),srs::spar::lon_0<>(24.95),srs::spar::k<>(1),srs::spar::x_0<>(1250000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3352) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0.1),srs::spar::lon_0<>(27.95),srs::spar::k<>(1),srs::spar::x_0<>(2250000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3353) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<32>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3354) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<32>,srs::spar::south,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3355) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_helmert,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(31),srs::spar::k<>(1),srs::spar::x_0<>(615000),srs::spar::y_0<>(810000),srs::spar::ellps_helmert(),srs::spar::towgs84<>(-146.21,112.63,4.05,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3356) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<17>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<17>(),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(67.8,106.1,138.8,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3357) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<17>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3358) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.16666666666666),srs::spar::lat_2<>(34.33333333333334),srs::spar::lat_0<>(33.75),srs::spar::lon_0<>(-79),srs::spar::x_0<>(609601.22),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3359) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.16666666666666),srs::spar::lat_2<>(34.33333333333334),srs::spar::lat_0<>(33.75),srs::spar::lon_0<>(-79),srs::spar::x_0<>(609601.2192024385),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3360) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.83333333333334),srs::spar::lat_2<>(32.5),srs::spar::lat_0<>(31.83333333333333),srs::spar::lon_0<>(-81),srs::spar::x_0<>(609600),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3361) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.83333333333334),srs::spar::lat_2<>(32.5),srs::spar::lat_0<>(31.83333333333333),srs::spar::lon_0<>(-81),srs::spar::x_0<>(609600),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3362) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.95),srs::spar::lat_2<>(40.88333333333333),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3363) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.95),srs::spar::lat_2<>(40.88333333333333),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3364) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.96666666666667),srs::spar::lat_2<>(39.93333333333333),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3365) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.96666666666667),srs::spar::lat_2<>(39.93333333333333),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3366) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(22.31213333333334),srs::spar::lon_0<>(114.1785555555556),srs::spar::x_0<>(40243.57775604237),srs::spar::y_0<>(19069.93351512578),srs::spar::a<>(6378293.645208759),srs::spar::b<>(6356617.987679838)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3367) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3368) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3369) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<30>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3370) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<59>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3371) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<60>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3372) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<59>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3373) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<60>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3374) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3375) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(4),srs::spar::lonc<>(102.25),srs::spar::alpha<>(323.0257964666666),srs::spar::k<>(0.99984),srs::spar::x_0<>(804671),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3376) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(4),srs::spar::lonc<>(115),srs::spar::alpha<>(53.31580995),srs::spar::k<>(0.99984),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3377) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(2.121679744444445),srs::spar::lon_0<>(103.4279362361111),srs::spar::x_0<>(-14810.562),srs::spar::y_0<>(8758.32)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3378) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(2.682347636111111),srs::spar::lon_0<>(101.9749050416667),srs::spar::x_0<>(3673.785),srs::spar::y_0<>(-4240.573)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3379) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(3.769388088888889),srs::spar::lon_0<>(102.3682989833333),srs::spar::x_0<>(-7368.228),srs::spar::y_0<>(6485.858)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3380) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(3.68464905),srs::spar::lon_0<>(101.3891079138889),srs::spar::x_0<>(-34836.161),srs::spar::y_0<>(56464.049)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3381) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(4.9762852),srs::spar::lon_0<>(103.070275625),srs::spar::x_0<>(19594.245),srs::spar::y_0<>(3371.895)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3382) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(5.421517541666667),srs::spar::lon_0<>(100.3443769638889),srs::spar::x_0<>(-23.414),srs::spar::y_0<>(62.283)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3383) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(5.964672713888889),srs::spar::lon_0<>(100.6363711111111),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3384) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(4.859063022222222),srs::spar::lon_0<>(100.8154105861111),srs::spar::x_0<>(-1.769),srs::spar::y_0<>(133454.779)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3385) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(5.972543658333334),srs::spar::lon_0<>(102.2952416694444),srs::spar::x_0<>(13227.851),srs::spar::y_0<>(8739.894)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3386) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(18),srs::spar::k<>(1),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3387) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(33),srs::spar::k<>(1),srs::spar::x_0<>(5500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3388) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(51),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3389) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(180),srs::spar::k<>(1),srs::spar::x_0<>(60500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3390) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_krass,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(180),srs::spar::k<>(1),srs::spar::x_0<>(60500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3391) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<37>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<37>(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(84.1,-320.1,218.7,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3392) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<38>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<38>(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(84.1,-320.1,218.7,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3393) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<39>,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<39>(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(84.1,-320.1,218.7,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3394) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.5),srs::spar::lat_0<>(32.5),srs::spar::lon_0<>(45),srs::spar::k_0<>(0.9987864078000001),srs::spar::x_0<>(1500000),srs::spar::y_0<>(1166200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3395) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3396) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(9),srs::spar::k<>(1),srs::spar::x_0<>(3500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3397) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(12),srs::spar::k<>(1),srs::spar::x_0<>(4500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3398) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(12),srs::spar::k<>(1),srs::spar::x_0<>(4500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3399) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(1),srs::spar::x_0<>(5500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3400) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-115),srs::spar::k<>(0.9992),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3401) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-115),srs::spar::k<>(0.9992),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3402) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-115),srs::spar::k<>(0.9992),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3403) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-115),srs::spar::k<>(0.9992),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3404) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.16666666666666),srs::spar::lat_2<>(34.33333333333334),srs::spar::lat_0<>(33.75),srs::spar::lon_0<>(-79),srs::spar::x_0<>(609601.2192024384),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3405) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<48>,srs::spar::ellps_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3406) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<49>,srs::spar::ellps_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3407) srs::spar::parameters<srs::spar::proj_cass,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cass(),srs::spar::lat_0<>(22.31213333333334),srs::spar::lon_0<>(114.1785555555556),srs::spar::x_0<>(40243.57775604237),srs::spar::y_0<>(19069.93351512578),srs::spar::a<>(6378293.645208759),srs::spar::b<>(6356617.987679838),srs::spar::to_meter<>(0.3047972654)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3408) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371228)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3409) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371228)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3410) srs::spar::parameters<srs::spar::proj_cea,srs::spar::lon_0<>,srs::spar::lat_ts<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_cea(),srs::spar::lon_0<>(0),srs::spar::lat_ts<>(30),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371228)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3411) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lat_ts<>(70),srs::spar::lon_0<>(-45),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378273),srs::spar::b<>(6356889.449)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3412) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lat_ts<>(-70),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378273),srs::spar::b<>(6356889.449)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3413) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lat_ts<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lat_ts<>(70),srs::spar::lon_0<>(-45),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3414) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(1.366666666666667),srs::spar::lon_0<>(103.8333333333333),srs::spar::k<>(1),srs::spar::x_0<>(28001.642),srs::spar::y_0<>(38744.572)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3415) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs72,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(18),srs::spar::lat_2<>(24),srs::spar::lat_0<>(21),srs::spar::lon_0<>(114),srs::spar::x_0<>(500000),srs::spar::y_0<>(500000),srs::spar::ellps_wgs72(),srs::spar::towgs84<>(0,0,1.9,0,0,0.814,-0.38)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3416) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49),srs::spar::lat_2<>(46),srs::spar::lat_0<>(47.5),srs::spar::lon_0<>(13.33333333333333),srs::spar::x_0<>(400000),srs::spar::y_0<>(400000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3417) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.26666666666667),srs::spar::lat_2<>(42.06666666666667),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(1500000),srs::spar::y_0<>(999999.9999898402),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3418) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.61666666666667),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3419) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.78333333333333),srs::spar::lat_2<>(38.71666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3420) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.56666666666667),srs::spar::lat_2<>(37.26666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(399999.99998984),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3421) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-115.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000.00001016),srs::spar::y_0<>(8000000.000010163),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3422) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-116.6666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(6000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3423) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-118.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(800000.0000101599),srs::spar::y_0<>(3999999.99998984),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3424) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3425) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.26666666666667),srs::spar::lat_2<>(42.06666666666667),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(1500000),srs::spar::y_0<>(999999.9999898402),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3426) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.61666666666667),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3427) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.78333333333333),srs::spar::lat_2<>(38.71666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3428) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.56666666666667),srs::spar::lat_2<>(37.26666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(399999.99998984),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3429) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-115.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000.00001016),srs::spar::y_0<>(8000000.000010163),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3430) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-116.6666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(6000000),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3431) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-118.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(800000.0000101599),srs::spar::y_0<>(3999999.99998984),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3432) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3433) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.23333333333333),srs::spar::lat_2<>(34.93333333333333),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-92),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3434) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.76666666666667),srs::spar::lat_2<>(33.3),srs::spar::lat_0<>(32.66666666666666),srs::spar::lon_0<>(-92),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(399999.99998984),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3435) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-88.33333333333333),srs::spar::k<>(0.9999749999999999),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3436) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-90.16666666666667),srs::spar::k<>(0.999941177),srs::spar::x_0<>(699999.9999898402),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3437) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-71.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3438) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.08333333333334),srs::spar::lon_0<>(-71.5),srs::spar::k<>(0.99999375),srs::spar::x_0<>(99999.99998983997),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3439) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<39>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3440) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<40>,srs::spar::ellps_clrk80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3441) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.23333333333333),srs::spar::lat_2<>(34.93333333333333),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-92),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3442) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.76666666666667),srs::spar::lat_2<>(33.3),srs::spar::lat_0<>(32.66666666666666),srs::spar::lon_0<>(-92),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(399999.99998984),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3443) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-88.33333333333333),srs::spar::k<>(0.9999749999999999),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3444) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-90.16666666666667),srs::spar::k<>(0.999941177),srs::spar::x_0<>(699999.9999898402),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3445) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-71.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3446) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.08333333333334),srs::spar::lon_0<>(-71.5),srs::spar::k<>(0.99999375),srs::spar::x_0<>(99999.99998983997),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3447) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49.83333333333334),srs::spar::lat_2<>(51.16666666666666),srs::spar::lat_0<>(50.797815),srs::spar::lon_0<>(4.359215833333333),srs::spar::x_0<>(150328),srs::spar::y_0<>(166262)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3448) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(18),srs::spar::lat_0<>(18),srs::spar::lon_0<>(-77),srs::spar::k_0<>(1),srs::spar::x_0<>(750000),srs::spar::y_0<>(650000),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3449) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<17>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<17>(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3450) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<18>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<18>(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3451) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.66666666666666),srs::spar::lat_2<>(31.16666666666667),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-92.5),srs::spar::x_0<>(999999.9999898402),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3452) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.7),srs::spar::lat_2<>(29.3),srs::spar::lat_0<>(28.5),srs::spar::lon_0<>(-91.33333333333333),srs::spar::x_0<>(999999.9999898402),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3453) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.83333333333333),srs::spar::lat_2<>(26.16666666666667),srs::spar::lat_0<>(25.5),srs::spar::lon_0<>(-91.33333333333333),srs::spar::x_0<>(999999.9999898402),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3454) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.4),srs::spar::lat_2<>(42.83333333333334),srs::spar::lat_0<>(42.33333333333334),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3455) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.4),srs::spar::lat_2<>(42.83333333333334),srs::spar::lat_0<>(42.33333333333334),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3456) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.66666666666666),srs::spar::lat_2<>(31.16666666666667),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-92.5),srs::spar::x_0<>(999999.9999898402),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3457) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.7),srs::spar::lat_2<>(29.3),srs::spar::lat_0<>(28.5),srs::spar::lon_0<>(-91.33333333333333),srs::spar::x_0<>(999999.9999898402),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3458) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.68333333333333),srs::spar::lat_2<>(44.41666666666666),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-100),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3459) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.4),srs::spar::lat_2<>(42.83333333333334),srs::spar::lat_0<>(42.33333333333334),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3460) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs72,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-17),srs::spar::lon_0<>(178.75),srs::spar::k<>(0.99985),srs::spar::x_0<>(2000000),srs::spar::y_0<>(4000000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3461) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<28>,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<28>(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356515),srs::spar::towgs84<>(-83,37,124,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3462) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<29>,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<29>(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356515),srs::spar::towgs84<>(-83,37,124,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3463) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43.5),srs::spar::lon_0<>(-69.125),srs::spar::k<>(0.99998),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3464) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43.5),srs::spar::lon_0<>(-69.125),srs::spar::k<>(0.99998),srs::spar::x_0<>(500000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3465) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-85.83333333333333),srs::spar::k<>(0.99996),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3466) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-87.5),srs::spar::k<>(0.999933333),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3467) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(55),srs::spar::lat_2<>(65),srs::spar::lat_0<>(50),srs::spar::lon_0<>(-154),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3468) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(57),srs::spar::lonc<>(-133.6666666666667),srs::spar::alpha<>(323.1301023611111),srs::spar::k<>(0.9999),srs::spar::x_0<>(5000000),srs::spar::y_0<>(-5000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3469) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-142),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3470) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-146),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3471) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-150),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3472) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-154),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3473) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-158),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3474) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-162),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3475) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-166),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3476) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(54),srs::spar::lon_0<>(-170),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3477) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(53.83333333333334),srs::spar::lat_2<>(51.83333333333334),srs::spar::lat_0<>(51),srs::spar::lon_0<>(-176),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3478) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-111.9166666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3479) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-111.9166666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3480) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-110.1666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3481) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-110.1666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3482) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-113.75),srs::spar::k<>(0.999933333),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3483) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-113.75),srs::spar::k<>(0.999933333),srs::spar::x_0<>(213360),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3484) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.23333333333333),srs::spar::lat_2<>(34.93333333333333),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-92),srs::spar::x_0<>(400000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3485) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.23333333333333),srs::spar::lat_2<>(34.93333333333333),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-92),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3486) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.76666666666667),srs::spar::lat_2<>(33.3),srs::spar::lat_0<>(32.66666666666666),srs::spar::lon_0<>(-92),srs::spar::x_0<>(400000),srs::spar::y_0<>(400000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3487) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.76666666666667),srs::spar::lat_2<>(33.3),srs::spar::lat_0<>(32.66666666666666),srs::spar::lon_0<>(-92),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(399999.99998984),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3488) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(34),srs::spar::lat_2<>(40.5),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-120),srs::spar::x_0<>(0),srs::spar::y_0<>(-4000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3489) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.66666666666666),srs::spar::lat_2<>(40),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3490) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.66666666666666),srs::spar::lat_2<>(40),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3491) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.83333333333334),srs::spar::lat_2<>(38.33333333333334),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3492) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.83333333333334),srs::spar::lat_2<>(38.33333333333334),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-122),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3493) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.43333333333333),srs::spar::lat_2<>(37.06666666666667),srs::spar::lat_0<>(36.5),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3494) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.43333333333333),srs::spar::lat_2<>(37.06666666666667),srs::spar::lat_0<>(36.5),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3495) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.25),srs::spar::lat_2<>(36),srs::spar::lat_0<>(35.33333333333334),srs::spar::lon_0<>(-119),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3496) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.25),srs::spar::lat_2<>(36),srs::spar::lat_0<>(35.33333333333334),srs::spar::lon_0<>(-119),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3497) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.46666666666667),srs::spar::lat_2<>(34.03333333333333),srs::spar::lat_0<>(33.5),srs::spar::lon_0<>(-118),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3498) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.46666666666667),srs::spar::lat_2<>(34.03333333333333),srs::spar::lat_0<>(33.5),srs::spar::lon_0<>(-118),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3499) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.88333333333333),srs::spar::lat_2<>(32.78333333333333),srs::spar::lat_0<>(32.16666666666666),srs::spar::lon_0<>(-116.25),srs::spar::x_0<>(2000000),srs::spar::y_0<>(500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3500) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.88333333333333),srs::spar::lat_2<>(32.78333333333333),srs::spar::lat_0<>(32.16666666666666),srs::spar::lon_0<>(-116.25),srs::spar::x_0<>(2000000.0001016),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3501) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.75),srs::spar::lat_2<>(38.45),srs::spar::lat_0<>(37.83333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3502) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.75),srs::spar::lat_2<>(38.45),srs::spar::lat_0<>(37.83333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8288036576),srs::spar::y_0<>(304800.6096012192),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3503) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.78333333333333),srs::spar::lat_2<>(39.71666666666667),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3504) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.78333333333333),srs::spar::lat_2<>(39.71666666666667),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8288036576),srs::spar::y_0<>(304800.6096012192),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3505) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.43333333333333),srs::spar::lat_2<>(37.23333333333333),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8289),srs::spar::y_0<>(304800.6096),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3506) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.43333333333333),srs::spar::lat_2<>(37.23333333333333),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-105.5),srs::spar::x_0<>(914401.8288036576),srs::spar::y_0<>(304800.6096012192),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3507) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.86666666666667),srs::spar::lat_2<>(41.2),srs::spar::lat_0<>(40.83333333333334),srs::spar::lon_0<>(-72.75),srs::spar::x_0<>(304800.6096),srs::spar::y_0<>(152400.3048),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3508) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.86666666666667),srs::spar::lat_2<>(41.2),srs::spar::lat_0<>(40.83333333333334),srs::spar::lon_0<>(-72.75),srs::spar::x_0<>(304800.6096012192),srs::spar::y_0<>(152400.3048006096),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3509) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-75.41666666666667),srs::spar::k<>(0.999995),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3510) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-75.41666666666667),srs::spar::k<>(0.999995),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3511) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-81),srs::spar::k<>(0.999941177),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3512) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-81),srs::spar::k<>(0.999941177),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3513) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(24),srs::spar::lat_2<>(31.5),srs::spar::lat_0<>(24),srs::spar::lon_0<>(-84),srs::spar::x_0<>(400000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3514) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.75),srs::spar::lat_2<>(29.58333333333333),srs::spar::lat_0<>(29),srs::spar::lon_0<>(-84.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3515) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.75),srs::spar::lat_2<>(29.58333333333333),srs::spar::lat_0<>(29),srs::spar::lon_0<>(-84.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3516) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-82),srs::spar::k<>(0.999941177),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3517) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(24.33333333333333),srs::spar::lon_0<>(-82),srs::spar::k<>(0.999941177),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3518) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-82.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3519) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-82.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3520) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-84.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(700000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3521) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(30),srs::spar::lon_0<>(-84.16666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(699999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3522) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-114),srs::spar::k<>(0.9999473679999999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3523) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-114),srs::spar::k<>(0.9999473679999999),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3524) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-112.1666666666667),srs::spar::k<>(0.9999473679999999),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3525) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-112.1666666666667),srs::spar::k<>(0.9999473679999999),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3526) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-115.75),srs::spar::k<>(0.999933333),srs::spar::x_0<>(800000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3527) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-115.75),srs::spar::k<>(0.999933333),srs::spar::x_0<>(800000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3528) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-88.33333333333333),srs::spar::k<>(0.9999749999999999),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3529) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-88.33333333333333),srs::spar::k<>(0.9999749999999999),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3530) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-90.16666666666667),srs::spar::k<>(0.999941177),srs::spar::x_0<>(700000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3531) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-90.16666666666667),srs::spar::k<>(0.999941177),srs::spar::x_0<>(699999.9999898402),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3532) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-85.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(100000),srs::spar::y_0<>(250000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3533) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-85.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(99999.99989839978),srs::spar::y_0<>(249999.9998983998),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3534) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-87.08333333333333),srs::spar::k<>(0.999966667),srs::spar::x_0<>(900000),srs::spar::y_0<>(250000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3535) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-87.08333333333333),srs::spar::k<>(0.999966667),srs::spar::x_0<>(900000),srs::spar::y_0<>(249999.9998983998),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3536) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.26666666666667),srs::spar::lat_2<>(42.06666666666667),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(1500000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3537) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.26666666666667),srs::spar::lat_2<>(42.06666666666667),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(1500000),srs::spar::y_0<>(999999.9999898402),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3538) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.61666666666667),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3539) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.61666666666667),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-93.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3540) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.78333333333333),srs::spar::lat_2<>(38.71666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(400000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3541) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.78333333333333),srs::spar::lat_2<>(38.71666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3542) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.56666666666667),srs::spar::lat_2<>(37.26666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(400000),srs::spar::y_0<>(400000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3543) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.56666666666667),srs::spar::lat_2<>(37.26666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(399999.99998984),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3544) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(38.96666666666667),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-84.25),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3545) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(38.96666666666667),srs::spar::lat_0<>(37.5),srs::spar::lon_0<>(-84.25),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3546) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.08333333333334),srs::spar::lat_2<>(38.66666666666666),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(1500000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3547) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.08333333333334),srs::spar::lat_2<>(38.66666666666666),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(1500000),srs::spar::y_0<>(999999.9998983998),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3548) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.93333333333333),srs::spar::lat_2<>(36.73333333333333),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(500000),srs::spar::y_0<>(500000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3549) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.93333333333333),srs::spar::lat_2<>(36.73333333333333),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-85.75),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(500000.0001016001),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3550) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.66666666666666),srs::spar::lat_2<>(31.16666666666667),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-92.5),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3551) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(32.66666666666666),srs::spar::lat_2<>(31.16666666666667),srs::spar::lat_0<>(30.5),srs::spar::lon_0<>(-92.5),srs::spar::x_0<>(999999.9999898402),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3552) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.7),srs::spar::lat_2<>(29.3),srs::spar::lat_0<>(28.5),srs::spar::lon_0<>(-91.33333333333333),srs::spar::x_0<>(1000000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3553) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.7),srs::spar::lat_2<>(29.3),srs::spar::lat_0<>(28.5),srs::spar::lon_0<>(-91.33333333333333),srs::spar::x_0<>(999999.9999898402),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3554) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43.5),srs::spar::lon_0<>(-69.125),srs::spar::k<>(0.99998),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3555) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-67.875),srs::spar::k<>(0.99998),srs::spar::x_0<>(700000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3556) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.83333333333334),srs::spar::lon_0<>(-70.375),srs::spar::k<>(0.99998),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3557) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-68.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3558) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.83333333333334),srs::spar::lon_0<>(-70.16666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(900000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3559) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.45),srs::spar::lat_2<>(38.3),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-77),srs::spar::x_0<>(400000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3560) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.71666666666667),srs::spar::lat_0<>(40.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(999999.9999898402),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3561) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(18.83333333333333),srs::spar::lon_0<>(-155.5),srs::spar::k<>(0.999966667),srs::spar::x_0<>(152400.3048006096),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3562) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(20.33333333333333),srs::spar::lon_0<>(-156.6666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(152400.3048006096),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3563) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.16666666666667),srs::spar::lon_0<>(-158),srs::spar::k<>(0.99999),srs::spar::x_0<>(152400.3048006096),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3564) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.83333333333333),srs::spar::lon_0<>(-159.5),srs::spar::k<>(0.99999),srs::spar::x_0<>(152400.3048006096),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3565) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.66666666666667),srs::spar::lon_0<>(-160.1666666666667),srs::spar::k<>(1),srs::spar::x_0<>(152400.3048006096),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3566) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.65),srs::spar::lat_2<>(39.01666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(2000000.00001016),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3567) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.35),srs::spar::lat_2<>(37.21666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(3000000),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3568) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.71666666666667),srs::spar::lat_0<>(40.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(999999.9999898402),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3569) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.65),srs::spar::lat_2<>(39.01666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(2000000.00001016),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3570) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.35),srs::spar::lat_2<>(37.21666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(3000000),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3571) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(180),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3572) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(-150),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3573) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(-100),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3574) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(-40),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3575) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(10),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3576) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(90),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3577) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(-18),srs::spar::lat_2<>(-36),srs::spar::lat_0<>(0),srs::spar::lon_0<>(132),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3578) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(61.66666666666666),srs::spar::lat_2<>(68),srs::spar::lat_0<>(59),srs::spar::lon_0<>(-132.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3579) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(61.66666666666666),srs::spar::lat_2<>(68),srs::spar::lat_0<>(59),srs::spar::lon_0<>(-132.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(500000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3580) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(62),srs::spar::lat_2<>(70),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-112),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3581) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(62),srs::spar::lat_2<>(70),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-112),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3582) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.45),srs::spar::lat_2<>(38.3),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-77),srs::spar::x_0<>(399999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3583) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.48333333333333),srs::spar::lat_2<>(41.28333333333333),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-70.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3584) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.48333333333333),srs::spar::lat_2<>(41.28333333333333),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-70.5),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3585) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.68333333333333),srs::spar::lat_2<>(41.71666666666667),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-71.5),srs::spar::x_0<>(200000),srs::spar::y_0<>(750000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3586) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.68333333333333),srs::spar::lat_2<>(41.71666666666667),srs::spar::lat_0<>(41),srs::spar::lon_0<>(-71.5),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(750000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3587) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.7),srs::spar::lat_2<>(44.18333333333333),srs::spar::lat_0<>(43.31666666666667),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(6000000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3588) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.7),srs::spar::lat_2<>(44.18333333333333),srs::spar::lat_0<>(43.31666666666667),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(5999999.999976001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3589) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.08333333333334),srs::spar::lat_2<>(45.48333333333333),srs::spar::lat_0<>(44.78333333333333),srs::spar::lon_0<>(-87),srs::spar::x_0<>(8000000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3590) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.08333333333334),srs::spar::lat_2<>(45.48333333333333),srs::spar::lat_0<>(44.78333333333333),srs::spar::lon_0<>(-87),srs::spar::x_0<>(7999999.999968001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3591) srs::spar::parameters<srs::spar::proj_omerc,srs::spar::lat_0<>,srs::spar::lonc<>,srs::spar::alpha<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_omerc(),srs::spar::lat_0<>(45.30916666666666),srs::spar::lonc<>(-86),srs::spar::alpha<>(337.25556),srs::spar::k<>(0.9996),srs::spar::x_0<>(2546731.496),srs::spar::y_0<>(-4354009.816),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3592) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.66666666666666),srs::spar::lat_2<>(42.1),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(4000000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3593) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.66666666666666),srs::spar::lat_2<>(42.1),srs::spar::lat_0<>(41.5),srs::spar::lon_0<>(-84.36666666666666),srs::spar::x_0<>(3999999.999984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3594) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.05),srs::spar::lat_2<>(45.61666666666667),srs::spar::lat_0<>(45),srs::spar::lon_0<>(-94.25),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3595) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.63333333333333),srs::spar::lat_2<>(47.03333333333333),srs::spar::lat_0<>(46.5),srs::spar::lon_0<>(-93.09999999999999),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3596) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.21666666666667),srs::spar::lat_2<>(43.78333333333333),srs::spar::lat_0<>(43),srs::spar::lon_0<>(-94),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3597) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-88.83333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3598) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-88.83333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3599) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-90.33333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(700000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3600) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(29.5),srs::spar::lon_0<>(-90.33333333333333),srs::spar::k<>(0.99995),srs::spar::x_0<>(699999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3601) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(35.83333333333334),srs::spar::lon_0<>(-92.5),srs::spar::k<>(0.999933333),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3602) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(35.83333333333334),srs::spar::lon_0<>(-90.5),srs::spar::k<>(0.999933333),srs::spar::x_0<>(250000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3603) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(36.16666666666666),srs::spar::lon_0<>(-94.5),srs::spar::k<>(0.999941177),srs::spar::x_0<>(850000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3604) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49),srs::spar::lat_2<>(45),srs::spar::lat_0<>(44.25),srs::spar::lon_0<>(-109.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3605) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49),srs::spar::lat_2<>(45),srs::spar::lat_0<>(44.25),srs::spar::lon_0<>(-109.5),srs::spar::x_0<>(599999.9999976),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3606) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43),srs::spar::lat_2<>(40),srs::spar::lat_0<>(39.83333333333334),srs::spar::lon_0<>(-100),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3607) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-116.6666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(6000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3608) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-116.6666666666667),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(6000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3609) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-115.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000),srs::spar::y_0<>(8000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3610) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-115.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(200000.00001016),srs::spar::y_0<>(8000000.000010163),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3611) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-118.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(800000),srs::spar::y_0<>(4000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3612) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(34.75),srs::spar::lon_0<>(-118.5833333333333),srs::spar::k<>(0.9999),srs::spar::x_0<>(800000.0000101599),srs::spar::y_0<>(3999999.99998984),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3613) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-71.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3614) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-71.66666666666667),srs::spar::k<>(0.999966667),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3615) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3616) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3617) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-106.25),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3618) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-106.25),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3619) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-104.3333333333333),srs::spar::k<>(0.999909091),srs::spar::x_0<>(165000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3620) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-104.3333333333333),srs::spar::k<>(0.999909091),srs::spar::x_0<>(165000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3621) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-107.8333333333333),srs::spar::k<>(0.999916667),srs::spar::x_0<>(830000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3622) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(31),srs::spar::lon_0<>(-107.8333333333333),srs::spar::k<>(0.999916667),srs::spar::x_0<>(830000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3623) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-76.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(250000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3624) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-76.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(249999.9998983998),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3625) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3626) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(38.83333333333334),srs::spar::lon_0<>(-74.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(150000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3627) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.03333333333333),srs::spar::lat_2<>(40.66666666666666),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-74),srs::spar::x_0<>(300000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3628) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.03333333333333),srs::spar::lat_2<>(40.66666666666666),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-74),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3629) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-78.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(350000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3630) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40),srs::spar::lon_0<>(-78.58333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(350000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3631) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.16666666666666),srs::spar::lat_2<>(34.33333333333334),srs::spar::lat_0<>(33.75),srs::spar::lon_0<>(-79),srs::spar::x_0<>(609601.22),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3632) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.16666666666666),srs::spar::lat_2<>(34.33333333333334),srs::spar::lat_0<>(33.75),srs::spar::lon_0<>(-79),srs::spar::x_0<>(609601.2192024384),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3633) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.73333333333333),srs::spar::lat_2<>(47.43333333333333),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3634) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.73333333333333),srs::spar::lat_2<>(47.43333333333333),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(599999.9999976),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3635) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.48333333333333),srs::spar::lat_2<>(46.18333333333333),srs::spar::lat_0<>(45.66666666666666),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3636) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.48333333333333),srs::spar::lat_2<>(46.18333333333333),srs::spar::lat_0<>(45.66666666666666),srs::spar::lon_0<>(-100.5),srs::spar::x_0<>(599999.9999976),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3637) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.7),srs::spar::lat_2<>(40.43333333333333),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3638) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.03333333333333),srs::spar::lat_2<>(38.73333333333333),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3639) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.76666666666667),srs::spar::lat_2<>(35.56666666666667),srs::spar::lat_0<>(35),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3640) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.76666666666667),srs::spar::lat_2<>(35.56666666666667),srs::spar::lat_0<>(35),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3641) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.23333333333333),srs::spar::lat_2<>(33.93333333333333),srs::spar::lat_0<>(33.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3642) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(35.23333333333333),srs::spar::lat_2<>(33.93333333333333),srs::spar::lat_0<>(33.33333333333334),srs::spar::lon_0<>(-98),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3643) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43),srs::spar::lat_2<>(45.5),srs::spar::lat_0<>(41.75),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(400000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3644) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43),srs::spar::lat_2<>(45.5),srs::spar::lat_0<>(41.75),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(399999.9999984),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3645) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46),srs::spar::lat_2<>(44.33333333333334),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3646) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46),srs::spar::lat_2<>(44.33333333333334),srs::spar::lat_0<>(43.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(2500000.0001424),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3647) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44),srs::spar::lat_2<>(42.33333333333334),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(1500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3648) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44),srs::spar::lat_2<>(42.33333333333334),srs::spar::lat_0<>(41.66666666666666),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(1500000.0001464),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3649) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.95),srs::spar::lat_2<>(40.88333333333333),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3650) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.95),srs::spar::lat_2<>(40.88333333333333),srs::spar::lat_0<>(40.16666666666666),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3651) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.96666666666667),srs::spar::lat_2<>(39.93333333333333),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3652) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.96666666666667),srs::spar::lat_2<>(39.93333333333333),srs::spar::lat_0<>(39.33333333333334),srs::spar::lon_0<>(-77.75),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3653) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.08333333333334),srs::spar::lon_0<>(-71.5),srs::spar::k<>(0.99999375),srs::spar::x_0<>(100000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3654) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(41.08333333333334),srs::spar::lon_0<>(-71.5),srs::spar::k<>(0.99999375),srs::spar::x_0<>(99999.99998983997),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3655) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.83333333333334),srs::spar::lat_2<>(32.5),srs::spar::lat_0<>(31.83333333333333),srs::spar::lon_0<>(-81),srs::spar::x_0<>(609600),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3656) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(34.83333333333334),srs::spar::lat_2<>(32.5),srs::spar::lat_0<>(31.83333333333333),srs::spar::lon_0<>(-81),srs::spar::x_0<>(609600),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3657) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.68333333333333),srs::spar::lat_2<>(44.41666666666666),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-100),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3658) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.68333333333333),srs::spar::lat_2<>(44.41666666666666),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-100),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3659) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.4),srs::spar::lat_2<>(42.83333333333334),srs::spar::lat_0<>(42.33333333333334),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3660) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.4),srs::spar::lat_2<>(42.83333333333334),srs::spar::lat_0<>(42.33333333333334),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3661) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.41666666666666),srs::spar::lat_2<>(35.25),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-86),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3662) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.41666666666666),srs::spar::lat_2<>(35.25),srs::spar::lat_0<>(34.33333333333334),srs::spar::lon_0<>(-86),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3663) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(31.88333333333333),srs::spar::lat_2<>(30.11666666666667),srs::spar::lat_0<>(29.66666666666667),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(700000),srs::spar::y_0<>(3000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3664) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(31.88333333333333),srs::spar::lat_2<>(30.11666666666667),srs::spar::lat_0<>(29.66666666666667),srs::spar::lon_0<>(-100.3333333333333),srs::spar::x_0<>(699999.9998983998),srs::spar::y_0<>(3000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3665) srs::spar::parameters<srs::spar::proj_aea,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_aea(),srs::spar::lat_1<>(27.5),srs::spar::lat_2<>(35),srs::spar::lat_0<>(18),srs::spar::lon_0<>(-100),srs::spar::x_0<>(1500000),srs::spar::y_0<>(6000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3666) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.5),srs::spar::lat_2<>(35),srs::spar::lat_0<>(18),srs::spar::lon_0<>(-100),srs::spar::x_0<>(1500000),srs::spar::y_0<>(5000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3667) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.18333333333333),srs::spar::lat_2<>(34.65),srs::spar::lat_0<>(34),srs::spar::lon_0<>(-101.5),srs::spar::x_0<>(200000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3668) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(36.18333333333333),srs::spar::lat_2<>(34.65),srs::spar::lat_0<>(34),srs::spar::lon_0<>(-101.5),srs::spar::x_0<>(200000.0001016002),srs::spar::y_0<>(999999.9998983998),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3669) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.96666666666667),srs::spar::lat_2<>(32.13333333333333),srs::spar::lat_0<>(31.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(2000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3670) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(33.96666666666667),srs::spar::lat_2<>(32.13333333333333),srs::spar::lat_0<>(31.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(2000000.0001016),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3671) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.83333333333333),srs::spar::lat_2<>(26.16666666666667),srs::spar::lat_0<>(25.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(300000),srs::spar::y_0<>(5000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3672) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(27.83333333333333),srs::spar::lat_2<>(26.16666666666667),srs::spar::lat_0<>(25.66666666666667),srs::spar::lon_0<>(-98.5),srs::spar::x_0<>(300000.0000000001),srs::spar::y_0<>(5000000.0001016),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3673) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.28333333333333),srs::spar::lat_2<>(28.38333333333333),srs::spar::lat_0<>(27.83333333333333),srs::spar::lon_0<>(-99),srs::spar::x_0<>(600000),srs::spar::y_0<>(4000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3674) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(30.28333333333333),srs::spar::lat_2<>(28.38333333333333),srs::spar::lat_0<>(27.83333333333333),srs::spar::lon_0<>(-99),srs::spar::x_0<>(600000),srs::spar::y_0<>(3999999.9998984),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3675) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.65),srs::spar::lat_2<>(39.01666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(2000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3676) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.65),srs::spar::lat_2<>(39.01666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0001504),srs::spar::y_0<>(1999999.999992),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3677) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.65),srs::spar::lat_2<>(39.01666666666667),srs::spar::lat_0<>(38.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(2000000.00001016),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3678) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.71666666666667),srs::spar::lat_0<>(40.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3679) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.71666666666667),srs::spar::lat_0<>(40.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0001504),srs::spar::y_0<>(999999.9999960001),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3680) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.78333333333333),srs::spar::lat_2<>(40.71666666666667),srs::spar::lat_0<>(40.33333333333334),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(999999.9999898402),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3681) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.35),srs::spar::lat_2<>(37.21666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(3000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3682) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.35),srs::spar::lat_2<>(37.21666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.0001504),srs::spar::y_0<>(2999999.999988),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3683) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.35),srs::spar::lat_2<>(37.21666666666667),srs::spar::lat_0<>(36.66666666666666),srs::spar::lon_0<>(-111.5),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(3000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3684) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(42.5),srs::spar::lon_0<>(-72.5),srs::spar::k<>(0.999964286),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3685) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.2),srs::spar::lat_2<>(38.03333333333333),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000),srs::spar::y_0<>(2000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3686) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(39.2),srs::spar::lat_2<>(38.03333333333333),srs::spar::lat_0<>(37.66666666666666),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000.0001016),srs::spar::y_0<>(2000000.0001016),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3687) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(36.76666666666667),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000),srs::spar::y_0<>(1000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3688) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(37.96666666666667),srs::spar::lat_2<>(36.76666666666667),srs::spar::lat_0<>(36.33333333333334),srs::spar::lon_0<>(-78.5),srs::spar::x_0<>(3500000.0001016),srs::spar::y_0<>(999999.9998983998),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3689) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.73333333333333),srs::spar::lat_2<>(47.5),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-120.8333333333333),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3690) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.73333333333333),srs::spar::lat_2<>(47.5),srs::spar::lat_0<>(47),srs::spar::lon_0<>(-120.8333333333333),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3691) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.33333333333334),srs::spar::lat_2<>(45.83333333333334),srs::spar::lat_0<>(45.33333333333334),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3692) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.33333333333334),srs::spar::lat_2<>(45.83333333333334),srs::spar::lat_0<>(45.33333333333334),srs::spar::lon_0<>(-120.5),srs::spar::x_0<>(500000.0001016001),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3693) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.25),srs::spar::lat_2<>(39),srs::spar::lat_0<>(38.5),srs::spar::lon_0<>(-79.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3694) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(38.88333333333333),srs::spar::lat_2<>(37.48333333333333),srs::spar::lat_0<>(37),srs::spar::lon_0<>(-81),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3695) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.5),srs::spar::lat_2<>(44.25),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3696) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.5),srs::spar::lat_2<>(44.25),srs::spar::lat_0<>(43.83333333333334),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3697) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46.76666666666667),srs::spar::lat_2<>(45.56666666666667),srs::spar::lat_0<>(45.16666666666666),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3698) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46.76666666666667),srs::spar::lat_2<>(45.56666666666667),srs::spar::lat_0<>(45.16666666666666),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3699) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.06666666666667),srs::spar::lat_2<>(42.73333333333333),srs::spar::lat_0<>(42),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3700) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.06666666666667),srs::spar::lat_2<>(42.73333333333333),srs::spar::lat_0<>(42),srs::spar::lon_0<>(-90),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3701) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-90),srs::spar::k<>(0.9996),srs::spar::x_0<>(520000),srs::spar::y_0<>(-4480000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3702) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-105.1666666666667),srs::spar::k<>(0.9999375),srs::spar::x_0<>(200000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3703) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-107.3333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(400000),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3704) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-108.75),srs::spar::k<>(0.9999375),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3705) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-110.0833333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(800000),srs::spar::y_0<>(100000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3706) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<59>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<59>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3707) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<60>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<60>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3708) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<1>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<1>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3709) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<2>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<2>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3710) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<3>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<3>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3711) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<4>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<4>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3712) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<5>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<5>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3713) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<6>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<6>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3714) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<7>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<7>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3715) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<8>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<8>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3716) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<9>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<9>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3717) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<10>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<10>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3718) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<11>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<11>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3719) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<12>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<12>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3720) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<13>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<13>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3721) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<14>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<14>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3722) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<15>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<15>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3723) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<16>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<16>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3724) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<17>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<17>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3725) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<18>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<18>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3726) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<19>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<19>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3727) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_intl,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-21.11666666666667),srs::spar::lon_0<>(55.53333333333333),srs::spar::k<>(1),srs::spar::x_0<>(160000),srs::spar::y_0<>(50000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3728) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.7),srs::spar::lat_2<>(40.43333333333333),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3729) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.03333333333333),srs::spar::lat_2<>(38.73333333333333),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3730) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-105.1666666666667),srs::spar::k<>(0.9999375),srs::spar::x_0<>(200000.00001016),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3731) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-107.3333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(99999.99998983997),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3732) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-108.75),srs::spar::k<>(0.9999375),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3733) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-110.0833333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(800000.0000101599),srs::spar::y_0<>(99999.99998983997),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3734) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.7),srs::spar::lat_2<>(40.43333333333333),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3735) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.03333333333333),srs::spar::lat_2<>(38.73333333333333),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3736) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-105.1666666666667),srs::spar::k<>(0.9999375),srs::spar::x_0<>(200000.00001016),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3737) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-107.3333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(99999.99998983997),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3738) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-108.75),srs::spar::k<>(0.9999375),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3739) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-110.0833333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(800000.0000101599),srs::spar::y_0<>(99999.99998983997),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3740) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<10>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3741) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<11>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3742) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<12>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3743) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<13>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3744) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<14>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3745) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<15>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3746) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<16>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3747) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<17>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3748) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<18>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3749) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<19>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3750) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<4>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3751) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<5>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3752) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::lat_ts<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(100),srs::spar::lat_ts<>(-41),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3753) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.7),srs::spar::lat_2<>(40.43333333333333),srs::spar::lat_0<>(39.66666666666666),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3754) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(40.03333333333333),srs::spar::lat_2<>(38.73333333333333),srs::spar::lat_0<>(38),srs::spar::lon_0<>(-82.5),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3755) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-105.1666666666667),srs::spar::k<>(0.9999375),srs::spar::x_0<>(200000.00001016),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3756) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-107.3333333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(399999.99998984),srs::spar::y_0<>(99999.99998983997),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3757) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-108.75),srs::spar::k<>(0.9999375),srs::spar::x_0<>(600000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3758) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(40.5),srs::spar::lon_0<>(-110.0833333333333),srs::spar::k<>(0.9999375),srs::spar::x_0<>(800000.0000101599),srs::spar::y_0<>(99999.99998983997),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3759) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.16666666666667),srs::spar::lon_0<>(-158),srs::spar::k<>(0.99999),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::datum_nad83(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3760) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(21.16666666666667),srs::spar::lon_0<>(-158),srs::spar::k<>(0.99999),srs::spar::x_0<>(500000.00001016),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3761) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<22>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3762) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::datum_wgs84,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(-54),srs::spar::lat_2<>(-54.75),srs::spar::lat_0<>(-55),srs::spar::lon_0<>(-37),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3763) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(39.66825833333333),srs::spar::lon_0<>(-8.133108333333334),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3764) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-44),srs::spar::lon_0<>(-176.5),srs::spar::k<>(1),srs::spar::x_0<>(400000),srs::spar::y_0<>(800000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3765) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(16.5),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3766) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.91666666666666),srs::spar::lat_2<>(43.08333333333334),srs::spar::lat_0<>(0),srs::spar::lon_0<>(16.5),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3767) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<33>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<33>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3768) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<34>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<34>(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3769) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_clrk66,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3770) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(32),srs::spar::lon_0<>(-64.75),srs::spar::k<>(1),srs::spar::x_0<>(550000),srs::spar::y_0<>(100000),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3771) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-111),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3772) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-114),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3773) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-117),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3774) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-120),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3775) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-111),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3776) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-114),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3777) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-117),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3778) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-120),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3779) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-111),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3780) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-114),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3781) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-117),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3782) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-120),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3783) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(-25.06855261111111),srs::spar::lon_0<>(-130.1129671111111),srs::spar::k<>(1),srs::spar::x_0<>(14200),srs::spar::y_0<>(15500),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3784) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<9>,srs::spar::south,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<9>(),srs::spar::south(),srs::spar::ellps_intl(),srs::spar::towgs84<>(185,165,42,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3785) srs::spar::parameters<srs::spar::proj_merc,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_merc(),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6378137),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3786) srs::spar::parameters<srs::spar::proj_eqc,srs::spar::lat_ts<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_eqc(),srs::spar::lat_ts<>(0),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6371007)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3787) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_bessel,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(-5000000),srs::spar::ellps_bessel(),srs::spar::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3788) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(166),srs::spar::k<>(1),srs::spar::x_0<>(3500000),srs::spar::y_0<>(10000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3789) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(169),srs::spar::k<>(1),srs::spar::x_0<>(3500000),srs::spar::y_0<>(10000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3790) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(179),srs::spar::k<>(1),srs::spar::x_0<>(3500000),srs::spar::y_0<>(10000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3791) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-178),srs::spar::k<>(1),srs::spar::x_0<>(3500000),srs::spar::y_0<>(10000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3793) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-176.5),srs::spar::k<>(1),srs::spar::x_0<>(3500000),srs::spar::y_0<>(10000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3794) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(15),srs::spar::k<>(0.9999),srs::spar::x_0<>(500000),srs::spar::y_0<>(-5000000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3795) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(23),srs::spar::lat_2<>(21.7),srs::spar::lat_0<>(22.35),srs::spar::lon_0<>(-81),srs::spar::x_0<>(500000),srs::spar::y_0<>(280296.016)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3796) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(21.3),srs::spar::lat_2<>(20.13333333333333),srs::spar::lat_0<>(20.71666666666667),srs::spar::lon_0<>(-76.83333333333333),srs::spar::x_0<>(500000),srs::spar::y_0<>(229126.939)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3797) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(50),srs::spar::lat_2<>(46),srs::spar::lat_0<>(44),srs::spar::lon_0<>(-70),srs::spar::x_0<>(800000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3798) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(50),srs::spar::lat_2<>(46),srs::spar::lat_0<>(44),srs::spar::lon_0<>(-70),srs::spar::x_0<>(800000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3799) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(50),srs::spar::lat_2<>(46),srs::spar::lat_0<>(44),srs::spar::lon_0<>(-70),srs::spar::x_0<>(800000),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3800) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::datum_nad27,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-120),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3801) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::datum_nad83,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-120),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3802) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(-120),srs::spar::k<>(0.9999),srs::spar::x_0<>(0),srs::spar::y_0<>(0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3812)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3814)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3815)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3816)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3819) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_bessel(),srs::spar::towgs84<>(595.48,121.69,515.35,4.115,2.9383,-0.853,-0.7029504596901044)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3821) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_aust_sa,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3822)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3823) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3824) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3825)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3826)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3827)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3828)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3829)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3832)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3833)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3834)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3835)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3836)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3837)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3838)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3839)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3840)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3841)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3842)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3843)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3844)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3845)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3846)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3847)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3848)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3849)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3850)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3920) srs::spar::parameters<srs::spar::proj_utm,srs::spar::zone<20>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_utm(),srs::spar::zone<20>(),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(11,72,-101,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3942) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(41.25),srs::spar::lat_2<>(42.75),srs::spar::lat_0<>(42),srs::spar::lon_0<>(3),srs::spar::x_0<>(1700000),srs::spar::y_0<>(1200000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3943) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(42.25),srs::spar::lat_2<>(43.75),srs::spar::lat_0<>(43),srs::spar::lon_0<>(3),srs::spar::x_0<>(1700000),srs::spar::y_0<>(2200000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3944) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(43.25),srs::spar::lat_2<>(44.75),srs::spar::lat_0<>(44),srs::spar::lon_0<>(3),srs::spar::x_0<>(1700000),srs::spar::y_0<>(3200000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3945) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(44.25),srs::spar::lat_2<>(45.75),srs::spar::lat_0<>(45),srs::spar::lon_0<>(3),srs::spar::x_0<>(1700000),srs::spar::y_0<>(4200000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3946) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(45.25),srs::spar::lat_2<>(46.75),srs::spar::lat_0<>(46),srs::spar::lon_0<>(3),srs::spar::x_0<>(1700000),srs::spar::y_0<>(5200000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3947) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(46.25),srs::spar::lat_2<>(47.75),srs::spar::lat_0<>(47),srs::spar::lon_0<>(3),srs::spar::x_0<>(1700000),srs::spar::y_0<>(6200000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3948) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(47.25),srs::spar::lat_2<>(48.75),srs::spar::lat_0<>(48),srs::spar::lon_0<>(3),srs::spar::x_0<>(1700000),srs::spar::y_0<>(7200000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3949) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(48.25),srs::spar::lat_2<>(49.75),srs::spar::lat_0<>(49),srs::spar::lon_0<>(3),srs::spar::x_0<>(1700000),srs::spar::y_0<>(8200000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3950) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(49.25),srs::spar::lat_2<>(50.75),srs::spar::lat_0<>(50),srs::spar::lon_0<>(3),srs::spar::x_0<>(1700000),srs::spar::y_0<>(9200000),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3991) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(18.43333333333333),srs::spar::lat_2<>(18.03333333333333),srs::spar::lat_0<>(17.83333333333333),srs::spar::lon_0<>(-66.43333333333334),srs::spar::x_0<>(152400.3048006096),srs::spar::y_0<>(0),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(11,72,-101,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3992) srs::spar::parameters<srs::spar::proj_lcc,srs::spar::lat_1<>,srs::spar::lat_2<>,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::to_meter<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_lcc(),srs::spar::lat_1<>(18.43333333333333),srs::spar::lat_2<>(18.03333333333333),srs::spar::lat_0<>(17.83333333333333),srs::spar::lon_0<>(-66.43333333333334),srs::spar::x_0<>(152400.3048006096),srs::spar::y_0<>(30480.06096012192),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(11,72,-101,0,0,0,0),srs::spar::to_meter<>(0.3048006096012192)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3993)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3994)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3995)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3996)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 3997)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4001) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_airy,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4002) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377340.189),srs::spar::b<>(6356034.447938534)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4003) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_aust_sa,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4004) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4005) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377492.018),srs::spar::b<>(6356173.508712696)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4006) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bess_nam,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4007) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378293.645208759),srs::spar::b<>(6356617.987679838)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4008) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4009) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378450.047548896),srs::spar::b<>(6356826.621488444)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4010) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378300.789),srs::spar::b<>(6356566.435)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4011) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356515)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4012) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4013) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378249.145),srs::spar::b<>(6356514.966398753)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4014) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356514.996941779)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4015) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377276.345),srs::spar::b<>(6356075.41314024)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4016) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_evrstss,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4018) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377304.063),srs::spar::b<>(6356103.038993155)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4019) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4020) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_helmert,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4021) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378160),srs::spar::b<>(6356774.50408554)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4022) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4024) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_krass,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4025) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_wgs66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4027) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6376523),srs::spar::b<>(6355862.933255573)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4028) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378298.3),srs::spar::b<>(6356657.142669561)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4029) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378300),srs::spar::b<>(6356751.689189189)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4030) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_wgs84,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4031) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_wgs84,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4032) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378136.2),srs::spar::b<>(6356751.516927429)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4033) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378136.3),srs::spar::b<>(6356751.616592146)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4034) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378249.144808011),srs::spar::b<>(6356514.966204134)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4035) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(6371000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4036) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs67,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4041) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378135),srs::spar::b<>(6356750.304921594)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4042) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377299.36559538),srs::spar::b<>(6356098.359005157)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4043) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_wgs72,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4044) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377301.243),srs::spar::b<>(6356100.230165384)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4045) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377299.151),srs::spar::b<>(6356098.145120132)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4047) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(6371007)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4052) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(6370997)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4053) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(6371228)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4054) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378273),srs::spar::b<>(6356889.449)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4055) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(6378137),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4120) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4121) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(-199.87,74.79,246.62,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4122) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378135),srs::spar::b<>(6356750.304921594)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4123) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4124) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4125) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_bessel(),srs::spar::towgs84<>(-404.78,685.68,45.47,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4126) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4127) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4128) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4129) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4130) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,-0,-0,-0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4131) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377276.345),srs::spar::b<>(6356075.41314024)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4132) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4133) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4134) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4135) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4136) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4137) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4138) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4139) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk66,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_clrk66(),srs::spar::towgs84<>(11,72,-101,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4140) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4141) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(-48,55,52,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4142) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-125,53,467,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4143) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_clrk80,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_clrk80(),srs::spar::towgs84<>(-124.76,53,466.79,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4144) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377276.345),srs::spar::b<>(6356075.41314024)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4145) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377301.243),srs::spar::b<>(6356100.230165384)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4146) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6377299.151),srs::spar::b<>(6356098.145120132),srs::spar::towgs84<>(295,736,257,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4147) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_krass,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_krass(),srs::spar::towgs84<>(-17.51,-108.32,-62.39,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4148) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_wgs84,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_wgs84(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4149) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_bessel(),srs::spar::towgs84<>(674.374,15.056,405.346,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4150) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_bessel(),srs::spar::towgs84<>(674.374,15.056,405.346,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4151) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_grs80(),srs::spar::towgs84<>(0,0,0,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4152) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_grs80,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4153) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::ellps_intl(),srs::spar::towgs84<>(-133.63,-157.5,-158.62,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4154) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4155) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::towgs84<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378249.2),srs::spar::b<>(6356515),srs::spar::towgs84<>(-83,37,124,0,0,0,0)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4156) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_bessel,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4157) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378293.645208759),srs::spar::b<>(6356617.987679838)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4158) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() () BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(epsg, 4159) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::ellps_intl,srs::spar::no_de