/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.tools.OperatingSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.InputContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class ControllerAction
extends ResourceAction {
    private final Object controller;
    private final Method controllerMethod;
    private final Object[] parameters;
    private static final String[] LATIN_AND_SUPPORTED_LOCALES = new String[]{"cs", "da", "de", "en", "es", "et", "fi", "fr", "hr", "hu", "it", "ja", "lt", "lv", "nl", "no", "pl", "pt", "ro", "sk", "sl", "sv", "tr", "vi"};
    private static KeyStroke previousActionAccelerator;
    private static Timer doubleEventsTimer;

    public ControllerAction(UserPreferences userPreferences, Class<?> clazz, String string, Object object, String string2, Object ... objectArray) throws NoSuchMethodException {
        this(userPreferences, clazz, string, false, object, string2, objectArray);
    }

    public ControllerAction(UserPreferences userPreferences, Class<?> clazz, String string, boolean bl, Object object, String string2, Object ... objectArray) throws NoSuchMethodException {
        Method method;
        block5: {
            super(userPreferences, clazz, string, bl);
            this.controller = object;
            this.parameters = objectArray;
            Class[] classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
            method = null;
            try {
                method = object.getClass().getMethod(string2, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                for (Method method2 : object.getClass().getMethods()) {
                    int n;
                    Class<?>[] classArray2;
                    if (!method2.getName().equals(string2) || (classArray2 = method2.getParameterTypes()).length != classArray.length) continue;
                    for (n = 0; n < classArray2.length && classArray2[n].isAssignableFrom(classArray[n]); ++n) {
                    }
                    if (n != classArray2.length) continue;
                    method = method2;
                    break;
                }
                if (method != null) break block5;
                throw noSuchMethodException;
            }
        }
        this.controllerMethod = method;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Locale locale;
            if (OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionBetween("1.7", "9") && (locale = InputContext.getInstance().getLocale()) != null && Arrays.binarySearch(LATIN_AND_SUPPORTED_LOCALES, locale.getLanguage()) < 0) {
                if (!this.isInvokedFromMenuItem()) {
                    previousActionAccelerator = (KeyStroke)this.getValue("AcceleratorKey");
                    if (doubleEventsTimer == null) {
                        doubleEventsTimer = new Timer(1000, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                previousActionAccelerator = null;
                                doubleEventsTimer.stop();
                            }
                        });
                    }
                    doubleEventsTimer.restart();
                } else if (previousActionAccelerator != null && previousActionAccelerator.equals(this.getValue("AcceleratorKey"))) {
                    previousActionAccelerator = null;
                    return;
                }
            }
            this.controllerMethod.invoke(this.controller, this.parameters);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    private boolean isInvokedFromMenuItem() {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!"com.apple.laf.ScreenMenuItem".equals(stackTraceElement.getClassName()) || !"actionPerformed".equals(stackTraceElement.getMethodName())) continue;
            return true;
        }
        return false;
    }
}

