#pragma once

// @generated by aten/src/ATen/gen.py

#include <ATen/CPUTypeDefault.h>
#include <ATen/Context.h>
#include <ATen/CheckGenerator.h>



#ifdef _MSC_VER
#ifdef Type
#undef Type
#endif
#endif

namespace at {

struct MkldnnCPUType final : public CPUTypeDefault {
  explicit MkldnnCPUType();
  virtual Backend backend() const override;
  virtual const char * toString() const override;
  virtual TypeID ID() const override;

  // example
  // virtual Tensor * add(Tensor & a, Tensor & b) override;
  Tensor add(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor & add_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor & add_out(Tensor & out, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor mkldnn_linear(const Tensor & input, const Tensor & weight, const Tensor & bias) const override;
  Tensor mkldnn_max_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, IntArrayRef dilation, bool ceil_mode) const override;
  std::tuple<Tensor,Tensor,Tensor> native_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const override;
  Tensor mkldnn_reshape(const Tensor & self, IntArrayRef shape) const override;
  Tensor relu(const Tensor & self) const override;
  Tensor & relu_(Tensor & self) const override;
  Tensor clone(const Tensor & self) const override;
  Tensor to_dense(const Tensor & self) const override;
  Tensor mkldnn_reorder_conv2d_weight(const Tensor & self, IntArrayRef padding, IntArrayRef stride, IntArrayRef dilation, int64_t groups) const override;
  Tensor & avg_pool2d_out(Tensor & out, const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor avg_pool2d(const Tensor & self, IntArrayRef kernel_size, IntArrayRef stride, IntArrayRef padding, bool ceil_mode, bool count_include_pad) const override;

 private:
  ScalarType infer_scalar_type(const Tensor & t) const {
    return t.scalar_type();
  }
  ScalarType infer_scalar_type(const TensorList & tl) const {
    AT_CHECK(tl.size() > 0, "expected a non-empty list of Tensors");
    return tl[0].scalar_type();
  }
};

} // namespace at
