/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolWindowManager {
    public abstract boolean canShowNotification(@NotNull String var1);

    public static ToolWindowManager getInstance(@NotNull Project project) {
        if (project == null) {
            ToolWindowManager.$$$reportNull$$$0(0);
        }
        return project.getComponent(ToolWindowManager.class);
    }

    @Deprecated
    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, @NotNull JComponent var2, @NotNull ToolWindowAnchor var3);

    @Deprecated
    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, @NotNull JComponent var2, @NotNull ToolWindowAnchor var3, @NotNull Disposable var4);

    @Deprecated
    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, @NotNull JComponent var2, @NotNull ToolWindowAnchor var3, @NotNull Disposable var4, boolean var5);

    @Deprecated
    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, @NotNull JComponent var2, @NotNull ToolWindowAnchor var3, @NotNull Disposable var4, boolean var5, boolean var6);

    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, boolean var2, @NotNull ToolWindowAnchor var3);

    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, boolean var2, @NotNull ToolWindowAnchor var3, boolean var4);

    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, boolean var2, @NotNull ToolWindowAnchor var3, @NotNull Disposable var4, boolean var5);

    @NotNull
    public abstract ToolWindow registerToolWindow(@NotNull String var1, boolean var2, @NotNull ToolWindowAnchor var3, @NotNull Disposable var4, boolean var5, boolean var6);

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable) {
        if (id == null) {
            ToolWindowManager.$$$reportNull$$$0(1);
        }
        if (anchor == null) {
            ToolWindowManager.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            ToolWindowManager.$$$reportNull$$$0(3);
        }
        ToolWindow toolWindow = this.registerToolWindow(id, canCloseContent, anchor, parentDisposable, false);
        if (toolWindow == null) {
            ToolWindowManager.$$$reportNull$$$0(4);
        }
        return toolWindow;
    }

    public abstract void unregisterToolWindow(@NotNull String var1);

    public abstract void activateEditorComponent();

    public abstract boolean isEditorComponentActive();

    @NotNull
    public abstract String[] getToolWindowIds();

    @Nullable
    public abstract String getActiveToolWindowId();

    @Nullable
    public static ToolWindow getActiveToolWindow() {
        ToolWindowManager managerInstance;
        Project project;
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project2 = project = frame == null ? ProjectManager.getInstance().getDefaultProject() : frame.getProject();
        if (project != null && (managerInstance = ToolWindowManager.getInstance(project)) != null) {
            return managerInstance.getToolWindow(ToolWindowManager.getActiveId());
        }
        return null;
    }

    @Nullable
    public static String getActiveId() {
        Project project;
        IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (lastFocusedFrame != null && (project = lastFocusedFrame.getProject()) != null) {
            ToolWindowManager instance = ToolWindowManager.getInstance(project);
            return instance == null ? "" : instance.getActiveToolWindowId();
        }
        return "";
    }

    public abstract ToolWindow getToolWindow(@Nullable String var1);

    public abstract void invokeLater(@NotNull Runnable var1);

    @NotNull
    public abstract IdeFocusManager getFocusManager();

    public abstract void notifyByBalloon(@NotNull String var1, @NotNull MessageType var2, @NotNull String var3);

    public abstract void notifyByBalloon(@NotNull String var1, @NotNull MessageType var2, @NotNull String var3, @Nullable Icon var4, @Nullable HyperlinkListener var5);

    @Nullable
    public abstract Balloon getToolWindowBalloon(String var1);

    public abstract boolean isMaximized(@NotNull ToolWindow var1);

    public abstract void setMaximized(@NotNull ToolWindow var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/ToolWindowManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/ToolWindowManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "registerToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerToolWindow";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

