/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import gnu.trove.TIntHashSet;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Selection {
    @NotNull
    private final VcsLogGraphTable myTable;
    @NotNull
    private final TIntHashSet mySelectedCommits;
    @Nullable
    private final Integer myVisibleSelectedCommit;
    @Nullable
    private final Integer myDelta;
    private final boolean myIsOnTop;

    Selection(@NotNull VcsLogGraphTable table) {
        if (table == null) {
            Selection.$$$reportNull$$$0(0);
        }
        this.myTable = table;
        List selectedRows = ContainerUtil.sorted((Collection)Ints.asList((int[])this.myTable.getSelectedRows()));
        Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this.myTable));
        this.myIsOnTop = (Integer)visibleRows.first - 1 == 0;
        VisibleGraph<Integer> graph2 = this.myTable.getVisibleGraph();
        this.mySelectedCommits = new TIntHashSet();
        Integer visibleSelectedCommit = null;
        Integer delta = null;
        Iterator iterator = selectedRows.iterator();
        while (iterator.hasNext()) {
            int row2 = (Integer)iterator.next();
            if (row2 >= graph2.getVisibleCommitCount()) continue;
            Integer commit = (Integer)graph2.getRowInfo(row2).getCommit();
            this.mySelectedCommits.add(commit.intValue());
            if ((Integer)visibleRows.first - 1 > row2 || row2 > (Integer)visibleRows.second || visibleSelectedCommit != null) continue;
            visibleSelectedCommit = commit;
            delta = this.myTable.getCellRect((int)row2, (int)0, (boolean)false).y - this.myTable.getVisibleRect().y;
        }
        if (visibleSelectedCommit == null && (Integer)visibleRows.first - 1 >= 0) {
            visibleSelectedCommit = (Integer)graph2.getRowInfo((Integer)visibleRows.first - 1).getCommit();
            delta = this.myTable.getCellRect((int)(((Integer)visibleRows.first).intValue() - 1), (int)0, (boolean)false).y - this.myTable.getVisibleRect().y;
        }
        this.myVisibleSelectedCommit = visibleSelectedCommit;
        this.myDelta = delta;
    }

    public void restore(@NotNull VisibleGraph<Integer> newVisibleGraph, boolean scrollToSelection, boolean permGraphChanged) {
        if (newVisibleGraph == null) {
            Selection.$$$reportNull$$$0(1);
        }
        Pair<TIntHashSet, Integer> toSelectAndScroll = this.findRowsToSelectAndScroll(this.myTable.getModel(), newVisibleGraph);
        if (!((TIntHashSet)toSelectAndScroll.first).isEmpty()) {
            this.myTable.getSelectionModel().setValueIsAdjusting(true);
            ((TIntHashSet)toSelectAndScroll.first).forEach(row2 -> {
                this.myTable.addRowSelectionInterval(row2, row2);
                return true;
            });
            this.myTable.getSelectionModel().setValueIsAdjusting(false);
        }
        if (scrollToSelection) {
            if (this.myIsOnTop && permGraphChanged) {
                this.scrollToRow(0, 0);
            } else if (toSelectAndScroll.second != null) {
                assert (this.myDelta != null);
                this.scrollToRow((Integer)toSelectAndScroll.second, this.myDelta);
            }
        }
    }

    private void scrollToRow(Integer row2, Integer delta) {
        Rectangle startRect = this.myTable.getCellRect(row2, 0, true);
        this.myTable.scrollRectToVisible(new Rectangle(startRect.x, Math.max(startRect.y - delta, 0), startRect.width, this.myTable.getVisibleRect().height));
    }

    @NotNull
    private Pair<TIntHashSet, Integer> findRowsToSelectAndScroll(@NotNull GraphTableModel model, @NotNull VisibleGraph<Integer> visibleGraph) {
        if (model == null) {
            Selection.$$$reportNull$$$0(2);
        }
        if (visibleGraph == null) {
            Selection.$$$reportNull$$$0(3);
        }
        TIntHashSet rowsToSelect = new TIntHashSet();
        if (model.getRowCount() == 0) {
            Pair pair = Pair.create((Object)rowsToSelect, null);
            if (pair == null) {
                Selection.$$$reportNull$$$0(4);
            }
            return pair;
        }
        Integer rowToScroll = null;
        for (int row2 = 0; row2 < visibleGraph.getVisibleCommitCount() && (rowsToSelect.size() < this.mySelectedCommits.size() || rowToScroll == null); ++row2) {
            int commit = (Integer)visibleGraph.getRowInfo(row2).getCommit();
            if (this.mySelectedCommits.contains(commit)) {
                rowsToSelect.add(row2);
            }
            if (this.myVisibleSelectedCommit == null || this.myVisibleSelectedCommit != commit) continue;
            rowToScroll = row2;
        }
        Pair pair = Pair.create((Object)rowsToSelect, rowToScroll);
        if (pair == null) {
            Selection.$$$reportNull$$$0(5);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVisibleGraph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleGraph";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/Selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/Selection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findRowsToSelectAndScroll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findRowsToSelectAndScroll";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

